/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.internal;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.money.MonetaryAmount;
import javax.money.MonetaryAmountFactory;
import javax.money.MonetaryException;
import javax.money.spi.Bootstrap;
import javax.money.spi.MonetaryAmountFactoryProviderSpi;
import javax.money.spi.MonetaryAmountsSingletonSpi;

public class DefaultMonetaryAmountsSingletonSpi
implements MonetaryAmountsSingletonSpi {
    private final Map<Class<? extends MonetaryAmount>, MonetaryAmountFactoryProviderSpi<?>> factories = new ConcurrentHashMap();
    private Class<? extends MonetaryAmount> configuredDefaultAmountType = this.loadDefaultAmountType();

    public DefaultMonetaryAmountsSingletonSpi() {
        for (MonetaryAmountFactoryProviderSpi f : Bootstrap.getServices(MonetaryAmountFactoryProviderSpi.class)) {
            this.factories.putIfAbsent(f.getAmountType(), f);
        }
    }

    private Class<? extends MonetaryAmount> loadDefaultAmountType() {
        return null;
    }

    public <T extends MonetaryAmount> MonetaryAmountFactory<T> getAmountFactory(Class<T> amountType) {
        MonetaryAmountFactoryProviderSpi f = (MonetaryAmountFactoryProviderSpi)MonetaryAmountFactoryProviderSpi.class.cast(this.factories.get(amountType));
        if (Objects.nonNull(f)) {
            return f.createMonetaryAmountFactory();
        }
        throw new MonetaryException("No matching MonetaryAmountFactory found, type=" + amountType.getName());
    }

    public Set<Class<? extends MonetaryAmount>> getAmountTypes() {
        return this.factories.keySet();
    }

    public Class<? extends MonetaryAmount> getDefaultAmountType() {
        if (Objects.isNull(this.configuredDefaultAmountType)) {
            for (MonetaryAmountFactoryProviderSpi f : Bootstrap.getServices(MonetaryAmountFactoryProviderSpi.class)) {
                if (f.getQueryInclusionPolicy() != MonetaryAmountFactoryProviderSpi.QueryInclusionPolicy.ALWAYS) continue;
                this.configuredDefaultAmountType = f.getAmountType();
                break;
            }
        }
        return Optional.ofNullable(this.configuredDefaultAmountType).orElseThrow(() -> new MonetaryException("No MonetaryAmountFactoryProviderSpi registered."));
    }
}

