/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.utils;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import nonapi.io.github.classgraph.classpath.SystemJarFinder;
import nonapi.io.github.classgraph.utils.LogNode;
import nonapi.io.github.classgraph.utils.VersionFinder;

public class JarUtils {
    private static final String[] UNIX_NON_PATH_SEPARATORS = new String[]{"jar:", "file:", "http://", "https://", "\\:"};
    private static final int[] UNIX_NON_PATH_SEPARATOR_COLON_POSITIONS = new int[UNIX_NON_PATH_SEPARATORS.length];

    public static String[] smartPathSplit(String pathStr) {
        return JarUtils.smartPathSplit(pathStr, File.pathSeparatorChar);
    }

    public static String[] smartPathSplit(String pathStr, char separatorChar) {
        if (pathStr == null || pathStr.isEmpty()) {
            return new String[0];
        }
        if (separatorChar != ':') {
            ArrayList<String> partsFiltered = new ArrayList<String>();
            for (String part : pathStr.split("" + separatorChar)) {
                String partFiltered = part.trim();
                if (partFiltered.isEmpty()) continue;
                partsFiltered.add(partFiltered);
            }
            return partsFiltered.toArray(new String[0]);
        }
        HashSet<Integer> splitPoints = new HashSet<Integer>();
        int i = -1;
        do {
            boolean foundNonPathSeparator = false;
            for (int j = 0; j < UNIX_NON_PATH_SEPARATORS.length; ++j) {
                int startIdx = i - UNIX_NON_PATH_SEPARATOR_COLON_POSITIONS[j];
                if (!pathStr.regionMatches(true, startIdx, UNIX_NON_PATH_SEPARATORS[j], 0, UNIX_NON_PATH_SEPARATORS[j].length()) || startIdx != 0 && pathStr.charAt(startIdx - 1) != ':') continue;
                foundNonPathSeparator = true;
                break;
            }
            if (foundNonPathSeparator) continue;
            splitPoints.add(i);
        } while ((i = pathStr.indexOf(58, i + 1)) >= 0);
        splitPoints.add(pathStr.length());
        ArrayList splitPointsSorted = new ArrayList(splitPoints);
        Collections.sort(splitPointsSorted);
        ArrayList<String> parts = new ArrayList<String>();
        for (int i2 = 1; i2 < splitPointsSorted.size(); ++i2) {
            int idx0 = (Integer)splitPointsSorted.get(i2 - 1);
            int idx1 = (Integer)splitPointsSorted.get(i2);
            String part = pathStr.substring(idx0 + 1, idx1).trim();
            if ((part = part.replaceAll("\\\\:", ":")).isEmpty()) continue;
            parts.add(part);
        }
        return parts.toArray(new String[0]);
    }

    public static ClassLoader createURLClassLoaderFromPathString(String classpathStr) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String pathEltStr : JarUtils.smartPathSplit(classpathStr)) {
            try {
                URL url = new URL(pathEltStr);
                urls.add(url);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new URLClassLoader(urls.toArray(new URL[0]));
    }

    private static void appendPathElt(Object pathElt, StringBuilder buf) {
        if (buf.length() > 0) {
            buf.append(File.pathSeparatorChar);
        }
        String path = File.separatorChar == '\\' ? pathElt.toString() : pathElt.toString().replaceAll(File.pathSeparator, "\\" + File.pathSeparator);
        buf.append(path);
    }

    public static String pathElementsToPathStr(Object ... pathElts) {
        StringBuilder buf = new StringBuilder();
        for (Object pathElt : pathElts) {
            JarUtils.appendPathElt(pathElt, buf);
        }
        return buf.toString();
    }

    public static String pathElementsToPathStr(Iterable<?> pathElts) {
        StringBuilder buf = new StringBuilder();
        for (Object pathElt : pathElts) {
            JarUtils.appendPathElt(pathElt, buf);
        }
        return buf.toString();
    }

    public static String leafName(String path) {
        int bangIdx = path.indexOf("!");
        int endIdx = bangIdx >= 0 ? bangIdx : path.length();
        int leafStartIdx = 1 + (File.separatorChar == '/' ? path.lastIndexOf(47, endIdx) : Math.max(path.lastIndexOf(47, endIdx), path.lastIndexOf(File.separatorChar, endIdx)));
        int sepIdx = path.indexOf("---");
        if (sepIdx >= 0) {
            sepIdx += "---".length();
        }
        leafStartIdx = Math.max(leafStartIdx, sepIdx);
        leafStartIdx = Math.min(leafStartIdx, endIdx);
        return path.substring(leafStartIdx, endIdx);
    }

    public static String classfilePathToClassName(String classfilePath) {
        if (!classfilePath.endsWith(".class")) {
            throw new IllegalArgumentException("Classfile path does not end with \".class\": " + classfilePath);
        }
        return classfilePath.substring(0, classfilePath.length() - 6).replace('/', '.');
    }

    public static String classNameToClassfilePath(String className) {
        return className.replace('.', '/') + ".class";
    }

    public static void logJavaInfo(LogNode log) {
        if (log != null) {
            log.log("Operating system: " + VersionFinder.getProperty("os.name") + " " + VersionFinder.getProperty("os.version") + " " + VersionFinder.getProperty("os.arch"));
            log.log("Java version: " + VersionFinder.getProperty("java.version") + " / " + VersionFinder.getProperty("java.runtime.version") + " (" + VersionFinder.getProperty("java.vendor") + ")");
            log.log("Java home: " + VersionFinder.getProperty("java.home"));
            String jreRtJarPath = SystemJarFinder.getJreRtJarPath();
            if (jreRtJarPath != null) {
                log.log("JRE rt.jar:").log(jreRtJarPath);
            }
        }
    }

    static {
        for (int i = 0; i < UNIX_NON_PATH_SEPARATORS.length; ++i) {
            JarUtils.UNIX_NON_PATH_SEPARATOR_COLON_POSITIONS[i] = UNIX_NON_PATH_SEPARATORS[i].indexOf(58);
            if (UNIX_NON_PATH_SEPARATOR_COLON_POSITIONS[i] >= 0) continue;
            throw new RuntimeException("Could not find ':' in \"" + UNIX_NON_PATH_SEPARATORS[i] + "\"");
        }
    }
}

