/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.services;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.unomi.api.Item;
import org.apache.unomi.api.Metadata;
import org.apache.unomi.api.PartialList;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.query.Query;
import org.apache.unomi.api.services.DefinitionsService;
import org.apache.unomi.lists.UserList;
import org.apache.unomi.persistence.spi.PersistenceService;
import org.apache.unomi.services.UserListService;

public class UserListServiceImpl
implements UserListService {
    private PersistenceService persistenceService;
    private DefinitionsService definitionsService;

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public void setDefinitionsService(DefinitionsService definitionsService) {
        this.definitionsService = definitionsService;
    }

    @Override
    public PartialList<Metadata> getListMetadatas(int offset, int size, String sortBy) {
        PartialList userLists = this.persistenceService.getAllItems(UserList.class, offset, size, sortBy);
        LinkedList<Metadata> metadata = new LinkedList<Metadata>();
        for (UserList definition : userLists.getList()) {
            metadata.add(definition.getMetadata());
        }
        return new PartialList(metadata, userLists.getOffset(), userLists.getPageSize(), userLists.getTotalSize(), userLists.getTotalSizeRelation());
    }

    @Override
    public PartialList<Metadata> getListMetadatas(Query query) {
        if (query.isForceRefresh()) {
            this.persistenceService.refreshIndex(UserList.class, null);
        }
        this.definitionsService.resolveConditionType(query.getCondition());
        PartialList userLists = this.persistenceService.query(query.getCondition(), query.getSortby(), UserList.class, query.getOffset(), query.getLimit());
        LinkedList<Metadata> metadata = new LinkedList<Metadata>();
        for (UserList definition : userLists.getList()) {
            metadata.add(definition.getMetadata());
        }
        return new PartialList(metadata, userLists.getOffset(), userLists.getPageSize(), userLists.getTotalSize(), userLists.getTotalSizeRelation());
    }

    @Override
    public UserList load(String listId) {
        return (UserList)this.persistenceService.load(listId, UserList.class);
    }

    @Override
    public void save(UserList list) {
        this.persistenceService.save((Item)list);
    }

    @Override
    public void delete(String listId) {
        Condition query = new Condition(this.definitionsService.getConditionType("profilePropertyCondition"));
        query.setParameter("propertyName", (Object)"systemProperties.lists");
        query.setParameter("comparisonOperator", (Object)"equals");
        query.setParameter("propertyValue", (Object)listId);
        List profiles = this.persistenceService.query(query, null, Profile.class);
        for (Profile p : profiles) {
            int index;
            Map profileSystemProperties = p.getSystemProperties();
            if (profileSystemProperties == null || profileSystemProperties.get("lists") == null || (index = ((List)profileSystemProperties.get("lists")).indexOf(listId)) == -1) continue;
            ((List)profileSystemProperties.get("lists")).remove(index);
            profileSystemProperties.put("lastUpdated", new Date());
            this.persistenceService.update((Item)p, null, Profile.class, "systemProperties", (Object)profileSystemProperties);
        }
        this.persistenceService.remove(listId, UserList.class);
    }
}

