/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi.repository;

import aQute.bnd.osgi.repository.BaseRepository;
import aQute.bnd.osgi.repository.ResourcesRepository;
import aQute.bnd.osgi.resource.ResourceBuilder;
import aQute.bnd.stream.MapStream;
import aQute.lib.exceptions.Exceptions;
import aQute.lib.memoize.Memoize;
import java.io.File;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public abstract class AbstractIndexingRepository<KEY, FILE>
extends BaseRepository {
    private final Map<KEY, Supplier<? extends Collection<? extends Resource>>> resources = new ConcurrentHashMap<KEY, Supplier<? extends Collection<? extends Resource>>>();
    private volatile Supplier<ResourcesRepository> repository = this.memoize(this::aggregate);

    protected AbstractIndexingRepository() {
    }

    protected <S> Supplier<S> memoize(Supplier<S> supplier) {
        return Memoize.referenceSupplier(supplier, SoftReference::new);
    }

    protected abstract boolean isValid(KEY var1);

    protected abstract BiFunction<ResourceBuilder, FILE, ? extends ResourceBuilder> indexer(KEY var1);

    protected ResourceBuilder fileIndexer(ResourceBuilder rb, File file) {
        if (!file.isFile()) {
            return null;
        }
        try {
            rb.addFile(file, file.toURI());
        }
        catch (Exception e) {
            throw Exceptions.duck(e);
        }
        return rb;
    }

    public void index(KEY key, Collection<FILE> files) {
        this.index(key, () -> files);
    }

    public void index(KEY key, Supplier<? extends Collection<FILE>> files) {
        this.add(key, this.indexer(files, this.indexer(key)));
    }

    protected void add(KEY key, Supplier<? extends Collection<? extends Resource>> supplier) {
        this.resources.put(key, this.memoize(supplier));
        this.repository = this.memoize(this::aggregate);
    }

    protected boolean remove(KEY key) {
        if (this.resources.remove(key) != null | this.resources.keySet().removeIf(p -> !this.isValid(p))) {
            this.repository = this.memoize(this::aggregate);
            return true;
        }
        return false;
    }

    private Supplier<List<Resource>> indexer(Supplier<? extends Collection<FILE>> files, BiFunction<? super ResourceBuilder, FILE, ? extends ResourceBuilder> indexer) {
        Objects.requireNonNull(files);
        Objects.requireNonNull(indexer);
        return () -> ((Collection)files.get()).stream().map(file -> (ResourceBuilder)indexer.apply(new ResourceBuilder(), file)).filter(Objects::nonNull).map(ResourceBuilder::build).collect(Collectors.toList());
    }

    public Map<Requirement, Collection<Capability>> findProviders(Collection<? extends Requirement> requirements) {
        Map<Requirement, Collection<Capability>> result = this.repository.get().findProviders(requirements);
        return result;
    }

    private ResourcesRepository aggregate() {
        ResourcesRepository aggregate = MapStream.of(this.resources).filterKey(this::isValid).values().map(Supplier::get).flatMap(Collection::stream).collect(ResourcesRepository.toResourcesRepository());
        return aggregate;
    }
}

