/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.config;

import java.util.Dictionary;
import java.util.Map;
import java.util.Properties;
import org.apache.karaf.cellar.config.ClusterConfigurationEvent;
import org.apache.karaf.cellar.config.ConfigurationSupport;
import org.apache.karaf.cellar.core.Group;
import org.apache.karaf.cellar.core.control.BasicSwitch;
import org.apache.karaf.cellar.core.control.Switch;
import org.apache.karaf.cellar.core.control.SwitchStatus;
import org.apache.karaf.cellar.core.event.EventHandler;
import org.apache.karaf.cellar.core.event.EventType;
import org.osgi.service.cm.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationEventHandler
extends ConfigurationSupport
implements EventHandler<ClusterConfigurationEvent> {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(ConfigurationEventHandler.class);
    public static final String SWITCH_ID = "org.apache.karaf.cellar.configuration.handler";
    private final Switch eventSwitch = new BasicSwitch("org.apache.karaf.cellar.configuration.handler");

    public void handle(ClusterConfigurationEvent event) {
        if (this.getSwitch().getStatus().equals((Object)SwitchStatus.OFF)) {
            LOGGER.debug("CELLAR CONFIG: {} switch is OFF, cluster event not handled", (Object)SWITCH_ID);
            return;
        }
        if (this.groupManager == null) {
            LOGGER.error("CELLAR CONFIG: retrieved event {} while groupManager is not available yet!", (Object)event);
            return;
        }
        if (!this.groupManager.isLocalGroup(event.getSourceGroup().getName())) {
            LOGGER.debug("CELLAR CONFIG: node is not part of the event cluster group {}", (Object)event.getSourceGroup().getName());
            return;
        }
        if (event.getLocal() != null && event.getLocal().getId().equalsIgnoreCase(this.clusterManager.getNode().getId())) {
            LOGGER.trace("CELLAR CONFIG: cluster event is local (coming from local synchronizer or listener)");
            return;
        }
        Group group = event.getSourceGroup();
        String groupName = group.getName();
        Map clusterConfigurations = this.clusterManager.getMap("org.apache.karaf.cellar.configuration.map." + groupName);
        String pid = event.getId();
        if (this.isAllowed(event.getSourceGroup(), "config", pid, EventType.INBOUND).booleanValue()) {
            Dictionary clusterDictionary = (Dictionary)clusterConfigurations.get(pid);
            try {
                Configuration localConfiguration = this.findLocalConfiguration(pid, clusterDictionary);
                if (event.getType() != null && event.getType() == 2) {
                    if (localConfiguration != null) {
                        this.deleteConfiguration(localConfiguration);
                    }
                } else if (clusterDictionary != null && this.shouldReplicateConfig(clusterDictionary)) {
                    Dictionary localDictionary;
                    if (localConfiguration == null) {
                        localConfiguration = this.createLocalConfiguration(pid, clusterDictionary);
                    }
                    if ((localDictionary = localConfiguration.getProperties()) == null) {
                        localDictionary = new Properties();
                    }
                    if (!this.equals(clusterDictionary, localDictionary = this.filter(localDictionary)) && this.canDistributeConfig(localDictionary)) {
                        Dictionary convertedDictionary = this.convertPropertiesFromCluster(clusterDictionary);
                        localConfiguration.update(convertedDictionary);
                        this.persistConfiguration(localConfiguration, clusterDictionary);
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.error("CELLAR CONFIG: failed to read cluster configuration", (Throwable)ex);
            }
        } else {
            LOGGER.trace("CELLAR CONFIG: configuration PID {} is marked BLOCKED INBOUND for cluster group {}", (Object)pid, (Object)groupName);
        }
    }

    public void init() {
    }

    public void destroy() {
    }

    public Switch getSwitch() {
        try {
            Configuration configuration = this.configurationAdmin.getConfiguration("org.apache.karaf.cellar.node", null);
            if (configuration != null) {
                Boolean status = new Boolean((String)configuration.getProperties().get("handler." + ((Object)((Object)this)).getClass().getName()));
                if (status.booleanValue()) {
                    this.eventSwitch.turnOn();
                } else {
                    this.eventSwitch.turnOff();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.eventSwitch;
    }

    public Class<ClusterConfigurationEvent> getType() {
        return ClusterConfigurationEvent.class;
    }
}

