/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractResponse;

public class LeaderAndIsrResponse
extends AbstractResponse {
    private static final String ERROR_CODE_KEY_NAME = "error_code";
    private static final String PARTITIONS_KEY_NAME = "partitions";
    private static final String PARTITIONS_TOPIC_KEY_NAME = "topic";
    private static final String PARTITIONS_PARTITION_KEY_NAME = "partition";
    private static final String PARTITIONS_ERROR_CODE_KEY_NAME = "error_code";
    private final Errors error;
    private final Map<TopicPartition, Errors> responses;

    public LeaderAndIsrResponse(Errors error, Map<TopicPartition, Errors> responses) {
        this.responses = responses;
        this.error = error;
    }

    public LeaderAndIsrResponse(Struct struct) {
        this.responses = new HashMap<TopicPartition, Errors>();
        for (Object responseDataObj : struct.getArray(PARTITIONS_KEY_NAME)) {
            Struct responseData = (Struct)responseDataObj;
            String topic = responseData.getString(PARTITIONS_TOPIC_KEY_NAME);
            int partition = responseData.getInt(PARTITIONS_PARTITION_KEY_NAME);
            Errors error = Errors.forCode(responseData.getShort("error_code"));
            this.responses.put(new TopicPartition(topic, partition), error);
        }
        this.error = Errors.forCode(struct.getShort("error_code"));
    }

    public Map<TopicPartition, Errors> responses() {
        return this.responses;
    }

    public Errors error() {
        return this.error;
    }

    public static LeaderAndIsrResponse parse(ByteBuffer buffer, short version) {
        return new LeaderAndIsrResponse(ApiKeys.LEADER_AND_ISR.parseResponse(version, buffer));
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.LEADER_AND_ISR.responseSchema(version));
        ArrayList<Struct> responseDatas = new ArrayList<Struct>(this.responses.size());
        for (Map.Entry<TopicPartition, Errors> response : this.responses.entrySet()) {
            Struct partitionData = struct.instance(PARTITIONS_KEY_NAME);
            TopicPartition partition = response.getKey();
            partitionData.set(PARTITIONS_TOPIC_KEY_NAME, (Object)partition.topic());
            partitionData.set(PARTITIONS_PARTITION_KEY_NAME, (Object)partition.partition());
            partitionData.set("error_code", (Object)response.getValue().code());
            responseDatas.add(partitionData);
        }
        struct.set(PARTITIONS_KEY_NAME, (Object)responseDatas.toArray());
        struct.set("error_code", (Object)this.error.code());
        return struct;
    }
}

