/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.command;

import java.io.IOException;
import java.util.Optional;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.RerouteExplanation;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.command.BasePrimaryAllocationCommand;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.shard.ShardNotFoundException;

public class AllocateEmptyPrimaryAllocationCommand
extends BasePrimaryAllocationCommand {
    public static final String NAME = "allocate_empty_primary";
    public static final ParseField COMMAND_NAME_FIELD = new ParseField("allocate_empty_primary", new String[0]);
    private static final ObjectParser<Builder, Void> EMPTY_PRIMARY_PARSER = BasePrimaryAllocationCommand.createAllocatePrimaryParser("allocate_empty_primary");

    public AllocateEmptyPrimaryAllocationCommand(String index, int shardId, String node, boolean acceptDataLoss) {
        super(index, shardId, node, acceptDataLoss);
    }

    public AllocateEmptyPrimaryAllocationCommand(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public Optional<String> getMessage() {
        return Optional.of("allocated an empty primary for [" + this.index + "][" + this.shardId + "] on node [" + this.node + "] from user command");
    }

    public static AllocateEmptyPrimaryAllocationCommand fromXContent(XContentParser parser) throws IOException {
        return new Builder().parse(parser).build();
    }

    @Override
    public RerouteExplanation execute(RoutingAllocation allocation, boolean explain) {
        DiscoveryNode discoNode;
        try {
            discoNode = allocation.nodes().resolveNode(this.node);
        }
        catch (IllegalArgumentException e) {
            return this.explainOrThrowRejectedCommand(explain, allocation, e);
        }
        RoutingNodes routingNodes = allocation.routingNodes();
        RoutingNode routingNode = routingNodes.node(discoNode.getId());
        if (routingNode == null) {
            return this.explainOrThrowMissingRoutingNode(allocation, explain, discoNode);
        }
        try {
            allocation.routingTable().shardRoutingTable(this.index, this.shardId).primaryShard();
        }
        catch (IndexNotFoundException | ShardNotFoundException e) {
            return this.explainOrThrowRejectedCommand(explain, allocation, e);
        }
        ShardRouting shardRouting = null;
        for (ShardRouting shard : allocation.routingNodes().unassigned()) {
            if (!shard.getIndexName().equals(this.index) || shard.getId() != this.shardId || !shard.primary()) continue;
            shardRouting = shard;
            break;
        }
        if (shardRouting == null) {
            return this.explainOrThrowRejectedCommand(explain, allocation, "primary [" + this.index + "][" + this.shardId + "] is already assigned");
        }
        if (shardRouting.recoverySource().getType() != RecoverySource.Type.EMPTY_STORE && !this.acceptDataLoss) {
            String dataLossWarning = "allocating an empty primary for [" + this.index + "][" + this.shardId + "] can result in data loss. Please confirm by setting the accept_data_loss parameter to true";
            return this.explainOrThrowRejectedCommand(explain, allocation, dataLossWarning);
        }
        UnassignedInfo unassignedInfoToUpdate = null;
        if (shardRouting.unassignedInfo().getReason() != UnassignedInfo.Reason.FORCED_EMPTY_PRIMARY) {
            String unassignedInfoMessage = "force empty allocation from previous reason " + (Object)((Object)shardRouting.unassignedInfo().getReason()) + ", " + shardRouting.unassignedInfo().getMessage();
            unassignedInfoToUpdate = new UnassignedInfo(UnassignedInfo.Reason.FORCED_EMPTY_PRIMARY, unassignedInfoMessage, shardRouting.unassignedInfo().getFailure(), 0, System.nanoTime(), System.currentTimeMillis(), false, shardRouting.unassignedInfo().getLastAllocationStatus());
        }
        this.initializeUnassignedShard(allocation, routingNodes, routingNode, shardRouting, unassignedInfoToUpdate, RecoverySource.EmptyStoreRecoverySource.INSTANCE);
        return new RerouteExplanation(this, allocation.decision(Decision.YES, this.name() + " (allocation command)", "ignore deciders", new Object[0]));
    }

    public static class Builder
    extends BasePrimaryAllocationCommand.Builder<AllocateEmptyPrimaryAllocationCommand> {
        public Builder parse(XContentParser parser) throws IOException {
            return EMPTY_PRIMARY_PARSER.parse(parser, this, null);
        }

        @Override
        public AllocateEmptyPrimaryAllocationCommand build() {
            this.validate();
            return new AllocateEmptyPrimaryAllocationCommand(this.index, this.shard, this.node, this.acceptDataLoss);
        }
    }
}

