/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.shell;

import org.apache.karaf.cellar.core.Node;
import org.apache.karaf.cellar.core.shell.completer.NodeAliasCompleter;
import org.apache.karaf.cellar.core.shell.completer.NodeIdCompleter;
import org.apache.karaf.cellar.shell.ClusterCommandSupport;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="cluster", name="node-alias", description="Set or get node alias")
@Service
public class NodeAliasCommand
extends ClusterCommandSupport {
    @Argument(index=0, name="alias", description="The alias to set", required=false, multiValued=false)
    String alias;
    @Option(name="--id", description="Look for the alias for a given node ID", required=false, multiValued=false)
    @Completion(value=NodeIdCompleter.class)
    String idLookup;
    @Option(name="--alias", description="Look for the node ID for a given alias", required=false, multiValued=false)
    @Completion(value=NodeAliasCompleter.class)
    String aliasLookup;

    protected Object doExecute() throws Exception {
        if (this.idLookup != null) {
            Node node = this.clusterManager.findNodeById(this.idLookup);
            System.out.println(node.getAlias());
            return null;
        }
        if (this.aliasLookup != null) {
            Node node = this.clusterManager.findNodeByAlias(this.aliasLookup);
            System.out.println(node.getId());
            return null;
        }
        if (this.alias != null) {
            if (this.clusterManager.findNodeByAlias(this.alias) != null) {
                System.err.println("Alias " + this.alias + " already exists");
                return null;
            }
            this.clusterManager.setNodeAlias(this.alias);
        } else {
            Node node = this.clusterManager.getNode();
            if (node.getAlias() == null) {
                System.out.println("");
            } else {
                System.out.println(node.getAlias());
            }
        }
        return null;
    }
}

