/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.router.services;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.unomi.api.Item;
import org.apache.unomi.persistence.spi.PersistenceService;
import org.apache.unomi.router.api.ExportConfiguration;
import org.apache.unomi.router.api.RouterConstants;
import org.apache.unomi.router.api.services.ImportExportConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportConfigurationServiceImpl
implements ImportExportConfigurationService<ExportConfiguration> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ExportConfigurationServiceImpl.class.getName());
    private PersistenceService persistenceService;
    private final Map<String, RouterConstants.CONFIG_CAMEL_REFRESH> camelConfigsToRefresh = new ConcurrentHashMap<String, RouterConstants.CONFIG_CAMEL_REFRESH>();

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public ExportConfigurationServiceImpl() {
        LOGGER.info("Initializing export configuration service...");
    }

    public List<ExportConfiguration> getAll() {
        return this.persistenceService.getAllItems(ExportConfiguration.class);
    }

    public ExportConfiguration load(String configId) {
        return (ExportConfiguration)this.persistenceService.load(configId, ExportConfiguration.class);
    }

    public ExportConfiguration save(ExportConfiguration exportConfiguration, boolean updateRunningRoute) {
        if (exportConfiguration.getItemId() == null) {
            exportConfiguration.setItemId(UUID.randomUUID().toString());
        }
        this.persistenceService.save((Item)exportConfiguration);
        if (updateRunningRoute) {
            this.camelConfigsToRefresh.put(exportConfiguration.getItemId(), RouterConstants.CONFIG_CAMEL_REFRESH.UPDATED);
        }
        return (ExportConfiguration)this.persistenceService.load(exportConfiguration.getItemId(), ExportConfiguration.class);
    }

    public void delete(String configId) {
        this.persistenceService.remove(configId, ExportConfiguration.class);
        this.camelConfigsToRefresh.put(configId, RouterConstants.CONFIG_CAMEL_REFRESH.REMOVED);
    }

    public Map<String, RouterConstants.CONFIG_CAMEL_REFRESH> consumeConfigsToBeRefresh() {
        HashMap<String, RouterConstants.CONFIG_CAMEL_REFRESH> result = new HashMap<String, RouterConstants.CONFIG_CAMEL_REFRESH>(this.camelConfigsToRefresh);
        this.camelConfigsToRefresh.clear();
        return result;
    }
}

