/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.rest.endpoints;

import java.util.Map;
import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.cxf.rs.security.cors.CrossOriginResourceSharing;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.query.AggregateQuery;
import org.apache.unomi.api.services.QueryService;
import org.apache.unomi.rest.service.impl.LocalizationHelper;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@CrossOriginResourceSharing(allowAllOrigins=true, allowCredentials=true)
@Path(value="/query")
@Component(service={QueryServiceEndPoint.class}, property={"osgi.jaxrs.resource=true"})
public class QueryServiceEndPoint {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)QueryServiceEndPoint.class.getName());
    @Reference
    private QueryService queryService;
    @Reference
    private LocalizationHelper localizationHelper;

    @WebMethod(exclude=true)
    public void setQueryService(QueryService queryService) {
        this.queryService = queryService;
    }

    @WebMethod(exclude=true)
    public void setLocalizationHelper(LocalizationHelper localizationHelper) {
        this.localizationHelper = localizationHelper;
    }

    @GET
    @Path(value="/{type}/{property}")
    public Map<String, Long> getAggregate(@PathParam(value="type") String type, @PathParam(value="property") String property) {
        return this.queryService.getAggregate(type, property);
    }

    @POST
    @Path(value="/{type}/{property}")
    public Map<String, Long> getAggregate(@PathParam(value="type") String type, @PathParam(value="property") String property, @QueryParam(value="optimizedQuery") boolean optimizedQuery, AggregateQuery aggregateQuery) {
        if (optimizedQuery) {
            return this.queryService.getAggregateWithOptimizedQuery(type, property, aggregateQuery);
        }
        return this.queryService.getAggregate(type, property, aggregateQuery);
    }

    @POST
    @Path(value="/{type}/{property}/{metricTypes:((sum|avg|min|max)/?)*}")
    public Map<String, Double> getMetric(@PathParam(value="type") String type, @PathParam(value="property") String property, @PathParam(value="metricTypes") String metricsType, Condition condition) {
        return this.queryService.getMetric(type, property, metricsType, condition);
    }

    @POST
    @Path(value="/{type}/count")
    public long getQueryCount(@PathParam(value="type") String type, @QueryParam(value="validate") Boolean validate, Condition condition, @Context HttpServletResponse response) {
        long count;
        block2: {
            count = 0L;
            try {
                count = this.queryService.getQueryCount(type, condition);
            }
            catch (IllegalArgumentException e) {
                if (validate != null && !validate.booleanValue()) break block2;
                LOGGER.error("{}", (Object)e.getMessage(), (Object)e);
                response.setStatus(Response.Status.BAD_REQUEST.getStatusCode());
            }
        }
        return count;
    }
}

