/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.rest.endpoints;

import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.cxf.rs.security.cors.CrossOriginResourceSharing;
import org.apache.unomi.api.Metadata;
import org.apache.unomi.api.PartialList;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.query.Query;
import org.apache.unomi.api.segments.DependentMetadata;
import org.apache.unomi.api.segments.Segment;
import org.apache.unomi.api.services.SegmentService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@CrossOriginResourceSharing(allowAllOrigins=true, allowCredentials=true)
@Path(value="/segments")
@Component(service={SegmentServiceEndPoint.class}, property={"osgi.jaxrs.resource=true"})
public class SegmentServiceEndPoint {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)SegmentServiceEndPoint.class.getName());
    @Reference
    private SegmentService segmentService;

    public SegmentServiceEndPoint() {
        LOGGER.info("Initializing segment service endpoint...");
    }

    @WebMethod(exclude=true)
    public void setSegmentService(SegmentService segmentService) {
        this.segmentService = segmentService;
    }

    @GET
    @Path(value="/{segmentID}/match")
    public PartialList<Profile> getMatchingIndividuals(@PathParam(value="segmentID") String segmentId, @QueryParam(value="offset") @DefaultValue(value="0") int offset, @QueryParam(value="size") @DefaultValue(value="50") int size, @QueryParam(value="sort") String sortBy) {
        return this.segmentService.getMatchingIndividuals(segmentId, offset, size, sortBy);
    }

    @GET
    @Path(value="/{segmentID}/count")
    public long getMatchingIndividualsCount(@PathParam(value="segmentID") String segmentId) {
        return this.segmentService.getMatchingIndividualsCount(segmentId);
    }

    @GET
    @Path(value="/{segmentID}/match/{profile}")
    public Boolean isProfileInSegment(@PathParam(value="profile") Profile profile, @PathParam(value="segmentID") String segmentId) {
        return this.segmentService.isProfileInSegment(profile, segmentId);
    }

    @GET
    @Path(value="/")
    public List<Metadata> getSegmentMetadatas(@QueryParam(value="offset") @DefaultValue(value="0") int offset, @QueryParam(value="size") @DefaultValue(value="50") int size, @QueryParam(value="sort") String sortBy) {
        return this.segmentService.getSegmentMetadatas(offset, size, sortBy).getList();
    }

    @GET
    @Path(value="/{segmentID}/impacted")
    public DependentMetadata getSegmentDependentMetadata(@PathParam(value="segmentID") String segmentId) {
        return this.segmentService.getSegmentDependentMetadata(segmentId);
    }

    @POST
    @Path(value="/")
    public void setSegmentDefinition(Segment segment) {
        this.segmentService.setSegmentDefinition(segment);
    }

    @POST
    @Path(value="/query")
    public PartialList<Metadata> getListMetadatas(Query query) {
        return this.segmentService.getSegmentMetadatas(query);
    }

    @GET
    @Path(value="/{segmentID}")
    public Segment getSegmentDefinition(@PathParam(value="segmentID") String segmentId) {
        return this.segmentService.getSegmentDefinition(segmentId);
    }

    @DELETE
    @Path(value="/{segmentID}")
    public DependentMetadata removeSegmentDefinition(@PathParam(value="segmentID") String segmentId, @QueryParam(value="validate") boolean validate) {
        return this.segmentService.removeSegmentDefinition(segmentId, validate);
    }

    @Deprecated
    @GET
    @Path(value="/resetQueries")
    public void resetQueries() {
        for (Metadata metadata : this.segmentService.getSegmentMetadatas(0, 50, null).getList()) {
            Segment s = this.segmentService.getSegmentDefinition(metadata.getId());
            this.segmentService.setSegmentDefinition(s);
        }
    }
}

