/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.bundle.management.internal;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.karaf.cellar.bundle.BundleState;
import org.apache.karaf.cellar.bundle.ClusterBundleEvent;
import org.apache.karaf.cellar.bundle.management.CellarBundleMBean;
import org.apache.karaf.cellar.core.CellarSupport;
import org.apache.karaf.cellar.core.ClusterManager;
import org.apache.karaf.cellar.core.Group;
import org.apache.karaf.cellar.core.GroupManager;
import org.apache.karaf.cellar.core.control.SwitchStatus;
import org.apache.karaf.cellar.core.event.Event;
import org.apache.karaf.cellar.core.event.EventProducer;
import org.apache.karaf.cellar.core.event.EventType;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationAdmin;

public class CellarBundleMBeanImpl
extends StandardMBean
implements CellarBundleMBean {
    private ClusterManager clusterManager;
    private GroupManager groupManager;
    private ConfigurationAdmin configurationAdmin;
    private EventProducer eventProducer;
    private BundleContext bundleContext;

    public CellarBundleMBeanImpl() throws NotCompliantMBeanException {
        super(CellarBundleMBean.class);
    }

    public ClusterManager getClusterManager() {
        return this.clusterManager;
    }

    public void setClusterManager(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }

    public GroupManager getGroupManager() {
        return this.groupManager;
    }

    public void setGroupManager(GroupManager groupManager) {
        this.groupManager = groupManager;
    }

    public ConfigurationAdmin getConfigurationAdmin() {
        return this.configurationAdmin;
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    public EventProducer getEventProducer() {
        return this.eventProducer;
    }

    public void setEventProducer(EventProducer eventProducer) {
        this.eventProducer = eventProducer;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Override
    public void install(String groupName, String location) throws Exception {
        this.install(groupName, location, null, false);
    }

    @Override
    public void install(String groupName, String location, boolean start) throws Exception {
        this.install(groupName, location, null, start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void install(String groupName, String location, Integer level, boolean start) throws Exception {
        Group group = this.groupManager.findGroupByName(groupName);
        if (group == null) {
            throw new IllegalArgumentException("Cluster group " + groupName + " doesn't exist");
        }
        if (this.eventProducer.getSwitch().getStatus().equals((Object)SwitchStatus.OFF)) {
            throw new IllegalStateException("Cluster event producer is OFF for this node");
        }
        CellarSupport support = new CellarSupport();
        support.setClusterManager(this.clusterManager);
        support.setGroupManager(this.groupManager);
        support.setConfigurationAdmin(this.configurationAdmin);
        if (!support.isAllowed(group, "bundle", location, EventType.OUTBOUND).booleanValue()) {
            throw new IllegalArgumentException("Bundle location " + location + " is blocked outbound for cluster group " + groupName);
        }
        JarInputStream jarInputStream = new JarInputStream(new URL(location).openStream());
        Manifest manifest = jarInputStream.getManifest();
        if (manifest == null) {
            throw new IllegalArgumentException("Bundle location " + location + " doesn't seem correct");
        }
        String name = manifest.getMainAttributes().getValue("Bundle-Name");
        String symbolicName = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
        if (name == null) {
            name = symbolicName;
        }
        if (name == null) {
            name = location;
        }
        String version = manifest.getMainAttributes().getValue("Bundle-Version");
        jarInputStream.close();
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            Map clusterBundles = this.clusterManager.getMap("org.apache.karaf.cellar.bundle.map." + groupName);
            BundleState state = new BundleState();
            state.setName(name);
            state.setSymbolicName(symbolicName);
            state.setVersion(version);
            state.setId(clusterBundles.size());
            state.setStartLevel(level);
            state.setLocation(location);
            if (start) {
                state.setStatus(32);
            } else {
                state.setStatus(2);
            }
            clusterBundles.put(symbolicName + "/" + version, state);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        ClusterBundleEvent event = new ClusterBundleEvent(symbolicName, version, location, level, 2);
        event.setSourceGroup(group);
        event.setSourceNode(this.clusterManager.getNode());
        if (start) {
            event = new ClusterBundleEvent(symbolicName, version, location, level, 32);
            event.setSourceGroup(group);
            event.setSourceNode(this.clusterManager.getNode());
        }
        this.eventProducer.produce((Event)event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uninstall(String groupName, String id) throws Exception {
        Group group = this.groupManager.findGroupByName(groupName);
        if (group == null) {
            throw new IllegalArgumentException("Cluster group " + groupName + " doesn't exist");
        }
        if (this.eventProducer.getSwitch().getStatus().equals((Object)SwitchStatus.OFF)) {
            throw new IllegalStateException("Cluster event producer is OFF for this node");
        }
        CellarSupport support = new CellarSupport();
        support.setClusterManager(this.clusterManager);
        support.setGroupManager(this.groupManager);
        support.setConfigurationAdmin(this.configurationAdmin);
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            Map clusterBundles = this.clusterManager.getMap("org.apache.karaf.cellar.bundle.map." + groupName);
            List<String> bundles = this.selector(id, this.gatherBundles(groupName));
            for (String bundle : bundles) {
                String location;
                BundleState state = (BundleState)clusterBundles.get(bundle);
                if (state == null || !support.isAllowed(group, "bundle", location = state.getLocation(), EventType.OUTBOUND).booleanValue()) continue;
                clusterBundles.remove(bundle);
                String[] split = bundle.split("/");
                ClusterBundleEvent event = new ClusterBundleEvent(split[0], split[1], location, null, 1);
                event.setSourceGroup(group);
                event.setSourceNode(this.clusterManager.getNode());
                this.eventProducer.produce((Event)event);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(String groupName, String id) throws Exception {
        Group group = this.groupManager.findGroupByName(groupName);
        if (group == null) {
            throw new IllegalArgumentException("Cluster group " + groupName + " doesn't exist");
        }
        if (this.eventProducer.getSwitch().getStatus().equals((Object)SwitchStatus.OFF)) {
            throw new IllegalStateException("Cluster event producer is OFF for this node");
        }
        CellarSupport support = new CellarSupport();
        support.setClusterManager(this.clusterManager);
        support.setGroupManager(this.groupManager);
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            Map clusterBundles = this.clusterManager.getMap("org.apache.karaf.cellar.bundle.map." + groupName);
            List<String> bundles = this.selector(id, this.gatherBundles(groupName));
            for (String bundle : bundles) {
                BundleState state = (BundleState)clusterBundles.get(bundle);
                if (state == null) continue;
                String location = state.getLocation();
                support.setConfigurationAdmin(this.configurationAdmin);
                if (!support.isAllowed(group, "bundle", location, EventType.OUTBOUND).booleanValue()) continue;
                state.setStatus(32);
                clusterBundles.put(bundle, state);
                String[] split = bundle.split("/");
                ClusterBundleEvent event = new ClusterBundleEvent(split[0], split[1], location, state.getStartLevel(), 32);
                event.setSourceGroup(group);
                event.setSourceNode(this.clusterManager.getNode());
                this.eventProducer.produce((Event)event);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(String groupName, String id) throws Exception {
        Group group = this.groupManager.findGroupByName(groupName);
        if (group == null) {
            throw new IllegalArgumentException("Cluster group " + groupName + " doesn't exist");
        }
        if (this.eventProducer.getSwitch().getStatus().equals((Object)SwitchStatus.OFF)) {
            throw new IllegalStateException("Cluster event producer is OFF for this node");
        }
        CellarSupport support = new CellarSupport();
        support.setClusterManager(this.clusterManager);
        support.setGroupManager(this.groupManager);
        support.setConfigurationAdmin(this.configurationAdmin);
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            Map clusterBundles = this.clusterManager.getMap("org.apache.karaf.cellar.bundle.map." + groupName);
            List<String> bundles = this.selector(id, this.gatherBundles(groupName));
            for (String bundle : bundles) {
                String location;
                BundleState state = (BundleState)clusterBundles.get(bundle);
                if (state == null || !support.isAllowed(group, "bundle", location = state.getLocation(), EventType.OUTBOUND).booleanValue()) continue;
                state.setStatus(4);
                clusterBundles.put(bundle, state);
                String[] split = bundle.split("/");
                ClusterBundleEvent event = new ClusterBundleEvent(split[0], split[1], location, state.getStartLevel(), 4);
                event.setSourceGroup(group);
                event.setSourceNode(this.clusterManager.getNode());
                this.eventProducer.produce((Event)event);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(String groupName, String id, String updateLocation) throws Exception {
        Group group = this.groupManager.findGroupByName(groupName);
        if (group == null) {
            throw new IllegalArgumentException("Cluster group " + groupName + " doesn't exist");
        }
        if (this.eventProducer.getSwitch().getStatus().equals((Object)SwitchStatus.OFF)) {
            throw new IllegalStateException("Cluster event producer is OFF for this node");
        }
        CellarSupport support = new CellarSupport();
        support.setClusterManager(this.clusterManager);
        support.setGroupManager(this.groupManager);
        support.setConfigurationAdmin(this.configurationAdmin);
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            Map clusterBundles = this.clusterManager.getMap("org.apache.karaf.cellar.bundle.map." + groupName);
            List<String> bundles = this.selector(id, this.gatherBundles(groupName));
            for (String bundle : bundles) {
                BundleState state = (BundleState)clusterBundles.get(bundle);
                if (state == null) continue;
                String location = state.getLocation();
                if (updateLocation != null) {
                    location = updateLocation;
                }
                if (!support.isAllowed(group, "bundle", location, EventType.OUTBOUND).booleanValue()) continue;
                state.setLocation(location);
                clusterBundles.put(bundle, state);
                String[] split = bundle.split("/");
                ClusterBundleEvent event = new ClusterBundleEvent(split[0], split[1], location, null, 555);
                event.setSourceGroup(group);
                event.setSourceNode(this.clusterManager.getNode());
                this.eventProducer.produce((Event)event);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    @Override
    public void update(String groupName, String id) throws Exception {
        this.update(groupName, id, null);
    }

    @Override
    public void block(String groupName, String bundlePattern, boolean whitelist, boolean blacklist, boolean in, boolean out) throws Exception {
        ArrayList<String> patterns = new ArrayList<String>();
        Map<String, ExtendedBundleState> bundles = this.gatherBundles(groupName);
        List<String> selectedBundles = this.selector(bundlePattern, bundles);
        for (String selectedBundle : selectedBundles) {
            patterns.add(bundles.get(selectedBundle).getLocation());
        }
        if (patterns.isEmpty()) {
            patterns.add(bundlePattern);
        }
        CellarSupport support = new CellarSupport();
        support.setClusterManager(this.clusterManager);
        support.setGroupManager(this.groupManager);
        support.setConfigurationAdmin(this.configurationAdmin);
        for (String pattern : patterns) {
            if (in) {
                if (whitelist) {
                    support.switchListEntry("whitelist", groupName, "bundle", EventType.INBOUND, pattern);
                }
                if (blacklist) {
                    support.switchListEntry("blacklist", groupName, "bundle", EventType.INBOUND, pattern);
                }
            }
            if (!out) continue;
            if (whitelist) {
                support.switchListEntry("whitelist", groupName, "bundle", EventType.OUTBOUND, pattern);
            }
            if (!blacklist) continue;
            support.switchListEntry("blacklist", groupName, "bundle", EventType.OUTBOUND, pattern);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TabularData getBundles(String groupName) throws Exception {
        CompositeType compositeType = new CompositeType("Bundle", "Karaf Cellar bundle", new String[]{"id", "name", "symbolic_name", "version", "status", "location", "located", "blocked"}, new String[]{"ID of the bundle", "Name of the bundle", "Symbolic name of the bundle", "Version of the bundle", "Current status of the bundle", "Location of the bundle", "Where the bundle is located (cluster or local node)", "The bundle blocked policy"}, new OpenType[]{SimpleType.LONG, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING});
        TabularType tableType = new TabularType("Bundles", "Table of all Karaf Cellar bundles", compositeType, new String[]{"name", "version"});
        TabularDataSupport table = new TabularDataSupport(tableType);
        Group group = this.groupManager.findGroupByName(groupName);
        if (group == null) {
            throw new IllegalArgumentException("Cluster group " + groupName + " doesn't exist");
        }
        CellarSupport support = new CellarSupport();
        support.setClusterManager(this.clusterManager);
        support.setConfigurationAdmin(this.configurationAdmin);
        support.setGroupManager(this.groupManager);
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            Map<String, ExtendedBundleState> allBundles = this.gatherBundles(groupName);
            ArrayList<ExtendedBundleState> bundles = new ArrayList<ExtendedBundleState>(allBundles.values());
            Collections.sort(bundles, new BundleStateComparator());
            for (ExtendedBundleState bundle : bundles) {
                String status;
                switch (bundle.getStatus()) {
                    case 2: {
                        status = "Installed";
                        break;
                    }
                    case 4: {
                        status = "Resolved";
                        break;
                    }
                    case 32: {
                        status = "Active";
                        break;
                    }
                    case 8: {
                        status = "Starting";
                        break;
                    }
                    case 16: {
                        status = "Stopping";
                        break;
                    }
                    case 1: {
                        status = "Uninstalled";
                        break;
                    }
                    default: {
                        status = "";
                    }
                }
                String located = "";
                boolean local = bundle.isLocal();
                boolean cluster = bundle.isCluster();
                if (local && cluster) {
                    located = "cluster/local";
                }
                if (local && !cluster) {
                    located = "local";
                }
                if (cluster && !local) {
                    located = "cluster";
                }
                String blocked = "";
                boolean inbound = support.isAllowed(group, "bundle", bundle.getLocation(), EventType.INBOUND);
                boolean outbound = support.isAllowed(group, "bundle", bundle.getLocation(), EventType.OUTBOUND);
                if (!inbound && !outbound) {
                    blocked = "in/out";
                }
                if (!inbound && outbound) {
                    blocked = "in";
                }
                if (outbound && !inbound) {
                    blocked = "out";
                }
                CompositeDataSupport data = new CompositeDataSupport(compositeType, new String[]{"id", "name", "symbolic_name", "version", "status", "location", "located", "blocked"}, new Object[]{bundle.getId(), bundle.getName(), bundle.getSymbolicName(), bundle.getVersion(), status, bundle.getLocation(), located, blocked});
                table.put(data);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        return table;
    }

    protected List<String> selector(String id, Map<String, ExtendedBundleState> clusterBundles) {
        ArrayList<String> bundles = new ArrayList<String>();
        this.addMatchingBundles(id, bundles, clusterBundles);
        return bundles;
    }

    protected void addMatchingBundles(String nameId, List<String> bundles, Map<String, ExtendedBundleState> clusterBundles) {
        Pattern pattern = Pattern.compile("^\\d+$");
        Matcher matcher = pattern.matcher(nameId);
        if (matcher.matches()) {
            int id = Integer.parseInt(nameId);
            for (String bundle : clusterBundles.keySet()) {
                if (clusterBundles.get(bundle).getId() != (long)id) continue;
                bundles.add(bundle);
                break;
            }
            return;
        }
        pattern = Pattern.compile("^(\\d+)-(\\d+)$");
        matcher = pattern.matcher(nameId);
        if (matcher.matches()) {
            long endId;
            int index = nameId.indexOf(45);
            long startId = Long.parseLong(nameId.substring(0, index));
            if (startId < (endId = Long.parseLong(nameId.substring(index + 1)))) {
                int bundleIndex = 0;
                for (String bundle : clusterBundles.keySet()) {
                    if ((long)bundleIndex >= startId && (long)bundleIndex <= endId) {
                        bundles.add(bundle);
                    }
                    ++bundleIndex;
                }
            }
            return;
        }
        int index = nameId.indexOf(47);
        if (index != -1) {
            String[] idSplit = nameId.split("/");
            String name = idSplit[0];
            String version = idSplit[1];
            for (String bundle : clusterBundles.keySet()) {
                String[] bundleSplit = bundle.split("/");
                if (!bundleSplit[1].equals(version)) continue;
                Pattern namePattern = Pattern.compile(name);
                BundleState state = clusterBundles.get(bundle);
                if (state.getName() != null) {
                    matcher = namePattern.matcher(state.getName());
                    if (matcher.matches()) {
                        bundles.add(bundle);
                        continue;
                    }
                    matcher = namePattern.matcher(bundleSplit[0]);
                    if (!matcher.matches()) continue;
                    bundles.add(bundle);
                    continue;
                }
                if (state.getSymbolicName() != null) {
                    matcher = namePattern.matcher(state.getSymbolicName());
                    if (matcher.matches()) {
                        bundles.add(bundle);
                        continue;
                    }
                    matcher = namePattern.matcher(bundleSplit[0]);
                    if (!matcher.matches()) continue;
                    bundles.add(bundle);
                    continue;
                }
                matcher = namePattern.matcher(bundleSplit[0]);
                if (!matcher.matches()) continue;
                bundles.add(bundle);
            }
            return;
        }
        Pattern namePattern = Pattern.compile(nameId);
        for (String bundle : clusterBundles.keySet()) {
            String[] idSplit;
            BundleState state = clusterBundles.get(bundle);
            if (state.getName() != null) {
                matcher = namePattern.matcher(state.getName());
                if (matcher.matches()) {
                    bundles.add(bundle);
                    continue;
                }
                idSplit = bundle.split("/");
                matcher = namePattern.matcher(idSplit[0]);
                if (!matcher.matches()) continue;
                bundles.add(bundle);
                continue;
            }
            if (state.getSymbolicName() != null) {
                matcher = namePattern.matcher(state.getSymbolicName());
                if (matcher.matches()) {
                    bundles.add(bundle);
                    continue;
                }
                idSplit = bundle.split("/");
                matcher = namePattern.matcher(idSplit[0]);
                if (!matcher.matches()) continue;
                bundles.add(bundle);
                continue;
            }
            idSplit = bundle.split("/");
            matcher = namePattern.matcher(idSplit[0]);
            if (!matcher.matches()) continue;
            bundles.add(bundle);
        }
    }

    private Map<String, ExtendedBundleState> gatherBundles(String groupName) {
        HashMap<String, ExtendedBundleState> bundles = new HashMap<String, ExtendedBundleState>();
        Map clusterBundles = this.clusterManager.getMap("org.apache.karaf.cellar.bundle.map." + groupName);
        for (String key : clusterBundles.keySet()) {
            BundleState state = (BundleState)clusterBundles.get(key);
            ExtendedBundleState extendedState = new ExtendedBundleState();
            extendedState.setId(state.getId());
            extendedState.setName(state.getName());
            extendedState.setVersion(state.getVersion());
            extendedState.setSymbolicName(state.getSymbolicName());
            extendedState.setStatus(state.getStatus());
            extendedState.setLocation(state.getLocation());
            extendedState.setCluster(true);
            extendedState.setLocal(false);
            bundles.put(key, extendedState);
        }
        for (Bundle bundle : this.bundleContext.getBundles()) {
            ExtendedBundleState extendedState;
            String version = (String)bundle.getHeaders().get("Bundle-Version");
            String symbolicName = bundle.getSymbolicName();
            String key = symbolicName + "/" + version;
            if (bundles.containsKey(key)) {
                extendedState = (ExtendedBundleState)bundles.get(key);
                extendedState.setLocal(true);
                continue;
            }
            extendedState = new ExtendedBundleState();
            String name = (String)bundle.getHeaders().get("Bundle-Name");
            name = name == null ? symbolicName : name;
            name = name == null ? bundle.getLocation() : name;
            extendedState.setId(bundle.getBundleId());
            extendedState.setName(name);
            extendedState.setVersion((String)bundle.getHeaders().get("Bundle-Version"));
            extendedState.setSymbolicName(symbolicName);
            extendedState.setLocation(bundle.getLocation());
            extendedState.setStatus(bundle.getState());
            extendedState.setCluster(false);
            extendedState.setLocal(true);
            bundles.put(key, extendedState);
        }
        return bundles;
    }

    class BundleStateComparator
    implements Comparator<BundleState> {
        BundleStateComparator() {
        }

        @Override
        public int compare(BundleState b1, BundleState b2) {
            return (int)(b1.getId() - b2.getId());
        }
    }

    class ExtendedBundleState
    extends BundleState {
        private boolean cluster;
        private boolean local;

        ExtendedBundleState() {
        }

        public boolean isCluster() {
            return this.cluster;
        }

        public void setCluster(boolean cluster) {
            this.cluster = cluster;
        }

        public boolean isLocal() {
            return this.local;
        }

        public void setLocal(boolean local) {
            this.local = local;
        }
    }
}

