/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.health;

import java.time.Duration;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.converter.TimePatternConverter;
import org.apache.camel.util.ObjectHelper;

public class HealthCheckConfiguration
implements Cloneable {
    public static final Boolean DEFAULT_VALUE_ENABLED = Boolean.FALSE;
    public static final Duration DEFAULT_VALUE_INTERVAL = Duration.ZERO;
    public static final Integer DEFAULT_VALUE_FAILURE_THRESHOLD = 0;
    private Boolean enabled;
    private Duration interval;
    private Integer failureThreshold;

    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Duration getInterval() {
        return this.interval;
    }

    public void setInterval(Duration interval) {
        this.interval = interval;
    }

    public void setInterval(String interval) {
        this.interval = ObjectHelper.isNotEmpty(interval) ? Duration.ofMillis(TimePatternConverter.toMilliSeconds(interval)) : null;
    }

    public Integer getFailureThreshold() {
        return this.failureThreshold;
    }

    public void setFailureThreshold(Integer failureThreshold) {
        this.failureThreshold = failureThreshold;
    }

    public static Boolean defaultValueEnabled() {
        return DEFAULT_VALUE_ENABLED;
    }

    public static Duration defaultValueInterval() {
        return DEFAULT_VALUE_INTERVAL;
    }

    public static Integer defaultValueFailureThreshold() {
        return DEFAULT_VALUE_FAILURE_THRESHOLD;
    }

    public HealthCheckConfiguration copy() {
        try {
            return (HealthCheckConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException(e);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements org.apache.camel.Builder<HealthCheckConfiguration> {
        private Boolean enabled;
        private Duration interval;
        private Integer failureThreshold;

        private Builder() {
        }

        public Builder complete(HealthCheckConfiguration template) {
            if (template != null) {
                if (this.enabled == null) {
                    this.enabled = template.enabled;
                }
                if (this.interval == null) {
                    this.interval = template.interval;
                }
                if (this.failureThreshold == null) {
                    this.failureThreshold = template.failureThreshold;
                }
            }
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder interval(Duration interval) {
            this.interval = interval;
            return this;
        }

        public Builder interval(Long interval) {
            return ObjectHelper.isNotEmpty(interval) ? this.interval(Duration.ofMillis(interval)) : this;
        }

        public Builder interval(String interval) {
            return ObjectHelper.isNotEmpty(interval) ? this.interval(TimePatternConverter.toMilliSeconds(interval)) : this;
        }

        public Builder failureThreshold(Integer failureThreshold) {
            this.failureThreshold = failureThreshold;
            return this;
        }

        @Override
        public HealthCheckConfiguration build() {
            HealthCheckConfiguration conf = new HealthCheckConfiguration();
            conf.setEnabled(ObjectHelper.supplyIfEmpty(this.enabled, HealthCheckConfiguration::defaultValueEnabled));
            conf.setInterval(ObjectHelper.supplyIfEmpty(this.interval, HealthCheckConfiguration::defaultValueInterval));
            conf.setFailureThreshold(ObjectHelper.supplyIfEmpty(this.failureThreshold, HealthCheckConfiguration::defaultValueFailureThreshold));
            return conf;
        }
    }
}

