/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.validator;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlType;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.impl.validator.ProcessorValidator;
import org.apache.camel.model.ExpressionNodeHelper;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.model.validator.ValidatorDefinition;
import org.apache.camel.processor.validation.PredicateValidatingProcessor;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.Validator;

@Metadata(label="validation")
@XmlType(name="predicateValidator")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class PredicateValidatorDefinition
extends ValidatorDefinition {
    @XmlElementRef
    private ExpressionDefinition expression;

    @Override
    protected Validator doCreateValidator(CamelContext context) throws Exception {
        Predicate pred = this.getExpression().createPredicate(context);
        PredicateValidatingProcessor processor = new PredicateValidatingProcessor(pred);
        return new ProcessorValidator(context).setProcessor(processor).setType(this.getType());
    }

    public ExpressionDefinition getExpression() {
        return this.expression;
    }

    public void setExpression(ExpressionDefinition expression) {
        this.expression = expression instanceof Expression ? ExpressionNodeHelper.toExpressionDefinition(expression) : (expression instanceof Predicate ? ExpressionNodeHelper.toExpressionDefinition(expression) : expression);
    }
}

