/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Traceable;
import org.apache.camel.spi.IdAware;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.ObjectHelper;

public class SetPropertyProcessor
extends ServiceSupport
implements AsyncProcessor,
Traceable,
IdAware {
    private String id;
    private final Expression propertyName;
    private final Expression expression;

    public SetPropertyProcessor(Expression propertyName, Expression expression) {
        this.propertyName = propertyName;
        this.expression = expression;
        ObjectHelper.notNull(propertyName, "propertyName");
        ObjectHelper.notNull(expression, "expression");
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            Object newProperty = this.expression.evaluate(exchange, Object.class);
            if (exchange.getException() != null) {
                callback.done(true);
                return true;
            }
            String key = this.propertyName.evaluate(exchange, String.class);
            exchange.setProperty(key, newProperty);
        }
        catch (Throwable e) {
            exchange.setException(e);
        }
        callback.done(true);
        return true;
    }

    public String toString() {
        return "SetProperty(" + this.propertyName + ", " + this.expression + ")";
    }

    @Override
    public String getTraceLabel() {
        return "setProperty[" + this.propertyName + ", " + this.expression + "]";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public String getPropertyName() {
        return this.propertyName.toString();
    }

    public Expression getExpression() {
        return this.expression;
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
    }
}

