/*
 * Decompiled with CFR 0.152.
 */
package groovyx.net.http;

import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;

public class Traverser {
    public static <T, V> V traverse(T target, Function<T, T> next, Function<T, V> getValue, Predicate<V> testValue) {
        V v = getValue.apply(target);
        if (testValue.test(v)) {
            return v;
        }
        T nextTarget = next.apply(target);
        if (nextTarget != null) {
            return Traverser.traverse(nextTarget, next, getValue, testValue);
        }
        return null;
    }

    public static <V> boolean notNull(V v) {
        return v != null;
    }

    public static boolean nonEmptyMap(Map<?, ?> v) {
        return v != null && !v.isEmpty();
    }

    public static <V> Predicate<V> notValue(V v) {
        return toTest -> !v.equals(toTest);
    }
}

