/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.jaspi.modules;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.MessagePolicy;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.security.authentication.DeferredAuthentication;
import org.eclipse.jetty.security.authentication.LoginCallbackImpl;
import org.eclipse.jetty.security.authentication.SessionAuthentication;
import org.eclipse.jetty.security.jaspi.modules.BaseAuthModule;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.security.Credential;
import org.eclipse.jetty.util.security.Password;

@Deprecated
public class FormAuthModule
extends BaseAuthModule {
    private static final Logger LOG = Log.getLogger(FormAuthModule.class);
    public static final String __J_URI = "org.eclipse.jetty.util.URI";
    public static final String __J_AUTHENTICATED = "org.eclipse.jetty.server.Auth";
    public static final String __J_SECURITY_CHECK = "/j_security_check";
    public static final String __J_USERNAME = "j_username";
    public static final String __J_PASSWORD = "j_password";
    public static final String LOGIN_PAGE_KEY = "org.eclipse.jetty.security.jaspi.modules.LoginPage";
    public static final String ERROR_PAGE_KEY = "org.eclipse.jetty.security.jaspi.modules.ErrorPage";
    public static final String SSO_SOURCE_KEY = "org.eclipse.jetty.security.jaspi.modules.SsoSource";
    private String _formErrorPage;
    private String _formErrorPath;
    private String _formLoginPage;
    private String _formLoginPath;

    public FormAuthModule() {
    }

    public FormAuthModule(CallbackHandler callbackHandler, String loginPage, String errorPage) {
        super(callbackHandler);
        this.setLoginPage(loginPage);
        this.setErrorPage(errorPage);
    }

    @Override
    public void initialize(MessagePolicy requestPolicy, MessagePolicy responsePolicy, CallbackHandler handler, Map options) throws AuthException {
        super.initialize(requestPolicy, responsePolicy, handler, options);
        this.setLoginPage((String)options.get(LOGIN_PAGE_KEY));
        this.setErrorPage((String)options.get(ERROR_PAGE_KEY));
    }

    private void setLoginPage(String path) {
        if (!path.startsWith("/")) {
            LOG.warn("form-login-page must start with /", new Object[0]);
            path = "/" + path;
        }
        this._formLoginPage = path;
        this._formLoginPath = path;
        if (this._formLoginPath.indexOf(63) > 0) {
            this._formLoginPath = this._formLoginPath.substring(0, this._formLoginPath.indexOf(63));
        }
    }

    private void setErrorPage(String path) {
        if (path == null || path.trim().length() == 0) {
            this._formErrorPath = null;
            this._formErrorPage = null;
        } else {
            if (!path.startsWith("/")) {
                LOG.warn("form-error-page must start with /", new Object[0]);
                path = "/" + path;
            }
            this._formErrorPage = path;
            this._formErrorPath = path;
            if (this._formErrorPath.indexOf(63) > 0) {
                this._formErrorPath = this._formErrorPath.substring(0, this._formErrorPath.indexOf(63));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthStatus validateRequest(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        HttpServletRequest request = (HttpServletRequest)messageInfo.getRequestMessage();
        HttpServletResponse response = (HttpServletResponse)messageInfo.getResponseMessage();
        String uri = request.getRequestURI();
        if (uri == null) {
            uri = "/";
        }
        boolean mandatory = this.isMandatory(messageInfo);
        HttpSession session = request.getSession(mandatory |= this.isJSecurityCheck(uri));
        if (!mandatory || this.isLoginOrErrorPage(URIUtil.addPaths((String)request.getServletPath(), (String)request.getPathInfo()))) {
            return AuthStatus.SUCCESS;
        }
        try {
            if (this.isJSecurityCheck(uri)) {
                String password;
                String username = request.getParameter(__J_USERNAME);
                boolean success = this.tryLogin(messageInfo, clientSubject, response, session, username, new Password(password = request.getParameter(__J_PASSWORD)));
                if (success) {
                    String nuri = null;
                    HttpSession httpSession = session;
                    synchronized (httpSession) {
                        nuri = (String)session.getAttribute(__J_URI);
                    }
                    if ((nuri == null || nuri.length() == 0) && (nuri = request.getContextPath()).length() == 0) {
                        nuri = "/";
                    }
                    response.setContentLength(0);
                    Request.getBaseRequest((ServletRequest)request).getResponse().sendRedirect(302, nuri, true);
                    return AuthStatus.SEND_CONTINUE;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Form authentication FAILED for " + StringUtil.printable((String)username), new Object[0]);
                }
                if (this._formErrorPage == null) {
                    if (response != null) {
                        response.sendError(403);
                    }
                } else {
                    response.setContentLength(0);
                    Request.getBaseRequest((ServletRequest)request).getResponse().sendRedirect(302, response.encodeRedirectURL(URIUtil.addPaths((String)request.getContextPath(), (String)this._formErrorPage)), true);
                }
                return AuthStatus.SEND_FAILURE;
            }
            SessionAuthentication sessionAuth = (SessionAuthentication)session.getAttribute("org.eclipse.jetty.security.UserIdentity");
            if (sessionAuth != null) {
                if (sessionAuth.getUserIdentity().getSubject() == null) {
                    return AuthStatus.SEND_FAILURE;
                }
                Set<Object> credentials = sessionAuth.getUserIdentity().getSubject().getPrivateCredentials();
                if (credentials == null || credentials.isEmpty()) {
                    return AuthStatus.SEND_FAILURE;
                }
                clientSubject.getPrivateCredentials().addAll(credentials);
                clientSubject.getPrivateCredentials().add(sessionAuth.getUserIdentity());
                return AuthStatus.SUCCESS;
            }
            if (DeferredAuthentication.isDeferred((HttpServletResponse)response)) {
                return AuthStatus.SUCCESS;
            }
            StringBuffer buf = request.getRequestURL();
            if (request.getQueryString() != null) {
                buf.append("?").append(request.getQueryString());
            }
            HttpSession httpSession = session;
            synchronized (httpSession) {
                session.setAttribute(__J_URI, (Object)buf.toString());
            }
            response.setContentLength(0);
            Request.getBaseRequest((ServletRequest)request).getResponse().sendRedirect(302, response.encodeRedirectURL(URIUtil.addPaths((String)request.getContextPath(), (String)this._formLoginPage)), true);
            return AuthStatus.SEND_CONTINUE;
        }
        catch (IOException | UnsupportedCallbackException e) {
            throw new AuthException(e.getMessage());
        }
    }

    public boolean isJSecurityCheck(String uri) {
        int jsc = uri.indexOf(__J_SECURITY_CHECK);
        if (jsc < 0) {
            return false;
        }
        int e = jsc + __J_SECURITY_CHECK.length();
        if (e == uri.length()) {
            return true;
        }
        char c = uri.charAt(e);
        return c == ';' || c == '#' || c == '/' || c == '?';
    }

    private boolean tryLogin(MessageInfo messageInfo, Subject clientSubject, HttpServletResponse response, HttpSession session, String username, Password password) throws AuthException, IOException, UnsupportedCallbackException {
        if (this.login(clientSubject, username, (Credential)password, "FORM", messageInfo)) {
            char[] pwdChars = password.toString().toCharArray();
            Set<LoginCallbackImpl> loginCallbacks = clientSubject.getPrivateCredentials(LoginCallbackImpl.class);
            if (!loginCallbacks.isEmpty()) {
                LoginCallbackImpl loginCallback = loginCallbacks.iterator().next();
                Set<UserIdentity> userIdentities = clientSubject.getPrivateCredentials(UserIdentity.class);
                if (!userIdentities.isEmpty()) {
                    UserIdentity userIdentity = userIdentities.iterator().next();
                    SessionAuthentication sessionAuth = new SessionAuthentication("FORM", userIdentity, (Object)password);
                    session.setAttribute("org.eclipse.jetty.security.UserIdentity", (Object)sessionAuth);
                }
            }
            return true;
        }
        return false;
    }

    public boolean isLoginOrErrorPage(String pathInContext) {
        return pathInContext != null && (pathInContext.equals(this._formErrorPath) || pathInContext.equals(this._formLoginPath));
    }
}

