/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.lang;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Numbers {
    private static final Logger LOG = LoggerFactory.getLogger(Numbers.class);

    private Numbers() {
    }

    public static Number getMinValue(Class<? extends Number> numberType) {
        Number result;
        if (Integer.class == numberType || Integer.TYPE == numberType) {
            result = Integer.MIN_VALUE;
        } else if (Long.class == numberType || Long.TYPE == numberType) {
            result = Long.MIN_VALUE;
        } else if (Float.class == numberType || Float.TYPE == numberType) {
            result = Float.valueOf(-3.4028235E38f);
        } else if (Double.class == numberType || Double.TYPE == numberType) {
            result = -1.7976931348623157E308;
        } else if (Byte.class == numberType || Byte.TYPE == numberType) {
            result = (byte)-128;
        } else if (Short.class == numberType || Short.TYPE == numberType) {
            result = (short)Short.MIN_VALUE;
        } else {
            LOG.debug("'{}' has no minimum value. Falling back to Double.", numberType);
            result = -1.7976931348623157E308;
        }
        return result;
    }

    public static Number getMaxValue(Class<? extends Number> numberType) {
        Number result;
        if (Integer.class == numberType || Integer.TYPE == numberType) {
            result = Integer.MAX_VALUE;
        } else if (Long.class == numberType || Long.TYPE == numberType) {
            result = Long.MAX_VALUE;
        } else if (Float.class == numberType || Float.TYPE == numberType) {
            result = Float.valueOf(Float.MAX_VALUE);
        } else if (Double.class == numberType || Double.TYPE == numberType) {
            result = Double.MAX_VALUE;
        } else if (Byte.class == numberType || Byte.TYPE == numberType) {
            result = (byte)127;
        } else if (Short.class == numberType || Short.TYPE == numberType) {
            result = (short)Short.MAX_VALUE;
        } else {
            LOG.debug("'{}' has no maximum value. Falling back to Double.MAX_VALUE.");
            result = Double.MAX_VALUE;
        }
        return result;
    }
}

