# This is a shell script that calls functions and scripts from
# tml@iki.fi's personal work envronment. It is not expected to be
# usable unmodified by others, and is included only for reference.

MOD=gtk+
VER=2.14.4
REV=1
ARCH=win64

THIS=${MOD}_${VER}-${REV}_${ARCH}

RUNZIP=${MOD}_${VER}-${REV}_${ARCH}.zip
DEVZIP=${MOD}-dev_${VER}-${REV}_${ARCH}.zip

HEX=`echo $THIS | md5sum | cut -d' ' -f1`
TARGET=c:/devel/target/$HEX

usehead
usemingw64
usemsvs9x64

(

set -x

DEPS=`latest --arch=${ARCH} glib atk cairo pango libpng zlib libtiff jpeg`
PROXY_LIBINTL=`latest --arch=${ARCH} proxy-libintl`


PKG_CONFIG_PATH=
for D in $DEPS; do
    [ -d /devel/dist/${ARCH}/$D/lib/pkgconfig ] && PKG_CONFIG_PATH=/devel/dist/${ARCH}/$D/lib/pkgconfig:$PKG_CONFIG_PATH
done

LIBPNG=`latest --arch=${ARCH} libpng`
ZLIB=`latest --arch=${ARCH} zlib`
LIBTIFF=`latest --arch=${ARCH} libtiff`
JPEG=`latest --arch=${ARCH} jpeg`

# Don't do any relinking crap in libtool.

sed -e 's/need_relink=yes/need_relink=no # no way --tml/' <ltmain.sh >ltmain.temp && mv ltmain.temp ltmain.sh

# Avoid using "file" in libtool. Otherwise libtool won't create a
# shared library, and give the warning "Trying to link with static lib
# archive [...] But I can only do this if you have shared version of
# the library, which you do not appear to have."

# I know what I am doing, I do want to link with a static
# libintl. (The proxy-libintl libintl wrapper.)

sed -e 's!file /!dont-want-to-use-file!' <configure >configure.temp && mv configure.temp configure

# Fix problems with libtool and Win64

sed -e 's!file format pe-i386!file format pe-!' <ltmain.sh >ltmain.sh.temp && mv ltmain.sh.temp ltmain.sh &&
sed -e 's!file_magic file format pei\*-i386!file_magic file format pei*-!' <configure >configure.temp && mv configure.temp configure &&

patch -p0 <<'EOF'
Index: ChangeLog
===================================================================
--- ChangeLog	(revision 21669)
+++ ChangeLog	(revision 21675)
@@ -1,3 +1,22 @@
+2008-10-18  Tor Lillqvist  <tml@novell.com>
+
+	* gdk/win32/gdkevents-win32.c (gdk_event_translate): On
+	WM_WINDOWPOSCHANGING, don't dereference windowpos in the debugging
+	output without setting it first.
+
+2008-10-18  Tor Lillqvist  <tml@novell.com>
+
+	Bug 556578 - GIMP windows stay on top of other windows
+
+	* gdk/win32/gdkevents-win32.c (ensure_stacking_on_unminimize)
+	(ensure_stacking_on_window_pos_changing)
+	(ensure_stacking_on_activate_app): Ignore unmapped windows in the
+	loops where we look for the lowest "transient-type" window.
+
+	(gdk_event_translate): Don't call
+	ensure_stacking_on_window_pos_changing() or
+	ensure_stacking_on_activate_app() for unmapped windows.
+
 2008-10-16  Matthias Clasen  <mclasen@redhat.com>
 
 	* === Released 2.14.4 ====
Index: gdk/win32/gdkevents-win32.c
===================================================================
--- gdk/win32/gdkevents-win32.c	(revision 21586)
+++ gdk/win32/gdkevents-win32.c	(revision 21675)
@@ -2116,9 +2116,10 @@
 	  GdkWindowImplWin32 *rover_impl =
 	    (GdkWindowImplWin32 *)((GdkWindowObject *)rover_gdkw)->impl;
 
-	  if (rover_impl->type_hint == GDK_WINDOW_TYPE_HINT_UTILITY ||
-	      rover_impl->type_hint == GDK_WINDOW_TYPE_HINT_DIALOG ||
-	      rover_impl->transient_owner != NULL)
+	  if (GDK_WINDOW_IS_MAPPED (rover_gdkw) &&
+	      (rover_impl->type_hint == GDK_WINDOW_TYPE_HINT_UTILITY ||
+	       rover_impl->type_hint == GDK_WINDOW_TYPE_HINT_DIALOG ||
+	       rover_impl->transient_owner != NULL))
 	    {
 	      lowest_transient = rover;
 	    }
@@ -2166,9 +2167,10 @@
 	      GdkWindowImplWin32 *rover_impl =
 		(GdkWindowImplWin32 *)((GdkWindowObject *)rover_gdkw)->impl;
 
-	      if (rover_impl->type_hint == GDK_WINDOW_TYPE_HINT_UTILITY ||
-		  rover_impl->type_hint == GDK_WINDOW_TYPE_HINT_DIALOG ||
-		  rover_impl->transient_owner != NULL)
+	      if (GDK_WINDOW_IS_MAPPED (rover_gdkw) &&
+		  (rover_impl->type_hint == GDK_WINDOW_TYPE_HINT_UTILITY ||
+		   rover_impl->type_hint == GDK_WINDOW_TYPE_HINT_DIALOG ||
+		   rover_impl->transient_owner != NULL))
 		{
 		  restacking = TRUE;
 		  windowpos->hwndInsertAfter = rover;
@@ -2222,9 +2224,10 @@
 	      GdkWindowImplWin32 *rover_impl =
 		(GdkWindowImplWin32 *)((GdkWindowObject *)rover_gdkw)->impl;
 
-	      if (rover_impl->type_hint == GDK_WINDOW_TYPE_HINT_UTILITY ||
-		  rover_impl->type_hint == GDK_WINDOW_TYPE_HINT_DIALOG ||
-		  rover_impl->transient_owner != NULL)
+	      if (GDK_WINDOW_IS_MAPPED (rover_gdkw) &&
+		  (rover_impl->type_hint == GDK_WINDOW_TYPE_HINT_UTILITY ||
+		   rover_impl->type_hint == GDK_WINDOW_TYPE_HINT_DIALOG ||
+		   rover_impl->transient_owner != NULL))
 		{
 		  GDK_NOTE (EVENTS, g_print (" restacking: %p", rover));
 		  SetWindowPos (msg->hwnd, rover, 0, 0, 0, 0,
@@ -3164,18 +3167,20 @@
       break;
 
     case WM_WINDOWPOSCHANGING:
-      GDK_NOTE (EVENTS, g_print (" %s %s %dx%d@%+d%+d now below %p",
-				 _gdk_win32_window_pos_bits_to_string (windowpos->flags),
-				 (windowpos->hwndInsertAfter == HWND_BOTTOM ? "BOTTOM" :
-				  (windowpos->hwndInsertAfter == HWND_NOTOPMOST ? "NOTOPMOST" :
-				   (windowpos->hwndInsertAfter == HWND_TOP ? "TOP" :
-				    (windowpos->hwndInsertAfter == HWND_TOPMOST ? "TOPMOST" :
-				     (sprintf (buf, "%p", windowpos->hwndInsertAfter),
-				      buf))))),
-				 windowpos->cx, windowpos->cy, windowpos->x, windowpos->y,
-				 GetNextWindow (msg->hwnd, GW_HWNDPREV)));
+      GDK_NOTE (EVENTS, (windowpos = (WINDOWPOS *) msg->lParam,
+			 g_print (" %s %s %dx%d@%+d%+d now below %p",
+				  _gdk_win32_window_pos_bits_to_string (windowpos->flags),
+				  (windowpos->hwndInsertAfter == HWND_BOTTOM ? "BOTTOM" :
+				   (windowpos->hwndInsertAfter == HWND_NOTOPMOST ? "NOTOPMOST" :
+				    (windowpos->hwndInsertAfter == HWND_TOP ? "TOP" :
+				     (windowpos->hwndInsertAfter == HWND_TOPMOST ? "TOPMOST" :
+				      (sprintf (buf, "%p", windowpos->hwndInsertAfter),
+				       buf))))),
+				  windowpos->cx, windowpos->cy, windowpos->x, windowpos->y,
+				  GetNextWindow (msg->hwnd, GW_HWNDPREV))));
 
-      return_val = ensure_stacking_on_window_pos_changing (msg, window);
+      if (GDK_WINDOW_IS_MAPPED (window))
+	return_val = ensure_stacking_on_window_pos_changing (msg, window);
       break;
 
     case WM_WINDOWPOSCHANGED:
@@ -3656,7 +3661,8 @@
 				 msg->wParam ? "YES" : "NO",
 				 (gint64) msg->lParam));
 
-      ensure_stacking_on_activate_app (msg, window);
+      if (GDK_WINDOW_IS_MAPPED (window))
+	ensure_stacking_on_activate_app (msg, window);
       break;
 
       /* Handle WINTAB events here, as we know that gdkinput.c will
EOF

CC='x86_64-pc-mingw32-gcc' CPPFLAGS="-I/devel/dist/${ARCH}/${LIBPNG}/include -I/devel/dist/${ARCH}/${ZLIB}/include -I/devel/dist/${ARCH}/${LIBTIFF}/include -I/devel/dist/${ARCH}/${JPEG}/include -I/devel/dist/${ARCH}/${PROXY_LIBINTL}/include" LDFLAGS="-L/devel/dist/${ARCH}/${LIBPNG}/lib -L/devel/dist/${ARCH}/${ZLIB}/lib -L/devel/dist/${ARCH}/${LIBTIFF}/lib -L/devel/dist/${ARCH}/${JPEG}/lib -L/devel/dist/${ARCH}/${PROXY_LIBINTL}/lib -Wl,--exclude-libs=libintl.a -Wl,--enable-auto-image-base" LIBS=-lintl CFLAGS=-O2 ./configure --host=x86_64-pc-mingw32 --with-gdktarget=win32 --disable-gdiplus --with-included-loaders --with-included-immodules --without-libjasper --enable-debug=yes --enable-explicit-deps=no --disable-gtk-doc --disable-static --prefix=$TARGET &&
libtoolcacheize &&
rm gtk/gtk.def &&
(make -j3 install || (rm .libtool-cache* && make -j3 install)) &&

./gtk-zip.sh &&

mv /tmp/${MOD}-${VER}.zip /tmp/$RUNZIP &&
mv /tmp/${MOD}-dev-${VER}.zip /tmp/$DEVZIP

) 2>&1 | tee /devel/src/tml/make/$THIS.log

(cd /devel && zip /tmp/$DEVZIP src/tml/make/$THIS.{sh,log}) &&
manifestify /tmp/$RUNZIP /tmp/$DEVZIP
