// Code generated by go-swagger; DO NOT EDIT.

// Copyright Authors of Cilium
// SPDX-License-Identifier: Apache-2.0

package endpoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// DeleteEndpointReader is a Reader for the DeleteEndpoint structure.
type DeleteEndpointReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DeleteEndpointReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDeleteEndpointOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 206:
		result := NewDeleteEndpointErrors()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewDeleteEndpointInvalid()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewDeleteEndpointNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewDeleteEndpointTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewDeleteEndpointOK creates a DeleteEndpointOK with default headers values
func NewDeleteEndpointOK() *DeleteEndpointOK {
	return &DeleteEndpointOK{}
}

/*
DeleteEndpointOK describes a response with status code 200, with default header values.

Success
*/
type DeleteEndpointOK struct {
}

// IsSuccess returns true when this delete endpoint o k response has a 2xx status code
func (o *DeleteEndpointOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this delete endpoint o k response has a 3xx status code
func (o *DeleteEndpointOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete endpoint o k response has a 4xx status code
func (o *DeleteEndpointOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete endpoint o k response has a 5xx status code
func (o *DeleteEndpointOK) IsServerError() bool {
	return false
}

// IsCode returns true when this delete endpoint o k response a status code equal to that given
func (o *DeleteEndpointOK) IsCode(code int) bool {
	return code == 200
}

func (o *DeleteEndpointOK) Error() string {
	return fmt.Sprintf("[DELETE /endpoint][%d] deleteEndpointOK ", 200)
}

func (o *DeleteEndpointOK) String() string {
	return fmt.Sprintf("[DELETE /endpoint][%d] deleteEndpointOK ", 200)
}

func (o *DeleteEndpointOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewDeleteEndpointErrors creates a DeleteEndpointErrors with default headers values
func NewDeleteEndpointErrors() *DeleteEndpointErrors {
	return &DeleteEndpointErrors{}
}

/*
DeleteEndpointErrors describes a response with status code 206, with default header values.

Deleted with a number of errors encountered
*/
type DeleteEndpointErrors struct {
	Payload int64
}

// IsSuccess returns true when this delete endpoint errors response has a 2xx status code
func (o *DeleteEndpointErrors) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this delete endpoint errors response has a 3xx status code
func (o *DeleteEndpointErrors) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete endpoint errors response has a 4xx status code
func (o *DeleteEndpointErrors) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete endpoint errors response has a 5xx status code
func (o *DeleteEndpointErrors) IsServerError() bool {
	return false
}

// IsCode returns true when this delete endpoint errors response a status code equal to that given
func (o *DeleteEndpointErrors) IsCode(code int) bool {
	return code == 206
}

func (o *DeleteEndpointErrors) Error() string {
	return fmt.Sprintf("[DELETE /endpoint][%d] deleteEndpointErrors  %+v", 206, o.Payload)
}

func (o *DeleteEndpointErrors) String() string {
	return fmt.Sprintf("[DELETE /endpoint][%d] deleteEndpointErrors  %+v", 206, o.Payload)
}

func (o *DeleteEndpointErrors) GetPayload() int64 {
	return o.Payload
}

func (o *DeleteEndpointErrors) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteEndpointInvalid creates a DeleteEndpointInvalid with default headers values
func NewDeleteEndpointInvalid() *DeleteEndpointInvalid {
	return &DeleteEndpointInvalid{}
}

/*
DeleteEndpointInvalid describes a response with status code 400, with default header values.

Invalid endpoint delete request
*/
type DeleteEndpointInvalid struct {
}

// IsSuccess returns true when this delete endpoint invalid response has a 2xx status code
func (o *DeleteEndpointInvalid) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete endpoint invalid response has a 3xx status code
func (o *DeleteEndpointInvalid) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete endpoint invalid response has a 4xx status code
func (o *DeleteEndpointInvalid) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete endpoint invalid response has a 5xx status code
func (o *DeleteEndpointInvalid) IsServerError() bool {
	return false
}

// IsCode returns true when this delete endpoint invalid response a status code equal to that given
func (o *DeleteEndpointInvalid) IsCode(code int) bool {
	return code == 400
}

func (o *DeleteEndpointInvalid) Error() string {
	return fmt.Sprintf("[DELETE /endpoint][%d] deleteEndpointInvalid ", 400)
}

func (o *DeleteEndpointInvalid) String() string {
	return fmt.Sprintf("[DELETE /endpoint][%d] deleteEndpointInvalid ", 400)
}

func (o *DeleteEndpointInvalid) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewDeleteEndpointNotFound creates a DeleteEndpointNotFound with default headers values
func NewDeleteEndpointNotFound() *DeleteEndpointNotFound {
	return &DeleteEndpointNotFound{}
}

/*
DeleteEndpointNotFound describes a response with status code 404, with default header values.

No endpoints with provided parameters found
*/
type DeleteEndpointNotFound struct {
}

// IsSuccess returns true when this delete endpoint not found response has a 2xx status code
func (o *DeleteEndpointNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete endpoint not found response has a 3xx status code
func (o *DeleteEndpointNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete endpoint not found response has a 4xx status code
func (o *DeleteEndpointNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete endpoint not found response has a 5xx status code
func (o *DeleteEndpointNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this delete endpoint not found response a status code equal to that given
func (o *DeleteEndpointNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *DeleteEndpointNotFound) Error() string {
	return fmt.Sprintf("[DELETE /endpoint][%d] deleteEndpointNotFound ", 404)
}

func (o *DeleteEndpointNotFound) String() string {
	return fmt.Sprintf("[DELETE /endpoint][%d] deleteEndpointNotFound ", 404)
}

func (o *DeleteEndpointNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewDeleteEndpointTooManyRequests creates a DeleteEndpointTooManyRequests with default headers values
func NewDeleteEndpointTooManyRequests() *DeleteEndpointTooManyRequests {
	return &DeleteEndpointTooManyRequests{}
}

/*
DeleteEndpointTooManyRequests describes a response with status code 429, with default header values.

Rate-limiting too many requests in the given time frame
*/
type DeleteEndpointTooManyRequests struct {
}

// IsSuccess returns true when this delete endpoint too many requests response has a 2xx status code
func (o *DeleteEndpointTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete endpoint too many requests response has a 3xx status code
func (o *DeleteEndpointTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete endpoint too many requests response has a 4xx status code
func (o *DeleteEndpointTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete endpoint too many requests response has a 5xx status code
func (o *DeleteEndpointTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this delete endpoint too many requests response a status code equal to that given
func (o *DeleteEndpointTooManyRequests) IsCode(code int) bool {
	return code == 429
}

func (o *DeleteEndpointTooManyRequests) Error() string {
	return fmt.Sprintf("[DELETE /endpoint][%d] deleteEndpointTooManyRequests ", 429)
}

func (o *DeleteEndpointTooManyRequests) String() string {
	return fmt.Sprintf("[DELETE /endpoint][%d] deleteEndpointTooManyRequests ", 429)
}

func (o *DeleteEndpointTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}
