10 December 2018

#### Advertising Kubernetes Service ClusterIPs

With Calico v3.4, you can [configure Calico to advertise Kubernetes Service ClusterIPs over BGP](https://docs.projectcalico.org/v3.4/usage/service-advertisement).  If you have peered Calico with your own BGP fabric, this allows external hosts to reach Kubernetes services at their ClusterIP.

Github PR: [calico #2303](https://github.com/projectcalico/calico/pull/2303) (@neiljerram)

#### Support for the Azure vnet IPAM plugin

The v3.4 CNI plugin adds [support for the Azure vnet IPAM plugin](https://docs.projectcalico.org/v3.4/reference/public-cloud/azure). This makes it easier to deploy Calico in conjunction with Azure networking.

Github PR: [cni-plugin #626](https://github.com/projectcalico/cni-plugin/pull/626) (@caseydavenport)

#### Host `*` endpoints

Calico v3.4 has support for [a new type of HostEndpoint](https://docs.projectcalico.org/v3.4/reference/calicoctl/resources/hostendpoint) that allows you to protect the whole host rather than a specific interface.  In this release, only pre-DNAT policy is supported, which is suitable for securing Kubernetes NodePorts from all interfaces (and even from local pods).

Github PR: [calico #2232](https://github.com/projectcalico/calico/pull/2232) (@neiljerram)

#### Bug fixes

 - To avoid collisions, which can cause graceful restart to fail, Calico now marks one peer in each node-to-node mesh peering as passive.  Passive nodes will listen for inbound BGP connections but will not initiate outbound BGP connections. [node #79](https://github.com/projectcalico/node/pull/79) (@fasaxc)

#### Other changes

 - For ease of deployment the RBAC manifest has been removed. It is now combined with the main Calico manifest.  Any install scripts that rely on installing the RBAC manifest will need to be updated. [calico #2234](https://github.com/projectcalico/calico/pull/2234) (@caseydavenport)
 - Typha now has a PodDisruptionBudget for compatibility with the cluster autoscaler. [calico #2235](https://github.com/projectcalico/calico/pull/2235) (@markfermor)
 - The CNI plugin is now installed using a Kubernetes init container rather than a long-lived sidecar. [calico #2231](https://github.com/projectcalico/calico/pull/2231) (@caseydavenport)
 - etcd manifests now install CNI plugins and config using an init container [calico #2300](https://github.com/projectcalico/calico/pull/2300) (@caseydavenport)
