/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.Global;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.DisplayedText;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.output.EDIFEquiv;
import com.sun.electric.tool.io.output.Topology;
import com.sun.electric.tool.user.User;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EDIF
extends Topology {
    private static final boolean ADD_RIPPERS = true;
    private static final EGraphic EGUNKNOWN = new EGraphic("UNKNOWN");
    private static final EGraphic EGART = new EGraphic("ARTWORK");
    private static final EGraphic EGWIRE = new EGraphic("WIRE");
    private static final EGraphic EGBUS = new EGraphic("BUS");
    private EGraphic egraphic = EGUNKNOWN;
    private EGraphic egraphic_override = EGUNKNOWN;
    private static final String primitivesLibName = "ELECTRIC_PRIMS";
    private int scale = 20;
    EDIFEquiv equivs;
    private final HashMap<Library, LibToWrite> libsToWrite;
    private final List<Library> libsToWriteOrder;
    private static final Pattern atPat = Pattern.compile("@(\\w+)");
    private static final Pattern pPat = Pattern.compile("(P|PAR)\\(\"(\\w+)\"\\)");
    private static final Pattern pparPat = Pattern.compile("(pPar|iPar|atPar|dotPar|_Par)\\(\"(\\w+)\"\\)");
    private static final Pattern bPat = Pattern.compile("\\[([~+.@])(\\w+)\\]");
    private static DecimalFormat decimalFormatScientific = null;
    private int blkstack_ptr;
    private String[] blkstack = new String[50];

    public static void writeEDIFFile(Cell cell, VarContext context, String filePath) {
        EDIF out = new EDIF();
        if (out.openTextOutputStream(filePath)) {
            return;
        }
        if (out.writeCell(cell, context)) {
            return;
        }
        if (out.closeTextOutputStream()) {
            return;
        }
        System.out.println(filePath + " written");
    }

    EDIF() {
        this.libsToWrite = new HashMap();
        this.libsToWriteOrder = new ArrayList<Library>();
        this.equivs = new EDIFEquiv();
    }

    @Override
    protected void start() {
        if (this.topCell.getView() == View.LAYOUT) {
            int rgrid = 660;
            double route = rgrid / 100;
            System.out.println("Writing footprint for cell " + this.makeToken(this.topCell.getName()));
            this.printWriter.println("(footprint " + TextUtils.formatDouble(route) + "e-06");
            this.printWriter.println(" (unknownLayoutRep");
            ERectangle cellBounds = this.topCell.getBounds();
            double width = ((RectangularShape)cellBounds).getWidth() / (double)rgrid;
            double height = ((RectangularShape)cellBounds).getHeight() / (double)rgrid;
            this.printWriter.println("  (" + this.makeToken(this.topCell.getName()) + " standard (" + TextUtils.formatDouble(height) + " " + TextUtils.formatDouble(width) + ")");
            this.printWriter.println(")))");
            return;
        }
        String header = "Electric VLSI Design System";
        if (User.isIncludeDateAndVersionInOutput()) {
            header = header + ", version " + Version.getVersion();
        }
        this.writeHeader(this.topCell, header, "EDIF Writer", this.topCell.getLibrary().getName());
        this.blockOpen("library");
        this.blockPutIdentifier(primitivesLibName);
        this.blockPut("edifLevel", "0");
        this.blockOpen("technology");
        this.blockOpen("numberDefinition");
        if (IOTool.isEDIFUseSchematicView()) {
            this.writeScale(Technology.getCurrent());
        }
        this.blockClose("numberDefinition");
        if (IOTool.isEDIFUseSchematicView()) {
            this.writeFigureGroup(EGART);
            this.writeFigureGroup(EGWIRE);
            this.writeFigureGroup(EGBUS);
        }
        this.blockClose("technology");
        HashMap<Object, PrimitiveNode> primsFound = new HashMap<Object, PrimitiveNode>();
        this.writeAllPrims(this.topCell, primsFound);
        this.blockClose("library");
        HashSet<Integer> rippers = new HashSet<Integer>();
        this.countRippers(this.topCell, rippers);
        if (rippers.size() > 0) {
            this.blockOpen("library");
            this.blockPutIdentifier("cdsRipLib");
            this.blockPut("edifLevel", "0");
            this.blockOpen("technology");
            this.blockOpen("numberDefinition");
            if (IOTool.isEDIFUseSchematicView()) {
                this.writeScale(Technology.getCurrent());
            }
            this.blockClose("numberDefinition");
            this.blockClose("technology");
        }
        for (Integer width : rippers) {
            this.blockOpen("cell");
            this.blockPutIdentifier("ripper_" + width);
            this.blockPut("cellType", "RIPPER");
            this.blockOpen("view");
            this.blockPutIdentifier("symbol");
            this.blockPut("viewType", IOTool.isEDIFUseSchematicView() ? "SCHEMATIC" : "NETLIST");
            this.blockOpen("interface");
            this.blockOpen("port");
            this.blockOpen("array");
            this.blockPutIdentifier("dst_0");
            this.blockPutIdentifier(width.toString());
            this.blockClose("array");
            this.blockClose("port");
            this.blockOpen("port");
            this.blockOpen("array");
            this.blockPutIdentifier("src");
            this.blockPutIdentifier(width.toString());
            this.blockClose("array");
            this.blockClose("port");
            this.blockOpen("joined");
            this.blockPut("portRef", "dst_0");
            this.blockPut("portRef", "src");
            this.blockClose("joined");
            this.blockOpen("symbol");
            this.blockOpen("figure");
            this.blockPutIdentifier("wire");
            this.blockOpen("circle");
            this.blockOpen("pt");
            this.blockPutIdentifier("-5");
            this.blockPutIdentifier("0");
            this.blockClose("pt");
            this.blockOpen("pt");
            this.blockPutIdentifier("5");
            this.blockPutIdentifier("0");
            this.blockClose("pt");
            this.blockClose("circle");
            this.blockClose("figure");
            this.blockOpen("portImplementation");
            this.blockPutIdentifier("dst_0");
            this.blockOpen("connectLocation");
            this.blockOpen("figure");
            this.blockPutIdentifier("pin");
            this.blockOpen("dot");
            this.writePoint(0.0, 0.0);
            this.blockClose("dot");
            this.blockClose("figure");
            this.blockClose("connectLocation");
            this.blockClose("portImplementation");
            this.blockOpen("portImplementation");
            this.blockPutIdentifier("src");
            this.blockOpen("connectLocation");
            this.blockOpen("figure");
            this.blockPutIdentifier("pin");
            this.blockOpen("dot");
            this.writePoint(0.0, 0.0);
            this.blockClose("dot");
            this.blockClose("figure");
            this.blockClose("connectLocation");
            this.blockClose("portImplementation");
            this.blockClose("symbol");
            this.blockClose("interface");
            this.blockClose("view");
            this.blockClose("cell");
        }
        if (rippers.size() > 0) {
            this.blockClose("library");
        }
        ArrayList<String> libs = new ArrayList<String>();
        for (EDIFEquiv.NodeEquivalence e : this.equivs.getNodeEquivs()) {
            if (libs.contains(e.externalLib)) continue;
            libs.add(e.externalLib);
        }
        for (String lib : libs) {
            this.blockOpen("external");
            this.blockPutIdentifier(lib);
            this.blockPut("edifLevel", "0");
            this.blockOpen("technology");
            this.blockOpen("numberDefinition");
            if (IOTool.isEDIFUseSchematicView()) {
                this.writeScale(Technology.getCurrent());
            }
            this.blockClose("technology");
            for (EDIFEquiv.NodeEquivalence e : this.equivs.getNodeEquivs()) {
                if (!lib.equals(e.externalLib)) continue;
                String viewType = null;
                if (e.exortedType != null) {
                    viewType = "GRAPHIC";
                }
                this.writeExternalDef(e.externalCell, e.externalView, viewType, e.getExtPorts());
            }
            this.blockClose("external");
        }
    }

    @Override
    protected void writeCellTopology(Cell cell, Topology.CellNetInfo cni, VarContext context, Topology.MyCellInfo info) {
        Library lib = cell.getLibrary();
        LibToWrite l = this.libsToWrite.get(lib);
        if (l == null) {
            l = new LibToWrite(lib);
            this.libsToWrite.put(lib, l);
            this.libsToWriteOrder.add(lib);
        }
        l.add(new CellToWrite(cell, cni, context));
    }

    @Override
    protected void done() {
        for (Library lib : this.libsToWriteOrder) {
            LibToWrite l = this.libsToWrite.get(lib);
            this.blockOpen("library");
            this.blockPutIdentifier(this.makeToken(lib.getName()));
            this.blockPut("edifLevel", "0");
            this.blockOpen("technology");
            this.blockOpen("numberDefinition", false);
            if (IOTool.isEDIFUseSchematicView()) {
                this.writeScale(Technology.getCurrent());
            }
            this.blockClose("numberDefinition");
            if (IOTool.isEDIFUseSchematicView()) {
                this.writeFigureGroup(EGART);
                this.writeFigureGroup(EGWIRE);
                this.writeFigureGroup(EGBUS);
            }
            this.blockClose("technology");
            Iterator it2 = l.getCells();
            while (it2.hasNext()) {
                CellToWrite c = (CellToWrite)it2.next();
                this.writeCellEdif(c.cell, c.cni, c.context);
            }
            this.blockClose("library");
        }
        this.blockOpen("design");
        this.blockPutIdentifier(this.makeToken(this.topCell.getName()));
        this.blockOpen("cellRef");
        this.blockPutIdentifier(this.makeToken(this.topCell.getName()));
        this.blockPut("libraryRef", this.makeToken(this.topCell.getLibrary().getName()));
        this.blockFinish();
    }

    private void writeCellEdif(Cell cell, Topology.CellNetInfo cni, VarContext context) {
        NodeInst ni;
        Topology.CellSignal cs;
        this.blockOpen("cell");
        this.blockPutIdentifier(this.makeToken(cell.getName()));
        this.blockPut("cellType", "generic");
        this.blockOpen("view");
        this.blockPutIdentifier("symbol");
        this.blockPut("viewType", IOTool.isEDIFUseSchematicView() ? "SCHEMATIC" : "NETLIST");
        this.blockOpen("interface");
        Netlist netList = cni.getNetList();
        HashMap<Export, String> busExports = new HashMap<Export, String>();
        Iterator<Object> it = cni.getCellSignals();
        while (it.hasNext()) {
            int busWidth;
            cs = it.next();
            if (!cs.isExported()) continue;
            Export e = cs.getExport();
            String direction = "INPUT";
            if (e.getCharacteristic() == PortCharacteristic.OUT || e.getCharacteristic() == PortCharacteristic.REFOUT) {
                direction = "OUTPUT";
            }
            if (e.getCharacteristic() == PortCharacteristic.BIDIR) {
                direction = "INOUT";
            }
            if ((busWidth = netList.getBusWidth(e)) > 1) {
                if (busExports.get(e) != null) continue;
                this.blockOpen("port");
                this.blockOpen("array");
                String eBusName = this.convertBusName(e.getName(), netList, e);
                String busName = this.makeToken(eBusName);
                busExports.put(e, busName);
                this.blockOpen("rename");
                this.blockPutIdentifier(busName);
                this.blockPutString(eBusName);
                this.blockClose("rename");
                this.blockPutIdentifier(Integer.toString(busWidth));
                this.blockClose("array");
                this.blockPut("direction", direction);
                this.blockClose("port");
                continue;
            }
            this.blockOpen("port");
            this.blockPutIdentifier(this.makeToken(cs.getName()));
            this.blockPut("direction", direction);
            this.blockClose("port");
        }
        if (IOTool.isEDIFUseSchematicView()) {
            it = cell.getParametersAndVariables();
            while (it.hasNext()) {
                Variable var = (Variable)it.next();
                if (var.getTrueName().equals("prototype_center")) continue;
                this.blockOpen("property");
                String name = var.getTrueName();
                String name2 = EDIF.makeValidName(name);
                if (!name.equals(name2)) {
                    this.blockOpen("rename", false);
                    this.blockPutIdentifier(name2);
                    this.blockPutString(name);
                    this.blockClose("rename");
                } else {
                    this.blockPutIdentifier(name);
                }
                this.blockOpen("string", false);
                String value = var.getObject().toString();
                value = value.replaceAll("\"", "%34%");
                this.blockPutString(value);
                this.blockClose("string");
                if (!var.isAttribute()) {
                    this.blockOpen("owner", false);
                    this.blockPutString("Electric");
                }
                this.blockClose("property");
            }
            this.writeSymbol(cell);
        }
        this.blockClose("interface");
        this.blockOpen("contents");
        if (IOTool.isEDIFUseSchematicView()) {
            this.blockOpen("page");
            this.blockPutIdentifier("SH1");
        }
        int splitterIndex = 1;
        Iterator<Geometric> it2 = cell.getNodes();
        while (it2.hasNext()) {
            PrimitiveNode.Function fun;
            NodeInst ni2 = it2.next();
            if (ni2.isCellInstance() || this.equivs.getNodeEquivalence(ni2) != null || (fun = ni2.getFunction()) != PrimitiveNode.Function.PIN) continue;
            ArcInst busFound = null;
            Iterator<Connection> cIt = ni2.getConnections();
            while (cIt.hasNext()) {
                Connection con = cIt.next();
                ArcInst ai = con.getArc();
                int width = netList.getBusWidth(ai);
                if (width <= 1) continue;
                busFound = ai;
            }
            if (busFound == null) continue;
            int busWidth = netList.getBusWidth(busFound);
            Iterator<Connection> cIt2 = ni2.getConnections();
            while (cIt2.hasNext()) {
                Connection con = cIt2.next();
                ArcInst ai = con.getArc();
                int width = netList.getBusWidth(ai);
                if (width >= 2) continue;
                Network net = netList.getNetwork(ai, 0);
                int busIndex = 0;
                for (int i = 0; i < busWidth; ++i) {
                    Network busNet = netList.getNetwork(busFound, i);
                    if (busNet != net) continue;
                    busIndex = i;
                    break;
                }
                BusRipper.makeBusRipper(ni2, net, busWidth, busIndex, splitterIndex, netList.getBusName(busFound).toString());
                this.blockOpen("instance");
                String splitterName = "splitter_" + splitterIndex;
                ++splitterIndex;
                this.blockPutIdentifier(splitterName);
                this.blockOpen("viewRef");
                this.blockPutIdentifier("symbol");
                this.blockOpen("cellRef");
                this.blockPutIdentifier("ripper_" + busWidth);
                this.blockPut("libraryRef", "cdsRipLib");
                this.blockClose("cellRef");
                this.blockClose("viewRef");
                this.blockOpen("transform");
                this.blockOpen("origin");
                this.writePoint(ni2.getAnchorCenterX(), ni2.getAnchorCenterY());
                this.blockClose("origin");
                this.blockClose("transform");
                this.blockClose("instance");
            }
        }
        Iterator<NodeInst> nIt = cell.getNodes();
        while (nIt.hasNext()) {
            NodeInst no = nIt.next();
            if (no.isCellInstance()) {
                Cell c = (Cell)no.getProto();
                if (cell.iconView() == c) continue;
            }
            if (!no.isCellInstance()) {
                PrimitiveNode.Function fun = no.getFunction();
                Variable var = no.getVar(Artwork.ART_MESSAGE);
                if (var != null) {
                    String s;
                    this.blockOpen("commentGraphics");
                    this.blockOpen("annotate", false);
                    Point2D.Double point = new Point2D.Double(no.getAnchorCenterX(), no.getAnchorCenterY());
                    Poly p = new Poly(new Point2D[]{point});
                    if (var.getObject() instanceof String[]) {
                        String[] lines = (String[])var.getObject();
                        StringBuffer sbuf = new StringBuffer();
                        for (int i = 0; i < lines.length; ++i) {
                            sbuf.append(lines[i]);
                            if (i == lines.length - 1) continue;
                            sbuf.append("%10%");
                        }
                        s = sbuf.toString();
                    } else {
                        s = var.getObject().toString();
                    }
                    p.setString(s);
                    p.setTextDescriptor(var.getTextDescriptor());
                    p.setStyle(var.getTextDescriptor().getPos().getPolyType());
                    this.writeSymbolPoly(p, null, 1.0);
                    this.blockClose("commentGraphics");
                    continue;
                }
                if (fun == PrimitiveNode.Function.UNKNOWN || fun == PrimitiveNode.Function.PIN || fun == PrimitiveNode.Function.CONTACT || fun == PrimitiveNode.Function.NODE || fun == PrimitiveNode.Function.ART) continue;
            }
            String iname = this.makeComponentName(no);
            String oname = no.getName();
            String refLib = "?";
            String refCell = "?";
            String refView = "symbol";
            int addedRotation = 0;
            boolean openedPortImplementation = false;
            EDIFEquiv.NodeEquivalence ne = this.equivs.getNodeEquivalence(no);
            if (ne != null) {
                Iterator<Export> eit;
                addedRotation = ne.rotation * 10;
                refLib = ne.externalLib;
                refCell = ne.externalCell;
                if (ne.exortedType != null && (eit = no.getExports()).hasNext()) {
                    Export e = eit.next();
                    oname = e.getName();
                    this.writePortImplementation(e, false);
                    openedPortImplementation = true;
                }
            } else if (!no.isCellInstance()) {
                ni = no;
                PrimitiveNode.Function fun = ni.getFunction();
                refLib = primitivesLibName;
                if (fun == PrimitiveNode.Function.GATEAND || fun == PrimitiveNode.Function.GATEOR || fun == PrimitiveNode.Function.GATEXOR) {
                    int i = 0;
                    Iterator<Connection> pIt = ni.getConnections();
                    while (pIt.hasNext()) {
                        Connection con = pIt.next();
                        if (!con.getPortInst().getPortProto().getName().equals("a")) continue;
                        ++i;
                    }
                    refCell = this.makeToken(ni.getProto().getName()) + i;
                } else {
                    refCell = this.describePrimitive(ni, fun);
                }
            } else {
                Cell np = (Cell)no.getProto();
                refLib = np.getLibrary().getName();
                refCell = this.makeToken(no.getProto().getName());
            }
            this.blockOpen("instance");
            if (!oname.equalsIgnoreCase(iname)) {
                this.blockOpen("rename", false);
                this.blockPutIdentifier(iname);
                this.blockPutString(oname);
                this.blockClose("rename");
            } else {
                this.blockPutIdentifier(iname);
            }
            this.blockOpen("viewRef");
            this.blockPutIdentifier(refView);
            this.blockOpen("cellRef", false);
            this.blockPutIdentifier(refCell);
            this.blockPut("libraryRef", refLib);
            this.blockClose("viewRef");
            if (IOTool.isEDIFUseSchematicView()) {
                ni = no;
                this.blockOpen("transform");
                this.blockPut("orientation", EDIF.getOrientation(ni, addedRotation));
                this.blockOpen("origin");
                double cX = ni.getAnchorCenterX();
                double cY = ni.getAnchorCenterY();
                Point2D.Double pt = new Point2D.Double(cX, cY);
                this.writePoint(((Point2D)pt).getX(), ((Point2D)pt).getY());
                this.blockClose("transform");
            }
            if (IOTool.isEDIFUseSchematicView()) {
                ni = no;
                Poly[] varPolys = ni.getDisplayableVariables(ni.getBounds(), null, false);
                this.writeDisplayableVariables(varPolys, ni.rotateOut());
            }
            this.blockClose("instance");
            if (!openedPortImplementation) continue;
            this.blockClose("portImplementation");
        }
        Iterator<Topology.CellSignal> it22 = cni.getCellSignals();
        while (it22.hasNext()) {
            Export e;
            cs = it22.next();
            String netName = cs.getNetwork().describe(false);
            if (netName.length() == 0) continue;
            boolean globalport = false;
            this.blockOpen("net");
            netName = cs.getName();
            String eName = this.makeToken(netName);
            if (globalport) {
                this.blockOpen("rename");
                this.blockPutIdentifier(eName);
                this.blockPutString(eName + "!");
                this.blockClose("rename");
                this.blockPut("property", "GLOBAL");
            } else {
                EDIFEquiv.GlobalEquivalence ge = this.equivs.getElectricGlobalEquivalence(netName);
                if (ge != null) {
                    netName = ge.externGName;
                }
                if (!eName.equals(netName)) {
                    this.blockOpen("rename");
                    this.blockPutIdentifier(eName);
                    this.blockPutString(netName);
                    this.blockClose("rename");
                } else {
                    this.blockPutIdentifier(eName);
                }
            }
            this.blockOpen("joined");
            if (cs.isExported() && netList.getBusWidth(e = cs.getExport()) <= 1) {
                String pt = e.getName();
                this.blockPut("portRef", this.makeToken(pt));
            }
            Network net = cs.getNetwork();
            Iterator<Nodable> nIt2 = netList.getNodables();
            while (nIt2.hasNext()) {
                EDIFEquiv.PortEquivalence pe;
                String portName;
                BusRipper br;
                Nodable no = nIt2.next();
                NodeProto niProto = no.getProto();
                if (no instanceof NodeInst && (br = BusRipper.findBusRipper((NodeInst)no, net)) != null) {
                    this.blockOpen("portRef");
                    this.blockOpen("member");
                    this.blockPutIdentifier("dst_0");
                    this.blockPutIdentifier(Integer.toString(br.getBusIndex()));
                    this.blockClose("member");
                    this.blockOpen("instanceRef");
                    this.blockPutIdentifier("splitter_" + br.getSplitterIndex());
                    this.blockClose("instanceRef");
                    this.blockClose("portRef");
                }
                EDIFEquiv.NodeEquivalence ne = this.equivs.getNodeEquivalence(no.getNodeInst());
                if (niProto instanceof Cell) {
                    String nodeName = this.parameterizedName(no, context);
                    Topology.CellNetInfo subCni = this.getCellNetInfo(nodeName);
                    Iterator<Topology.CellSignal> sIt = subCni.getCellSignals();
                    while (sIt.hasNext()) {
                        Network subNet;
                        Topology.CellSignal subCs = sIt.next();
                        Export subPp = subCs.getExport();
                        if (subPp == null || cs != cni.getCellSignal(subNet = netList.getNetwork(no, subPp, subCs.getExportIndex()))) continue;
                        portName = subCs.getName();
                        if (ne != null) {
                            pe = ne.getPortEquivElec(portName);
                            if (pe == null) {
                                System.out.println("Error: no equivalent port found for '" + portName + "' on node " + niProto.describe(false));
                                System.out.println("     Equivalence class: ");
                                System.out.println(ne.toString());
                                continue;
                            }
                            if (pe.getExtPort().ignorePort) continue;
                            this.blockOpen("portRef");
                            portName = pe.getExtPort().name;
                            this.blockPutIdentifier(this.makeToken(portName));
                            this.blockPut("instanceRef", this.makeComponentName(no));
                            this.blockClose("portRef");
                            continue;
                        }
                        this.blockOpen("portRef");
                        this.blockPutIdentifier(this.makeToken(portName));
                        this.blockPut("instanceRef", this.makeComponentName(no));
                        this.blockClose("portRef");
                    }
                    continue;
                }
                ni = (NodeInst)no;
                PrimitiveNode.Function fun = ni.getFunction();
                if (fun == PrimitiveNode.Function.UNKNOWN || fun == PrimitiveNode.Function.PIN || fun == PrimitiveNode.Function.CONTACT || fun == PrimitiveNode.Function.NODE || fun == PrimitiveNode.Function.ART) continue;
                Iterator<Connection> cIt = ni.getConnections();
                while (cIt.hasNext()) {
                    Connection con = cIt.next();
                    ArcInst ai = con.getArc();
                    Network aNet = netList.getNetwork(ai, 0);
                    if (aNet != net) continue;
                    portName = con.getPortInst().getPortProto().getName();
                    if (ne != null) {
                        pe = ne.getPortEquivElec(portName);
                        if (pe == null) {
                            System.out.println("Error: no equivalent port found for '" + portName + "' on node " + niProto.describe(false));
                            System.out.println("     Equivalence class: ");
                            System.out.println(ne.toString());
                            continue;
                        }
                        if (pe.getExtPort().ignorePort) continue;
                        this.blockOpen("portRef");
                        portName = pe.getExtPort().name;
                        String safeName = EDIF.makeValidName(portName);
                        if (!safeName.equals(portName)) {
                            this.blockPutIdentifier(this.makeToken(safeName));
                        } else {
                            this.blockPutIdentifier(this.makeToken(portName));
                        }
                        this.blockPut("instanceRef", this.makeComponentName(no));
                        this.blockClose("portRef");
                        continue;
                    }
                    this.blockOpen("portRef");
                    this.blockPutIdentifier(this.makeToken(portName));
                    this.blockPut("instanceRef", this.makeComponentName(no));
                    this.blockClose("portRef");
                }
            }
            this.blockClose("joined");
            if (IOTool.isEDIFUseSchematicView()) {
                this.egraphic = EGUNKNOWN;
                this.egraphic_override = EGWIRE;
                Iterator<ArcInst> aIt = cell.getArcs();
                while (aIt.hasNext()) {
                    Network aNet;
                    ArcInst ai = aIt.next();
                    int aWidth = netList.getBusWidth(ai);
                    if (aWidth > 1 || (aNet = netList.getNetwork(ai, 0)) != net) continue;
                    this.writeSymbolArcInst(ai, GenMath.MATID);
                }
                this.setGraphic(EGUNKNOWN);
                this.egraphic_override = EGUNKNOWN;
            }
            if (cs.isExported()) {
                Export e2 = cs.getExport();
                this.blockOpen("comment");
                this.blockPutString("exported as " + e2.getName() + ", type " + e2.getCharacteristic().getName());
                this.blockClose("comment");
            }
            if (globalport) {
                this.blockPut("userData", "global");
            }
            this.blockClose("net");
        }
        HashSet<ArcInst> bussesSeen = new HashSet<ArcInst>();
        it2 = cell.getArcs();
        while (it2.hasNext()) {
            ArcInst ai = (ArcInst)it2.next();
            int busWidth = netList.getBusWidth(ai);
            if (busWidth < 2 || bussesSeen.contains(ai)) continue;
            this.blockOpen("net");
            this.blockOpen("array");
            String realBusName = netList.getBusName(ai).toString();
            String busName = this.convertBusName(realBusName, netList, ai);
            String oname = this.makeToken(busName);
            if (!oname.equals(busName)) {
                this.blockOpen("rename");
                this.blockPutIdentifier(oname);
                this.blockPutString(busName);
                this.blockClose("rename");
            } else {
                this.blockPutIdentifier(oname);
            }
            this.blockPutIdentifier(Integer.toString(busWidth));
            this.blockClose("array");
            this.blockOpen("joined");
            List<BusRipper> rippersOnBus = BusRipper.getRippersOnBus(cell, realBusName);
            for (BusRipper br : rippersOnBus) {
                this.blockOpen("portList");
                for (int i = 0; i < busWidth; ++i) {
                    this.blockOpen("portRef");
                    this.blockOpen("member");
                    this.blockPutIdentifier("src");
                    this.blockPutIdentifier(Integer.toString(i));
                    this.blockClose("member");
                    this.blockOpen("instanceRef");
                    this.blockPutIdentifier("splitter_" + br.splitterIndex);
                    this.blockClose("instanceRef");
                    this.blockClose("portRef");
                }
                this.blockClose("portList");
            }
            this.blockClose("joined");
            if (IOTool.isEDIFUseSchematicView()) {
                this.egraphic = EGUNKNOWN;
                this.egraphic_override = EGBUS;
                Iterator<ArcInst> aIt = cell.getArcs();
                while (aIt.hasNext()) {
                    String arcBusName;
                    ArcInst oAi = aIt.next();
                    if (oAi.getProto() != Schematics.tech().bus_arc || !(arcBusName = netList.getBusName(oAi).toString()).equals(realBusName)) continue;
                    this.writeSymbolArcInst(oAi, GenMath.MATID);
                    bussesSeen.add(oAi);
                }
                this.setGraphic(EGUNKNOWN);
                this.egraphic_override = EGUNKNOWN;
            }
            this.blockClose("net");
        }
        if (IOTool.isEDIFUseSchematicView()) {
            this.blockClose("page");
        }
        this.blockClose("contents");
        this.blockClose("cell");
    }

    private void writeHeader(Cell cell, String program, String comment, String origin) {
        this.blockOpen("edif");
        this.blockPutIdentifier(cell.getName());
        this.blockPut("edifVersion", "2 0 0");
        this.blockPut("edifLevel", "0");
        this.blockOpen("keywordMap");
        this.blockPut("keywordLevel", "0");
        this.blockClose("keywordMap");
        this.blockOpen("status");
        this.blockOpen("written");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy MM dd HH mm ss");
        this.blockPut("timeStamp", simpleDateFormat.format(new Date()));
        if (program != null) {
            this.blockPut("program", "\"" + program + "\"");
        }
        if (comment != null) {
            this.blockPut("comment", "\"" + comment + "\"");
        }
        if (origin != null) {
            this.blockPut("dataOrigin", "\"" + origin + "\"");
        }
        this.blockClose("status");
    }

    private void writePrimitive(PrimitiveNode pn, int i, PrimitiveNode.Function fun) {
        if (fun == PrimitiveNode.Function.GATEAND || fun == PrimitiveNode.Function.GATEOR || fun == PrimitiveNode.Function.GATEXOR) {
            this.blockOpen("cell");
            String name = this.makeToken(pn.getName()) + i;
            this.blockPutIdentifier(name);
        } else {
            this.blockOpen("cell");
            this.blockPutIdentifier(this.makeToken(pn.getName()));
        }
        this.blockPut("cellType", "generic");
        this.blockOpen("comment");
        Technology tech = pn.getTechnology();
        this.blockPutString("Tech: " + tech.getTechName() + ", Node: " + pn.getName() + ", Func: " + fun.getConstantName());
        this.blockClose("comment");
        this.blockOpen("view");
        this.blockPutIdentifier("symbol");
        this.blockPut("viewType", IOTool.isEDIFUseSchematicView() ? "SCHEMATIC" : "NETLIST");
        this.blockOpen("interface");
        int firstPortIndex = 0;
        if (fun == PrimitiveNode.Function.GATEAND || fun == PrimitiveNode.Function.GATEOR || fun == PrimitiveNode.Function.GATEXOR) {
            for (int j = 0; j < i; ++j) {
                this.blockOpen("port");
                String name = "IN" + (j + 1);
                this.blockPutIdentifier(name);
                this.blockPut("direction", "INPUT");
                this.blockClose("port");
            }
            firstPortIndex = 1;
        }
        for (int k = firstPortIndex; k < pn.getNumPorts(); ++k) {
            PrimitivePort pp = pn.getPort(k);
            String direction = "input";
            if (pp.getCharacteristic() == PortCharacteristic.OUT) {
                direction = "output";
            } else if (pp.getCharacteristic() == PortCharacteristic.BIDIR) {
                direction = "inout";
            }
            this.blockOpen("port");
            this.blockPutIdentifier(this.makeToken(pp.getName()));
            this.blockPut("direction", direction);
            this.blockClose("port");
        }
        NodeInst ni = NodeInst.makeDummyInstance(pn);
        this.writeSymbol(pn, ni);
        this.blockClose("cell");
    }

    private void writeExternalDef(String extCell, String extView, String viewType, List<EDIFEquiv.Port> ports) {
        this.blockOpen("cell");
        this.blockPutIdentifier(extCell);
        this.blockPut("cellType", "generic");
        this.blockOpen("view");
        this.blockPutIdentifier(extView);
        if (viewType == null) {
            viewType = IOTool.isEDIFUseSchematicView() ? "SCHEMATIC" : "NETLIST";
        }
        this.blockPut("viewType", viewType);
        this.blockOpen("interface");
        for (EDIFEquiv.Port port : ports) {
            if (port.ignorePort) continue;
            this.blockOpen("port");
            String safeName = EDIF.makeValidName(port.name);
            if (!safeName.equals(port.name)) {
                this.blockOpen("rename");
                this.blockPutIdentifier(safeName);
                this.blockPutString(port.name);
                this.blockClose("rename");
            } else {
                this.blockPutIdentifier(port.name);
            }
            this.blockClose("port");
        }
        this.blockClose("cell");
    }

    private void writeAllPrims(Cell cell, HashMap<Object, PrimitiveNode> primsFound) {
        if (cell.isIcon()) {
            return;
        }
        Iterator<NodeInst> it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            NodeProto np = ni.getProto();
            if (!ni.isCellInstance()) {
                if (this.equivs.getNodeEquivalence(ni) != null) continue;
                PrimitiveNode pn = (PrimitiveNode)np;
                PrimitiveNode.Function fun = pn.getTechnology().getPrimitiveFunction(pn, ni.getTechSpecific());
                int i = 1;
                if (fun == PrimitiveNode.Function.GATEAND || fun == PrimitiveNode.Function.GATEOR || fun == PrimitiveNode.Function.GATEXOR) {
                    Iterator<Connection> cIt = ni.getConnections();
                    while (cIt.hasNext()) {
                        Connection con = cIt.next();
                        if (!con.getPortInst().getPortProto().getName().equals("a")) continue;
                        ++i;
                    }
                }
                if (primsFound.get(this.getPrimKey(ni, i)) != null || fun == PrimitiveNode.Function.UNKNOWN || fun == PrimitiveNode.Function.PIN || fun == PrimitiveNode.Function.ART) continue;
                this.writePrimitive(pn, i, fun);
                primsFound.put(this.getPrimKey(ni, i), pn);
                continue;
            }
            if (ni.isIconOfParent()) continue;
            Cell oNp = ((Cell)np).contentsView();
            if (oNp == null) {
                oNp = (Cell)np;
            }
            this.writeAllPrims(oNp, primsFound);
        }
    }

    private void countRippers(Cell cell, HashSet<Integer> rippers) {
        if (cell.isIcon()) {
            return;
        }
        Netlist netlist = null;
        Iterator<NodeInst> it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            NodeProto np = ni.getProto();
            if (!ni.isCellInstance()) {
                PrimitiveNode.Function fun;
                if (this.equivs.getNodeEquivalence(ni) != null || (fun = ni.getFunction()) != PrimitiveNode.Function.PIN) continue;
                int busWidthFound = -1;
                boolean wireFound = false;
                Iterator<Connection> cIt = ni.getConnections();
                while (cIt.hasNext()) {
                    int width;
                    Connection con = cIt.next();
                    ArcInst ai = con.getArc();
                    if (netlist == null) {
                        netlist = cell.acquireUserNetlist();
                    }
                    if ((width = netlist.getBusWidth(ai)) > 1) {
                        busWidthFound = width;
                        continue;
                    }
                    wireFound = true;
                }
                if (!wireFound || busWidthFound <= 1) continue;
                rippers.add(new Integer(busWidthFound));
                continue;
            }
            if (ni.isIconOfParent()) continue;
            Cell oNp = ((Cell)np).contentsView();
            if (oNp == null) {
                oNp = (Cell)np;
            }
            this.countRippers(oNp, rippers);
        }
    }

    private Object getPrimKey(NodeInst ni, int i) {
        if (ni.isCellInstance()) {
            return null;
        }
        PrimitiveNode pn = (PrimitiveNode)ni.getProto();
        PrimitiveNode.Function func = pn.getTechnology().getPrimitiveFunction(pn, ni.getTechSpecific());
        String key = pn.getTechnology().getTechShortName() + "_" + pn.getName() + "_" + func.getConstantName() + "_" + i;
        return key;
    }

    private void writePoint(double x, double y) {
        this.blockOpen("pt");
        this.blockPutInteger(this.scaleValue(x));
        this.blockPutInteger(this.scaleValue(y));
        this.blockClose("pt");
    }

    private String convertBusName(String busName, Netlist netlist, ElectricObject eObj) {
        block8: {
            int i;
            int width;
            block10: {
                block9: {
                    if (!IOTool.isEDIFCadenceCompatibility()) break block8;
                    int firstOpen = busName.indexOf(91);
                    if (firstOpen < 0) {
                        return busName;
                    }
                    boolean simple = true;
                    if (busName.indexOf(91, firstOpen + 1) >= 0) {
                        simple = false;
                    } else {
                        int closePos = busName.indexOf(93, firstOpen);
                        for (int i2 = firstOpen + 1; i2 < closePos; ++i2) {
                            char ch = busName.charAt(i2);
                            if (ch == ':' || ch == ',' || TextUtils.isDigit(ch)) continue;
                            simple = false;
                            break;
                        }
                    }
                    if (!simple) break block9;
                    busName = busName.replaceAll("\\[", "\\<").replaceAll("\\]", "\\>");
                    break block8;
                }
                busName = "";
                if (!(eObj instanceof ArcInst)) break block10;
                ArcInst ai = (ArcInst)eObj;
                width = netlist.getBusWidth(ai);
                for (i = 0; i < width; ++i) {
                    Iterator<String> nIt;
                    Network net = netlist.getNetwork(ai, i);
                    if (busName.length() > 0) {
                        busName = busName + ",";
                    }
                    String netName = (nIt = net.getNames()).hasNext() ? nIt.next() : net.describe(true);
                    busName = busName + netName.replaceAll("\\[", "_").replaceAll("\\]", "_");
                }
                break block8;
            }
            if (!(eObj instanceof Export)) break block8;
            Export e = (Export)eObj;
            width = netlist.getBusWidth(e);
            for (i = 0; i < width; ++i) {
                Iterator<String> nIt;
                Network net = netlist.getNetwork(e, i);
                if (busName.length() > 0) {
                    busName = busName + ",";
                }
                String netName = (nIt = net.getNames()).hasNext() ? nIt.next() : net.describe(true);
                busName = busName + netName.replaceAll("\\[", "_").replaceAll("\\]", "_");
            }
        }
        return busName;
    }

    public static String getOrientation(NodeInst ni, int addedRotation) {
        String orientation = "ERROR";
        int angle = ni.getAngle() - addedRotation;
        if (angle < 0) {
            angle += 3600;
        }
        if (angle > 3600) {
            angle %= 3600;
        }
        switch (angle) {
            case 0: {
                orientation = "";
                break;
            }
            case 900: {
                orientation = "R90";
                break;
            }
            case 1800: {
                orientation = "R180";
                break;
            }
            case 2700: {
                orientation = "R270";
            }
        }
        if (ni.isMirroredAboutXAxis()) {
            orientation = "MX" + orientation;
        }
        if (ni.isMirroredAboutYAxis()) {
            orientation = "MY" + orientation;
        }
        if (orientation.length() == 0) {
            orientation = "R0";
        }
        if (orientation.equals("MXR180")) {
            orientation = "MY";
        }
        if (orientation.equals("MYR180")) {
            orientation = "MX";
        }
        if (orientation.equals("MXR270")) {
            orientation = "MYR90";
        }
        if (orientation.equals("MYR270")) {
            orientation = "MXR90";
        }
        return orientation;
    }

    private double scaleValue(double val) {
        return (int)(val * (double)this.scale);
    }

    private String describePrimitive(NodeInst ni, PrimitiveNode.Function fun) {
        if (fun.isResistor()) {
            return "Resistor";
        }
        if (fun == PrimitiveNode.Function.TRANPN) {
            return "npn";
        }
        if (fun == PrimitiveNode.Function.TRAPNP) {
            return "pnp";
        }
        if (fun.isNTypeTransistor()) {
            return "nfet";
        }
        if (fun.isPTypeTransistor()) {
            return "pfet";
        }
        if (fun == PrimitiveNode.Function.SUBSTRATE) {
            return "gtap";
        }
        return this.makeToken(ni.getProto().getName());
    }

    private String makeComponentName(Nodable no) {
        char chr;
        String okname = EDIF.makeValidName(no.getName());
        if (okname.length() > 0 && (TextUtils.isDigit(chr = okname.charAt(0)) || chr == '_')) {
            okname = "&" + okname;
        }
        return okname;
    }

    public static String makeValidName(String name) {
        StringBuffer iptr = new StringBuffer(name);
        int i = 0;
        if (iptr.charAt(i) == '&') {
            ++i;
        }
        while (i < iptr.length()) {
            if (!TextUtils.isLetterOrDigit(iptr.charAt(i)) && iptr.charAt(i) != '_') {
                iptr.setCharAt(i, '_');
            }
            ++i;
        }
        return iptr.toString();
    }

    private String makeToken(String str) {
        char chr;
        if (str.length() == 0) {
            return str;
        }
        StringBuffer sb = new StringBuffer();
        if (TextUtils.isDigit(str.charAt(0))) {
            sb.append('X');
        }
        for (int i = 0; i < str.length() && !Character.isWhitespace(chr = str.charAt(i)); ++i) {
            if (chr == '[' || chr == '<') {
                chr = '_';
            }
            if (!TextUtils.isLetterOrDigit(chr) && chr != '&' && chr != 95) continue;
            sb.append(chr);
        }
        return sb.toString();
    }

    private void writeSymbol(Cell cell) {
        if (cell == null) {
            return;
        }
        if (!cell.isIcon()) {
            cell = cell.iconView();
        }
        if (cell == null) {
            return;
        }
        this.blockOpen("symbol");
        this.egraphic_override = EGWIRE;
        this.egraphic = EGUNKNOWN;
        Iterator<Object> it = cell.getPorts();
        while (it.hasNext()) {
            Export e = (Export)it.next();
            this.writePortImplementation(e, true);
        }
        this.egraphic_override = EGUNKNOWN;
        it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            this.writeSymbolCell(ni, GenMath.MATID);
        }
        it = cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            this.writeSymbolArcInst(ai, GenMath.MATID);
        }
        this.setGraphic(EGUNKNOWN);
        this.blockClose("symbol");
    }

    private void writeSymbol(PrimitiveNode pn, NodeInst ni) {
        if (pn == null) {
            return;
        }
        this.blockOpen("symbol");
        this.egraphic_override = EGWIRE;
        this.egraphic = EGUNKNOWN;
        Iterator<PortProto> it = pn.getPorts();
        while (it.hasNext()) {
            PortProto e = it.next();
            this.blockOpen("portImplementation");
            this.blockOpen("name");
            this.blockPutIdentifier(this.makeToken(e.getName()));
            this.blockOpen("display");
            this.blockOpen("figureGroupOverride");
            this.blockPutIdentifier(this.getFigureGroupName(EGWIRE));
            this.blockOpen("textHeight");
            this.blockPutInteger(this.getTextHeight(null));
            this.blockClose("figureGroupOverride");
            Poly portPoly = ni.getShapeOfPort(e);
            this.blockClose("name");
            this.blockOpen("connectLocation");
            this.writeSymbolPoly(portPoly, null, 1.0);
            this.setGraphic(EGUNKNOWN);
            this.blockClose("portImplementation");
        }
        this.egraphic_override = EGUNKNOWN;
        Poly[] polys = pn.getTechnology().getShapeOfNode(ni);
        for (int i = 0; i < polys.length; ++i) {
            this.writeSymbolPoly(polys[i], null, 1.0);
        }
        this.setGraphic(EGUNKNOWN);
        this.blockClose("symbol");
    }

    private void writePortImplementation(Export e, boolean closeBlock) {
        this.blockOpen("portImplementation");
        this.blockOpen("name");
        this.blockPutIdentifier(this.makeToken(e.getName()));
        this.blockOpen("display");
        this.blockOpen("figureGroupOverride");
        this.blockPutIdentifier(this.getFigureGroupName(EGWIRE));
        this.blockOpen("textHeight");
        this.blockPutInteger(this.getTextHeight(e.getTextDescriptor(Export.EXPORT_NAME)));
        this.blockClose("figureGroupOverride");
        this.blockOpen("origin");
        Poly namePoly = e.getNamePoly();
        this.writePoint(namePoly.getCenterX(), namePoly.getCenterY());
        this.blockClose("name");
        this.blockOpen("connectLocation");
        Poly portPoly = e.getOriginalPort().getPoly();
        this.egraphic_override = EGWIRE;
        this.egraphic = EGUNKNOWN;
        this.writeSymbolPoly(portPoly, null, 1.0);
        this.setGraphic(EGUNKNOWN);
        this.blockClose("connectLocation");
        if (closeBlock) {
            this.blockClose("portImplementation");
        }
    }

    private void writeSymbolCell(NodeInst ni, AffineTransform prevtrans) {
        if (ni.getOrient().equals(Orientation.IDENT)) {
            this.writeSymbolNodeInst(ni, prevtrans);
        } else {
            AffineTransform localtran = ni.rotateOut(prevtrans);
            this.writeSymbolNodeInst(ni, localtran);
        }
    }

    private void writeSymbolNodeInst(NodeInst ni, AffineTransform prevtrans) {
        NodeProto np = ni.getProto();
        if (!ni.isCellInstance()) {
            Technology tech = np.getTechnology();
            Poly[] polys = tech.getShapeOfNode(ni);
            int high = polys.length;
            int low = 0;
            if (np == Generic.tech().invisiblePinNode) {
                low = 1;
            }
            for (int j = low; j < high; ++j) {
                Poly poly = polys[j];
                poly.transform(prevtrans);
                boolean istext = false;
                if (poly.getStyle().isText()) {
                    istext = true;
                    this.setGraphic(EGUNKNOWN);
                    this.blockOpen("annotate");
                }
                this.writeSymbolPoly(poly, null, 1.0);
                if (!istext) continue;
                this.blockClose("annotate");
            }
        } else {
            Cell subCell = (Cell)np;
            AffineTransform subrot = ni.translateOut(prevtrans);
            Poly[] varPolys = ni.getDisplayableVariables(ni.getBounds(), null, false);
            if (varPolys.length != 0) {
                this.setGraphic(EGUNKNOWN);
            }
            this.writeDisplayableVariables(varPolys, prevtrans);
            Iterator<Geometric> it = subCell.getNodes();
            while (it.hasNext()) {
                NodeInst sNi = it.next();
                this.writeSymbolCell(sNi, subrot);
            }
            it = subCell.getArcs();
            while (it.hasNext()) {
                ArcInst sAi = (ArcInst)it.next();
                this.writeSymbolArcInst(sAi, subrot);
            }
        }
    }

    private void writeSymbolArcInst(ArcInst ai, AffineTransform trans) {
        Point2D[] points = new Point2D[]{new Point2D.Double(ai.getTailLocation().getX(), ai.getTailLocation().getY()), new Point2D.Double(ai.getHeadLocation().getX(), ai.getHeadLocation().getY())};
        points[0] = this.equivs.translatePortConnection(points[0], ai.getTailPortInst());
        points[1] = this.equivs.translatePortConnection(points[1], ai.getHeadPortInst());
        Poly poly = new Poly(points);
        poly.setStyle(Poly.Type.OPENED);
        poly.transform(trans);
        this.writeSymbolPoly(poly, null, 1.0);
        int num = ai.numDisplayableVariables(false);
        if (num != 0) {
            this.setGraphic(EGUNKNOWN);
        }
        Poly[] varPolys = new Poly[num];
        ai.addDisplayableVariables(ai.getBounds(), varPolys, 0, null, false);
        this.writeDisplayableVariables(varPolys, trans);
    }

    private void writeDisplayableVariables(Poly[] varPolys, AffineTransform prevtrans) {
        for (int i = 0; i < varPolys.length; ++i) {
            TextDescriptor td;
            Poly varPoly = varPolys[i];
            String name = null;
            String append = null;
            double scale = 1.0;
            DisplayedText dt = varPoly.getDisplayedText();
            Variable var = null;
            if (dt != null) {
                var = dt.getVariable();
            }
            if (var != null) {
                name = var.getTrueName();
                EDIFEquiv.VariableEquivalence ve = this.equivs.getElectricVariableEquivalence(dt.getVariableKey().getName());
                if (ve != null) {
                    name = ve.externVarName;
                    append = ve.appendElecOutput;
                    scale = ve.scale;
                }
            }
            if (name == null) continue;
            if (prevtrans != null) {
                varPoly.transform(prevtrans);
            }
            if (!varPoly.getStyle().isText() && var != null && (td = var.getTextDescriptor()) != null) {
                Poly.Type style = td.getPos().getPolyType();
                varPoly.setStyle(style);
            }
            if (varPoly.getString() == null && var != null) {
                varPoly.setString(var.getObject().toString());
            }
            this.blockOpen("property");
            this.blockPutIdentifier(name);
            this.blockOpen("string");
            this.writeSymbolPoly(varPoly, append, scale);
            this.blockClose("property");
        }
    }

    private void setGraphic(EGraphic type) {
        if (type == EGUNKNOWN) {
            if (this.egraphic != EGUNKNOWN) {
                this.blockClose("figure");
            }
            this.egraphic = EGUNKNOWN;
        } else if (this.egraphic_override == EGUNKNOWN) {
            if (type != this.egraphic) {
                if (this.egraphic != EGUNKNOWN) {
                    this.blockClose("figure");
                }
                this.egraphic = type;
                this.blockOpen("figure");
                this.blockPutIdentifier(this.getFigureGroupName(this.egraphic));
            }
        } else if (this.egraphic != this.egraphic_override) {
            if (this.egraphic != EGUNKNOWN) {
                this.blockClose("figure");
            }
            this.egraphic = this.egraphic_override;
            this.blockOpen("figure");
            this.blockPutIdentifier(this.getFigureGroupName(this.egraphic));
        }
    }

    private void writeSymbolPoly(Poly obj, String append, double scale) {
        Poly.Type type = obj.getStyle();
        Point2D[] points = obj.getPoints();
        if (type == Poly.Type.CIRCLE || type == Poly.Type.DISC || type == Poly.Type.THICKCIRCLE) {
            this.setGraphic(EGART);
            double i = points[0].distance(points[1]);
            this.blockOpen("circle");
            this.writePoint(points[0].getX() - i, points[0].getY());
            this.writePoint(points[0].getX() + i, points[0].getY());
            this.blockClose("circle");
            return;
        }
        if (type == Poly.Type.CIRCLEARC || type == Poly.Type.THICKCIRCLEARC) {
            this.setGraphic(EGART);
            if (points.length == 0) {
                return;
            }
            if (points.length % 3 != 0) {
                return;
            }
            for (int i = 0; i < points.length; i += 3) {
                this.blockOpen("openShape");
                this.blockOpen("curve");
                this.blockOpen("arc");
                this.writePoint(points[i + 1].getX(), points[i + 1].getY());
                Point2D si = GenMath.computeArcCenter(points[i], points[i + 1], points[i + 2]);
                this.writePoint(si.getX(), si.getY());
                this.writePoint(points[i + 2].getX(), points[i + 2].getY());
                this.blockClose("openShape");
            }
            return;
        }
        if (type == Poly.Type.FILLED || type == Poly.Type.CLOSED) {
            Rectangle2D bounds = obj.getBox();
            if (bounds != null) {
                if (bounds.getWidth() == 0.0 && bounds.getHeight() == 0.0) {
                    if (this.egraphic_override == EGUNKNOWN) {
                        return;
                    }
                    this.setGraphic(EGART);
                    this.blockOpen("dot");
                    this.writePoint(bounds.getCenterX(), bounds.getCenterY());
                    this.blockClose("dot");
                } else {
                    this.setGraphic(EGART);
                    this.blockOpen("rectangle");
                    this.writePoint(bounds.getMinX(), bounds.getMinY());
                    this.writePoint(bounds.getMaxY(), bounds.getMaxY());
                    this.blockClose("rectangle");
                }
            } else {
                this.setGraphic(EGART);
                this.blockOpen("path");
                this.blockOpen("pointList");
                for (int i = 0; i < points.length; ++i) {
                    this.writePoint(points[i].getX(), points[i].getY());
                }
                if (points.length > 2) {
                    this.writePoint(points[0].getX(), points[0].getY());
                }
                this.blockClose("path");
            }
            return;
        }
        if (type.isText()) {
            if (IOTool.isEDIFCadenceCompatibility() && obj.getDisplayedText() != null) {
                String value = obj.getDisplayedText().getVariable().getPureValue(-1);
                if (scale != 1.0) {
                    double scaled = TextUtils.atof(value);
                    value = TextUtils.formatDouble(scaled * scale);
                }
                if (append != null) {
                    value = value + append;
                }
                String str = EDIF.convertElectricPropToCadence(value);
                str = str.replaceAll("\"", "%34%");
                this.blockPutString(str);
                return;
            }
            Rectangle2D bounds = obj.getBounds2D();
            this.setGraphic(EGUNKNOWN);
            this.blockOpen("stringDisplay");
            String str = obj.getString().replaceAll("\"", "%34%");
            if (append != null) {
                str = str + append;
            }
            this.blockPutString(str);
            this.blockOpen("display");
            TextDescriptor td = obj.getTextDescriptor();
            if (td != null) {
                this.blockOpen("figureGroupOverride");
                this.blockPutIdentifier(this.getFigureGroupName(EGART));
                this.blockOpen("textHeight");
                double height = this.getTextHeight(td);
                this.blockPutInteger(height);
                this.blockClose("figureGroupOverride");
            } else {
                this.blockPutIdentifier(EGART.getText());
            }
            if (type == Poly.Type.TEXTCENT) {
                this.blockPut("justify", "CENTERCENTER");
            } else if (type == Poly.Type.TEXTTOP) {
                this.blockPut("justify", "LOWERCENTER");
            } else if (type == Poly.Type.TEXTBOT) {
                this.blockPut("justify", "UPPERCENTER");
            } else if (type == Poly.Type.TEXTLEFT) {
                this.blockPut("justify", "CENTERRIGHT");
            } else if (type == Poly.Type.TEXTRIGHT) {
                this.blockPut("justify", "CENTERLEFT");
            } else if (type == Poly.Type.TEXTTOPLEFT) {
                this.blockPut("justify", "LOWERRIGHT");
            } else if (type == Poly.Type.TEXTBOTLEFT) {
                this.blockPut("justify", "UPPERRIGHT");
            } else if (type == Poly.Type.TEXTTOPRIGHT) {
                this.blockPut("justify", "LOWERLEFT");
            } else if (type == Poly.Type.TEXTBOTRIGHT) {
                this.blockPut("justify", "UPPERLEFT");
            }
            this.blockPut("orientation", "R0");
            this.blockOpen("origin");
            this.writePoint(bounds.getMinX(), bounds.getMinY());
            this.blockClose("stringDisplay");
            return;
        }
        if (type == Poly.Type.OPENED || type == Poly.Type.OPENEDT1 || type == Poly.Type.OPENEDT2 || type == Poly.Type.OPENEDT3) {
            Rectangle2D bounds;
            if (points.length == 5 && points[4].getX() == points[0].getX() && points[4].getY() == points[0].getY() && (bounds = obj.getBox()) != null) {
                if (bounds.getWidth() == 0.0 && bounds.getHeight() == 0.0) {
                    if (this.egraphic_override == EGUNKNOWN) {
                        return;
                    }
                    this.setGraphic(EGART);
                    this.blockOpen("dot");
                    this.writePoint(bounds.getCenterX(), bounds.getCenterY());
                    this.blockClose("dot");
                } else {
                    this.setGraphic(EGART);
                    this.blockOpen("rectangle");
                    this.writePoint(bounds.getMinX(), bounds.getMinY());
                    this.writePoint(bounds.getMaxX(), bounds.getMaxY());
                    this.blockClose("rectangle");
                }
                return;
            }
            this.setGraphic(EGART);
            this.blockOpen("path");
            this.blockOpen("pointList");
            for (int i = 0; i < points.length; ++i) {
                this.writePoint(points[i].getX(), points[i].getY());
            }
            this.blockClose("path");
            return;
        }
        if (type == Poly.Type.VECTORS) {
            this.setGraphic(EGART);
            for (int i = 0; i < points.length; i += 2) {
                this.blockOpen("path");
                this.blockOpen("pointList");
                this.writePoint(points[i].getX(), points[i].getY());
                this.writePoint(points[i + 1].getX(), points[i + 1].getY());
                this.blockClose("path");
            }
            return;
        }
    }

    private String getFigureGroupName(EGraphic graphic) {
        String name = graphic.getText();
        EDIFEquiv.FigureGroupEquivalence fge = this.equivs.getElectricFigureGroupEquivalence(name);
        if (fge != null) {
            name = fge.externFGName;
        }
        return name;
    }

    private void writeFigureGroup(EGraphic graphic) {
        this.blockOpen("figureGroup");
        this.blockPutIdentifier(this.getFigureGroupName(graphic));
        this.blockClose("figureGroup");
    }

    private void writeScale(Technology tech) {
        this.blockOpen("scale");
        this.blockPutInteger(160.0);
        this.blockPutDouble(0.0254);
        this.blockPut("unit", "DISTANCE");
        this.blockClose("scale");
    }

    private double getTextHeight(TextDescriptor td) {
        double size = 2.0;
        if (td != null) {
            size = td.getSize().getSize();
            if (!td.getSize().isAbsolute()) {
                size *= 2.0;
            }
        }
        double height = size * 10.0 / 36.0;
        return this.scaleValue(height);
    }

    public static String convertElectricPropToCadence(String prop) {
        StringBuffer sb = new StringBuffer();
        Matcher atMat = atPat.matcher(prop);
        while (atMat.find()) {
            atMat.appendReplacement(sb, "P(\"" + atMat.group(1) + "\")");
        }
        atMat.appendTail(sb);
        prop = sb.toString();
        sb = new StringBuffer();
        Matcher pMat = pPat.matcher(prop);
        while (pMat.find()) {
            String c = "+";
            if (pMat.group(1).equals("PAR")) {
                c = "@";
            }
            pMat.appendReplacement(sb, "[" + c + pMat.group(2) + "]");
        }
        pMat.appendTail(sb);
        return sb.toString();
    }

    public static String convertCadencePropToElectric(String prop) {
        String origProp = prop;
        StringBuffer sb = new StringBuffer();
        Matcher atMat = bPat.matcher(prop);
        while (atMat.find()) {
            String call = "pPar";
            if (atMat.group(1).equals("+")) {
                call = "pPar";
            } else if (atMat.group(1).equals("@")) {
                call = "atPar";
            } else {
                System.out.println("Warning converting properties: Electric does not support \"[" + atMat.group(1) + "param], using [+param] instead, in " + origProp);
            }
            atMat.appendReplacement(sb, call + "(\"" + atMat.group(2) + "\")");
        }
        atMat.appendTail(sb);
        prop = sb.toString();
        sb = new StringBuffer();
        Matcher pMat = pparPat.matcher(prop);
        while (pMat.find()) {
            String c = "P";
            if (pMat.group(1).equals("pPar")) {
                c = "P";
            } else if (pMat.group(1).equals("atPar")) {
                c = "PAR";
            } else {
                System.out.println("Warning converting properties: Electric does not support \"[" + pMat.group(1) + "param], using pPar instead, in " + origProp);
            }
            pMat.appendReplacement(sb, c + "(\"" + pMat.group(2) + "\")");
        }
        pMat.appendTail(sb);
        return sb.toString();
    }

    private void blockOpen(String keyword) {
        this.blockOpen(keyword, true);
    }

    private void blockOpen(String keyword, boolean startOnNewLine) {
        if (this.blkstack_ptr > 0 && startOnNewLine) {
            this.printWriter.print("\n");
        }
        this.blkstack[this.blkstack_ptr++] = keyword;
        String blanks = startOnNewLine ? this.getBlanks(this.blkstack_ptr - 1) : " ";
        this.printWriter.print(blanks + "( " + keyword);
    }

    private void blockPut(String keyword, String identifier) {
        if (this.blkstack_ptr != 0) {
            this.printWriter.print("\n");
        }
        this.printWriter.print(this.getBlanks(this.blkstack_ptr) + "( " + keyword + " " + identifier + " )");
    }

    private void blockPutIdentifier(String str) {
        this.printWriter.print(" " + str);
    }

    private void blockPutString(String str) {
        this.printWriter.print(" \"" + str + "\"");
    }

    private void blockPutInteger(double val) {
        this.printWriter.print(" " + TextUtils.formatDouble(val));
    }

    private void blockPutDouble(double val) {
        if (decimalFormatScientific == null) {
            decimalFormatScientific = new DecimalFormat("########E0");
            decimalFormatScientific.setGroupingUsed(false);
        }
        String ret = decimalFormatScientific.format(val).replace('E', ' ');
        ret = ret.replaceAll("\\.[0-9]+", "");
        this.printWriter.print(" ( e " + ret + " )");
    }

    private void blockClose(String keyword) {
        if (this.blkstack_ptr == 0) {
            return;
        }
        int depth = 1;
        if (keyword != null) {
            for (depth = 1; depth <= this.blkstack_ptr && !this.blkstack[this.blkstack_ptr - depth].equals(keyword); ++depth) {
            }
            if (depth > this.blkstack_ptr) {
                System.out.println("EDIF output: could not match keyword <" + keyword + ">");
                return;
            }
        }
        do {
            --this.blkstack_ptr;
            this.printWriter.print(" )");
        } while (--depth > 0);
    }

    private void blockFinish() {
        if (this.blkstack_ptr > 0) {
            this.blockClose(this.blkstack[0]);
        }
        this.printWriter.print("\n");
    }

    private String getBlanks(int num) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < num; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }

    @Override
    protected String getSafeCellName(String name) {
        return name;
    }

    @Override
    protected String getPowerName(Network net) {
        return "VDD";
    }

    @Override
    protected String getGroundName(Network net) {
        return "GND";
    }

    @Override
    protected String getGlobalName(Global glob) {
        return glob.getName();
    }

    @Override
    protected boolean isNetworksUseExportedNames() {
        return true;
    }

    @Override
    protected boolean isLibraryNameAlwaysAddedToCellName() {
        return false;
    }

    @Override
    protected boolean isAggregateNamesSupported() {
        return false;
    }

    @Override
    protected boolean isAggregateNameGapsSupported() {
        return false;
    }

    @Override
    protected boolean isSeparateInputAndOutput() {
        return true;
    }

    @Override
    protected boolean isCaseSensitive() {
        return true;
    }

    @Override
    protected String getSafeNetName(String name, boolean bus) {
        return name;
    }

    @Override
    protected Netlist.ShortResistors getShortResistors() {
        return Netlist.ShortResistors.NO;
    }

    @Override
    protected boolean canParameterizeNames() {
        return false;
    }

    private static class CellToWrite {
        private final Cell cell;
        private final Topology.CellNetInfo cni;
        private final VarContext context;

        private CellToWrite(Cell cell, Topology.CellNetInfo cni, VarContext context) {
            this.cell = cell;
            this.cni = cni;
            this.context = context;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LibToWrite {
        private final List<CellToWrite> cellsToWrite = new ArrayList<CellToWrite>();

        private LibToWrite(Library l) {
        }

        private void add(CellToWrite c) {
            this.cellsToWrite.add(c);
        }

        private Iterator<CellToWrite> getCells() {
            return this.cellsToWrite.iterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BusRipper {
        private NodeInst ni;
        private Network net;
        private int busWidth;
        private int busIndex;
        private int splitterIndex;
        private String busName;
        private static HashMap<Cell, List<BusRipper>> rippersPerCell = null;

        private BusRipper(NodeInst ni, Network net, int busWidth, int busIndex, int splitterIndex, String busName) {
            this.ni = ni;
            this.net = net;
            this.busWidth = busWidth;
            this.busIndex = busIndex;
            this.splitterIndex = splitterIndex;
            this.busName = busName;
        }

        public int getBusWidth() {
            return this.busWidth;
        }

        public int getBusIndex() {
            return this.busIndex;
        }

        public int getSplitterIndex() {
            return this.splitterIndex;
        }

        public static void makeBusRipper(NodeInst ni, Network net, int busWidth, int busIndex, int splitterIndex, String busName) {
            List<BusRipper> rippersInCell;
            BusRipper br = new BusRipper(ni, net, busWidth, busIndex, splitterIndex, busName);
            Cell cell = ni.getParent();
            if (rippersPerCell == null) {
                rippersPerCell = new HashMap();
            }
            if ((rippersInCell = rippersPerCell.get(cell)) == null) {
                rippersInCell = new ArrayList<BusRipper>();
                rippersPerCell.put(cell, rippersInCell);
            }
            rippersInCell.add(br);
        }

        public static BusRipper findBusRipper(NodeInst ni, Network net) {
            if (rippersPerCell == null) {
                return null;
            }
            List<BusRipper> rippersInCell = rippersPerCell.get(ni.getParent());
            if (rippersInCell == null) {
                return null;
            }
            for (BusRipper br : rippersInCell) {
                if (br.ni != ni || br.net != net) continue;
                return br;
            }
            return null;
        }

        public static List<BusRipper> getRippersOnBus(Cell cell, String busName) {
            ArrayList<BusRipper> ripperList = new ArrayList<BusRipper>();
            if (rippersPerCell == null) {
                return ripperList;
            }
            List<BusRipper> rippersInCell = rippersPerCell.get(cell);
            if (rippersInCell == null) {
                return ripperList;
            }
            for (BusRipper br : rippersInCell) {
                if (!br.busName.equals(busName)) continue;
                ripperList.add(br);
            }
            return ripperList;
        }

        public static void done() {
            rippersPerCell = null;
        }
    }

    private static class EGraphic {
        private String text;

        EGraphic(String text) {
            this.text = text;
        }

        String getText() {
            return this.text;
        }
    }
}

