/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.Poly3D;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.routing.Routing;
import com.sun.electric.tool.routing.SeaOfGates;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesEngine;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesEngineFactory;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesHandlers;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.tool.user.dialogs.EModelessDialog;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.ToolBar;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.GenMath;
import com.sun.electric.util.math.MutableInteger;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class RoutingDebug {
    private static final double goalWidth = 0.005;
    private static final double layerOffset = 0.04;
    private static RoutingDialog debugDialog = null;
    private static SVState currentSVHighlight = null;
    private static boolean endADebug;
    private static boolean debugIn3D;
    private static Map<Integer, Color> netColors;
    private static Map<Integer, Integer> netAngles;
    private static int angleAssigned;
    private static DebugType debuggingType;

    public static void startDebugging() {
        User.setRoutingMode(true);
        ToolBar.setCursorMode(ToolBar.CursorMode.ROUTING);
        debugDialog = new RoutingDialog();
    }

    private static void endDebugging() {
        User.setRoutingMode(false);
        if (ToolBar.getCursorMode() == ToolBar.CursorMode.ROUTING) {
            ToolBar.setCursorMode(ToolBar.CursorMode.CLICKZOOMWIRE);
        }
        if (debugDialog != null) {
            debugDialog.setVisible(false);
            debugDialog.dispose();
            debugDialog = null;
        }
    }

    public static boolean isActive() {
        return debugDialog != null;
    }

    private static void showRouting(boolean endA, boolean threeD) {
        debuggingType = DebugType.DISPLAYROUTING;
        endADebug = endA;
        debugIn3D = threeD;
        debugDialog.router = SeaOfGatesEngineFactory.createSeaOfGatesEngine(SeaOfGatesEngineFactory.SeaOfGatesEngineType.defaultVersion);
        SeaOfGates.SeaOfGatesOptions prefs = new SeaOfGates.SeaOfGatesOptions();
        prefs.getOptionsFromPreferences(false);
        debugDialog.router.setPrefs(prefs);
        SeaOfGates.seaOfGatesRoute(UserInterfaceMain.getEditingPreferences(), debugDialog.router);
    }

    public static boolean isDisplayRouting() {
        return debugDialog != null && debuggingType == DebugType.DISPLAYROUTING;
    }

    public static void debugRoute(SeaOfGatesEngine.NeededRoute nr, List<SeaOfGatesEngine.NeededRoute> allRoutes) {
        if (debugDialog == null) {
            return;
        }
        DebugThread runnable = new DebugThread(nr, allRoutes);
        runnable.startJob();
    }

    public static void saveSVLink(SeaOfGatesEngine.SearchVertex sv, int lastDirection) {
        if (debugDialog != null && lastDirection >= 0) {
            EditWindow wnd = EditWindow.getCurrent();
            Cell cell = wnd.getCell();
            SVState svs = SVState.ensure(sv.getLast(), cell);
            svs.nextVertices[lastDirection] = sv;
        }
    }

    public static void saveSVDetails(SeaOfGatesEngine.SearchVertex sv, String[] details) {
        if (debugDialog != null) {
            EditWindow wnd = EditWindow.getCurrent();
            Cell cell = wnd.getCell();
            SVState svs = SVState.ensure(sv, cell);
            svs.details = details;
        }
    }

    public static SeaOfGatesEngine.SearchVertex findDebugSearchVertex(MouseEvent evt) {
        if (debugDialog == null || debugDialog.svInfo == null) {
            return null;
        }
        EditWindow wnd = (EditWindow)evt.getSource();
        if (wnd.getScale() < 25.0) {
            return null;
        }
        Point2D dbClick = wnd.screenToDatabase(evt.getX(), evt.getY());
        double bestDist = Double.MAX_VALUE;
        SeaOfGatesEngine.SearchVertex bestSV = null;
        for (SeaOfGatesEngine.SearchVertex sv : debugDialog.svInfo.keySet()) {
            double dY;
            double off = (double)sv.getZ() * 0.04;
            double dX = sv.getX() + off - dbClick.getX();
            double dist = Math.sqrt(dX * dX + (dY = sv.getY() + off - dbClick.getY()) * dY);
            if (!(dist < bestDist)) continue;
            bestDist = dist;
            bestSV = sv;
        }
        if (bestDist < 1.0) {
            return bestSV;
        }
        return null;
    }

    public static void previewSelectedSV(SeaOfGatesEngine.SearchVertex sv, boolean center) {
        SVState svsHigh;
        if (debugDialog == null) {
            return;
        }
        EditWindow wnd = EditWindow.getCurrent();
        Highlighter h = wnd.getRulerHighlighter();
        SVState svs = (SVState)debugDialog.svInfo.get(sv);
        if (currentSVHighlight != null) {
            currentSVHighlight.setBackgroundColor(null, h);
        }
        if (debugDialog.currentSV != null && (svsHigh = (SVState)debugDialog.svInfo.get(debugDialog.currentSV)) != null) {
            svsHigh.setBackgroundColor(Color.WHITE, h);
            h.finished();
        }
        if ((currentSVHighlight = svs) != null) {
            currentSVHighlight.setBackgroundColor(Color.RED, h);
            h.finished();
            if (center) {
                Rectangle2D windowBound = wnd.getDisplayedBounds();
                if (sv.getX() < windowBound.getMinX() || sv.getX() > windowBound.getMaxX() || sv.getY() < windowBound.getMinY() || sv.getY() > windowBound.getMaxY()) {
                    wnd.setOffset(new Point2D.Double(sv.getX(), sv.getY()));
                }
            }
            wnd.fullRepaint();
        }
    }

    public static void showSelectedSV(SeaOfGatesEngine.SearchVertex sv) {
        RoutingDebug.debugDialog.seeSelectedSV(sv);
    }

    private static void showEndBlockages() {
        debugDialog.router = SeaOfGatesEngineFactory.createSeaOfGatesEngine(SeaOfGatesEngineFactory.SeaOfGatesEngineType.defaultVersion);
        SeaOfGates.SeaOfGatesOptions prefs = new SeaOfGates.SeaOfGatesOptions();
        prefs.getOptionsFromPreferences(false);
        debuggingType = DebugType.DISPLAYENDBLOCKAGES;
        debugDialog.router.setPrefs(prefs);
        SeaOfGates.seaOfGatesRoute(UserInterfaceMain.getEditingPreferences(), debugDialog.router);
    }

    public static boolean isDisplayEndBlockages() {
        return debugDialog != null && debuggingType == DebugType.DISPLAYENDBLOCKAGES;
    }

    public static void showGeometryAtRouteEnds(SeaOfGatesEngine.NeededRoute nr) {
        ERectangle drawn;
        List assigned;
        Layer layer;
        int i;
        debuggingType = DebugType.NONE;
        if (debugDialog == null) {
            return;
        }
        EditWindow wnd = EditWindow.getCurrent();
        Cell cell = wnd.getCell();
        Highlighter h = wnd.getRulerHighlighter();
        h.clear();
        double examineSurround = 10.0;
        angleAssigned = 45;
        netColors = new HashMap<Integer, Color>();
        netAngles = new HashMap<Integer, Integer>();
        double lowestX = Double.MAX_VALUE;
        double lowestY = Double.MAX_VALUE;
        RoutingDebug.debugDialog.setRouteDescription("Netlist information at ends of selected route", null);
        Rectangle2D limit = nr.getBounds();
        RoutingDebug.showBounds(cell, limit, h, Color.ORANGE);
        HashMap allAssigned = new HashMap();
        Rectangle2D.Double headBound = new Rectangle2D.Double(nr.getAX() - examineSurround, nr.getAY() - examineSurround, examineSurround * 2.0, examineSurround * 2.0);
        for (int i2 = 0; i2 < debugDialog.router.getNumMetals(); ++i2) {
            Layer layer2 = debugDialog.router.getMetalLayer(i2);
            ArrayList<SeaOfGatesEngine.SOGBound> assigned2 = new ArrayList<SeaOfGatesEngine.SOGBound>();
            allAssigned.put(layer2, assigned2);
            Iterator<SeaOfGatesEngine.SOGBound> sea = debugDialog.router.searchMetalTree(layer2, headBound);
            while (sea.hasNext()) {
                SeaOfGatesEngine.SOGBound sBound = sea.next();
                if (sBound.getNetID() != null && sBound.getNetID().intValue() != 0) {
                    assigned2.add(sBound);
                    continue;
                }
                ERectangle drawn2 = RoutingDebug.showGeometryPiece(sBound, limit, layer2);
                if (drawn2 == null) continue;
                if (drawn2.getMinX() < lowestX) {
                    lowestX = drawn2.getMinX();
                }
                if (!(drawn2.getMinY() < lowestY)) continue;
                lowestY = drawn2.getMinY();
            }
        }
        Rectangle2D.Double tailBound = new Rectangle2D.Double(nr.getBX() - examineSurround, nr.getBY() - examineSurround, examineSurround * 2.0, examineSurround * 2.0);
        for (i = 0; i < debugDialog.router.getNumMetals(); ++i) {
            layer = debugDialog.router.getMetalLayer(i);
            assigned = (List)allAssigned.get(layer);
            Iterator<SeaOfGatesEngine.SOGBound> sea = debugDialog.router.searchMetalTree(layer, tailBound);
            while (sea.hasNext()) {
                SeaOfGatesEngine.SOGBound sBound = sea.next();
                if (sBound.getNetID() != null && sBound.getNetID().intValue() != 0) {
                    assigned.add(sBound);
                    continue;
                }
                drawn = RoutingDebug.showGeometryPiece(sBound, limit, layer);
                if (drawn == null) continue;
                if (drawn.getMinX() < lowestX) {
                    lowestX = drawn.getMinX();
                }
                if (!(drawn.getMinY() < lowestY)) continue;
                lowestY = drawn.getMinY();
            }
        }
        for (i = 0; i < debugDialog.router.getNumMetals(); ++i) {
            layer = debugDialog.router.getMetalLayer(i);
            assigned = (List)allAssigned.get(layer);
            for (SeaOfGatesEngine.SOGBound sBound : assigned) {
                drawn = RoutingDebug.showGeometryPiece(sBound, limit, layer);
                if (drawn == null) continue;
                if (drawn.getMinX() < lowestX) {
                    lowestX = drawn.getMinX();
                }
                if (!(drawn.getMinY() < lowestY)) continue;
                lowestY = drawn.getMinY();
            }
        }
        double pos = lowestY - 10.0;
        for (Integer netIDI : netColors.keySet()) {
            Color color = netColors.get(netIDI);
            Integer angle = netAngles.get(netIDI);
            Rectangle2D.Double bound = new Rectangle2D.Double(lowestX, pos, 4.0, 2.0);
            RoutingDebug.showStripedRect(bound, color, angle);
            h.addMessage(cell, RoutingDebug.getNetName(netIDI), EPoint.fromLambda(lowestX - 10.0, pos + 1.0));
            pos -= 3.0;
        }
        h.finished();
        EditWindow.repaintAllContents();
    }

    private static void showAreaBlockages() {
        debugDialog.router = SeaOfGatesEngineFactory.createSeaOfGatesEngine(SeaOfGatesEngineFactory.SeaOfGatesEngineType.defaultVersion);
        SeaOfGates.SeaOfGatesOptions prefs = new SeaOfGates.SeaOfGatesOptions();
        prefs.getOptionsFromPreferences(false);
        debuggingType = DebugType.DISPLAYAREABLOCKAGES;
        debugDialog.router.setPrefs(prefs);
        SeaOfGates.seaOfGatesRoute(UserInterfaceMain.getEditingPreferences(), debugDialog.router);
    }

    public static boolean isDisplayAreaBlockages() {
        return debugDialog != null && debuggingType == DebugType.DISPLAYAREABLOCKAGES;
    }

    public static void showGeometryInArea(SeaOfGatesEngine.NeededRoute nr) {
        ERectangle drawn;
        List<SeaOfGatesEngine.SOGBound> assigned;
        Layer layer;
        int i;
        debuggingType = DebugType.NONE;
        if (debugDialog == null) {
            return;
        }
        EditWindow wnd = EditWindow.getCurrent();
        Cell cell = wnd.getCell();
        Rectangle2D limit = nr.getBounds();
        Highlighter h = wnd.getRulerHighlighter();
        h.clear();
        angleAssigned = 45;
        netColors = new HashMap<Integer, Color>();
        netAngles = new HashMap<Integer, Integer>();
        double lowestX = Double.MAX_VALUE;
        double lowestY = Double.MAX_VALUE;
        RoutingDebug.debugDialog.setRouteDescription("Netlist information for selected area", null);
        RoutingDebug.showBounds(cell, limit, h, Color.ORANGE);
        HashMap allAssigned = new HashMap();
        for (i = 0; i < debugDialog.router.getNumMetals(); ++i) {
            layer = debugDialog.router.getMetalLayer(i);
            assigned = new ArrayList();
            allAssigned.put(layer, assigned);
            Iterator<SeaOfGatesEngine.SOGBound> sea = debugDialog.router.searchMetalTree(layer, limit);
            while (sea.hasNext()) {
                SeaOfGatesEngine.SOGBound sBound = sea.next();
                if (sBound.getNetID() != null && sBound.getNetID().intValue() != 0) {
                    assigned.add(sBound);
                    continue;
                }
                drawn = RoutingDebug.showGeometryPiece(sBound, limit, layer);
                if (drawn == null) continue;
                if (drawn.getMinX() < lowestX) {
                    lowestX = drawn.getMinX();
                }
                if (!(drawn.getMinY() < lowestY)) continue;
                lowestY = drawn.getMinY();
            }
        }
        for (i = 0; i < debugDialog.router.getNumMetals(); ++i) {
            layer = debugDialog.router.getMetalLayer(i);
            assigned = (List)allAssigned.get(layer);
            for (SeaOfGatesEngine.SOGBound sBound : assigned) {
                drawn = RoutingDebug.showGeometryPiece(sBound, limit, layer);
                if (drawn == null) continue;
                if (drawn.getMinX() < lowestX) {
                    lowestX = drawn.getMinX();
                }
                if (!(drawn.getMinY() < lowestY)) continue;
                lowestY = drawn.getMinY();
            }
        }
        double pos = lowestY - 10.0;
        for (Integer netIDI : netColors.keySet()) {
            Color color = netColors.get(netIDI);
            Integer angle = netAngles.get(netIDI);
            Rectangle2D.Double bound = new Rectangle2D.Double(lowestX, pos, 4.0, 2.0);
            RoutingDebug.showStripedRect(bound, color, angle);
            h.addMessage(cell, RoutingDebug.getNetName(netIDI), EPoint.fromLambda(lowestX - 10.0, pos + 1.0));
            pos -= 3.0;
        }
        h.finished();
        EditWindow.repaintAllContents();
    }

    private static void showRoutingGrid() {
        debugDialog.router = SeaOfGatesEngineFactory.createSeaOfGatesEngine(SeaOfGatesEngineFactory.SeaOfGatesEngineType.defaultVersion);
        SeaOfGates.SeaOfGatesOptions prefs = new SeaOfGates.SeaOfGatesOptions();
        prefs.getOptionsFromPreferences(false);
        debuggingType = DebugType.DISPLAYROUTINGGRID;
        debugDialog.router.setPrefs(prefs);
        SeaOfGates.seaOfGatesRoute(UserInterfaceMain.getEditingPreferences(), debugDialog.router);
    }

    public static boolean isTestRoutingGrid() {
        return debugDialog != null && debuggingType == DebugType.DISPLAYROUTINGGRID;
    }

    public static void showRoutingGrid(SeaOfGatesEngine.NeededRoute nr) {
        int metNum = TextUtils.atoi(debugDialog.whichLayer.getText());
        int numMetalLayers = debugDialog.router.getNumMetals();
        if (metNum <= 0 || metNum > numMetalLayers) {
            Job.getUserInterface().showErrorMessage("Invalid layer number (" + metNum + ") must be between 1 and " + numMetalLayers, "Invalid Layer");
            return;
        }
        debuggingType = DebugType.NONE;
        if (debugDialog == null) {
            return;
        }
        EditWindow wnd = EditWindow.getCurrent();
        Cell cell = wnd.getCell();
        Rectangle2D limit = nr.getBounds();
        Highlighter h = wnd.getRulerHighlighter();
        h.clear();
        RoutingDebug.debugDialog.setRouteDescription("Routing grid for Metal-" + metNum, null);
        RoutingDebug.showBounds(cell, limit, h, Color.ORANGE);
        double[][] gridLocationsX = nr.getXRoutingGrid();
        double[][] gridLocationsY = nr.getYRoutingGrid();
        SeaOfGates.SeaOfGatesCellParameters sogp = new SeaOfGates.SeaOfGatesCellParameters(cell);
        boolean hor = true;
        if (sogp.isHorizontalEven()) {
            if (metNum % 2 != 0) {
                hor = false;
            }
        } else if (metNum % 2 == 0) {
            hor = false;
        }
        if (hor) {
            double[] gridLines = gridLocationsY[metNum - 1];
            if (gridLines != null) {
                for (int i = 0; i < gridLines.length; ++i) {
                    double[] gridUp;
                    int j;
                    double[] gridDown;
                    Point2D.Double p1 = new Point2D.Double(limit.getMinX(), gridLines[i]);
                    Point2D.Double p2 = new Point2D.Double(limit.getMaxX(), gridLines[i]);
                    h.addLine(p1, p2, cell, false, Color.WHITE, false);
                    if (metNum > 1 && (gridDown = gridLocationsX[metNum - 2]) != null) {
                        for (j = 0; j < gridDown.length; ++j) {
                            p1 = new Point2D.Double(gridDown[j], gridLines[i]);
                            p2 = new Point2D.Double(gridDown[j], gridLines[i] - 5.0);
                            h.addLine(p1, p2, cell, false, Color.WHITE, false);
                        }
                    }
                    if (metNum >= numMetalLayers || (gridUp = gridLocationsX[metNum]) == null) continue;
                    for (j = 0; j < gridUp.length; ++j) {
                        p1 = new Point2D.Double(gridUp[j], gridLines[i]);
                        p2 = new Point2D.Double(gridUp[j], gridLines[i] + 5.0);
                        h.addLine(p1, p2, cell, false, Color.WHITE, false);
                    }
                }
            }
        } else {
            double[] gridLines = gridLocationsX[metNum - 1];
            if (gridLines != null) {
                for (int i = 0; i < gridLines.length; ++i) {
                    double[] gridUp;
                    int j;
                    double[] gridDown;
                    Point2D.Double p1 = new Point2D.Double(gridLines[i], limit.getMinY());
                    Point2D.Double p2 = new Point2D.Double(gridLines[i], limit.getMaxY());
                    h.addLine(p1, p2, cell, false, Color.WHITE, false);
                    if (metNum > 1 && (gridDown = gridLocationsY[metNum - 2]) != null) {
                        for (j = 0; j < gridDown.length; ++j) {
                            p1 = new Point2D.Double(gridLines[i], gridDown[j]);
                            p2 = new Point2D.Double(gridLines[i] - 5.0, gridDown[j]);
                            h.addLine(p1, p2, cell, false, Color.WHITE, false);
                        }
                    }
                    if (metNum >= numMetalLayers || (gridUp = gridLocationsY[metNum]) == null) continue;
                    for (j = 0; j < gridUp.length; ++j) {
                        p1 = new Point2D.Double(gridLines[i], gridUp[j]);
                        p2 = new Point2D.Double(gridLines[i] + 5.0, gridUp[j]);
                        h.addLine(p1, p2, cell, false, Color.WHITE, false);
                    }
                }
            }
        }
        h.finished();
        EditWindow.repaintAllContents();
    }

    public static void doGlobalRouting() {
        debugDialog.router = SeaOfGatesEngineFactory.createSeaOfGatesEngine(SeaOfGatesEngineFactory.SeaOfGatesEngineType.defaultVersion);
        SeaOfGates.SeaOfGatesOptions prefs = new SeaOfGates.SeaOfGatesOptions();
        prefs.getOptionsFromPreferences(false);
        debuggingType = DebugType.RUNGLOBALROUTING;
        debugDialog.router.setPrefs(prefs);
        SeaOfGates.seaOfGatesRoute(UserInterfaceMain.getEditingPreferences(), debugDialog.router);
    }

    public static int getDesiredRouteToDebug() {
        String selection = debugDialog.whichOne.getText().trim();
        if (selection.length() == 0) {
            return 0;
        }
        return TextUtils.atoi(selection);
    }

    public static boolean isTestGlobalRouting() {
        return debugDialog != null && debuggingType == DebugType.RUNGLOBALROUTING;
    }

    public static void setGlobalRouting(SeaOfGatesEngine.GlobalRouter gr) {
        debugDialog.globalRoutingResults = gr;
    }

    public static void showGlobalRouting() {
        EditWindow wnd = EditWindow.getCurrent();
        Highlighter h = wnd.getRulerHighlighter();
        h.clear();
        RoutingDebug.debugDialog.showGlobalRoutingGrid();
        RoutingDebug.debugDialog.showGlobalRoutingPath(null);
        h.finished();
        wnd.repaint();
    }

    private static void rewireNets() {
        EditWindow wnd = EditWindow.getCurrent();
        Cell cell = wnd.getCell();
        if (cell == null) {
            return;
        }
        ArrayList<ArcInst> selected = new ArrayList<ArcInst>();
        Iterator<ArcInst> it = cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = it.next();
            if (ai.getProto() != Generic.tech().unrouted_arc) continue;
            selected.add(ai);
        }
        if (selected.isEmpty()) {
            return;
        }
        debuggingType = DebugType.REWIRENETS;
        SeaOfGatesHandlers.startInJob(cell, selected, SeaOfGatesEngineFactory.SeaOfGatesEngineType.defaultVersion, SeaOfGatesHandlers.Save.SAVE_PERIODIC);
    }

    public static boolean isRewireNetworks() {
        return debugDialog != null && debuggingType == DebugType.REWIRENETS;
    }

    private static String getNetName(Integer netIDI) {
        return "Net " + netIDI;
    }

    private static void showBounds(Cell cell, Rectangle2D bounds, Highlighter h, Color col) {
        Point2D.Double p1 = new Point2D.Double(bounds.getMinX(), bounds.getMinY());
        Point2D.Double p2 = new Point2D.Double(bounds.getMinX(), bounds.getMaxY());
        Point2D.Double p3 = new Point2D.Double(bounds.getMaxX(), bounds.getMaxY());
        Point2D.Double p4 = new Point2D.Double(bounds.getMaxX(), bounds.getMinY());
        h.addLine(p1, p2, cell, true, col, false);
        h.addLine(p2, p3, cell, true, col, false);
        h.addLine(p3, p4, cell, true, col, false);
        h.addLine(p4, p1, cell, true, col, false);
    }

    private static void showStripedRect(Rectangle2D bound, Color color, int angle) {
        EditWindow wnd = EditWindow.getCurrent();
        Cell cell = wnd.getCell();
        Highlighter h = wnd.getRulerHighlighter();
        h.addArea(bound, color, cell);
        double gapX = 0.5;
        double gapY = 0.5;
        double lX = bound.getMinX();
        double hX = bound.getMaxX();
        double lY = bound.getMinY();
        double hY = bound.getMaxY();
        if (angle == 0) {
            for (double y = RoutingDebug.gridValue(lY, gapY); y < hY; y += gapY) {
                h.addLine(new Point2D.Double(lX, y), new Point2D.Double(hX, y), cell, false, color, false);
            }
            return;
        }
        if (angle == 90) {
            for (double x2 = RoutingDebug.gridValue(lX, gapX); x2 < hX; x2 += gapX) {
                h.addLine(new Point2D.Double(x2, lY), new Point2D.Double(x2, hY), cell, false, color, false);
            }
            return;
        }
        double s = DBMath.sin(angle * 10);
        double c = DBMath.cos(angle * 10);
        gapX /= Math.abs(s);
        gapY /= Math.abs(c);
        if (angle <= 45 || angle >= 135) {
            double length;
            double pos;
            if (angle < 90) {
                pos = RoutingDebug.gridValue(lX - gapX, gapX);
                length = (hX - pos) / c;
            } else {
                pos = RoutingDebug.gridValue(hX + gapX, gapX);
                length = (lX - pos) / c;
            }
            for (double y = RoutingDebug.gridValue(lY - bound.getWidth() - gapY, gapY); y < hY + bound.getWidth(); y += gapY) {
                Point2D.Double pt1 = new Point2D.Double(pos, y);
                Point2D.Double pt2 = new Point2D.Double(pos + c * length, y + s * length);
                boolean gone = DBMath.clipLine(pt1, pt2, lX, hX, lY, hY);
                if (gone) continue;
                h.addLine(pt1, pt2, cell, false, color, false);
            }
        } else {
            double pos = RoutingDebug.gridValue(lY - gapY, gapY);
            double length = (hY - pos) / s;
            for (double x3 = RoutingDebug.gridValue(lX - bound.getHeight() - gapX, gapX); x3 < hX + bound.getHeight(); x3 += gapX) {
                Point2D.Double pt1 = new Point2D.Double(x3, pos);
                Point2D.Double pt2 = new Point2D.Double(x3 + c * length, pos + s * length);
                boolean gone = DBMath.clipLine(pt1, pt2, lX, hX, lY, hY);
                if (gone) continue;
                h.addLine(pt1, pt2, cell, false, color, false);
            }
        }
    }

    private static double gridValue(double v, double gap) {
        int iv = (int)Math.round(v / gap);
        return (double)iv * gap;
    }

    private static ERectangle showGeometryPiece(SeaOfGatesEngine.SOGBound sBound, Rectangle2D limit, Layer lay) {
        Integer angle;
        Color color;
        MutableInteger mi = sBound.getNetID();
        Integer netIDI = mi == null ? Integer.valueOf(0) : Integer.valueOf(mi.intValue());
        if (netIDI == 0) {
            color = lay.getGraphics().getColor();
            angle = 90;
        } else {
            color = Color.BLACK;
            color = lay.getGraphics().getColor();
            if ((netIDI & 1) != 0) {
                color = Color.GRAY;
            }
            if ((angle = netAngles.get(netIDI)) == null) {
                angleAssigned = (angleAssigned + 41) % 180;
                angle = angleAssigned;
                netAngles.put(netIDI, angle);
            }
        }
        ERectangle draw = sBound.getBounds();
        double lX = draw.getMinX();
        double hX = draw.getMaxX();
        double lY = draw.getMinY();
        double hY = draw.getMaxY();
        if (lX < limit.getMinX()) {
            lX = limit.getMinX();
            draw = null;
        }
        if (hX > limit.getMaxX()) {
            hX = limit.getMaxX();
            draw = null;
        }
        if (lY < limit.getMinY()) {
            lY = limit.getMinY();
            draw = null;
        }
        if (hY > limit.getMaxY()) {
            hY = limit.getMaxY();
            draw = null;
        }
        if (draw == null) {
            draw = ERectangle.fromLambda(lX, lY, hX - lX, hY - lY);
        }
        RoutingDebug.showStripedRect(draw, color, angle);
        return draw;
    }

    static /* synthetic */ RoutingDialog access$202(RoutingDialog x0) {
        debugDialog = x0;
        return debugDialog;
    }

    private static class Show3DRoute
    implements Runnable {
        private SeaOfGatesEngine.Wavefront wf;
        private SeaOfGatesEngine.NeededRoute nr;
        private SeaOfGatesEngine router;
        private Cell cell;

        Show3DRoute(SeaOfGatesEngine.Wavefront wf, SeaOfGatesEngine.NeededRoute nr, SeaOfGatesEngine router, Cell cell) {
            this.wf = wf;
            this.nr = nr;
            this.router = router;
            this.cell = cell;
        }

        @Override
        public void run() {
            Poly3D poly;
            Layer layer;
            Method showPolysMethod = null;
            try {
                Class<?> threeDClass = Class.forName("com.sun.electric.plugins.j3d.View3DWindow");
                showPolysMethod = threeDClass.getMethod("show3DPolygons", ArrayList.class);
            }
            catch (Exception e) {
                System.out.println("Problem with 3D view: " + e.getMessage());
            }
            if (showPolysMethod == null) {
                EditWindow_ wnd = Job.getUserInterface().getCurrentEditWindow_();
                Cell drawCell = wnd.getCell();
                wnd.clearHighlighting();
                for (SeaOfGatesEngine.SearchVertex sv : this.wf.getActive()) {
                    this.showSV(sv, wnd, drawCell);
                }
                for (SeaOfGatesEngine.SearchVertex sv : this.wf.getInactive()) {
                    this.showSV(sv, wnd, drawCell);
                }
                wnd.finishedHighlighting();
                return;
            }
            ArrayList<PolyBase> polys = new ArrayList<PolyBase>();
            for (SeaOfGatesEngine.SearchVertex sv : this.wf.getActive()) {
                this.displaySearchVertex(sv, polys);
            }
            for (SeaOfGatesEngine.SearchVertex sv : this.wf.getInactive()) {
                this.displaySearchVertex(sv, polys);
            }
            int highestUsedLayer = 0;
            for (int lay = 0; lay < this.router.getNumMetals(); ++lay) {
                layer = this.router.getMetalLayer(lay);
                Iterator<SeaOfGatesEngine.SOGBound> sea = debugDialog.router.searchMetalTree(layer, this.nr.getBounds());
                while (sea.hasNext()) {
                    SeaOfGatesEngine.SOGBound sBound = sea.next();
                    double lX = sBound.getBounds().getMinX();
                    double hX = sBound.getBounds().getMaxX();
                    double lY = sBound.getBounds().getMinY();
                    double hY = sBound.getBounds().getMaxY();
                    if (hX <= this.nr.getBounds().getMinX() || lX >= this.nr.getBounds().getMaxX() || hY <= this.nr.getBounds().getMinY() || lY >= this.nr.getBounds().getMaxY()) continue;
                    if (lX < this.nr.getBounds().getMinX()) {
                        lX = this.nr.getBounds().getMinX();
                    }
                    if (hX > this.nr.getBounds().getMaxX()) {
                        hX = this.nr.getBounds().getMaxX();
                    }
                    if (lY < this.nr.getBounds().getMinY()) {
                        lY = this.nr.getBounds().getMinY();
                    }
                    if (hY > this.nr.getBounds().getMaxY()) {
                        hY = this.nr.getBounds().getMaxY();
                    }
                    double lowZ = layer.getDistance();
                    poly = new Poly3D((lX + hX) / 2.0, (lY + hY) / 2.0, hX - lX, hY - lY, lowZ, lowZ);
                    poly.setStyle(Poly.Type.FILLED);
                    EGraphics graphics = layer.getGraphics();
                    poly.setColor(graphics.getColor());
                    poly.setTransparency(0.1f);
                    polys.add(poly);
                    if (lay <= highestUsedLayer) continue;
                    highestUsedLayer = lay;
                }
            }
            for (int i = 0; i < highestUsedLayer; ++i) {
                layer = this.router.getMetalLayer(i);
                Layer m1Layer = this.router.getMetalLayer(i);
                Layer m2Layer = this.router.getMetalLayer(i + 1);
                Iterator<SeaOfGatesEngine.SOGBound> sea = this.nr.searchViaTree(layer, this.nr.getBounds());
                while (sea.hasNext()) {
                    SeaOfGatesEngine.SOGVia sBound = (SeaOfGatesEngine.SOGVia)sea.next();
                    double cX = sBound.getBounds().getCenterX();
                    double cY = sBound.getBounds().getCenterY();
                    if (cX <= this.nr.getBounds().getMinX() || cX >= this.nr.getBounds().getMaxX() || cY <= this.nr.getBounds().getMinY() || cY >= this.nr.getBounds().getMaxY()) continue;
                    double lowZ = m1Layer.getDistance();
                    double highZ = m2Layer.getDistance();
                    poly = new Poly3D(cX, cY, 1.0, 1.0, lowZ, highZ);
                    poly.setStyle(Poly.Type.FILLED);
                    poly.setColor(Color.BLACK);
                    poly.setTransparency(0.1f);
                    polys.add(poly);
                }
            }
            this.showRoutingPath(polys, highestUsedLayer);
            try {
                showPolysMethod.invoke(null, polys);
            }
            catch (Exception e) {
                System.out.println("3D rendering error: " + e.getMessage());
            }
        }

        private void showSV(SeaOfGatesEngine.SearchVertex sv, EditWindow_ wnd, Cell cellToUse) {
            String message = "M" + (sv.getZ() + 1) + "=" + sv.getCost();
            Point2D.Double loc = new Point2D.Double(sv.getX(), sv.getY());
            wnd.addHighlightMessage(cellToUse, message, loc);
        }

        private void showRoutingPath(List<PolyBase> polys, int highestUsedLayer) {
            double overallDepth = 20.0;
            Technology tech = this.cell.getTechnology();
            PolyBase.Point fromPT = Poly3D.fromLambda(this.wf.getFromX(), this.wf.getFromY());
            PolyBase.Point toPT = Poly3D.fromLambda(this.wf.getToX(), this.wf.getToY());
            PolyBase.Point[] twoPT = new PolyBase.Point[]{fromPT, toPT};
            double lowZ = this.router.getMetalLayer(0).getDistance() - overallDepth;
            double highZ = this.router.getMetalLayer(highestUsedLayer).getDistance() + this.router.getMetalLayer(highestUsedLayer).getThickness() + overallDepth;
            Poly3D routePoly = new Poly3D(twoPT, lowZ, lowZ);
            routePoly.setLayer(tech.findLayer("Metal-1"));
            routePoly.setStyle(Poly.Type.OPENED);
            routePoly.setColor(Color.WHITE);
            polys.add(routePoly);
            double cX = (this.wf.getFromX() + this.wf.getToX()) / 2.0;
            double cY = (this.wf.getFromY() + this.wf.getToY()) / 2.0;
            PolyBase.Point ctr = Poly3D.fromLambda(cX, cY);
            int angle = DBMath.figureAngle(toPT, fromPT);
            int arrowAngle = (angle + 300) % 3600;
            double arrowHeadLength = GenMath.distBetweenPoints(fromPT, toPT) / 10.0;
            double endX = DBMath.cos(arrowAngle) * arrowHeadLength + cX;
            double endY = DBMath.sin(arrowAngle) * arrowHeadLength + cY;
            twoPT = new PolyBase.Point[]{ctr, Poly3D.fromLambda(endX, endY)};
            routePoly = new Poly3D(twoPT, lowZ, lowZ);
            routePoly.setLayer(tech.findLayer("Metal-1"));
            routePoly.setStyle(Poly.Type.OPENED);
            routePoly.setColor(Color.WHITE);
            polys.add(routePoly);
            arrowAngle = (angle + 3300) % 3600;
            endX = DBMath.cos(arrowAngle) * arrowHeadLength + cX;
            endY = DBMath.sin(arrowAngle) * arrowHeadLength + cY;
            twoPT = new PolyBase.Point[]{ctr, Poly3D.fromLambda(endX, endY)};
            routePoly = new Poly3D(twoPT, lowZ, lowZ);
            routePoly.setLayer(tech.findLayer("Metal-1"));
            routePoly.setStyle(Poly.Type.OPENED);
            routePoly.setColor(Color.WHITE);
            polys.add(routePoly);
            PolyBase.Point[] onePT = new PolyBase.Point[]{fromPT};
            routePoly = new Poly3D(onePT, lowZ, highZ);
            routePoly.setLayer(tech.findLayer("Metal-1"));
            routePoly.setStyle(Poly.Type.OPENED);
            routePoly.setColor(Color.WHITE);
            polys.add(routePoly);
            onePT = new PolyBase.Point[]{toPT};
            routePoly = new Poly3D(onePT, lowZ, highZ);
            routePoly.setLayer(tech.findLayer("Metal-1"));
            routePoly.setStyle(Poly.Type.OPENED);
            routePoly.setColor(Color.WHITE);
            polys.add(routePoly);
        }

        private void displaySearchVertex(SeaOfGatesEngine.SearchVertex sv, List<PolyBase> polys) {
            if (sv.getLast() == null) {
                return;
            }
            Technology tech = this.cell.getTechnology();
            double pathSize = 0.75;
            if (sv.getZ() == sv.getLast().getZ()) {
                double z = this.router.getMetalLayer(sv.getZ()).getDistance() - 5.0;
                PolyBase.Point[] pts = new PolyBase.Point[4];
                double lX = Math.min(sv.getX(), sv.getLast().getX());
                double hX = Math.max(sv.getX(), sv.getLast().getX());
                double lY = Math.min(sv.getY(), sv.getLast().getY());
                double hY = Math.max(sv.getY(), sv.getLast().getY());
                pts[0] = Poly3D.fromLambda(lX - pathSize, lY - pathSize);
                pts[1] = Poly3D.fromLambda(lX - pathSize, hY + pathSize);
                pts[2] = Poly3D.fromLambda(hX + pathSize, hY + pathSize);
                pts[3] = Poly3D.fromLambda(hX + pathSize, lY - pathSize);
                Poly3D routePoly = new Poly3D(pts, z, z);
                routePoly.setLayer(tech.findLayer("Metal-1"));
                routePoly.setColor(Color.RED);
                routePoly.setStyle(Poly.Type.CLOSED);
                polys.add(routePoly);
                return;
            }
            double fromZ = this.router.getMetalLayer(sv.getZ()).getDistance() - 5.0;
            double toZ = this.router.getMetalLayer(sv.getLast().getZ()).getDistance() - 5.0;
            PolyBase.Point[] pts = new PolyBase.Point[]{Poly3D.fromLambda(sv.getX() - pathSize, sv.getY() - pathSize), Poly3D.fromLambda(sv.getX() - pathSize, sv.getY() + pathSize), Poly3D.fromLambda(sv.getX() + pathSize, sv.getY() + pathSize), Poly3D.fromLambda(sv.getX() + pathSize, sv.getY() - pathSize)};
            Poly3D routePoly = new Poly3D(pts, fromZ, toZ);
            routePoly.setLayer(tech.findLayer("Metal-1"));
            routePoly.setColor(Color.GREEN);
            routePoly.setStyle(Poly.Type.CLOSED);
            polys.add(routePoly);
            PolyBase.Point[] pts1 = new PolyBase.Point[]{Poly3D.fromLambda(sv.getX(), sv.getY())};
            routePoly = new Poly3D(pts1, fromZ, fromZ);
            routePoly.setLayer(tech.findLayer("Metal-1"));
            routePoly.setColor(Color.BLACK);
            routePoly.setStyle(Poly.Type.TEXTCENT);
            routePoly.setText(sv.getCost() + "");
            polys.add(routePoly);
        }
    }

    private static class RoutingDialog
    extends EModelessDialog {
        private SeaOfGatesEngine router;
        private Map<SeaOfGatesEngine.SearchVertex, SVState> svInfo;
        private SeaOfGatesEngine.SearchVertex[] seeSV = new SeaOfGatesEngine.SearchVertex[6];
        private SeaOfGatesEngine.SearchVertex currentSV = null;
        private SeaOfGatesEngine.GlobalRouter globalRoutingResults;
        private JLabel routeDescriptionFrom;
        private JLabel routeDescriptionTo;
        private JLabel routeResult;
        private JLabel labValue;
        private JLabel grInfo;
        private JTextField whichOne;
        private JTextField whichLayer;
        private JTextField whichStep;
        private JTextArea[] dirData;
        private JButton[] dirShow;
        private JLabel[] costShow;

        public RoutingDialog() {
            super(TopLevel.getCurrentJFrame());
            this.getContentPane().setLayout(new GridBagLayout());
            this.setTitle("Debug Routing");
            this.setName("");
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    RoutingDebug.endDebugging();
                }
            });
            int yPos = 0;
            JButton runA = new JButton("Run From A");
            runA.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    RoutingDebug.showRouting(true, false);
                }
            });
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = yPos;
            gbc.weightx = 0.5;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)runA, gbc);
            JButton run3DA = new JButton("Run 3D From A");
            run3DA.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    RoutingDebug.showRouting(true, true);
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = yPos;
            gbc.weightx = 0.5;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)run3DA, gbc);
            JLabel lab1 = new JLabel("Route to Debug:");
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = yPos++;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)lab1, gbc);
            JButton runB = new JButton("Run From B");
            runB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    RoutingDebug.showRouting(false, false);
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = yPos;
            gbc.weightx = 0.5;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)runB, gbc);
            JButton run3DB = new JButton("Run 3D From B");
            run3DB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    RoutingDebug.showRouting(false, true);
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = yPos;
            gbc.weightx = 0.5;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)run3DB, gbc);
            this.whichOne = new JTextField("");
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = yPos++;
            gbc.fill = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.whichOne, gbc);
            JButton showEndBlockage = new JButton("Show End Blockage");
            showEndBlockage.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    RoutingDebug.showEndBlockages();
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = yPos;
            gbc.weightx = 0.5;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)showEndBlockage, gbc);
            JButton doGlobalRouting = new JButton("Show Global Routing");
            doGlobalRouting.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    RoutingDebug.doGlobalRouting();
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = yPos;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)doGlobalRouting, gbc);
            JButton unrouteSeg = new JButton("Unroute Segment");
            unrouteSeg.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Routing.unrouteCurrentSegment();
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = yPos++;
            gbc.weightx = 0.5;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)unrouteSeg, gbc);
            JButton showAreaBlockage = new JButton("Show Area Blockage");
            showAreaBlockage.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    RoutingDebug.showAreaBlockages();
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = yPos;
            gbc.weightx = 0.5;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)showAreaBlockage, gbc);
            JButton rewire = new JButton("Rewire for Routing");
            rewire.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    RoutingDebug.rewireNets();
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = yPos;
            gbc.weightx = 0.5;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)rewire, gbc);
            JButton unrouteNet = new JButton("Unroute Network");
            unrouteNet.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Routing.unrouteCurrent();
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = yPos++;
            gbc.weightx = 0.5;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)unrouteNet, gbc);
            JButton showRoutingGrid = new JButton("Show Routing Grid");
            showRoutingGrid.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    RoutingDebug.showRoutingGrid();
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = yPos;
            gbc.weightx = 0.5;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)showRoutingGrid, gbc);
            JLabel lab2 = new JLabel("Layer to grid:");
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = yPos;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)lab2, gbc);
            this.whichLayer = new JTextField("1");
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = yPos++;
            gbc.fill = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.whichLayer, gbc);
            this.routeDescriptionFrom = new JLabel("");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = yPos++;
            gbc.gridwidth = 3;
            gbc.fill = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.weightx = 1.0;
            this.getContentPane().add((Component)this.routeDescriptionFrom, gbc);
            this.routeDescriptionTo = new JLabel("");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = yPos++;
            gbc.gridwidth = 3;
            gbc.fill = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.weightx = 1.0;
            this.getContentPane().add((Component)this.routeDescriptionTo, gbc);
            this.routeResult = new JLabel("");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = yPos++;
            gbc.gridwidth = 3;
            gbc.fill = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.weightx = 1.0;
            this.getContentPane().add((Component)this.routeResult, gbc);
            JPanel panel = this.makeSVPanel();
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = yPos++;
            gbc.gridwidth = 3;
            gbc.fill = 1;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.weightx = 1.0;
            gbc.weighty = 0.5;
            this.getContentPane().add((Component)panel, gbc);
            JPanel grPanel = new JPanel();
            grPanel.setLayout(new GridBagLayout());
            grPanel.setBorder(BorderFactory.createTitledBorder("Global Routing"));
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = yPos++;
            gbc.gridwidth = 3;
            gbc.fill = 1;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.weightx = 1.0;
            this.getContentPane().add((Component)grPanel, gbc);
            this.grInfo = new JLabel("");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.fill = 1;
            gbc.weighty = 1.0;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(4, 4, 4, 4);
            grPanel.add((Component)this.grInfo, gbc);
            this.pack();
            this.finishInitialization();
            this.setVisible(true);
        }

        private JPanel makeSVPanel() {
            JPanel panel = new JPanel();
            panel.setLayout(new GridBagLayout());
            panel.setBorder(BorderFactory.createTitledBorder("Forward and Backward Propagation"));
            JButton backButton = new JButton("Back");
            backButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    RoutingDialog.this.showBack();
                }
            });
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.fill = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            panel.add((Component)backButton, gbc);
            JButton nextButton = new JButton("Next");
            nextButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    RoutingDialog.this.showNext();
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.fill = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            panel.add((Component)nextButton, gbc);
            this.whichStep = new JTextField("");
            this.whichStep.setColumns(5);
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 0;
            gbc.fill = 2;
            gbc.anchor = 13;
            gbc.insets = new Insets(4, 4, 4, 0);
            panel.add((Component)this.whichStep, gbc);
            JButton goButton = new JButton("Show Routing Step");
            goButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    RoutingDialog.this.showStepButton();
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 3;
            gbc.gridy = 0;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 0, 4, 4);
            panel.add((Component)goButton, gbc);
            this.labValue = new JLabel("");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 4;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            panel.add((Component)this.labValue, gbc);
            this.dirData = new JTextArea[6];
            this.dirShow = new JButton[6];
            this.costShow = new JLabel[6];
            for (int i = 0; i < 6; ++i) {
                this.dirShow[i] = new JButton("See");
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = i * 2 + 2;
                gbc.gridheight = 2;
                gbc.anchor = 11;
                gbc.fill = 2;
                gbc.insets = new Insets(4, 4, 4, 4);
                panel.add((Component)this.dirShow[i], gbc);
                String lab = "";
                switch (i) {
                    case 0: {
                        lab = "-X";
                        break;
                    }
                    case 1: {
                        lab = "+X";
                        break;
                    }
                    case 2: {
                        lab = "-Y";
                        break;
                    }
                    case 3: {
                        lab = "+Y";
                        break;
                    }
                    case 4: {
                        lab = "Down";
                        break;
                    }
                    case 5: {
                        lab = "Up";
                    }
                }
                JLabel dirLabel = new JLabel(lab);
                gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = i * 2 + 2;
                gbc.weightx = 0.1;
                gbc.anchor = 15;
                gbc.fill = 2;
                gbc.insets = new Insets(4, 4, 0, 4);
                panel.add((Component)dirLabel, gbc);
                this.costShow[i] = new JLabel("");
                gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = i * 2 + 3;
                gbc.weightx = 0.1;
                gbc.anchor = 11;
                gbc.insets = new Insets(0, 4, 4, 4);
                panel.add((Component)this.costShow[i], gbc);
                this.dirData[i] = new JTextArea("");
                this.dirData[i].setEditable(false);
                this.dirData[i].setCursor(null);
                this.dirData[i].setOpaque(false);
                this.dirData[i].setFocusable(false);
                this.dirData[i].setLineWrap(true);
                this.dirData[i].setFont(UIManager.getFont("Label.font"));
                gbc = new GridBagConstraints();
                gbc.gridx = 2;
                gbc.gridy = i * 2 + 2;
                gbc.gridwidth = 2;
                gbc.gridheight = 2;
                gbc.weightx = 0.9;
                gbc.weighty = 0.2;
                gbc.anchor = 18;
                gbc.fill = 1;
                gbc.insets = new Insets(4, 4, 4, 4);
                panel.add((Component)this.dirData[i], gbc);
            }
            this.dirShow[0].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    RoutingDialog.this.see(0);
                }
            });
            this.dirShow[1].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    RoutingDialog.this.see(1);
                }
            });
            this.dirShow[2].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    RoutingDialog.this.see(2);
                }
            });
            this.dirShow[3].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    RoutingDialog.this.see(3);
                }
            });
            this.dirShow[4].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    RoutingDialog.this.see(4);
                }
            });
            this.dirShow[5].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    RoutingDialog.this.see(5);
                }
            });
            return panel;
        }

        private void setRouteDescription(String desc1, String desc2) {
            this.routeDescriptionFrom.setText(desc1);
            this.routeDescriptionTo.setText(desc2);
        }

        private void see(int index) {
            SeaOfGatesEngine.SearchVertex sv = this.seeSV[index];
            if (sv == null) {
                return;
            }
            this.seeSelectedSV(sv);
        }

        private void showBack() {
            if (this.currentSV == null || this.currentSV.getLast() == null) {
                return;
            }
            this.seeSelectedSV(this.currentSV.getLast());
        }

        private void showNext() {
            if (debugDialog == null || debugDialog.svInfo == null) {
                return;
            }
            SeaOfGatesEngine.SearchVertex foundSV = null;
            if (this.currentSV == null) {
                return;
            }
            SVState svs = this.svInfo.get(this.currentSV);
            String stepNum = svs.msg.equals("START") ? "1" : TextUtils.atoi(svs.msg) + 1 + "";
            for (SeaOfGatesEngine.SearchVertex sv : debugDialog.svInfo.keySet()) {
                svs = this.svInfo.get(sv);
                if (!svs.msg.equals(stepNum)) continue;
                foundSV = sv;
                break;
            }
            if (foundSV != null) {
                this.seeSelectedSV(foundSV);
            } else {
                System.out.println("No Routing Step numbered " + stepNum);
            }
        }

        private void showStepButton() {
            if (debugDialog == null || debugDialog.svInfo == null) {
                return;
            }
            String stepNum = this.whichStep.getText().trim();
            SeaOfGatesEngine.SearchVertex foundSV = null;
            for (SeaOfGatesEngine.SearchVertex sv : debugDialog.svInfo.keySet()) {
                SVState svs = this.svInfo.get(sv);
                if (!svs.msg.equals(stepNum)) continue;
                foundSV = sv;
                break;
            }
            if (foundSV != null) {
                this.seeSelectedSV(foundSV);
            } else {
                System.out.println("No Routing Step numbered " + stepNum);
            }
        }

        private void seeSelectedSV(SeaOfGatesEngine.SearchVertex sv) {
            String msg;
            Highlight.Message hMsgLast;
            SVState oldSVS;
            if (debugDialog == null) {
                return;
            }
            EditWindow wnd = EditWindow.getCurrent();
            Highlighter h = wnd.getRulerHighlighter();
            if (this.currentSV != null && (oldSVS = this.svInfo.get(this.currentSV)) != null) {
                oldSVS.setBackgroundColor(null, h);
            }
            this.currentSV = sv;
            SVState svs = this.svInfo.get(sv);
            svs.setBackgroundColor(Color.WHITE, h);
            for (int i = 0; i < 6; ++i) {
                this.dirData[i].setText("");
                this.dirShow[i].setText("See");
                this.dirShow[i].setEnabled(false);
                this.costShow[i].setText("");
            }
            Highlight.Message hMsg = (Highlight.Message)svs.label;
            if (svs.details == null) {
                String msg2 = "At (" + TextUtils.formatDouble(sv.getX()) + "," + TextUtils.formatDouble(sv.getY()) + ",M" + (sv.getZ() + 1) + "), Cost=" + sv.getCost();
                if (sv.getLast() != null) {
                    SVState svsLast = this.svInfo.get(sv.getLast());
                    hMsgLast = (Highlight.Message)svsLast.label;
                    msg2 = sv.getGRBucket() < 0 ? msg2 + ", NO Global Routing" : msg2 + ", Global Routing Bucket: " + sv.getGRBucket();
                    msg2 = msg2 + ", previous point " + hMsgLast.getInfo() + " at (" + TextUtils.formatDouble(sv.getLast().getX()) + "," + TextUtils.formatDouble(sv.getLast().getY()) + ",M" + (sv.getLast().getZ() + 1) + ")";
                }
                this.labValue.setText(hMsg.getInfo() + ": " + msg2 + ", DID NOT GET PROPAGATED");
            } else {
                String lab = hMsg.getInfo() + ": " + svs.details[0];
                if (sv.getLast() != null) {
                    SVState svsLast = this.svInfo.get(sv.getLast());
                    hMsgLast = (Highlight.Message)svsLast.label;
                    lab = lab + ", previous point " + hMsgLast.getInfo() + " at (" + TextUtils.formatDouble(sv.getLast().getX()) + "," + TextUtils.formatDouble(sv.getLast().getY()) + ",M" + (sv.getLast().getZ() + 1) + ")";
                }
                this.labValue.setText(lab);
                for (int i = 0; i < 6; ++i) {
                    if (svs.details[i + 1] == null) continue;
                    if (svs.details[i + 1].indexOf(124) >= 0) {
                        String leading = "> ";
                        String[] subParts = svs.details[i + 1].split("\\|");
                        msg = subParts[0];
                        for (int j = 1; j < subParts.length; ++j) {
                            msg = msg + "\n" + leading + subParts[j];
                        }
                        this.dirData[i].setText(msg);
                    } else {
                        this.dirData[i].setText(svs.details[i + 1]);
                    }
                    this.seeSV[i] = svs.nextVertices[i];
                    if (this.seeSV[i] == null) continue;
                    SVState svsNext = this.svInfo.get(this.seeSV[i]);
                    if (svsNext == null) {
                        this.dirShow[i].setText("?");
                    } else {
                        Highlight.Message hMsgNext = (Highlight.Message)svsNext.label;
                        this.dirShow[i].setText(hMsgNext.getInfo());
                        this.dirShow[i].setEnabled(true);
                    }
                    this.costShow[i].setText("Cost: " + this.seeSV[i].getCost());
                }
            }
            if (sv.getWavefront().getGRDirection() == 0) {
                this.grInfo.setText("No Global Routing data");
            } else {
                int b;
                SeaOfGatesEngine.Wavefront wf = sv.getWavefront();
                SeaOfGatesEngine.NeededRoute nr = wf.getNeededRoute();
                Rectangle2D[] buckets = nr.getGRBuckets();
                Rectangle2D[] orderedBuckets = wf.getOrderedBuckets();
                msg = "<html>";
                for (b = 0; b < orderedBuckets.length; ++b) {
                    msg = msg + "Bucket " + b + " is " + TextUtils.formatDouble(buckets[b].getMinX()) + "&lt;=X&lt;=" + TextUtils.formatDouble(buckets[b].getMaxX()) + " and " + TextUtils.formatDouble(buckets[b].getMinY()) + "&lt;=Y&lt;=" + TextUtils.formatDouble(buckets[b].getMaxY()) + "<p>";
                }
                for (b = 0; b < orderedBuckets.length; ++b) {
                    msg = msg + "Ordered Bucket " + b + " is " + TextUtils.formatDouble(orderedBuckets[b].getMinX()) + "&lt;=X&lt;=" + TextUtils.formatDouble(orderedBuckets[b].getMaxX()) + " and " + TextUtils.formatDouble(orderedBuckets[b].getMinY()) + "&lt;=Y&lt;=" + TextUtils.formatDouble(orderedBuckets[b].getMaxY()) + "<p>";
                }
                msg = msg + "</html>";
                this.grInfo.setText(msg);
            }
            wnd.fullRepaint();
            this.pack();
        }

        @Override
        protected void escapePressed() {
            RoutingDebug.endDebugging();
        }

        private void showGlobalRoutingGrid() {
            EditWindow wnd = EditWindow.getCurrent();
            Cell cell = wnd.getCell();
            Highlighter h = wnd.getRulerHighlighter();
            ERectangle bounds = cell.getBounds();
            double bucketWidth = bounds.getWidth() / (double)this.globalRoutingResults.getXBuckets();
            double bucketHeight = bounds.getHeight() / (double)this.globalRoutingResults.getYBuckets();
            for (int x2 = 0; x2 <= this.globalRoutingResults.getXBuckets(); ++x2) {
                double xPos = bounds.getMinX() + (double)x2 * bucketWidth;
                h.addLine(EPoint.fromLambda(xPos, bounds.getMinY()), EPoint.fromLambda(xPos, bounds.getMaxY()), cell, false, Color.RED, false);
            }
            for (int y = 0; y <= this.globalRoutingResults.getYBuckets(); ++y) {
                double yPos = bounds.getMinY() + (double)y * bucketHeight;
                h.addLine(EPoint.fromLambda(bounds.getMinX(), yPos), EPoint.fromLambda(bounds.getMaxX(), yPos), cell, false, Color.RED, false);
            }
        }

        private void showGlobalRoutingPath(SeaOfGatesEngine.NeededRoute nr) {
            EditWindow wnd = EditWindow.getCurrent();
            Cell cell = wnd.getCell();
            Highlighter h = wnd.getRulerHighlighter();
            HashSet<Integer> xUsed = new HashSet<Integer>();
            HashSet<Integer> yUsed = new HashSet<Integer>();
            for (SeaOfGatesEngine.GRNet net : debugDialog.globalRoutingResults.getNets()) {
                for (SeaOfGatesEngine.GRWire w : net.getWires()) {
                    if (nr != null && w.getNeededRoute() != nr) continue;
                    EPoint p1 = w.getPoint1();
                    EPoint p2 = w.getPoint2();
                    SeaOfGatesEngine.GRBucket n1 = w.getBucket1();
                    SeaOfGatesEngine.GRBucket n2 = w.getBucket2();
                    SeaOfGatesEngine.GRBucket prev = null;
                    double prevX = 0.0;
                    double prevY = 0.0;
                    for (int i = 0; i < w.getNumPathElements(); ++i) {
                        SeaOfGatesEngine.GRBucket n = w.getPathBucket(i);
                        Rectangle2D bucketBound = n.getBounds();
                        double x2 = bucketBound.getCenterX();
                        double y = bucketBound.getCenterY();
                        boolean adjusted = false;
                        if (n == n1) {
                            x2 = p1.getX();
                            y = p1.getY();
                            adjusted = true;
                        }
                        if (n == n2) {
                            x2 = p2.getX();
                            y = p2.getY();
                            adjusted = true;
                        }
                        if (!adjusted) {
                            Integer yi;
                            Integer xi;
                            if (i > 0) {
                                if (w.getPathBucket(i - 1).getBounds().getCenterX() == x2) {
                                    if (w.getPathBucket(i - 1) == n1) {
                                        x2 = p1.getX();
                                    }
                                    if (w.getPathBucket(i - 1) == n2) {
                                        x2 = p2.getX();
                                    }
                                }
                                if (w.getPathBucket(i - 1).getBounds().getCenterY() == y) {
                                    if (w.getPathBucket(i - 1) == n1) {
                                        y = p1.getY();
                                    }
                                    if (w.getPathBucket(i - 1) == n2) {
                                        y = p2.getY();
                                    }
                                }
                            }
                            if (i < w.getNumPathElements() - 1) {
                                if (w.getPathBucket(i + 1).getBounds().getCenterX() == x2) {
                                    if (w.getPathBucket(i + 1) == n1) {
                                        x2 = p1.getX();
                                    }
                                    if (w.getPathBucket(i + 1) == n2) {
                                        x2 = p2.getX();
                                    }
                                }
                                if (w.getPathBucket(i + 1).getBounds().getCenterY() == y) {
                                    if (w.getPathBucket(i + 1) == n1) {
                                        y = p1.getY();
                                    }
                                    if (w.getPathBucket(i + 1) == n2) {
                                        y = p2.getY();
                                    }
                                }
                            }
                            while (xUsed.contains(xi = Integer.valueOf((int)x2))) {
                                x2 += 1.0;
                            }
                            xUsed.add(xi);
                            while (yUsed.contains(yi = Integer.valueOf((int)y))) {
                                y += 1.0;
                            }
                            yUsed.add(yi);
                        }
                        if (prev != null) {
                            h.addLine(EPoint.fromLambda(prevX, prevY), EPoint.fromLambda(x2, y), cell, false, Color.GREEN, false);
                        }
                        if (i == 0 || i == w.getNumPathElements() - 1) {
                            int xSize = 2;
                            h.addLine(EPoint.fromLambda(x2 - (double)xSize, y - (double)xSize), EPoint.fromLambda(x2 + (double)xSize, y + (double)xSize), cell, false, Color.GREEN, false);
                            h.addLine(EPoint.fromLambda(x2 - (double)xSize, y + (double)xSize), EPoint.fromLambda(x2 + (double)xSize, y - (double)xSize), cell, false, Color.GREEN, false);
                        }
                        prev = n;
                        prevX = x2;
                        prevY = y;
                    }
                }
            }
            h.finished();
            wnd.repaint();
        }

        private void showPathToGoal(SeaOfGatesEngine.SearchVertex result2, Cell cell, Highlighter h) {
            if (result2 == SeaOfGatesEngine.svAborted) {
                this.routeResult.setText("Result: Aborted by user");
            } else if (result2 == SeaOfGatesEngine.svExhausted) {
                this.routeResult.setText("Result: Examined all possibilities");
            } else if (result2 == SeaOfGatesEngine.svLimited) {
                this.routeResult.setText("Result: Stopped after " + this.router.getPrefs().complexityLimit + " steps");
            } else {
                SeaOfGatesEngine.SearchVertex svLast;
                this.routeResult.setText("Result: Success!");
                SVState svs = SVState.ensure(result2, cell);
                svs.changeLabel("!!GOAL!!", h);
                while ((svLast = result2.getLast()) != null) {
                    if (result2.getZ() != svLast.getZ()) {
                        int lowZ = Math.min(result2.getZ(), svLast.getZ());
                        int highZ = Math.max(result2.getZ(), svLast.getZ());
                        double lowOff = (double)lowZ * 0.04;
                        double highOff = (double)highZ * 0.04;
                        h.addLine(EPoint.fromLambda(result2.getX() + lowOff, result2.getY() + lowOff + 0.005), EPoint.fromLambda(result2.getX() + highOff - 0.005, result2.getY() + highOff), cell, true, Color.WHITE, false);
                        h.addLine(EPoint.fromLambda(result2.getX() + lowOff + 0.005, result2.getY() + lowOff), EPoint.fromLambda(result2.getX() + highOff, result2.getY() + highOff - 0.005), cell, true, Color.WHITE, false);
                    } else {
                        double off = (double)result2.getZ() * 0.04;
                        if (result2.getX() != svLast.getX()) {
                            h.addLine(EPoint.fromLambda(result2.getX() + off, result2.getY() + off - 0.005), EPoint.fromLambda(svLast.getX() + off, svLast.getY() + off - 0.005), cell, true, Color.WHITE, false);
                            h.addLine(EPoint.fromLambda(result2.getX() + off, result2.getY() + off + 0.005), EPoint.fromLambda(svLast.getX() + off, svLast.getY() + off + 0.005), cell, true, Color.WHITE, false);
                        } else {
                            h.addLine(EPoint.fromLambda(result2.getX() + off - 0.005, result2.getY() + off), EPoint.fromLambda(svLast.getX() + off - 0.005, svLast.getY() + off), cell, true, Color.WHITE, false);
                            h.addLine(EPoint.fromLambda(result2.getX() + off + 0.005, result2.getY() + off), EPoint.fromLambda(svLast.getX() + off + 0.005, svLast.getY() + off), cell, true, Color.WHITE, false);
                        }
                    }
                    result2 = svLast;
                }
            }
        }

        private void showSearchVertices(Cell cell, Highlighter h, SeaOfGatesEngine.Wavefront wf) {
            PortInst piF = wf.getFromPortInst();
            PortInst piT = wf.getToPortInst();
            String fromMsg = "A: (" + TextUtils.formatDouble(wf.getFromX()) + "," + TextUtils.formatDouble(wf.getFromY()) + ", M" + (wf.getFromZ() + 1) + "): port " + piF.getPortProto().getName() + " of node " + piF.getNodeInst().describe(false);
            String toMsg = "B: (" + TextUtils.formatDouble(wf.getToX()) + "," + TextUtils.formatDouble(wf.getToY()) + ", M" + (wf.getToZ() + 1) + "): port " + piT.getPortProto().getName() + " of node " + piT.getNodeInst().describe(false);
            this.setRouteDescription(fromMsg, toMsg);
            HashMap<String, Integer> lowestZ = new HashMap<String, Integer>();
            Map<Integer, Map<Integer, SeaOfGatesEngine.SearchVertex>>[] searchVertexPlanes = wf.getSearchVertexPlanes();
            for (int z = 0; z < this.router.getNumMetals(); ++z) {
                Map<Integer, Map<Integer, SeaOfGatesEngine.SearchVertex>> plane = searchVertexPlanes[z];
                if (plane == null) continue;
                for (Integer y : plane.keySet()) {
                    Map<Integer, SeaOfGatesEngine.SearchVertex> row = plane.get(y);
                    for (Integer x2 : row.keySet()) {
                        SeaOfGatesEngine.SearchVertex sv = row.get(x2);
                        SVState svs = SVState.ensure(sv, cell);
                        svs.showLabel(h);
                        if (sv.getLast() == null) continue;
                        if (sv.getZ() != sv.getLast().getZ()) {
                            int lowZ = Math.min(sv.getZ(), sv.getLast().getZ());
                            int highZ = Math.max(sv.getZ(), sv.getLast().getZ());
                            double lowOff = (double)lowZ * 0.04;
                            double highOff = (double)highZ * 0.04;
                            h.addLine(EPoint.fromLambda(sv.getX() + lowOff, sv.getY() + lowOff), EPoint.fromLambda(sv.getX() + highOff, sv.getY() + highOff), cell, true, Color.WHITE, false);
                        } else {
                            double off = (double)sv.getZ() * 0.04;
                            Color col = this.router.getMetalLayer(sv.getZ()).getGraphics().getColor();
                            h.addLine(EPoint.fromLambda(sv.getX() + off, sv.getY() + off), EPoint.fromLambda(sv.getLast().getX() + off, sv.getLast().getY() + off), cell, false, col, false);
                        }
                        String coordLoc = TextUtils.formatDouble(sv.getX()) + "/" + TextUtils.formatDouble(sv.getY());
                        Integer height = (Integer)lowestZ.get(coordLoc);
                        int lowZ = Math.min(sv.getZ(), sv.getLast().getZ());
                        if (height == null) {
                            height = lowZ;
                        } else {
                            int lowest = Math.min(height, lowZ);
                            height = lowest;
                        }
                        lowestZ.put(coordLoc, height);
                    }
                }
            }
            for (String loc : lowestZ.keySet()) {
                Integer height = (Integer)lowestZ.get(loc);
                if (height <= 0) continue;
                String[] locCoords = loc.split("/");
                double x3 = TextUtils.atof(locCoords[0]);
                double y = TextUtils.atof(locCoords[1]);
                double off = (double)height.intValue() * 0.04;
                h.addLine(EPoint.fromLambda(x3, y), EPoint.fromLambda(x3 + off, y + off), cell, false, Color.BLACK, false);
            }
        }
    }

    private static class SVState {
        Cell cell;
        EPoint anchor;
        String msg;
        Highlight label;
        String[] details;
        SeaOfGatesEngine.SearchVertex[] nextVertices = new SeaOfGatesEngine.SearchVertex[6];

        SVState(SeaOfGatesEngine.SearchVertex sv, Cell cell) {
            this.cell = cell;
            double off = (double)sv.getZ() * 0.04;
            this.anchor = EPoint.fromLambda(sv.getX() + off, sv.getY() + off);
            this.msg = "M" + (sv.getZ() + 1);
            this.label = null;
        }

        void showLabel(Highlighter h) {
            if (this.label != null) {
                h.remove(this.label);
            }
            this.label = h.addMessage(this.cell, this.msg, this.anchor);
        }

        void changeLabel(String msg, Highlighter h) {
            this.msg = msg;
            this.showLabel(h);
        }

        void setBackgroundColor(Color backgroundColor, Highlighter h) {
            if (this.label != null) {
                h.remove(this.label);
            }
            this.label = h.addMessage(this.cell, this.msg, this.anchor, 0, backgroundColor);
        }

        public static SVState ensure(SeaOfGatesEngine.SearchVertex sv, Cell cell) {
            SVState svs = (SVState)debugDialog.svInfo.get(sv);
            if (svs == null) {
                svs = new SVState(sv, cell);
                debugDialog.svInfo.put(sv, svs);
            }
            return svs;
        }
    }

    private static class DebugThread
    extends Job {
        private SeaOfGatesEngine.NeededRoute nr;
        private final List<SeaOfGatesEngine.NeededRoute> allRoutes;

        private DebugThread(SeaOfGatesEngine.NeededRoute nr, List<SeaOfGatesEngine.NeededRoute> allRoutes) {
            super("Debug Sea-Of-Gates Route", User.getUserTool(), Job.Type.CLIENT_EXAMINE, null, null, Job.Priority.USER);
            this.nr = nr;
            this.allRoutes = allRoutes;
        }

        @Override
        public boolean doIt() throws JobException {
            int totalRoutes = this.allRoutes.size();
            for (int r = 0; r < totalRoutes; ++r) {
                SeaOfGatesEngine.NeededRoute nrThis = this.allRoutes.get(r);
                if (nrThis != this.nr) continue;
                EditWindow wnd = EditWindow.getCurrent();
                Cell cell = wnd.getCell();
                Highlighter h = wnd.getRulerHighlighter();
                h.clear();
                RoutingDebug.showGeometryInArea(this.nr);
                debugDialog.svInfo = new HashMap();
                SeaOfGatesEngine.SearchVertex result2 = null;
                int svOrder = 1;
                SeaOfGatesEngine.Wavefront wf = this.nr.makeWavefronts()[endADebug ? 0 : 1];
                while (result2 == null) {
                    SeaOfGatesEngine.SearchVertex sv = wf.getNextSearchVertex();
                    if (sv != SeaOfGatesEngine.svExhausted && sv != SeaOfGatesEngine.svLimited) {
                        SVState svs = SVState.ensure(sv, cell);
                        if (sv.getLast() == null) {
                            svs.changeLabel("START", h);
                        } else {
                            svs.changeLabel(svOrder++ + "", h);
                        }
                    }
                    result2 = wf.advanceWavefront();
                }
                if (debugIn3D) {
                    SwingUtilities.invokeLater(new Show3DRoute(wf, this.nr, debugDialog.router, cell));
                    return true;
                }
                debugDialog.showPathToGoal(result2, cell, h);
                debugDialog.showSearchVertices(cell, h, wf);
                if (debugDialog.globalRoutingResults != null) {
                    debugDialog.showGlobalRoutingGrid();
                    debugDialog.showGlobalRoutingPath(this.nr);
                }
                h.finished();
                EditWindow.repaintAllContents();
                break;
            }
            return true;
        }

        @Override
        public void terminateOK() {
            SeaOfGatesEngine.SearchVertex svStart = null;
            for (SeaOfGatesEngine.SearchVertex sv : debugDialog.svInfo.keySet()) {
                if (sv.getLast() != null) continue;
                svStart = sv;
                break;
            }
            RoutingDebug.showSelectedSV(svStart);
        }
    }

    private static enum DebugType {
        NONE,
        DISPLAYROUTING,
        DISPLAYENDBLOCKAGES,
        DISPLAYAREABLOCKAGES,
        DISPLAYROUTINGGRID,
        REWIRENETS,
        RUNGLOBALROUTING;

    }
}

