"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CAClient = void 0;
const error_1 = require("../error");
const external_1 = require("../external");
const format_1 = require("./format");
class CAClient {
    constructor(options) {
        this.fulcio = new external_1.Fulcio({ baseURL: options.fulcioBaseURL });
    }
    async createSigningCertificate(identityToken, publicKey, challenge) {
        const request = (0, format_1.toCertificateRequest)(identityToken, publicKey, challenge);
        try {
            const certificate = await this.fulcio.createSigningCertificate(request);
            return certificate.signedCertificateEmbeddedSct.chain.certificates;
        }
        catch (err) {
            throw new error_1.InternalError({
                code: 'CA_CREATE_SIGNING_CERTIFICATE_ERROR',
                message: 'error creating signing certificate',
                cause: err,
            });
        }
    }
}
exports.CAClient = CAClient;
