# Node Foundation TSC Meeting 2015-10-14

## Links

* **Audio Recording**: https://soundcloud.com/node-foundation/tsc-meeting-2015-10-14
* **GitHub Issue**: https://github.com/nodejs/node/issues/3363
* **Minutes Google Doc**: <https://docs.google.com/document/d/1tVPxA4Y3n3dmICJFZN2vK93PXjCaUQ-eiN2mvt7zqbE>
* _Previous Minutes Google Doc: <https://docs.google.com/document/d/1LIrTCdTUjKtb_GGecrJ3Es0rPOpVdpkV5kefJ_p5FGU>_

## Present

* Rod Vagg (TSC)
* Domenic Denicola (observer)
* Brian White (TSC)
* Steven Loomis (observer)
* James Snell (TSC)
* Michael Dawson (observer)
* Ben Noordhuis (TSC)
* Jeremiah Senkpiel (TSC)
* Trevor Norris (TSC)
* Alexis Campailla (TSC)
* Mikeal Rogers (observer)

## Agenda

Extracted from **tsc-agenda** labelled issues and pull requests in the nodejs org prior to meeting.

### nodejs/node

* V8 security reporting [#3348](https://github.com/nodejs/node/issues/3348)
* doc: add information about Assert behavior and maintenance [#3330](https://github.com/nodejs/node/pull/3330)
* WG: Considering a new HTTP WG [#3214](https://github.com/nodejs/node/issues/3214)
* Discussion: LTS & v5 release planning [#3000](https://github.com/nodejs/node/issues/3000)
* Compiling node v4.0.0 with OpenSSL 1.0.1 fails [#2783](https://github.com/nodejs/node/issues/2783)

### nodejs/TSC

* Umbrella Program [#2](https://github.com/nodejs/TSC/pull/2)


## Minutes

### Standup

* Rod Vagg: Not quite as involved, took a bit of time off. Getting back up to speed on build
* Domenic: Nothing this week
* Brian: PRs & Issues
* Steven: Worked on getting ICU 56.1 out and into v4.2.0 LTS, working on making the ICU [install better](https://github.com/nodejs/node-v0.x-archive/issues/8996#issuecomment-89411193). Also shepherding iojs-* rename to nodejs-* [#2525](https://github.com/nodejs/node/issues/2525)
* James: Worked on the 4.2.0 and 4.2.1 releases. Working on the cgitm smoke-testing tool and http WG.
* Michael: Worked on adding pLinux to the CI. Looking into running the tests on fips-compliant mode. Investigated some AIX issues.
* Ben: PRs & Issues, doing some work on the debugger and memory bugs in libuv
* Jeremiah: PRs & Issues, working on resolving the timers in beforeExit bug: https://github.com/nodejs/node/pull/2795
* Trevor: Helped Jeremiah with the beforeExit thing, worked on PRs and Issues. Looking into AsyncWrap improvements.
* Alexis: Looking into a native module build service. Worked on the Ci a bit.
* Mikeal: Worked on the Umbrella Program proposal. Helping set up the Node.js Interactive conference.


### Review of previous meeting

* WG: Considering a new HTTP WG [#3214](https://github.com/nodejs/node/issues/3214)
* lib,test: deprecate _linklist [#3078](https://github.com/nodejs/node/pull/3078)
* Discussion: LTS & v5 release planning [#3000](https://github.com/nodejs/node/issues/3000)
* Compiling node v4.0.0 with OpenSSL 1.0.1 fails [#2783](https://github.com/nodejs/node/issues/2783)
* Inspecting Node.js with Chrome DevTools [#2546](https://github.com/nodejs/node/issues/2546)
* Umbrella Program [#2](https://github.com/nodejs/TSC/pull/2)


### V8 security reporting [#3348](https://github.com/nodejs/node/issues/3348)

Michael: Proposal is to add one or more TSC members to the V8 security list. Not all issues will actually be V8 issues, but there shouldn’t be too many.

* Concerns about too many issues

Michael: Let’s go back and ask if a handfull means only 4-5 a week.

Mikeal: Part of the Umbrella Program is to make a top-level security group that all security issues are funneled through. This group may not need to be TSC members.

Ben: How would this group know an issue is relevant to us?

Rod: We are talking about a Chromium security list, so we would probably need someone with enough knowledge to filter out which issues affect us.

Mikeal: They would only be an initial filter.

Rod: Some chromium issues will not be recognizable as V8 issues without prior understanding.

Rod & others: Suggest to add Ben and Fedor to add to the Chromium/V8 security list.

Discussion about the current Security repo / group, and current mailing lists

### doc: add information about Assert behavior and maintenance [#3330](https://github.com/nodejs/node/pull/3330)

Discussion about what assert is intended to do, and how we want to deal with additions and breaking changes in the future.

Discussion about the stability index in the docs.

Resolution: Lock the assert module. Possibly re-evaluate in the future. Close existing open PRs/issues against it after landing doc change.


### WG: Considering a new HTTP WG [#3214](https://github.com/nodejs/node/issues/3214)

James: having scheduling problems for an initial hangout but are getting a lot of interest from outside of core, including Doug Wilson and Eran Hammer.

Discussion about the WG’s goals and how we should possibly think about handing over authority of the http module to this WG in the future. (At charter time or later on)

### Discussion: LTS & v5 release planning [#3000](https://github.com/nodejs/node/issues/3000)

James: recommended that we adopt a general rule that commits must go through at least one stable release before going into an LTS. Exceptions to this are security problems and changes that can’t go on to stable.

### Compiling node v4.0.0 with OpenSSL 1.0.1 fails [#2783](https://github.com/nodejs/node/issues/2783)

Conclusion was that this would be difficult and would result in a build that had some features disabled. The TSC is not going to undertake this work and would have reservations officially supporting a build that cripples some crypto features. However, pull requests for this work are welcome and would be considered.

### Umbrella Program [#2](https://github.com/nodejs/TSC/pull/2)

Mikeal sought a vote from the TSC to adopt the Project Lifecycle document and the Core TLP document.

Resolution: there were no abstentions from voting and no disagreement amongst TSC members present, additional TSC members have registered their +1 on the PR so the motion is passed.

## Next Meeting

October 21st, 2015
