/*
 * Copyright (C) 2014 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#import <WebKit/WKFoundation.h>

#if !TARGET_OS_IPHONE

#import <AppKit/AppKit.h>

@class WKView;
@class WKWebView;

WK_EXTERN API_AVAILABLE(macos(10.10), ios(8.0))
@interface _WKThumbnailView : NSView

#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdeprecated-declarations"
- (instancetype)initWithFrame:(NSRect)frame fromWKView:(WKView *)wkView;
#pragma clang diagnostic pop
- (instancetype)initWithFrame:(NSRect)frame fromWKWebView:(WKWebView *)webView;

@property (nonatomic) CGFloat scale;
@property (nonatomic, readonly) CGSize snapshotSize;
@property (nonatomic) CGSize maximumSnapshotSize;
@property (nonatomic) BOOL exclusivelyUsesSnapshot;

// Defaults to NO.
@property (nonatomic) BOOL shouldKeepSnapshotWhenRemovedFromSuperview;

@property (strong, nonatomic) NSColor *overrideBackgroundColor;

- (void)requestSnapshot;

@end

#endif // TARGET_OS_IPHONE
