/*
 * Copyright (C) 2021 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#if ENABLE(VIDEO)

#include "PlatformTrackConfiguration.h"
#include "PlatformVideoColorSpace.h"

namespace WebCore {

struct PlatformVideoTrackConfiguration : PlatformTrackConfiguration {
    uint32_t width { 0 };
    uint32_t height { 0 };
    PlatformVideoColorSpace colorSpace;
    double framerate { 0 };
    uint64_t bitrate { 0 };

    template <class Encoder> void encode(Encoder&) const;
    template <class Decoder> static WARN_UNUSED_RETURN bool decode(Decoder&, PlatformVideoTrackConfiguration&);
};

inline bool operator==(const PlatformVideoTrackConfiguration& a, const PlatformVideoTrackConfiguration& b)
{
    return a.codec == b.codec
        && a.width == b.width
        && a.height == b.height
        && a.colorSpace == b.colorSpace
        && a.framerate == b.framerate
        && a.bitrate == b.bitrate;
}

template <class Encoder>
void PlatformVideoTrackConfiguration::encode(Encoder& encoder) const
{
    encoder << codec;
    encoder << width;
    encoder << height;
    encoder << colorSpace;
    encoder << framerate;
    encoder << bitrate;
}

template <class Decoder>
bool PlatformVideoTrackConfiguration::decode(Decoder& decoder, PlatformVideoTrackConfiguration& configuration)
{
    return decoder.decode(configuration.codec)
        && decoder.decode(configuration.width)
        && decoder.decode(configuration.height)
        && decoder.decode(configuration.colorSpace)
        && decoder.decode(configuration.framerate)
        && decoder.decode(configuration.bitrate);
}

}

#endif
