// This file is automatically generated from CSSProperties.json by the process-css-properties.py script. Do not edit it.

#pragma once

#include <array>
#include <wtf/HashFunctions.h>
#include <wtf/HashTraits.h>

namespace WebCore {

class Settings;

enum CSSPropertyID : uint16_t {
    CSSPropertyInvalid = 0,
    CSSPropertyCustom = 1,
    CSSPropertyColorScheme = 2,
    CSSPropertyWritingMode = 3,
    CSSPropertyWebkitRubyPosition = 4,
    CSSPropertyColor = 5,
    CSSPropertyDirection = 6,
    CSSPropertyDisplay = 7,
    CSSPropertyFontFamily = 8,
    CSSPropertyFontFeatureSettings = 9,
    CSSPropertyFontKerning = 10,
    CSSPropertyFontOpticalSizing = 11,
    CSSPropertyFontPalette = 12,
    CSSPropertyFontSize = 13,
    CSSPropertyFontSizeAdjust = 14,
    CSSPropertyFontStretch = 15,
    CSSPropertyFontStyle = 16,
    CSSPropertyFontSynthesisSmallCaps = 17,
    CSSPropertyFontSynthesisStyle = 18,
    CSSPropertyFontSynthesisWeight = 19,
    CSSPropertyFontVariantAlternates = 20,
    CSSPropertyFontVariantCaps = 21,
    CSSPropertyFontVariantEastAsian = 22,
    CSSPropertyFontVariantLigatures = 23,
    CSSPropertyFontVariantNumeric = 24,
    CSSPropertyFontVariantPosition = 25,
    CSSPropertyFontVariationSettings = 26,
    CSSPropertyFontWeight = 27,
    CSSPropertyTextOrientation = 28,
    CSSPropertyTextRendering = 29,
    CSSPropertyZoom = 30,
    CSSPropertyWebkitFontSmoothing = 31,
    CSSPropertyWebkitLocale = 32,
    CSSPropertyWebkitTextSizeAdjust = 33,
    CSSPropertyWebkitTextZoom = 34,
    CSSPropertyLetterSpacing = 35,
    CSSPropertyTextAutospace = 36,
    CSSPropertyTextSpacingTrim = 37,
    CSSPropertyAccentColor = 38,
    CSSPropertyAdditiveSymbols = 39,
    CSSPropertyAlignContent = 40,
    CSSPropertyAlignItems = 41,
    CSSPropertyAlignSelf = 42,
    CSSPropertyAlignTracks = 43,
    CSSPropertyAlignmentBaseline = 44,
    CSSPropertyAlt = 45,
    CSSPropertyAnimationComposition = 46,
    CSSPropertyAnimationDelay = 47,
    CSSPropertyAnimationDirection = 48,
    CSSPropertyAnimationDuration = 49,
    CSSPropertyAnimationFillMode = 50,
    CSSPropertyAnimationIterationCount = 51,
    CSSPropertyAnimationName = 52,
    CSSPropertyAnimationPlayState = 53,
    CSSPropertyAnimationTimingFunction = 54,
    CSSPropertyAppearance = 55,
    CSSPropertyAspectRatio = 56,
    CSSPropertyBackfaceVisibility = 57,
    CSSPropertyBackgroundAttachment = 58,
    CSSPropertyBackgroundBlendMode = 59,
    CSSPropertyBackgroundColor = 60,
    CSSPropertyBackgroundImage = 61,
    CSSPropertyBackgroundPositionX = 62,
    CSSPropertyBackgroundPositionY = 63,
    CSSPropertyBackgroundRepeat = 64,
    CSSPropertyBackgroundSize = 65,
    CSSPropertyBasePalette = 66,
    CSSPropertyBaselineShift = 67,
    CSSPropertyBlockStepInsert = 68,
    CSSPropertyBlockStepSize = 69,
    CSSPropertyBorderCollapse = 70,
    CSSPropertyBorderImageOutset = 71,
    CSSPropertyBorderImageRepeat = 72,
    CSSPropertyBorderImageSlice = 73,
    CSSPropertyBorderImageSource = 74,
    CSSPropertyBorderImageWidth = 75,
    CSSPropertyBoxSizing = 76,
    CSSPropertyBreakAfter = 77,
    CSSPropertyBreakBefore = 78,
    CSSPropertyBreakInside = 79,
    CSSPropertyBufferedRendering = 80,
    CSSPropertyCaptionSide = 81,
    CSSPropertyCaretColor = 82,
    CSSPropertyClear = 83,
    CSSPropertyClip = 84,
    CSSPropertyClipPath = 85,
    CSSPropertyClipRule = 86,
    CSSPropertyColorInterpolation = 87,
    CSSPropertyColorInterpolationFilters = 88,
    CSSPropertyColumnCount = 89,
    CSSPropertyColumnFill = 90,
    CSSPropertyColumnGap = 91,
    CSSPropertyColumnRuleColor = 92,
    CSSPropertyColumnRuleStyle = 93,
    CSSPropertyColumnRuleWidth = 94,
    CSSPropertyColumnSpan = 95,
    CSSPropertyColumnWidth = 96,
    CSSPropertyContain = 97,
    CSSPropertyContainerName = 98,
    CSSPropertyContainerType = 99,
    CSSPropertyContent = 100,
    CSSPropertyContentVisibility = 101,
    CSSPropertyCounterIncrement = 102,
    CSSPropertyCounterReset = 103,
    CSSPropertyCounterSet = 104,
    CSSPropertyCursor = 105,
    CSSPropertyCx = 106,
    CSSPropertyCy = 107,
    CSSPropertyDominantBaseline = 108,
    CSSPropertyEmptyCells = 109,
    CSSPropertyFallback = 110,
    CSSPropertyFill = 111,
    CSSPropertyFillOpacity = 112,
    CSSPropertyFillRule = 113,
    CSSPropertyFilter = 114,
    CSSPropertyFlexBasis = 115,
    CSSPropertyFlexDirection = 116,
    CSSPropertyFlexGrow = 117,
    CSSPropertyFlexShrink = 118,
    CSSPropertyFlexWrap = 119,
    CSSPropertyFloat = 120,
    CSSPropertyFloodColor = 121,
    CSSPropertyFloodOpacity = 122,
    CSSPropertyFontDisplay = 123,
    CSSPropertyGlyphOrientationHorizontal = 124,
    CSSPropertyGlyphOrientationVertical = 125,
    CSSPropertyGridAutoColumns = 126,
    CSSPropertyGridAutoFlow = 127,
    CSSPropertyGridAutoRows = 128,
    CSSPropertyGridColumnEnd = 129,
    CSSPropertyGridColumnStart = 130,
    CSSPropertyGridRowEnd = 131,
    CSSPropertyGridRowStart = 132,
    CSSPropertyGridTemplateAreas = 133,
    CSSPropertyGridTemplateColumns = 134,
    CSSPropertyGridTemplateRows = 135,
    CSSPropertyHangingPunctuation = 136,
    CSSPropertyHyphenateCharacter = 137,
    CSSPropertyHyphens = 138,
    CSSPropertyImageOrientation = 139,
    CSSPropertyImageRendering = 140,
    CSSPropertyInherits = 141,
    CSSPropertyInitialValue = 142,
    CSSPropertyInputSecurity = 143,
    CSSPropertyIsolation = 144,
    CSSPropertyJustifyContent = 145,
    CSSPropertyJustifyItems = 146,
    CSSPropertyJustifySelf = 147,
    CSSPropertyJustifyTracks = 148,
    CSSPropertyKerning = 149,
    CSSPropertyLightingColor = 150,
    CSSPropertyLineBreak = 151,
    CSSPropertyLineHeight = 152,
    CSSPropertyListStyleImage = 153,
    CSSPropertyListStylePosition = 154,
    CSSPropertyListStyleType = 155,
    CSSPropertyMarginTrim = 156,
    CSSPropertyMarkerEnd = 157,
    CSSPropertyMarkerMid = 158,
    CSSPropertyMarkerStart = 159,
    CSSPropertyMaskBorderOutset = 160,
    CSSPropertyMaskBorderRepeat = 161,
    CSSPropertyMaskBorderSlice = 162,
    CSSPropertyMaskBorderSource = 163,
    CSSPropertyMaskBorderWidth = 164,
    CSSPropertyMaskImage = 165,
    CSSPropertyMaskOrigin = 166,
    CSSPropertyMaskRepeat = 167,
    CSSPropertyMaskSize = 168,
    CSSPropertyMaskType = 169,
    CSSPropertyMasonryAutoFlow = 170,
    CSSPropertyMathStyle = 171,
    CSSPropertyMixBlendMode = 172,
    CSSPropertyNegative = 173,
    CSSPropertyObjectFit = 174,
    CSSPropertyObjectPosition = 175,
    CSSPropertyOffsetAnchor = 176,
    CSSPropertyOffsetDistance = 177,
    CSSPropertyOffsetPath = 178,
    CSSPropertyOffsetPosition = 179,
    CSSPropertyOffsetRotate = 180,
    CSSPropertyOpacity = 181,
    CSSPropertyOrder = 182,
    CSSPropertyOrphans = 183,
    CSSPropertyOutlineColor = 184,
    CSSPropertyOutlineOffset = 185,
    CSSPropertyOutlineStyle = 186,
    CSSPropertyOutlineWidth = 187,
    CSSPropertyOverflowAnchor = 188,
    CSSPropertyOverflowWrap = 189,
    CSSPropertyOverflowX = 190,
    CSSPropertyOverflowY = 191,
    CSSPropertyOverrideColors = 192,
    CSSPropertyPad = 193,
    CSSPropertyPage = 194,
    CSSPropertyPaintOrder = 195,
    CSSPropertyPerspective = 196,
    CSSPropertyPerspectiveOriginX = 197,
    CSSPropertyPerspectiveOriginY = 198,
    CSSPropertyPointerEvents = 199,
    CSSPropertyPosition = 200,
    CSSPropertyPrefix = 201,
    CSSPropertyPrintColorAdjust = 202,
    CSSPropertyQuotes = 203,
    CSSPropertyR = 204,
    CSSPropertyRange = 205,
    CSSPropertyResize = 206,
    CSSPropertyRotate = 207,
    CSSPropertyRowGap = 208,
    CSSPropertyRx = 209,
    CSSPropertyRy = 210,
    CSSPropertyScale = 211,
    CSSPropertyScrollBehavior = 212,
    CSSPropertyScrollSnapAlign = 213,
    CSSPropertyScrollSnapStop = 214,
    CSSPropertyScrollSnapType = 215,
    CSSPropertyScrollbarColor = 216,
    CSSPropertyScrollbarGutter = 217,
    CSSPropertyScrollbarWidth = 218,
    CSSPropertyShapeImageThreshold = 219,
    CSSPropertyShapeMargin = 220,
    CSSPropertyShapeOutside = 221,
    CSSPropertyShapeRendering = 222,
    CSSPropertySize = 223,
    CSSPropertySizeAdjust = 224,
    CSSPropertySpeakAs = 225,
    CSSPropertySrc = 226,
    CSSPropertyStopColor = 227,
    CSSPropertyStopOpacity = 228,
    CSSPropertyStroke = 229,
    CSSPropertyStrokeColor = 230,
    CSSPropertyStrokeDasharray = 231,
    CSSPropertyStrokeDashoffset = 232,
    CSSPropertyStrokeLinecap = 233,
    CSSPropertyStrokeLinejoin = 234,
    CSSPropertyStrokeMiterlimit = 235,
    CSSPropertyStrokeOpacity = 236,
    CSSPropertyStrokeWidth = 237,
    CSSPropertySuffix = 238,
    CSSPropertySymbols = 239,
    CSSPropertySyntax = 240,
    CSSPropertySystem = 241,
    CSSPropertyTabSize = 242,
    CSSPropertyTableLayout = 243,
    CSSPropertyTextAlign = 244,
    CSSPropertyTextAlignLast = 245,
    CSSPropertyTextAnchor = 246,
    CSSPropertyTextBoxEdge = 247,
    CSSPropertyTextBoxTrim = 248,
    CSSPropertyTextDecorationColor = 249,
    CSSPropertyTextDecorationLine = 250,
    CSSPropertyTextDecorationSkipInk = 251,
    CSSPropertyTextDecorationStyle = 252,
    CSSPropertyTextDecorationThickness = 253,
    CSSPropertyTextEmphasisColor = 254,
    CSSPropertyTextEmphasisPosition = 255,
    CSSPropertyTextEmphasisStyle = 256,
    CSSPropertyTextGroupAlign = 257,
    CSSPropertyTextIndent = 258,
    CSSPropertyTextJustify = 259,
    CSSPropertyTextOverflow = 260,
    CSSPropertyTextShadow = 261,
    CSSPropertyTextTransform = 262,
    CSSPropertyTextUnderlineOffset = 263,
    CSSPropertyTextUnderlinePosition = 264,
    CSSPropertyTextWrap = 265,
    CSSPropertyTouchAction = 266,
    CSSPropertyTransform = 267,
    CSSPropertyTransformBox = 268,
    CSSPropertyTransformOriginX = 269,
    CSSPropertyTransformOriginY = 270,
    CSSPropertyTransformOriginZ = 271,
    CSSPropertyTransformStyle = 272,
    CSSPropertyTransitionDelay = 273,
    CSSPropertyTransitionDuration = 274,
    CSSPropertyTransitionProperty = 275,
    CSSPropertyTransitionTimingFunction = 276,
    CSSPropertyTranslate = 277,
    CSSPropertyUnicodeBidi = 278,
    CSSPropertyUnicodeRange = 279,
    CSSPropertyVectorEffect = 280,
    CSSPropertyVerticalAlign = 281,
    CSSPropertyVisibility = 282,
    CSSPropertyWhiteSpaceCollapse = 283,
    CSSPropertyWidows = 284,
    CSSPropertyWillChange = 285,
    CSSPropertyWordBreak = 286,
    CSSPropertyWordSpacing = 287,
    CSSPropertyX = 288,
    CSSPropertyY = 289,
    CSSPropertyZIndex = 290,
    CSSPropertyAppleColorFilter = 291,
    CSSPropertyApplePayButtonStyle = 292,
    CSSPropertyApplePayButtonType = 293,
    CSSPropertyInternalTextAutosizingStatus = 294,
    CSSPropertyWebkitBackdropFilter = 295,
    CSSPropertyWebkitBorderHorizontalSpacing = 296,
    CSSPropertyWebkitBorderVerticalSpacing = 297,
    CSSPropertyWebkitBoxAlign = 298,
    CSSPropertyWebkitBoxDecorationBreak = 299,
    CSSPropertyWebkitBoxDirection = 300,
    CSSPropertyWebkitBoxFlex = 301,
    CSSPropertyWebkitBoxFlexGroup = 302,
    CSSPropertyWebkitBoxLines = 303,
    CSSPropertyWebkitBoxOrdinalGroup = 304,
    CSSPropertyWebkitBoxOrient = 305,
    CSSPropertyWebkitBoxPack = 306,
    CSSPropertyWebkitBoxReflect = 307,
    CSSPropertyWebkitColumnAxis = 308,
    CSSPropertyWebkitColumnProgression = 309,
    CSSPropertyWebkitCursorVisibility = 310,
    CSSPropertyWebkitFontSizeDelta = 311,
    CSSPropertyWebkitHyphenateLimitAfter = 312,
    CSSPropertyWebkitHyphenateLimitBefore = 313,
    CSSPropertyWebkitHyphenateLimitLines = 314,
    CSSPropertyWebkitInitialLetter = 315,
    CSSPropertyWebkitLineAlign = 316,
    CSSPropertyWebkitLineBoxContain = 317,
    CSSPropertyWebkitLineClamp = 318,
    CSSPropertyWebkitLineGrid = 319,
    CSSPropertyWebkitLineSnap = 320,
    CSSPropertyWebkitMarqueeDirection = 321,
    CSSPropertyWebkitMarqueeIncrement = 322,
    CSSPropertyWebkitMarqueeRepetition = 323,
    CSSPropertyWebkitMarqueeSpeed = 324,
    CSSPropertyWebkitMarqueeStyle = 325,
    CSSPropertyWebkitMaskPositionX = 326,
    CSSPropertyWebkitMaskPositionY = 327,
    CSSPropertyWebkitNbspMode = 328,
    CSSPropertyWebkitRtlOrdering = 329,
    CSSPropertyWebkitTapHighlightColor = 330,
    CSSPropertyWebkitTextDecorationsInEffect = 331,
    CSSPropertyWebkitTextFillColor = 332,
    CSSPropertyWebkitTextSecurity = 333,
    CSSPropertyWebkitTextStrokeColor = 334,
    CSSPropertyWebkitTextStrokeWidth = 335,
    CSSPropertyWebkitUserDrag = 336,
    CSSPropertyWebkitUserModify = 337,
    CSSPropertyWebkitUserSelect = 338,
    CSSPropertyBackgroundClip = 339,
    CSSPropertyBackgroundOrigin = 340,
    CSSPropertyBlockSize = 341,
    CSSPropertyBorderBlockEndColor = 342,
    CSSPropertyBorderBlockEndStyle = 343,
    CSSPropertyBorderBlockEndWidth = 344,
    CSSPropertyBorderBlockStartColor = 345,
    CSSPropertyBorderBlockStartStyle = 346,
    CSSPropertyBorderBlockStartWidth = 347,
    CSSPropertyBorderBottomColor = 348,
    CSSPropertyBorderBottomLeftRadius = 349,
    CSSPropertyBorderBottomRightRadius = 350,
    CSSPropertyBorderBottomStyle = 351,
    CSSPropertyBorderBottomWidth = 352,
    CSSPropertyBorderEndEndRadius = 353,
    CSSPropertyBorderEndStartRadius = 354,
    CSSPropertyBorderInlineEndColor = 355,
    CSSPropertyBorderInlineEndStyle = 356,
    CSSPropertyBorderInlineEndWidth = 357,
    CSSPropertyBorderInlineStartColor = 358,
    CSSPropertyBorderInlineStartStyle = 359,
    CSSPropertyBorderInlineStartWidth = 360,
    CSSPropertyBorderLeftColor = 361,
    CSSPropertyBorderLeftStyle = 362,
    CSSPropertyBorderLeftWidth = 363,
    CSSPropertyBorderRightColor = 364,
    CSSPropertyBorderRightStyle = 365,
    CSSPropertyBorderRightWidth = 366,
    CSSPropertyBorderStartEndRadius = 367,
    CSSPropertyBorderStartStartRadius = 368,
    CSSPropertyBorderTopColor = 369,
    CSSPropertyBorderTopLeftRadius = 370,
    CSSPropertyBorderTopRightRadius = 371,
    CSSPropertyBorderTopStyle = 372,
    CSSPropertyBorderTopWidth = 373,
    CSSPropertyBottom = 374,
    CSSPropertyBoxShadow = 375,
    CSSPropertyContainIntrinsicBlockSize = 376,
    CSSPropertyContainIntrinsicHeight = 377,
    CSSPropertyContainIntrinsicInlineSize = 378,
    CSSPropertyContainIntrinsicWidth = 379,
    CSSPropertyHeight = 380,
    CSSPropertyInlineSize = 381,
    CSSPropertyInsetBlockEnd = 382,
    CSSPropertyInsetBlockStart = 383,
    CSSPropertyInsetInlineEnd = 384,
    CSSPropertyInsetInlineStart = 385,
    CSSPropertyLeft = 386,
    CSSPropertyMarginBlockEnd = 387,
    CSSPropertyMarginBlockStart = 388,
    CSSPropertyMarginBottom = 389,
    CSSPropertyMarginInlineEnd = 390,
    CSSPropertyMarginInlineStart = 391,
    CSSPropertyMarginLeft = 392,
    CSSPropertyMarginRight = 393,
    CSSPropertyMarginTop = 394,
    CSSPropertyMaskClip = 395,
    CSSPropertyMaskComposite = 396,
    CSSPropertyMaskMode = 397,
    CSSPropertyMaxBlockSize = 398,
    CSSPropertyMaxHeight = 399,
    CSSPropertyMaxInlineSize = 400,
    CSSPropertyMaxWidth = 401,
    CSSPropertyMinBlockSize = 402,
    CSSPropertyMinHeight = 403,
    CSSPropertyMinInlineSize = 404,
    CSSPropertyMinWidth = 405,
    CSSPropertyOverscrollBehaviorBlock = 406,
    CSSPropertyOverscrollBehaviorInline = 407,
    CSSPropertyOverscrollBehaviorX = 408,
    CSSPropertyOverscrollBehaviorY = 409,
    CSSPropertyPaddingBlockEnd = 410,
    CSSPropertyPaddingBlockStart = 411,
    CSSPropertyPaddingBottom = 412,
    CSSPropertyPaddingInlineEnd = 413,
    CSSPropertyPaddingInlineStart = 414,
    CSSPropertyPaddingLeft = 415,
    CSSPropertyPaddingRight = 416,
    CSSPropertyPaddingTop = 417,
    CSSPropertyRight = 418,
    CSSPropertyScrollMarginBlockEnd = 419,
    CSSPropertyScrollMarginBlockStart = 420,
    CSSPropertyScrollMarginBottom = 421,
    CSSPropertyScrollMarginInlineEnd = 422,
    CSSPropertyScrollMarginInlineStart = 423,
    CSSPropertyScrollMarginLeft = 424,
    CSSPropertyScrollMarginRight = 425,
    CSSPropertyScrollMarginTop = 426,
    CSSPropertyScrollPaddingBlockEnd = 427,
    CSSPropertyScrollPaddingBlockStart = 428,
    CSSPropertyScrollPaddingBottom = 429,
    CSSPropertyScrollPaddingInlineEnd = 430,
    CSSPropertyScrollPaddingInlineStart = 431,
    CSSPropertyScrollPaddingLeft = 432,
    CSSPropertyScrollPaddingRight = 433,
    CSSPropertyScrollPaddingTop = 434,
    CSSPropertyTextCombineUpright = 435,
    CSSPropertyTop = 436,
    CSSPropertyWidth = 437,
    CSSPropertyWebkitBackgroundClip = 438,
    CSSPropertyWebkitBackgroundOrigin = 439,
    CSSPropertyWebkitBoxShadow = 440,
    CSSPropertyWebkitMaskClip = 441,
    CSSPropertyWebkitMaskComposite = 442,
    CSSPropertyWebkitMaskSourceType = 443,
    CSSPropertyWebkitTextCombine = 444,
    CSSPropertyAll = 445,
    CSSPropertyAnimation = 446,
    CSSPropertyBackground = 447,
    CSSPropertyBackgroundPosition = 448,
    CSSPropertyBorder = 449,
    CSSPropertyBorderBlock = 450,
    CSSPropertyBorderBlockColor = 451,
    CSSPropertyBorderBlockEnd = 452,
    CSSPropertyBorderBlockStart = 453,
    CSSPropertyBorderBlockStyle = 454,
    CSSPropertyBorderBlockWidth = 455,
    CSSPropertyBorderBottom = 456,
    CSSPropertyBorderColor = 457,
    CSSPropertyBorderImage = 458,
    CSSPropertyBorderInline = 459,
    CSSPropertyBorderInlineColor = 460,
    CSSPropertyBorderInlineEnd = 461,
    CSSPropertyBorderInlineStart = 462,
    CSSPropertyBorderInlineStyle = 463,
    CSSPropertyBorderInlineWidth = 464,
    CSSPropertyBorderLeft = 465,
    CSSPropertyBorderRadius = 466,
    CSSPropertyBorderRight = 467,
    CSSPropertyBorderSpacing = 468,
    CSSPropertyBorderStyle = 469,
    CSSPropertyBorderTop = 470,
    CSSPropertyBorderWidth = 471,
    CSSPropertyColumnRule = 472,
    CSSPropertyColumns = 473,
    CSSPropertyContainIntrinsicSize = 474,
    CSSPropertyContainer = 475,
    CSSPropertyFlex = 476,
    CSSPropertyFlexFlow = 477,
    CSSPropertyFont = 478,
    CSSPropertyFontSynthesis = 479,
    CSSPropertyFontVariant = 480,
    CSSPropertyGap = 481,
    CSSPropertyGrid = 482,
    CSSPropertyGridArea = 483,
    CSSPropertyGridColumn = 484,
    CSSPropertyGridRow = 485,
    CSSPropertyGridTemplate = 486,
    CSSPropertyInset = 487,
    CSSPropertyInsetBlock = 488,
    CSSPropertyInsetInline = 489,
    CSSPropertyListStyle = 490,
    CSSPropertyMargin = 491,
    CSSPropertyMarginBlock = 492,
    CSSPropertyMarginInline = 493,
    CSSPropertyMarker = 494,
    CSSPropertyMask = 495,
    CSSPropertyMaskBorder = 496,
    CSSPropertyMaskPosition = 497,
    CSSPropertyOffset = 498,
    CSSPropertyOutline = 499,
    CSSPropertyOverflow = 500,
    CSSPropertyOverscrollBehavior = 501,
    CSSPropertyPadding = 502,
    CSSPropertyPaddingBlock = 503,
    CSSPropertyPaddingInline = 504,
    CSSPropertyPageBreakAfter = 505,
    CSSPropertyPageBreakBefore = 506,
    CSSPropertyPageBreakInside = 507,
    CSSPropertyPerspectiveOrigin = 508,
    CSSPropertyPlaceContent = 509,
    CSSPropertyPlaceItems = 510,
    CSSPropertyPlaceSelf = 511,
    CSSPropertyScrollMargin = 512,
    CSSPropertyScrollMarginBlock = 513,
    CSSPropertyScrollMarginInline = 514,
    CSSPropertyScrollPadding = 515,
    CSSPropertyScrollPaddingBlock = 516,
    CSSPropertyScrollPaddingInline = 517,
    CSSPropertyTextDecoration = 518,
    CSSPropertyTextDecorationSkip = 519,
    CSSPropertyTextEmphasis = 520,
    CSSPropertyTransformOrigin = 521,
    CSSPropertyTransition = 522,
    CSSPropertyWhiteSpace = 523,
    CSSPropertyWebkitBackgroundSize = 524,
    CSSPropertyWebkitBorderImage = 525,
    CSSPropertyWebkitBorderRadius = 526,
    CSSPropertyWebkitColumnBreakAfter = 527,
    CSSPropertyWebkitColumnBreakBefore = 528,
    CSSPropertyWebkitColumnBreakInside = 529,
    CSSPropertyWebkitMask = 530,
    CSSPropertyWebkitMaskBoxImage = 531,
    CSSPropertyWebkitMaskPosition = 532,
    CSSPropertyWebkitPerspective = 533,
    CSSPropertyWebkitTextDecoration = 534,
    CSSPropertyWebkitTextOrientation = 535,
    CSSPropertyWebkitTextStroke = 536,
};

constexpr uint16_t firstCSSProperty = 2;
constexpr uint16_t numCSSProperties = 535;
constexpr unsigned maxCSSPropertyNameLength = 34;
constexpr auto firstTopPriorityProperty = CSSPropertyID::CSSPropertyColorScheme;
constexpr auto lastTopPriorityProperty = CSSPropertyID::CSSPropertyWebkitRubyPosition;
constexpr auto firstHighPriorityProperty = CSSPropertyID::CSSPropertyColor;
constexpr auto lastHighPriorityProperty = CSSPropertyID::CSSPropertyTextSpacingTrim;
constexpr auto firstLowPriorityProperty = CSSPropertyID::CSSPropertyAccentColor;
constexpr auto lastLowPriorityProperty = CSSPropertyID::CSSPropertyWebkitUserSelect;
constexpr auto firstDeferredProperty = CSSPropertyID::CSSPropertyBackgroundClip;
constexpr auto lastDeferredProperty = CSSPropertyID::CSSPropertyWebkitTextCombine;
constexpr auto firstShorthandProperty = CSSPropertyID::CSSPropertyAll;
constexpr auto lastShorthandProperty = CSSPropertyID::CSSPropertyWebkitTextStroke;
constexpr uint16_t numCSSPropertyLonghands = firstShorthandProperty - firstCSSProperty;
extern const std::array<CSSPropertyID, 412> computedPropertyIDs;

struct CSSPropertySettings {
    WTF_MAKE_STRUCT_FAST_ALLOCATED;

    bool CSSOMViewSmoothScrollingEnabled { false };
    bool accentColorEnabled { false };
    bool aspectRatioEnabled { false };
    bool colorFilterEnabled { false };
    bool cssContainIntrinsicSizeEnabled { false };
    bool cssContainerQueriesEnabled { false };
    bool cssContainmentEnabled { false };
    bool cssContentVisibilityEnabled { false };
    bool cssCounterStyleAtRulesEnabled { false };
    bool cssCustomPropertiesAndValuesEnabled { false };
    bool cssFontFaceSizeAdjustEnabled { false };
    bool cssIndividualTransformPropertiesEnabled { false };
    bool cssInputSecurityEnabled { false };
    bool cssMarginTrimEnabled { false };
    bool cssMotionPathEnabled { false };
    bool cssRhythmicSizingEnabled { false };
    bool cssScrollAnchoringEnabled { false };
    bool cssScrollbarColorEnabled { false };
    bool cssScrollbarGutterEnabled { false };
    bool cssScrollbarWidthEnabled { false };
    bool cssTextAlignLastEnabled { false };
    bool cssTextBoxTrimEnabled { false };
    bool cssTextGroupAlignEnabled { false };
    bool cssTextJustifyEnabled { false };
    bool cssTextSpacingEnabled { false };
    bool cssWhiteSpaceLonghandsEnabled { false };
    bool masonryEnabled { false };
    bool masonryTrackAlignmentEnabled { false };
    bool overscrollBehaviorEnabled { false };
    bool textAutosizingEnabled { false };
    bool webAnimationsCompositeOperationsEnabled { false };

    CSSPropertySettings() = default;
    explicit CSSPropertySettings(const Settings&);
};

bool operator==(const CSSPropertySettings&, const CSSPropertySettings&);
void add(Hasher&, const CSSPropertySettings&);

constexpr bool isLonghand(CSSPropertyID);
bool isInternal(CSSPropertyID);
bool isExposed(CSSPropertyID, const Settings*);
bool isExposed(CSSPropertyID, const Settings&);
bool isExposed(CSSPropertyID, const CSSPropertySettings*);
bool isExposed(CSSPropertyID, const CSSPropertySettings&);

CSSPropertyID findCSSProperty(const char* characters, unsigned length);
ASCIILiteral nameLiteral(CSSPropertyID);
const AtomString& nameString(CSSPropertyID);
String nameForIDL(CSSPropertyID);

CSSPropertyID relatedProperty(CSSPropertyID);

template<CSSPropertyID first, CSSPropertyID last> struct CSSPropertiesRange {
    struct Iterator {
        uint16_t index { static_cast<uint16_t>(first) };
        constexpr CSSPropertyID operator*() const { return static_cast<CSSPropertyID>(index); }
        constexpr Iterator& operator++() { ++index; return *this; }
        constexpr bool operator==(std::nullptr_t) const { return index > static_cast<uint16_t>(last); }
    };
    static constexpr Iterator begin() { return { }; }
    static constexpr std::nullptr_t end() { return nullptr; }
    static constexpr uint16_t size() { return last - first + 1; }
};
using AllCSSPropertiesRange = CSSPropertiesRange<static_cast<CSSPropertyID>(firstCSSProperty), lastShorthandProperty>;
using AllLonghandCSSPropertiesRange = CSSPropertiesRange<static_cast<CSSPropertyID>(firstCSSProperty), lastDeferredProperty>;
constexpr AllCSSPropertiesRange allCSSProperties() { return { }; }
constexpr AllLonghandCSSPropertiesRange allLonghandCSSProperties() { return { }; }

constexpr bool isLonghand(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= firstCSSProperty && static_cast<uint16_t>(property) < static_cast<uint16_t>(firstShorthandProperty);
}
constexpr bool isShorthand(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= static_cast<uint16_t>(firstShorthandProperty) && static_cast<uint16_t>(property) <= static_cast<uint16_t>(lastShorthandProperty);
}

} // namespace WebCore

namespace WTF {

template<> struct DefaultHash<WebCore::CSSPropertyID> : IntHash<unsigned> { };

template<> struct HashTraits<WebCore::CSSPropertyID> : GenericHashTraits<WebCore::CSSPropertyID> {
    static const bool emptyValueIsZero = true;
    static void constructDeletedValue(WebCore::CSSPropertyID& slot) { slot = static_cast<WebCore::CSSPropertyID>(std::numeric_limits<uint16_t>::max()); }
    static bool isDeletedValue(WebCore::CSSPropertyID value) { return static_cast<uint16_t>(value) == std::numeric_limits<uint16_t>::max(); }
};

} // namespace WTF

namespace std {

template<> struct iterator_traits<WebCore::AllCSSPropertiesRange::Iterator> { using value_type = WebCore::CSSPropertyID; };
template<> struct iterator_traits<WebCore::AllLonghandCSSPropertiesRange::Iterator> { using value_type = WebCore::CSSPropertyID; };

} // namespace std

