// This file is automatically generated from CSSProperties.json by the process-css-properties.py script. Do not edit it.

#pragma once

#include <array>
#include <wtf/HashFunctions.h>
#include <wtf/HashTraits.h>

namespace WebCore {

class Settings;

enum CSSPropertyID : uint16_t {
    CSSPropertyInvalid = 0,
    CSSPropertyCustom = 1,
    CSSPropertyColorScheme = 2,
    CSSPropertyRubyPosition = 3,
    CSSPropertyWritingMode = 4,
    CSSPropertyColor = 5,
    CSSPropertyDirection = 6,
    CSSPropertyDisplay = 7,
    CSSPropertyFontFamily = 8,
    CSSPropertyFontFeatureSettings = 9,
    CSSPropertyFontKerning = 10,
    CSSPropertyFontOpticalSizing = 11,
    CSSPropertyFontPalette = 12,
    CSSPropertyFontSize = 13,
    CSSPropertyFontSizeAdjust = 14,
    CSSPropertyFontStyle = 15,
    CSSPropertyFontSynthesisSmallCaps = 16,
    CSSPropertyFontSynthesisStyle = 17,
    CSSPropertyFontSynthesisWeight = 18,
    CSSPropertyFontVariantAlternates = 19,
    CSSPropertyFontVariantCaps = 20,
    CSSPropertyFontVariantEastAsian = 21,
    CSSPropertyFontVariantEmoji = 22,
    CSSPropertyFontVariantLigatures = 23,
    CSSPropertyFontVariantNumeric = 24,
    CSSPropertyFontVariantPosition = 25,
    CSSPropertyFontVariationSettings = 26,
    CSSPropertyFontWeight = 27,
    CSSPropertyFontWidth = 28,
    CSSPropertyTextOrientation = 29,
    CSSPropertyTextRendering = 30,
    CSSPropertyZoom = 31,
    CSSPropertyWebkitFontSmoothing = 32,
    CSSPropertyWebkitLocale = 33,
    CSSPropertyWebkitTextSizeAdjust = 34,
    CSSPropertyWebkitTextZoom = 35,
    CSSPropertyLetterSpacing = 36,
    CSSPropertyTextAutospace = 37,
    CSSPropertyTextSpacingTrim = 38,
    CSSPropertyAccentColor = 39,
    CSSPropertyAdditiveSymbols = 40,
    CSSPropertyAlignContent = 41,
    CSSPropertyAlignItems = 42,
    CSSPropertyAlignSelf = 43,
    CSSPropertyAlignmentBaseline = 44,
    CSSPropertyAnchorName = 45,
    CSSPropertyAnimationComposition = 46,
    CSSPropertyAnimationDelay = 47,
    CSSPropertyAnimationDirection = 48,
    CSSPropertyAnimationDuration = 49,
    CSSPropertyAnimationFillMode = 50,
    CSSPropertyAnimationIterationCount = 51,
    CSSPropertyAnimationName = 52,
    CSSPropertyAnimationPlayState = 53,
    CSSPropertyAnimationRangeEnd = 54,
    CSSPropertyAnimationRangeStart = 55,
    CSSPropertyAnimationTimeline = 56,
    CSSPropertyAnimationTimingFunction = 57,
    CSSPropertyAppearance = 58,
    CSSPropertyAspectRatio = 59,
    CSSPropertyBackdropFilter = 60,
    CSSPropertyBackfaceVisibility = 61,
    CSSPropertyBackgroundAttachment = 62,
    CSSPropertyBackgroundBlendMode = 63,
    CSSPropertyBackgroundClip = 64,
    CSSPropertyBackgroundColor = 65,
    CSSPropertyBackgroundImage = 66,
    CSSPropertyBackgroundOrigin = 67,
    CSSPropertyBackgroundPositionX = 68,
    CSSPropertyBackgroundPositionY = 69,
    CSSPropertyBackgroundRepeat = 70,
    CSSPropertyBackgroundSize = 71,
    CSSPropertyBasePalette = 72,
    CSSPropertyBaselineShift = 73,
    CSSPropertyBlockEllipsis = 74,
    CSSPropertyBlockStepAlign = 75,
    CSSPropertyBlockStepInsert = 76,
    CSSPropertyBlockStepRound = 77,
    CSSPropertyBlockStepSize = 78,
    CSSPropertyBorderCollapse = 79,
    CSSPropertyBorderImageOutset = 80,
    CSSPropertyBorderImageRepeat = 81,
    CSSPropertyBorderImageSlice = 82,
    CSSPropertyBorderImageSource = 83,
    CSSPropertyBorderImageWidth = 84,
    CSSPropertyBoxShadow = 85,
    CSSPropertyBoxSizing = 86,
    CSSPropertyBreakAfter = 87,
    CSSPropertyBreakBefore = 88,
    CSSPropertyBreakInside = 89,
    CSSPropertyBufferedRendering = 90,
    CSSPropertyCaptionSide = 91,
    CSSPropertyCaretColor = 92,
    CSSPropertyClear = 93,
    CSSPropertyClip = 94,
    CSSPropertyClipPath = 95,
    CSSPropertyClipRule = 96,
    CSSPropertyColorInterpolation = 97,
    CSSPropertyColorInterpolationFilters = 98,
    CSSPropertyColumnCount = 99,
    CSSPropertyColumnFill = 100,
    CSSPropertyColumnGap = 101,
    CSSPropertyColumnRuleColor = 102,
    CSSPropertyColumnRuleStyle = 103,
    CSSPropertyColumnRuleWidth = 104,
    CSSPropertyColumnSpan = 105,
    CSSPropertyColumnWidth = 106,
    CSSPropertyContain = 107,
    CSSPropertyContainerName = 108,
    CSSPropertyContainerType = 109,
    CSSPropertyContent = 110,
    CSSPropertyContentVisibility = 111,
    CSSPropertyContinue = 112,
    CSSPropertyCounterIncrement = 113,
    CSSPropertyCounterReset = 114,
    CSSPropertyCounterSet = 115,
    CSSPropertyCursor = 116,
    CSSPropertyCx = 117,
    CSSPropertyCy = 118,
    CSSPropertyD = 119,
    CSSPropertyDominantBaseline = 120,
    CSSPropertyDynamicRangeLimit = 121,
    CSSPropertyEmptyCells = 122,
    CSSPropertyFallback = 123,
    CSSPropertyFieldSizing = 124,
    CSSPropertyFill = 125,
    CSSPropertyFillOpacity = 126,
    CSSPropertyFillRule = 127,
    CSSPropertyFilter = 128,
    CSSPropertyFlexBasis = 129,
    CSSPropertyFlexDirection = 130,
    CSSPropertyFlexGrow = 131,
    CSSPropertyFlexShrink = 132,
    CSSPropertyFlexWrap = 133,
    CSSPropertyFloat = 134,
    CSSPropertyFloodColor = 135,
    CSSPropertyFloodOpacity = 136,
    CSSPropertyFontDisplay = 137,
    CSSPropertyGlyphOrientationHorizontal = 138,
    CSSPropertyGlyphOrientationVertical = 139,
    CSSPropertyGridAutoColumns = 140,
    CSSPropertyGridAutoFlow = 141,
    CSSPropertyGridAutoRows = 142,
    CSSPropertyGridColumnEnd = 143,
    CSSPropertyGridColumnStart = 144,
    CSSPropertyGridRowEnd = 145,
    CSSPropertyGridRowStart = 146,
    CSSPropertyGridTemplateAreas = 147,
    CSSPropertyGridTemplateColumns = 148,
    CSSPropertyGridTemplateRows = 149,
    CSSPropertyHangingPunctuation = 150,
    CSSPropertyHyphenateCharacter = 151,
    CSSPropertyHyphens = 152,
    CSSPropertyImageOrientation = 153,
    CSSPropertyImageRendering = 154,
    CSSPropertyInherits = 155,
    CSSPropertyInitialValue = 156,
    CSSPropertyInputSecurity = 157,
    CSSPropertyIsolation = 158,
    CSSPropertyJustifyContent = 159,
    CSSPropertyJustifyItems = 160,
    CSSPropertyJustifySelf = 161,
    CSSPropertyLightingColor = 162,
    CSSPropertyLineBreak = 163,
    CSSPropertyLineFitEdge = 164,
    CSSPropertyLineHeight = 165,
    CSSPropertyListStyleImage = 166,
    CSSPropertyListStylePosition = 167,
    CSSPropertyListStyleType = 168,
    CSSPropertyMarginTrim = 169,
    CSSPropertyMarkerEnd = 170,
    CSSPropertyMarkerMid = 171,
    CSSPropertyMarkerStart = 172,
    CSSPropertyMaskBorderOutset = 173,
    CSSPropertyMaskBorderRepeat = 174,
    CSSPropertyMaskBorderSlice = 175,
    CSSPropertyMaskBorderSource = 176,
    CSSPropertyMaskBorderWidth = 177,
    CSSPropertyMaskClip = 178,
    CSSPropertyMaskComposite = 179,
    CSSPropertyMaskImage = 180,
    CSSPropertyMaskMode = 181,
    CSSPropertyMaskOrigin = 182,
    CSSPropertyMaskRepeat = 183,
    CSSPropertyMaskSize = 184,
    CSSPropertyMaskType = 185,
    CSSPropertyMasonryAutoFlow = 186,
    CSSPropertyMathStyle = 187,
    CSSPropertyMaxLines = 188,
    CSSPropertyMixBlendMode = 189,
    CSSPropertyNavigation = 190,
    CSSPropertyNegative = 191,
    CSSPropertyObjectFit = 192,
    CSSPropertyObjectPosition = 193,
    CSSPropertyOffsetAnchor = 194,
    CSSPropertyOffsetDistance = 195,
    CSSPropertyOffsetPath = 196,
    CSSPropertyOffsetPosition = 197,
    CSSPropertyOffsetRotate = 198,
    CSSPropertyOpacity = 199,
    CSSPropertyOrder = 200,
    CSSPropertyOrphans = 201,
    CSSPropertyOutlineColor = 202,
    CSSPropertyOutlineOffset = 203,
    CSSPropertyOutlineStyle = 204,
    CSSPropertyOutlineWidth = 205,
    CSSPropertyOverflowAnchor = 206,
    CSSPropertyOverflowWrap = 207,
    CSSPropertyOverrideColors = 208,
    CSSPropertyPad = 209,
    CSSPropertyPage = 210,
    CSSPropertyPaintOrder = 211,
    CSSPropertyPerspective = 212,
    CSSPropertyPerspectiveOriginX = 213,
    CSSPropertyPerspectiveOriginY = 214,
    CSSPropertyPointerEvents = 215,
    CSSPropertyPosition = 216,
    CSSPropertyPositionAnchor = 217,
    CSSPropertyPositionArea = 218,
    CSSPropertyPositionTryFallbacks = 219,
    CSSPropertyPositionTryOrder = 220,
    CSSPropertyPrefix = 221,
    CSSPropertyPrintColorAdjust = 222,
    CSSPropertyQuotes = 223,
    CSSPropertyR = 224,
    CSSPropertyRange = 225,
    CSSPropertyResize = 226,
    CSSPropertyRotate = 227,
    CSSPropertyRowGap = 228,
    CSSPropertyRubyAlign = 229,
    CSSPropertyRubyOverhang = 230,
    CSSPropertyRx = 231,
    CSSPropertyRy = 232,
    CSSPropertyScale = 233,
    CSSPropertyScrollBehavior = 234,
    CSSPropertyScrollSnapAlign = 235,
    CSSPropertyScrollSnapStop = 236,
    CSSPropertyScrollSnapType = 237,
    CSSPropertyScrollTimelineAxis = 238,
    CSSPropertyScrollTimelineName = 239,
    CSSPropertyScrollbarColor = 240,
    CSSPropertyScrollbarGutter = 241,
    CSSPropertyScrollbarWidth = 242,
    CSSPropertyShapeImageThreshold = 243,
    CSSPropertyShapeMargin = 244,
    CSSPropertyShapeOutside = 245,
    CSSPropertyShapeRendering = 246,
    CSSPropertySize = 247,
    CSSPropertySizeAdjust = 248,
    CSSPropertySpeakAs = 249,
    CSSPropertySrc = 250,
    CSSPropertyStopColor = 251,
    CSSPropertyStopOpacity = 252,
    CSSPropertyStroke = 253,
    CSSPropertyStrokeColor = 254,
    CSSPropertyStrokeDasharray = 255,
    CSSPropertyStrokeDashoffset = 256,
    CSSPropertyStrokeLinecap = 257,
    CSSPropertyStrokeLinejoin = 258,
    CSSPropertyStrokeMiterlimit = 259,
    CSSPropertyStrokeOpacity = 260,
    CSSPropertyStrokeWidth = 261,
    CSSPropertySuffix = 262,
    CSSPropertySymbols = 263,
    CSSPropertySyntax = 264,
    CSSPropertySystem = 265,
    CSSPropertyTabSize = 266,
    CSSPropertyTableLayout = 267,
    CSSPropertyTextAlign = 268,
    CSSPropertyTextAlignLast = 269,
    CSSPropertyTextAnchor = 270,
    CSSPropertyTextBoxEdge = 271,
    CSSPropertyTextBoxTrim = 272,
    CSSPropertyTextCombineUpright = 273,
    CSSPropertyTextDecorationColor = 274,
    CSSPropertyTextDecorationLine = 275,
    CSSPropertyTextDecorationSkipInk = 276,
    CSSPropertyTextDecorationStyle = 277,
    CSSPropertyTextDecorationThickness = 278,
    CSSPropertyTextEmphasisColor = 279,
    CSSPropertyTextEmphasisPosition = 280,
    CSSPropertyTextEmphasisStyle = 281,
    CSSPropertyTextGroupAlign = 282,
    CSSPropertyTextIndent = 283,
    CSSPropertyTextJustify = 284,
    CSSPropertyTextOverflow = 285,
    CSSPropertyTextShadow = 286,
    CSSPropertyTextTransform = 287,
    CSSPropertyTextUnderlineOffset = 288,
    CSSPropertyTextUnderlinePosition = 289,
    CSSPropertyTextWrapMode = 290,
    CSSPropertyTextWrapStyle = 291,
    CSSPropertyTimelineScope = 292,
    CSSPropertyTouchAction = 293,
    CSSPropertyTransform = 294,
    CSSPropertyTransformBox = 295,
    CSSPropertyTransformOriginX = 296,
    CSSPropertyTransformOriginY = 297,
    CSSPropertyTransformOriginZ = 298,
    CSSPropertyTransformStyle = 299,
    CSSPropertyTransitionBehavior = 300,
    CSSPropertyTransitionDelay = 301,
    CSSPropertyTransitionDuration = 302,
    CSSPropertyTransitionProperty = 303,
    CSSPropertyTransitionTimingFunction = 304,
    CSSPropertyTranslate = 305,
    CSSPropertyTypes = 306,
    CSSPropertyUnicodeBidi = 307,
    CSSPropertyUnicodeRange = 308,
    CSSPropertyVectorEffect = 309,
    CSSPropertyVerticalAlign = 310,
    CSSPropertyViewTimelineAxis = 311,
    CSSPropertyViewTimelineInset = 312,
    CSSPropertyViewTimelineName = 313,
    CSSPropertyViewTransitionClass = 314,
    CSSPropertyViewTransitionName = 315,
    CSSPropertyVisibility = 316,
    CSSPropertyWhiteSpaceCollapse = 317,
    CSSPropertyWidows = 318,
    CSSPropertyWillChange = 319,
    CSSPropertyWordBreak = 320,
    CSSPropertyX = 321,
    CSSPropertyY = 322,
    CSSPropertyZIndex = 323,
    CSSPropertyAppleColorFilter = 324,
    CSSPropertyApplePayButtonStyle = 325,
    CSSPropertyApplePayButtonType = 326,
    CSSPropertyInternalTextAutosizingStatus = 327,
    CSSPropertyWebkitBackdropFilter = 328,
    CSSPropertyWebkitBackgroundClip = 329,
    CSSPropertyWebkitBackgroundOrigin = 330,
    CSSPropertyWebkitBorderHorizontalSpacing = 331,
    CSSPropertyWebkitBorderVerticalSpacing = 332,
    CSSPropertyWebkitBoxAlign = 333,
    CSSPropertyWebkitBoxDecorationBreak = 334,
    CSSPropertyWebkitBoxDirection = 335,
    CSSPropertyWebkitBoxFlex = 336,
    CSSPropertyWebkitBoxFlexGroup = 337,
    CSSPropertyWebkitBoxLines = 338,
    CSSPropertyWebkitBoxOrdinalGroup = 339,
    CSSPropertyWebkitBoxOrient = 340,
    CSSPropertyWebkitBoxPack = 341,
    CSSPropertyWebkitBoxReflect = 342,
    CSSPropertyWebkitBoxShadow = 343,
    CSSPropertyWebkitColumnAxis = 344,
    CSSPropertyWebkitColumnProgression = 345,
    CSSPropertyWebkitCursorVisibility = 346,
    CSSPropertyWebkitFontSizeDelta = 347,
    CSSPropertyWebkitHyphenateLimitAfter = 348,
    CSSPropertyWebkitHyphenateLimitBefore = 349,
    CSSPropertyWebkitHyphenateLimitLines = 350,
    CSSPropertyWebkitInitialLetter = 351,
    CSSPropertyWebkitLineAlign = 352,
    CSSPropertyWebkitLineBoxContain = 353,
    CSSPropertyWebkitLineClamp = 354,
    CSSPropertyWebkitLineGrid = 355,
    CSSPropertyWebkitLineSnap = 356,
    CSSPropertyWebkitMarqueeDirection = 357,
    CSSPropertyWebkitMarqueeIncrement = 358,
    CSSPropertyWebkitMarqueeRepetition = 359,
    CSSPropertyWebkitMarqueeSpeed = 360,
    CSSPropertyWebkitMarqueeStyle = 361,
    CSSPropertyWebkitMaskClip = 362,
    CSSPropertyWebkitMaskComposite = 363,
    CSSPropertyWebkitMaskPositionX = 364,
    CSSPropertyWebkitMaskPositionY = 365,
    CSSPropertyWebkitMaskSourceType = 366,
    CSSPropertyWebkitNbspMode = 367,
    CSSPropertyWebkitRtlOrdering = 368,
    CSSPropertyWebkitRubyPosition = 369,
    CSSPropertyWebkitTapHighlightColor = 370,
    CSSPropertyWebkitTextCombine = 371,
    CSSPropertyWebkitTextDecorationsInEffect = 372,
    CSSPropertyWebkitTextFillColor = 373,
    CSSPropertyWebkitTextSecurity = 374,
    CSSPropertyWebkitTextStrokeColor = 375,
    CSSPropertyWebkitTextStrokeWidth = 376,
    CSSPropertyWebkitUserDrag = 377,
    CSSPropertyWebkitUserModify = 378,
    CSSPropertyWebkitUserSelect = 379,
    CSSPropertyWordSpacing = 380,
    CSSPropertyBlockSize = 381,
    CSSPropertyBorderBlockEndColor = 382,
    CSSPropertyBorderBlockEndStyle = 383,
    CSSPropertyBorderBlockEndWidth = 384,
    CSSPropertyBorderBlockStartColor = 385,
    CSSPropertyBorderBlockStartStyle = 386,
    CSSPropertyBorderBlockStartWidth = 387,
    CSSPropertyBorderBottomColor = 388,
    CSSPropertyBorderBottomLeftRadius = 389,
    CSSPropertyBorderBottomRightRadius = 390,
    CSSPropertyBorderBottomStyle = 391,
    CSSPropertyBorderBottomWidth = 392,
    CSSPropertyBorderEndEndRadius = 393,
    CSSPropertyBorderEndStartRadius = 394,
    CSSPropertyBorderInlineEndColor = 395,
    CSSPropertyBorderInlineEndStyle = 396,
    CSSPropertyBorderInlineEndWidth = 397,
    CSSPropertyBorderInlineStartColor = 398,
    CSSPropertyBorderInlineStartStyle = 399,
    CSSPropertyBorderInlineStartWidth = 400,
    CSSPropertyBorderLeftColor = 401,
    CSSPropertyBorderLeftStyle = 402,
    CSSPropertyBorderLeftWidth = 403,
    CSSPropertyBorderRightColor = 404,
    CSSPropertyBorderRightStyle = 405,
    CSSPropertyBorderRightWidth = 406,
    CSSPropertyBorderStartEndRadius = 407,
    CSSPropertyBorderStartStartRadius = 408,
    CSSPropertyBorderTopColor = 409,
    CSSPropertyBorderTopLeftRadius = 410,
    CSSPropertyBorderTopRightRadius = 411,
    CSSPropertyBorderTopStyle = 412,
    CSSPropertyBorderTopWidth = 413,
    CSSPropertyBottom = 414,
    CSSPropertyContainIntrinsicBlockSize = 415,
    CSSPropertyContainIntrinsicHeight = 416,
    CSSPropertyContainIntrinsicInlineSize = 417,
    CSSPropertyContainIntrinsicWidth = 418,
    CSSPropertyHeight = 419,
    CSSPropertyInlineSize = 420,
    CSSPropertyInsetBlockEnd = 421,
    CSSPropertyInsetBlockStart = 422,
    CSSPropertyInsetInlineEnd = 423,
    CSSPropertyInsetInlineStart = 424,
    CSSPropertyLeft = 425,
    CSSPropertyMarginBlockEnd = 426,
    CSSPropertyMarginBlockStart = 427,
    CSSPropertyMarginBottom = 428,
    CSSPropertyMarginInlineEnd = 429,
    CSSPropertyMarginInlineStart = 430,
    CSSPropertyMarginLeft = 431,
    CSSPropertyMarginRight = 432,
    CSSPropertyMarginTop = 433,
    CSSPropertyMaxBlockSize = 434,
    CSSPropertyMaxHeight = 435,
    CSSPropertyMaxInlineSize = 436,
    CSSPropertyMaxWidth = 437,
    CSSPropertyMinBlockSize = 438,
    CSSPropertyMinHeight = 439,
    CSSPropertyMinInlineSize = 440,
    CSSPropertyMinWidth = 441,
    CSSPropertyOverflowBlock = 442,
    CSSPropertyOverflowInline = 443,
    CSSPropertyOverflowX = 444,
    CSSPropertyOverflowY = 445,
    CSSPropertyOverscrollBehaviorBlock = 446,
    CSSPropertyOverscrollBehaviorInline = 447,
    CSSPropertyOverscrollBehaviorX = 448,
    CSSPropertyOverscrollBehaviorY = 449,
    CSSPropertyPaddingBlockEnd = 450,
    CSSPropertyPaddingBlockStart = 451,
    CSSPropertyPaddingBottom = 452,
    CSSPropertyPaddingInlineEnd = 453,
    CSSPropertyPaddingInlineStart = 454,
    CSSPropertyPaddingLeft = 455,
    CSSPropertyPaddingRight = 456,
    CSSPropertyPaddingTop = 457,
    CSSPropertyRight = 458,
    CSSPropertyScrollMarginBlockEnd = 459,
    CSSPropertyScrollMarginBlockStart = 460,
    CSSPropertyScrollMarginBottom = 461,
    CSSPropertyScrollMarginInlineEnd = 462,
    CSSPropertyScrollMarginInlineStart = 463,
    CSSPropertyScrollMarginLeft = 464,
    CSSPropertyScrollMarginRight = 465,
    CSSPropertyScrollMarginTop = 466,
    CSSPropertyScrollPaddingBlockEnd = 467,
    CSSPropertyScrollPaddingBlockStart = 468,
    CSSPropertyScrollPaddingBottom = 469,
    CSSPropertyScrollPaddingInlineEnd = 470,
    CSSPropertyScrollPaddingInlineStart = 471,
    CSSPropertyScrollPaddingLeft = 472,
    CSSPropertyScrollPaddingRight = 473,
    CSSPropertyScrollPaddingTop = 474,
    CSSPropertyTop = 475,
    CSSPropertyWidth = 476,
    CSSPropertyAll = 477,
    CSSPropertyAnimation = 478,
    CSSPropertyAnimationRange = 479,
    CSSPropertyBackground = 480,
    CSSPropertyBackgroundPosition = 481,
    CSSPropertyBlockStep = 482,
    CSSPropertyBorder = 483,
    CSSPropertyBorderBlock = 484,
    CSSPropertyBorderBlockColor = 485,
    CSSPropertyBorderBlockEnd = 486,
    CSSPropertyBorderBlockStart = 487,
    CSSPropertyBorderBlockStyle = 488,
    CSSPropertyBorderBlockWidth = 489,
    CSSPropertyBorderBottom = 490,
    CSSPropertyBorderColor = 491,
    CSSPropertyBorderImage = 492,
    CSSPropertyBorderInline = 493,
    CSSPropertyBorderInlineColor = 494,
    CSSPropertyBorderInlineEnd = 495,
    CSSPropertyBorderInlineStart = 496,
    CSSPropertyBorderInlineStyle = 497,
    CSSPropertyBorderInlineWidth = 498,
    CSSPropertyBorderLeft = 499,
    CSSPropertyBorderRadius = 500,
    CSSPropertyBorderRight = 501,
    CSSPropertyBorderSpacing = 502,
    CSSPropertyBorderStyle = 503,
    CSSPropertyBorderTop = 504,
    CSSPropertyBorderWidth = 505,
    CSSPropertyColumnRule = 506,
    CSSPropertyColumns = 507,
    CSSPropertyContainIntrinsicSize = 508,
    CSSPropertyContainer = 509,
    CSSPropertyFlex = 510,
    CSSPropertyFlexFlow = 511,
    CSSPropertyFont = 512,
    CSSPropertyFontSynthesis = 513,
    CSSPropertyFontVariant = 514,
    CSSPropertyGap = 515,
    CSSPropertyGrid = 516,
    CSSPropertyGridArea = 517,
    CSSPropertyGridColumn = 518,
    CSSPropertyGridRow = 519,
    CSSPropertyGridTemplate = 520,
    CSSPropertyInset = 521,
    CSSPropertyInsetBlock = 522,
    CSSPropertyInsetInline = 523,
    CSSPropertyLineClamp = 524,
    CSSPropertyListStyle = 525,
    CSSPropertyMargin = 526,
    CSSPropertyMarginBlock = 527,
    CSSPropertyMarginInline = 528,
    CSSPropertyMarker = 529,
    CSSPropertyMask = 530,
    CSSPropertyMaskBorder = 531,
    CSSPropertyMaskPosition = 532,
    CSSPropertyOffset = 533,
    CSSPropertyOutline = 534,
    CSSPropertyOverflow = 535,
    CSSPropertyOverscrollBehavior = 536,
    CSSPropertyPadding = 537,
    CSSPropertyPaddingBlock = 538,
    CSSPropertyPaddingInline = 539,
    CSSPropertyPageBreakAfter = 540,
    CSSPropertyPageBreakBefore = 541,
    CSSPropertyPageBreakInside = 542,
    CSSPropertyPerspectiveOrigin = 543,
    CSSPropertyPlaceContent = 544,
    CSSPropertyPlaceItems = 545,
    CSSPropertyPlaceSelf = 546,
    CSSPropertyScrollMargin = 547,
    CSSPropertyScrollMarginBlock = 548,
    CSSPropertyScrollMarginInline = 549,
    CSSPropertyScrollPadding = 550,
    CSSPropertyScrollPaddingBlock = 551,
    CSSPropertyScrollPaddingInline = 552,
    CSSPropertyScrollTimeline = 553,
    CSSPropertyTextBox = 554,
    CSSPropertyTextDecoration = 555,
    CSSPropertyTextDecorationSkip = 556,
    CSSPropertyTextEmphasis = 557,
    CSSPropertyTextWrap = 558,
    CSSPropertyTransformOrigin = 559,
    CSSPropertyTransition = 560,
    CSSPropertyViewTimeline = 561,
    CSSPropertyWhiteSpace = 562,
    CSSPropertyWebkitBackgroundSize = 563,
    CSSPropertyWebkitBorderImage = 564,
    CSSPropertyWebkitBorderRadius = 565,
    CSSPropertyWebkitColumnBreakAfter = 566,
    CSSPropertyWebkitColumnBreakBefore = 567,
    CSSPropertyWebkitColumnBreakInside = 568,
    CSSPropertyWebkitMask = 569,
    CSSPropertyWebkitMaskBoxImage = 570,
    CSSPropertyWebkitMaskPosition = 571,
    CSSPropertyWebkitPerspective = 572,
    CSSPropertyWebkitTextDecoration = 573,
    CSSPropertyWebkitTextOrientation = 574,
    CSSPropertyWebkitTextStroke = 575,
};

constexpr uint16_t firstCSSProperty = 2;
constexpr uint16_t numCSSProperties = 574;
constexpr unsigned maxCSSPropertyNameLength = 34;
constexpr auto firstTopPriorityProperty = CSSPropertyID::CSSPropertyColorScheme;
constexpr auto lastTopPriorityProperty = CSSPropertyID::CSSPropertyWritingMode;
constexpr auto firstHighPriorityProperty = CSSPropertyID::CSSPropertyColor;
constexpr auto lastHighPriorityProperty = CSSPropertyID::CSSPropertyTextSpacingTrim;
constexpr auto firstLowPriorityProperty = CSSPropertyID::CSSPropertyAccentColor;
constexpr auto lastLowPriorityProperty = CSSPropertyID::CSSPropertyWordSpacing;
constexpr auto firstLogicalGroupProperty = CSSPropertyID::CSSPropertyBlockSize;
constexpr auto lastLogicalGroupProperty = CSSPropertyID::CSSPropertyWidth;
constexpr auto firstShorthandProperty = CSSPropertyID::CSSPropertyAll;
constexpr auto lastShorthandProperty = CSSPropertyID::CSSPropertyWebkitTextStroke;
constexpr uint16_t numCSSPropertyLonghands = firstShorthandProperty - firstCSSProperty;
extern const std::array<CSSPropertyID, 442> computedPropertyIDs;

struct CSSPropertySettings {
    WTF_MAKE_STRUCT_FAST_ALLOCATED;

    bool CSSOMViewSmoothScrollingEnabled : 1 { false };
    bool accentColorEnabled : 1 { false };
    bool colorFilterEnabled : 1 { false };
    bool crossDocumentViewTransitionsEnabled : 1 { false };
    bool cssAnchorPositioningEnabled : 1 { false };
    bool cssContentVisibilityEnabled : 1 { false };
    bool cssCounterStyleAtRulesEnabled : 1 { false };
    bool cssDPropertyEnabled : 1 { false };
    bool cssDynamicRangeLimitPropertyEnabled : 1 { false };
    bool cssFieldSizingEnabled : 1 { false };
    bool cssFontFaceSizeAdjustEnabled : 1 { false };
    bool cssFontVariantEmojiEnabled : 1 { false };
    bool cssInputSecurityEnabled : 1 { false };
    bool cssLineClampEnabled : 1 { false };
    bool cssLineFitEdgeEnabled : 1 { false };
    bool cssMarginTrimEnabled : 1 { false };
    bool cssMotionPathEnabled : 1 { false };
    bool cssRhythmicSizingEnabled : 1 { false };
    bool cssRubyAlignEnabled : 1 { false };
    bool cssRubyOverhangEnabled : 1 { false };
    bool cssScrollAnchoringEnabled : 1 { false };
    bool cssScrollbarColorEnabled : 1 { false };
    bool cssScrollbarGutterEnabled : 1 { false };
    bool cssScrollbarWidthEnabled : 1 { false };
    bool cssTextAutospaceEnabled : 1 { false };
    bool cssTextBoxTrimEnabled : 1 { false };
    bool cssTextGroupAlignEnabled : 1 { false };
    bool cssTextJustifyEnabled : 1 { false };
    bool cssTextSpacingTrimEnabled : 1 { false };
    bool cssTextWrapStyleEnabled : 1 { false };
    bool cssUnprefixedBackdropFilterEnabled : 1 { false };
    bool masonryEnabled : 1 { false };
    bool overscrollBehaviorEnabled : 1 { false };
    bool scrollDrivenAnimationsEnabled : 1 { false };
    bool textAutosizingEnabled : 1 { false };
    bool viewTransitionClassesEnabled : 1 { false };
    bool viewTransitionsEnabled : 1 { false };

    CSSPropertySettings() = default;
    explicit CSSPropertySettings(const Settings&);
};

bool operator==(const CSSPropertySettings&, const CSSPropertySettings&);
void add(Hasher&, const CSSPropertySettings&);

constexpr bool isLonghand(CSSPropertyID);
bool isInternal(CSSPropertyID);
bool isExposed(CSSPropertyID, const Settings*);
bool isExposed(CSSPropertyID, const Settings&);
bool isExposed(CSSPropertyID, const CSSPropertySettings*);
bool isExposed(CSSPropertyID, const CSSPropertySettings&);

CSSPropertyID findCSSProperty(const char* characters, unsigned length);
ASCIILiteral nameLiteral(CSSPropertyID);
const AtomString& nameString(CSSPropertyID);
String nameForIDL(CSSPropertyID);

CSSPropertyID cascadeAliasProperty(CSSPropertyID);

template<CSSPropertyID first, CSSPropertyID last> struct CSSPropertiesRange {
    struct Iterator {
        uint16_t index { static_cast<uint16_t>(first) };
        constexpr CSSPropertyID operator*() const { return static_cast<CSSPropertyID>(index); }
        constexpr Iterator& operator++() { ++index; return *this; }
        constexpr bool operator==(std::nullptr_t) const { return index > static_cast<uint16_t>(last); }
    };
    static constexpr Iterator begin() { return { }; }
    static constexpr std::nullptr_t end() { return nullptr; }
    static constexpr uint16_t size() { return last - first + 1; }
};
using AllCSSPropertiesRange = CSSPropertiesRange<static_cast<CSSPropertyID>(firstCSSProperty), lastShorthandProperty>;
using AllLonghandCSSPropertiesRange = CSSPropertiesRange<static_cast<CSSPropertyID>(firstCSSProperty), lastLogicalGroupProperty>;
constexpr AllCSSPropertiesRange allCSSProperties() { return { }; }
constexpr AllLonghandCSSPropertiesRange allLonghandCSSProperties() { return { }; }

constexpr bool isLonghand(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= firstCSSProperty && static_cast<uint16_t>(property) < static_cast<uint16_t>(firstShorthandProperty);
}
constexpr bool isShorthand(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= static_cast<uint16_t>(firstShorthandProperty) && static_cast<uint16_t>(property) <= static_cast<uint16_t>(lastShorthandProperty);
}

} // namespace WebCore

namespace WTF {

template<> struct DefaultHash<WebCore::CSSPropertyID> : IntHash<unsigned> { };

template<> struct HashTraits<WebCore::CSSPropertyID> : GenericHashTraits<WebCore::CSSPropertyID> {
    static const bool emptyValueIsZero = true;
    static void constructDeletedValue(WebCore::CSSPropertyID& slot) { slot = static_cast<WebCore::CSSPropertyID>(std::numeric_limits<uint16_t>::max()); }
    static bool isDeletedValue(WebCore::CSSPropertyID value) { return static_cast<uint16_t>(value) == std::numeric_limits<uint16_t>::max(); }
};

} // namespace WTF

namespace std {

template<> struct iterator_traits<WebCore::AllCSSPropertiesRange::Iterator> { using value_type = WebCore::CSSPropertyID; };
template<> struct iterator_traits<WebCore::AllLonghandCSSPropertiesRange::Iterator> { using value_type = WebCore::CSSPropertyID; };

} // namespace std

