// This file is automatically generated from CSSProperties.json by the process-css-properties.py script. Do not edit it.

#pragma once

#include <array>
#include <wtf/HashFunctions.h>
#include <wtf/HashTraits.h>

namespace WebCore {

class Settings;

enum CSSPropertyID : uint16_t {
    CSSPropertyInvalid = 0,
    CSSPropertyCustom = 1,
    CSSPropertyColorScheme = 2,
    CSSPropertyRubyPosition = 3,
    CSSPropertyWritingMode = 4,
    CSSPropertyDirection = 5,
    CSSPropertyDisplay = 6,
    CSSPropertyFontFamily = 7,
    CSSPropertyFontFeatureSettings = 8,
    CSSPropertyFontKerning = 9,
    CSSPropertyFontOpticalSizing = 10,
    CSSPropertyFontPalette = 11,
    CSSPropertyFontSize = 12,
    CSSPropertyFontSizeAdjust = 13,
    CSSPropertyFontStyle = 14,
    CSSPropertyFontSynthesisSmallCaps = 15,
    CSSPropertyFontSynthesisStyle = 16,
    CSSPropertyFontSynthesisWeight = 17,
    CSSPropertyFontVariantAlternates = 18,
    CSSPropertyFontVariantCaps = 19,
    CSSPropertyFontVariantEastAsian = 20,
    CSSPropertyFontVariantEmoji = 21,
    CSSPropertyFontVariantLigatures = 22,
    CSSPropertyFontVariantNumeric = 23,
    CSSPropertyFontVariantPosition = 24,
    CSSPropertyFontVariationSettings = 25,
    CSSPropertyFontWeight = 26,
    CSSPropertyFontWidth = 27,
    CSSPropertyTextOrientation = 28,
    CSSPropertyTextRendering = 29,
    CSSPropertyZoom = 30,
    CSSPropertyWebkitFontSmoothing = 31,
    CSSPropertyWebkitLocale = 32,
    CSSPropertyWebkitTextSizeAdjust = 33,
    CSSPropertyWebkitTextZoom = 34,
    CSSPropertyLetterSpacing = 35,
    CSSPropertyTextAutospace = 36,
    CSSPropertyTextSpacingTrim = 37,
    CSSPropertyAccentColor = 38,
    CSSPropertyAdditiveSymbols = 39,
    CSSPropertyAlignContent = 40,
    CSSPropertyAlignItems = 41,
    CSSPropertyAlignSelf = 42,
    CSSPropertyAlignmentBaseline = 43,
    CSSPropertyAnchorName = 44,
    CSSPropertyAnchorScope = 45,
    CSSPropertyAnimationComposition = 46,
    CSSPropertyAnimationDelay = 47,
    CSSPropertyAnimationDirection = 48,
    CSSPropertyAnimationDuration = 49,
    CSSPropertyAnimationFillMode = 50,
    CSSPropertyAnimationIterationCount = 51,
    CSSPropertyAnimationName = 52,
    CSSPropertyAnimationPlayState = 53,
    CSSPropertyAnimationRangeEnd = 54,
    CSSPropertyAnimationRangeStart = 55,
    CSSPropertyAnimationTimeline = 56,
    CSSPropertyAnimationTimingFunction = 57,
    CSSPropertyAppearance = 58,
    CSSPropertyAspectRatio = 59,
    CSSPropertyBackdropFilter = 60,
    CSSPropertyBackfaceVisibility = 61,
    CSSPropertyBackgroundAttachment = 62,
    CSSPropertyBackgroundBlendMode = 63,
    CSSPropertyBackgroundClip = 64,
    CSSPropertyBackgroundColor = 65,
    CSSPropertyBackgroundImage = 66,
    CSSPropertyBackgroundOrigin = 67,
    CSSPropertyBackgroundPositionX = 68,
    CSSPropertyBackgroundPositionY = 69,
    CSSPropertyBackgroundRepeat = 70,
    CSSPropertyBackgroundSize = 71,
    CSSPropertyBasePalette = 72,
    CSSPropertyBaselineShift = 73,
    CSSPropertyBlockEllipsis = 74,
    CSSPropertyBlockStepAlign = 75,
    CSSPropertyBlockStepInsert = 76,
    CSSPropertyBlockStepRound = 77,
    CSSPropertyBlockStepSize = 78,
    CSSPropertyBorderCollapse = 79,
    CSSPropertyBorderImageOutset = 80,
    CSSPropertyBorderImageRepeat = 81,
    CSSPropertyBorderImageSlice = 82,
    CSSPropertyBorderImageSource = 83,
    CSSPropertyBorderImageWidth = 84,
    CSSPropertyBoxShadow = 85,
    CSSPropertyBoxSizing = 86,
    CSSPropertyBreakAfter = 87,
    CSSPropertyBreakBefore = 88,
    CSSPropertyBreakInside = 89,
    CSSPropertyBufferedRendering = 90,
    CSSPropertyCaptionSide = 91,
    CSSPropertyCaretColor = 92,
    CSSPropertyClear = 93,
    CSSPropertyClip = 94,
    CSSPropertyClipPath = 95,
    CSSPropertyClipRule = 96,
    CSSPropertyColor = 97,
    CSSPropertyColorInterpolation = 98,
    CSSPropertyColorInterpolationFilters = 99,
    CSSPropertyColumnCount = 100,
    CSSPropertyColumnFill = 101,
    CSSPropertyColumnGap = 102,
    CSSPropertyColumnRuleColor = 103,
    CSSPropertyColumnRuleStyle = 104,
    CSSPropertyColumnRuleWidth = 105,
    CSSPropertyColumnSpan = 106,
    CSSPropertyColumnWidth = 107,
    CSSPropertyContain = 108,
    CSSPropertyContainerName = 109,
    CSSPropertyContainerType = 110,
    CSSPropertyContent = 111,
    CSSPropertyContentVisibility = 112,
    CSSPropertyContinue = 113,
    CSSPropertyCounterIncrement = 114,
    CSSPropertyCounterReset = 115,
    CSSPropertyCounterSet = 116,
    CSSPropertyCursor = 117,
    CSSPropertyCx = 118,
    CSSPropertyCy = 119,
    CSSPropertyD = 120,
    CSSPropertyDominantBaseline = 121,
    CSSPropertyDynamicRangeLimit = 122,
    CSSPropertyEmptyCells = 123,
    CSSPropertyFallback = 124,
    CSSPropertyFieldSizing = 125,
    CSSPropertyFill = 126,
    CSSPropertyFillOpacity = 127,
    CSSPropertyFillRule = 128,
    CSSPropertyFilter = 129,
    CSSPropertyFlexBasis = 130,
    CSSPropertyFlexDirection = 131,
    CSSPropertyFlexGrow = 132,
    CSSPropertyFlexShrink = 133,
    CSSPropertyFlexWrap = 134,
    CSSPropertyFloat = 135,
    CSSPropertyFloodColor = 136,
    CSSPropertyFloodOpacity = 137,
    CSSPropertyFontDisplay = 138,
    CSSPropertyGlyphOrientationHorizontal = 139,
    CSSPropertyGlyphOrientationVertical = 140,
    CSSPropertyGridAutoColumns = 141,
    CSSPropertyGridAutoFlow = 142,
    CSSPropertyGridAutoRows = 143,
    CSSPropertyGridColumnEnd = 144,
    CSSPropertyGridColumnStart = 145,
    CSSPropertyGridRowEnd = 146,
    CSSPropertyGridRowStart = 147,
    CSSPropertyGridTemplateAreas = 148,
    CSSPropertyGridTemplateColumns = 149,
    CSSPropertyGridTemplateRows = 150,
    CSSPropertyHangingPunctuation = 151,
    CSSPropertyHyphenateCharacter = 152,
    CSSPropertyHyphens = 153,
    CSSPropertyImageOrientation = 154,
    CSSPropertyImageRendering = 155,
    CSSPropertyInherits = 156,
    CSSPropertyInitialValue = 157,
    CSSPropertyInputSecurity = 158,
    CSSPropertyIsolation = 159,
    CSSPropertyJustifyContent = 160,
    CSSPropertyJustifyItems = 161,
    CSSPropertyJustifySelf = 162,
    CSSPropertyLightingColor = 163,
    CSSPropertyLineBreak = 164,
    CSSPropertyLineFitEdge = 165,
    CSSPropertyLineHeight = 166,
    CSSPropertyListStyleImage = 167,
    CSSPropertyListStylePosition = 168,
    CSSPropertyListStyleType = 169,
    CSSPropertyMarginTrim = 170,
    CSSPropertyMarkerEnd = 171,
    CSSPropertyMarkerMid = 172,
    CSSPropertyMarkerStart = 173,
    CSSPropertyMaskBorderOutset = 174,
    CSSPropertyMaskBorderRepeat = 175,
    CSSPropertyMaskBorderSlice = 176,
    CSSPropertyMaskBorderSource = 177,
    CSSPropertyMaskBorderWidth = 178,
    CSSPropertyMaskClip = 179,
    CSSPropertyMaskComposite = 180,
    CSSPropertyMaskImage = 181,
    CSSPropertyMaskMode = 182,
    CSSPropertyMaskOrigin = 183,
    CSSPropertyMaskRepeat = 184,
    CSSPropertyMaskSize = 185,
    CSSPropertyMaskType = 186,
    CSSPropertyMathStyle = 187,
    CSSPropertyMaxLines = 188,
    CSSPropertyMixBlendMode = 189,
    CSSPropertyNavigation = 190,
    CSSPropertyNegative = 191,
    CSSPropertyObjectFit = 192,
    CSSPropertyObjectPosition = 193,
    CSSPropertyOffsetAnchor = 194,
    CSSPropertyOffsetDistance = 195,
    CSSPropertyOffsetPath = 196,
    CSSPropertyOffsetPosition = 197,
    CSSPropertyOffsetRotate = 198,
    CSSPropertyOpacity = 199,
    CSSPropertyOrder = 200,
    CSSPropertyOrphans = 201,
    CSSPropertyOutlineColor = 202,
    CSSPropertyOutlineOffset = 203,
    CSSPropertyOutlineStyle = 204,
    CSSPropertyOutlineWidth = 205,
    CSSPropertyOverflowAnchor = 206,
    CSSPropertyOverflowWrap = 207,
    CSSPropertyOverrideColors = 208,
    CSSPropertyPad = 209,
    CSSPropertyPage = 210,
    CSSPropertyPaintOrder = 211,
    CSSPropertyPerspective = 212,
    CSSPropertyPerspectiveOriginX = 213,
    CSSPropertyPerspectiveOriginY = 214,
    CSSPropertyPointerEvents = 215,
    CSSPropertyPosition = 216,
    CSSPropertyPositionAnchor = 217,
    CSSPropertyPositionArea = 218,
    CSSPropertyPositionTryFallbacks = 219,
    CSSPropertyPositionTryOrder = 220,
    CSSPropertyPositionVisibility = 221,
    CSSPropertyPrefix = 222,
    CSSPropertyPrintColorAdjust = 223,
    CSSPropertyQuotes = 224,
    CSSPropertyR = 225,
    CSSPropertyRange = 226,
    CSSPropertyResize = 227,
    CSSPropertyRotate = 228,
    CSSPropertyRowGap = 229,
    CSSPropertyRubyAlign = 230,
    CSSPropertyRubyOverhang = 231,
    CSSPropertyRx = 232,
    CSSPropertyRy = 233,
    CSSPropertyScale = 234,
    CSSPropertyScrollBehavior = 235,
    CSSPropertyScrollSnapAlign = 236,
    CSSPropertyScrollSnapStop = 237,
    CSSPropertyScrollSnapType = 238,
    CSSPropertyScrollTimelineAxis = 239,
    CSSPropertyScrollTimelineName = 240,
    CSSPropertyScrollbarColor = 241,
    CSSPropertyScrollbarGutter = 242,
    CSSPropertyScrollbarWidth = 243,
    CSSPropertyShapeImageThreshold = 244,
    CSSPropertyShapeMargin = 245,
    CSSPropertyShapeOutside = 246,
    CSSPropertyShapeRendering = 247,
    CSSPropertySize = 248,
    CSSPropertySizeAdjust = 249,
    CSSPropertySpeakAs = 250,
    CSSPropertySrc = 251,
    CSSPropertyStopColor = 252,
    CSSPropertyStopOpacity = 253,
    CSSPropertyStroke = 254,
    CSSPropertyStrokeColor = 255,
    CSSPropertyStrokeDasharray = 256,
    CSSPropertyStrokeDashoffset = 257,
    CSSPropertyStrokeLinecap = 258,
    CSSPropertyStrokeLinejoin = 259,
    CSSPropertyStrokeMiterlimit = 260,
    CSSPropertyStrokeOpacity = 261,
    CSSPropertyStrokeWidth = 262,
    CSSPropertySuffix = 263,
    CSSPropertySymbols = 264,
    CSSPropertySyntax = 265,
    CSSPropertySystem = 266,
    CSSPropertyTabSize = 267,
    CSSPropertyTableLayout = 268,
    CSSPropertyTextAlign = 269,
    CSSPropertyTextAlignLast = 270,
    CSSPropertyTextAnchor = 271,
    CSSPropertyTextBoxEdge = 272,
    CSSPropertyTextBoxTrim = 273,
    CSSPropertyTextCombineUpright = 274,
    CSSPropertyTextDecorationColor = 275,
    CSSPropertyTextDecorationLine = 276,
    CSSPropertyTextDecorationSkipInk = 277,
    CSSPropertyTextDecorationStyle = 278,
    CSSPropertyTextDecorationThickness = 279,
    CSSPropertyTextEmphasisColor = 280,
    CSSPropertyTextEmphasisPosition = 281,
    CSSPropertyTextEmphasisStyle = 282,
    CSSPropertyTextGroupAlign = 283,
    CSSPropertyTextIndent = 284,
    CSSPropertyTextJustify = 285,
    CSSPropertyTextOverflow = 286,
    CSSPropertyTextShadow = 287,
    CSSPropertyTextTransform = 288,
    CSSPropertyTextUnderlineOffset = 289,
    CSSPropertyTextUnderlinePosition = 290,
    CSSPropertyTextWrapMode = 291,
    CSSPropertyTextWrapStyle = 292,
    CSSPropertyTimelineScope = 293,
    CSSPropertyTouchAction = 294,
    CSSPropertyTransform = 295,
    CSSPropertyTransformBox = 296,
    CSSPropertyTransformOriginX = 297,
    CSSPropertyTransformOriginY = 298,
    CSSPropertyTransformOriginZ = 299,
    CSSPropertyTransformStyle = 300,
    CSSPropertyTransitionBehavior = 301,
    CSSPropertyTransitionDelay = 302,
    CSSPropertyTransitionDuration = 303,
    CSSPropertyTransitionProperty = 304,
    CSSPropertyTransitionTimingFunction = 305,
    CSSPropertyTranslate = 306,
    CSSPropertyTypes = 307,
    CSSPropertyUnicodeBidi = 308,
    CSSPropertyUnicodeRange = 309,
    CSSPropertyVectorEffect = 310,
    CSSPropertyVerticalAlign = 311,
    CSSPropertyViewTimelineAxis = 312,
    CSSPropertyViewTimelineInset = 313,
    CSSPropertyViewTimelineName = 314,
    CSSPropertyViewTransitionClass = 315,
    CSSPropertyViewTransitionName = 316,
    CSSPropertyVisibility = 317,
    CSSPropertyWhiteSpaceCollapse = 318,
    CSSPropertyWidows = 319,
    CSSPropertyWillChange = 320,
    CSSPropertyWordBreak = 321,
    CSSPropertyX = 322,
    CSSPropertyY = 323,
    CSSPropertyZIndex = 324,
    CSSPropertyAppleColorFilter = 325,
    CSSPropertyApplePayButtonStyle = 326,
    CSSPropertyApplePayButtonType = 327,
    CSSPropertyAppleVisualEffect = 328,
    CSSPropertyInternalTextAutosizingStatus = 329,
    CSSPropertyWebkitBackdropFilter = 330,
    CSSPropertyWebkitBackgroundClip = 331,
    CSSPropertyWebkitBackgroundOrigin = 332,
    CSSPropertyWebkitBorderHorizontalSpacing = 333,
    CSSPropertyWebkitBorderVerticalSpacing = 334,
    CSSPropertyWebkitBoxAlign = 335,
    CSSPropertyWebkitBoxDecorationBreak = 336,
    CSSPropertyWebkitBoxDirection = 337,
    CSSPropertyWebkitBoxFlex = 338,
    CSSPropertyWebkitBoxFlexGroup = 339,
    CSSPropertyWebkitBoxLines = 340,
    CSSPropertyWebkitBoxOrdinalGroup = 341,
    CSSPropertyWebkitBoxOrient = 342,
    CSSPropertyWebkitBoxPack = 343,
    CSSPropertyWebkitBoxReflect = 344,
    CSSPropertyWebkitBoxShadow = 345,
    CSSPropertyWebkitColumnAxis = 346,
    CSSPropertyWebkitColumnProgression = 347,
    CSSPropertyWebkitCursorVisibility = 348,
    CSSPropertyWebkitFontSizeDelta = 349,
    CSSPropertyWebkitHyphenateLimitAfter = 350,
    CSSPropertyWebkitHyphenateLimitBefore = 351,
    CSSPropertyWebkitHyphenateLimitLines = 352,
    CSSPropertyWebkitInitialLetter = 353,
    CSSPropertyWebkitLineAlign = 354,
    CSSPropertyWebkitLineBoxContain = 355,
    CSSPropertyWebkitLineClamp = 356,
    CSSPropertyWebkitLineGrid = 357,
    CSSPropertyWebkitLineSnap = 358,
    CSSPropertyWebkitMarqueeDirection = 359,
    CSSPropertyWebkitMarqueeIncrement = 360,
    CSSPropertyWebkitMarqueeRepetition = 361,
    CSSPropertyWebkitMarqueeSpeed = 362,
    CSSPropertyWebkitMarqueeStyle = 363,
    CSSPropertyWebkitMaskClip = 364,
    CSSPropertyWebkitMaskComposite = 365,
    CSSPropertyWebkitMaskPositionX = 366,
    CSSPropertyWebkitMaskPositionY = 367,
    CSSPropertyWebkitMaskSourceType = 368,
    CSSPropertyWebkitNbspMode = 369,
    CSSPropertyWebkitRtlOrdering = 370,
    CSSPropertyWebkitRubyPosition = 371,
    CSSPropertyWebkitTapHighlightColor = 372,
    CSSPropertyWebkitTextCombine = 373,
    CSSPropertyWebkitTextDecorationsInEffect = 374,
    CSSPropertyWebkitTextFillColor = 375,
    CSSPropertyWebkitTextSecurity = 376,
    CSSPropertyWebkitTextStrokeColor = 377,
    CSSPropertyWebkitTextStrokeWidth = 378,
    CSSPropertyWebkitUserDrag = 379,
    CSSPropertyWebkitUserModify = 380,
    CSSPropertyWebkitUserSelect = 381,
    CSSPropertyWordSpacing = 382,
    CSSPropertyBlockSize = 383,
    CSSPropertyBorderBlockEndColor = 384,
    CSSPropertyBorderBlockEndStyle = 385,
    CSSPropertyBorderBlockEndWidth = 386,
    CSSPropertyBorderBlockStartColor = 387,
    CSSPropertyBorderBlockStartStyle = 388,
    CSSPropertyBorderBlockStartWidth = 389,
    CSSPropertyBorderBottomColor = 390,
    CSSPropertyBorderBottomLeftRadius = 391,
    CSSPropertyBorderBottomRightRadius = 392,
    CSSPropertyBorderBottomStyle = 393,
    CSSPropertyBorderBottomWidth = 394,
    CSSPropertyBorderEndEndRadius = 395,
    CSSPropertyBorderEndStartRadius = 396,
    CSSPropertyBorderInlineEndColor = 397,
    CSSPropertyBorderInlineEndStyle = 398,
    CSSPropertyBorderInlineEndWidth = 399,
    CSSPropertyBorderInlineStartColor = 400,
    CSSPropertyBorderInlineStartStyle = 401,
    CSSPropertyBorderInlineStartWidth = 402,
    CSSPropertyBorderLeftColor = 403,
    CSSPropertyBorderLeftStyle = 404,
    CSSPropertyBorderLeftWidth = 405,
    CSSPropertyBorderRightColor = 406,
    CSSPropertyBorderRightStyle = 407,
    CSSPropertyBorderRightWidth = 408,
    CSSPropertyBorderStartEndRadius = 409,
    CSSPropertyBorderStartStartRadius = 410,
    CSSPropertyBorderTopColor = 411,
    CSSPropertyBorderTopLeftRadius = 412,
    CSSPropertyBorderTopRightRadius = 413,
    CSSPropertyBorderTopStyle = 414,
    CSSPropertyBorderTopWidth = 415,
    CSSPropertyBottom = 416,
    CSSPropertyContainIntrinsicBlockSize = 417,
    CSSPropertyContainIntrinsicHeight = 418,
    CSSPropertyContainIntrinsicInlineSize = 419,
    CSSPropertyContainIntrinsicWidth = 420,
    CSSPropertyCornerBottomLeftShape = 421,
    CSSPropertyCornerBottomRightShape = 422,
    CSSPropertyCornerEndEndShape = 423,
    CSSPropertyCornerEndStartShape = 424,
    CSSPropertyCornerStartEndShape = 425,
    CSSPropertyCornerStartStartShape = 426,
    CSSPropertyCornerTopLeftShape = 427,
    CSSPropertyCornerTopRightShape = 428,
    CSSPropertyHeight = 429,
    CSSPropertyInlineSize = 430,
    CSSPropertyInsetBlockEnd = 431,
    CSSPropertyInsetBlockStart = 432,
    CSSPropertyInsetInlineEnd = 433,
    CSSPropertyInsetInlineStart = 434,
    CSSPropertyLeft = 435,
    CSSPropertyMarginBlockEnd = 436,
    CSSPropertyMarginBlockStart = 437,
    CSSPropertyMarginBottom = 438,
    CSSPropertyMarginInlineEnd = 439,
    CSSPropertyMarginInlineStart = 440,
    CSSPropertyMarginLeft = 441,
    CSSPropertyMarginRight = 442,
    CSSPropertyMarginTop = 443,
    CSSPropertyMaxBlockSize = 444,
    CSSPropertyMaxHeight = 445,
    CSSPropertyMaxInlineSize = 446,
    CSSPropertyMaxWidth = 447,
    CSSPropertyMinBlockSize = 448,
    CSSPropertyMinHeight = 449,
    CSSPropertyMinInlineSize = 450,
    CSSPropertyMinWidth = 451,
    CSSPropertyOverflowBlock = 452,
    CSSPropertyOverflowInline = 453,
    CSSPropertyOverflowX = 454,
    CSSPropertyOverflowY = 455,
    CSSPropertyOverscrollBehaviorBlock = 456,
    CSSPropertyOverscrollBehaviorInline = 457,
    CSSPropertyOverscrollBehaviorX = 458,
    CSSPropertyOverscrollBehaviorY = 459,
    CSSPropertyPaddingBlockEnd = 460,
    CSSPropertyPaddingBlockStart = 461,
    CSSPropertyPaddingBottom = 462,
    CSSPropertyPaddingInlineEnd = 463,
    CSSPropertyPaddingInlineStart = 464,
    CSSPropertyPaddingLeft = 465,
    CSSPropertyPaddingRight = 466,
    CSSPropertyPaddingTop = 467,
    CSSPropertyRight = 468,
    CSSPropertyScrollMarginBlockEnd = 469,
    CSSPropertyScrollMarginBlockStart = 470,
    CSSPropertyScrollMarginBottom = 471,
    CSSPropertyScrollMarginInlineEnd = 472,
    CSSPropertyScrollMarginInlineStart = 473,
    CSSPropertyScrollMarginLeft = 474,
    CSSPropertyScrollMarginRight = 475,
    CSSPropertyScrollMarginTop = 476,
    CSSPropertyScrollPaddingBlockEnd = 477,
    CSSPropertyScrollPaddingBlockStart = 478,
    CSSPropertyScrollPaddingBottom = 479,
    CSSPropertyScrollPaddingInlineEnd = 480,
    CSSPropertyScrollPaddingInlineStart = 481,
    CSSPropertyScrollPaddingLeft = 482,
    CSSPropertyScrollPaddingRight = 483,
    CSSPropertyScrollPaddingTop = 484,
    CSSPropertyTop = 485,
    CSSPropertyWidth = 486,
    CSSPropertyAll = 487,
    CSSPropertyAnimation = 488,
    CSSPropertyAnimationRange = 489,
    CSSPropertyBackground = 490,
    CSSPropertyBackgroundPosition = 491,
    CSSPropertyBlockStep = 492,
    CSSPropertyBorder = 493,
    CSSPropertyBorderBlock = 494,
    CSSPropertyBorderBlockColor = 495,
    CSSPropertyBorderBlockEnd = 496,
    CSSPropertyBorderBlockStart = 497,
    CSSPropertyBorderBlockStyle = 498,
    CSSPropertyBorderBlockWidth = 499,
    CSSPropertyBorderBottom = 500,
    CSSPropertyBorderColor = 501,
    CSSPropertyBorderImage = 502,
    CSSPropertyBorderInline = 503,
    CSSPropertyBorderInlineColor = 504,
    CSSPropertyBorderInlineEnd = 505,
    CSSPropertyBorderInlineStart = 506,
    CSSPropertyBorderInlineStyle = 507,
    CSSPropertyBorderInlineWidth = 508,
    CSSPropertyBorderLeft = 509,
    CSSPropertyBorderRadius = 510,
    CSSPropertyBorderRight = 511,
    CSSPropertyBorderSpacing = 512,
    CSSPropertyBorderStyle = 513,
    CSSPropertyBorderTop = 514,
    CSSPropertyBorderWidth = 515,
    CSSPropertyColumnRule = 516,
    CSSPropertyColumns = 517,
    CSSPropertyContainIntrinsicSize = 518,
    CSSPropertyContainer = 519,
    CSSPropertyCornerShape = 520,
    CSSPropertyFlex = 521,
    CSSPropertyFlexFlow = 522,
    CSSPropertyFont = 523,
    CSSPropertyFontSynthesis = 524,
    CSSPropertyFontVariant = 525,
    CSSPropertyGap = 526,
    CSSPropertyGrid = 527,
    CSSPropertyGridArea = 528,
    CSSPropertyGridColumn = 529,
    CSSPropertyGridRow = 530,
    CSSPropertyGridTemplate = 531,
    CSSPropertyInset = 532,
    CSSPropertyInsetBlock = 533,
    CSSPropertyInsetInline = 534,
    CSSPropertyLineClamp = 535,
    CSSPropertyListStyle = 536,
    CSSPropertyMargin = 537,
    CSSPropertyMarginBlock = 538,
    CSSPropertyMarginInline = 539,
    CSSPropertyMarker = 540,
    CSSPropertyMask = 541,
    CSSPropertyMaskBorder = 542,
    CSSPropertyMaskPosition = 543,
    CSSPropertyOffset = 544,
    CSSPropertyOutline = 545,
    CSSPropertyOverflow = 546,
    CSSPropertyOverscrollBehavior = 547,
    CSSPropertyPadding = 548,
    CSSPropertyPaddingBlock = 549,
    CSSPropertyPaddingInline = 550,
    CSSPropertyPageBreakAfter = 551,
    CSSPropertyPageBreakBefore = 552,
    CSSPropertyPageBreakInside = 553,
    CSSPropertyPerspectiveOrigin = 554,
    CSSPropertyPlaceContent = 555,
    CSSPropertyPlaceItems = 556,
    CSSPropertyPlaceSelf = 557,
    CSSPropertyPositionTry = 558,
    CSSPropertyScrollMargin = 559,
    CSSPropertyScrollMarginBlock = 560,
    CSSPropertyScrollMarginInline = 561,
    CSSPropertyScrollPadding = 562,
    CSSPropertyScrollPaddingBlock = 563,
    CSSPropertyScrollPaddingInline = 564,
    CSSPropertyScrollTimeline = 565,
    CSSPropertyTextBox = 566,
    CSSPropertyTextDecoration = 567,
    CSSPropertyTextDecorationSkip = 568,
    CSSPropertyTextEmphasis = 569,
    CSSPropertyTextWrap = 570,
    CSSPropertyTransformOrigin = 571,
    CSSPropertyTransition = 572,
    CSSPropertyViewTimeline = 573,
    CSSPropertyWhiteSpace = 574,
    CSSPropertyWebkitBackgroundSize = 575,
    CSSPropertyWebkitBorderImage = 576,
    CSSPropertyWebkitBorderRadius = 577,
    CSSPropertyWebkitColumnBreakAfter = 578,
    CSSPropertyWebkitColumnBreakBefore = 579,
    CSSPropertyWebkitColumnBreakInside = 580,
    CSSPropertyWebkitMask = 581,
    CSSPropertyWebkitMaskBoxImage = 582,
    CSSPropertyWebkitMaskPosition = 583,
    CSSPropertyWebkitPerspective = 584,
    CSSPropertyWebkitTextDecoration = 585,
    CSSPropertyWebkitTextOrientation = 586,
    CSSPropertyWebkitTextStroke = 587,
};

// Enum value of the first "real" CSS property, which excludes
// CSSPropertyInvalid and CSSPropertyCustom.
constexpr uint16_t firstCSSProperty = 2;
// Total number of enum values in the CSSPropertyID enum. If making an array
// that can be indexed into using the enum value, use this as the size.
constexpr uint16_t cssPropertyIDEnumValueCount = 588;
// Number of "real" CSS properties. This differs from cssPropertyIDEnumValueCount,
// as this doesn't consider CSSPropertyInvalid and CSSPropertyCustom.
constexpr uint16_t numCSSProperties = 586;
constexpr unsigned maxCSSPropertyNameLength = 34;
constexpr auto firstTopPriorityProperty = CSSPropertyID::CSSPropertyColorScheme;
constexpr auto lastTopPriorityProperty = CSSPropertyID::CSSPropertyWritingMode;
constexpr auto firstHighPriorityProperty = CSSPropertyID::CSSPropertyDirection;
constexpr auto lastHighPriorityProperty = CSSPropertyID::CSSPropertyTextSpacingTrim;
constexpr auto firstLowPriorityProperty = CSSPropertyID::CSSPropertyAccentColor;
constexpr auto lastLowPriorityProperty = CSSPropertyID::CSSPropertyWordSpacing;
constexpr auto firstLogicalGroupProperty = CSSPropertyID::CSSPropertyBlockSize;
constexpr auto lastLogicalGroupProperty = CSSPropertyID::CSSPropertyWidth;
constexpr auto firstShorthandProperty = CSSPropertyID::CSSPropertyAll;
constexpr auto lastShorthandProperty = CSSPropertyID::CSSPropertyWebkitTextStroke;
constexpr uint16_t numCSSPropertyLonghands = firstShorthandProperty - firstCSSProperty;
extern const std::array<CSSPropertyID, 452> computedPropertyIDs;

struct CSSPropertySettings {
    WTF_MAKE_STRUCT_FAST_ALLOCATED;

    bool CSSOMViewSmoothScrollingEnabled : 1 { false };
    bool accentColorEnabled : 1 { false };
    bool colorFilterEnabled : 1 { false };
    bool crossDocumentViewTransitionsEnabled : 1 { false };
    bool cssAnchorPositioningEnabled : 1 { false };
    bool cssContentVisibilityEnabled : 1 { false };
    bool cssCornerShapeEnabled : 1 { false };
    bool cssCounterStyleAtRulesEnabled : 1 { false };
    bool cssDPropertyEnabled : 1 { false };
    bool cssFieldSizingEnabled : 1 { false };
    bool cssFontFaceSizeAdjustEnabled : 1 { false };
    bool cssFontVariantEmojiEnabled : 1 { false };
    bool cssInputSecurityEnabled : 1 { false };
    bool cssLineClampEnabled : 1 { false };
    bool cssLineFitEdgeEnabled : 1 { false };
    bool cssMarginTrimEnabled : 1 { false };
    bool cssMotionPathEnabled : 1 { false };
    bool cssRhythmicSizingEnabled : 1 { false };
    bool cssRubyAlignEnabled : 1 { false };
    bool cssRubyOverhangEnabled : 1 { false };
    bool cssScrollAnchoringEnabled : 1 { false };
    bool cssScrollbarColorEnabled : 1 { false };
    bool cssScrollbarGutterEnabled : 1 { false };
    bool cssScrollbarWidthEnabled : 1 { false };
    bool cssTextAutospaceEnabled : 1 { false };
    bool cssTextBoxTrimEnabled : 1 { false };
    bool cssTextGroupAlignEnabled : 1 { false };
    bool cssTextJustifyEnabled : 1 { false };
    bool cssTextSpacingTrimEnabled : 1 { false };
    bool cssTextWrapStyleEnabled : 1 { false };
    bool cssUnprefixedBackdropFilterEnabled : 1 { false };
    bool overscrollBehaviorEnabled : 1 { false };
    bool scrollDrivenAnimationsEnabled : 1 { false };
    bool supportHDRDisplayEnabled : 1 { false };
    bool textAutosizingEnabled : 1 { false };
    bool useSystemAppearance : 1 { false };
    bool viewTransitionClassesEnabled : 1 { false };
    bool viewTransitionsEnabled : 1 { false };

    CSSPropertySettings() = default;
    explicit CSSPropertySettings(const Settings&);
};

bool operator==(const CSSPropertySettings&, const CSSPropertySettings&);
void add(Hasher&, const CSSPropertySettings&);

constexpr bool isLonghand(CSSPropertyID);
bool isInternal(CSSPropertyID);
bool isExposed(CSSPropertyID, const Settings*);
bool isExposed(CSSPropertyID, const Settings&);
bool isExposed(CSSPropertyID, const CSSPropertySettings*);
bool isExposed(CSSPropertyID, const CSSPropertySettings&);

CSSPropertyID findCSSProperty(const char* characters, unsigned length);
ASCIILiteral nameLiteral(CSSPropertyID);
const AtomString& nameString(CSSPropertyID);
String nameForIDL(CSSPropertyID);

CSSPropertyID cascadeAliasProperty(CSSPropertyID);

template<CSSPropertyID first, CSSPropertyID last> struct CSSPropertiesRange {
    struct Iterator {
        uint16_t index { static_cast<uint16_t>(first) };
        constexpr CSSPropertyID operator*() const { return static_cast<CSSPropertyID>(index); }
        constexpr Iterator& operator++() { ++index; return *this; }
        constexpr bool operator==(std::nullptr_t) const { return index > static_cast<uint16_t>(last); }
    };
    static constexpr Iterator begin() { return { }; }
    static constexpr std::nullptr_t end() { return nullptr; }
    static constexpr uint16_t size() { return last - first + 1; }
};
using AllCSSPropertiesRange = CSSPropertiesRange<static_cast<CSSPropertyID>(firstCSSProperty), lastShorthandProperty>;
using AllLonghandCSSPropertiesRange = CSSPropertiesRange<static_cast<CSSPropertyID>(firstCSSProperty), lastLogicalGroupProperty>;
constexpr AllCSSPropertiesRange allCSSProperties() { return { }; }
constexpr AllLonghandCSSPropertiesRange allLonghandCSSProperties() { return { }; }

constexpr bool isLonghand(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= firstCSSProperty && static_cast<uint16_t>(property) < static_cast<uint16_t>(firstShorthandProperty);
}
constexpr bool isShorthand(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= static_cast<uint16_t>(firstShorthandProperty) && static_cast<uint16_t>(property) <= static_cast<uint16_t>(lastShorthandProperty);
}

WTF::TextStream& operator<<(WTF::TextStream&, CSSPropertyID);

} // namespace WebCore

namespace WTF {

template<> struct DefaultHash<WebCore::CSSPropertyID> : IntHash<unsigned> { };

template<> struct HashTraits<WebCore::CSSPropertyID> : GenericHashTraits<WebCore::CSSPropertyID> {
    static const bool emptyValueIsZero = true;
    static void constructDeletedValue(WebCore::CSSPropertyID& slot) { slot = static_cast<WebCore::CSSPropertyID>(std::numeric_limits<uint16_t>::max()); }
    static bool isDeletedValue(WebCore::CSSPropertyID value) { return static_cast<uint16_t>(value) == std::numeric_limits<uint16_t>::max(); }
};

} // namespace WTF

namespace std {

template<> struct iterator_traits<WebCore::AllCSSPropertiesRange::Iterator> { using value_type = WebCore::CSSPropertyID; };
template<> struct iterator_traits<WebCore::AllLonghandCSSPropertiesRange::Iterator> { using value_type = WebCore::CSSPropertyID; };

} // namespace std

