/*
 * Copyright (C) 2019-2023 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#include <JavaScriptCore/HeapCellType.h>
#include <wtf/PtrTag.h>
#include <wtf/TZoneMalloc.h>

namespace JSC {

class JS_EXPORT_PRIVATE IsoHeapCellType final : public HeapCellType {
    WTF_MAKE_TZONE_ALLOCATED(IsoHeapCellType);
public:
    using DestroyFunctionPtr = void (*)(JSCell*);

    ~IsoHeapCellType();

    template<typename CellType>
    struct Args {
        Args()
            : mode(CellType::needsDestruction)
            , functionPtr(&CellType::destroy)
        { }

        DestructionMode mode;
        DestroyFunctionPtr functionPtr;
    };

    template<typename CellType>
    IsoHeapCellType(Args<CellType>&& args)
        : IsoHeapCellType(args.mode, args.functionPtr)
    { }

    void finishSweep(MarkedBlock::Handle&, FreeList*) const final;
    void destroy(VM&, JSCell*) const final;

    ALWAYS_INLINE void operator()(VM&, JSCell* cell) const
    {
        m_destroy(cell);
    }

private:
    IsoHeapCellType(DestructionMode, DestroyFunctionPtr);

    DestroyFunctionPtr WTF_VTBL_FUNCPTR_PTRAUTH_STR("IsoHeapCellType.destroy") m_destroy;
};

} // namespace JSC
