// This file is automatically generated from CSSProperties.json by the process-css-properties.py script. Do not edit it.

#pragma once

#include <array>
#include <wtf/HashFunctions.h>
#include <wtf/HashTraits.h>

namespace WebCore {

class Settings;

enum CSSPropertyID : uint16_t {
    CSSPropertyInvalid = 0,
    CSSPropertyCustom = 1,
    CSSPropertyColorScheme = 2,
    CSSPropertyRubyPosition = 3,
    CSSPropertyWritingMode = 4,
    CSSPropertyDirection = 5,
    CSSPropertyDisplay = 6,
    CSSPropertyFontFamily = 7,
    CSSPropertyFontFeatureSettings = 8,
    CSSPropertyFontKerning = 9,
    CSSPropertyFontOpticalSizing = 10,
    CSSPropertyFontPalette = 11,
    CSSPropertyFontSize = 12,
    CSSPropertyFontSizeAdjust = 13,
    CSSPropertyFontStyle = 14,
    CSSPropertyFontSynthesisSmallCaps = 15,
    CSSPropertyFontSynthesisStyle = 16,
    CSSPropertyFontSynthesisWeight = 17,
    CSSPropertyFontVariantAlternates = 18,
    CSSPropertyFontVariantCaps = 19,
    CSSPropertyFontVariantEastAsian = 20,
    CSSPropertyFontVariantEmoji = 21,
    CSSPropertyFontVariantLigatures = 22,
    CSSPropertyFontVariantNumeric = 23,
    CSSPropertyFontVariantPosition = 24,
    CSSPropertyFontVariationSettings = 25,
    CSSPropertyFontWeight = 26,
    CSSPropertyFontWidth = 27,
    CSSPropertyTextOrientation = 28,
    CSSPropertyTextRendering = 29,
    CSSPropertyZoom = 30,
    CSSPropertyWebkitFontSmoothing = 31,
    CSSPropertyWebkitLocale = 32,
    CSSPropertyWebkitTextSizeAdjust = 33,
    CSSPropertyWebkitTextZoom = 34,
    CSSPropertyLetterSpacing = 35,
    CSSPropertyTextAutospace = 36,
    CSSPropertyTextSpacingTrim = 37,
    CSSPropertyWordSpacing = 38,
    CSSPropertyBackgroundImage = 39,
    CSSPropertyMaskImage = 40,
    CSSPropertyAccentColor = 41,
    CSSPropertyAdditiveSymbols = 42,
    CSSPropertyAlignContent = 43,
    CSSPropertyAlignItems = 44,
    CSSPropertyAlignSelf = 45,
    CSSPropertyAlignmentBaseline = 46,
    CSSPropertyAnchorName = 47,
    CSSPropertyAnchorScope = 48,
    CSSPropertyAnimationComposition = 49,
    CSSPropertyAnimationDelay = 50,
    CSSPropertyAnimationDirection = 51,
    CSSPropertyAnimationDuration = 52,
    CSSPropertyAnimationFillMode = 53,
    CSSPropertyAnimationIterationCount = 54,
    CSSPropertyAnimationName = 55,
    CSSPropertyAnimationPlayState = 56,
    CSSPropertyAnimationRangeEnd = 57,
    CSSPropertyAnimationRangeStart = 58,
    CSSPropertyAnimationTimeline = 59,
    CSSPropertyAnimationTimingFunction = 60,
    CSSPropertyAppearance = 61,
    CSSPropertyAspectRatio = 62,
    CSSPropertyBackdropFilter = 63,
    CSSPropertyBackfaceVisibility = 64,
    CSSPropertyBackgroundAttachment = 65,
    CSSPropertyBackgroundBlendMode = 66,
    CSSPropertyBackgroundClip = 67,
    CSSPropertyBackgroundColor = 68,
    CSSPropertyBackgroundOrigin = 69,
    CSSPropertyBackgroundPositionX = 70,
    CSSPropertyBackgroundPositionY = 71,
    CSSPropertyBackgroundRepeat = 72,
    CSSPropertyBackgroundSize = 73,
    CSSPropertyBasePalette = 74,
    CSSPropertyBaselineShift = 75,
    CSSPropertyBlockEllipsis = 76,
    CSSPropertyBlockStepAlign = 77,
    CSSPropertyBlockStepInsert = 78,
    CSSPropertyBlockStepRound = 79,
    CSSPropertyBlockStepSize = 80,
    CSSPropertyBorderCollapse = 81,
    CSSPropertyBorderImageOutset = 82,
    CSSPropertyBorderImageRepeat = 83,
    CSSPropertyBorderImageSlice = 84,
    CSSPropertyBorderImageSource = 85,
    CSSPropertyBorderImageWidth = 86,
    CSSPropertyBoxShadow = 87,
    CSSPropertyBoxSizing = 88,
    CSSPropertyBreakAfter = 89,
    CSSPropertyBreakBefore = 90,
    CSSPropertyBreakInside = 91,
    CSSPropertyBufferedRendering = 92,
    CSSPropertyCaptionSide = 93,
    CSSPropertyCaretColor = 94,
    CSSPropertyClear = 95,
    CSSPropertyClip = 96,
    CSSPropertyClipPath = 97,
    CSSPropertyClipRule = 98,
    CSSPropertyColor = 99,
    CSSPropertyColorInterpolation = 100,
    CSSPropertyColorInterpolationFilters = 101,
    CSSPropertyColumnCount = 102,
    CSSPropertyColumnFill = 103,
    CSSPropertyColumnGap = 104,
    CSSPropertyColumnRuleColor = 105,
    CSSPropertyColumnRuleStyle = 106,
    CSSPropertyColumnRuleWidth = 107,
    CSSPropertyColumnSpan = 108,
    CSSPropertyColumnWidth = 109,
    CSSPropertyContain = 110,
    CSSPropertyContainerName = 111,
    CSSPropertyContainerType = 112,
    CSSPropertyContent = 113,
    CSSPropertyContentVisibility = 114,
    CSSPropertyContinue = 115,
    CSSPropertyCounterIncrement = 116,
    CSSPropertyCounterReset = 117,
    CSSPropertyCounterSet = 118,
    CSSPropertyCursor = 119,
    CSSPropertyCx = 120,
    CSSPropertyCy = 121,
    CSSPropertyD = 122,
    CSSPropertyDominantBaseline = 123,
    CSSPropertyDynamicRangeLimit = 124,
    CSSPropertyEmptyCells = 125,
    CSSPropertyFallback = 126,
    CSSPropertyFieldSizing = 127,
    CSSPropertyFill = 128,
    CSSPropertyFillOpacity = 129,
    CSSPropertyFillRule = 130,
    CSSPropertyFilter = 131,
    CSSPropertyFlexBasis = 132,
    CSSPropertyFlexDirection = 133,
    CSSPropertyFlexGrow = 134,
    CSSPropertyFlexShrink = 135,
    CSSPropertyFlexWrap = 136,
    CSSPropertyFloat = 137,
    CSSPropertyFloodColor = 138,
    CSSPropertyFloodOpacity = 139,
    CSSPropertyFontDisplay = 140,
    CSSPropertyGlyphOrientationHorizontal = 141,
    CSSPropertyGlyphOrientationVertical = 142,
    CSSPropertyGridAutoColumns = 143,
    CSSPropertyGridAutoFlow = 144,
    CSSPropertyGridAutoRows = 145,
    CSSPropertyGridColumnEnd = 146,
    CSSPropertyGridColumnStart = 147,
    CSSPropertyGridRowEnd = 148,
    CSSPropertyGridRowStart = 149,
    CSSPropertyGridTemplateAreas = 150,
    CSSPropertyGridTemplateColumns = 151,
    CSSPropertyGridTemplateRows = 152,
    CSSPropertyHangingPunctuation = 153,
    CSSPropertyHyphenateCharacter = 154,
    CSSPropertyHyphens = 155,
    CSSPropertyImageOrientation = 156,
    CSSPropertyImageRendering = 157,
    CSSPropertyInherits = 158,
    CSSPropertyInitialValue = 159,
    CSSPropertyInputSecurity = 160,
    CSSPropertyIsolation = 161,
    CSSPropertyJustifyContent = 162,
    CSSPropertyJustifyItems = 163,
    CSSPropertyJustifySelf = 164,
    CSSPropertyLightingColor = 165,
    CSSPropertyLineBreak = 166,
    CSSPropertyLineFitEdge = 167,
    CSSPropertyLineHeight = 168,
    CSSPropertyListStyleImage = 169,
    CSSPropertyListStylePosition = 170,
    CSSPropertyListStyleType = 171,
    CSSPropertyMarginTrim = 172,
    CSSPropertyMarkerEnd = 173,
    CSSPropertyMarkerMid = 174,
    CSSPropertyMarkerStart = 175,
    CSSPropertyMaskBorderOutset = 176,
    CSSPropertyMaskBorderRepeat = 177,
    CSSPropertyMaskBorderSlice = 178,
    CSSPropertyMaskBorderSource = 179,
    CSSPropertyMaskBorderWidth = 180,
    CSSPropertyMaskClip = 181,
    CSSPropertyMaskComposite = 182,
    CSSPropertyMaskMode = 183,
    CSSPropertyMaskOrigin = 184,
    CSSPropertyMaskRepeat = 185,
    CSSPropertyMaskSize = 186,
    CSSPropertyMaskType = 187,
    CSSPropertyMathShift = 188,
    CSSPropertyMathStyle = 189,
    CSSPropertyMaxLines = 190,
    CSSPropertyMixBlendMode = 191,
    CSSPropertyNavigation = 192,
    CSSPropertyNegative = 193,
    CSSPropertyObjectFit = 194,
    CSSPropertyObjectPosition = 195,
    CSSPropertyOffsetAnchor = 196,
    CSSPropertyOffsetDistance = 197,
    CSSPropertyOffsetPath = 198,
    CSSPropertyOffsetPosition = 199,
    CSSPropertyOffsetRotate = 200,
    CSSPropertyOpacity = 201,
    CSSPropertyOrder = 202,
    CSSPropertyOrphans = 203,
    CSSPropertyOutlineColor = 204,
    CSSPropertyOutlineOffset = 205,
    CSSPropertyOutlineStyle = 206,
    CSSPropertyOutlineWidth = 207,
    CSSPropertyOverflowAnchor = 208,
    CSSPropertyOverflowWrap = 209,
    CSSPropertyOverrideColors = 210,
    CSSPropertyPad = 211,
    CSSPropertyPage = 212,
    CSSPropertyPaintOrder = 213,
    CSSPropertyPerspective = 214,
    CSSPropertyPerspectiveOriginX = 215,
    CSSPropertyPerspectiveOriginY = 216,
    CSSPropertyPointerEvents = 217,
    CSSPropertyPosition = 218,
    CSSPropertyPositionAnchor = 219,
    CSSPropertyPositionArea = 220,
    CSSPropertyPositionTryFallbacks = 221,
    CSSPropertyPositionTryOrder = 222,
    CSSPropertyPositionVisibility = 223,
    CSSPropertyPrefix = 224,
    CSSPropertyPrintColorAdjust = 225,
    CSSPropertyQuotes = 226,
    CSSPropertyR = 227,
    CSSPropertyRange = 228,
    CSSPropertyResize = 229,
    CSSPropertyResult = 230,
    CSSPropertyRotate = 231,
    CSSPropertyRowGap = 232,
    CSSPropertyRubyAlign = 233,
    CSSPropertyRubyOverhang = 234,
    CSSPropertyRx = 235,
    CSSPropertyRy = 236,
    CSSPropertyScale = 237,
    CSSPropertyScrollBehavior = 238,
    CSSPropertyScrollSnapAlign = 239,
    CSSPropertyScrollSnapStop = 240,
    CSSPropertyScrollSnapType = 241,
    CSSPropertyScrollTimelineAxis = 242,
    CSSPropertyScrollTimelineName = 243,
    CSSPropertyScrollbarColor = 244,
    CSSPropertyScrollbarGutter = 245,
    CSSPropertyScrollbarWidth = 246,
    CSSPropertyShapeImageThreshold = 247,
    CSSPropertyShapeMargin = 248,
    CSSPropertyShapeOutside = 249,
    CSSPropertyShapeRendering = 250,
    CSSPropertySize = 251,
    CSSPropertySizeAdjust = 252,
    CSSPropertySpeakAs = 253,
    CSSPropertySrc = 254,
    CSSPropertyStopColor = 255,
    CSSPropertyStopOpacity = 256,
    CSSPropertyStroke = 257,
    CSSPropertyStrokeColor = 258,
    CSSPropertyStrokeDasharray = 259,
    CSSPropertyStrokeDashoffset = 260,
    CSSPropertyStrokeLinecap = 261,
    CSSPropertyStrokeLinejoin = 262,
    CSSPropertyStrokeMiterlimit = 263,
    CSSPropertyStrokeOpacity = 264,
    CSSPropertyStrokeWidth = 265,
    CSSPropertySuffix = 266,
    CSSPropertySymbols = 267,
    CSSPropertySyntax = 268,
    CSSPropertySystem = 269,
    CSSPropertyTabSize = 270,
    CSSPropertyTableLayout = 271,
    CSSPropertyTextAlign = 272,
    CSSPropertyTextAlignLast = 273,
    CSSPropertyTextAnchor = 274,
    CSSPropertyTextBoxEdge = 275,
    CSSPropertyTextBoxTrim = 276,
    CSSPropertyTextCombineUpright = 277,
    CSSPropertyTextDecorationColor = 278,
    CSSPropertyTextDecorationLine = 279,
    CSSPropertyTextDecorationSkipInk = 280,
    CSSPropertyTextDecorationStyle = 281,
    CSSPropertyTextDecorationThickness = 282,
    CSSPropertyTextEmphasisColor = 283,
    CSSPropertyTextEmphasisPosition = 284,
    CSSPropertyTextEmphasisStyle = 285,
    CSSPropertyTextGroupAlign = 286,
    CSSPropertyTextIndent = 287,
    CSSPropertyTextJustify = 288,
    CSSPropertyTextOverflow = 289,
    CSSPropertyTextShadow = 290,
    CSSPropertyTextTransform = 291,
    CSSPropertyTextUnderlineOffset = 292,
    CSSPropertyTextUnderlinePosition = 293,
    CSSPropertyTextWrapMode = 294,
    CSSPropertyTextWrapStyle = 295,
    CSSPropertyTimelineScope = 296,
    CSSPropertyTouchAction = 297,
    CSSPropertyTransform = 298,
    CSSPropertyTransformBox = 299,
    CSSPropertyTransformOriginX = 300,
    CSSPropertyTransformOriginY = 301,
    CSSPropertyTransformOriginZ = 302,
    CSSPropertyTransformStyle = 303,
    CSSPropertyTransitionBehavior = 304,
    CSSPropertyTransitionDelay = 305,
    CSSPropertyTransitionDuration = 306,
    CSSPropertyTransitionProperty = 307,
    CSSPropertyTransitionTimingFunction = 308,
    CSSPropertyTranslate = 309,
    CSSPropertyTypes = 310,
    CSSPropertyUnicodeBidi = 311,
    CSSPropertyUnicodeRange = 312,
    CSSPropertyVectorEffect = 313,
    CSSPropertyVerticalAlign = 314,
    CSSPropertyViewTimelineAxis = 315,
    CSSPropertyViewTimelineInset = 316,
    CSSPropertyViewTimelineName = 317,
    CSSPropertyViewTransitionClass = 318,
    CSSPropertyViewTransitionName = 319,
    CSSPropertyVisibility = 320,
    CSSPropertyWhiteSpaceCollapse = 321,
    CSSPropertyWidows = 322,
    CSSPropertyWillChange = 323,
    CSSPropertyWordBreak = 324,
    CSSPropertyX = 325,
    CSSPropertyY = 326,
    CSSPropertyZIndex = 327,
    CSSPropertyAppleColorFilter = 328,
    CSSPropertyApplePayButtonStyle = 329,
    CSSPropertyApplePayButtonType = 330,
    CSSPropertyAppleVisualEffect = 331,
    CSSPropertyInternalTextAutosizingStatus = 332,
    CSSPropertyWebkitBackdropFilter = 333,
    CSSPropertyWebkitBackgroundClip = 334,
    CSSPropertyWebkitBackgroundOrigin = 335,
    CSSPropertyWebkitBorderHorizontalSpacing = 336,
    CSSPropertyWebkitBorderVerticalSpacing = 337,
    CSSPropertyWebkitBoxAlign = 338,
    CSSPropertyWebkitBoxDecorationBreak = 339,
    CSSPropertyWebkitBoxDirection = 340,
    CSSPropertyWebkitBoxFlex = 341,
    CSSPropertyWebkitBoxFlexGroup = 342,
    CSSPropertyWebkitBoxLines = 343,
    CSSPropertyWebkitBoxOrdinalGroup = 344,
    CSSPropertyWebkitBoxOrient = 345,
    CSSPropertyWebkitBoxPack = 346,
    CSSPropertyWebkitBoxReflect = 347,
    CSSPropertyWebkitBoxShadow = 348,
    CSSPropertyWebkitColumnAxis = 349,
    CSSPropertyWebkitColumnProgression = 350,
    CSSPropertyWebkitCursorVisibility = 351,
    CSSPropertyWebkitFontSizeDelta = 352,
    CSSPropertyWebkitHyphenateLimitAfter = 353,
    CSSPropertyWebkitHyphenateLimitBefore = 354,
    CSSPropertyWebkitHyphenateLimitLines = 355,
    CSSPropertyWebkitInitialLetter = 356,
    CSSPropertyWebkitLineAlign = 357,
    CSSPropertyWebkitLineBoxContain = 358,
    CSSPropertyWebkitLineClamp = 359,
    CSSPropertyWebkitLineGrid = 360,
    CSSPropertyWebkitLineSnap = 361,
    CSSPropertyWebkitMarqueeDirection = 362,
    CSSPropertyWebkitMarqueeIncrement = 363,
    CSSPropertyWebkitMarqueeRepetition = 364,
    CSSPropertyWebkitMarqueeSpeed = 365,
    CSSPropertyWebkitMarqueeStyle = 366,
    CSSPropertyWebkitMaskClip = 367,
    CSSPropertyWebkitMaskComposite = 368,
    CSSPropertyWebkitMaskPositionX = 369,
    CSSPropertyWebkitMaskPositionY = 370,
    CSSPropertyWebkitMaskSourceType = 371,
    CSSPropertyWebkitNbspMode = 372,
    CSSPropertyWebkitRtlOrdering = 373,
    CSSPropertyWebkitRubyPosition = 374,
    CSSPropertyWebkitTapHighlightColor = 375,
    CSSPropertyWebkitTextCombine = 376,
    CSSPropertyWebkitTextDecorationsInEffect = 377,
    CSSPropertyWebkitTextFillColor = 378,
    CSSPropertyWebkitTextSecurity = 379,
    CSSPropertyWebkitTextStrokeColor = 380,
    CSSPropertyWebkitTextStrokeWidth = 381,
    CSSPropertyWebkitUserDrag = 382,
    CSSPropertyWebkitUserModify = 383,
    CSSPropertyWebkitUserSelect = 384,
    CSSPropertyBorderBottomColor = 385,
    CSSPropertyBorderBottomLeftRadius = 386,
    CSSPropertyBorderBottomRightRadius = 387,
    CSSPropertyBorderBottomStyle = 388,
    CSSPropertyBorderBottomWidth = 389,
    CSSPropertyBorderLeftColor = 390,
    CSSPropertyBorderLeftStyle = 391,
    CSSPropertyBorderLeftWidth = 392,
    CSSPropertyBorderRightColor = 393,
    CSSPropertyBorderRightStyle = 394,
    CSSPropertyBorderRightWidth = 395,
    CSSPropertyBorderTopColor = 396,
    CSSPropertyBorderTopLeftRadius = 397,
    CSSPropertyBorderTopRightRadius = 398,
    CSSPropertyBorderTopStyle = 399,
    CSSPropertyBorderTopWidth = 400,
    CSSPropertyBottom = 401,
    CSSPropertyContainIntrinsicHeight = 402,
    CSSPropertyContainIntrinsicWidth = 403,
    CSSPropertyCornerBottomLeftShape = 404,
    CSSPropertyCornerBottomRightShape = 405,
    CSSPropertyCornerTopLeftShape = 406,
    CSSPropertyCornerTopRightShape = 407,
    CSSPropertyHeight = 408,
    CSSPropertyLeft = 409,
    CSSPropertyMarginBottom = 410,
    CSSPropertyMarginLeft = 411,
    CSSPropertyMarginRight = 412,
    CSSPropertyMarginTop = 413,
    CSSPropertyMaxHeight = 414,
    CSSPropertyMaxWidth = 415,
    CSSPropertyMinHeight = 416,
    CSSPropertyMinWidth = 417,
    CSSPropertyOverflowX = 418,
    CSSPropertyOverflowY = 419,
    CSSPropertyOverscrollBehaviorX = 420,
    CSSPropertyOverscrollBehaviorY = 421,
    CSSPropertyPaddingBottom = 422,
    CSSPropertyPaddingLeft = 423,
    CSSPropertyPaddingRight = 424,
    CSSPropertyPaddingTop = 425,
    CSSPropertyRight = 426,
    CSSPropertyScrollMarginBottom = 427,
    CSSPropertyScrollMarginLeft = 428,
    CSSPropertyScrollMarginRight = 429,
    CSSPropertyScrollMarginTop = 430,
    CSSPropertyScrollPaddingBottom = 431,
    CSSPropertyScrollPaddingLeft = 432,
    CSSPropertyScrollPaddingRight = 433,
    CSSPropertyScrollPaddingTop = 434,
    CSSPropertyTop = 435,
    CSSPropertyWidth = 436,
    CSSPropertyBlockSize = 437,
    CSSPropertyBorderBlockEndColor = 438,
    CSSPropertyBorderBlockEndStyle = 439,
    CSSPropertyBorderBlockEndWidth = 440,
    CSSPropertyBorderBlockStartColor = 441,
    CSSPropertyBorderBlockStartStyle = 442,
    CSSPropertyBorderBlockStartWidth = 443,
    CSSPropertyBorderEndEndRadius = 444,
    CSSPropertyBorderEndStartRadius = 445,
    CSSPropertyBorderInlineEndColor = 446,
    CSSPropertyBorderInlineEndStyle = 447,
    CSSPropertyBorderInlineEndWidth = 448,
    CSSPropertyBorderInlineStartColor = 449,
    CSSPropertyBorderInlineStartStyle = 450,
    CSSPropertyBorderInlineStartWidth = 451,
    CSSPropertyBorderStartEndRadius = 452,
    CSSPropertyBorderStartStartRadius = 453,
    CSSPropertyContainIntrinsicBlockSize = 454,
    CSSPropertyContainIntrinsicInlineSize = 455,
    CSSPropertyCornerEndEndShape = 456,
    CSSPropertyCornerEndStartShape = 457,
    CSSPropertyCornerStartEndShape = 458,
    CSSPropertyCornerStartStartShape = 459,
    CSSPropertyInlineSize = 460,
    CSSPropertyInsetBlockEnd = 461,
    CSSPropertyInsetBlockStart = 462,
    CSSPropertyInsetInlineEnd = 463,
    CSSPropertyInsetInlineStart = 464,
    CSSPropertyMarginBlockEnd = 465,
    CSSPropertyMarginBlockStart = 466,
    CSSPropertyMarginInlineEnd = 467,
    CSSPropertyMarginInlineStart = 468,
    CSSPropertyMaxBlockSize = 469,
    CSSPropertyMaxInlineSize = 470,
    CSSPropertyMinBlockSize = 471,
    CSSPropertyMinInlineSize = 472,
    CSSPropertyOverflowBlock = 473,
    CSSPropertyOverflowInline = 474,
    CSSPropertyOverscrollBehaviorBlock = 475,
    CSSPropertyOverscrollBehaviorInline = 476,
    CSSPropertyPaddingBlockEnd = 477,
    CSSPropertyPaddingBlockStart = 478,
    CSSPropertyPaddingInlineEnd = 479,
    CSSPropertyPaddingInlineStart = 480,
    CSSPropertyScrollMarginBlockEnd = 481,
    CSSPropertyScrollMarginBlockStart = 482,
    CSSPropertyScrollMarginInlineEnd = 483,
    CSSPropertyScrollMarginInlineStart = 484,
    CSSPropertyScrollPaddingBlockEnd = 485,
    CSSPropertyScrollPaddingBlockStart = 486,
    CSSPropertyScrollPaddingInlineEnd = 487,
    CSSPropertyScrollPaddingInlineStart = 488,
    CSSPropertyAll = 489,
    CSSPropertyAnimation = 490,
    CSSPropertyAnimationRange = 491,
    CSSPropertyBackground = 492,
    CSSPropertyBackgroundPosition = 493,
    CSSPropertyBlockStep = 494,
    CSSPropertyBorder = 495,
    CSSPropertyBorderBlock = 496,
    CSSPropertyBorderBlockColor = 497,
    CSSPropertyBorderBlockEnd = 498,
    CSSPropertyBorderBlockStart = 499,
    CSSPropertyBorderBlockStyle = 500,
    CSSPropertyBorderBlockWidth = 501,
    CSSPropertyBorderBottom = 502,
    CSSPropertyBorderColor = 503,
    CSSPropertyBorderImage = 504,
    CSSPropertyBorderInline = 505,
    CSSPropertyBorderInlineColor = 506,
    CSSPropertyBorderInlineEnd = 507,
    CSSPropertyBorderInlineStart = 508,
    CSSPropertyBorderInlineStyle = 509,
    CSSPropertyBorderInlineWidth = 510,
    CSSPropertyBorderLeft = 511,
    CSSPropertyBorderRadius = 512,
    CSSPropertyBorderRight = 513,
    CSSPropertyBorderSpacing = 514,
    CSSPropertyBorderStyle = 515,
    CSSPropertyBorderTop = 516,
    CSSPropertyBorderWidth = 517,
    CSSPropertyColumnRule = 518,
    CSSPropertyColumns = 519,
    CSSPropertyContainIntrinsicSize = 520,
    CSSPropertyContainer = 521,
    CSSPropertyCornerShape = 522,
    CSSPropertyFlex = 523,
    CSSPropertyFlexFlow = 524,
    CSSPropertyFont = 525,
    CSSPropertyFontSynthesis = 526,
    CSSPropertyFontVariant = 527,
    CSSPropertyGap = 528,
    CSSPropertyGrid = 529,
    CSSPropertyGridArea = 530,
    CSSPropertyGridColumn = 531,
    CSSPropertyGridRow = 532,
    CSSPropertyGridTemplate = 533,
    CSSPropertyInset = 534,
    CSSPropertyInsetBlock = 535,
    CSSPropertyInsetInline = 536,
    CSSPropertyLineClamp = 537,
    CSSPropertyListStyle = 538,
    CSSPropertyMargin = 539,
    CSSPropertyMarginBlock = 540,
    CSSPropertyMarginInline = 541,
    CSSPropertyMarker = 542,
    CSSPropertyMask = 543,
    CSSPropertyMaskBorder = 544,
    CSSPropertyMaskPosition = 545,
    CSSPropertyOffset = 546,
    CSSPropertyOutline = 547,
    CSSPropertyOverflow = 548,
    CSSPropertyOverscrollBehavior = 549,
    CSSPropertyPadding = 550,
    CSSPropertyPaddingBlock = 551,
    CSSPropertyPaddingInline = 552,
    CSSPropertyPageBreakAfter = 553,
    CSSPropertyPageBreakBefore = 554,
    CSSPropertyPageBreakInside = 555,
    CSSPropertyPerspectiveOrigin = 556,
    CSSPropertyPlaceContent = 557,
    CSSPropertyPlaceItems = 558,
    CSSPropertyPlaceSelf = 559,
    CSSPropertyPositionTry = 560,
    CSSPropertyScrollMargin = 561,
    CSSPropertyScrollMarginBlock = 562,
    CSSPropertyScrollMarginInline = 563,
    CSSPropertyScrollPadding = 564,
    CSSPropertyScrollPaddingBlock = 565,
    CSSPropertyScrollPaddingInline = 566,
    CSSPropertyScrollTimeline = 567,
    CSSPropertyTextBox = 568,
    CSSPropertyTextDecoration = 569,
    CSSPropertyTextDecorationSkip = 570,
    CSSPropertyTextEmphasis = 571,
    CSSPropertyTextWrap = 572,
    CSSPropertyTransformOrigin = 573,
    CSSPropertyTransition = 574,
    CSSPropertyViewTimeline = 575,
    CSSPropertyWhiteSpace = 576,
    CSSPropertyWebkitBackgroundSize = 577,
    CSSPropertyWebkitBorderImage = 578,
    CSSPropertyWebkitBorderRadius = 579,
    CSSPropertyWebkitColumnBreakAfter = 580,
    CSSPropertyWebkitColumnBreakBefore = 581,
    CSSPropertyWebkitColumnBreakInside = 582,
    CSSPropertyWebkitMask = 583,
    CSSPropertyWebkitMaskBoxImage = 584,
    CSSPropertyWebkitMaskPosition = 585,
    CSSPropertyWebkitPerspective = 586,
    CSSPropertyWebkitTextOrientation = 587,
    CSSPropertyWebkitTextStroke = 588,
};

// Enum value of the first "real" CSS property, which excludes
// CSSPropertyInvalid and CSSPropertyCustom.
constexpr uint16_t firstCSSProperty = 2;
// Total number of enum values in the CSSPropertyID enum. If making an array
// that can be indexed into using the enum value, use this as the size.
constexpr uint16_t cssPropertyIDEnumValueCount = 589;
// Number of "real" CSS properties. This differs from cssPropertyIDEnumValueCount,
// as this doesn't consider CSSPropertyInvalid and CSSPropertyCustom.
constexpr uint16_t numCSSProperties = 587;
constexpr unsigned maxCSSPropertyNameLength = 34;
constexpr auto firstTopPriorityProperty = CSSPropertyID::CSSPropertyColorScheme;
constexpr auto lastTopPriorityProperty = CSSPropertyID::CSSPropertyWritingMode;
constexpr auto firstHighPriorityProperty = CSSPropertyID::CSSPropertyDirection;
constexpr auto lastHighPriorityProperty = CSSPropertyID::CSSPropertyWordSpacing;
constexpr auto firstMediumPriorityProperty = CSSPropertyID::CSSPropertyBackgroundImage;
constexpr auto lastMediumPriorityProperty = CSSPropertyID::CSSPropertyMaskImage;
constexpr auto firstLowPriorityProperty = CSSPropertyID::CSSPropertyAccentColor;
constexpr auto lastLowPriorityProperty = CSSPropertyID::CSSPropertyWebkitUserSelect;
constexpr auto firstLogicalGroupPhysicalProperty = CSSPropertyID::CSSPropertyBorderBottomColor;
constexpr auto lastLogicalGroupPhysicalProperty = CSSPropertyID::CSSPropertyWidth;
constexpr auto firstLogicalGroupLogicalProperty = CSSPropertyID::CSSPropertyBlockSize;
constexpr auto lastLogicalGroupLogicalProperty = CSSPropertyID::CSSPropertyScrollPaddingInlineStart;
constexpr auto firstLogicalGroupProperty = firstLogicalGroupPhysicalProperty;
constexpr auto lastLogicalGroupProperty = lastLogicalGroupLogicalProperty;
constexpr auto firstShorthandProperty = CSSPropertyID::CSSPropertyAll;
constexpr auto lastShorthandProperty = CSSPropertyID::CSSPropertyWebkitTextStroke;
constexpr uint16_t numCSSPropertyLonghands = firstShorthandProperty - firstCSSProperty;
extern const std::array<CSSPropertyID, 453> computedPropertyIDs;

struct CSSPropertySettings {
    WTF_DEPRECATED_MAKE_STRUCT_FAST_ALLOCATED(CSSPropertySettings);

    bool accentColorEnabled : 1 { false };
    bool colorFilterEnabled : 1 { false };
    bool crossDocumentViewTransitionsEnabled : 1 { false };
    bool cssAnchorPositioningEnabled : 1 { false };
    bool cssCornerShapeEnabled : 1 { false };
    bool cssDPropertyEnabled : 1 { false };
    bool cssFieldSizingEnabled : 1 { false };
    bool cssFontVariantEmojiEnabled : 1 { false };
    bool cssFunctionAtRuleEnabled : 1 { false };
    bool cssInputSecurityEnabled : 1 { false };
    bool cssLineClampEnabled : 1 { false };
    bool cssLineFitEdgeEnabled : 1 { false };
    bool cssRhythmicSizingEnabled : 1 { false };
    bool cssRubyAlignEnabled : 1 { false };
    bool cssRubyOverhangEnabled : 1 { false };
    bool cssScrollAnchoringEnabled : 1 { false };
    bool cssScrollbarColorEnabled : 1 { false };
    bool cssScrollbarGutterEnabled : 1 { false };
    bool cssScrollbarWidthEnabled : 1 { false };
    bool cssTextAutospaceEnabled : 1 { false };
    bool cssTextBoxTrimEnabled : 1 { false };
    bool cssTextGroupAlignEnabled : 1 { false };
    bool cssTextJustifyEnabled : 1 { false };
    bool cssTextSpacingTrimEnabled : 1 { false };
    bool cssUnprefixedBackdropFilterEnabled : 1 { false };
    bool overscrollBehaviorEnabled : 1 { false };
    bool scrollDrivenAnimationsEnabled : 1 { false };
    bool supportHDRDisplayEnabled : 1 { false };
    bool textAutosizingEnabled : 1 { false };
    bool useSystemAppearance : 1 { false };
    bool viewTransitionClassesEnabled : 1 { false };
    bool viewTransitionsEnabled : 1 { false };

    CSSPropertySettings() = default;
    explicit CSSPropertySettings(const Settings&);
};

bool operator==(const CSSPropertySettings&, const CSSPropertySettings&);
void add(Hasher&, const CSSPropertySettings&);

constexpr bool isLonghand(CSSPropertyID);
bool isInternal(CSSPropertyID);
bool isExposed(CSSPropertyID, const Settings*);
bool isExposed(CSSPropertyID, const Settings&);
bool isExposed(CSSPropertyID, const CSSPropertySettings*);
bool isExposed(CSSPropertyID, const CSSPropertySettings&);

CSSPropertyID findCSSProperty(const char* characters, unsigned length);
ASCIILiteral nameLiteral(CSSPropertyID);
const AtomString& nameString(CSSPropertyID);
String nameForIDL(CSSPropertyID);

CSSPropertyID cascadeAliasProperty(CSSPropertyID);

template<CSSPropertyID first, CSSPropertyID last> struct CSSPropertiesRange {
    struct Iterator {
        uint16_t index { static_cast<uint16_t>(first) };
        constexpr CSSPropertyID operator*() const { return static_cast<CSSPropertyID>(index); }
        constexpr Iterator& operator++() { ++index; return *this; }
        constexpr bool operator==(std::nullptr_t) const { return index > static_cast<uint16_t>(last); }
    };
    static constexpr Iterator begin() { return { }; }
    static constexpr std::nullptr_t end() { return nullptr; }
    static constexpr uint16_t size() { return last - first + 1; }
};
using AllCSSPropertiesRange = CSSPropertiesRange<static_cast<CSSPropertyID>(firstCSSProperty), lastShorthandProperty>;
using AllLonghandCSSPropertiesRange = CSSPropertiesRange<static_cast<CSSPropertyID>(firstCSSProperty), lastLogicalGroupProperty>;
constexpr AllCSSPropertiesRange allCSSProperties() { return { }; }
constexpr AllLonghandCSSPropertiesRange allLonghandCSSProperties() { return { }; }

constexpr bool isLonghand(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= firstCSSProperty
        && static_cast<uint16_t>(property) < static_cast<uint16_t>(firstShorthandProperty);
}
constexpr bool isShorthand(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= static_cast<uint16_t>(firstShorthandProperty)
        && static_cast<uint16_t>(property) <= static_cast<uint16_t>(lastShorthandProperty);
}

constexpr bool isLogicalPropertyGroupProperty(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= static_cast<uint16_t>(firstLogicalGroupPhysicalProperty)
        && static_cast<uint16_t>(property) <= static_cast<uint16_t>(lastLogicalGroupLogicalProperty);
}

constexpr bool isLogicalPropertyGroupPhysicalProperty(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= static_cast<uint16_t>(firstLogicalGroupPhysicalProperty)
        && static_cast<uint16_t>(property) <= static_cast<uint16_t>(lastLogicalGroupPhysicalProperty);
}

constexpr bool isLogicalPropertyGroupLogicalProperty(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= static_cast<uint16_t>(firstLogicalGroupLogicalProperty)
        && static_cast<uint16_t>(property) <= static_cast<uint16_t>(lastLogicalGroupLogicalProperty);
}

WTF::TextStream& operator<<(WTF::TextStream&, CSSPropertyID);

} // namespace WebCore

namespace WTF {

template<> struct DefaultHash<WebCore::CSSPropertyID> : IntHash<unsigned> { };

template<> struct HashTraits<WebCore::CSSPropertyID> : GenericHashTraits<WebCore::CSSPropertyID> {
    static const bool emptyValueIsZero = true;
    static void constructDeletedValue(WebCore::CSSPropertyID& slot) { slot = static_cast<WebCore::CSSPropertyID>(std::numeric_limits<uint16_t>::max()); }
    static bool isDeletedValue(WebCore::CSSPropertyID value) { return static_cast<uint16_t>(value) == std::numeric_limits<uint16_t>::max(); }
};

} // namespace WTF

namespace std {

template<> struct iterator_traits<WebCore::AllCSSPropertiesRange::Iterator> { using value_type = WebCore::CSSPropertyID; };
template<> struct iterator_traits<WebCore::AllLonghandCSSPropertiesRange::Iterator> { using value_type = WebCore::CSSPropertyID; };

} // namespace std

