/*
 * Copyright (c) 2015 Canon Inc. All rights reserved.
 * Copyright (c) 2015 Igalia.
 * Copyright (c) 2016 Apple Inc. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// DO NOT EDIT THIS FILE. It is automatically generated from JavaScript files for
// builtins by the script: Source/JavaScriptCore/Scripts/generate-js-builtins.py

#pragma once

#include <JavaScriptCore/BuiltinUtils.h>
#include <JavaScriptCore/Identifier.h>
#include <JavaScriptCore/JSFunction.h>
#include <JavaScriptCore/UnlinkedFunctionExecutable.h>

namespace JSC {
class FunctionExecutable;
}

namespace WebCore {

/* ReadableStreamInternals */
extern const char* const s_readableStreamInternalsCreateInternalReadableStreamFromUnderlyingSourceCode;
extern const int s_readableStreamInternalsCreateInternalReadableStreamFromUnderlyingSourceCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsCreateInternalReadableStreamFromUnderlyingSourceCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsCreateInternalReadableStreamFromUnderlyingSourceCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsCreateInternalReadableStreamFromUnderlyingSourceCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsCreateInternalReadableStreamFromUnderlyingSourceCodeInlineAttribute;
extern const char* const s_readableStreamInternalsReadableStreamCancelForBindingsCode;
extern const int s_readableStreamInternalsReadableStreamCancelForBindingsCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamCancelForBindingsCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamCancelForBindingsCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamCancelForBindingsCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsReadableStreamCancelForBindingsCodeInlineAttribute;
extern const char* const s_readableStreamInternalsReadableStreamPipeThroughForBindingsCode;
extern const int s_readableStreamInternalsReadableStreamPipeThroughForBindingsCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamPipeThroughForBindingsCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamPipeThroughForBindingsCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamPipeThroughForBindingsCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsReadableStreamPipeThroughForBindingsCodeInlineAttribute;
extern const char* const s_readableStreamInternalsReadableStreamPipeToForBindingsCode;
extern const int s_readableStreamInternalsReadableStreamPipeToForBindingsCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamPipeToForBindingsCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamPipeToForBindingsCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamPipeToForBindingsCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsReadableStreamPipeToForBindingsCodeInlineAttribute;
extern const char* const s_readableStreamInternalsCreateInternalReadableStreamDefaultReaderCode;
extern const int s_readableStreamInternalsCreateInternalReadableStreamDefaultReaderCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsCreateInternalReadableStreamDefaultReaderCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsCreateInternalReadableStreamDefaultReaderCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsCreateInternalReadableStreamDefaultReaderCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsCreateInternalReadableStreamDefaultReaderCodeInlineAttribute;
extern const char* const s_readableStreamInternalsReadableStreamDefaultReaderClosedForBindingsCode;
extern const int s_readableStreamInternalsReadableStreamDefaultReaderClosedForBindingsCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamDefaultReaderClosedForBindingsCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamDefaultReaderClosedForBindingsCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamDefaultReaderClosedForBindingsCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsReadableStreamDefaultReaderClosedForBindingsCodeInlineAttribute;
extern const char* const s_readableStreamInternalsReadableStreamDefaultReaderReadForBindingsCode;
extern const int s_readableStreamInternalsReadableStreamDefaultReaderReadForBindingsCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamDefaultReaderReadForBindingsCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamDefaultReaderReadForBindingsCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamDefaultReaderReadForBindingsCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsReadableStreamDefaultReaderReadForBindingsCodeInlineAttribute;
extern const char* const s_readableStreamInternalsReadableStreamDefaultReaderReleaseLockForBindingsCode;
extern const int s_readableStreamInternalsReadableStreamDefaultReaderReleaseLockForBindingsCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamDefaultReaderReleaseLockForBindingsCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamDefaultReaderReleaseLockForBindingsCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamDefaultReaderReleaseLockForBindingsCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsReadableStreamDefaultReaderReleaseLockForBindingsCodeInlineAttribute;
extern const char* const s_readableStreamInternalsReadableStreamDefaultReaderCancelForBindingsCode;
extern const int s_readableStreamInternalsReadableStreamDefaultReaderCancelForBindingsCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamDefaultReaderCancelForBindingsCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamDefaultReaderCancelForBindingsCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamDefaultReaderCancelForBindingsCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsReadableStreamDefaultReaderCancelForBindingsCodeInlineAttribute;
extern const char* const s_readableStreamInternalsReadableStreamDefaultReaderClosedPromiseCode;
extern const int s_readableStreamInternalsReadableStreamDefaultReaderClosedPromiseCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamDefaultReaderClosedPromiseCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamDefaultReaderClosedPromiseCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamDefaultReaderClosedPromiseCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsReadableStreamDefaultReaderClosedPromiseCodeInlineAttribute;
extern const char* const s_readableStreamInternalsReadableStreamReaderGenericInitializeCode;
extern const int s_readableStreamInternalsReadableStreamReaderGenericInitializeCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamReaderGenericInitializeCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamReaderGenericInitializeCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamReaderGenericInitializeCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsReadableStreamReaderGenericInitializeCodeInlineAttribute;
extern const char* const s_readableStreamInternalsPrivateInitializeReadableStreamDefaultControllerCode;
extern const int s_readableStreamInternalsPrivateInitializeReadableStreamDefaultControllerCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsPrivateInitializeReadableStreamDefaultControllerCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsPrivateInitializeReadableStreamDefaultControllerCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsPrivateInitializeReadableStreamDefaultControllerCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsPrivateInitializeReadableStreamDefaultControllerCodeInlineAttribute;
extern const char* const s_readableStreamInternalsSetupReadableStreamDefaultControllerCode;
extern const int s_readableStreamInternalsSetupReadableStreamDefaultControllerCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsSetupReadableStreamDefaultControllerCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsSetupReadableStreamDefaultControllerCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsSetupReadableStreamDefaultControllerCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsSetupReadableStreamDefaultControllerCodeInlineAttribute;
extern const char* const s_readableStreamInternalsReadableStreamDefaultControllerErrorCode;
extern const int s_readableStreamInternalsReadableStreamDefaultControllerErrorCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamDefaultControllerErrorCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamDefaultControllerErrorCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamDefaultControllerErrorCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsReadableStreamDefaultControllerErrorCodeInlineAttribute;
extern const char* const s_readableStreamInternalsReadableStreamPipeToCode;
extern const int s_readableStreamInternalsReadableStreamPipeToCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamPipeToCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamPipeToCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamPipeToCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsReadableStreamPipeToCodeInlineAttribute;
extern const char* const s_readableStreamInternalsAcquireReadableStreamDefaultReaderCode;
extern const int s_readableStreamInternalsAcquireReadableStreamDefaultReaderCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsAcquireReadableStreamDefaultReaderCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsAcquireReadableStreamDefaultReaderCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsAcquireReadableStreamDefaultReaderCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsAcquireReadableStreamDefaultReaderCodeInlineAttribute;
extern const char* const s_readableStreamInternalsReadableStreamPipeToWritableStreamCode;
extern const int s_readableStreamInternalsReadableStreamPipeToWritableStreamCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamPipeToWritableStreamCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamPipeToWritableStreamCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamPipeToWritableStreamCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsReadableStreamPipeToWritableStreamCodeInlineAttribute;
extern const char* const s_readableStreamInternalsPipeToLoopCode;
extern const int s_readableStreamInternalsPipeToLoopCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsPipeToLoopCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsPipeToLoopCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsPipeToLoopCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsPipeToLoopCodeInlineAttribute;
extern const char* const s_readableStreamInternalsPipeToDoReadWriteCode;
extern const int s_readableStreamInternalsPipeToDoReadWriteCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsPipeToDoReadWriteCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsPipeToDoReadWriteCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsPipeToDoReadWriteCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsPipeToDoReadWriteCodeInlineAttribute;
extern const char* const s_readableStreamInternalsPipeToErrorsMustBePropagatedForwardCode;
extern const int s_readableStreamInternalsPipeToErrorsMustBePropagatedForwardCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsPipeToErrorsMustBePropagatedForwardCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsPipeToErrorsMustBePropagatedForwardCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsPipeToErrorsMustBePropagatedForwardCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsPipeToErrorsMustBePropagatedForwardCodeInlineAttribute;
extern const char* const s_readableStreamInternalsPipeToErrorsMustBePropagatedBackwardCode;
extern const int s_readableStreamInternalsPipeToErrorsMustBePropagatedBackwardCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsPipeToErrorsMustBePropagatedBackwardCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsPipeToErrorsMustBePropagatedBackwardCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsPipeToErrorsMustBePropagatedBackwardCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsPipeToErrorsMustBePropagatedBackwardCodeInlineAttribute;
extern const char* const s_readableStreamInternalsPipeToClosingMustBePropagatedForwardCode;
extern const int s_readableStreamInternalsPipeToClosingMustBePropagatedForwardCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsPipeToClosingMustBePropagatedForwardCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsPipeToClosingMustBePropagatedForwardCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsPipeToClosingMustBePropagatedForwardCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsPipeToClosingMustBePropagatedForwardCodeInlineAttribute;
extern const char* const s_readableStreamInternalsPipeToClosingMustBePropagatedBackwardCode;
extern const int s_readableStreamInternalsPipeToClosingMustBePropagatedBackwardCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsPipeToClosingMustBePropagatedBackwardCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsPipeToClosingMustBePropagatedBackwardCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsPipeToClosingMustBePropagatedBackwardCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsPipeToClosingMustBePropagatedBackwardCodeInlineAttribute;
extern const char* const s_readableStreamInternalsPipeToShutdownWithActionCode;
extern const int s_readableStreamInternalsPipeToShutdownWithActionCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsPipeToShutdownWithActionCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsPipeToShutdownWithActionCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsPipeToShutdownWithActionCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsPipeToShutdownWithActionCodeInlineAttribute;
extern const char* const s_readableStreamInternalsPipeToShutdownCode;
extern const int s_readableStreamInternalsPipeToShutdownCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsPipeToShutdownCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsPipeToShutdownCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsPipeToShutdownCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsPipeToShutdownCodeInlineAttribute;
extern const char* const s_readableStreamInternalsPipeToFinalizeCode;
extern const int s_readableStreamInternalsPipeToFinalizeCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsPipeToFinalizeCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsPipeToFinalizeCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsPipeToFinalizeCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsPipeToFinalizeCodeInlineAttribute;
extern const char* const s_readableStreamInternalsReadableStreamTeeCode;
extern const int s_readableStreamInternalsReadableStreamTeeCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamTeeCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamTeeCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamTeeCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsReadableStreamTeeCodeInlineAttribute;
extern const char* const s_readableStreamInternalsReadableStreamTeePullFunctionCode;
extern const int s_readableStreamInternalsReadableStreamTeePullFunctionCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamTeePullFunctionCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamTeePullFunctionCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamTeePullFunctionCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsReadableStreamTeePullFunctionCodeInlineAttribute;
extern const char* const s_readableStreamInternalsReadableStreamTeeBranch1CancelFunctionCode;
extern const int s_readableStreamInternalsReadableStreamTeeBranch1CancelFunctionCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamTeeBranch1CancelFunctionCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamTeeBranch1CancelFunctionCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamTeeBranch1CancelFunctionCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsReadableStreamTeeBranch1CancelFunctionCodeInlineAttribute;
extern const char* const s_readableStreamInternalsReadableStreamTeeBranch2CancelFunctionCode;
extern const int s_readableStreamInternalsReadableStreamTeeBranch2CancelFunctionCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamTeeBranch2CancelFunctionCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamTeeBranch2CancelFunctionCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamTeeBranch2CancelFunctionCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsReadableStreamTeeBranch2CancelFunctionCodeInlineAttribute;
extern const char* const s_readableStreamInternalsIsReadableStreamCode;
extern const int s_readableStreamInternalsIsReadableStreamCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsIsReadableStreamCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsIsReadableStreamCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsIsReadableStreamCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsIsReadableStreamCodeInlineAttribute;
extern const char* const s_readableStreamInternalsIsReadableStreamDefaultReaderCode;
extern const int s_readableStreamInternalsIsReadableStreamDefaultReaderCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsIsReadableStreamDefaultReaderCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsIsReadableStreamDefaultReaderCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsIsReadableStreamDefaultReaderCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsIsReadableStreamDefaultReaderCodeInlineAttribute;
extern const char* const s_readableStreamInternalsIsReadableStreamDefaultControllerCode;
extern const int s_readableStreamInternalsIsReadableStreamDefaultControllerCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsIsReadableStreamDefaultControllerCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsIsReadableStreamDefaultControllerCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsIsReadableStreamDefaultControllerCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsIsReadableStreamDefaultControllerCodeInlineAttribute;
extern const char* const s_readableStreamInternalsReadableStreamErrorCode;
extern const int s_readableStreamInternalsReadableStreamErrorCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamErrorCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamErrorCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamErrorCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsReadableStreamErrorCodeInlineAttribute;
extern const char* const s_readableStreamInternalsReadableStreamDefaultControllerShouldCallPullCode;
extern const int s_readableStreamInternalsReadableStreamDefaultControllerShouldCallPullCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamDefaultControllerShouldCallPullCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamDefaultControllerShouldCallPullCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamDefaultControllerShouldCallPullCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsReadableStreamDefaultControllerShouldCallPullCodeInlineAttribute;
extern const char* const s_readableStreamInternalsReadableStreamDefaultControllerCallPullIfNeededCode;
extern const int s_readableStreamInternalsReadableStreamDefaultControllerCallPullIfNeededCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamDefaultControllerCallPullIfNeededCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamDefaultControllerCallPullIfNeededCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamDefaultControllerCallPullIfNeededCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsReadableStreamDefaultControllerCallPullIfNeededCodeInlineAttribute;
extern const char* const s_readableStreamInternalsIsReadableStreamLockedCode;
extern const int s_readableStreamInternalsIsReadableStreamLockedCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsIsReadableStreamLockedCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsIsReadableStreamLockedCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsIsReadableStreamLockedCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsIsReadableStreamLockedCodeInlineAttribute;
extern const char* const s_readableStreamInternalsReadableStreamDefaultControllerGetDesiredSizeCode;
extern const int s_readableStreamInternalsReadableStreamDefaultControllerGetDesiredSizeCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamDefaultControllerGetDesiredSizeCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamDefaultControllerGetDesiredSizeCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamDefaultControllerGetDesiredSizeCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsReadableStreamDefaultControllerGetDesiredSizeCodeInlineAttribute;
extern const char* const s_readableStreamInternalsReadableStreamReaderGenericCancelCode;
extern const int s_readableStreamInternalsReadableStreamReaderGenericCancelCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamReaderGenericCancelCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamReaderGenericCancelCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamReaderGenericCancelCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsReadableStreamReaderGenericCancelCodeInlineAttribute;
extern const char* const s_readableStreamInternalsReadableStreamCancelCode;
extern const int s_readableStreamInternalsReadableStreamCancelCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamCancelCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamCancelCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamCancelCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsReadableStreamCancelCodeInlineAttribute;
extern const char* const s_readableStreamInternalsReadableStreamDefaultControllerCancelCode;
extern const int s_readableStreamInternalsReadableStreamDefaultControllerCancelCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamDefaultControllerCancelCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamDefaultControllerCancelCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamDefaultControllerCancelCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsReadableStreamDefaultControllerCancelCodeInlineAttribute;
extern const char* const s_readableStreamInternalsReadableStreamDefaultControllerPullCode;
extern const int s_readableStreamInternalsReadableStreamDefaultControllerPullCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamDefaultControllerPullCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamDefaultControllerPullCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamDefaultControllerPullCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsReadableStreamDefaultControllerPullCodeInlineAttribute;
extern const char* const s_readableStreamInternalsReadableStreamDefaultControllerCloseCode;
extern const int s_readableStreamInternalsReadableStreamDefaultControllerCloseCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamDefaultControllerCloseCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamDefaultControllerCloseCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamDefaultControllerCloseCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsReadableStreamDefaultControllerCloseCodeInlineAttribute;
extern const char* const s_readableStreamInternalsReadableStreamCloseCode;
extern const int s_readableStreamInternalsReadableStreamCloseCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamCloseCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamCloseCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamCloseCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsReadableStreamCloseCodeInlineAttribute;
extern const char* const s_readableStreamInternalsReadableStreamFulfillReadRequestCode;
extern const int s_readableStreamInternalsReadableStreamFulfillReadRequestCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamFulfillReadRequestCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamFulfillReadRequestCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamFulfillReadRequestCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsReadableStreamFulfillReadRequestCodeInlineAttribute;
extern const char* const s_readableStreamInternalsReadableStreamDefaultControllerEnqueueCode;
extern const int s_readableStreamInternalsReadableStreamDefaultControllerEnqueueCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamDefaultControllerEnqueueCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamDefaultControllerEnqueueCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamDefaultControllerEnqueueCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsReadableStreamDefaultControllerEnqueueCodeInlineAttribute;
extern const char* const s_readableStreamInternalsReadableStreamDefaultReaderReadCode;
extern const int s_readableStreamInternalsReadableStreamDefaultReaderReadCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamDefaultReaderReadCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamDefaultReaderReadCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamDefaultReaderReadCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsReadableStreamDefaultReaderReadCodeInlineAttribute;
extern const char* const s_readableStreamInternalsReadableStreamAddReadRequestCode;
extern const int s_readableStreamInternalsReadableStreamAddReadRequestCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamAddReadRequestCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamAddReadRequestCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamAddReadRequestCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsReadableStreamAddReadRequestCodeInlineAttribute;
extern const char* const s_readableStreamInternalsIsReadableStreamDisturbedCode;
extern const int s_readableStreamInternalsIsReadableStreamDisturbedCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsIsReadableStreamDisturbedCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsIsReadableStreamDisturbedCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsIsReadableStreamDisturbedCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsIsReadableStreamDisturbedCodeInlineAttribute;
extern const char* const s_readableStreamInternalsReadableStreamDefaultReaderReleaseCode;
extern const int s_readableStreamInternalsReadableStreamDefaultReaderReleaseCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamDefaultReaderReleaseCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamDefaultReaderReleaseCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamDefaultReaderReleaseCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsReadableStreamDefaultReaderReleaseCodeInlineAttribute;
extern const char* const s_readableStreamInternalsReadableStreamReaderGenericReleaseCode;
extern const int s_readableStreamInternalsReadableStreamReaderGenericReleaseCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamReaderGenericReleaseCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamReaderGenericReleaseCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamReaderGenericReleaseCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsReadableStreamReaderGenericReleaseCodeInlineAttribute;
extern const char* const s_readableStreamInternalsReadableStreamDefaultReaderErrorReadRequestsCode;
extern const int s_readableStreamInternalsReadableStreamDefaultReaderErrorReadRequestsCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamDefaultReaderErrorReadRequestsCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamDefaultReaderErrorReadRequestsCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamDefaultReaderErrorReadRequestsCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsReadableStreamDefaultReaderErrorReadRequestsCodeInlineAttribute;
extern const char* const s_readableStreamInternalsReadableStreamDefaultControllerCanCloseOrEnqueueCode;
extern const int s_readableStreamInternalsReadableStreamDefaultControllerCanCloseOrEnqueueCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamDefaultControllerCanCloseOrEnqueueCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamDefaultControllerCanCloseOrEnqueueCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamDefaultControllerCanCloseOrEnqueueCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsReadableStreamDefaultControllerCanCloseOrEnqueueCodeInlineAttribute;
extern const char* const s_readableStreamInternalsReadableStreamStateCode;
extern const int s_readableStreamInternalsReadableStreamStateCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamStateCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamStateCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamStateCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsReadableStreamStateCodeInlineAttribute;
extern const char* const s_readableStreamInternalsReadableStreamStoredErrorCode;
extern const int s_readableStreamInternalsReadableStreamStoredErrorCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamStoredErrorCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamStoredErrorCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamStoredErrorCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableStreamInternalsReadableStreamStoredErrorCodeInlineAttribute;

#define WEBCORE_FOREACH_READABLESTREAMINTERNALS_BUILTIN_DATA(macro) \
    macro(createInternalReadableStreamFromUnderlyingSource, readableStreamInternalsCreateInternalReadableStreamFromUnderlyingSource, 2) \
    macro(readableStreamCancelForBindings, readableStreamInternalsReadableStreamCancelForBindings, 2) \
    macro(readableStreamPipeThroughForBindings, readableStreamInternalsReadableStreamPipeThroughForBindings, 3) \
    macro(readableStreamPipeToForBindings, readableStreamInternalsReadableStreamPipeToForBindings, 3) \
    macro(createInternalReadableStreamDefaultReader, readableStreamInternalsCreateInternalReadableStreamDefaultReader, 1) \
    macro(readableStreamDefaultReaderClosedForBindings, readableStreamInternalsReadableStreamDefaultReaderClosedForBindings, 1) \
    macro(readableStreamDefaultReaderReadForBindings, readableStreamInternalsReadableStreamDefaultReaderReadForBindings, 1) \
    macro(readableStreamDefaultReaderReleaseLockForBindings, readableStreamInternalsReadableStreamDefaultReaderReleaseLockForBindings, 1) \
    macro(readableStreamDefaultReaderCancelForBindings, readableStreamInternalsReadableStreamDefaultReaderCancelForBindings, 2) \
    macro(readableStreamDefaultReaderClosedPromise, readableStreamInternalsReadableStreamDefaultReaderClosedPromise, 1) \
    macro(readableStreamReaderGenericInitialize, readableStreamInternalsReadableStreamReaderGenericInitialize, 2) \
    macro(privateInitializeReadableStreamDefaultController, readableStreamInternalsPrivateInitializeReadableStreamDefaultController, 4) \
    macro(setupReadableStreamDefaultController, readableStreamInternalsSetupReadableStreamDefaultController, 7) \
    macro(readableStreamDefaultControllerError, readableStreamInternalsReadableStreamDefaultControllerError, 2) \
    macro(readableStreamPipeTo, readableStreamInternalsReadableStreamPipeTo, 2) \
    macro(acquireReadableStreamDefaultReader, readableStreamInternalsAcquireReadableStreamDefaultReader, 1) \
    macro(readableStreamPipeToWritableStream, readableStreamInternalsReadableStreamPipeToWritableStream, 6) \
    macro(pipeToLoop, readableStreamInternalsPipeToLoop, 1) \
    macro(pipeToDoReadWrite, readableStreamInternalsPipeToDoReadWrite, 1) \
    macro(pipeToErrorsMustBePropagatedForward, readableStreamInternalsPipeToErrorsMustBePropagatedForward, 1) \
    macro(pipeToErrorsMustBePropagatedBackward, readableStreamInternalsPipeToErrorsMustBePropagatedBackward, 1) \
    macro(pipeToClosingMustBePropagatedForward, readableStreamInternalsPipeToClosingMustBePropagatedForward, 1) \
    macro(pipeToClosingMustBePropagatedBackward, readableStreamInternalsPipeToClosingMustBePropagatedBackward, 1) \
    macro(pipeToShutdownWithAction, readableStreamInternalsPipeToShutdownWithAction, 2) \
    macro(pipeToShutdown, readableStreamInternalsPipeToShutdown, 1) \
    macro(pipeToFinalize, readableStreamInternalsPipeToFinalize, 1) \
    macro(readableStreamTee, readableStreamInternalsReadableStreamTee, 2) \
    macro(readableStreamTeePullFunction, readableStreamInternalsReadableStreamTeePullFunction, 3) \
    macro(readableStreamTeeBranch1CancelFunction, readableStreamInternalsReadableStreamTeeBranch1CancelFunction, 2) \
    macro(readableStreamTeeBranch2CancelFunction, readableStreamInternalsReadableStreamTeeBranch2CancelFunction, 2) \
    macro(isReadableStream, readableStreamInternalsIsReadableStream, 1) \
    macro(isReadableStreamDefaultReader, readableStreamInternalsIsReadableStreamDefaultReader, 1) \
    macro(isReadableStreamDefaultController, readableStreamInternalsIsReadableStreamDefaultController, 1) \
    macro(readableStreamError, readableStreamInternalsReadableStreamError, 2) \
    macro(readableStreamDefaultControllerShouldCallPull, readableStreamInternalsReadableStreamDefaultControllerShouldCallPull, 1) \
    macro(readableStreamDefaultControllerCallPullIfNeeded, readableStreamInternalsReadableStreamDefaultControllerCallPullIfNeeded, 1) \
    macro(isReadableStreamLocked, readableStreamInternalsIsReadableStreamLocked, 1) \
    macro(readableStreamDefaultControllerGetDesiredSize, readableStreamInternalsReadableStreamDefaultControllerGetDesiredSize, 1) \
    macro(readableStreamReaderGenericCancel, readableStreamInternalsReadableStreamReaderGenericCancel, 2) \
    macro(readableStreamCancel, readableStreamInternalsReadableStreamCancel, 2) \
    macro(readableStreamDefaultControllerCancel, readableStreamInternalsReadableStreamDefaultControllerCancel, 2) \
    macro(readableStreamDefaultControllerPull, readableStreamInternalsReadableStreamDefaultControllerPull, 1) \
    macro(readableStreamDefaultControllerClose, readableStreamInternalsReadableStreamDefaultControllerClose, 1) \
    macro(readableStreamClose, readableStreamInternalsReadableStreamClose, 1) \
    macro(readableStreamFulfillReadRequest, readableStreamInternalsReadableStreamFulfillReadRequest, 3) \
    macro(readableStreamDefaultControllerEnqueue, readableStreamInternalsReadableStreamDefaultControllerEnqueue, 2) \
    macro(readableStreamDefaultReaderRead, readableStreamInternalsReadableStreamDefaultReaderRead, 1) \
    macro(readableStreamAddReadRequest, readableStreamInternalsReadableStreamAddReadRequest, 1) \
    macro(isReadableStreamDisturbed, readableStreamInternalsIsReadableStreamDisturbed, 1) \
    macro(readableStreamDefaultReaderRelease, readableStreamInternalsReadableStreamDefaultReaderRelease, 1) \
    macro(readableStreamReaderGenericRelease, readableStreamInternalsReadableStreamReaderGenericRelease, 1) \
    macro(readableStreamDefaultReaderErrorReadRequests, readableStreamInternalsReadableStreamDefaultReaderErrorReadRequests, 2) \
    macro(readableStreamDefaultControllerCanCloseOrEnqueue, readableStreamInternalsReadableStreamDefaultControllerCanCloseOrEnqueue, 1) \
    macro(readableStreamState, readableStreamInternalsReadableStreamState, 1) \
    macro(readableStreamStoredError, readableStreamInternalsReadableStreamStoredError, 1) \

#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_CREATEINTERNALREADABLESTREAMFROMUNDERLYINGSOURCE 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMCANCELFORBINDINGS 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMPIPETHROUGHFORBINDINGS 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMPIPETOFORBINDINGS 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_CREATEINTERNALREADABLESTREAMDEFAULTREADER 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMDEFAULTREADERCLOSEDFORBINDINGS 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMDEFAULTREADERREADFORBINDINGS 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMDEFAULTREADERRELEASELOCKFORBINDINGS 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMDEFAULTREADERCANCELFORBINDINGS 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMDEFAULTREADERCLOSEDPROMISE 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMREADERGENERICINITIALIZE 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_PRIVATEINITIALIZEREADABLESTREAMDEFAULTCONTROLLER 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_SETUPREADABLESTREAMDEFAULTCONTROLLER 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMDEFAULTCONTROLLERERROR 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMPIPETO 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_ACQUIREREADABLESTREAMDEFAULTREADER 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMPIPETOWRITABLESTREAM 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_PIPETOLOOP 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_PIPETODOREADWRITE 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_PIPETOERRORSMUSTBEPROPAGATEDFORWARD 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_PIPETOERRORSMUSTBEPROPAGATEDBACKWARD 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_PIPETOCLOSINGMUSTBEPROPAGATEDFORWARD 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_PIPETOCLOSINGMUSTBEPROPAGATEDBACKWARD 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_PIPETOSHUTDOWNWITHACTION 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_PIPETOSHUTDOWN 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_PIPETOFINALIZE 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMTEE 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMTEEPULLFUNCTION 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMTEEBRANCH1CANCELFUNCTION 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMTEEBRANCH2CANCELFUNCTION 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_ISREADABLESTREAM 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_ISREADABLESTREAMDEFAULTREADER 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_ISREADABLESTREAMDEFAULTCONTROLLER 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMERROR 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMDEFAULTCONTROLLERSHOULDCALLPULL 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMDEFAULTCONTROLLERCALLPULLIFNEEDED 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_ISREADABLESTREAMLOCKED 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMDEFAULTCONTROLLERGETDESIREDSIZE 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMREADERGENERICCANCEL 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMCANCEL 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMDEFAULTCONTROLLERCANCEL 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMDEFAULTCONTROLLERPULL 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMDEFAULTCONTROLLERCLOSE 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMCLOSE 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMFULFILLREADREQUEST 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMDEFAULTCONTROLLERENQUEUE 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMDEFAULTREADERREAD 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMADDREADREQUEST 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_ISREADABLESTREAMDISTURBED 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMDEFAULTREADERRELEASE 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMREADERGENERICRELEASE 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMDEFAULTREADERERRORREADREQUESTS 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMDEFAULTCONTROLLERCANCLOSEORENQUEUE 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMSTATE 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMSTOREDERROR 1

#define WEBCORE_FOREACH_READABLESTREAMINTERNALS_BUILTIN_CODE(macro) \
    macro(readableStreamInternalsCreateInternalReadableStreamFromUnderlyingSourceCode, createInternalReadableStreamFromUnderlyingSource, ASCIILiteral(), s_readableStreamInternalsCreateInternalReadableStreamFromUnderlyingSourceCodeLength) \
    macro(readableStreamInternalsReadableStreamCancelForBindingsCode, readableStreamCancelForBindings, ASCIILiteral(), s_readableStreamInternalsReadableStreamCancelForBindingsCodeLength) \
    macro(readableStreamInternalsReadableStreamPipeThroughForBindingsCode, readableStreamPipeThroughForBindings, ASCIILiteral(), s_readableStreamInternalsReadableStreamPipeThroughForBindingsCodeLength) \
    macro(readableStreamInternalsReadableStreamPipeToForBindingsCode, readableStreamPipeToForBindings, ASCIILiteral(), s_readableStreamInternalsReadableStreamPipeToForBindingsCodeLength) \
    macro(readableStreamInternalsCreateInternalReadableStreamDefaultReaderCode, createInternalReadableStreamDefaultReader, ASCIILiteral(), s_readableStreamInternalsCreateInternalReadableStreamDefaultReaderCodeLength) \
    macro(readableStreamInternalsReadableStreamDefaultReaderClosedForBindingsCode, readableStreamDefaultReaderClosedForBindings, ASCIILiteral(), s_readableStreamInternalsReadableStreamDefaultReaderClosedForBindingsCodeLength) \
    macro(readableStreamInternalsReadableStreamDefaultReaderReadForBindingsCode, readableStreamDefaultReaderReadForBindings, ASCIILiteral(), s_readableStreamInternalsReadableStreamDefaultReaderReadForBindingsCodeLength) \
    macro(readableStreamInternalsReadableStreamDefaultReaderReleaseLockForBindingsCode, readableStreamDefaultReaderReleaseLockForBindings, ASCIILiteral(), s_readableStreamInternalsReadableStreamDefaultReaderReleaseLockForBindingsCodeLength) \
    macro(readableStreamInternalsReadableStreamDefaultReaderCancelForBindingsCode, readableStreamDefaultReaderCancelForBindings, ASCIILiteral(), s_readableStreamInternalsReadableStreamDefaultReaderCancelForBindingsCodeLength) \
    macro(readableStreamInternalsReadableStreamDefaultReaderClosedPromiseCode, readableStreamDefaultReaderClosedPromise, ASCIILiteral(), s_readableStreamInternalsReadableStreamDefaultReaderClosedPromiseCodeLength) \
    macro(readableStreamInternalsReadableStreamReaderGenericInitializeCode, readableStreamReaderGenericInitialize, ASCIILiteral(), s_readableStreamInternalsReadableStreamReaderGenericInitializeCodeLength) \
    macro(readableStreamInternalsPrivateInitializeReadableStreamDefaultControllerCode, privateInitializeReadableStreamDefaultController, ASCIILiteral(), s_readableStreamInternalsPrivateInitializeReadableStreamDefaultControllerCodeLength) \
    macro(readableStreamInternalsSetupReadableStreamDefaultControllerCode, setupReadableStreamDefaultController, ASCIILiteral(), s_readableStreamInternalsSetupReadableStreamDefaultControllerCodeLength) \
    macro(readableStreamInternalsReadableStreamDefaultControllerErrorCode, readableStreamDefaultControllerError, ASCIILiteral(), s_readableStreamInternalsReadableStreamDefaultControllerErrorCodeLength) \
    macro(readableStreamInternalsReadableStreamPipeToCode, readableStreamPipeTo, ASCIILiteral(), s_readableStreamInternalsReadableStreamPipeToCodeLength) \
    macro(readableStreamInternalsAcquireReadableStreamDefaultReaderCode, acquireReadableStreamDefaultReader, ASCIILiteral(), s_readableStreamInternalsAcquireReadableStreamDefaultReaderCodeLength) \
    macro(readableStreamInternalsReadableStreamPipeToWritableStreamCode, readableStreamPipeToWritableStream, ASCIILiteral(), s_readableStreamInternalsReadableStreamPipeToWritableStreamCodeLength) \
    macro(readableStreamInternalsPipeToLoopCode, pipeToLoop, ASCIILiteral(), s_readableStreamInternalsPipeToLoopCodeLength) \
    macro(readableStreamInternalsPipeToDoReadWriteCode, pipeToDoReadWrite, ASCIILiteral(), s_readableStreamInternalsPipeToDoReadWriteCodeLength) \
    macro(readableStreamInternalsPipeToErrorsMustBePropagatedForwardCode, pipeToErrorsMustBePropagatedForward, ASCIILiteral(), s_readableStreamInternalsPipeToErrorsMustBePropagatedForwardCodeLength) \
    macro(readableStreamInternalsPipeToErrorsMustBePropagatedBackwardCode, pipeToErrorsMustBePropagatedBackward, ASCIILiteral(), s_readableStreamInternalsPipeToErrorsMustBePropagatedBackwardCodeLength) \
    macro(readableStreamInternalsPipeToClosingMustBePropagatedForwardCode, pipeToClosingMustBePropagatedForward, ASCIILiteral(), s_readableStreamInternalsPipeToClosingMustBePropagatedForwardCodeLength) \
    macro(readableStreamInternalsPipeToClosingMustBePropagatedBackwardCode, pipeToClosingMustBePropagatedBackward, ASCIILiteral(), s_readableStreamInternalsPipeToClosingMustBePropagatedBackwardCodeLength) \
    macro(readableStreamInternalsPipeToShutdownWithActionCode, pipeToShutdownWithAction, ASCIILiteral(), s_readableStreamInternalsPipeToShutdownWithActionCodeLength) \
    macro(readableStreamInternalsPipeToShutdownCode, pipeToShutdown, ASCIILiteral(), s_readableStreamInternalsPipeToShutdownCodeLength) \
    macro(readableStreamInternalsPipeToFinalizeCode, pipeToFinalize, ASCIILiteral(), s_readableStreamInternalsPipeToFinalizeCodeLength) \
    macro(readableStreamInternalsReadableStreamTeeCode, readableStreamTee, ASCIILiteral(), s_readableStreamInternalsReadableStreamTeeCodeLength) \
    macro(readableStreamInternalsReadableStreamTeePullFunctionCode, readableStreamTeePullFunction, ASCIILiteral(), s_readableStreamInternalsReadableStreamTeePullFunctionCodeLength) \
    macro(readableStreamInternalsReadableStreamTeeBranch1CancelFunctionCode, readableStreamTeeBranch1CancelFunction, ASCIILiteral(), s_readableStreamInternalsReadableStreamTeeBranch1CancelFunctionCodeLength) \
    macro(readableStreamInternalsReadableStreamTeeBranch2CancelFunctionCode, readableStreamTeeBranch2CancelFunction, ASCIILiteral(), s_readableStreamInternalsReadableStreamTeeBranch2CancelFunctionCodeLength) \
    macro(readableStreamInternalsIsReadableStreamCode, isReadableStream, ASCIILiteral(), s_readableStreamInternalsIsReadableStreamCodeLength) \
    macro(readableStreamInternalsIsReadableStreamDefaultReaderCode, isReadableStreamDefaultReader, ASCIILiteral(), s_readableStreamInternalsIsReadableStreamDefaultReaderCodeLength) \
    macro(readableStreamInternalsIsReadableStreamDefaultControllerCode, isReadableStreamDefaultController, ASCIILiteral(), s_readableStreamInternalsIsReadableStreamDefaultControllerCodeLength) \
    macro(readableStreamInternalsReadableStreamErrorCode, readableStreamError, ASCIILiteral(), s_readableStreamInternalsReadableStreamErrorCodeLength) \
    macro(readableStreamInternalsReadableStreamDefaultControllerShouldCallPullCode, readableStreamDefaultControllerShouldCallPull, ASCIILiteral(), s_readableStreamInternalsReadableStreamDefaultControllerShouldCallPullCodeLength) \
    macro(readableStreamInternalsReadableStreamDefaultControllerCallPullIfNeededCode, readableStreamDefaultControllerCallPullIfNeeded, ASCIILiteral(), s_readableStreamInternalsReadableStreamDefaultControllerCallPullIfNeededCodeLength) \
    macro(readableStreamInternalsIsReadableStreamLockedCode, isReadableStreamLocked, ASCIILiteral(), s_readableStreamInternalsIsReadableStreamLockedCodeLength) \
    macro(readableStreamInternalsReadableStreamDefaultControllerGetDesiredSizeCode, readableStreamDefaultControllerGetDesiredSize, ASCIILiteral(), s_readableStreamInternalsReadableStreamDefaultControllerGetDesiredSizeCodeLength) \
    macro(readableStreamInternalsReadableStreamReaderGenericCancelCode, readableStreamReaderGenericCancel, ASCIILiteral(), s_readableStreamInternalsReadableStreamReaderGenericCancelCodeLength) \
    macro(readableStreamInternalsReadableStreamCancelCode, readableStreamCancel, ASCIILiteral(), s_readableStreamInternalsReadableStreamCancelCodeLength) \
    macro(readableStreamInternalsReadableStreamDefaultControllerCancelCode, readableStreamDefaultControllerCancel, ASCIILiteral(), s_readableStreamInternalsReadableStreamDefaultControllerCancelCodeLength) \
    macro(readableStreamInternalsReadableStreamDefaultControllerPullCode, readableStreamDefaultControllerPull, ASCIILiteral(), s_readableStreamInternalsReadableStreamDefaultControllerPullCodeLength) \
    macro(readableStreamInternalsReadableStreamDefaultControllerCloseCode, readableStreamDefaultControllerClose, ASCIILiteral(), s_readableStreamInternalsReadableStreamDefaultControllerCloseCodeLength) \
    macro(readableStreamInternalsReadableStreamCloseCode, readableStreamClose, ASCIILiteral(), s_readableStreamInternalsReadableStreamCloseCodeLength) \
    macro(readableStreamInternalsReadableStreamFulfillReadRequestCode, readableStreamFulfillReadRequest, ASCIILiteral(), s_readableStreamInternalsReadableStreamFulfillReadRequestCodeLength) \
    macro(readableStreamInternalsReadableStreamDefaultControllerEnqueueCode, readableStreamDefaultControllerEnqueue, ASCIILiteral(), s_readableStreamInternalsReadableStreamDefaultControllerEnqueueCodeLength) \
    macro(readableStreamInternalsReadableStreamDefaultReaderReadCode, readableStreamDefaultReaderRead, ASCIILiteral(), s_readableStreamInternalsReadableStreamDefaultReaderReadCodeLength) \
    macro(readableStreamInternalsReadableStreamAddReadRequestCode, readableStreamAddReadRequest, ASCIILiteral(), s_readableStreamInternalsReadableStreamAddReadRequestCodeLength) \
    macro(readableStreamInternalsIsReadableStreamDisturbedCode, isReadableStreamDisturbed, ASCIILiteral(), s_readableStreamInternalsIsReadableStreamDisturbedCodeLength) \
    macro(readableStreamInternalsReadableStreamDefaultReaderReleaseCode, readableStreamDefaultReaderRelease, ASCIILiteral(), s_readableStreamInternalsReadableStreamDefaultReaderReleaseCodeLength) \
    macro(readableStreamInternalsReadableStreamReaderGenericReleaseCode, readableStreamReaderGenericRelease, ASCIILiteral(), s_readableStreamInternalsReadableStreamReaderGenericReleaseCodeLength) \
    macro(readableStreamInternalsReadableStreamDefaultReaderErrorReadRequestsCode, readableStreamDefaultReaderErrorReadRequests, ASCIILiteral(), s_readableStreamInternalsReadableStreamDefaultReaderErrorReadRequestsCodeLength) \
    macro(readableStreamInternalsReadableStreamDefaultControllerCanCloseOrEnqueueCode, readableStreamDefaultControllerCanCloseOrEnqueue, ASCIILiteral(), s_readableStreamInternalsReadableStreamDefaultControllerCanCloseOrEnqueueCodeLength) \
    macro(readableStreamInternalsReadableStreamStateCode, readableStreamState, ASCIILiteral(), s_readableStreamInternalsReadableStreamStateCodeLength) \
    macro(readableStreamInternalsReadableStreamStoredErrorCode, readableStreamStoredError, ASCIILiteral(), s_readableStreamInternalsReadableStreamStoredErrorCodeLength) \

#define WEBCORE_FOREACH_READABLESTREAMINTERNALS_BUILTIN_FUNCTION_NAME(macro) \
    macro(acquireReadableStreamDefaultReader) \
    macro(createInternalReadableStreamDefaultReader) \
    macro(createInternalReadableStreamFromUnderlyingSource) \
    macro(isReadableStream) \
    macro(isReadableStreamDefaultController) \
    macro(isReadableStreamDefaultReader) \
    macro(isReadableStreamDisturbed) \
    macro(isReadableStreamLocked) \
    macro(pipeToClosingMustBePropagatedBackward) \
    macro(pipeToClosingMustBePropagatedForward) \
    macro(pipeToDoReadWrite) \
    macro(pipeToErrorsMustBePropagatedBackward) \
    macro(pipeToErrorsMustBePropagatedForward) \
    macro(pipeToFinalize) \
    macro(pipeToLoop) \
    macro(pipeToShutdown) \
    macro(pipeToShutdownWithAction) \
    macro(privateInitializeReadableStreamDefaultController) \
    macro(readableStreamAddReadRequest) \
    macro(readableStreamCancel) \
    macro(readableStreamCancelForBindings) \
    macro(readableStreamClose) \
    macro(readableStreamDefaultControllerCallPullIfNeeded) \
    macro(readableStreamDefaultControllerCanCloseOrEnqueue) \
    macro(readableStreamDefaultControllerCancel) \
    macro(readableStreamDefaultControllerClose) \
    macro(readableStreamDefaultControllerEnqueue) \
    macro(readableStreamDefaultControllerError) \
    macro(readableStreamDefaultControllerGetDesiredSize) \
    macro(readableStreamDefaultControllerPull) \
    macro(readableStreamDefaultControllerShouldCallPull) \
    macro(readableStreamDefaultReaderCancelForBindings) \
    macro(readableStreamDefaultReaderClosedForBindings) \
    macro(readableStreamDefaultReaderClosedPromise) \
    macro(readableStreamDefaultReaderErrorReadRequests) \
    macro(readableStreamDefaultReaderRead) \
    macro(readableStreamDefaultReaderReadForBindings) \
    macro(readableStreamDefaultReaderRelease) \
    macro(readableStreamDefaultReaderReleaseLockForBindings) \
    macro(readableStreamError) \
    macro(readableStreamFulfillReadRequest) \
    macro(readableStreamPipeThroughForBindings) \
    macro(readableStreamPipeTo) \
    macro(readableStreamPipeToForBindings) \
    macro(readableStreamPipeToWritableStream) \
    macro(readableStreamReaderGenericCancel) \
    macro(readableStreamReaderGenericInitialize) \
    macro(readableStreamReaderGenericRelease) \
    macro(readableStreamState) \
    macro(readableStreamStoredError) \
    macro(readableStreamTee) \
    macro(readableStreamTeeBranch1CancelFunction) \
    macro(readableStreamTeeBranch2CancelFunction) \
    macro(readableStreamTeePullFunction) \
    macro(setupReadableStreamDefaultController) \

#define DECLARE_BUILTIN_GENERATOR(codeName, functionName, overriddenName, argumentCount) \
    JSC::FunctionExecutable* codeName##Generator(JSC::VM&);

WEBCORE_FOREACH_READABLESTREAMINTERNALS_BUILTIN_CODE(DECLARE_BUILTIN_GENERATOR)
#undef DECLARE_BUILTIN_GENERATOR

class ReadableStreamInternalsBuiltinsWrapper : private JSC::WeakHandleOwner {
public:
    explicit ReadableStreamInternalsBuiltinsWrapper(JSC::VM& vm)
        : m_vm(vm)
        WEBCORE_FOREACH_READABLESTREAMINTERNALS_BUILTIN_FUNCTION_NAME(INITIALIZE_BUILTIN_NAMES)
#define INITIALIZE_BUILTIN_SOURCE_MEMBERS(name, functionName, overriddenName, length) , m_##name##Source(JSC::makeSource(StringImpl::createWithoutCopying(unsafeMakeSpan(s_##name, static_cast<size_t>(length))), { }, JSC::SourceTaintedOrigin::Untainted))
        WEBCORE_FOREACH_READABLESTREAMINTERNALS_BUILTIN_CODE(INITIALIZE_BUILTIN_SOURCE_MEMBERS)
#undef INITIALIZE_BUILTIN_SOURCE_MEMBERS
    {
    }

#define EXPOSE_BUILTIN_EXECUTABLES(name, functionName, overriddenName, length) \
    JSC::UnlinkedFunctionExecutable* name##Executable(); \
    const JSC::SourceCode& name##Source() const { return m_##name##Source; }
    WEBCORE_FOREACH_READABLESTREAMINTERNALS_BUILTIN_CODE(EXPOSE_BUILTIN_EXECUTABLES)
#undef EXPOSE_BUILTIN_EXECUTABLES

    WEBCORE_FOREACH_READABLESTREAMINTERNALS_BUILTIN_FUNCTION_NAME(DECLARE_BUILTIN_IDENTIFIER_ACCESSOR)

    void exportNames();

private:
    JSC::VM& m_vm;

    WEBCORE_FOREACH_READABLESTREAMINTERNALS_BUILTIN_FUNCTION_NAME(DECLARE_BUILTIN_NAMES)

#define DECLARE_BUILTIN_SOURCE_MEMBERS(name, functionName, overriddenName, length) \
    JSC::SourceCode m_##name##Source;\
    JSC::Weak<JSC::UnlinkedFunctionExecutable> m_##name##Executable;
    WEBCORE_FOREACH_READABLESTREAMINTERNALS_BUILTIN_CODE(DECLARE_BUILTIN_SOURCE_MEMBERS)
#undef DECLARE_BUILTIN_SOURCE_MEMBERS

};

#define DEFINE_BUILTIN_EXECUTABLES(name, functionName, overriddenName, length) \
inline JSC::UnlinkedFunctionExecutable* ReadableStreamInternalsBuiltinsWrapper::name##Executable() \
{\
    if (!m_##name##Executable) {\
        JSC::Identifier executableName = functionName##PublicName();\
        if (overriddenName)\
            executableName = JSC::Identifier::fromString(m_vm, overriddenName);\
        m_##name##Executable = JSC::Weak<JSC::UnlinkedFunctionExecutable>(JSC::createBuiltinExecutable(m_vm, m_##name##Source, executableName, s_##name##ImplementationVisibility, s_##name##ConstructorKind, s_##name##ConstructAbility, s_##name##InlineAttribute), this, &m_##name##Executable);\
    }\
    return m_##name##Executable.get();\
}
WEBCORE_FOREACH_READABLESTREAMINTERNALS_BUILTIN_CODE(DEFINE_BUILTIN_EXECUTABLES)
#undef DEFINE_BUILTIN_EXECUTABLES

inline void ReadableStreamInternalsBuiltinsWrapper::exportNames()
{
#define EXPORT_FUNCTION_NAME(name) m_vm.propertyNames->appendExternalName(name##PublicName(), name##PrivateName());
    WEBCORE_FOREACH_READABLESTREAMINTERNALS_BUILTIN_FUNCTION_NAME(EXPORT_FUNCTION_NAME)
#undef EXPORT_FUNCTION_NAME
}

class ReadableStreamInternalsBuiltinFunctions {
public:
    explicit ReadableStreamInternalsBuiltinFunctions(JSC::VM& vm) : m_vm(vm) { }

    void init(JSC::JSGlobalObject&);
    template<typename Visitor> void visit(Visitor&);

public:
    JSC::VM& m_vm;

#define DECLARE_BUILTIN_SOURCE_MEMBERS(functionName) \
    JSC::WriteBarrier<JSC::JSFunction> m_##functionName##Function;
    WEBCORE_FOREACH_READABLESTREAMINTERNALS_BUILTIN_FUNCTION_NAME(DECLARE_BUILTIN_SOURCE_MEMBERS)
#undef DECLARE_BUILTIN_SOURCE_MEMBERS
};

inline void ReadableStreamInternalsBuiltinFunctions::init(JSC::JSGlobalObject& globalObject)
{
#define EXPORT_FUNCTION(codeName, functionName, overriddenName, length)\
    m_##functionName##Function.set(m_vm, &globalObject, JSC::JSFunction::create(m_vm, &globalObject, codeName##Generator(m_vm), &globalObject));
    WEBCORE_FOREACH_READABLESTREAMINTERNALS_BUILTIN_CODE(EXPORT_FUNCTION)
#undef EXPORT_FUNCTION
}

template<typename Visitor>
inline void ReadableStreamInternalsBuiltinFunctions::visit(Visitor& visitor)
{
#define VISIT_FUNCTION(name) visitor.append(m_##name##Function);
    WEBCORE_FOREACH_READABLESTREAMINTERNALS_BUILTIN_FUNCTION_NAME(VISIT_FUNCTION)
#undef VISIT_FUNCTION
}

template void ReadableStreamInternalsBuiltinFunctions::visit(JSC::AbstractSlotVisitor&);
template void ReadableStreamInternalsBuiltinFunctions::visit(JSC::SlotVisitor&);



} // namespace WebCore
