/****************************************************************************
**
** Copyright (C) 2024 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the release tools of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:GPL-EXCEPT$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

var isOpensourceAccount = true;
var ifwVersion;

function Component()
{
    ifwVersion = installer.value("FrameworkVersion");
    var isOpenSource = "true";
    if (['false', 'no', '0'].indexOf(isOpenSource) >= 0)
        isOpensourceAccount = false;

    if (installer.versionMatches(ifwVersion, ">=4.0.0") && !installer.isCommandLineInstance())
        gui.pageWidgetByObjectName("LicenseAgreementPage").entered.connect(changeInstallerLicenseLabels);

    if (installer.versionMatches(ifwVersion, ">=4.8.0") && !isOpensourceAccount) {
        // Workaround for setting page sub title which is not available for scripting interface
        var licenseAgreementPage = gui.pageWidgetByObjectName("LicenseAgreementPage");
        if (licenseAgreementPage) {
             licenseAgreementPage.entered.connect(setLicenseAgreementSubTitle);
        }
    }
}

setLicenseAgreementSubTitle = function()
{
    var page = gui.pageWidgetByObjectName("LicenseAgreementPage");
    if (page)
        page.subTitle = qsTr("This Agreement applies to your download and installation of Qt software as a Designated User of a Customer under a valid agreement for the licensing of Qt software (each as defined in the Agreement). Please read in full and accept to proceed with the installation.")
}

changeInstallerLicenseLabels = function()
{
    var page = gui.pageWidgetByObjectName("LicenseAgreementPage");
    if (!page)
        return;

    if (installer.versionMatches(ifwVersion, "<4.8.0") || isOpensourceAccount) {
        page.AcceptLicenseLabel.setText(qsTr("I h<u>a</u>ve read and agree to the terms contained in the license agreements."));
    } else {
        page.AcceptLicenseLabel.setText(qsTr("I <u>a</u>cknowledge, accept, and will abide by the terms of this Agreement as a Designated User. In the event of any discrepancy between this Agreement and the agreement between the Customer for whom I am a Designated User, that agreement with the Customer governs my use and installation of Qt software to the extent of the discrepancy."));
        installer.addWizardPageItem( component, "DesignatedUserOfCustomerCheckBoxForm", QInstaller.LicenseCheck );
    }
}
