/****************************************************************************
**
** Copyright (C) 2025 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the release tools of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:GPL-EXCEPT$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

// constructor
function Component()
{
    // desktop component dependency needed for .pc file patching
    if (installer.componentByName("qt.qt6.692.win64_mingw"))
        component.addDependency("qt.qt6.692.win64_mingw");
}

Component.prototype.createOperations = function()
{
    component.createOperations();
    var qmakeBinary = "@TargetDir@" + "/6.9.2/mingw_64/bin/qmake.exe";
    // this operation is added to path .pc files for pkg-config
    component.addOperation("ConsumeOutput", component.value("Name") + "_qmakeoutput", qmakeBinary, "-query");
    component.addOperation("QtPatch",
                           "windows",
                           "@TargetDir@" + "/6.9.2/mingw_64",
                           "QmakeOutputInstallerKey=" + component.value("Name") + "_qmakeoutput",
                           "oldQtPath=" + "/Users/qt/work/install",
                           "qt5-no-bin-patch");
}
