// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/cloud/aiplatform/v1beta1/model_monitoring_spec.proto

package aiplatformpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	interval "google.golang.org/genproto/googleapis/type/interval"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Supported data format.
type ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringGcsSource_DataFormat int32

const (
	// Data format unspecified, used when this field is unset.
	ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringGcsSource_DATA_FORMAT_UNSPECIFIED ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringGcsSource_DataFormat = 0
	// CSV files.
	ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringGcsSource_CSV ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringGcsSource_DataFormat = 1
	// TfRecord files
	ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringGcsSource_TF_RECORD ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringGcsSource_DataFormat = 2
	// JsonL files.
	ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringGcsSource_JSONL ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringGcsSource_DataFormat = 3
)

// Enum value maps for ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringGcsSource_DataFormat.
var (
	ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringGcsSource_DataFormat_name = map[int32]string{
		0: "DATA_FORMAT_UNSPECIFIED",
		1: "CSV",
		2: "TF_RECORD",
		3: "JSONL",
	}
	ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringGcsSource_DataFormat_value = map[string]int32{
		"DATA_FORMAT_UNSPECIFIED": 0,
		"CSV":                     1,
		"TF_RECORD":               2,
		"JSONL":                   3,
	}
)

func (x ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringGcsSource_DataFormat) Enum() *ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringGcsSource_DataFormat {
	p := new(ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringGcsSource_DataFormat)
	*p = x
	return p
}

func (x ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringGcsSource_DataFormat) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringGcsSource_DataFormat) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_enumTypes[0].Descriptor()
}

func (ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringGcsSource_DataFormat) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_enumTypes[0]
}

func (x ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringGcsSource_DataFormat) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringGcsSource_DataFormat.Descriptor instead.
func (ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringGcsSource_DataFormat) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_rawDescGZIP(), []int{3, 0, 0, 0}
}

// Monitoring monitoring job spec. It outlines the specifications for monitoring
// objectives, notifications, and result exports.
type ModelMonitoringSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The monitoring objective spec.
	ObjectiveSpec *ModelMonitoringObjectiveSpec `protobuf:"bytes,1,opt,name=objective_spec,json=objectiveSpec,proto3" json:"objective_spec,omitempty"`
	// The model monitoring notification spec.
	NotificationSpec *ModelMonitoringNotificationSpec `protobuf:"bytes,2,opt,name=notification_spec,json=notificationSpec,proto3" json:"notification_spec,omitempty"`
	// The Output destination spec for metrics, error logs, etc.
	OutputSpec *ModelMonitoringOutputSpec `protobuf:"bytes,3,opt,name=output_spec,json=outputSpec,proto3" json:"output_spec,omitempty"`
}

func (x *ModelMonitoringSpec) Reset() {
	*x = ModelMonitoringSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ModelMonitoringSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModelMonitoringSpec) ProtoMessage() {}

func (x *ModelMonitoringSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModelMonitoringSpec.ProtoReflect.Descriptor instead.
func (*ModelMonitoringSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_rawDescGZIP(), []int{0}
}

func (x *ModelMonitoringSpec) GetObjectiveSpec() *ModelMonitoringObjectiveSpec {
	if x != nil {
		return x.ObjectiveSpec
	}
	return nil
}

func (x *ModelMonitoringSpec) GetNotificationSpec() *ModelMonitoringNotificationSpec {
	if x != nil {
		return x.NotificationSpec
	}
	return nil
}

func (x *ModelMonitoringSpec) GetOutputSpec() *ModelMonitoringOutputSpec {
	if x != nil {
		return x.OutputSpec
	}
	return nil
}

// Monitoring objectives spec.
type ModelMonitoringObjectiveSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The monitoring objective.
	//
	// Types that are assignable to Objective:
	//
	//	*ModelMonitoringObjectiveSpec_TabularObjective_
	Objective isModelMonitoringObjectiveSpec_Objective `protobuf_oneof:"objective"`
	// The explanation spec.
	// This spec is required when the objectives spec includes feature attribution
	// objectives.
	ExplanationSpec *ExplanationSpec `protobuf:"bytes,3,opt,name=explanation_spec,json=explanationSpec,proto3" json:"explanation_spec,omitempty"`
	// Baseline dataset.
	// It could be the training dataset or production serving dataset from a
	// previous period.
	BaselineDataset *ModelMonitoringInput `protobuf:"bytes,4,opt,name=baseline_dataset,json=baselineDataset,proto3" json:"baseline_dataset,omitempty"`
	// Target dataset.
	TargetDataset *ModelMonitoringInput `protobuf:"bytes,5,opt,name=target_dataset,json=targetDataset,proto3" json:"target_dataset,omitempty"`
}

func (x *ModelMonitoringObjectiveSpec) Reset() {
	*x = ModelMonitoringObjectiveSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ModelMonitoringObjectiveSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModelMonitoringObjectiveSpec) ProtoMessage() {}

func (x *ModelMonitoringObjectiveSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModelMonitoringObjectiveSpec.ProtoReflect.Descriptor instead.
func (*ModelMonitoringObjectiveSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_rawDescGZIP(), []int{1}
}

func (m *ModelMonitoringObjectiveSpec) GetObjective() isModelMonitoringObjectiveSpec_Objective {
	if m != nil {
		return m.Objective
	}
	return nil
}

func (x *ModelMonitoringObjectiveSpec) GetTabularObjective() *ModelMonitoringObjectiveSpec_TabularObjective {
	if x, ok := x.GetObjective().(*ModelMonitoringObjectiveSpec_TabularObjective_); ok {
		return x.TabularObjective
	}
	return nil
}

func (x *ModelMonitoringObjectiveSpec) GetExplanationSpec() *ExplanationSpec {
	if x != nil {
		return x.ExplanationSpec
	}
	return nil
}

func (x *ModelMonitoringObjectiveSpec) GetBaselineDataset() *ModelMonitoringInput {
	if x != nil {
		return x.BaselineDataset
	}
	return nil
}

func (x *ModelMonitoringObjectiveSpec) GetTargetDataset() *ModelMonitoringInput {
	if x != nil {
		return x.TargetDataset
	}
	return nil
}

type isModelMonitoringObjectiveSpec_Objective interface {
	isModelMonitoringObjectiveSpec_Objective()
}

type ModelMonitoringObjectiveSpec_TabularObjective_ struct {
	// Tabular monitoring objective.
	TabularObjective *ModelMonitoringObjectiveSpec_TabularObjective `protobuf:"bytes,1,opt,name=tabular_objective,json=tabularObjective,proto3,oneof"`
}

func (*ModelMonitoringObjectiveSpec_TabularObjective_) isModelMonitoringObjectiveSpec_Objective() {}

// Specification for the export destination of monitoring results, including
// metrics, logs, etc.
type ModelMonitoringOutputSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Google Cloud Storage base folder path for metrics, error logs, etc.
	GcsBaseDirectory *GcsDestination `protobuf:"bytes,1,opt,name=gcs_base_directory,json=gcsBaseDirectory,proto3" json:"gcs_base_directory,omitempty"`
}

func (x *ModelMonitoringOutputSpec) Reset() {
	*x = ModelMonitoringOutputSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ModelMonitoringOutputSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModelMonitoringOutputSpec) ProtoMessage() {}

func (x *ModelMonitoringOutputSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModelMonitoringOutputSpec.ProtoReflect.Descriptor instead.
func (*ModelMonitoringOutputSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_rawDescGZIP(), []int{2}
}

func (x *ModelMonitoringOutputSpec) GetGcsBaseDirectory() *GcsDestination {
	if x != nil {
		return x.GcsBaseDirectory
	}
	return nil
}

// Model monitoring data input spec.
type ModelMonitoringInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Dataset source.
	//
	// Types that are assignable to Dataset:
	//
	//	*ModelMonitoringInput_ColumnizedDataset
	//	*ModelMonitoringInput_BatchPredictionOutput_
	//	*ModelMonitoringInput_VertexEndpointLogs_
	Dataset isModelMonitoringInput_Dataset `protobuf_oneof:"dataset"`
	// Time specification for the dataset.
	//
	// Types that are assignable to TimeSpec:
	//
	//	*ModelMonitoringInput_TimeInterval
	//	*ModelMonitoringInput_TimeOffset_
	TimeSpec isModelMonitoringInput_TimeSpec `protobuf_oneof:"time_spec"`
}

func (x *ModelMonitoringInput) Reset() {
	*x = ModelMonitoringInput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ModelMonitoringInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModelMonitoringInput) ProtoMessage() {}

func (x *ModelMonitoringInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModelMonitoringInput.ProtoReflect.Descriptor instead.
func (*ModelMonitoringInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_rawDescGZIP(), []int{3}
}

func (m *ModelMonitoringInput) GetDataset() isModelMonitoringInput_Dataset {
	if m != nil {
		return m.Dataset
	}
	return nil
}

func (x *ModelMonitoringInput) GetColumnizedDataset() *ModelMonitoringInput_ModelMonitoringDataset {
	if x, ok := x.GetDataset().(*ModelMonitoringInput_ColumnizedDataset); ok {
		return x.ColumnizedDataset
	}
	return nil
}

func (x *ModelMonitoringInput) GetBatchPredictionOutput() *ModelMonitoringInput_BatchPredictionOutput {
	if x, ok := x.GetDataset().(*ModelMonitoringInput_BatchPredictionOutput_); ok {
		return x.BatchPredictionOutput
	}
	return nil
}

func (x *ModelMonitoringInput) GetVertexEndpointLogs() *ModelMonitoringInput_VertexEndpointLogs {
	if x, ok := x.GetDataset().(*ModelMonitoringInput_VertexEndpointLogs_); ok {
		return x.VertexEndpointLogs
	}
	return nil
}

func (m *ModelMonitoringInput) GetTimeSpec() isModelMonitoringInput_TimeSpec {
	if m != nil {
		return m.TimeSpec
	}
	return nil
}

func (x *ModelMonitoringInput) GetTimeInterval() *interval.Interval {
	if x, ok := x.GetTimeSpec().(*ModelMonitoringInput_TimeInterval); ok {
		return x.TimeInterval
	}
	return nil
}

func (x *ModelMonitoringInput) GetTimeOffset() *ModelMonitoringInput_TimeOffset {
	if x, ok := x.GetTimeSpec().(*ModelMonitoringInput_TimeOffset_); ok {
		return x.TimeOffset
	}
	return nil
}

type isModelMonitoringInput_Dataset interface {
	isModelMonitoringInput_Dataset()
}

type ModelMonitoringInput_ColumnizedDataset struct {
	// Columnized dataset.
	ColumnizedDataset *ModelMonitoringInput_ModelMonitoringDataset `protobuf:"bytes,1,opt,name=columnized_dataset,json=columnizedDataset,proto3,oneof"`
}

type ModelMonitoringInput_BatchPredictionOutput_ struct {
	// Vertex AI Batch prediction Job.
	BatchPredictionOutput *ModelMonitoringInput_BatchPredictionOutput `protobuf:"bytes,2,opt,name=batch_prediction_output,json=batchPredictionOutput,proto3,oneof"`
}

type ModelMonitoringInput_VertexEndpointLogs_ struct {
	// Vertex AI Endpoint request & response logging.
	VertexEndpointLogs *ModelMonitoringInput_VertexEndpointLogs `protobuf:"bytes,3,opt,name=vertex_endpoint_logs,json=vertexEndpointLogs,proto3,oneof"`
}

func (*ModelMonitoringInput_ColumnizedDataset) isModelMonitoringInput_Dataset() {}

func (*ModelMonitoringInput_BatchPredictionOutput_) isModelMonitoringInput_Dataset() {}

func (*ModelMonitoringInput_VertexEndpointLogs_) isModelMonitoringInput_Dataset() {}

type isModelMonitoringInput_TimeSpec interface {
	isModelMonitoringInput_TimeSpec()
}

type ModelMonitoringInput_TimeInterval struct {
	// The time interval (pair of start_time and end_time) for which results
	// should be returned.
	TimeInterval *interval.Interval `protobuf:"bytes,6,opt,name=time_interval,json=timeInterval,proto3,oneof"`
}

type ModelMonitoringInput_TimeOffset_ struct {
	// The time offset setting for which results should be returned.
	TimeOffset *ModelMonitoringInput_TimeOffset `protobuf:"bytes,7,opt,name=time_offset,json=timeOffset,proto3,oneof"`
}

func (*ModelMonitoringInput_TimeInterval) isModelMonitoringInput_TimeSpec() {}

func (*ModelMonitoringInput_TimeOffset_) isModelMonitoringInput_TimeSpec() {}

// Notification spec(email, notification channel) for model monitoring
// statistics/alerts.
type ModelMonitoringNotificationSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Email alert config.
	EmailConfig *ModelMonitoringNotificationSpec_EmailConfig `protobuf:"bytes,1,opt,name=email_config,json=emailConfig,proto3" json:"email_config,omitempty"`
	// Dump the anomalies to Cloud Logging. The anomalies will be put to json
	// payload encoded from proto
	// [google.cloud.aiplatform.logging.ModelMonitoringAnomaliesLogEntry][].
	// This can be further sinked to Pub/Sub or any other services supported
	// by Cloud Logging.
	EnableCloudLogging bool `protobuf:"varint,2,opt,name=enable_cloud_logging,json=enableCloudLogging,proto3" json:"enable_cloud_logging,omitempty"`
	// Notification channel config.
	NotificationChannelConfigs []*ModelMonitoringNotificationSpec_NotificationChannelConfig `protobuf:"bytes,3,rep,name=notification_channel_configs,json=notificationChannelConfigs,proto3" json:"notification_channel_configs,omitempty"`
}

func (x *ModelMonitoringNotificationSpec) Reset() {
	*x = ModelMonitoringNotificationSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ModelMonitoringNotificationSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModelMonitoringNotificationSpec) ProtoMessage() {}

func (x *ModelMonitoringNotificationSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModelMonitoringNotificationSpec.ProtoReflect.Descriptor instead.
func (*ModelMonitoringNotificationSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_rawDescGZIP(), []int{4}
}

func (x *ModelMonitoringNotificationSpec) GetEmailConfig() *ModelMonitoringNotificationSpec_EmailConfig {
	if x != nil {
		return x.EmailConfig
	}
	return nil
}

func (x *ModelMonitoringNotificationSpec) GetEnableCloudLogging() bool {
	if x != nil {
		return x.EnableCloudLogging
	}
	return false
}

func (x *ModelMonitoringNotificationSpec) GetNotificationChannelConfigs() []*ModelMonitoringNotificationSpec_NotificationChannelConfig {
	if x != nil {
		return x.NotificationChannelConfigs
	}
	return nil
}

// Data drift monitoring spec.
// Data drift measures the distribution distance between the current dataset
// and a baseline dataset. A typical use case is to detect data drift between
// the recent production serving dataset and the training dataset, or to
// compare the recent production dataset with a dataset from a previous
// period.
type ModelMonitoringObjectiveSpec_DataDriftSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Feature names / Prediction output names interested in monitoring.
	// These should be a subset of the input feature names or prediction output
	// names specified in the monitoring schema.
	// If the field is not specified all features / prediction outputs outlied
	// in the monitoring schema will be used.
	Features []string `protobuf:"bytes,1,rep,name=features,proto3" json:"features,omitempty"`
	// Supported metrics type:
	//   - l_infinity
	//   - jensen_shannon_divergence
	CategoricalMetricType string `protobuf:"bytes,2,opt,name=categorical_metric_type,json=categoricalMetricType,proto3" json:"categorical_metric_type,omitempty"`
	// Supported metrics type:
	//   - jensen_shannon_divergence
	NumericMetricType string `protobuf:"bytes,3,opt,name=numeric_metric_type,json=numericMetricType,proto3" json:"numeric_metric_type,omitempty"`
	// Default alert condition for all the categorical features.
	DefaultCategoricalAlertCondition *ModelMonitoringAlertCondition `protobuf:"bytes,4,opt,name=default_categorical_alert_condition,json=defaultCategoricalAlertCondition,proto3" json:"default_categorical_alert_condition,omitempty"`
	// Default alert condition for all the numeric features.
	DefaultNumericAlertCondition *ModelMonitoringAlertCondition `protobuf:"bytes,5,opt,name=default_numeric_alert_condition,json=defaultNumericAlertCondition,proto3" json:"default_numeric_alert_condition,omitempty"`
	// Per feature alert condition will override default alert condition.
	FeatureAlertConditions map[string]*ModelMonitoringAlertCondition `protobuf:"bytes,6,rep,name=feature_alert_conditions,json=featureAlertConditions,proto3" json:"feature_alert_conditions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *ModelMonitoringObjectiveSpec_DataDriftSpec) Reset() {
	*x = ModelMonitoringObjectiveSpec_DataDriftSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ModelMonitoringObjectiveSpec_DataDriftSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModelMonitoringObjectiveSpec_DataDriftSpec) ProtoMessage() {}

func (x *ModelMonitoringObjectiveSpec_DataDriftSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModelMonitoringObjectiveSpec_DataDriftSpec.ProtoReflect.Descriptor instead.
func (*ModelMonitoringObjectiveSpec_DataDriftSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_rawDescGZIP(), []int{1, 0}
}

func (x *ModelMonitoringObjectiveSpec_DataDriftSpec) GetFeatures() []string {
	if x != nil {
		return x.Features
	}
	return nil
}

func (x *ModelMonitoringObjectiveSpec_DataDriftSpec) GetCategoricalMetricType() string {
	if x != nil {
		return x.CategoricalMetricType
	}
	return ""
}

func (x *ModelMonitoringObjectiveSpec_DataDriftSpec) GetNumericMetricType() string {
	if x != nil {
		return x.NumericMetricType
	}
	return ""
}

func (x *ModelMonitoringObjectiveSpec_DataDriftSpec) GetDefaultCategoricalAlertCondition() *ModelMonitoringAlertCondition {
	if x != nil {
		return x.DefaultCategoricalAlertCondition
	}
	return nil
}

func (x *ModelMonitoringObjectiveSpec_DataDriftSpec) GetDefaultNumericAlertCondition() *ModelMonitoringAlertCondition {
	if x != nil {
		return x.DefaultNumericAlertCondition
	}
	return nil
}

func (x *ModelMonitoringObjectiveSpec_DataDriftSpec) GetFeatureAlertConditions() map[string]*ModelMonitoringAlertCondition {
	if x != nil {
		return x.FeatureAlertConditions
	}
	return nil
}

// Feature attribution monitoring spec.
type ModelMonitoringObjectiveSpec_FeatureAttributionSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Feature names interested in monitoring.
	// These should be a subset of the input feature names specified in the
	// monitoring schema. If the field is not specified all features outlied in
	// the monitoring schema will be used.
	Features []string `protobuf:"bytes,1,rep,name=features,proto3" json:"features,omitempty"`
	// Default alert condition for all the features.
	DefaultAlertCondition *ModelMonitoringAlertCondition `protobuf:"bytes,2,opt,name=default_alert_condition,json=defaultAlertCondition,proto3" json:"default_alert_condition,omitempty"`
	// Per feature alert condition will override default alert condition.
	FeatureAlertConditions map[string]*ModelMonitoringAlertCondition `protobuf:"bytes,3,rep,name=feature_alert_conditions,json=featureAlertConditions,proto3" json:"feature_alert_conditions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The config of resources used by the Model Monitoring during the batch
	// explanation for non-AutoML models. If not set, `n1-standard-2` machine
	// type will be used by default.
	BatchExplanationDedicatedResources *BatchDedicatedResources `protobuf:"bytes,4,opt,name=batch_explanation_dedicated_resources,json=batchExplanationDedicatedResources,proto3" json:"batch_explanation_dedicated_resources,omitempty"`
}

func (x *ModelMonitoringObjectiveSpec_FeatureAttributionSpec) Reset() {
	*x = ModelMonitoringObjectiveSpec_FeatureAttributionSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ModelMonitoringObjectiveSpec_FeatureAttributionSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModelMonitoringObjectiveSpec_FeatureAttributionSpec) ProtoMessage() {}

func (x *ModelMonitoringObjectiveSpec_FeatureAttributionSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModelMonitoringObjectiveSpec_FeatureAttributionSpec.ProtoReflect.Descriptor instead.
func (*ModelMonitoringObjectiveSpec_FeatureAttributionSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_rawDescGZIP(), []int{1, 1}
}

func (x *ModelMonitoringObjectiveSpec_FeatureAttributionSpec) GetFeatures() []string {
	if x != nil {
		return x.Features
	}
	return nil
}

func (x *ModelMonitoringObjectiveSpec_FeatureAttributionSpec) GetDefaultAlertCondition() *ModelMonitoringAlertCondition {
	if x != nil {
		return x.DefaultAlertCondition
	}
	return nil
}

func (x *ModelMonitoringObjectiveSpec_FeatureAttributionSpec) GetFeatureAlertConditions() map[string]*ModelMonitoringAlertCondition {
	if x != nil {
		return x.FeatureAlertConditions
	}
	return nil
}

func (x *ModelMonitoringObjectiveSpec_FeatureAttributionSpec) GetBatchExplanationDedicatedResources() *BatchDedicatedResources {
	if x != nil {
		return x.BatchExplanationDedicatedResources
	}
	return nil
}

// Tabular monitoring objective.
type ModelMonitoringObjectiveSpec_TabularObjective struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Input feature distribution drift monitoring spec.
	FeatureDriftSpec *ModelMonitoringObjectiveSpec_DataDriftSpec `protobuf:"bytes,10,opt,name=feature_drift_spec,json=featureDriftSpec,proto3" json:"feature_drift_spec,omitempty"`
	// Prediction output distribution drift monitoring spec.
	PredictionOutputDriftSpec *ModelMonitoringObjectiveSpec_DataDriftSpec `protobuf:"bytes,11,opt,name=prediction_output_drift_spec,json=predictionOutputDriftSpec,proto3" json:"prediction_output_drift_spec,omitempty"`
	// Feature attribution monitoring spec.
	FeatureAttributionSpec *ModelMonitoringObjectiveSpec_FeatureAttributionSpec `protobuf:"bytes,12,opt,name=feature_attribution_spec,json=featureAttributionSpec,proto3" json:"feature_attribution_spec,omitempty"`
}

func (x *ModelMonitoringObjectiveSpec_TabularObjective) Reset() {
	*x = ModelMonitoringObjectiveSpec_TabularObjective{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ModelMonitoringObjectiveSpec_TabularObjective) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModelMonitoringObjectiveSpec_TabularObjective) ProtoMessage() {}

func (x *ModelMonitoringObjectiveSpec_TabularObjective) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModelMonitoringObjectiveSpec_TabularObjective.ProtoReflect.Descriptor instead.
func (*ModelMonitoringObjectiveSpec_TabularObjective) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_rawDescGZIP(), []int{1, 2}
}

func (x *ModelMonitoringObjectiveSpec_TabularObjective) GetFeatureDriftSpec() *ModelMonitoringObjectiveSpec_DataDriftSpec {
	if x != nil {
		return x.FeatureDriftSpec
	}
	return nil
}

func (x *ModelMonitoringObjectiveSpec_TabularObjective) GetPredictionOutputDriftSpec() *ModelMonitoringObjectiveSpec_DataDriftSpec {
	if x != nil {
		return x.PredictionOutputDriftSpec
	}
	return nil
}

func (x *ModelMonitoringObjectiveSpec_TabularObjective) GetFeatureAttributionSpec() *ModelMonitoringObjectiveSpec_FeatureAttributionSpec {
	if x != nil {
		return x.FeatureAttributionSpec
	}
	return nil
}

// Input dataset spec.
type ModelMonitoringInput_ModelMonitoringDataset struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Choose one of supported data location for columnized dataset.
	//
	// Types that are assignable to DataLocation:
	//
	//	*ModelMonitoringInput_ModelMonitoringDataset_VertexDataset
	//	*ModelMonitoringInput_ModelMonitoringDataset_GcsSource
	//	*ModelMonitoringInput_ModelMonitoringDataset_BigquerySource
	DataLocation isModelMonitoringInput_ModelMonitoringDataset_DataLocation `protobuf_oneof:"data_location"`
	// The timestamp field. Usually for serving data.
	TimestampField string `protobuf:"bytes,7,opt,name=timestamp_field,json=timestampField,proto3" json:"timestamp_field,omitempty"`
}

func (x *ModelMonitoringInput_ModelMonitoringDataset) Reset() {
	*x = ModelMonitoringInput_ModelMonitoringDataset{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ModelMonitoringInput_ModelMonitoringDataset) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModelMonitoringInput_ModelMonitoringDataset) ProtoMessage() {}

func (x *ModelMonitoringInput_ModelMonitoringDataset) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModelMonitoringInput_ModelMonitoringDataset.ProtoReflect.Descriptor instead.
func (*ModelMonitoringInput_ModelMonitoringDataset) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_rawDescGZIP(), []int{3, 0}
}

func (m *ModelMonitoringInput_ModelMonitoringDataset) GetDataLocation() isModelMonitoringInput_ModelMonitoringDataset_DataLocation {
	if m != nil {
		return m.DataLocation
	}
	return nil
}

func (x *ModelMonitoringInput_ModelMonitoringDataset) GetVertexDataset() string {
	if x, ok := x.GetDataLocation().(*ModelMonitoringInput_ModelMonitoringDataset_VertexDataset); ok {
		return x.VertexDataset
	}
	return ""
}

func (x *ModelMonitoringInput_ModelMonitoringDataset) GetGcsSource() *ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringGcsSource {
	if x, ok := x.GetDataLocation().(*ModelMonitoringInput_ModelMonitoringDataset_GcsSource); ok {
		return x.GcsSource
	}
	return nil
}

func (x *ModelMonitoringInput_ModelMonitoringDataset) GetBigquerySource() *ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringBigQuerySource {
	if x, ok := x.GetDataLocation().(*ModelMonitoringInput_ModelMonitoringDataset_BigquerySource); ok {
		return x.BigquerySource
	}
	return nil
}

func (x *ModelMonitoringInput_ModelMonitoringDataset) GetTimestampField() string {
	if x != nil {
		return x.TimestampField
	}
	return ""
}

type isModelMonitoringInput_ModelMonitoringDataset_DataLocation interface {
	isModelMonitoringInput_ModelMonitoringDataset_DataLocation()
}

type ModelMonitoringInput_ModelMonitoringDataset_VertexDataset struct {
	// Resource name of the Vertex AI managed dataset.
	VertexDataset string `protobuf:"bytes,1,opt,name=vertex_dataset,json=vertexDataset,proto3,oneof"`
}

type ModelMonitoringInput_ModelMonitoringDataset_GcsSource struct {
	// Google Cloud Storage data source.
	GcsSource *ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringGcsSource `protobuf:"bytes,2,opt,name=gcs_source,json=gcsSource,proto3,oneof"`
}

type ModelMonitoringInput_ModelMonitoringDataset_BigquerySource struct {
	// BigQuery data source.
	BigquerySource *ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringBigQuerySource `protobuf:"bytes,6,opt,name=bigquery_source,json=bigquerySource,proto3,oneof"`
}

func (*ModelMonitoringInput_ModelMonitoringDataset_VertexDataset) isModelMonitoringInput_ModelMonitoringDataset_DataLocation() {
}

func (*ModelMonitoringInput_ModelMonitoringDataset_GcsSource) isModelMonitoringInput_ModelMonitoringDataset_DataLocation() {
}

func (*ModelMonitoringInput_ModelMonitoringDataset_BigquerySource) isModelMonitoringInput_ModelMonitoringDataset_DataLocation() {
}

// Data from Vertex AI Batch prediction job output.
type ModelMonitoringInput_BatchPredictionOutput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Vertex AI Batch prediction job resource name. The job must match the
	// model version specified in [ModelMonitor].[model_monitoring_target].
	BatchPredictionJob string `protobuf:"bytes,1,opt,name=batch_prediction_job,json=batchPredictionJob,proto3" json:"batch_prediction_job,omitempty"`
}

func (x *ModelMonitoringInput_BatchPredictionOutput) Reset() {
	*x = ModelMonitoringInput_BatchPredictionOutput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ModelMonitoringInput_BatchPredictionOutput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModelMonitoringInput_BatchPredictionOutput) ProtoMessage() {}

func (x *ModelMonitoringInput_BatchPredictionOutput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModelMonitoringInput_BatchPredictionOutput.ProtoReflect.Descriptor instead.
func (*ModelMonitoringInput_BatchPredictionOutput) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_rawDescGZIP(), []int{3, 1}
}

func (x *ModelMonitoringInput_BatchPredictionOutput) GetBatchPredictionJob() string {
	if x != nil {
		return x.BatchPredictionJob
	}
	return ""
}

// Data from Vertex AI Endpoint request response logging.
type ModelMonitoringInput_VertexEndpointLogs struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of endpoint resource names. The endpoints must enable the logging
	// with the [Endpoint].[request_response_logging_config], and must contain
	// the deployed model corresponding to the model version specified in
	// [ModelMonitor].[model_monitoring_target].
	Endpoints []string `protobuf:"bytes,1,rep,name=endpoints,proto3" json:"endpoints,omitempty"`
}

func (x *ModelMonitoringInput_VertexEndpointLogs) Reset() {
	*x = ModelMonitoringInput_VertexEndpointLogs{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ModelMonitoringInput_VertexEndpointLogs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModelMonitoringInput_VertexEndpointLogs) ProtoMessage() {}

func (x *ModelMonitoringInput_VertexEndpointLogs) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModelMonitoringInput_VertexEndpointLogs.ProtoReflect.Descriptor instead.
func (*ModelMonitoringInput_VertexEndpointLogs) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_rawDescGZIP(), []int{3, 2}
}

func (x *ModelMonitoringInput_VertexEndpointLogs) GetEndpoints() []string {
	if x != nil {
		return x.Endpoints
	}
	return nil
}

// Time offset setting.
type ModelMonitoringInput_TimeOffset struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [offset] is the time difference from the cut-off time.
	// For scheduled jobs, the cut-off time is the scheduled time.
	// For non-scheduled jobs, it's the time when the job was created.
	// Currently we support the following format:
	// 'w|W': Week, 'd|D': Day, 'h|H': Hour
	// E.g. '1h' stands for 1 hour, '2d' stands for 2 days.
	Offset string `protobuf:"bytes,1,opt,name=offset,proto3" json:"offset,omitempty"`
	// [window] refers to the scope of data selected for analysis.
	// It allows you to specify the quantity of data you wish to examine.
	// Currently we support the following format:
	// 'w|W': Week, 'd|D': Day, 'h|H': Hour
	// E.g. '1h' stands for 1 hour, '2d' stands for 2 days.
	Window string `protobuf:"bytes,2,opt,name=window,proto3" json:"window,omitempty"`
}

func (x *ModelMonitoringInput_TimeOffset) Reset() {
	*x = ModelMonitoringInput_TimeOffset{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ModelMonitoringInput_TimeOffset) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModelMonitoringInput_TimeOffset) ProtoMessage() {}

func (x *ModelMonitoringInput_TimeOffset) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModelMonitoringInput_TimeOffset.ProtoReflect.Descriptor instead.
func (*ModelMonitoringInput_TimeOffset) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_rawDescGZIP(), []int{3, 3}
}

func (x *ModelMonitoringInput_TimeOffset) GetOffset() string {
	if x != nil {
		return x.Offset
	}
	return ""
}

func (x *ModelMonitoringInput_TimeOffset) GetWindow() string {
	if x != nil {
		return x.Window
	}
	return ""
}

// Dataset spec for data stored in Google Cloud Storage.
type ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringGcsSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Google Cloud Storage URI to the input file(s). May contain
	// wildcards. For more information on wildcards, see
	// https://cloud.google.com/storage/docs/gsutil/addlhelp/WildcardNames.
	GcsUri string `protobuf:"bytes,1,opt,name=gcs_uri,json=gcsUri,proto3" json:"gcs_uri,omitempty"`
	// Data format of the dataset.
	Format ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringGcsSource_DataFormat `protobuf:"varint,2,opt,name=format,proto3,enum=google.cloud.aiplatform.v1beta1.ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringGcsSource_DataFormat" json:"format,omitempty"`
}

func (x *ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringGcsSource) Reset() {
	*x = ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringGcsSource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringGcsSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringGcsSource) ProtoMessage() {}

func (x *ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringGcsSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringGcsSource.ProtoReflect.Descriptor instead.
func (*ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringGcsSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_rawDescGZIP(), []int{3, 0, 0}
}

func (x *ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringGcsSource) GetGcsUri() string {
	if x != nil {
		return x.GcsUri
	}
	return ""
}

func (x *ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringGcsSource) GetFormat() ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringGcsSource_DataFormat {
	if x != nil {
		return x.Format
	}
	return ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringGcsSource_DATA_FORMAT_UNSPECIFIED
}

// Dataset spec for data sotred in BigQuery.
type ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringBigQuerySource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Connection:
	//
	//	*ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringBigQuerySource_TableUri
	//	*ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringBigQuerySource_Query
	Connection isModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringBigQuerySource_Connection `protobuf_oneof:"connection"`
}

func (x *ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringBigQuerySource) Reset() {
	*x = ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringBigQuerySource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringBigQuerySource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringBigQuerySource) ProtoMessage() {}

func (x *ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringBigQuerySource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringBigQuerySource.ProtoReflect.Descriptor instead.
func (*ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringBigQuerySource) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_rawDescGZIP(), []int{3, 0, 1}
}

func (m *ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringBigQuerySource) GetConnection() isModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringBigQuerySource_Connection {
	if m != nil {
		return m.Connection
	}
	return nil
}

func (x *ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringBigQuerySource) GetTableUri() string {
	if x, ok := x.GetConnection().(*ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringBigQuerySource_TableUri); ok {
		return x.TableUri
	}
	return ""
}

func (x *ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringBigQuerySource) GetQuery() string {
	if x, ok := x.GetConnection().(*ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringBigQuerySource_Query); ok {
		return x.Query
	}
	return ""
}

type isModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringBigQuerySource_Connection interface {
	isModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringBigQuerySource_Connection()
}

type ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringBigQuerySource_TableUri struct {
	// BigQuery URI to a table, up to 2000 characters long. All the columns
	// in the table will be selected. Accepted forms:
	//
	// *  BigQuery path. For example:
	// `bq://projectId.bqDatasetId.bqTableId`.
	TableUri string `protobuf:"bytes,1,opt,name=table_uri,json=tableUri,proto3,oneof"`
}

type ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringBigQuerySource_Query struct {
	// Standard SQL to be used instead of the `table_uri`.
	Query string `protobuf:"bytes,2,opt,name=query,proto3,oneof"`
}

func (*ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringBigQuerySource_TableUri) isModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringBigQuerySource_Connection() {
}

func (*ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringBigQuerySource_Query) isModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringBigQuerySource_Connection() {
}

// The config for email alerts.
type ModelMonitoringNotificationSpec_EmailConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The email addresses to send the alerts.
	UserEmails []string `protobuf:"bytes,1,rep,name=user_emails,json=userEmails,proto3" json:"user_emails,omitempty"`
}

func (x *ModelMonitoringNotificationSpec_EmailConfig) Reset() {
	*x = ModelMonitoringNotificationSpec_EmailConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ModelMonitoringNotificationSpec_EmailConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModelMonitoringNotificationSpec_EmailConfig) ProtoMessage() {}

func (x *ModelMonitoringNotificationSpec_EmailConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModelMonitoringNotificationSpec_EmailConfig.ProtoReflect.Descriptor instead.
func (*ModelMonitoringNotificationSpec_EmailConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_rawDescGZIP(), []int{4, 0}
}

func (x *ModelMonitoringNotificationSpec_EmailConfig) GetUserEmails() []string {
	if x != nil {
		return x.UserEmails
	}
	return nil
}

// Google Cloud Notification Channel config.
type ModelMonitoringNotificationSpec_NotificationChannelConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource names of the NotificationChannels.
	// Must be of the format
	// `projects/<project_id_or_number>/notificationChannels/<channel_id>`
	NotificationChannel string `protobuf:"bytes,1,opt,name=notification_channel,json=notificationChannel,proto3" json:"notification_channel,omitempty"`
}

func (x *ModelMonitoringNotificationSpec_NotificationChannelConfig) Reset() {
	*x = ModelMonitoringNotificationSpec_NotificationChannelConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ModelMonitoringNotificationSpec_NotificationChannelConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModelMonitoringNotificationSpec_NotificationChannelConfig) ProtoMessage() {}

func (x *ModelMonitoringNotificationSpec_NotificationChannelConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModelMonitoringNotificationSpec_NotificationChannelConfig.ProtoReflect.Descriptor instead.
func (*ModelMonitoringNotificationSpec_NotificationChannelConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_rawDescGZIP(), []int{4, 1}
}

func (x *ModelMonitoringNotificationSpec_NotificationChannelConfig) GetNotificationChannel() string {
	if x != nil {
		return x.NotificationChannel
	}
	return ""
}

var File_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_rawDesc = []byte{
	0x0a, 0x3b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69,
	0x6e, 0x67, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x19,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x65, 0x78, 0x70, 0x6c, 0x61,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x69, 0x6f,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x3c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e,
	0x67, 0x5f, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x76, 0x61, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc7, 0x02, 0x0a, 0x13, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x70, 0x65,
	0x63, 0x12, 0x64, 0x0a, 0x0e, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x73,
	0x70, 0x65, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x4f, 0x62, 0x6a, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x65, 0x53, 0x70, 0x65, 0x63, 0x52, 0x0d, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x6d, 0x0a, 0x11, 0x6e, 0x6f, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f,
	0x72, 0x69, 0x6e, 0x67, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x70, 0x65, 0x63, 0x52, 0x10, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x5b, 0x0a, 0x0b, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x4f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x53, 0x70, 0x65, 0x63, 0x52, 0x0a, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x53,
	0x70, 0x65, 0x63, 0x22, 0xcb, 0x11, 0x0a, 0x1c, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e,
	0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65,
	0x53, 0x70, 0x65, 0x63, 0x12, 0x7d, 0x0a, 0x11, 0x74, 0x61, 0x62, 0x75, 0x6c, 0x61, 0x72, 0x5f,
	0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e,
	0x67, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x54,
	0x61, 0x62, 0x75, 0x6c, 0x61, 0x72, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x48,
	0x00, 0x52, 0x10, 0x74, 0x61, 0x62, 0x75, 0x6c, 0x61, 0x72, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x12, 0x5b, 0x0a, 0x10, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52,
	0x0f, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63,
	0x12, 0x60, 0x0a, 0x10, 0x62, 0x61, 0x73, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x64, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x70, 0x75,
	0x74, 0x52, 0x0f, 0x62, 0x61, 0x73, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x44, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x12, 0x5c, 0x0a, 0x0e, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x64, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x70, 0x75,
	0x74, 0x52, 0x0d, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x1a, 0xdb, 0x05, 0x0a, 0x0d, 0x44, 0x61, 0x74, 0x61, 0x44, 0x72, 0x69, 0x66, 0x74, 0x53, 0x70,
	0x65, 0x63, 0x12, 0x1a, 0x0a, 0x08, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x12, 0x36,
	0x0a, 0x17, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x15, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2e, 0x0a, 0x13, 0x6e, 0x75, 0x6d, 0x65, 0x72, 0x69,
	0x63, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x11, 0x6e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x54, 0x79, 0x70, 0x65, 0x12, 0x8d, 0x01, 0x0a, 0x23, 0x64, 0x65, 0x66, 0x61, 0x75,
	0x6c, 0x74, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x61,
	0x6c, 0x65, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69,
	0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x64, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x20, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x43, 0x61, 0x74,
	0x65, 0x67, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x43, 0x6f, 0x6e,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x85, 0x01, 0x0a, 0x1f, 0x64, 0x65, 0x66, 0x61, 0x75,
	0x6c, 0x74, 0x5f, 0x6e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x5f, 0x61, 0x6c, 0x65, 0x72, 0x74,
	0x5f, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69,
	0x6e, 0x67, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x1c, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x4e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63,
	0x41, 0x6c, 0x65, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0xa1,
	0x01, 0x0a, 0x18, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x61, 0x6c, 0x65, 0x72, 0x74,
	0x5f, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72,
	0x69, 0x6e, 0x67, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53, 0x70, 0x65, 0x63,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x44, 0x72, 0x69, 0x66, 0x74, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x46,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x64, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x16, 0x66, 0x65, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x1a, 0x89, 0x01, 0x0a, 0x1b, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x41, 0x6c,
	0x65, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x54, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74,
	0x6f, 0x72, 0x69, 0x6e, 0x67, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0xf3,
	0x04, 0x0a, 0x16, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x1a, 0x0a, 0x08, 0x66, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x66, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x73, 0x12, 0x76, 0x0a, 0x17, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74,
	0x5f, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f,
	0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x43, 0x6f, 0x6e,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x15, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x41,
	0x6c, 0x65, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0xaa, 0x01,
	0x0a, 0x18, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x5f,
	0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69,
	0x6e, 0x67, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53, 0x70, 0x65, 0x63, 0x2e,
	0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x41, 0x6c,
	0x65, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x16, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x41, 0x6c, 0x65, 0x72, 0x74,
	0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x8b, 0x01, 0x0a, 0x25, 0x62,
	0x61, 0x74, 0x63, 0x68, 0x5f, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x64, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x44, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x52, 0x22, 0x62, 0x61, 0x74, 0x63, 0x68, 0x45, 0x78, 0x70, 0x6c, 0x61,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x1a, 0x89, 0x01, 0x0a, 0x1b, 0x46, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x54, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x41, 0x6c, 0x65, 0x72, 0x74,
	0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x1a, 0xad, 0x03, 0x0a, 0x10, 0x54, 0x61, 0x62, 0x75, 0x6c, 0x61, 0x72,
	0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x12, 0x79, 0x0a, 0x12, 0x66, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x5f, 0x64, 0x72, 0x69, 0x66, 0x74, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e,
	0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65,
	0x53, 0x70, 0x65, 0x63, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x44, 0x72, 0x69, 0x66, 0x74, 0x53, 0x70,
	0x65, 0x63, 0x52, 0x10, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x44, 0x72, 0x69, 0x66, 0x74,
	0x53, 0x70, 0x65, 0x63, 0x12, 0x8c, 0x01, 0x0a, 0x1c, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x64, 0x72, 0x69, 0x66, 0x74,
	0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x4f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x44,
	0x72, 0x69, 0x66, 0x74, 0x53, 0x70, 0x65, 0x63, 0x52, 0x19, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x44, 0x72, 0x69, 0x66, 0x74, 0x53,
	0x70, 0x65, 0x63, 0x12, 0x8e, 0x01, 0x0a, 0x18, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f,
	0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63,
	0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x54, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f,
	0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x65, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x41, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x16, 0x66, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x70, 0x65, 0x63, 0x42, 0x0b, 0x0a, 0x09, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x65, 0x22, 0x7a, 0x0a, 0x19, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f,
	0x72, 0x69, 0x6e, 0x67, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x5d,
	0x0a, 0x12, 0x67, 0x63, 0x73, 0x5f, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x64, 0x69, 0x72, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x63, 0x73,
	0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x67, 0x63, 0x73,
	0x42, 0x61, 0x73, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x22, 0xab, 0x0d,
	0x0a, 0x14, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e,
	0x67, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x7d, 0x0a, 0x12, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e,
	0x69, 0x7a, 0x65, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f,
	0x72, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d,
	0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x48, 0x00, 0x52, 0x11, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x69, 0x7a, 0x65, 0x64, 0x44, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x85, 0x01, 0x0a, 0x17, 0x62, 0x61, 0x74, 0x63, 0x68, 0x5f,
	0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d,
	0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x2e, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x48, 0x00, 0x52, 0x15, 0x62, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x65,
	0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x12, 0x7c, 0x0a,
	0x14, 0x76, 0x65, 0x72, 0x74, 0x65, 0x78, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x5f, 0x6c, 0x6f, 0x67, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x70,
	0x75, 0x74, 0x2e, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x4c, 0x6f, 0x67, 0x73, 0x48, 0x00, 0x52, 0x12, 0x76, 0x65, 0x72, 0x74, 0x65, 0x78, 0x45,
	0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x4c, 0x6f, 0x67, 0x73, 0x12, 0x3c, 0x0a, 0x0d, 0x74,
	0x69, 0x6d, 0x65, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65,
	0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x48, 0x01, 0x52, 0x0c, 0x74, 0x69, 0x6d,
	0x65, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x12, 0x63, 0x0a, 0x0b, 0x74, 0x69, 0x6d,
	0x65, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67,
	0x49, 0x6e, 0x70, 0x75, 0x74, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74,
	0x48, 0x01, 0x52, 0x0a, 0x74, 0x69, 0x6d, 0x65, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x1a, 0xb9,
	0x06, 0x0a, 0x16, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69,
	0x6e, 0x67, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x4f, 0x0a, 0x0e, 0x76, 0x65, 0x72,
	0x74, 0x65, 0x78, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x26, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x48, 0x00, 0x52, 0x0d, 0x76, 0x65, 0x72,
	0x74, 0x65, 0x78, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x86, 0x01, 0x0a, 0x0a, 0x67,
	0x63, 0x73, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e,
	0x67, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69,
	0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x2e, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x47, 0x63, 0x73,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x09, 0x67, 0x63, 0x73, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x12, 0x95, 0x01, 0x0a, 0x0f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x6a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f,
	0x72, 0x69, 0x6e, 0x67, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x2e, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x42, 0x69, 0x67, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x0e, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x1a, 0x8c, 0x02, 0x0a, 0x18, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f,
	0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x12, 0x17, 0x0a, 0x07, 0x67, 0x63, 0x73, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x67, 0x63, 0x73, 0x55, 0x72, 0x69, 0x12, 0x88, 0x01, 0x0a, 0x06, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x70, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x70,
	0x75, 0x74, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69,
	0x6e, 0x67, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d,
	0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x52, 0x06, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x22, 0x4c, 0x0a, 0x0a, 0x44, 0x61, 0x74, 0x61, 0x46, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x12, 0x1b, 0x0a, 0x17, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x46, 0x4f, 0x52, 0x4d,
	0x41, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x07, 0x0a, 0x03, 0x43, 0x53, 0x56, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x54, 0x46, 0x5f,
	0x52, 0x45, 0x43, 0x4f, 0x52, 0x44, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x4a, 0x53, 0x4f, 0x4e,
	0x4c, 0x10, 0x03, 0x1a, 0x64, 0x0a, 0x1d, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69,
	0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x12, 0x1d, 0x0a, 0x09, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x75, 0x72,
	0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x08, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x55, 0x72, 0x69, 0x12, 0x16, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x00, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x42, 0x0c, 0x0a, 0x0a, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x0f, 0x0a, 0x0d, 0x64, 0x61, 0x74,
	0x61, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x7c, 0x0a, 0x15, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x12, 0x63, 0x0a, 0x14, 0x62, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x70, 0x72, 0x65,
	0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6a, 0x6f, 0x62, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x31, 0xfa, 0x41, 0x2e, 0x0a, 0x2c, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x42, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x12, 0x62, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x65, 0x64, 0x69,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x1a, 0x5b, 0x0a, 0x12, 0x56, 0x65, 0x72, 0x74,
	0x65, 0x78, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x4c, 0x6f, 0x67, 0x73, 0x12, 0x45,
	0x0a, 0x09, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x09, 0x42, 0x27, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x09, 0x65, 0x6e, 0x64, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x73, 0x1a, 0x3c, 0x0a, 0x0a, 0x54, 0x69, 0x6d, 0x65, 0x4f, 0x66, 0x66,
	0x73, 0x65, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x77,
	0x69, 0x6e, 0x64, 0x6f, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x77, 0x69, 0x6e,
	0x64, 0x6f, 0x77, 0x42, 0x09, 0x0a, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x42, 0x0b,
	0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x22, 0xe3, 0x03, 0x0a, 0x1f,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x4e,
	0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12,
	0x6f, 0x0a, 0x0c, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e,
	0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x0b, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x30, 0x0a, 0x14, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x5f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x12,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x4c, 0x6f, 0x67, 0x67, 0x69,
	0x6e, 0x67, 0x12, 0x9c, 0x01, 0x0a, 0x1c, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x5a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x4e, 0x6f, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x4e, 0x6f, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x1a, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x73, 0x1a, 0x2e, 0x0a, 0x0b, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x1f, 0x0a, 0x0b, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x75, 0x73, 0x65, 0x72, 0x45, 0x6d, 0x61, 0x69, 0x6c,
	0x73, 0x1a, 0x4e, 0x0a, 0x19, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x31,
	0x0a, 0x14, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x6e, 0x6f,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x42, 0xef, 0x01, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x18, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x70, 0x65, 0x63, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x43, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0x3b, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x31, 0xca, 0x02, 0x1f, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x49, 0x50, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02,
	0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a,
	0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_rawDescData = file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_rawDesc
)

func file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_rawDescData
}

var file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes = make([]protoimpl.MessageInfo, 18)
var file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_goTypes = []interface{}{
	(ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringGcsSource_DataFormat)(0), // 0: google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringGcsSource.DataFormat
	(*ModelMonitoringSpec)(nil),                                 // 1: google.cloud.aiplatform.v1beta1.ModelMonitoringSpec
	(*ModelMonitoringObjectiveSpec)(nil),                        // 2: google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
	(*ModelMonitoringOutputSpec)(nil),                           // 3: google.cloud.aiplatform.v1beta1.ModelMonitoringOutputSpec
	(*ModelMonitoringInput)(nil),                                // 4: google.cloud.aiplatform.v1beta1.ModelMonitoringInput
	(*ModelMonitoringNotificationSpec)(nil),                     // 5: google.cloud.aiplatform.v1beta1.ModelMonitoringNotificationSpec
	(*ModelMonitoringObjectiveSpec_DataDriftSpec)(nil),          // 6: google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec
	(*ModelMonitoringObjectiveSpec_FeatureAttributionSpec)(nil), // 7: google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.FeatureAttributionSpec
	(*ModelMonitoringObjectiveSpec_TabularObjective)(nil),       // 8: google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
	nil, // 9: google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec.FeatureAlertConditionsEntry
	nil, // 10: google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.FeatureAttributionSpec.FeatureAlertConditionsEntry
	(*ModelMonitoringInput_ModelMonitoringDataset)(nil),                               // 11: google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
	(*ModelMonitoringInput_BatchPredictionOutput)(nil),                                // 12: google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput
	(*ModelMonitoringInput_VertexEndpointLogs)(nil),                                   // 13: google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs
	(*ModelMonitoringInput_TimeOffset)(nil),                                           // 14: google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset
	(*ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringGcsSource)(nil),      // 15: google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringGcsSource
	(*ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringBigQuerySource)(nil), // 16: google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringBigQuerySource
	(*ModelMonitoringNotificationSpec_EmailConfig)(nil),                               // 17: google.cloud.aiplatform.v1beta1.ModelMonitoringNotificationSpec.EmailConfig
	(*ModelMonitoringNotificationSpec_NotificationChannelConfig)(nil),                 // 18: google.cloud.aiplatform.v1beta1.ModelMonitoringNotificationSpec.NotificationChannelConfig
	(*ExplanationSpec)(nil),                                                           // 19: google.cloud.aiplatform.v1beta1.ExplanationSpec
	(*GcsDestination)(nil),                                                            // 20: google.cloud.aiplatform.v1beta1.GcsDestination
	(*interval.Interval)(nil),                                                         // 21: google.type.Interval
	(*ModelMonitoringAlertCondition)(nil),                                             // 22: google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition
	(*BatchDedicatedResources)(nil),                                                   // 23: google.cloud.aiplatform.v1beta1.BatchDedicatedResources
}
var file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_depIdxs = []int32{
	2,  // 0: google.cloud.aiplatform.v1beta1.ModelMonitoringSpec.objective_spec:type_name -> google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
	5,  // 1: google.cloud.aiplatform.v1beta1.ModelMonitoringSpec.notification_spec:type_name -> google.cloud.aiplatform.v1beta1.ModelMonitoringNotificationSpec
	3,  // 2: google.cloud.aiplatform.v1beta1.ModelMonitoringSpec.output_spec:type_name -> google.cloud.aiplatform.v1beta1.ModelMonitoringOutputSpec
	8,  // 3: google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.tabular_objective:type_name -> google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
	19, // 4: google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.explanation_spec:type_name -> google.cloud.aiplatform.v1beta1.ExplanationSpec
	4,  // 5: google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.baseline_dataset:type_name -> google.cloud.aiplatform.v1beta1.ModelMonitoringInput
	4,  // 6: google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.target_dataset:type_name -> google.cloud.aiplatform.v1beta1.ModelMonitoringInput
	20, // 7: google.cloud.aiplatform.v1beta1.ModelMonitoringOutputSpec.gcs_base_directory:type_name -> google.cloud.aiplatform.v1beta1.GcsDestination
	11, // 8: google.cloud.aiplatform.v1beta1.ModelMonitoringInput.columnized_dataset:type_name -> google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
	12, // 9: google.cloud.aiplatform.v1beta1.ModelMonitoringInput.batch_prediction_output:type_name -> google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput
	13, // 10: google.cloud.aiplatform.v1beta1.ModelMonitoringInput.vertex_endpoint_logs:type_name -> google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs
	21, // 11: google.cloud.aiplatform.v1beta1.ModelMonitoringInput.time_interval:type_name -> google.type.Interval
	14, // 12: google.cloud.aiplatform.v1beta1.ModelMonitoringInput.time_offset:type_name -> google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset
	17, // 13: google.cloud.aiplatform.v1beta1.ModelMonitoringNotificationSpec.email_config:type_name -> google.cloud.aiplatform.v1beta1.ModelMonitoringNotificationSpec.EmailConfig
	18, // 14: google.cloud.aiplatform.v1beta1.ModelMonitoringNotificationSpec.notification_channel_configs:type_name -> google.cloud.aiplatform.v1beta1.ModelMonitoringNotificationSpec.NotificationChannelConfig
	22, // 15: google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec.default_categorical_alert_condition:type_name -> google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition
	22, // 16: google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec.default_numeric_alert_condition:type_name -> google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition
	9,  // 17: google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec.feature_alert_conditions:type_name -> google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec.FeatureAlertConditionsEntry
	22, // 18: google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.FeatureAttributionSpec.default_alert_condition:type_name -> google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition
	10, // 19: google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.FeatureAttributionSpec.feature_alert_conditions:type_name -> google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.FeatureAttributionSpec.FeatureAlertConditionsEntry
	23, // 20: google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.FeatureAttributionSpec.batch_explanation_dedicated_resources:type_name -> google.cloud.aiplatform.v1beta1.BatchDedicatedResources
	6,  // 21: google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective.feature_drift_spec:type_name -> google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec
	6,  // 22: google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective.prediction_output_drift_spec:type_name -> google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec
	7,  // 23: google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective.feature_attribution_spec:type_name -> google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.FeatureAttributionSpec
	22, // 24: google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.DataDriftSpec.FeatureAlertConditionsEntry.value:type_name -> google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition
	22, // 25: google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.FeatureAttributionSpec.FeatureAlertConditionsEntry.value:type_name -> google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition
	15, // 26: google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.gcs_source:type_name -> google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringGcsSource
	16, // 27: google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.bigquery_source:type_name -> google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringBigQuerySource
	0,  // 28: google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringGcsSource.format:type_name -> google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringGcsSource.DataFormat
	29, // [29:29] is the sub-list for method output_type
	29, // [29:29] is the sub-list for method input_type
	29, // [29:29] is the sub-list for extension type_name
	29, // [29:29] is the sub-list for extension extendee
	0,  // [0:29] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_init() }
func file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_init() {
	if File_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1beta1_explanation_proto_init()
	file_google_cloud_aiplatform_v1beta1_io_proto_init()
	file_google_cloud_aiplatform_v1beta1_machine_resources_proto_init()
	file_google_cloud_aiplatform_v1beta1_model_monitoring_alert_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ModelMonitoringSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ModelMonitoringObjectiveSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ModelMonitoringOutputSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ModelMonitoringInput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ModelMonitoringNotificationSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ModelMonitoringObjectiveSpec_DataDriftSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ModelMonitoringObjectiveSpec_FeatureAttributionSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ModelMonitoringObjectiveSpec_TabularObjective); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ModelMonitoringInput_ModelMonitoringDataset); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ModelMonitoringInput_BatchPredictionOutput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ModelMonitoringInput_VertexEndpointLogs); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ModelMonitoringInput_TimeOffset); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringGcsSource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringBigQuerySource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ModelMonitoringNotificationSpec_EmailConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ModelMonitoringNotificationSpec_NotificationChannelConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*ModelMonitoringObjectiveSpec_TabularObjective_)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*ModelMonitoringInput_ColumnizedDataset)(nil),
		(*ModelMonitoringInput_BatchPredictionOutput_)(nil),
		(*ModelMonitoringInput_VertexEndpointLogs_)(nil),
		(*ModelMonitoringInput_TimeInterval)(nil),
		(*ModelMonitoringInput_TimeOffset_)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes[10].OneofWrappers = []interface{}{
		(*ModelMonitoringInput_ModelMonitoringDataset_VertexDataset)(nil),
		(*ModelMonitoringInput_ModelMonitoringDataset_GcsSource)(nil),
		(*ModelMonitoringInput_ModelMonitoringDataset_BigquerySource)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes[15].OneofWrappers = []interface{}{
		(*ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringBigQuerySource_TableUri)(nil),
		(*ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringBigQuerySource_Query)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   18,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_depIdxs,
		EnumInfos:         file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_enumTypes,
		MessageInfos:      file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto = out.File
	file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_goTypes = nil
	file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_depIdxs = nil
}
