// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.31.0
// 	protoc        v4.23.2
// source: google/cloud/contactcenterinsights/v1/contact_center_insights.proto

package contactcenterinsightspb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Represents the options for viewing a conversation.
type ConversationView int32

const (
	// The conversation view is not specified.
	//
	// * Defaults to `FULL` in `GetConversationRequest`.
	// * Defaults to `BASIC` in `ListConversationsRequest`.
	ConversationView_CONVERSATION_VIEW_UNSPECIFIED ConversationView = 0
	// Populates all fields in the conversation.
	ConversationView_FULL ConversationView = 2
	// Populates all fields in the conversation except the transcript.
	ConversationView_BASIC ConversationView = 1
)

// Enum value maps for ConversationView.
var (
	ConversationView_name = map[int32]string{
		0: "CONVERSATION_VIEW_UNSPECIFIED",
		2: "FULL",
		1: "BASIC",
	}
	ConversationView_value = map[string]int32{
		"CONVERSATION_VIEW_UNSPECIFIED": 0,
		"FULL":                          2,
		"BASIC":                         1,
	}
)

func (x ConversationView) Enum() *ConversationView {
	p := new(ConversationView)
	*p = x
	return p
}

func (x ConversationView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ConversationView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_enumTypes[0].Descriptor()
}

func (ConversationView) Type() protoreflect.EnumType {
	return &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_enumTypes[0]
}

func (x ConversationView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ConversationView.Descriptor instead.
func (ConversationView) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{0}
}

type IngestConversationsRequest_GcsSource_BucketObjectType int32

const (
	// The object type is unspecified and will default to `TRANSCRIPT`.
	IngestConversationsRequest_GcsSource_BUCKET_OBJECT_TYPE_UNSPECIFIED IngestConversationsRequest_GcsSource_BucketObjectType = 0
	// The object is a transcript.
	IngestConversationsRequest_GcsSource_TRANSCRIPT IngestConversationsRequest_GcsSource_BucketObjectType = 1
	// The object is an audio file.
	IngestConversationsRequest_GcsSource_AUDIO IngestConversationsRequest_GcsSource_BucketObjectType = 2
)

// Enum value maps for IngestConversationsRequest_GcsSource_BucketObjectType.
var (
	IngestConversationsRequest_GcsSource_BucketObjectType_name = map[int32]string{
		0: "BUCKET_OBJECT_TYPE_UNSPECIFIED",
		1: "TRANSCRIPT",
		2: "AUDIO",
	}
	IngestConversationsRequest_GcsSource_BucketObjectType_value = map[string]int32{
		"BUCKET_OBJECT_TYPE_UNSPECIFIED": 0,
		"TRANSCRIPT":                     1,
		"AUDIO":                          2,
	}
)

func (x IngestConversationsRequest_GcsSource_BucketObjectType) Enum() *IngestConversationsRequest_GcsSource_BucketObjectType {
	p := new(IngestConversationsRequest_GcsSource_BucketObjectType)
	*p = x
	return p
}

func (x IngestConversationsRequest_GcsSource_BucketObjectType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (IngestConversationsRequest_GcsSource_BucketObjectType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_enumTypes[1].Descriptor()
}

func (IngestConversationsRequest_GcsSource_BucketObjectType) Type() protoreflect.EnumType {
	return &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_enumTypes[1]
}

func (x IngestConversationsRequest_GcsSource_BucketObjectType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use IngestConversationsRequest_GcsSource_BucketObjectType.Descriptor instead.
func (IngestConversationsRequest_GcsSource_BucketObjectType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{11, 0, 0}
}

// Specifies the action that occurs if the destination table already exists.
type ExportInsightsDataRequest_WriteDisposition int32

const (
	// Write disposition is not specified. Defaults to WRITE_TRUNCATE.
	ExportInsightsDataRequest_WRITE_DISPOSITION_UNSPECIFIED ExportInsightsDataRequest_WriteDisposition = 0
	// If the table already exists, BigQuery will overwrite the table data and
	// use the schema from the load.
	ExportInsightsDataRequest_WRITE_TRUNCATE ExportInsightsDataRequest_WriteDisposition = 1
	// If the table already exists, BigQuery will append data to the table.
	ExportInsightsDataRequest_WRITE_APPEND ExportInsightsDataRequest_WriteDisposition = 2
)

// Enum value maps for ExportInsightsDataRequest_WriteDisposition.
var (
	ExportInsightsDataRequest_WriteDisposition_name = map[int32]string{
		0: "WRITE_DISPOSITION_UNSPECIFIED",
		1: "WRITE_TRUNCATE",
		2: "WRITE_APPEND",
	}
	ExportInsightsDataRequest_WriteDisposition_value = map[string]int32{
		"WRITE_DISPOSITION_UNSPECIFIED": 0,
		"WRITE_TRUNCATE":                1,
		"WRITE_APPEND":                  2,
	}
)

func (x ExportInsightsDataRequest_WriteDisposition) Enum() *ExportInsightsDataRequest_WriteDisposition {
	p := new(ExportInsightsDataRequest_WriteDisposition)
	*p = x
	return p
}

func (x ExportInsightsDataRequest_WriteDisposition) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExportInsightsDataRequest_WriteDisposition) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_enumTypes[2].Descriptor()
}

func (ExportInsightsDataRequest_WriteDisposition) Type() protoreflect.EnumType {
	return &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_enumTypes[2]
}

func (x ExportInsightsDataRequest_WriteDisposition) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExportInsightsDataRequest_WriteDisposition.Descriptor instead.
func (ExportInsightsDataRequest_WriteDisposition) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{25, 0}
}

// The request for calculating conversation statistics.
type CalculateStatsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The location of the conversations.
	Location string `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
	// A filter to reduce results to a specific subset. This field is useful for
	// getting statistics about conversations with specific properties.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *CalculateStatsRequest) Reset() {
	*x = CalculateStatsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CalculateStatsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CalculateStatsRequest) ProtoMessage() {}

func (x *CalculateStatsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CalculateStatsRequest.ProtoReflect.Descriptor instead.
func (*CalculateStatsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{0}
}

func (x *CalculateStatsRequest) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *CalculateStatsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// The response for calculating conversation statistics.
type CalculateStatsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The average duration of all conversations. The average is calculated using
	// only conversations that have a time duration.
	AverageDuration *durationpb.Duration `protobuf:"bytes,1,opt,name=average_duration,json=averageDuration,proto3" json:"average_duration,omitempty"`
	// The average number of turns per conversation.
	AverageTurnCount int32 `protobuf:"varint,2,opt,name=average_turn_count,json=averageTurnCount,proto3" json:"average_turn_count,omitempty"`
	// The total number of conversations.
	ConversationCount int32 `protobuf:"varint,3,opt,name=conversation_count,json=conversationCount,proto3" json:"conversation_count,omitempty"`
	// A map associating each smart highlighter display name with its respective
	// number of matches in the set of conversations.
	SmartHighlighterMatches map[string]int32 `protobuf:"bytes,4,rep,name=smart_highlighter_matches,json=smartHighlighterMatches,proto3" json:"smart_highlighter_matches,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// A map associating each custom highlighter resource name with its respective
	// number of matches in the set of conversations.
	CustomHighlighterMatches map[string]int32 `protobuf:"bytes,5,rep,name=custom_highlighter_matches,json=customHighlighterMatches,proto3" json:"custom_highlighter_matches,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// A map associating each issue resource name with its respective number of
	// matches in the set of conversations. Key has the format:
	// `projects/<Project-ID>/locations/<Location-ID>/issueModels/<Issue-Model-ID>/issues/<Issue-ID>`
	// Deprecated, use `issue_matches_stats` field instead.
	//
	// Deprecated: Marked as deprecated in google/cloud/contactcenterinsights/v1/contact_center_insights.proto.
	IssueMatches map[string]int32 `protobuf:"bytes,6,rep,name=issue_matches,json=issueMatches,proto3" json:"issue_matches,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// A map associating each issue resource name with its respective number of
	// matches in the set of conversations. Key has the format:
	// `projects/<Project-ID>/locations/<Location-ID>/issueModels/<Issue-Model-ID>/issues/<Issue-ID>`
	IssueMatchesStats map[string]*IssueModelLabelStats_IssueStats `protobuf:"bytes,8,rep,name=issue_matches_stats,json=issueMatchesStats,proto3" json:"issue_matches_stats,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// A time series representing the count of conversations created over time
	// that match that requested filter criteria.
	ConversationCountTimeSeries *CalculateStatsResponse_TimeSeries `protobuf:"bytes,7,opt,name=conversation_count_time_series,json=conversationCountTimeSeries,proto3" json:"conversation_count_time_series,omitempty"`
}

func (x *CalculateStatsResponse) Reset() {
	*x = CalculateStatsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CalculateStatsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CalculateStatsResponse) ProtoMessage() {}

func (x *CalculateStatsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CalculateStatsResponse.ProtoReflect.Descriptor instead.
func (*CalculateStatsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{1}
}

func (x *CalculateStatsResponse) GetAverageDuration() *durationpb.Duration {
	if x != nil {
		return x.AverageDuration
	}
	return nil
}

func (x *CalculateStatsResponse) GetAverageTurnCount() int32 {
	if x != nil {
		return x.AverageTurnCount
	}
	return 0
}

func (x *CalculateStatsResponse) GetConversationCount() int32 {
	if x != nil {
		return x.ConversationCount
	}
	return 0
}

func (x *CalculateStatsResponse) GetSmartHighlighterMatches() map[string]int32 {
	if x != nil {
		return x.SmartHighlighterMatches
	}
	return nil
}

func (x *CalculateStatsResponse) GetCustomHighlighterMatches() map[string]int32 {
	if x != nil {
		return x.CustomHighlighterMatches
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/contactcenterinsights/v1/contact_center_insights.proto.
func (x *CalculateStatsResponse) GetIssueMatches() map[string]int32 {
	if x != nil {
		return x.IssueMatches
	}
	return nil
}

func (x *CalculateStatsResponse) GetIssueMatchesStats() map[string]*IssueModelLabelStats_IssueStats {
	if x != nil {
		return x.IssueMatchesStats
	}
	return nil
}

func (x *CalculateStatsResponse) GetConversationCountTimeSeries() *CalculateStatsResponse_TimeSeries {
	if x != nil {
		return x.ConversationCountTimeSeries
	}
	return nil
}

// Metadata for a create analysis operation.
type CreateAnalysisOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. The Conversation that this Analysis Operation belongs to.
	Conversation string `protobuf:"bytes,3,opt,name=conversation,proto3" json:"conversation,omitempty"`
	// Output only. The annotator selector used for the analysis (if any).
	AnnotatorSelector *AnnotatorSelector `protobuf:"bytes,4,opt,name=annotator_selector,json=annotatorSelector,proto3" json:"annotator_selector,omitempty"`
}

func (x *CreateAnalysisOperationMetadata) Reset() {
	*x = CreateAnalysisOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateAnalysisOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAnalysisOperationMetadata) ProtoMessage() {}

func (x *CreateAnalysisOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAnalysisOperationMetadata.ProtoReflect.Descriptor instead.
func (*CreateAnalysisOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{2}
}

func (x *CreateAnalysisOperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *CreateAnalysisOperationMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *CreateAnalysisOperationMetadata) GetConversation() string {
	if x != nil {
		return x.Conversation
	}
	return ""
}

func (x *CreateAnalysisOperationMetadata) GetAnnotatorSelector() *AnnotatorSelector {
	if x != nil {
		return x.AnnotatorSelector
	}
	return nil
}

// Request to create a conversation.
type CreateConversationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the conversation.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The conversation resource to create.
	Conversation *Conversation `protobuf:"bytes,2,opt,name=conversation,proto3" json:"conversation,omitempty"`
	// A unique ID for the new conversation. This ID will become the final
	// component of the conversation's resource name. If no ID is specified, a
	// server-generated ID will be used.
	//
	// This value should be 4-64 characters and must match the regular
	// expression `^[a-z0-9-]{4,64}$`. Valid characters are `[a-z][0-9]-`
	ConversationId string `protobuf:"bytes,3,opt,name=conversation_id,json=conversationId,proto3" json:"conversation_id,omitempty"`
}

func (x *CreateConversationRequest) Reset() {
	*x = CreateConversationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateConversationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateConversationRequest) ProtoMessage() {}

func (x *CreateConversationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateConversationRequest.ProtoReflect.Descriptor instead.
func (*CreateConversationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{3}
}

func (x *CreateConversationRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateConversationRequest) GetConversation() *Conversation {
	if x != nil {
		return x.Conversation
	}
	return nil
}

func (x *CreateConversationRequest) GetConversationId() string {
	if x != nil {
		return x.ConversationId
	}
	return ""
}

// Request to upload a conversation.
type UploadConversationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the conversation.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The conversation resource to create.
	Conversation *Conversation `protobuf:"bytes,2,opt,name=conversation,proto3" json:"conversation,omitempty"`
	// Optional. A unique ID for the new conversation. This ID will become the
	// final component of the conversation's resource name. If no ID is specified,
	// a server-generated ID will be used.
	//
	// This value should be 4-64 characters and must match the regular
	// expression `^[a-z0-9-]{4,64}$`. Valid characters are `[a-z][0-9]-`
	ConversationId string `protobuf:"bytes,3,opt,name=conversation_id,json=conversationId,proto3" json:"conversation_id,omitempty"`
	// Optional. DLP settings for transcript redaction. Will default to the config
	// specified in Settings.
	RedactionConfig *RedactionConfig `protobuf:"bytes,4,opt,name=redaction_config,json=redactionConfig,proto3" json:"redaction_config,omitempty"`
	// Optional. Speech-to-Text configuration. Will default to the config
	// specified in Settings.
	SpeechConfig *SpeechConfig `protobuf:"bytes,11,opt,name=speech_config,json=speechConfig,proto3" json:"speech_config,omitempty"`
}

func (x *UploadConversationRequest) Reset() {
	*x = UploadConversationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UploadConversationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UploadConversationRequest) ProtoMessage() {}

func (x *UploadConversationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UploadConversationRequest.ProtoReflect.Descriptor instead.
func (*UploadConversationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{4}
}

func (x *UploadConversationRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *UploadConversationRequest) GetConversation() *Conversation {
	if x != nil {
		return x.Conversation
	}
	return nil
}

func (x *UploadConversationRequest) GetConversationId() string {
	if x != nil {
		return x.ConversationId
	}
	return ""
}

func (x *UploadConversationRequest) GetRedactionConfig() *RedactionConfig {
	if x != nil {
		return x.RedactionConfig
	}
	return nil
}

func (x *UploadConversationRequest) GetSpeechConfig() *SpeechConfig {
	if x != nil {
		return x.SpeechConfig
	}
	return nil
}

// The metadata for an UploadConversation operation.
type UploadConversationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. The original request.
	Request *UploadConversationRequest `protobuf:"bytes,3,opt,name=request,proto3" json:"request,omitempty"`
	// Output only. The operation name for a successfully created analysis
	// operation, if any.
	AnalysisOperation string `protobuf:"bytes,4,opt,name=analysis_operation,json=analysisOperation,proto3" json:"analysis_operation,omitempty"`
	// Output only. The redaction config applied to the uploaded conversation.
	AppliedRedactionConfig *RedactionConfig `protobuf:"bytes,5,opt,name=applied_redaction_config,json=appliedRedactionConfig,proto3" json:"applied_redaction_config,omitempty"`
}

func (x *UploadConversationMetadata) Reset() {
	*x = UploadConversationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UploadConversationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UploadConversationMetadata) ProtoMessage() {}

func (x *UploadConversationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UploadConversationMetadata.ProtoReflect.Descriptor instead.
func (*UploadConversationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{5}
}

func (x *UploadConversationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *UploadConversationMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *UploadConversationMetadata) GetRequest() *UploadConversationRequest {
	if x != nil {
		return x.Request
	}
	return nil
}

func (x *UploadConversationMetadata) GetAnalysisOperation() string {
	if x != nil {
		return x.AnalysisOperation
	}
	return ""
}

func (x *UploadConversationMetadata) GetAppliedRedactionConfig() *RedactionConfig {
	if x != nil {
		return x.AppliedRedactionConfig
	}
	return nil
}

// Request to list conversations.
type ListConversationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the conversation.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of conversations to return in the response. A valid page
	// size ranges from 0 to 1,000 inclusive. If the page size is zero or
	// unspecified, a default page size of 100 will be chosen. Note that a call
	// might return fewer results than the requested page size.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value returned by the last `ListConversationsResponse`. This value
	// indicates that this is a continuation of a prior `ListConversations` call
	// and that the system should return the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter to reduce results to a specific subset. Useful for querying
	// conversations with specific properties.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// The level of details of the conversation. Default is `BASIC`.
	View ConversationView `protobuf:"varint,5,opt,name=view,proto3,enum=google.cloud.contactcenterinsights.v1.ConversationView" json:"view,omitempty"`
}

func (x *ListConversationsRequest) Reset() {
	*x = ListConversationsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListConversationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConversationsRequest) ProtoMessage() {}

func (x *ListConversationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConversationsRequest.ProtoReflect.Descriptor instead.
func (*ListConversationsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{6}
}

func (x *ListConversationsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListConversationsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListConversationsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListConversationsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListConversationsRequest) GetView() ConversationView {
	if x != nil {
		return x.View
	}
	return ConversationView_CONVERSATION_VIEW_UNSPECIFIED
}

// The response of listing conversations.
type ListConversationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The conversations that match the request.
	Conversations []*Conversation `protobuf:"bytes,1,rep,name=conversations,proto3" json:"conversations,omitempty"`
	// A token which can be sent as `page_token` to retrieve the next page. If
	// this field is set, it means there is another page available. If it is not
	// set, it means no other pages are available.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListConversationsResponse) Reset() {
	*x = ListConversationsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListConversationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConversationsResponse) ProtoMessage() {}

func (x *ListConversationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConversationsResponse.ProtoReflect.Descriptor instead.
func (*ListConversationsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{7}
}

func (x *ListConversationsResponse) GetConversations() []*Conversation {
	if x != nil {
		return x.Conversations
	}
	return nil
}

func (x *ListConversationsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request to get a conversation.
type GetConversationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the conversation to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The level of details of the conversation. Default is `FULL`.
	View ConversationView `protobuf:"varint,2,opt,name=view,proto3,enum=google.cloud.contactcenterinsights.v1.ConversationView" json:"view,omitempty"`
}

func (x *GetConversationRequest) Reset() {
	*x = GetConversationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetConversationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetConversationRequest) ProtoMessage() {}

func (x *GetConversationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetConversationRequest.ProtoReflect.Descriptor instead.
func (*GetConversationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{8}
}

func (x *GetConversationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetConversationRequest) GetView() ConversationView {
	if x != nil {
		return x.View
	}
	return ConversationView_CONVERSATION_VIEW_UNSPECIFIED
}

// The request to update a conversation.
type UpdateConversationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The new values for the conversation.
	Conversation *Conversation `protobuf:"bytes,1,opt,name=conversation,proto3" json:"conversation,omitempty"`
	// The list of fields to be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateConversationRequest) Reset() {
	*x = UpdateConversationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateConversationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateConversationRequest) ProtoMessage() {}

func (x *UpdateConversationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateConversationRequest.ProtoReflect.Descriptor instead.
func (*UpdateConversationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{9}
}

func (x *UpdateConversationRequest) GetConversation() *Conversation {
	if x != nil {
		return x.Conversation
	}
	return nil
}

func (x *UpdateConversationRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The request to delete a conversation.
type DeleteConversationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the conversation to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If set to true, all of this conversation's analyses will also be deleted.
	// Otherwise, the request will only succeed if the conversation has no
	// analyses.
	Force bool `protobuf:"varint,2,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteConversationRequest) Reset() {
	*x = DeleteConversationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteConversationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteConversationRequest) ProtoMessage() {}

func (x *DeleteConversationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteConversationRequest.ProtoReflect.Descriptor instead.
func (*DeleteConversationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{10}
}

func (x *DeleteConversationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteConversationRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// The request to ingest conversations.
type IngestConversationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for an external data store containing objects that will
	// be converted to conversations.
	//
	// Types that are assignable to Source:
	//	*IngestConversationsRequest_GcsSource_
	Source isIngestConversationsRequest_Source `protobuf_oneof:"source"`
	// Configuration for converting individual `source` objects to conversations.
	//
	// Types that are assignable to ObjectConfig:
	//	*IngestConversationsRequest_TranscriptObjectConfig_
	ObjectConfig isIngestConversationsRequest_ObjectConfig `protobuf_oneof:"object_config"`
	// Required. The parent resource for new conversations.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Configuration that applies to all conversations.
	ConversationConfig *IngestConversationsRequest_ConversationConfig `protobuf:"bytes,4,opt,name=conversation_config,json=conversationConfig,proto3" json:"conversation_config,omitempty"`
	// Optional. DLP settings for transcript redaction. Optional, will default to
	// the config specified in Settings.
	RedactionConfig *RedactionConfig `protobuf:"bytes,5,opt,name=redaction_config,json=redactionConfig,proto3" json:"redaction_config,omitempty"`
	// Optional. Default Speech-to-Text configuration. Optional, will default to
	// the config specified in Settings.
	SpeechConfig *SpeechConfig `protobuf:"bytes,6,opt,name=speech_config,json=speechConfig,proto3" json:"speech_config,omitempty"`
}

func (x *IngestConversationsRequest) Reset() {
	*x = IngestConversationsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IngestConversationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IngestConversationsRequest) ProtoMessage() {}

func (x *IngestConversationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IngestConversationsRequest.ProtoReflect.Descriptor instead.
func (*IngestConversationsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{11}
}

func (m *IngestConversationsRequest) GetSource() isIngestConversationsRequest_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *IngestConversationsRequest) GetGcsSource() *IngestConversationsRequest_GcsSource {
	if x, ok := x.GetSource().(*IngestConversationsRequest_GcsSource_); ok {
		return x.GcsSource
	}
	return nil
}

func (m *IngestConversationsRequest) GetObjectConfig() isIngestConversationsRequest_ObjectConfig {
	if m != nil {
		return m.ObjectConfig
	}
	return nil
}

func (x *IngestConversationsRequest) GetTranscriptObjectConfig() *IngestConversationsRequest_TranscriptObjectConfig {
	if x, ok := x.GetObjectConfig().(*IngestConversationsRequest_TranscriptObjectConfig_); ok {
		return x.TranscriptObjectConfig
	}
	return nil
}

func (x *IngestConversationsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *IngestConversationsRequest) GetConversationConfig() *IngestConversationsRequest_ConversationConfig {
	if x != nil {
		return x.ConversationConfig
	}
	return nil
}

func (x *IngestConversationsRequest) GetRedactionConfig() *RedactionConfig {
	if x != nil {
		return x.RedactionConfig
	}
	return nil
}

func (x *IngestConversationsRequest) GetSpeechConfig() *SpeechConfig {
	if x != nil {
		return x.SpeechConfig
	}
	return nil
}

type isIngestConversationsRequest_Source interface {
	isIngestConversationsRequest_Source()
}

type IngestConversationsRequest_GcsSource_ struct {
	// A cloud storage bucket source. Note that any previously ingested objects
	// from the source will be skipped to avoid duplication.
	GcsSource *IngestConversationsRequest_GcsSource `protobuf:"bytes,2,opt,name=gcs_source,json=gcsSource,proto3,oneof"`
}

func (*IngestConversationsRequest_GcsSource_) isIngestConversationsRequest_Source() {}

type isIngestConversationsRequest_ObjectConfig interface {
	isIngestConversationsRequest_ObjectConfig()
}

type IngestConversationsRequest_TranscriptObjectConfig_ struct {
	// Configuration for when `source` contains conversation transcripts.
	TranscriptObjectConfig *IngestConversationsRequest_TranscriptObjectConfig `protobuf:"bytes,3,opt,name=transcript_object_config,json=transcriptObjectConfig,proto3,oneof"`
}

func (*IngestConversationsRequest_TranscriptObjectConfig_) isIngestConversationsRequest_ObjectConfig() {
}

// The metadata for an IngestConversations operation.
type IngestConversationsMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. The original request for ingest.
	Request *IngestConversationsRequest `protobuf:"bytes,3,opt,name=request,proto3" json:"request,omitempty"`
	// Output only. Partial errors during ingest operation that might cause the
	// operation output to be incomplete.
	PartialErrors []*status.Status `protobuf:"bytes,4,rep,name=partial_errors,json=partialErrors,proto3" json:"partial_errors,omitempty"`
	// Output only. Statistics for IngestConversations operation.
	IngestConversationsStats *IngestConversationsMetadata_IngestConversationsStats `protobuf:"bytes,5,opt,name=ingest_conversations_stats,json=ingestConversationsStats,proto3" json:"ingest_conversations_stats,omitempty"`
}

func (x *IngestConversationsMetadata) Reset() {
	*x = IngestConversationsMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IngestConversationsMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IngestConversationsMetadata) ProtoMessage() {}

func (x *IngestConversationsMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IngestConversationsMetadata.ProtoReflect.Descriptor instead.
func (*IngestConversationsMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{12}
}

func (x *IngestConversationsMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *IngestConversationsMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *IngestConversationsMetadata) GetRequest() *IngestConversationsRequest {
	if x != nil {
		return x.Request
	}
	return nil
}

func (x *IngestConversationsMetadata) GetPartialErrors() []*status.Status {
	if x != nil {
		return x.PartialErrors
	}
	return nil
}

func (x *IngestConversationsMetadata) GetIngestConversationsStats() *IngestConversationsMetadata_IngestConversationsStats {
	if x != nil {
		return x.IngestConversationsStats
	}
	return nil
}

// The response to an IngestConversations operation.
type IngestConversationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *IngestConversationsResponse) Reset() {
	*x = IngestConversationsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IngestConversationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IngestConversationsResponse) ProtoMessage() {}

func (x *IngestConversationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IngestConversationsResponse.ProtoReflect.Descriptor instead.
func (*IngestConversationsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{13}
}

// The request to create an analysis.
type CreateAnalysisRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the analysis.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The analysis to create.
	Analysis *Analysis `protobuf:"bytes,2,opt,name=analysis,proto3" json:"analysis,omitempty"`
}

func (x *CreateAnalysisRequest) Reset() {
	*x = CreateAnalysisRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateAnalysisRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAnalysisRequest) ProtoMessage() {}

func (x *CreateAnalysisRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAnalysisRequest.ProtoReflect.Descriptor instead.
func (*CreateAnalysisRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{14}
}

func (x *CreateAnalysisRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateAnalysisRequest) GetAnalysis() *Analysis {
	if x != nil {
		return x.Analysis
	}
	return nil
}

// The request to list analyses.
type ListAnalysesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the analyses.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of analyses to return in the response. If this
	// value is zero, the service will select a default size. A call might return
	// fewer objects than requested. A non-empty `next_page_token` in the response
	// indicates that more data is available.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value returned by the last `ListAnalysesResponse`; indicates
	// that this is a continuation of a prior `ListAnalyses` call and
	// the system should return the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter to reduce results to a specific subset. Useful for querying
	// conversations with specific properties.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListAnalysesRequest) Reset() {
	*x = ListAnalysesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAnalysesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAnalysesRequest) ProtoMessage() {}

func (x *ListAnalysesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAnalysesRequest.ProtoReflect.Descriptor instead.
func (*ListAnalysesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{15}
}

func (x *ListAnalysesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAnalysesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAnalysesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListAnalysesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// The response to list analyses.
type ListAnalysesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The analyses that match the request.
	Analyses []*Analysis `protobuf:"bytes,1,rep,name=analyses,proto3" json:"analyses,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAnalysesResponse) Reset() {
	*x = ListAnalysesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAnalysesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAnalysesResponse) ProtoMessage() {}

func (x *ListAnalysesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAnalysesResponse.ProtoReflect.Descriptor instead.
func (*ListAnalysesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{16}
}

func (x *ListAnalysesResponse) GetAnalyses() []*Analysis {
	if x != nil {
		return x.Analyses
	}
	return nil
}

func (x *ListAnalysesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request to get an analysis.
type GetAnalysisRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the analysis to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAnalysisRequest) Reset() {
	*x = GetAnalysisRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAnalysisRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAnalysisRequest) ProtoMessage() {}

func (x *GetAnalysisRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAnalysisRequest.ProtoReflect.Descriptor instead.
func (*GetAnalysisRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{17}
}

func (x *GetAnalysisRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request to delete an analysis.
type DeleteAnalysisRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the analysis to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteAnalysisRequest) Reset() {
	*x = DeleteAnalysisRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteAnalysisRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAnalysisRequest) ProtoMessage() {}

func (x *DeleteAnalysisRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAnalysisRequest.ProtoReflect.Descriptor instead.
func (*DeleteAnalysisRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{18}
}

func (x *DeleteAnalysisRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request to analyze conversations in bulk.
type BulkAnalyzeConversationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource to create analyses in.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Filter used to select the subset of conversations to analyze.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Required. Percentage of selected conversation to analyze, between
	// [0, 100].
	AnalysisPercentage float32 `protobuf:"fixed32,3,opt,name=analysis_percentage,json=analysisPercentage,proto3" json:"analysis_percentage,omitempty"`
	// To select the annotators to run and the phrase matchers to use
	// (if any). If not specified, all annotators will be run.
	AnnotatorSelector *AnnotatorSelector `protobuf:"bytes,8,opt,name=annotator_selector,json=annotatorSelector,proto3" json:"annotator_selector,omitempty"`
}

func (x *BulkAnalyzeConversationsRequest) Reset() {
	*x = BulkAnalyzeConversationsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BulkAnalyzeConversationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BulkAnalyzeConversationsRequest) ProtoMessage() {}

func (x *BulkAnalyzeConversationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BulkAnalyzeConversationsRequest.ProtoReflect.Descriptor instead.
func (*BulkAnalyzeConversationsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{19}
}

func (x *BulkAnalyzeConversationsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BulkAnalyzeConversationsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *BulkAnalyzeConversationsRequest) GetAnalysisPercentage() float32 {
	if x != nil {
		return x.AnalysisPercentage
	}
	return 0
}

func (x *BulkAnalyzeConversationsRequest) GetAnnotatorSelector() *AnnotatorSelector {
	if x != nil {
		return x.AnnotatorSelector
	}
	return nil
}

// The metadata for a bulk analyze conversations operation.
type BulkAnalyzeConversationsMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The original request for bulk analyze.
	Request *BulkAnalyzeConversationsRequest `protobuf:"bytes,3,opt,name=request,proto3" json:"request,omitempty"`
	// The number of requested analyses that have completed successfully so far.
	CompletedAnalysesCount int32 `protobuf:"varint,4,opt,name=completed_analyses_count,json=completedAnalysesCount,proto3" json:"completed_analyses_count,omitempty"`
	// The number of requested analyses that have failed so far.
	FailedAnalysesCount int32 `protobuf:"varint,5,opt,name=failed_analyses_count,json=failedAnalysesCount,proto3" json:"failed_analyses_count,omitempty"`
	// Total number of analyses requested. Computed by the number of conversations
	// returned by `filter` multiplied by `analysis_percentage` in the request.
	TotalRequestedAnalysesCount int32 `protobuf:"varint,6,opt,name=total_requested_analyses_count,json=totalRequestedAnalysesCount,proto3" json:"total_requested_analyses_count,omitempty"`
	// Output only. Partial errors during bulk analyze operation that might cause
	// the operation output to be incomplete.
	PartialErrors []*status.Status `protobuf:"bytes,7,rep,name=partial_errors,json=partialErrors,proto3" json:"partial_errors,omitempty"`
}

func (x *BulkAnalyzeConversationsMetadata) Reset() {
	*x = BulkAnalyzeConversationsMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BulkAnalyzeConversationsMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BulkAnalyzeConversationsMetadata) ProtoMessage() {}

func (x *BulkAnalyzeConversationsMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BulkAnalyzeConversationsMetadata.ProtoReflect.Descriptor instead.
func (*BulkAnalyzeConversationsMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{20}
}

func (x *BulkAnalyzeConversationsMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *BulkAnalyzeConversationsMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *BulkAnalyzeConversationsMetadata) GetRequest() *BulkAnalyzeConversationsRequest {
	if x != nil {
		return x.Request
	}
	return nil
}

func (x *BulkAnalyzeConversationsMetadata) GetCompletedAnalysesCount() int32 {
	if x != nil {
		return x.CompletedAnalysesCount
	}
	return 0
}

func (x *BulkAnalyzeConversationsMetadata) GetFailedAnalysesCount() int32 {
	if x != nil {
		return x.FailedAnalysesCount
	}
	return 0
}

func (x *BulkAnalyzeConversationsMetadata) GetTotalRequestedAnalysesCount() int32 {
	if x != nil {
		return x.TotalRequestedAnalysesCount
	}
	return 0
}

func (x *BulkAnalyzeConversationsMetadata) GetPartialErrors() []*status.Status {
	if x != nil {
		return x.PartialErrors
	}
	return nil
}

// The response for a bulk analyze conversations operation.
type BulkAnalyzeConversationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Count of successful analyses.
	SuccessfulAnalysisCount int32 `protobuf:"varint,1,opt,name=successful_analysis_count,json=successfulAnalysisCount,proto3" json:"successful_analysis_count,omitempty"`
	// Count of failed analyses.
	FailedAnalysisCount int32 `protobuf:"varint,2,opt,name=failed_analysis_count,json=failedAnalysisCount,proto3" json:"failed_analysis_count,omitempty"`
}

func (x *BulkAnalyzeConversationsResponse) Reset() {
	*x = BulkAnalyzeConversationsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BulkAnalyzeConversationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BulkAnalyzeConversationsResponse) ProtoMessage() {}

func (x *BulkAnalyzeConversationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BulkAnalyzeConversationsResponse.ProtoReflect.Descriptor instead.
func (*BulkAnalyzeConversationsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{21}
}

func (x *BulkAnalyzeConversationsResponse) GetSuccessfulAnalysisCount() int32 {
	if x != nil {
		return x.SuccessfulAnalysisCount
	}
	return 0
}

func (x *BulkAnalyzeConversationsResponse) GetFailedAnalysisCount() int32 {
	if x != nil {
		return x.FailedAnalysisCount
	}
	return 0
}

// The request to delete conversations in bulk.
type BulkDeleteConversationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource to delete conversations from.
	// Format:
	// projects/{project}/locations/{location}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Filter used to select the subset of conversations to delete.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Maximum number of conversations to delete.
	MaxDeleteCount int32 `protobuf:"varint,3,opt,name=max_delete_count,json=maxDeleteCount,proto3" json:"max_delete_count,omitempty"`
	// If set to true, all of this conversation's analyses will also be deleted.
	// Otherwise, the request will only succeed if the conversation has no
	// analyses.
	Force bool `protobuf:"varint,4,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *BulkDeleteConversationsRequest) Reset() {
	*x = BulkDeleteConversationsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BulkDeleteConversationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BulkDeleteConversationsRequest) ProtoMessage() {}

func (x *BulkDeleteConversationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BulkDeleteConversationsRequest.ProtoReflect.Descriptor instead.
func (*BulkDeleteConversationsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{22}
}

func (x *BulkDeleteConversationsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BulkDeleteConversationsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *BulkDeleteConversationsRequest) GetMaxDeleteCount() int32 {
	if x != nil {
		return x.MaxDeleteCount
	}
	return 0
}

func (x *BulkDeleteConversationsRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// The metadata for a bulk delete conversations operation.
type BulkDeleteConversationsMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The original request for bulk delete.
	Request *BulkDeleteConversationsRequest `protobuf:"bytes,3,opt,name=request,proto3" json:"request,omitempty"`
	// Partial errors during bulk delete conversations operation that might cause
	// the operation output to be incomplete.
	PartialErrors []*status.Status `protobuf:"bytes,4,rep,name=partial_errors,json=partialErrors,proto3" json:"partial_errors,omitempty"`
}

func (x *BulkDeleteConversationsMetadata) Reset() {
	*x = BulkDeleteConversationsMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BulkDeleteConversationsMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BulkDeleteConversationsMetadata) ProtoMessage() {}

func (x *BulkDeleteConversationsMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BulkDeleteConversationsMetadata.ProtoReflect.Descriptor instead.
func (*BulkDeleteConversationsMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{23}
}

func (x *BulkDeleteConversationsMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *BulkDeleteConversationsMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *BulkDeleteConversationsMetadata) GetRequest() *BulkDeleteConversationsRequest {
	if x != nil {
		return x.Request
	}
	return nil
}

func (x *BulkDeleteConversationsMetadata) GetPartialErrors() []*status.Status {
	if x != nil {
		return x.PartialErrors
	}
	return nil
}

// The response for a bulk delete conversations operation.
type BulkDeleteConversationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *BulkDeleteConversationsResponse) Reset() {
	*x = BulkDeleteConversationsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BulkDeleteConversationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BulkDeleteConversationsResponse) ProtoMessage() {}

func (x *BulkDeleteConversationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BulkDeleteConversationsResponse.ProtoReflect.Descriptor instead.
func (*BulkDeleteConversationsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{24}
}

// The request to export insights.
type ExportInsightsDataRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Exporter destination.
	//
	// Types that are assignable to Destination:
	//	*ExportInsightsDataRequest_BigQueryDestination_
	Destination isExportInsightsDataRequest_Destination `protobuf_oneof:"destination"`
	// Required. The parent resource to export data from.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// A filter to reduce results to a specific subset. Useful for exporting
	// conversations with specific properties.
	Filter string `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
	// A fully qualified KMS key name for BigQuery tables protected by CMEK.
	// Format:
	// projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key}/cryptoKeyVersions/{version}
	KmsKey string `protobuf:"bytes,4,opt,name=kms_key,json=kmsKey,proto3" json:"kms_key,omitempty"`
	// Options for what to do if the destination table already exists.
	WriteDisposition ExportInsightsDataRequest_WriteDisposition `protobuf:"varint,5,opt,name=write_disposition,json=writeDisposition,proto3,enum=google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest_WriteDisposition" json:"write_disposition,omitempty"`
}

func (x *ExportInsightsDataRequest) Reset() {
	*x = ExportInsightsDataRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportInsightsDataRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportInsightsDataRequest) ProtoMessage() {}

func (x *ExportInsightsDataRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportInsightsDataRequest.ProtoReflect.Descriptor instead.
func (*ExportInsightsDataRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{25}
}

func (m *ExportInsightsDataRequest) GetDestination() isExportInsightsDataRequest_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *ExportInsightsDataRequest) GetBigQueryDestination() *ExportInsightsDataRequest_BigQueryDestination {
	if x, ok := x.GetDestination().(*ExportInsightsDataRequest_BigQueryDestination_); ok {
		return x.BigQueryDestination
	}
	return nil
}

func (x *ExportInsightsDataRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ExportInsightsDataRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ExportInsightsDataRequest) GetKmsKey() string {
	if x != nil {
		return x.KmsKey
	}
	return ""
}

func (x *ExportInsightsDataRequest) GetWriteDisposition() ExportInsightsDataRequest_WriteDisposition {
	if x != nil {
		return x.WriteDisposition
	}
	return ExportInsightsDataRequest_WRITE_DISPOSITION_UNSPECIFIED
}

type isExportInsightsDataRequest_Destination interface {
	isExportInsightsDataRequest_Destination()
}

type ExportInsightsDataRequest_BigQueryDestination_ struct {
	// Specified if sink is a BigQuery table.
	BigQueryDestination *ExportInsightsDataRequest_BigQueryDestination `protobuf:"bytes,2,opt,name=big_query_destination,json=bigQueryDestination,proto3,oneof"`
}

func (*ExportInsightsDataRequest_BigQueryDestination_) isExportInsightsDataRequest_Destination() {}

// Metadata for an export insights operation.
type ExportInsightsDataMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The original request for export.
	Request *ExportInsightsDataRequest `protobuf:"bytes,3,opt,name=request,proto3" json:"request,omitempty"`
	// Partial errors during export operation that might cause the operation
	// output to be incomplete.
	PartialErrors []*status.Status `protobuf:"bytes,4,rep,name=partial_errors,json=partialErrors,proto3" json:"partial_errors,omitempty"`
}

func (x *ExportInsightsDataMetadata) Reset() {
	*x = ExportInsightsDataMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportInsightsDataMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportInsightsDataMetadata) ProtoMessage() {}

func (x *ExportInsightsDataMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportInsightsDataMetadata.ProtoReflect.Descriptor instead.
func (*ExportInsightsDataMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{26}
}

func (x *ExportInsightsDataMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ExportInsightsDataMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *ExportInsightsDataMetadata) GetRequest() *ExportInsightsDataRequest {
	if x != nil {
		return x.Request
	}
	return nil
}

func (x *ExportInsightsDataMetadata) GetPartialErrors() []*status.Status {
	if x != nil {
		return x.PartialErrors
	}
	return nil
}

// Response for an export insights operation.
type ExportInsightsDataResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ExportInsightsDataResponse) Reset() {
	*x = ExportInsightsDataResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportInsightsDataResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportInsightsDataResponse) ProtoMessage() {}

func (x *ExportInsightsDataResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportInsightsDataResponse.ProtoReflect.Descriptor instead.
func (*ExportInsightsDataResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{27}
}

// The request to create an issue model.
type CreateIssueModelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the issue model.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The issue model to create.
	IssueModel *IssueModel `protobuf:"bytes,2,opt,name=issue_model,json=issueModel,proto3" json:"issue_model,omitempty"`
}

func (x *CreateIssueModelRequest) Reset() {
	*x = CreateIssueModelRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateIssueModelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateIssueModelRequest) ProtoMessage() {}

func (x *CreateIssueModelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateIssueModelRequest.ProtoReflect.Descriptor instead.
func (*CreateIssueModelRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{28}
}

func (x *CreateIssueModelRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateIssueModelRequest) GetIssueModel() *IssueModel {
	if x != nil {
		return x.IssueModel
	}
	return nil
}

// Metadata for creating an issue model.
type CreateIssueModelMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The original request for creation.
	Request *CreateIssueModelRequest `protobuf:"bytes,3,opt,name=request,proto3" json:"request,omitempty"`
}

func (x *CreateIssueModelMetadata) Reset() {
	*x = CreateIssueModelMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateIssueModelMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateIssueModelMetadata) ProtoMessage() {}

func (x *CreateIssueModelMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateIssueModelMetadata.ProtoReflect.Descriptor instead.
func (*CreateIssueModelMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{29}
}

func (x *CreateIssueModelMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *CreateIssueModelMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *CreateIssueModelMetadata) GetRequest() *CreateIssueModelRequest {
	if x != nil {
		return x.Request
	}
	return nil
}

// The request to update an issue model.
type UpdateIssueModelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The new values for the issue model.
	IssueModel *IssueModel `protobuf:"bytes,1,opt,name=issue_model,json=issueModel,proto3" json:"issue_model,omitempty"`
	// The list of fields to be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateIssueModelRequest) Reset() {
	*x = UpdateIssueModelRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateIssueModelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateIssueModelRequest) ProtoMessage() {}

func (x *UpdateIssueModelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateIssueModelRequest.ProtoReflect.Descriptor instead.
func (*UpdateIssueModelRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{30}
}

func (x *UpdateIssueModelRequest) GetIssueModel() *IssueModel {
	if x != nil {
		return x.IssueModel
	}
	return nil
}

func (x *UpdateIssueModelRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request to list issue models.
type ListIssueModelsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the issue model.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *ListIssueModelsRequest) Reset() {
	*x = ListIssueModelsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListIssueModelsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListIssueModelsRequest) ProtoMessage() {}

func (x *ListIssueModelsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListIssueModelsRequest.ProtoReflect.Descriptor instead.
func (*ListIssueModelsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{31}
}

func (x *ListIssueModelsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// The response of listing issue models.
type ListIssueModelsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The issue models that match the request.
	IssueModels []*IssueModel `protobuf:"bytes,1,rep,name=issue_models,json=issueModels,proto3" json:"issue_models,omitempty"`
}

func (x *ListIssueModelsResponse) Reset() {
	*x = ListIssueModelsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListIssueModelsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListIssueModelsResponse) ProtoMessage() {}

func (x *ListIssueModelsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListIssueModelsResponse.ProtoReflect.Descriptor instead.
func (*ListIssueModelsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{32}
}

func (x *ListIssueModelsResponse) GetIssueModels() []*IssueModel {
	if x != nil {
		return x.IssueModels
	}
	return nil
}

// The request to get an issue model.
type GetIssueModelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the issue model to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetIssueModelRequest) Reset() {
	*x = GetIssueModelRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetIssueModelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetIssueModelRequest) ProtoMessage() {}

func (x *GetIssueModelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetIssueModelRequest.ProtoReflect.Descriptor instead.
func (*GetIssueModelRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{33}
}

func (x *GetIssueModelRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request to delete an issue model.
type DeleteIssueModelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the issue model to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteIssueModelRequest) Reset() {
	*x = DeleteIssueModelRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteIssueModelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteIssueModelRequest) ProtoMessage() {}

func (x *DeleteIssueModelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteIssueModelRequest.ProtoReflect.Descriptor instead.
func (*DeleteIssueModelRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{34}
}

func (x *DeleteIssueModelRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Metadata for deleting an issue model.
type DeleteIssueModelMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The original request for deletion.
	Request *DeleteIssueModelRequest `protobuf:"bytes,3,opt,name=request,proto3" json:"request,omitempty"`
}

func (x *DeleteIssueModelMetadata) Reset() {
	*x = DeleteIssueModelMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteIssueModelMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteIssueModelMetadata) ProtoMessage() {}

func (x *DeleteIssueModelMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteIssueModelMetadata.ProtoReflect.Descriptor instead.
func (*DeleteIssueModelMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{35}
}

func (x *DeleteIssueModelMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *DeleteIssueModelMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *DeleteIssueModelMetadata) GetRequest() *DeleteIssueModelRequest {
	if x != nil {
		return x.Request
	}
	return nil
}

// The request to deploy an issue model.
type DeployIssueModelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The issue model to deploy.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeployIssueModelRequest) Reset() {
	*x = DeployIssueModelRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeployIssueModelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployIssueModelRequest) ProtoMessage() {}

func (x *DeployIssueModelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployIssueModelRequest.ProtoReflect.Descriptor instead.
func (*DeployIssueModelRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{36}
}

func (x *DeployIssueModelRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The response to deploy an issue model.
type DeployIssueModelResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DeployIssueModelResponse) Reset() {
	*x = DeployIssueModelResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeployIssueModelResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployIssueModelResponse) ProtoMessage() {}

func (x *DeployIssueModelResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployIssueModelResponse.ProtoReflect.Descriptor instead.
func (*DeployIssueModelResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{37}
}

// Metadata for deploying an issue model.
type DeployIssueModelMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The original request for deployment.
	Request *DeployIssueModelRequest `protobuf:"bytes,3,opt,name=request,proto3" json:"request,omitempty"`
}

func (x *DeployIssueModelMetadata) Reset() {
	*x = DeployIssueModelMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeployIssueModelMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployIssueModelMetadata) ProtoMessage() {}

func (x *DeployIssueModelMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployIssueModelMetadata.ProtoReflect.Descriptor instead.
func (*DeployIssueModelMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{38}
}

func (x *DeployIssueModelMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *DeployIssueModelMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *DeployIssueModelMetadata) GetRequest() *DeployIssueModelRequest {
	if x != nil {
		return x.Request
	}
	return nil
}

// The request to undeploy an issue model.
type UndeployIssueModelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The issue model to undeploy.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *UndeployIssueModelRequest) Reset() {
	*x = UndeployIssueModelRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UndeployIssueModelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UndeployIssueModelRequest) ProtoMessage() {}

func (x *UndeployIssueModelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UndeployIssueModelRequest.ProtoReflect.Descriptor instead.
func (*UndeployIssueModelRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{39}
}

func (x *UndeployIssueModelRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The response to undeploy an issue model.
type UndeployIssueModelResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *UndeployIssueModelResponse) Reset() {
	*x = UndeployIssueModelResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UndeployIssueModelResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UndeployIssueModelResponse) ProtoMessage() {}

func (x *UndeployIssueModelResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UndeployIssueModelResponse.ProtoReflect.Descriptor instead.
func (*UndeployIssueModelResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{40}
}

// Metadata for undeploying an issue model.
type UndeployIssueModelMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The original request for undeployment.
	Request *UndeployIssueModelRequest `protobuf:"bytes,3,opt,name=request,proto3" json:"request,omitempty"`
}

func (x *UndeployIssueModelMetadata) Reset() {
	*x = UndeployIssueModelMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UndeployIssueModelMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UndeployIssueModelMetadata) ProtoMessage() {}

func (x *UndeployIssueModelMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UndeployIssueModelMetadata.ProtoReflect.Descriptor instead.
func (*UndeployIssueModelMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{41}
}

func (x *UndeployIssueModelMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *UndeployIssueModelMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *UndeployIssueModelMetadata) GetRequest() *UndeployIssueModelRequest {
	if x != nil {
		return x.Request
	}
	return nil
}

// The request to get an issue.
type GetIssueRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the issue to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetIssueRequest) Reset() {
	*x = GetIssueRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetIssueRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetIssueRequest) ProtoMessage() {}

func (x *GetIssueRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetIssueRequest.ProtoReflect.Descriptor instead.
func (*GetIssueRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{42}
}

func (x *GetIssueRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request to list issues.
type ListIssuesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the issue.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *ListIssuesRequest) Reset() {
	*x = ListIssuesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListIssuesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListIssuesRequest) ProtoMessage() {}

func (x *ListIssuesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListIssuesRequest.ProtoReflect.Descriptor instead.
func (*ListIssuesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{43}
}

func (x *ListIssuesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// The response of listing issues.
type ListIssuesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The issues that match the request.
	Issues []*Issue `protobuf:"bytes,1,rep,name=issues,proto3" json:"issues,omitempty"`
}

func (x *ListIssuesResponse) Reset() {
	*x = ListIssuesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListIssuesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListIssuesResponse) ProtoMessage() {}

func (x *ListIssuesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListIssuesResponse.ProtoReflect.Descriptor instead.
func (*ListIssuesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{44}
}

func (x *ListIssuesResponse) GetIssues() []*Issue {
	if x != nil {
		return x.Issues
	}
	return nil
}

// The request to update an issue.
type UpdateIssueRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The new values for the issue.
	Issue *Issue `protobuf:"bytes,1,opt,name=issue,proto3" json:"issue,omitempty"`
	// The list of fields to be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateIssueRequest) Reset() {
	*x = UpdateIssueRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateIssueRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateIssueRequest) ProtoMessage() {}

func (x *UpdateIssueRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateIssueRequest.ProtoReflect.Descriptor instead.
func (*UpdateIssueRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{45}
}

func (x *UpdateIssueRequest) GetIssue() *Issue {
	if x != nil {
		return x.Issue
	}
	return nil
}

func (x *UpdateIssueRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The request to delete an issue.
type DeleteIssueRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the issue to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteIssueRequest) Reset() {
	*x = DeleteIssueRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteIssueRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteIssueRequest) ProtoMessage() {}

func (x *DeleteIssueRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteIssueRequest.ProtoReflect.Descriptor instead.
func (*DeleteIssueRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{46}
}

func (x *DeleteIssueRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request to get statistics of an issue model.
type CalculateIssueModelStatsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the issue model to query against.
	IssueModel string `protobuf:"bytes,1,opt,name=issue_model,json=issueModel,proto3" json:"issue_model,omitempty"`
}

func (x *CalculateIssueModelStatsRequest) Reset() {
	*x = CalculateIssueModelStatsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CalculateIssueModelStatsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CalculateIssueModelStatsRequest) ProtoMessage() {}

func (x *CalculateIssueModelStatsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CalculateIssueModelStatsRequest.ProtoReflect.Descriptor instead.
func (*CalculateIssueModelStatsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{47}
}

func (x *CalculateIssueModelStatsRequest) GetIssueModel() string {
	if x != nil {
		return x.IssueModel
	}
	return ""
}

// Response of querying an issue model's statistics.
type CalculateIssueModelStatsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The latest label statistics for the queried issue model. Includes results
	// on both training data and data labeled after deployment.
	CurrentStats *IssueModelLabelStats `protobuf:"bytes,4,opt,name=current_stats,json=currentStats,proto3" json:"current_stats,omitempty"`
}

func (x *CalculateIssueModelStatsResponse) Reset() {
	*x = CalculateIssueModelStatsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CalculateIssueModelStatsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CalculateIssueModelStatsResponse) ProtoMessage() {}

func (x *CalculateIssueModelStatsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CalculateIssueModelStatsResponse.ProtoReflect.Descriptor instead.
func (*CalculateIssueModelStatsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{48}
}

func (x *CalculateIssueModelStatsResponse) GetCurrentStats() *IssueModelLabelStats {
	if x != nil {
		return x.CurrentStats
	}
	return nil
}

// Request to create a phrase matcher.
type CreatePhraseMatcherRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the phrase matcher. Required. The location
	// to create a phrase matcher for. Format: `projects/<Project
	// ID>/locations/<Location ID>` or `projects/<Project
	// Number>/locations/<Location ID>`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The phrase matcher resource to create.
	PhraseMatcher *PhraseMatcher `protobuf:"bytes,2,opt,name=phrase_matcher,json=phraseMatcher,proto3" json:"phrase_matcher,omitempty"`
}

func (x *CreatePhraseMatcherRequest) Reset() {
	*x = CreatePhraseMatcherRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreatePhraseMatcherRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreatePhraseMatcherRequest) ProtoMessage() {}

func (x *CreatePhraseMatcherRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreatePhraseMatcherRequest.ProtoReflect.Descriptor instead.
func (*CreatePhraseMatcherRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{49}
}

func (x *CreatePhraseMatcherRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreatePhraseMatcherRequest) GetPhraseMatcher() *PhraseMatcher {
	if x != nil {
		return x.PhraseMatcher
	}
	return nil
}

// Request to list phrase matchers.
type ListPhraseMatchersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the phrase matcher.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of phrase matchers to return in the response. If this
	// value is zero, the service will select a default size. A call might return
	// fewer objects than requested. A non-empty `next_page_token` in the response
	// indicates that more data is available.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value returned by the last `ListPhraseMatchersResponse`. This value
	// indicates that this is a continuation of a prior `ListPhraseMatchers` call
	// and that the system should return the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter to reduce results to a specific subset. Useful for querying
	// phrase matchers with specific properties.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListPhraseMatchersRequest) Reset() {
	*x = ListPhraseMatchersRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPhraseMatchersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPhraseMatchersRequest) ProtoMessage() {}

func (x *ListPhraseMatchersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPhraseMatchersRequest.ProtoReflect.Descriptor instead.
func (*ListPhraseMatchersRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{50}
}

func (x *ListPhraseMatchersRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListPhraseMatchersRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListPhraseMatchersRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListPhraseMatchersRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// The response of listing phrase matchers.
type ListPhraseMatchersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The phrase matchers that match the request.
	PhraseMatchers []*PhraseMatcher `protobuf:"bytes,1,rep,name=phrase_matchers,json=phraseMatchers,proto3" json:"phrase_matchers,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListPhraseMatchersResponse) Reset() {
	*x = ListPhraseMatchersResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPhraseMatchersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPhraseMatchersResponse) ProtoMessage() {}

func (x *ListPhraseMatchersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPhraseMatchersResponse.ProtoReflect.Descriptor instead.
func (*ListPhraseMatchersResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{51}
}

func (x *ListPhraseMatchersResponse) GetPhraseMatchers() []*PhraseMatcher {
	if x != nil {
		return x.PhraseMatchers
	}
	return nil
}

func (x *ListPhraseMatchersResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request to get a a phrase matcher.
type GetPhraseMatcherRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the phrase matcher to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetPhraseMatcherRequest) Reset() {
	*x = GetPhraseMatcherRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetPhraseMatcherRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPhraseMatcherRequest) ProtoMessage() {}

func (x *GetPhraseMatcherRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPhraseMatcherRequest.ProtoReflect.Descriptor instead.
func (*GetPhraseMatcherRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{52}
}

func (x *GetPhraseMatcherRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request to delete a phrase matcher.
type DeletePhraseMatcherRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the phrase matcher to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeletePhraseMatcherRequest) Reset() {
	*x = DeletePhraseMatcherRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[53]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeletePhraseMatcherRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeletePhraseMatcherRequest) ProtoMessage() {}

func (x *DeletePhraseMatcherRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[53]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeletePhraseMatcherRequest.ProtoReflect.Descriptor instead.
func (*DeletePhraseMatcherRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{53}
}

func (x *DeletePhraseMatcherRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request to update a phrase matcher.
type UpdatePhraseMatcherRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The new values for the phrase matcher.
	PhraseMatcher *PhraseMatcher `protobuf:"bytes,1,opt,name=phrase_matcher,json=phraseMatcher,proto3" json:"phrase_matcher,omitempty"`
	// The list of fields to be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdatePhraseMatcherRequest) Reset() {
	*x = UpdatePhraseMatcherRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[54]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdatePhraseMatcherRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdatePhraseMatcherRequest) ProtoMessage() {}

func (x *UpdatePhraseMatcherRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[54]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdatePhraseMatcherRequest.ProtoReflect.Descriptor instead.
func (*UpdatePhraseMatcherRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{54}
}

func (x *UpdatePhraseMatcherRequest) GetPhraseMatcher() *PhraseMatcher {
	if x != nil {
		return x.PhraseMatcher
	}
	return nil
}

func (x *UpdatePhraseMatcherRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The request to get project-level settings.
type GetSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the settings resource to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSettingsRequest) Reset() {
	*x = GetSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[55]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSettingsRequest) ProtoMessage() {}

func (x *GetSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[55]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSettingsRequest.ProtoReflect.Descriptor instead.
func (*GetSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{55}
}

func (x *GetSettingsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request to update project-level settings.
type UpdateSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The new settings values.
	Settings *Settings `protobuf:"bytes,1,opt,name=settings,proto3" json:"settings,omitempty"`
	// Required. The list of fields to be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateSettingsRequest) Reset() {
	*x = UpdateSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[56]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSettingsRequest) ProtoMessage() {}

func (x *UpdateSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[56]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSettingsRequest.ProtoReflect.Descriptor instead.
func (*UpdateSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{56}
}

func (x *UpdateSettingsRequest) GetSettings() *Settings {
	if x != nil {
		return x.Settings
	}
	return nil
}

func (x *UpdateSettingsRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The request to create a view.
type CreateViewRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the view. Required. The location to create
	// a view for.
	// Format: `projects/<Project ID>/locations/<Location ID>` or
	// `projects/<Project Number>/locations/<Location ID>`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The view resource to create.
	View *View `protobuf:"bytes,2,opt,name=view,proto3" json:"view,omitempty"`
}

func (x *CreateViewRequest) Reset() {
	*x = CreateViewRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[57]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateViewRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateViewRequest) ProtoMessage() {}

func (x *CreateViewRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[57]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateViewRequest.ProtoReflect.Descriptor instead.
func (*CreateViewRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{57}
}

func (x *CreateViewRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateViewRequest) GetView() *View {
	if x != nil {
		return x.View
	}
	return nil
}

// The request to get a view.
type GetViewRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the view to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetViewRequest) Reset() {
	*x = GetViewRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[58]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetViewRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetViewRequest) ProtoMessage() {}

func (x *GetViewRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[58]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetViewRequest.ProtoReflect.Descriptor instead.
func (*GetViewRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{58}
}

func (x *GetViewRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request to list views.
type ListViewsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the views.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of views to return in the response. If this
	// value is zero, the service will select a default size. A call may return
	// fewer objects than requested. A non-empty `next_page_token` in the response
	// indicates that more data is available.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value returned by the last `ListViewsResponse`; indicates
	// that this is a continuation of a prior `ListViews` call and
	// the system should return the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListViewsRequest) Reset() {
	*x = ListViewsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[59]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListViewsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListViewsRequest) ProtoMessage() {}

func (x *ListViewsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[59]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListViewsRequest.ProtoReflect.Descriptor instead.
func (*ListViewsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{59}
}

func (x *ListViewsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListViewsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListViewsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response of listing views.
type ListViewsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The views that match the request.
	Views []*View `protobuf:"bytes,1,rep,name=views,proto3" json:"views,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListViewsResponse) Reset() {
	*x = ListViewsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[60]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListViewsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListViewsResponse) ProtoMessage() {}

func (x *ListViewsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[60]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListViewsResponse.ProtoReflect.Descriptor instead.
func (*ListViewsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{60}
}

func (x *ListViewsResponse) GetViews() []*View {
	if x != nil {
		return x.Views
	}
	return nil
}

func (x *ListViewsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request to update a view.
type UpdateViewRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The new view.
	View *View `protobuf:"bytes,1,opt,name=view,proto3" json:"view,omitempty"`
	// The list of fields to be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateViewRequest) Reset() {
	*x = UpdateViewRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[61]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateViewRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateViewRequest) ProtoMessage() {}

func (x *UpdateViewRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[61]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateViewRequest.ProtoReflect.Descriptor instead.
func (*UpdateViewRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{61}
}

func (x *UpdateViewRequest) GetView() *View {
	if x != nil {
		return x.View
	}
	return nil
}

func (x *UpdateViewRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The request to delete a view.
type DeleteViewRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the view to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteViewRequest) Reset() {
	*x = DeleteViewRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[62]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteViewRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteViewRequest) ProtoMessage() {}

func (x *DeleteViewRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[62]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteViewRequest.ProtoReflect.Descriptor instead.
func (*DeleteViewRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{62}
}

func (x *DeleteViewRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A time series representing conversations over time.
type CalculateStatsResponse_TimeSeries struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The duration of each interval.
	IntervalDuration *durationpb.Duration `protobuf:"bytes,1,opt,name=interval_duration,json=intervalDuration,proto3" json:"interval_duration,omitempty"`
	// An ordered list of intervals from earliest to latest, where each interval
	// represents the number of conversations that transpired during the time
	// window.
	Points []*CalculateStatsResponse_TimeSeries_Interval `protobuf:"bytes,2,rep,name=points,proto3" json:"points,omitempty"`
}

func (x *CalculateStatsResponse_TimeSeries) Reset() {
	*x = CalculateStatsResponse_TimeSeries{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[63]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CalculateStatsResponse_TimeSeries) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CalculateStatsResponse_TimeSeries) ProtoMessage() {}

func (x *CalculateStatsResponse_TimeSeries) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[63]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CalculateStatsResponse_TimeSeries.ProtoReflect.Descriptor instead.
func (*CalculateStatsResponse_TimeSeries) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{1, 0}
}

func (x *CalculateStatsResponse_TimeSeries) GetIntervalDuration() *durationpb.Duration {
	if x != nil {
		return x.IntervalDuration
	}
	return nil
}

func (x *CalculateStatsResponse_TimeSeries) GetPoints() []*CalculateStatsResponse_TimeSeries_Interval {
	if x != nil {
		return x.Points
	}
	return nil
}

// A single interval in a time series.
type CalculateStatsResponse_TimeSeries_Interval struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The start time of this interval.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The number of conversations created in this interval.
	ConversationCount int32 `protobuf:"varint,2,opt,name=conversation_count,json=conversationCount,proto3" json:"conversation_count,omitempty"`
}

func (x *CalculateStatsResponse_TimeSeries_Interval) Reset() {
	*x = CalculateStatsResponse_TimeSeries_Interval{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[68]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CalculateStatsResponse_TimeSeries_Interval) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CalculateStatsResponse_TimeSeries_Interval) ProtoMessage() {}

func (x *CalculateStatsResponse_TimeSeries_Interval) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[68]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CalculateStatsResponse_TimeSeries_Interval.ProtoReflect.Descriptor instead.
func (*CalculateStatsResponse_TimeSeries_Interval) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{1, 0, 0}
}

func (x *CalculateStatsResponse_TimeSeries_Interval) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *CalculateStatsResponse_TimeSeries_Interval) GetConversationCount() int32 {
	if x != nil {
		return x.ConversationCount
	}
	return 0
}

// Configuration for Cloud Storage bucket sources.
type IngestConversationsRequest_GcsSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Cloud Storage bucket containing source objects.
	BucketUri string `protobuf:"bytes,1,opt,name=bucket_uri,json=bucketUri,proto3" json:"bucket_uri,omitempty"`
	// Optional. Specifies the type of the objects in `bucket_uri`.
	BucketObjectType IngestConversationsRequest_GcsSource_BucketObjectType `protobuf:"varint,2,opt,name=bucket_object_type,json=bucketObjectType,proto3,enum=google.cloud.contactcenterinsights.v1.IngestConversationsRequest_GcsSource_BucketObjectType" json:"bucket_object_type,omitempty"`
}

func (x *IngestConversationsRequest_GcsSource) Reset() {
	*x = IngestConversationsRequest_GcsSource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[69]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IngestConversationsRequest_GcsSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IngestConversationsRequest_GcsSource) ProtoMessage() {}

func (x *IngestConversationsRequest_GcsSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[69]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IngestConversationsRequest_GcsSource.ProtoReflect.Descriptor instead.
func (*IngestConversationsRequest_GcsSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{11, 0}
}

func (x *IngestConversationsRequest_GcsSource) GetBucketUri() string {
	if x != nil {
		return x.BucketUri
	}
	return ""
}

func (x *IngestConversationsRequest_GcsSource) GetBucketObjectType() IngestConversationsRequest_GcsSource_BucketObjectType {
	if x != nil {
		return x.BucketObjectType
	}
	return IngestConversationsRequest_GcsSource_BUCKET_OBJECT_TYPE_UNSPECIFIED
}

// Configuration for processing transcript objects.
type IngestConversationsRequest_TranscriptObjectConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The medium transcript objects represent.
	Medium Conversation_Medium `protobuf:"varint,1,opt,name=medium,proto3,enum=google.cloud.contactcenterinsights.v1.Conversation_Medium" json:"medium,omitempty"`
}

func (x *IngestConversationsRequest_TranscriptObjectConfig) Reset() {
	*x = IngestConversationsRequest_TranscriptObjectConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[70]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IngestConversationsRequest_TranscriptObjectConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IngestConversationsRequest_TranscriptObjectConfig) ProtoMessage() {}

func (x *IngestConversationsRequest_TranscriptObjectConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[70]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IngestConversationsRequest_TranscriptObjectConfig.ProtoReflect.Descriptor instead.
func (*IngestConversationsRequest_TranscriptObjectConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{11, 1}
}

func (x *IngestConversationsRequest_TranscriptObjectConfig) GetMedium() Conversation_Medium {
	if x != nil {
		return x.Medium
	}
	return Conversation_MEDIUM_UNSPECIFIED
}

// Configuration that applies to all conversations.
type IngestConversationsRequest_ConversationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An opaque, user-specified string representing the human agent who handled
	// the conversations.
	AgentId string `protobuf:"bytes,1,opt,name=agent_id,json=agentId,proto3" json:"agent_id,omitempty"`
	// Optional. For audio conversations, this field indicates which of the
	// channels, 1 or 2, contains the agent. Note that this must be set for
	// audio conversations to be properly displayed and analyzed.
	AgentChannel int32 `protobuf:"varint,2,opt,name=agent_channel,json=agentChannel,proto3" json:"agent_channel,omitempty"`
	// Optional. For audio conversations, this field indicates which of the
	// channels, 1 or 2, contains the customer. Note that this must be set for
	// audio conversations to be properly displayed and analyzed.
	CustomerChannel int32 `protobuf:"varint,3,opt,name=customer_channel,json=customerChannel,proto3" json:"customer_channel,omitempty"`
}

func (x *IngestConversationsRequest_ConversationConfig) Reset() {
	*x = IngestConversationsRequest_ConversationConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[71]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IngestConversationsRequest_ConversationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IngestConversationsRequest_ConversationConfig) ProtoMessage() {}

func (x *IngestConversationsRequest_ConversationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[71]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IngestConversationsRequest_ConversationConfig.ProtoReflect.Descriptor instead.
func (*IngestConversationsRequest_ConversationConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{11, 2}
}

func (x *IngestConversationsRequest_ConversationConfig) GetAgentId() string {
	if x != nil {
		return x.AgentId
	}
	return ""
}

func (x *IngestConversationsRequest_ConversationConfig) GetAgentChannel() int32 {
	if x != nil {
		return x.AgentChannel
	}
	return 0
}

func (x *IngestConversationsRequest_ConversationConfig) GetCustomerChannel() int32 {
	if x != nil {
		return x.CustomerChannel
	}
	return 0
}

// Statistics for IngestConversations operation.
type IngestConversationsMetadata_IngestConversationsStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The number of objects processed during the ingest operation.
	ProcessedObjectCount int32 `protobuf:"varint,1,opt,name=processed_object_count,json=processedObjectCount,proto3" json:"processed_object_count,omitempty"`
	// Output only. The number of objects skipped because another conversation
	// with the same transcript uri had already been ingested.
	DuplicatesSkippedCount int32 `protobuf:"varint,2,opt,name=duplicates_skipped_count,json=duplicatesSkippedCount,proto3" json:"duplicates_skipped_count,omitempty"`
	// Output only. The number of new conversations added during this ingest
	// operation.
	SuccessfulIngestCount int32 `protobuf:"varint,3,opt,name=successful_ingest_count,json=successfulIngestCount,proto3" json:"successful_ingest_count,omitempty"`
	// Output only. The number of objects which were unable to be ingested due
	// to errors. The errors are populated in the partial_errors field.
	FailedIngestCount int32 `protobuf:"varint,4,opt,name=failed_ingest_count,json=failedIngestCount,proto3" json:"failed_ingest_count,omitempty"`
}

func (x *IngestConversationsMetadata_IngestConversationsStats) Reset() {
	*x = IngestConversationsMetadata_IngestConversationsStats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[72]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IngestConversationsMetadata_IngestConversationsStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IngestConversationsMetadata_IngestConversationsStats) ProtoMessage() {}

func (x *IngestConversationsMetadata_IngestConversationsStats) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[72]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IngestConversationsMetadata_IngestConversationsStats.ProtoReflect.Descriptor instead.
func (*IngestConversationsMetadata_IngestConversationsStats) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{12, 0}
}

func (x *IngestConversationsMetadata_IngestConversationsStats) GetProcessedObjectCount() int32 {
	if x != nil {
		return x.ProcessedObjectCount
	}
	return 0
}

func (x *IngestConversationsMetadata_IngestConversationsStats) GetDuplicatesSkippedCount() int32 {
	if x != nil {
		return x.DuplicatesSkippedCount
	}
	return 0
}

func (x *IngestConversationsMetadata_IngestConversationsStats) GetSuccessfulIngestCount() int32 {
	if x != nil {
		return x.SuccessfulIngestCount
	}
	return 0
}

func (x *IngestConversationsMetadata_IngestConversationsStats) GetFailedIngestCount() int32 {
	if x != nil {
		return x.FailedIngestCount
	}
	return 0
}

// A BigQuery Table Reference.
type ExportInsightsDataRequest_BigQueryDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A project ID or number. If specified, then export will attempt to
	// write data to this project instead of the resource project. Otherwise,
	// the resource project will be used.
	ProjectId string `protobuf:"bytes,3,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. The name of the BigQuery dataset that the snapshot result
	// should be exported to. If this dataset does not exist, the export call
	// returns an INVALID_ARGUMENT error.
	Dataset string `protobuf:"bytes,1,opt,name=dataset,proto3" json:"dataset,omitempty"`
	// The BigQuery table name to which the insights data should be written.
	// If this table does not exist, the export call returns an INVALID_ARGUMENT
	// error.
	Table string `protobuf:"bytes,2,opt,name=table,proto3" json:"table,omitempty"`
}

func (x *ExportInsightsDataRequest_BigQueryDestination) Reset() {
	*x = ExportInsightsDataRequest_BigQueryDestination{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[73]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportInsightsDataRequest_BigQueryDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportInsightsDataRequest_BigQueryDestination) ProtoMessage() {}

func (x *ExportInsightsDataRequest_BigQueryDestination) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[73]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportInsightsDataRequest_BigQueryDestination.ProtoReflect.Descriptor instead.
func (*ExportInsightsDataRequest_BigQueryDestination) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{25, 0}
}

func (x *ExportInsightsDataRequest_BigQueryDestination) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *ExportInsightsDataRequest_BigQueryDestination) GetDataset() string {
	if x != nil {
		return x.Dataset
	}
	return ""
}

func (x *ExportInsightsDataRequest_BigQueryDestination) GetTable() string {
	if x != nil {
		return x.Table
	}
	return ""
}

var File_google_cloud_contactcenterinsights_v1_contact_center_insights_proto protoreflect.FileDescriptor

var file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDesc = []byte{
	0x0a, 0x43, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69,
	0x67, 0x68, 0x74, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x5f,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67,
	0x68, 0x74, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70,
	0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0x76, 0x0a, 0x15, 0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74,
	0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a,
	0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xa2, 0x0c, 0x0a,
	0x16, 0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x44, 0x0a, 0x10, 0x61, 0x76, 0x65, 0x72, 0x61,
	0x67, 0x65, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x61, 0x76,
	0x65, 0x72, 0x61, 0x67, 0x65, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2c, 0x0a,
	0x12, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x75, 0x72, 0x6e, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x10, 0x61, 0x76, 0x65, 0x72, 0x61,
	0x67, 0x65, 0x54, 0x75, 0x72, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2d, 0x0a, 0x12, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x11, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x96, 0x01, 0x0a, 0x19, 0x73,
	0x6d, 0x61, 0x72, 0x74, 0x5f, 0x68, 0x69, 0x67, 0x68, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x65, 0x72,
	0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x5a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67,
	0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65,
	0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x53, 0x6d,
	0x61, 0x72, 0x74, 0x48, 0x69, 0x67, 0x68, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x65, 0x72, 0x4d, 0x61,
	0x74, 0x63, 0x68, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x17, 0x73, 0x6d, 0x61, 0x72,
	0x74, 0x48, 0x69, 0x67, 0x68, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x65, 0x72, 0x4d, 0x61, 0x74, 0x63,
	0x68, 0x65, 0x73, 0x12, 0x99, 0x01, 0x0a, 0x1a, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x68,
	0x69, 0x67, 0x68, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x65, 0x72, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68,
	0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x5b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x48, 0x69,
	0x67, 0x68, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x65, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x18, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x48, 0x69, 0x67,
	0x68, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x65, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x12,
	0x78, 0x0a, 0x0d, 0x69, 0x73, 0x73, 0x75, 0x65, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73,
	0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68,
	0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0c, 0x69, 0x73, 0x73,
	0x75, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x12, 0x84, 0x01, 0x0a, 0x13, 0x69, 0x73,
	0x73, 0x75, 0x65, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x5f, 0x73, 0x74, 0x61, 0x74,
	0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x54, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x61, 0x74, 0x63,
	0x68, 0x65, 0x73, 0x53, 0x74, 0x61, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x11, 0x69,
	0x73, 0x73, 0x75, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x53, 0x74, 0x61, 0x74, 0x73,
	0x12, 0x8d, 0x01, 0x0a, 0x1e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x72,
	0x69, 0x65, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72,
	0x69, 0x65, 0x73, 0x52, 0x1b, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73,
	0x1a, 0xb5, 0x02, 0x0a, 0x0a, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x12,
	0x46, 0x0a, 0x11, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x5f, 0x64, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x69, 0x0a, 0x06, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x51, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65,
	0x73, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x52, 0x06, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x73, 0x1a, 0x74, 0x0a, 0x08, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x12, 0x39,
	0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x2d, 0x0a, 0x12, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x11, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x1a, 0x4a, 0x0a, 0x1c, 0x53, 0x6d, 0x61, 0x72,
	0x74, 0x48, 0x69, 0x67, 0x68, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x65, 0x72, 0x4d, 0x61, 0x74, 0x63,
	0x68, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x1a, 0x4b, 0x0a, 0x1d, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x48, 0x69,
	0x67, 0x68, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x65, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x1a, 0x3f, 0x0a, 0x11, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x1a, 0x8c, 0x01, 0x0a, 0x16, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x61, 0x74, 0x63,
	0x68, 0x65, 0x73, 0x53, 0x74, 0x61, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x5c, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x46,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67,
	0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x73, 0x2e, 0x49, 0x73, 0x73, 0x75,
	0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x22, 0xec, 0x02, 0x0a, 0x1f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x61, 0x6c,
	0x79, 0x73, 0x69, 0x73, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x5d, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x39, 0xe0, 0x41, 0x03, 0xfa, 0x41,
	0x33, 0x0a, 0x31, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x6c, 0x0a, 0x12, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x6f, 0x72, 0x5f,
	0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67,
	0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x6f, 0x72,
	0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x6f, 0x72, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x22, 0xe5, 0x01, 0x0a, 0x19, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x5c, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x27, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22, 0xb1, 0x03, 0x0a, 0x19, 0x55, 0x70, 0x6c,
	0x6f, 0x61, 0x64, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x5c, 0x0a, 0x0c, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69,
	0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2c, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x66, 0x0a, 0x10, 0x72, 0x65, 0x64, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69,
	0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x64, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x72, 0x65,
	0x64, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5d, 0x0a,
	0x0d, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x65,
	0x65, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c,
	0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xa6, 0x03, 0x0a,
	0x1a, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a,
	0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x5f, 0x0a, 0x07, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63,
	0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x32, 0x0a, 0x12, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x73, 0x69, 0x73, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x75,
	0x0a, 0x18, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x64, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x64, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x16, 0x61,
	0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x52, 0x65, 0x64, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xfe, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x4b, 0x0a, 0x04, 0x76, 0x69, 0x65,
	0x77, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x69, 0x65, 0x77,
	0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x22, 0x9e, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x59, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xb4, 0x01, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x4d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x39, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x33, 0x0a, 0x31, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63,
	0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x4b, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69,
	0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x56, 0x69, 0x65, 0x77, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x22, 0xb6,
	0x01, 0x0a, 0x19, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5c, 0x0a, 0x0c,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x80, 0x01, 0x0a, 0x19, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x39, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x33, 0x0a, 0x31, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x22, 0xe4, 0x09, 0x0a, 0x1a, 0x49,
	0x6e, 0x67, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x6c, 0x0a, 0x0a, 0x67, 0x63, 0x73,
	0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x2e, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x09, 0x67, 0x63,
	0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x94, 0x01, 0x0a, 0x18, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x58, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63,
	0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x48, 0x01, 0x52, 0x16, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x41,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x85, 0x01, 0x0a, 0x13, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x54, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69,
	0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x12, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x66, 0x0a, 0x10, 0x72, 0x65, 0x64,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x64, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0f, 0x72, 0x65, 0x64, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x5d, 0x0a, 0x0d, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0c, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x1a, 0x94, 0x02, 0x0a, 0x09, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x22,
	0x0a, 0x0a, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x55,
	0x72, 0x69, 0x12, 0x8f, 0x01, 0x0a, 0x12, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x6f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x5c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69,
	0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x2e, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x42, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x10, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x54, 0x79, 0x70, 0x65, 0x22, 0x51, 0x0a, 0x10, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x4f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x22, 0x0a, 0x1e, 0x42, 0x55, 0x43, 0x4b,
	0x45, 0x54, 0x5f, 0x4f, 0x42, 0x4a, 0x45, 0x43, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a,
	0x54, 0x52, 0x41, 0x4e, 0x53, 0x43, 0x52, 0x49, 0x50, 0x54, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05,
	0x41, 0x55, 0x44, 0x49, 0x4f, 0x10, 0x02, 0x1a, 0x71, 0x0a, 0x16, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x57, 0x0a, 0x06, 0x6d, 0x65, 0x64, 0x69, 0x75, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4d, 0x65, 0x64, 0x69, 0x75, 0x6d, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x06, 0x6d, 0x65, 0x64, 0x69, 0x75, 0x6d, 0x1a, 0x89, 0x01, 0x0a, 0x12, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x19, 0x0a, 0x08, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x0d,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x43,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x2e, 0x0a, 0x10, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x65, 0x72, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x43,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x42, 0x0f, 0x0a, 0x0d, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x22, 0xe7, 0x05, 0x0a, 0x1b, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x60, 0x0a, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x3e, 0x0a, 0x0e, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0d, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x45, 0x72, 0x72, 0x6f, 0x72,
	0x73, 0x12, 0x9e, 0x01, 0x0a, 0x1a, 0x69, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x5f, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x5b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49,
	0x6e, 0x67, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x49, 0x6e, 0x67, 0x65, 0x73,
	0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x53, 0x74,
	0x61, 0x74, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x18, 0x69, 0x6e, 0x67, 0x65, 0x73, 0x74,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x53, 0x74, 0x61,
	0x74, 0x73, 0x1a, 0x86, 0x02, 0x0a, 0x18, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12,
	0x39, 0x0a, 0x16, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x64, 0x5f, 0x6f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x14, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x64, 0x4f,
	0x62, 0x6a, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x3d, 0x0a, 0x18, 0x64, 0x75,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x5f, 0x73, 0x6b, 0x69, 0x70, 0x70, 0x65, 0x64,
	0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x16, 0x64, 0x75, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x53, 0x6b, 0x69,
	0x70, 0x70, 0x65, 0x64, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x3b, 0x0a, 0x17, 0x73, 0x75, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x66, 0x75, 0x6c, 0x5f, 0x69, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x15, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x66, 0x75, 0x6c, 0x49, 0x6e, 0x67, 0x65, 0x73,
	0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x33, 0x0a, 0x13, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64,
	0x5f, 0x69, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64,
	0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x1d, 0x0a, 0x1b, 0x49,
	0x6e, 0x67, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xbc, 0x01, 0x0a, 0x15, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x51, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x39, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x33, 0x0a, 0x31, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67,
	0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x50, 0x0a, 0x08, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x73, 0x69, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x08, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x22, 0xbc, 0x01, 0x0a, 0x13, 0x4c, 0x69,
	0x73, 0x74, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x51, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x39, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x33, 0x0a, 0x31, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x8b, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73,
	0x74, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x4b, 0x0a, 0x08, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c,
	0x79, 0x73, 0x69, 0x73, 0x52, 0x08, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x65, 0x73, 0x12, 0x26,
	0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x5f, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2f, 0x0a, 0x2d, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69,
	0x73, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x62, 0x0a, 0x15, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x49, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa0, 0x02, 0x0a, 0x1f,
	0x42, 0x75, 0x6c, 0x6b, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12,
	0x34, 0x0a, 0x13, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x63,
	0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x12, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x50, 0x65, 0x72, 0x63, 0x65,
	0x6e, 0x74, 0x61, 0x67, 0x65, 0x12, 0x67, 0x0a, 0x12, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x6f, 0x72, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x6f, 0x72, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x11, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x6f, 0x72, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x22, 0xeb,
	0x03, 0x0a, 0x20, 0x42, 0x75, 0x6c, 0x6b, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07,
	0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x60, 0x0a, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x42, 0x75, 0x6c, 0x6b, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x52, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x38, 0x0a, 0x18, 0x63, 0x6f, 0x6d,
	0x70, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x65, 0x73, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x16, 0x63, 0x6f, 0x6d,
	0x70, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x65, 0x73, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x12, 0x32, 0x0a, 0x15, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x5f, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x73, 0x65, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x13, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73,
	0x65, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x43, 0x0a, 0x1e, 0x74, 0x6f, 0x74, 0x61, 0x6c,
	0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x73, 0x65, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x1b, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x41,
	0x6e, 0x61, 0x6c, 0x79, 0x73, 0x65, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x3e, 0x0a, 0x0e,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x07,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70,
	0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x70,
	0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x22, 0x92, 0x01, 0x0a,
	0x20, 0x42, 0x75, 0x6c, 0x6b, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x3a, 0x0a, 0x19, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x66, 0x75, 0x6c, 0x5f,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x17, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x66, 0x75, 0x6c,
	0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x32, 0x0a,
	0x15, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73,
	0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x13, 0x66, 0x61,
	0x69, 0x6c, 0x65, 0x64, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x22, 0xbb, 0x01, 0x0a, 0x1e, 0x42, 0x75, 0x6c, 0x6b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12,
	0x28, 0x0a, 0x10, 0x6d, 0x61, 0x78, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x6d, 0x61, 0x78, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x6f, 0x72,
	0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x22,
	0xb1, 0x02, 0x0a, 0x1f, 0x42, 0x75, 0x6c, 0x6b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07,
	0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x5f, 0x0a, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x42, 0x75, 0x6c, 0x6b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52,
	0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x39, 0x0a, 0x0e, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x61, 0x6c, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x52, 0x0d, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x45, 0x72, 0x72,
	0x6f, 0x72, 0x73, 0x22, 0x21, 0x0a, 0x1f, 0x42, 0x75, 0x6c, 0x6b, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xf3, 0x04, 0x0a, 0x19, 0x45, 0x78, 0x70, 0x6f, 0x72,
	0x74, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x8a, 0x01, 0x0a, 0x15, 0x62, 0x69, 0x67, 0x5f, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x54, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70,
	0x6f, 0x72, 0x74, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x44, 0x61, 0x74, 0x61, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x13, 0x62, 0x69,
	0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x17, 0x0a, 0x07,
	0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x6b,
	0x6d, 0x73, 0x4b, 0x65, 0x79, 0x12, 0x7e, 0x0a, 0x11, 0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x64,
	0x69, 0x73, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x51, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x49,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x2e, 0x57, 0x72, 0x69, 0x74, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x10, 0x77, 0x72, 0x69, 0x74, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x69, 0x0a, 0x13, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x07, 0x64,
	0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x22, 0x5b, 0x0a, 0x10, 0x57, 0x72, 0x69, 0x74, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x1d, 0x57, 0x52, 0x49, 0x54, 0x45, 0x5f, 0x44, 0x49,
	0x53, 0x50, 0x4f, 0x53, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x57, 0x52, 0x49, 0x54, 0x45,
	0x5f, 0x54, 0x52, 0x55, 0x4e, 0x43, 0x41, 0x54, 0x45, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x57,
	0x52, 0x49, 0x54, 0x45, 0x5f, 0x41, 0x50, 0x50, 0x45, 0x4e, 0x44, 0x10, 0x02, 0x42, 0x0d, 0x0a,
	0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb1, 0x02, 0x0a,
	0x1a, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x44,
	0x61, 0x74, 0x61, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a,
	0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x5a, 0x0a, 0x07, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63,
	0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74,
	0x73, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x07, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x39, 0x0a, 0x0e, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c,
	0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x52, 0x0d, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x73,
	0x22, 0x1c, 0x0a, 0x1a, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xb5,
	0x01, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x57, 0x0a,
	0x0b, 0x69, 0x73, 0x73, 0x75, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x73, 0x73, 0x75, 0x65,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x69, 0x73, 0x73, 0x75,
	0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x22, 0xf2, 0x01, 0x0a, 0x18, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x58, 0x0a, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x52, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0xaf, 0x01, 0x0a, 0x17,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x57, 0x0a, 0x0b, 0x69, 0x73, 0x73, 0x75, 0x65,
	0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x69, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73,
	0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x5b, 0x0a,
	0x16, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a,
	0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x22, 0x6f, 0x0a, 0x17, 0x4c, 0x69,
	0x73, 0x74, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x54, 0x0a, 0x0c, 0x69, 0x73, 0x73, 0x75, 0x65, 0x5f, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x0b,
	0x69, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x22, 0x63, 0x0a, 0x14, 0x47,
	0x65, 0x74, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0x66, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x31, 0x0a, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xf2, 0x01, 0x0a, 0x18, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x58, 0x0a, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x52, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0x66, 0x0a,
	0x17, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31, 0x0a, 0x2f,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x1a, 0x0a, 0x18, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x49,
	0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0xf2, 0x01, 0x0a, 0x18, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x49, 0x73, 0x73, 0x75,
	0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x40,
	0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x58, 0x0a, 0x07,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x49, 0x73, 0x73, 0x75,
	0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x07, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0x68, 0x0a, 0x19, 0x55, 0x6e, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0x1c, 0x0a, 0x1a, 0x55, 0x6e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x49, 0x73, 0x73, 0x75,
	0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xf6,
	0x01, 0x0a, 0x1a, 0x55, 0x6e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x49, 0x73, 0x73, 0x75, 0x65,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x40, 0x0a,
	0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x5a, 0x0a, 0x07, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x6e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x49, 0x73, 0x73,
	0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x07,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0x59, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x49, 0x73,
	0x73, 0x75, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c,
	0x0a, 0x2a, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x73, 0x73, 0x75, 0x65, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0x64, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x73, 0x73, 0x75, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31, 0x0a,
	0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x22, 0x5a, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74,
	0x49, 0x73, 0x73, 0x75, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x44,
	0x0a, 0x06, 0x69, 0x73, 0x73, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67,
	0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x73, 0x73, 0x75, 0x65, 0x52, 0x06, 0x69, 0x73,
	0x73, 0x75, 0x65, 0x73, 0x22, 0x9a, 0x01, 0x0a, 0x12, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49,
	0x73, 0x73, 0x75, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x05, 0x69,
	0x73, 0x73, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63,
	0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x49, 0x73, 0x73, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x69,
	0x73, 0x73, 0x75, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73,
	0x6b, 0x22, 0x5c, 0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69,
	0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x73, 0x73, 0x75, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0x7b, 0x0a, 0x1f, 0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75,
	0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x58, 0x0a, 0x0b, 0x69, 0x73, 0x73, 0x75, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31, 0x0a,
	0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x52, 0x0a, 0x69, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x22, 0x84, 0x01, 0x0a,
	0x20, 0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x60, 0x0a, 0x0d, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x74, 0x61,
	0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x0c, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x53, 0x74,
	0x61, 0x74, 0x73, 0x22, 0xc1, 0x01, 0x0a, 0x1a, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x68,
	0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x60, 0x0a, 0x0e, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x5f,
	0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63,
	0x68, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65,
	0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x22, 0xb2, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74,
	0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xa3, 0x01, 0x0a,
	0x1a, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68,
	0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5d, 0x0a, 0x0f, 0x70,
	0x68, 0x72, 0x61, 0x73, 0x65, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x68, 0x72,
	0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x52, 0x0e, 0x70, 0x68, 0x72, 0x61,
	0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65,
	0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0x69, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d,
	0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3a, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x34, 0x0a, 0x32, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65,
	0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x6c, 0x0a,
	0x1a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74,
	0x63, 0x68, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3a, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x34, 0x0a, 0x32, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61,
	0x74, 0x63, 0x68, 0x65, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xbb, 0x01, 0x0a, 0x1a,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63,
	0x68, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x60, 0x0a, 0x0e, 0x70, 0x68,
	0x72, 0x61, 0x73, 0x65, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x68, 0x72, 0x61, 0x73,
	0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x70,
	0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x12, 0x3b, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x5f, 0x0a, 0x12, 0x47, 0x65, 0x74,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x49, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xab, 0x01, 0x0a, 0x15, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x08, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x73, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x9c, 0x01, 0x0a, 0x11, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x56, 0x69, 0x65, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x44, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69,
	0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x69, 0x65, 0x77, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x22, 0x57, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x56, 0x69,
	0x65, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a,
	0x29, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x69, 0x65, 0x77, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0x91, 0x01, 0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x69, 0x65, 0x77, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x7e, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x69, 0x65, 0x77,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x41, 0x0a, 0x05, 0x76, 0x69, 0x65,
	0x77, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x56, 0x69, 0x65, 0x77, 0x52, 0x05, 0x76, 0x69, 0x65, 0x77, 0x73, 0x12, 0x26, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x96, 0x01, 0x0a, 0x11, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x56,
	0x69, 0x65, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x76, 0x69,
	0x65, 0x77, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x56, 0x69, 0x65, 0x77, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77,
	0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73,
	0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x5a, 0x0a,
	0x11, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x56, 0x69, 0x65, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x45, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63,
	0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56,
	0x69, 0x65, 0x77, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x2a, 0x4a, 0x0a, 0x10, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x69, 0x65, 0x77, 0x12, 0x21, 0x0a,
	0x1d, 0x43, 0x4f, 0x4e, 0x56, 0x45, 0x52, 0x53, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x56, 0x49,
	0x45, 0x57, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x08, 0x0a, 0x04, 0x46, 0x55, 0x4c, 0x4c, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x42, 0x41,
	0x53, 0x49, 0x43, 0x10, 0x01, 0x32, 0xdc, 0x44, 0x0a, 0x15, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63,
	0x74, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x12,
	0xfa, 0x01, 0x0a, 0x12, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6d, 0xda,
	0x41, 0x23, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x41, 0x3a, 0x0c, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xe7, 0x01, 0x0a,
	0x12, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x6c, 0x6f,
	0x61, 0x64, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x70, 0xca, 0x41, 0x2a, 0x0a, 0x0c, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x3a, 0x01, 0x2a, 0x22, 0x38, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a,
	0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0xfc, 0x01, 0x0a, 0x12, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69,
	0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6f, 0xda, 0x41, 0x18, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4e, 0x3a, 0x0c, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x32, 0x3e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc7, 0x01, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x40, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x12, 0x31, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xda, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x42, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x12, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xb0, 0x01, 0x0a,
	0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x40, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x2a, 0x31, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xfe, 0x01, 0x0a, 0x0e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73,
	0x69, 0x73, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x8e, 0x01, 0xca, 0x41, 0x2b, 0x0a, 0x08, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x12,
	0x1f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0xda, 0x41, 0x0f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73,
	0x69, 0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x48, 0x3a, 0x08, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73,
	0x69, 0x73, 0x22, 0x3c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x65, 0x73,
	0x12, 0xc6, 0x01, 0x0a, 0x0b, 0x47, 0x65, 0x74, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73,
	0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x6e, 0x61, 0x6c,
	0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x22, 0x4b, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x12, 0x3c, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd6, 0x01, 0x0a, 0x0c, 0x4c, 0x69,
	0x73, 0x74, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x65, 0x73, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63,
	0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x4d, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x3e, 0x12, 0x3c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73,
	0x65, 0x73, 0x12, 0xb3, 0x01, 0x0a, 0x0e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x73, 0x69, 0x73, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x4b, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x2a, 0x3c, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xb7, 0x02, 0x0a, 0x18, 0x42, 0x75, 0x6c,
	0x6b, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75,
	0x6c, 0x6b, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb3, 0x01, 0xca,
	0x41, 0x44, 0x0a, 0x20, 0x42, 0x75, 0x6c, 0x6b, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x20, 0x42, 0x75, 0x6c, 0x6b, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a,
	0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x21, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2c, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f,
	0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42,
	0x3a, 0x01, 0x2a, 0x22, 0x3d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x62, 0x75, 0x6c, 0x6b, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x7a, 0x65, 0x12, 0x9e, 0x02, 0x0a, 0x17, 0x42, 0x75, 0x6c, 0x6b, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x45,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67,
	0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x6c, 0x6b, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x9c, 0x01, 0xca, 0x41, 0x42, 0x0a, 0x1f, 0x42, 0x75, 0x6c, 0x6b,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1f, 0x42, 0x75, 0x6c,
	0x6b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x0d, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x41, 0x3a, 0x01, 0x2a, 0x22, 0x3c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x62, 0x75, 0x6c, 0x6b, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x12, 0x83, 0x02, 0x0a, 0x13, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x41, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x89, 0x01,
	0xca, 0x41, 0x3a, 0x0a, 0x1b, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x1b, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x3a, 0x01, 0x2a, 0x22,
	0x38, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x3a, 0x69, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x12, 0xfe, 0x01, 0x0a, 0x12, 0x45, 0x78,
	0x70, 0x6f, 0x72, 0x74, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x44, 0x61, 0x74, 0x61,
	0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x49,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x86, 0x01, 0xca, 0x41, 0x38, 0x0a, 0x1a, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x49,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x1a, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x6e, 0x73, 0x69, 0x67,
	0x68, 0x74, 0x73, 0x44, 0x61, 0x74, 0x61, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda,
	0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x3a, 0x01,
	0x2a, 0x22, 0x37, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x64,
	0x61, 0x74, 0x61, 0x3a, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x12, 0xf6, 0x01, 0x0a, 0x10, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12,
	0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69,
	0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x73,
	0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x82,
	0x01, 0xca, 0x41, 0x26, 0x0a, 0x0a, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x12, 0x18, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x12, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x2c, 0x69, 0x73, 0x73, 0x75, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x3a, 0x0b, 0x69, 0x73, 0x73, 0x75, 0x65, 0x5f, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x22, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x69, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x73, 0x12, 0xf1, 0x01, 0x0a, 0x10, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x73,
	0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x22, 0x6a, 0xda, 0x41, 0x17,
	0x69, 0x73, 0x73, 0x75, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2c, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4a, 0x3a, 0x0b, 0x69,
	0x73, 0x73, 0x75, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x32, 0x3b, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x69, 0x73, 0x73, 0x75, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xbf, 0x01, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x49,
	0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49,
	0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x22, 0x3e, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x73, 0x73, 0x75, 0x65,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd2, 0x01, 0x0a, 0x0f, 0x4c, 0x69,
	0x73, 0x74, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x12, 0x3d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x40, 0xda, 0x41,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x69, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x12, 0xe5,
	0x01, 0x0a, 0x10, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x72, 0xca, 0x41, 0x31, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x18,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x31, 0x2a, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xf2, 0x01, 0x0a, 0x10, 0x44, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x3e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7f, 0xca, 0x41, 0x34, 0x0a,
	0x18, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x18, 0x44, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b,
	0x3a, 0x01, 0x2a, 0x22, 0x36, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x12, 0xfd, 0x01, 0x0a, 0x12,
	0x55, 0x6e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x6e, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x85, 0x01, 0xca, 0x41, 0x38, 0x0a, 0x1a, 0x55, 0x6e, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1a, 0x55, 0x6e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x49,
	0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x3a, 0x01,
	0x2a, 0x22, 0x38, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x75, 0x6e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x12, 0xb9, 0x01, 0x0a, 0x08,
	0x47, 0x65, 0x74, 0x49, 0x73, 0x73, 0x75, 0x65, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x65, 0x74, 0x49, 0x73, 0x73, 0x75, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x73, 0x73, 0x75, 0x65, 0x22, 0x47,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3a, 0x12, 0x38, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x69, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x73,
	0x73, 0x75, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xcc, 0x01, 0x0a, 0x0a, 0x4c, 0x69, 0x73, 0x74,
	0x49, 0x73, 0x73, 0x75, 0x65, 0x73, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x49, 0x73, 0x73, 0x75, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x73, 0x73,
	0x75, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x49, 0xda, 0x41, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3a, 0x12, 0x38, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x69, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x69, 0x73, 0x73, 0x75, 0x65, 0x73, 0x12, 0xd9, 0x01, 0x0a, 0x0b, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x73, 0x73, 0x75, 0x65, 0x22,
	0x61, 0xda, 0x41, 0x11, 0x69, 0x73, 0x73, 0x75, 0x65, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x47, 0x3a, 0x05, 0x69, 0x73, 0x73,
	0x75, 0x65, 0x32, 0x3e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x69, 0x73, 0x73, 0x75, 0x65, 0x2e, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x73, 0x73, 0x75, 0x65,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x73, 0x73, 0x75, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0xa9, 0x01, 0x0a, 0x0b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x73, 0x73,
	0x75, 0x65, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x47, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x3a, 0x2a, 0x38, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x73, 0x73, 0x75, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x92,
	0x02, 0x0a, 0x18, 0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75,
	0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x46, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x49, 0x73, 0x73,
	0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x6c, 0x63,
	0x75, 0x6c, 0x61, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x53,
	0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x65, 0xda, 0x41,
	0x0b, 0x69, 0x73, 0x73, 0x75, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x51, 0x12, 0x4f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x69, 0x73, 0x73, 0x75, 0x65, 0x5f, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x73, 0x73, 0x75,
	0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x63, 0x61, 0x6c, 0x63, 0x75,
	0x6c, 0x61, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x53, 0x74,
	0x61, 0x74, 0x73, 0x12, 0xf2, 0x01, 0x0a, 0x13, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x68,
	0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x12, 0x41, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65,
	0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67,
	0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74,
	0x63, 0x68, 0x65, 0x72, 0x22, 0x62, 0xda, 0x41, 0x15, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c,
	0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x44, 0x3a, 0x0e, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x5f, 0x6d, 0x61, 0x74,
	0x63, 0x68, 0x65, 0x72, 0x22, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65,
	0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x73, 0x12, 0xcb, 0x01, 0x0a, 0x10, 0x47, 0x65, 0x74,
	0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x12, 0x3e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d,
	0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63,
	0x68, 0x65, 0x72, 0x22, 0x41, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x34, 0x12, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68,
	0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xde, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x50,
	0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x73, 0x12, 0x40, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65,
	0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69,
	0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x68, 0x72, 0x61,
	0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x43, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x34, 0x12, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d,
	0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x73, 0x12, 0xb3, 0x01, 0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x12,
	0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69,
	0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x68,
	0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x41, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x2a, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x68, 0x72, 0x61,
	0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x86, 0x02,
	0x0a, 0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61,
	0x74, 0x63, 0x68, 0x65, 0x72, 0x12, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65,
	0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x22, 0x76,
	0xda, 0x41, 0x1a, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65,
	0x72, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x53, 0x3a, 0x0e, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x5f, 0x6d, 0x61, 0x74, 0x63,
	0x68, 0x65, 0x72, 0x32, 0x41, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65,
	0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68,
	0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe4, 0x01, 0x0a, 0x0e, 0x43, 0x61, 0x6c, 0x63, 0x75,
	0x6c, 0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x55, 0xda, 0x41, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x12, 0x42, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x63,
	0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0xb4, 0x01,
	0x0a, 0x0b, 0x47, 0x65, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x39, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x39, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2c, 0x12, 0x2a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x7d, 0x12, 0xdd, 0x01, 0x0a, 0x0e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x5c, 0xda, 0x41, 0x14, 0x73, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x3a, 0x08, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x32,
	0x33, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x7d, 0x12, 0xba, 0x01, 0x0a, 0x0a, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x56,
	0x69, 0x65, 0x77, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x56, 0x69, 0x65, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x69, 0x65, 0x77, 0x22, 0x45, 0xda, 0x41, 0x0b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x76, 0x69, 0x65, 0x77, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31,
	0x3a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x22, 0x29, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x76, 0x69, 0x65, 0x77,
	0x73, 0x12, 0xa7, 0x01, 0x0a, 0x07, 0x47, 0x65, 0x74, 0x56, 0x69, 0x65, 0x77, 0x12, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x56, 0x69, 0x65, 0x77, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x69, 0x65,
	0x77, 0x22, 0x38, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2b,
	0x12, 0x29, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x76, 0x69, 0x65, 0x77, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xba, 0x01, 0x0a, 0x09,
	0x4c, 0x69, 0x73, 0x74, 0x56, 0x69, 0x65, 0x77, 0x73, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x69, 0x65, 0x77, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x56,
	0x69, 0x65, 0x77, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3a, 0xda, 0x41,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2b, 0x12, 0x29, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x76, 0x69, 0x65, 0x77, 0x73, 0x12, 0xc4, 0x01, 0x0a, 0x0a, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x56, 0x69, 0x65, 0x77, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x56, 0x69, 0x65, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x69, 0x65, 0x77, 0x22, 0x4f,
	0xda, 0x41, 0x10, 0x76, 0x69, 0x65, 0x77, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36, 0x3a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x32,
	0x2e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x76, 0x69, 0x65, 0x77, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x69, 0x65, 0x77, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0x98, 0x01, 0x0a, 0x0a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x56, 0x69, 0x65, 0x77, 0x12, 0x38,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67,
	0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x56, 0x69, 0x65,
	0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79,
	0x22, 0x38, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2b, 0x2a,
	0x29, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x76, 0x69, 0x65, 0x77, 0x73, 0x2f, 0x2a, 0x7d, 0x1a, 0x58, 0xca, 0x41, 0x24, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69,
	0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77,
	0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x42, 0xa5, 0x02, 0x0a, 0x29, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63,
	0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e,
	0x76, 0x31, 0x42, 0x1a, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x43, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2f, 0x61, 0x70, 0x69, 0x76,
	0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x70, 0x62, 0x3b, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63,
	0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x70,
	0x62, 0xaa, 0x02, 0x25, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x49, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x25, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74,
	0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x5c, 0x56,
	0x31, 0xea, 0x02, 0x28, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x3a, 0x3a, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescOnce sync.Once
	file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescData = file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDesc
)

func file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP() []byte {
	file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescOnce.Do(func() {
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescData)
	})
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescData
}

var file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes = make([]protoimpl.MessageInfo, 74)
var file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_goTypes = []interface{}{
	(ConversationView)(0), // 0: google.cloud.contactcenterinsights.v1.ConversationView
	(IngestConversationsRequest_GcsSource_BucketObjectType)(0), // 1: google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource.BucketObjectType
	(ExportInsightsDataRequest_WriteDisposition)(0),            // 2: google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.WriteDisposition
	(*CalculateStatsRequest)(nil),                              // 3: google.cloud.contactcenterinsights.v1.CalculateStatsRequest
	(*CalculateStatsResponse)(nil),                             // 4: google.cloud.contactcenterinsights.v1.CalculateStatsResponse
	(*CreateAnalysisOperationMetadata)(nil),                    // 5: google.cloud.contactcenterinsights.v1.CreateAnalysisOperationMetadata
	(*CreateConversationRequest)(nil),                          // 6: google.cloud.contactcenterinsights.v1.CreateConversationRequest
	(*UploadConversationRequest)(nil),                          // 7: google.cloud.contactcenterinsights.v1.UploadConversationRequest
	(*UploadConversationMetadata)(nil),                         // 8: google.cloud.contactcenterinsights.v1.UploadConversationMetadata
	(*ListConversationsRequest)(nil),                           // 9: google.cloud.contactcenterinsights.v1.ListConversationsRequest
	(*ListConversationsResponse)(nil),                          // 10: google.cloud.contactcenterinsights.v1.ListConversationsResponse
	(*GetConversationRequest)(nil),                             // 11: google.cloud.contactcenterinsights.v1.GetConversationRequest
	(*UpdateConversationRequest)(nil),                          // 12: google.cloud.contactcenterinsights.v1.UpdateConversationRequest
	(*DeleteConversationRequest)(nil),                          // 13: google.cloud.contactcenterinsights.v1.DeleteConversationRequest
	(*IngestConversationsRequest)(nil),                         // 14: google.cloud.contactcenterinsights.v1.IngestConversationsRequest
	(*IngestConversationsMetadata)(nil),                        // 15: google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
	(*IngestConversationsResponse)(nil),                        // 16: google.cloud.contactcenterinsights.v1.IngestConversationsResponse
	(*CreateAnalysisRequest)(nil),                              // 17: google.cloud.contactcenterinsights.v1.CreateAnalysisRequest
	(*ListAnalysesRequest)(nil),                                // 18: google.cloud.contactcenterinsights.v1.ListAnalysesRequest
	(*ListAnalysesResponse)(nil),                               // 19: google.cloud.contactcenterinsights.v1.ListAnalysesResponse
	(*GetAnalysisRequest)(nil),                                 // 20: google.cloud.contactcenterinsights.v1.GetAnalysisRequest
	(*DeleteAnalysisRequest)(nil),                              // 21: google.cloud.contactcenterinsights.v1.DeleteAnalysisRequest
	(*BulkAnalyzeConversationsRequest)(nil),                    // 22: google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsRequest
	(*BulkAnalyzeConversationsMetadata)(nil),                   // 23: google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata
	(*BulkAnalyzeConversationsResponse)(nil),                   // 24: google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsResponse
	(*BulkDeleteConversationsRequest)(nil),                     // 25: google.cloud.contactcenterinsights.v1.BulkDeleteConversationsRequest
	(*BulkDeleteConversationsMetadata)(nil),                    // 26: google.cloud.contactcenterinsights.v1.BulkDeleteConversationsMetadata
	(*BulkDeleteConversationsResponse)(nil),                    // 27: google.cloud.contactcenterinsights.v1.BulkDeleteConversationsResponse
	(*ExportInsightsDataRequest)(nil),                          // 28: google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
	(*ExportInsightsDataMetadata)(nil),                         // 29: google.cloud.contactcenterinsights.v1.ExportInsightsDataMetadata
	(*ExportInsightsDataResponse)(nil),                         // 30: google.cloud.contactcenterinsights.v1.ExportInsightsDataResponse
	(*CreateIssueModelRequest)(nil),                            // 31: google.cloud.contactcenterinsights.v1.CreateIssueModelRequest
	(*CreateIssueModelMetadata)(nil),                           // 32: google.cloud.contactcenterinsights.v1.CreateIssueModelMetadata
	(*UpdateIssueModelRequest)(nil),                            // 33: google.cloud.contactcenterinsights.v1.UpdateIssueModelRequest
	(*ListIssueModelsRequest)(nil),                             // 34: google.cloud.contactcenterinsights.v1.ListIssueModelsRequest
	(*ListIssueModelsResponse)(nil),                            // 35: google.cloud.contactcenterinsights.v1.ListIssueModelsResponse
	(*GetIssueModelRequest)(nil),                               // 36: google.cloud.contactcenterinsights.v1.GetIssueModelRequest
	(*DeleteIssueModelRequest)(nil),                            // 37: google.cloud.contactcenterinsights.v1.DeleteIssueModelRequest
	(*DeleteIssueModelMetadata)(nil),                           // 38: google.cloud.contactcenterinsights.v1.DeleteIssueModelMetadata
	(*DeployIssueModelRequest)(nil),                            // 39: google.cloud.contactcenterinsights.v1.DeployIssueModelRequest
	(*DeployIssueModelResponse)(nil),                           // 40: google.cloud.contactcenterinsights.v1.DeployIssueModelResponse
	(*DeployIssueModelMetadata)(nil),                           // 41: google.cloud.contactcenterinsights.v1.DeployIssueModelMetadata
	(*UndeployIssueModelRequest)(nil),                          // 42: google.cloud.contactcenterinsights.v1.UndeployIssueModelRequest
	(*UndeployIssueModelResponse)(nil),                         // 43: google.cloud.contactcenterinsights.v1.UndeployIssueModelResponse
	(*UndeployIssueModelMetadata)(nil),                         // 44: google.cloud.contactcenterinsights.v1.UndeployIssueModelMetadata
	(*GetIssueRequest)(nil),                                    // 45: google.cloud.contactcenterinsights.v1.GetIssueRequest
	(*ListIssuesRequest)(nil),                                  // 46: google.cloud.contactcenterinsights.v1.ListIssuesRequest
	(*ListIssuesResponse)(nil),                                 // 47: google.cloud.contactcenterinsights.v1.ListIssuesResponse
	(*UpdateIssueRequest)(nil),                                 // 48: google.cloud.contactcenterinsights.v1.UpdateIssueRequest
	(*DeleteIssueRequest)(nil),                                 // 49: google.cloud.contactcenterinsights.v1.DeleteIssueRequest
	(*CalculateIssueModelStatsRequest)(nil),                    // 50: google.cloud.contactcenterinsights.v1.CalculateIssueModelStatsRequest
	(*CalculateIssueModelStatsResponse)(nil),                   // 51: google.cloud.contactcenterinsights.v1.CalculateIssueModelStatsResponse
	(*CreatePhraseMatcherRequest)(nil),                         // 52: google.cloud.contactcenterinsights.v1.CreatePhraseMatcherRequest
	(*ListPhraseMatchersRequest)(nil),                          // 53: google.cloud.contactcenterinsights.v1.ListPhraseMatchersRequest
	(*ListPhraseMatchersResponse)(nil),                         // 54: google.cloud.contactcenterinsights.v1.ListPhraseMatchersResponse
	(*GetPhraseMatcherRequest)(nil),                            // 55: google.cloud.contactcenterinsights.v1.GetPhraseMatcherRequest
	(*DeletePhraseMatcherRequest)(nil),                         // 56: google.cloud.contactcenterinsights.v1.DeletePhraseMatcherRequest
	(*UpdatePhraseMatcherRequest)(nil),                         // 57: google.cloud.contactcenterinsights.v1.UpdatePhraseMatcherRequest
	(*GetSettingsRequest)(nil),                                 // 58: google.cloud.contactcenterinsights.v1.GetSettingsRequest
	(*UpdateSettingsRequest)(nil),                              // 59: google.cloud.contactcenterinsights.v1.UpdateSettingsRequest
	(*CreateViewRequest)(nil),                                  // 60: google.cloud.contactcenterinsights.v1.CreateViewRequest
	(*GetViewRequest)(nil),                                     // 61: google.cloud.contactcenterinsights.v1.GetViewRequest
	(*ListViewsRequest)(nil),                                   // 62: google.cloud.contactcenterinsights.v1.ListViewsRequest
	(*ListViewsResponse)(nil),                                  // 63: google.cloud.contactcenterinsights.v1.ListViewsResponse
	(*UpdateViewRequest)(nil),                                  // 64: google.cloud.contactcenterinsights.v1.UpdateViewRequest
	(*DeleteViewRequest)(nil),                                  // 65: google.cloud.contactcenterinsights.v1.DeleteViewRequest
	(*CalculateStatsResponse_TimeSeries)(nil),                  // 66: google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
	nil, // 67: google.cloud.contactcenterinsights.v1.CalculateStatsResponse.SmartHighlighterMatchesEntry
	nil, // 68: google.cloud.contactcenterinsights.v1.CalculateStatsResponse.CustomHighlighterMatchesEntry
	nil, // 69: google.cloud.contactcenterinsights.v1.CalculateStatsResponse.IssueMatchesEntry
	nil, // 70: google.cloud.contactcenterinsights.v1.CalculateStatsResponse.IssueMatchesStatsEntry
	(*CalculateStatsResponse_TimeSeries_Interval)(nil),           // 71: google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval
	(*IngestConversationsRequest_GcsSource)(nil),                 // 72: google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource
	(*IngestConversationsRequest_TranscriptObjectConfig)(nil),    // 73: google.cloud.contactcenterinsights.v1.IngestConversationsRequest.TranscriptObjectConfig
	(*IngestConversationsRequest_ConversationConfig)(nil),        // 74: google.cloud.contactcenterinsights.v1.IngestConversationsRequest.ConversationConfig
	(*IngestConversationsMetadata_IngestConversationsStats)(nil), // 75: google.cloud.contactcenterinsights.v1.IngestConversationsMetadata.IngestConversationsStats
	(*ExportInsightsDataRequest_BigQueryDestination)(nil),        // 76: google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.BigQueryDestination
	(*durationpb.Duration)(nil),                                  // 77: google.protobuf.Duration
	(*timestamppb.Timestamp)(nil),                                // 78: google.protobuf.Timestamp
	(*AnnotatorSelector)(nil),                                    // 79: google.cloud.contactcenterinsights.v1.AnnotatorSelector
	(*Conversation)(nil),                                         // 80: google.cloud.contactcenterinsights.v1.Conversation
	(*RedactionConfig)(nil),                                      // 81: google.cloud.contactcenterinsights.v1.RedactionConfig
	(*SpeechConfig)(nil),                                         // 82: google.cloud.contactcenterinsights.v1.SpeechConfig
	(*fieldmaskpb.FieldMask)(nil),                                // 83: google.protobuf.FieldMask
	(*status.Status)(nil),                                        // 84: google.rpc.Status
	(*Analysis)(nil),                                             // 85: google.cloud.contactcenterinsights.v1.Analysis
	(*IssueModel)(nil),                                           // 86: google.cloud.contactcenterinsights.v1.IssueModel
	(*Issue)(nil),                                                // 87: google.cloud.contactcenterinsights.v1.Issue
	(*IssueModelLabelStats)(nil),                                 // 88: google.cloud.contactcenterinsights.v1.IssueModelLabelStats
	(*PhraseMatcher)(nil),                                        // 89: google.cloud.contactcenterinsights.v1.PhraseMatcher
	(*Settings)(nil),                                             // 90: google.cloud.contactcenterinsights.v1.Settings
	(*View)(nil),                                                 // 91: google.cloud.contactcenterinsights.v1.View
	(*IssueModelLabelStats_IssueStats)(nil),                      // 92: google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats
	(Conversation_Medium)(0),                                     // 93: google.cloud.contactcenterinsights.v1.Conversation.Medium
	(*longrunningpb.Operation)(nil),                              // 94: google.longrunning.Operation
	(*emptypb.Empty)(nil),                                        // 95: google.protobuf.Empty
}
var file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_depIdxs = []int32{
	77,  // 0: google.cloud.contactcenterinsights.v1.CalculateStatsResponse.average_duration:type_name -> google.protobuf.Duration
	67,  // 1: google.cloud.contactcenterinsights.v1.CalculateStatsResponse.smart_highlighter_matches:type_name -> google.cloud.contactcenterinsights.v1.CalculateStatsResponse.SmartHighlighterMatchesEntry
	68,  // 2: google.cloud.contactcenterinsights.v1.CalculateStatsResponse.custom_highlighter_matches:type_name -> google.cloud.contactcenterinsights.v1.CalculateStatsResponse.CustomHighlighterMatchesEntry
	69,  // 3: google.cloud.contactcenterinsights.v1.CalculateStatsResponse.issue_matches:type_name -> google.cloud.contactcenterinsights.v1.CalculateStatsResponse.IssueMatchesEntry
	70,  // 4: google.cloud.contactcenterinsights.v1.CalculateStatsResponse.issue_matches_stats:type_name -> google.cloud.contactcenterinsights.v1.CalculateStatsResponse.IssueMatchesStatsEntry
	66,  // 5: google.cloud.contactcenterinsights.v1.CalculateStatsResponse.conversation_count_time_series:type_name -> google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
	78,  // 6: google.cloud.contactcenterinsights.v1.CreateAnalysisOperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	78,  // 7: google.cloud.contactcenterinsights.v1.CreateAnalysisOperationMetadata.end_time:type_name -> google.protobuf.Timestamp
	79,  // 8: google.cloud.contactcenterinsights.v1.CreateAnalysisOperationMetadata.annotator_selector:type_name -> google.cloud.contactcenterinsights.v1.AnnotatorSelector
	80,  // 9: google.cloud.contactcenterinsights.v1.CreateConversationRequest.conversation:type_name -> google.cloud.contactcenterinsights.v1.Conversation
	80,  // 10: google.cloud.contactcenterinsights.v1.UploadConversationRequest.conversation:type_name -> google.cloud.contactcenterinsights.v1.Conversation
	81,  // 11: google.cloud.contactcenterinsights.v1.UploadConversationRequest.redaction_config:type_name -> google.cloud.contactcenterinsights.v1.RedactionConfig
	82,  // 12: google.cloud.contactcenterinsights.v1.UploadConversationRequest.speech_config:type_name -> google.cloud.contactcenterinsights.v1.SpeechConfig
	78,  // 13: google.cloud.contactcenterinsights.v1.UploadConversationMetadata.create_time:type_name -> google.protobuf.Timestamp
	78,  // 14: google.cloud.contactcenterinsights.v1.UploadConversationMetadata.end_time:type_name -> google.protobuf.Timestamp
	7,   // 15: google.cloud.contactcenterinsights.v1.UploadConversationMetadata.request:type_name -> google.cloud.contactcenterinsights.v1.UploadConversationRequest
	81,  // 16: google.cloud.contactcenterinsights.v1.UploadConversationMetadata.applied_redaction_config:type_name -> google.cloud.contactcenterinsights.v1.RedactionConfig
	0,   // 17: google.cloud.contactcenterinsights.v1.ListConversationsRequest.view:type_name -> google.cloud.contactcenterinsights.v1.ConversationView
	80,  // 18: google.cloud.contactcenterinsights.v1.ListConversationsResponse.conversations:type_name -> google.cloud.contactcenterinsights.v1.Conversation
	0,   // 19: google.cloud.contactcenterinsights.v1.GetConversationRequest.view:type_name -> google.cloud.contactcenterinsights.v1.ConversationView
	80,  // 20: google.cloud.contactcenterinsights.v1.UpdateConversationRequest.conversation:type_name -> google.cloud.contactcenterinsights.v1.Conversation
	83,  // 21: google.cloud.contactcenterinsights.v1.UpdateConversationRequest.update_mask:type_name -> google.protobuf.FieldMask
	72,  // 22: google.cloud.contactcenterinsights.v1.IngestConversationsRequest.gcs_source:type_name -> google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource
	73,  // 23: google.cloud.contactcenterinsights.v1.IngestConversationsRequest.transcript_object_config:type_name -> google.cloud.contactcenterinsights.v1.IngestConversationsRequest.TranscriptObjectConfig
	74,  // 24: google.cloud.contactcenterinsights.v1.IngestConversationsRequest.conversation_config:type_name -> google.cloud.contactcenterinsights.v1.IngestConversationsRequest.ConversationConfig
	81,  // 25: google.cloud.contactcenterinsights.v1.IngestConversationsRequest.redaction_config:type_name -> google.cloud.contactcenterinsights.v1.RedactionConfig
	82,  // 26: google.cloud.contactcenterinsights.v1.IngestConversationsRequest.speech_config:type_name -> google.cloud.contactcenterinsights.v1.SpeechConfig
	78,  // 27: google.cloud.contactcenterinsights.v1.IngestConversationsMetadata.create_time:type_name -> google.protobuf.Timestamp
	78,  // 28: google.cloud.contactcenterinsights.v1.IngestConversationsMetadata.end_time:type_name -> google.protobuf.Timestamp
	14,  // 29: google.cloud.contactcenterinsights.v1.IngestConversationsMetadata.request:type_name -> google.cloud.contactcenterinsights.v1.IngestConversationsRequest
	84,  // 30: google.cloud.contactcenterinsights.v1.IngestConversationsMetadata.partial_errors:type_name -> google.rpc.Status
	75,  // 31: google.cloud.contactcenterinsights.v1.IngestConversationsMetadata.ingest_conversations_stats:type_name -> google.cloud.contactcenterinsights.v1.IngestConversationsMetadata.IngestConversationsStats
	85,  // 32: google.cloud.contactcenterinsights.v1.CreateAnalysisRequest.analysis:type_name -> google.cloud.contactcenterinsights.v1.Analysis
	85,  // 33: google.cloud.contactcenterinsights.v1.ListAnalysesResponse.analyses:type_name -> google.cloud.contactcenterinsights.v1.Analysis
	79,  // 34: google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsRequest.annotator_selector:type_name -> google.cloud.contactcenterinsights.v1.AnnotatorSelector
	78,  // 35: google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata.create_time:type_name -> google.protobuf.Timestamp
	78,  // 36: google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata.end_time:type_name -> google.protobuf.Timestamp
	22,  // 37: google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata.request:type_name -> google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsRequest
	84,  // 38: google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata.partial_errors:type_name -> google.rpc.Status
	78,  // 39: google.cloud.contactcenterinsights.v1.BulkDeleteConversationsMetadata.create_time:type_name -> google.protobuf.Timestamp
	78,  // 40: google.cloud.contactcenterinsights.v1.BulkDeleteConversationsMetadata.end_time:type_name -> google.protobuf.Timestamp
	25,  // 41: google.cloud.contactcenterinsights.v1.BulkDeleteConversationsMetadata.request:type_name -> google.cloud.contactcenterinsights.v1.BulkDeleteConversationsRequest
	84,  // 42: google.cloud.contactcenterinsights.v1.BulkDeleteConversationsMetadata.partial_errors:type_name -> google.rpc.Status
	76,  // 43: google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.big_query_destination:type_name -> google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.BigQueryDestination
	2,   // 44: google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.write_disposition:type_name -> google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.WriteDisposition
	78,  // 45: google.cloud.contactcenterinsights.v1.ExportInsightsDataMetadata.create_time:type_name -> google.protobuf.Timestamp
	78,  // 46: google.cloud.contactcenterinsights.v1.ExportInsightsDataMetadata.end_time:type_name -> google.protobuf.Timestamp
	28,  // 47: google.cloud.contactcenterinsights.v1.ExportInsightsDataMetadata.request:type_name -> google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
	84,  // 48: google.cloud.contactcenterinsights.v1.ExportInsightsDataMetadata.partial_errors:type_name -> google.rpc.Status
	86,  // 49: google.cloud.contactcenterinsights.v1.CreateIssueModelRequest.issue_model:type_name -> google.cloud.contactcenterinsights.v1.IssueModel
	78,  // 50: google.cloud.contactcenterinsights.v1.CreateIssueModelMetadata.create_time:type_name -> google.protobuf.Timestamp
	78,  // 51: google.cloud.contactcenterinsights.v1.CreateIssueModelMetadata.end_time:type_name -> google.protobuf.Timestamp
	31,  // 52: google.cloud.contactcenterinsights.v1.CreateIssueModelMetadata.request:type_name -> google.cloud.contactcenterinsights.v1.CreateIssueModelRequest
	86,  // 53: google.cloud.contactcenterinsights.v1.UpdateIssueModelRequest.issue_model:type_name -> google.cloud.contactcenterinsights.v1.IssueModel
	83,  // 54: google.cloud.contactcenterinsights.v1.UpdateIssueModelRequest.update_mask:type_name -> google.protobuf.FieldMask
	86,  // 55: google.cloud.contactcenterinsights.v1.ListIssueModelsResponse.issue_models:type_name -> google.cloud.contactcenterinsights.v1.IssueModel
	78,  // 56: google.cloud.contactcenterinsights.v1.DeleteIssueModelMetadata.create_time:type_name -> google.protobuf.Timestamp
	78,  // 57: google.cloud.contactcenterinsights.v1.DeleteIssueModelMetadata.end_time:type_name -> google.protobuf.Timestamp
	37,  // 58: google.cloud.contactcenterinsights.v1.DeleteIssueModelMetadata.request:type_name -> google.cloud.contactcenterinsights.v1.DeleteIssueModelRequest
	78,  // 59: google.cloud.contactcenterinsights.v1.DeployIssueModelMetadata.create_time:type_name -> google.protobuf.Timestamp
	78,  // 60: google.cloud.contactcenterinsights.v1.DeployIssueModelMetadata.end_time:type_name -> google.protobuf.Timestamp
	39,  // 61: google.cloud.contactcenterinsights.v1.DeployIssueModelMetadata.request:type_name -> google.cloud.contactcenterinsights.v1.DeployIssueModelRequest
	78,  // 62: google.cloud.contactcenterinsights.v1.UndeployIssueModelMetadata.create_time:type_name -> google.protobuf.Timestamp
	78,  // 63: google.cloud.contactcenterinsights.v1.UndeployIssueModelMetadata.end_time:type_name -> google.protobuf.Timestamp
	42,  // 64: google.cloud.contactcenterinsights.v1.UndeployIssueModelMetadata.request:type_name -> google.cloud.contactcenterinsights.v1.UndeployIssueModelRequest
	87,  // 65: google.cloud.contactcenterinsights.v1.ListIssuesResponse.issues:type_name -> google.cloud.contactcenterinsights.v1.Issue
	87,  // 66: google.cloud.contactcenterinsights.v1.UpdateIssueRequest.issue:type_name -> google.cloud.contactcenterinsights.v1.Issue
	83,  // 67: google.cloud.contactcenterinsights.v1.UpdateIssueRequest.update_mask:type_name -> google.protobuf.FieldMask
	88,  // 68: google.cloud.contactcenterinsights.v1.CalculateIssueModelStatsResponse.current_stats:type_name -> google.cloud.contactcenterinsights.v1.IssueModelLabelStats
	89,  // 69: google.cloud.contactcenterinsights.v1.CreatePhraseMatcherRequest.phrase_matcher:type_name -> google.cloud.contactcenterinsights.v1.PhraseMatcher
	89,  // 70: google.cloud.contactcenterinsights.v1.ListPhraseMatchersResponse.phrase_matchers:type_name -> google.cloud.contactcenterinsights.v1.PhraseMatcher
	89,  // 71: google.cloud.contactcenterinsights.v1.UpdatePhraseMatcherRequest.phrase_matcher:type_name -> google.cloud.contactcenterinsights.v1.PhraseMatcher
	83,  // 72: google.cloud.contactcenterinsights.v1.UpdatePhraseMatcherRequest.update_mask:type_name -> google.protobuf.FieldMask
	90,  // 73: google.cloud.contactcenterinsights.v1.UpdateSettingsRequest.settings:type_name -> google.cloud.contactcenterinsights.v1.Settings
	83,  // 74: google.cloud.contactcenterinsights.v1.UpdateSettingsRequest.update_mask:type_name -> google.protobuf.FieldMask
	91,  // 75: google.cloud.contactcenterinsights.v1.CreateViewRequest.view:type_name -> google.cloud.contactcenterinsights.v1.View
	91,  // 76: google.cloud.contactcenterinsights.v1.ListViewsResponse.views:type_name -> google.cloud.contactcenterinsights.v1.View
	91,  // 77: google.cloud.contactcenterinsights.v1.UpdateViewRequest.view:type_name -> google.cloud.contactcenterinsights.v1.View
	83,  // 78: google.cloud.contactcenterinsights.v1.UpdateViewRequest.update_mask:type_name -> google.protobuf.FieldMask
	77,  // 79: google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.interval_duration:type_name -> google.protobuf.Duration
	71,  // 80: google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.points:type_name -> google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval
	92,  // 81: google.cloud.contactcenterinsights.v1.CalculateStatsResponse.IssueMatchesStatsEntry.value:type_name -> google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats
	78,  // 82: google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval.start_time:type_name -> google.protobuf.Timestamp
	1,   // 83: google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource.bucket_object_type:type_name -> google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource.BucketObjectType
	93,  // 84: google.cloud.contactcenterinsights.v1.IngestConversationsRequest.TranscriptObjectConfig.medium:type_name -> google.cloud.contactcenterinsights.v1.Conversation.Medium
	6,   // 85: google.cloud.contactcenterinsights.v1.ContactCenterInsights.CreateConversation:input_type -> google.cloud.contactcenterinsights.v1.CreateConversationRequest
	7,   // 86: google.cloud.contactcenterinsights.v1.ContactCenterInsights.UploadConversation:input_type -> google.cloud.contactcenterinsights.v1.UploadConversationRequest
	12,  // 87: google.cloud.contactcenterinsights.v1.ContactCenterInsights.UpdateConversation:input_type -> google.cloud.contactcenterinsights.v1.UpdateConversationRequest
	11,  // 88: google.cloud.contactcenterinsights.v1.ContactCenterInsights.GetConversation:input_type -> google.cloud.contactcenterinsights.v1.GetConversationRequest
	9,   // 89: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ListConversations:input_type -> google.cloud.contactcenterinsights.v1.ListConversationsRequest
	13,  // 90: google.cloud.contactcenterinsights.v1.ContactCenterInsights.DeleteConversation:input_type -> google.cloud.contactcenterinsights.v1.DeleteConversationRequest
	17,  // 91: google.cloud.contactcenterinsights.v1.ContactCenterInsights.CreateAnalysis:input_type -> google.cloud.contactcenterinsights.v1.CreateAnalysisRequest
	20,  // 92: google.cloud.contactcenterinsights.v1.ContactCenterInsights.GetAnalysis:input_type -> google.cloud.contactcenterinsights.v1.GetAnalysisRequest
	18,  // 93: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ListAnalyses:input_type -> google.cloud.contactcenterinsights.v1.ListAnalysesRequest
	21,  // 94: google.cloud.contactcenterinsights.v1.ContactCenterInsights.DeleteAnalysis:input_type -> google.cloud.contactcenterinsights.v1.DeleteAnalysisRequest
	22,  // 95: google.cloud.contactcenterinsights.v1.ContactCenterInsights.BulkAnalyzeConversations:input_type -> google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsRequest
	25,  // 96: google.cloud.contactcenterinsights.v1.ContactCenterInsights.BulkDeleteConversations:input_type -> google.cloud.contactcenterinsights.v1.BulkDeleteConversationsRequest
	14,  // 97: google.cloud.contactcenterinsights.v1.ContactCenterInsights.IngestConversations:input_type -> google.cloud.contactcenterinsights.v1.IngestConversationsRequest
	28,  // 98: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ExportInsightsData:input_type -> google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
	31,  // 99: google.cloud.contactcenterinsights.v1.ContactCenterInsights.CreateIssueModel:input_type -> google.cloud.contactcenterinsights.v1.CreateIssueModelRequest
	33,  // 100: google.cloud.contactcenterinsights.v1.ContactCenterInsights.UpdateIssueModel:input_type -> google.cloud.contactcenterinsights.v1.UpdateIssueModelRequest
	36,  // 101: google.cloud.contactcenterinsights.v1.ContactCenterInsights.GetIssueModel:input_type -> google.cloud.contactcenterinsights.v1.GetIssueModelRequest
	34,  // 102: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ListIssueModels:input_type -> google.cloud.contactcenterinsights.v1.ListIssueModelsRequest
	37,  // 103: google.cloud.contactcenterinsights.v1.ContactCenterInsights.DeleteIssueModel:input_type -> google.cloud.contactcenterinsights.v1.DeleteIssueModelRequest
	39,  // 104: google.cloud.contactcenterinsights.v1.ContactCenterInsights.DeployIssueModel:input_type -> google.cloud.contactcenterinsights.v1.DeployIssueModelRequest
	42,  // 105: google.cloud.contactcenterinsights.v1.ContactCenterInsights.UndeployIssueModel:input_type -> google.cloud.contactcenterinsights.v1.UndeployIssueModelRequest
	45,  // 106: google.cloud.contactcenterinsights.v1.ContactCenterInsights.GetIssue:input_type -> google.cloud.contactcenterinsights.v1.GetIssueRequest
	46,  // 107: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ListIssues:input_type -> google.cloud.contactcenterinsights.v1.ListIssuesRequest
	48,  // 108: google.cloud.contactcenterinsights.v1.ContactCenterInsights.UpdateIssue:input_type -> google.cloud.contactcenterinsights.v1.UpdateIssueRequest
	49,  // 109: google.cloud.contactcenterinsights.v1.ContactCenterInsights.DeleteIssue:input_type -> google.cloud.contactcenterinsights.v1.DeleteIssueRequest
	50,  // 110: google.cloud.contactcenterinsights.v1.ContactCenterInsights.CalculateIssueModelStats:input_type -> google.cloud.contactcenterinsights.v1.CalculateIssueModelStatsRequest
	52,  // 111: google.cloud.contactcenterinsights.v1.ContactCenterInsights.CreatePhraseMatcher:input_type -> google.cloud.contactcenterinsights.v1.CreatePhraseMatcherRequest
	55,  // 112: google.cloud.contactcenterinsights.v1.ContactCenterInsights.GetPhraseMatcher:input_type -> google.cloud.contactcenterinsights.v1.GetPhraseMatcherRequest
	53,  // 113: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ListPhraseMatchers:input_type -> google.cloud.contactcenterinsights.v1.ListPhraseMatchersRequest
	56,  // 114: google.cloud.contactcenterinsights.v1.ContactCenterInsights.DeletePhraseMatcher:input_type -> google.cloud.contactcenterinsights.v1.DeletePhraseMatcherRequest
	57,  // 115: google.cloud.contactcenterinsights.v1.ContactCenterInsights.UpdatePhraseMatcher:input_type -> google.cloud.contactcenterinsights.v1.UpdatePhraseMatcherRequest
	3,   // 116: google.cloud.contactcenterinsights.v1.ContactCenterInsights.CalculateStats:input_type -> google.cloud.contactcenterinsights.v1.CalculateStatsRequest
	58,  // 117: google.cloud.contactcenterinsights.v1.ContactCenterInsights.GetSettings:input_type -> google.cloud.contactcenterinsights.v1.GetSettingsRequest
	59,  // 118: google.cloud.contactcenterinsights.v1.ContactCenterInsights.UpdateSettings:input_type -> google.cloud.contactcenterinsights.v1.UpdateSettingsRequest
	60,  // 119: google.cloud.contactcenterinsights.v1.ContactCenterInsights.CreateView:input_type -> google.cloud.contactcenterinsights.v1.CreateViewRequest
	61,  // 120: google.cloud.contactcenterinsights.v1.ContactCenterInsights.GetView:input_type -> google.cloud.contactcenterinsights.v1.GetViewRequest
	62,  // 121: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ListViews:input_type -> google.cloud.contactcenterinsights.v1.ListViewsRequest
	64,  // 122: google.cloud.contactcenterinsights.v1.ContactCenterInsights.UpdateView:input_type -> google.cloud.contactcenterinsights.v1.UpdateViewRequest
	65,  // 123: google.cloud.contactcenterinsights.v1.ContactCenterInsights.DeleteView:input_type -> google.cloud.contactcenterinsights.v1.DeleteViewRequest
	80,  // 124: google.cloud.contactcenterinsights.v1.ContactCenterInsights.CreateConversation:output_type -> google.cloud.contactcenterinsights.v1.Conversation
	94,  // 125: google.cloud.contactcenterinsights.v1.ContactCenterInsights.UploadConversation:output_type -> google.longrunning.Operation
	80,  // 126: google.cloud.contactcenterinsights.v1.ContactCenterInsights.UpdateConversation:output_type -> google.cloud.contactcenterinsights.v1.Conversation
	80,  // 127: google.cloud.contactcenterinsights.v1.ContactCenterInsights.GetConversation:output_type -> google.cloud.contactcenterinsights.v1.Conversation
	10,  // 128: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ListConversations:output_type -> google.cloud.contactcenterinsights.v1.ListConversationsResponse
	95,  // 129: google.cloud.contactcenterinsights.v1.ContactCenterInsights.DeleteConversation:output_type -> google.protobuf.Empty
	94,  // 130: google.cloud.contactcenterinsights.v1.ContactCenterInsights.CreateAnalysis:output_type -> google.longrunning.Operation
	85,  // 131: google.cloud.contactcenterinsights.v1.ContactCenterInsights.GetAnalysis:output_type -> google.cloud.contactcenterinsights.v1.Analysis
	19,  // 132: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ListAnalyses:output_type -> google.cloud.contactcenterinsights.v1.ListAnalysesResponse
	95,  // 133: google.cloud.contactcenterinsights.v1.ContactCenterInsights.DeleteAnalysis:output_type -> google.protobuf.Empty
	94,  // 134: google.cloud.contactcenterinsights.v1.ContactCenterInsights.BulkAnalyzeConversations:output_type -> google.longrunning.Operation
	94,  // 135: google.cloud.contactcenterinsights.v1.ContactCenterInsights.BulkDeleteConversations:output_type -> google.longrunning.Operation
	94,  // 136: google.cloud.contactcenterinsights.v1.ContactCenterInsights.IngestConversations:output_type -> google.longrunning.Operation
	94,  // 137: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ExportInsightsData:output_type -> google.longrunning.Operation
	94,  // 138: google.cloud.contactcenterinsights.v1.ContactCenterInsights.CreateIssueModel:output_type -> google.longrunning.Operation
	86,  // 139: google.cloud.contactcenterinsights.v1.ContactCenterInsights.UpdateIssueModel:output_type -> google.cloud.contactcenterinsights.v1.IssueModel
	86,  // 140: google.cloud.contactcenterinsights.v1.ContactCenterInsights.GetIssueModel:output_type -> google.cloud.contactcenterinsights.v1.IssueModel
	35,  // 141: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ListIssueModels:output_type -> google.cloud.contactcenterinsights.v1.ListIssueModelsResponse
	94,  // 142: google.cloud.contactcenterinsights.v1.ContactCenterInsights.DeleteIssueModel:output_type -> google.longrunning.Operation
	94,  // 143: google.cloud.contactcenterinsights.v1.ContactCenterInsights.DeployIssueModel:output_type -> google.longrunning.Operation
	94,  // 144: google.cloud.contactcenterinsights.v1.ContactCenterInsights.UndeployIssueModel:output_type -> google.longrunning.Operation
	87,  // 145: google.cloud.contactcenterinsights.v1.ContactCenterInsights.GetIssue:output_type -> google.cloud.contactcenterinsights.v1.Issue
	47,  // 146: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ListIssues:output_type -> google.cloud.contactcenterinsights.v1.ListIssuesResponse
	87,  // 147: google.cloud.contactcenterinsights.v1.ContactCenterInsights.UpdateIssue:output_type -> google.cloud.contactcenterinsights.v1.Issue
	95,  // 148: google.cloud.contactcenterinsights.v1.ContactCenterInsights.DeleteIssue:output_type -> google.protobuf.Empty
	51,  // 149: google.cloud.contactcenterinsights.v1.ContactCenterInsights.CalculateIssueModelStats:output_type -> google.cloud.contactcenterinsights.v1.CalculateIssueModelStatsResponse
	89,  // 150: google.cloud.contactcenterinsights.v1.ContactCenterInsights.CreatePhraseMatcher:output_type -> google.cloud.contactcenterinsights.v1.PhraseMatcher
	89,  // 151: google.cloud.contactcenterinsights.v1.ContactCenterInsights.GetPhraseMatcher:output_type -> google.cloud.contactcenterinsights.v1.PhraseMatcher
	54,  // 152: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ListPhraseMatchers:output_type -> google.cloud.contactcenterinsights.v1.ListPhraseMatchersResponse
	95,  // 153: google.cloud.contactcenterinsights.v1.ContactCenterInsights.DeletePhraseMatcher:output_type -> google.protobuf.Empty
	89,  // 154: google.cloud.contactcenterinsights.v1.ContactCenterInsights.UpdatePhraseMatcher:output_type -> google.cloud.contactcenterinsights.v1.PhraseMatcher
	4,   // 155: google.cloud.contactcenterinsights.v1.ContactCenterInsights.CalculateStats:output_type -> google.cloud.contactcenterinsights.v1.CalculateStatsResponse
	90,  // 156: google.cloud.contactcenterinsights.v1.ContactCenterInsights.GetSettings:output_type -> google.cloud.contactcenterinsights.v1.Settings
	90,  // 157: google.cloud.contactcenterinsights.v1.ContactCenterInsights.UpdateSettings:output_type -> google.cloud.contactcenterinsights.v1.Settings
	91,  // 158: google.cloud.contactcenterinsights.v1.ContactCenterInsights.CreateView:output_type -> google.cloud.contactcenterinsights.v1.View
	91,  // 159: google.cloud.contactcenterinsights.v1.ContactCenterInsights.GetView:output_type -> google.cloud.contactcenterinsights.v1.View
	63,  // 160: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ListViews:output_type -> google.cloud.contactcenterinsights.v1.ListViewsResponse
	91,  // 161: google.cloud.contactcenterinsights.v1.ContactCenterInsights.UpdateView:output_type -> google.cloud.contactcenterinsights.v1.View
	95,  // 162: google.cloud.contactcenterinsights.v1.ContactCenterInsights.DeleteView:output_type -> google.protobuf.Empty
	124, // [124:163] is the sub-list for method output_type
	85,  // [85:124] is the sub-list for method input_type
	85,  // [85:85] is the sub-list for extension type_name
	85,  // [85:85] is the sub-list for extension extendee
	0,   // [0:85] is the sub-list for field type_name
}

func init() { file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_init() }
func file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_init() {
	if File_google_cloud_contactcenterinsights_v1_contact_center_insights_proto != nil {
		return
	}
	file_google_cloud_contactcenterinsights_v1_resources_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CalculateStatsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CalculateStatsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateAnalysisOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateConversationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UploadConversationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UploadConversationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListConversationsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListConversationsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetConversationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateConversationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteConversationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IngestConversationsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IngestConversationsMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IngestConversationsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateAnalysisRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAnalysesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAnalysesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAnalysisRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteAnalysisRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BulkAnalyzeConversationsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BulkAnalyzeConversationsMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BulkAnalyzeConversationsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BulkDeleteConversationsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BulkDeleteConversationsMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BulkDeleteConversationsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportInsightsDataRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportInsightsDataMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportInsightsDataResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateIssueModelRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateIssueModelMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateIssueModelRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListIssueModelsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListIssueModelsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetIssueModelRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteIssueModelRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteIssueModelMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeployIssueModelRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeployIssueModelResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeployIssueModelMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UndeployIssueModelRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UndeployIssueModelResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UndeployIssueModelMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetIssueRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListIssuesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListIssuesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateIssueRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteIssueRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CalculateIssueModelStatsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CalculateIssueModelStatsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreatePhraseMatcherRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[50].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPhraseMatchersRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[51].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPhraseMatchersResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[52].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetPhraseMatcherRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[53].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeletePhraseMatcherRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[54].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdatePhraseMatcherRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[55].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[56].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[57].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateViewRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[58].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetViewRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[59].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListViewsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[60].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListViewsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[61].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateViewRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[62].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteViewRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[63].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CalculateStatsResponse_TimeSeries); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[68].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CalculateStatsResponse_TimeSeries_Interval); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[69].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IngestConversationsRequest_GcsSource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[70].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IngestConversationsRequest_TranscriptObjectConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[71].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IngestConversationsRequest_ConversationConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[72].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IngestConversationsMetadata_IngestConversationsStats); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[73].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportInsightsDataRequest_BigQueryDestination); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[11].OneofWrappers = []interface{}{
		(*IngestConversationsRequest_GcsSource_)(nil),
		(*IngestConversationsRequest_TranscriptObjectConfig_)(nil),
	}
	file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[25].OneofWrappers = []interface{}{
		(*ExportInsightsDataRequest_BigQueryDestination_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   74,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_goTypes,
		DependencyIndexes: file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_depIdxs,
		EnumInfos:         file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_enumTypes,
		MessageInfos:      file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes,
	}.Build()
	File_google_cloud_contactcenterinsights_v1_contact_center_insights_proto = out.File
	file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDesc = nil
	file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_goTypes = nil
	file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ContactCenterInsightsClient is the client API for ContactCenterInsights service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ContactCenterInsightsClient interface {
	// Creates a conversation.
	CreateConversation(ctx context.Context, in *CreateConversationRequest, opts ...grpc.CallOption) (*Conversation, error)
	// Create a longrunning conversation upload operation. This method differs
	// from CreateConversation by allowing audio transcription and optional DLP
	// redaction.
	UploadConversation(ctx context.Context, in *UploadConversationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates a conversation.
	UpdateConversation(ctx context.Context, in *UpdateConversationRequest, opts ...grpc.CallOption) (*Conversation, error)
	// Gets a conversation.
	GetConversation(ctx context.Context, in *GetConversationRequest, opts ...grpc.CallOption) (*Conversation, error)
	// Lists conversations.
	ListConversations(ctx context.Context, in *ListConversationsRequest, opts ...grpc.CallOption) (*ListConversationsResponse, error)
	// Deletes a conversation.
	DeleteConversation(ctx context.Context, in *DeleteConversationRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Creates an analysis. The long running operation is done when the analysis
	// has completed.
	CreateAnalysis(ctx context.Context, in *CreateAnalysisRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets an analysis.
	GetAnalysis(ctx context.Context, in *GetAnalysisRequest, opts ...grpc.CallOption) (*Analysis, error)
	// Lists analyses.
	ListAnalyses(ctx context.Context, in *ListAnalysesRequest, opts ...grpc.CallOption) (*ListAnalysesResponse, error)
	// Deletes an analysis.
	DeleteAnalysis(ctx context.Context, in *DeleteAnalysisRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Analyzes multiple conversations in a single request.
	BulkAnalyzeConversations(ctx context.Context, in *BulkAnalyzeConversationsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes multiple conversations in a single request.
	BulkDeleteConversations(ctx context.Context, in *BulkDeleteConversationsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Imports conversations and processes them according to the user's
	// configuration.
	IngestConversations(ctx context.Context, in *IngestConversationsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Export insights data to a destination defined in the request body.
	ExportInsightsData(ctx context.Context, in *ExportInsightsDataRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates an issue model.
	CreateIssueModel(ctx context.Context, in *CreateIssueModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates an issue model.
	UpdateIssueModel(ctx context.Context, in *UpdateIssueModelRequest, opts ...grpc.CallOption) (*IssueModel, error)
	// Gets an issue model.
	GetIssueModel(ctx context.Context, in *GetIssueModelRequest, opts ...grpc.CallOption) (*IssueModel, error)
	// Lists issue models.
	ListIssueModels(ctx context.Context, in *ListIssueModelsRequest, opts ...grpc.CallOption) (*ListIssueModelsResponse, error)
	// Deletes an issue model.
	DeleteIssueModel(ctx context.Context, in *DeleteIssueModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deploys an issue model. Returns an error if a model is already deployed.
	// An issue model can only be used in analysis after it has been deployed.
	DeployIssueModel(ctx context.Context, in *DeployIssueModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Undeploys an issue model.
	// An issue model can not be used in analysis after it has been undeployed.
	UndeployIssueModel(ctx context.Context, in *UndeployIssueModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets an issue.
	GetIssue(ctx context.Context, in *GetIssueRequest, opts ...grpc.CallOption) (*Issue, error)
	// Lists issues.
	ListIssues(ctx context.Context, in *ListIssuesRequest, opts ...grpc.CallOption) (*ListIssuesResponse, error)
	// Updates an issue.
	UpdateIssue(ctx context.Context, in *UpdateIssueRequest, opts ...grpc.CallOption) (*Issue, error)
	// Deletes an issue.
	DeleteIssue(ctx context.Context, in *DeleteIssueRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Gets an issue model's statistics.
	CalculateIssueModelStats(ctx context.Context, in *CalculateIssueModelStatsRequest, opts ...grpc.CallOption) (*CalculateIssueModelStatsResponse, error)
	// Creates a phrase matcher.
	CreatePhraseMatcher(ctx context.Context, in *CreatePhraseMatcherRequest, opts ...grpc.CallOption) (*PhraseMatcher, error)
	// Gets a phrase matcher.
	GetPhraseMatcher(ctx context.Context, in *GetPhraseMatcherRequest, opts ...grpc.CallOption) (*PhraseMatcher, error)
	// Lists phrase matchers.
	ListPhraseMatchers(ctx context.Context, in *ListPhraseMatchersRequest, opts ...grpc.CallOption) (*ListPhraseMatchersResponse, error)
	// Deletes a phrase matcher.
	DeletePhraseMatcher(ctx context.Context, in *DeletePhraseMatcherRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates a phrase matcher.
	UpdatePhraseMatcher(ctx context.Context, in *UpdatePhraseMatcherRequest, opts ...grpc.CallOption) (*PhraseMatcher, error)
	// Gets conversation statistics.
	CalculateStats(ctx context.Context, in *CalculateStatsRequest, opts ...grpc.CallOption) (*CalculateStatsResponse, error)
	// Gets project-level settings.
	GetSettings(ctx context.Context, in *GetSettingsRequest, opts ...grpc.CallOption) (*Settings, error)
	// Updates project-level settings.
	UpdateSettings(ctx context.Context, in *UpdateSettingsRequest, opts ...grpc.CallOption) (*Settings, error)
	// Creates a view.
	CreateView(ctx context.Context, in *CreateViewRequest, opts ...grpc.CallOption) (*View, error)
	// Gets a view.
	GetView(ctx context.Context, in *GetViewRequest, opts ...grpc.CallOption) (*View, error)
	// Lists views.
	ListViews(ctx context.Context, in *ListViewsRequest, opts ...grpc.CallOption) (*ListViewsResponse, error)
	// Updates a view.
	UpdateView(ctx context.Context, in *UpdateViewRequest, opts ...grpc.CallOption) (*View, error)
	// Deletes a view.
	DeleteView(ctx context.Context, in *DeleteViewRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type contactCenterInsightsClient struct {
	cc grpc.ClientConnInterface
}

func NewContactCenterInsightsClient(cc grpc.ClientConnInterface) ContactCenterInsightsClient {
	return &contactCenterInsightsClient{cc}
}

func (c *contactCenterInsightsClient) CreateConversation(ctx context.Context, in *CreateConversationRequest, opts ...grpc.CallOption) (*Conversation, error) {
	out := new(Conversation)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/CreateConversation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) UploadConversation(ctx context.Context, in *UploadConversationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/UploadConversation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) UpdateConversation(ctx context.Context, in *UpdateConversationRequest, opts ...grpc.CallOption) (*Conversation, error) {
	out := new(Conversation)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/UpdateConversation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) GetConversation(ctx context.Context, in *GetConversationRequest, opts ...grpc.CallOption) (*Conversation, error) {
	out := new(Conversation)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/GetConversation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) ListConversations(ctx context.Context, in *ListConversationsRequest, opts ...grpc.CallOption) (*ListConversationsResponse, error) {
	out := new(ListConversationsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/ListConversations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) DeleteConversation(ctx context.Context, in *DeleteConversationRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/DeleteConversation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) CreateAnalysis(ctx context.Context, in *CreateAnalysisRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/CreateAnalysis", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) GetAnalysis(ctx context.Context, in *GetAnalysisRequest, opts ...grpc.CallOption) (*Analysis, error) {
	out := new(Analysis)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/GetAnalysis", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) ListAnalyses(ctx context.Context, in *ListAnalysesRequest, opts ...grpc.CallOption) (*ListAnalysesResponse, error) {
	out := new(ListAnalysesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/ListAnalyses", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) DeleteAnalysis(ctx context.Context, in *DeleteAnalysisRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/DeleteAnalysis", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) BulkAnalyzeConversations(ctx context.Context, in *BulkAnalyzeConversationsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/BulkAnalyzeConversations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) BulkDeleteConversations(ctx context.Context, in *BulkDeleteConversationsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/BulkDeleteConversations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) IngestConversations(ctx context.Context, in *IngestConversationsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/IngestConversations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) ExportInsightsData(ctx context.Context, in *ExportInsightsDataRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/ExportInsightsData", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) CreateIssueModel(ctx context.Context, in *CreateIssueModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/CreateIssueModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) UpdateIssueModel(ctx context.Context, in *UpdateIssueModelRequest, opts ...grpc.CallOption) (*IssueModel, error) {
	out := new(IssueModel)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/UpdateIssueModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) GetIssueModel(ctx context.Context, in *GetIssueModelRequest, opts ...grpc.CallOption) (*IssueModel, error) {
	out := new(IssueModel)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/GetIssueModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) ListIssueModels(ctx context.Context, in *ListIssueModelsRequest, opts ...grpc.CallOption) (*ListIssueModelsResponse, error) {
	out := new(ListIssueModelsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/ListIssueModels", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) DeleteIssueModel(ctx context.Context, in *DeleteIssueModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/DeleteIssueModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) DeployIssueModel(ctx context.Context, in *DeployIssueModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/DeployIssueModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) UndeployIssueModel(ctx context.Context, in *UndeployIssueModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/UndeployIssueModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) GetIssue(ctx context.Context, in *GetIssueRequest, opts ...grpc.CallOption) (*Issue, error) {
	out := new(Issue)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/GetIssue", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) ListIssues(ctx context.Context, in *ListIssuesRequest, opts ...grpc.CallOption) (*ListIssuesResponse, error) {
	out := new(ListIssuesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/ListIssues", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) UpdateIssue(ctx context.Context, in *UpdateIssueRequest, opts ...grpc.CallOption) (*Issue, error) {
	out := new(Issue)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/UpdateIssue", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) DeleteIssue(ctx context.Context, in *DeleteIssueRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/DeleteIssue", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) CalculateIssueModelStats(ctx context.Context, in *CalculateIssueModelStatsRequest, opts ...grpc.CallOption) (*CalculateIssueModelStatsResponse, error) {
	out := new(CalculateIssueModelStatsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/CalculateIssueModelStats", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) CreatePhraseMatcher(ctx context.Context, in *CreatePhraseMatcherRequest, opts ...grpc.CallOption) (*PhraseMatcher, error) {
	out := new(PhraseMatcher)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/CreatePhraseMatcher", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) GetPhraseMatcher(ctx context.Context, in *GetPhraseMatcherRequest, opts ...grpc.CallOption) (*PhraseMatcher, error) {
	out := new(PhraseMatcher)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/GetPhraseMatcher", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) ListPhraseMatchers(ctx context.Context, in *ListPhraseMatchersRequest, opts ...grpc.CallOption) (*ListPhraseMatchersResponse, error) {
	out := new(ListPhraseMatchersResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/ListPhraseMatchers", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) DeletePhraseMatcher(ctx context.Context, in *DeletePhraseMatcherRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/DeletePhraseMatcher", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) UpdatePhraseMatcher(ctx context.Context, in *UpdatePhraseMatcherRequest, opts ...grpc.CallOption) (*PhraseMatcher, error) {
	out := new(PhraseMatcher)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/UpdatePhraseMatcher", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) CalculateStats(ctx context.Context, in *CalculateStatsRequest, opts ...grpc.CallOption) (*CalculateStatsResponse, error) {
	out := new(CalculateStatsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/CalculateStats", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) GetSettings(ctx context.Context, in *GetSettingsRequest, opts ...grpc.CallOption) (*Settings, error) {
	out := new(Settings)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/GetSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) UpdateSettings(ctx context.Context, in *UpdateSettingsRequest, opts ...grpc.CallOption) (*Settings, error) {
	out := new(Settings)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/UpdateSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) CreateView(ctx context.Context, in *CreateViewRequest, opts ...grpc.CallOption) (*View, error) {
	out := new(View)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/CreateView", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) GetView(ctx context.Context, in *GetViewRequest, opts ...grpc.CallOption) (*View, error) {
	out := new(View)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/GetView", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) ListViews(ctx context.Context, in *ListViewsRequest, opts ...grpc.CallOption) (*ListViewsResponse, error) {
	out := new(ListViewsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/ListViews", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) UpdateView(ctx context.Context, in *UpdateViewRequest, opts ...grpc.CallOption) (*View, error) {
	out := new(View)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/UpdateView", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactCenterInsightsClient) DeleteView(ctx context.Context, in *DeleteViewRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/DeleteView", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ContactCenterInsightsServer is the server API for ContactCenterInsights service.
type ContactCenterInsightsServer interface {
	// Creates a conversation.
	CreateConversation(context.Context, *CreateConversationRequest) (*Conversation, error)
	// Create a longrunning conversation upload operation. This method differs
	// from CreateConversation by allowing audio transcription and optional DLP
	// redaction.
	UploadConversation(context.Context, *UploadConversationRequest) (*longrunningpb.Operation, error)
	// Updates a conversation.
	UpdateConversation(context.Context, *UpdateConversationRequest) (*Conversation, error)
	// Gets a conversation.
	GetConversation(context.Context, *GetConversationRequest) (*Conversation, error)
	// Lists conversations.
	ListConversations(context.Context, *ListConversationsRequest) (*ListConversationsResponse, error)
	// Deletes a conversation.
	DeleteConversation(context.Context, *DeleteConversationRequest) (*emptypb.Empty, error)
	// Creates an analysis. The long running operation is done when the analysis
	// has completed.
	CreateAnalysis(context.Context, *CreateAnalysisRequest) (*longrunningpb.Operation, error)
	// Gets an analysis.
	GetAnalysis(context.Context, *GetAnalysisRequest) (*Analysis, error)
	// Lists analyses.
	ListAnalyses(context.Context, *ListAnalysesRequest) (*ListAnalysesResponse, error)
	// Deletes an analysis.
	DeleteAnalysis(context.Context, *DeleteAnalysisRequest) (*emptypb.Empty, error)
	// Analyzes multiple conversations in a single request.
	BulkAnalyzeConversations(context.Context, *BulkAnalyzeConversationsRequest) (*longrunningpb.Operation, error)
	// Deletes multiple conversations in a single request.
	BulkDeleteConversations(context.Context, *BulkDeleteConversationsRequest) (*longrunningpb.Operation, error)
	// Imports conversations and processes them according to the user's
	// configuration.
	IngestConversations(context.Context, *IngestConversationsRequest) (*longrunningpb.Operation, error)
	// Export insights data to a destination defined in the request body.
	ExportInsightsData(context.Context, *ExportInsightsDataRequest) (*longrunningpb.Operation, error)
	// Creates an issue model.
	CreateIssueModel(context.Context, *CreateIssueModelRequest) (*longrunningpb.Operation, error)
	// Updates an issue model.
	UpdateIssueModel(context.Context, *UpdateIssueModelRequest) (*IssueModel, error)
	// Gets an issue model.
	GetIssueModel(context.Context, *GetIssueModelRequest) (*IssueModel, error)
	// Lists issue models.
	ListIssueModels(context.Context, *ListIssueModelsRequest) (*ListIssueModelsResponse, error)
	// Deletes an issue model.
	DeleteIssueModel(context.Context, *DeleteIssueModelRequest) (*longrunningpb.Operation, error)
	// Deploys an issue model. Returns an error if a model is already deployed.
	// An issue model can only be used in analysis after it has been deployed.
	DeployIssueModel(context.Context, *DeployIssueModelRequest) (*longrunningpb.Operation, error)
	// Undeploys an issue model.
	// An issue model can not be used in analysis after it has been undeployed.
	UndeployIssueModel(context.Context, *UndeployIssueModelRequest) (*longrunningpb.Operation, error)
	// Gets an issue.
	GetIssue(context.Context, *GetIssueRequest) (*Issue, error)
	// Lists issues.
	ListIssues(context.Context, *ListIssuesRequest) (*ListIssuesResponse, error)
	// Updates an issue.
	UpdateIssue(context.Context, *UpdateIssueRequest) (*Issue, error)
	// Deletes an issue.
	DeleteIssue(context.Context, *DeleteIssueRequest) (*emptypb.Empty, error)
	// Gets an issue model's statistics.
	CalculateIssueModelStats(context.Context, *CalculateIssueModelStatsRequest) (*CalculateIssueModelStatsResponse, error)
	// Creates a phrase matcher.
	CreatePhraseMatcher(context.Context, *CreatePhraseMatcherRequest) (*PhraseMatcher, error)
	// Gets a phrase matcher.
	GetPhraseMatcher(context.Context, *GetPhraseMatcherRequest) (*PhraseMatcher, error)
	// Lists phrase matchers.
	ListPhraseMatchers(context.Context, *ListPhraseMatchersRequest) (*ListPhraseMatchersResponse, error)
	// Deletes a phrase matcher.
	DeletePhraseMatcher(context.Context, *DeletePhraseMatcherRequest) (*emptypb.Empty, error)
	// Updates a phrase matcher.
	UpdatePhraseMatcher(context.Context, *UpdatePhraseMatcherRequest) (*PhraseMatcher, error)
	// Gets conversation statistics.
	CalculateStats(context.Context, *CalculateStatsRequest) (*CalculateStatsResponse, error)
	// Gets project-level settings.
	GetSettings(context.Context, *GetSettingsRequest) (*Settings, error)
	// Updates project-level settings.
	UpdateSettings(context.Context, *UpdateSettingsRequest) (*Settings, error)
	// Creates a view.
	CreateView(context.Context, *CreateViewRequest) (*View, error)
	// Gets a view.
	GetView(context.Context, *GetViewRequest) (*View, error)
	// Lists views.
	ListViews(context.Context, *ListViewsRequest) (*ListViewsResponse, error)
	// Updates a view.
	UpdateView(context.Context, *UpdateViewRequest) (*View, error)
	// Deletes a view.
	DeleteView(context.Context, *DeleteViewRequest) (*emptypb.Empty, error)
}

// UnimplementedContactCenterInsightsServer can be embedded to have forward compatible implementations.
type UnimplementedContactCenterInsightsServer struct {
}

func (*UnimplementedContactCenterInsightsServer) CreateConversation(context.Context, *CreateConversationRequest) (*Conversation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateConversation not implemented")
}
func (*UnimplementedContactCenterInsightsServer) UploadConversation(context.Context, *UploadConversationRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UploadConversation not implemented")
}
func (*UnimplementedContactCenterInsightsServer) UpdateConversation(context.Context, *UpdateConversationRequest) (*Conversation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateConversation not implemented")
}
func (*UnimplementedContactCenterInsightsServer) GetConversation(context.Context, *GetConversationRequest) (*Conversation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetConversation not implemented")
}
func (*UnimplementedContactCenterInsightsServer) ListConversations(context.Context, *ListConversationsRequest) (*ListConversationsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListConversations not implemented")
}
func (*UnimplementedContactCenterInsightsServer) DeleteConversation(context.Context, *DeleteConversationRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteConversation not implemented")
}
func (*UnimplementedContactCenterInsightsServer) CreateAnalysis(context.Context, *CreateAnalysisRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateAnalysis not implemented")
}
func (*UnimplementedContactCenterInsightsServer) GetAnalysis(context.Context, *GetAnalysisRequest) (*Analysis, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetAnalysis not implemented")
}
func (*UnimplementedContactCenterInsightsServer) ListAnalyses(context.Context, *ListAnalysesRequest) (*ListAnalysesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListAnalyses not implemented")
}
func (*UnimplementedContactCenterInsightsServer) DeleteAnalysis(context.Context, *DeleteAnalysisRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteAnalysis not implemented")
}
func (*UnimplementedContactCenterInsightsServer) BulkAnalyzeConversations(context.Context, *BulkAnalyzeConversationsRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method BulkAnalyzeConversations not implemented")
}
func (*UnimplementedContactCenterInsightsServer) BulkDeleteConversations(context.Context, *BulkDeleteConversationsRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method BulkDeleteConversations not implemented")
}
func (*UnimplementedContactCenterInsightsServer) IngestConversations(context.Context, *IngestConversationsRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method IngestConversations not implemented")
}
func (*UnimplementedContactCenterInsightsServer) ExportInsightsData(context.Context, *ExportInsightsDataRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ExportInsightsData not implemented")
}
func (*UnimplementedContactCenterInsightsServer) CreateIssueModel(context.Context, *CreateIssueModelRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateIssueModel not implemented")
}
func (*UnimplementedContactCenterInsightsServer) UpdateIssueModel(context.Context, *UpdateIssueModelRequest) (*IssueModel, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateIssueModel not implemented")
}
func (*UnimplementedContactCenterInsightsServer) GetIssueModel(context.Context, *GetIssueModelRequest) (*IssueModel, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetIssueModel not implemented")
}
func (*UnimplementedContactCenterInsightsServer) ListIssueModels(context.Context, *ListIssueModelsRequest) (*ListIssueModelsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListIssueModels not implemented")
}
func (*UnimplementedContactCenterInsightsServer) DeleteIssueModel(context.Context, *DeleteIssueModelRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteIssueModel not implemented")
}
func (*UnimplementedContactCenterInsightsServer) DeployIssueModel(context.Context, *DeployIssueModelRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeployIssueModel not implemented")
}
func (*UnimplementedContactCenterInsightsServer) UndeployIssueModel(context.Context, *UndeployIssueModelRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UndeployIssueModel not implemented")
}
func (*UnimplementedContactCenterInsightsServer) GetIssue(context.Context, *GetIssueRequest) (*Issue, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetIssue not implemented")
}
func (*UnimplementedContactCenterInsightsServer) ListIssues(context.Context, *ListIssuesRequest) (*ListIssuesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListIssues not implemented")
}
func (*UnimplementedContactCenterInsightsServer) UpdateIssue(context.Context, *UpdateIssueRequest) (*Issue, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateIssue not implemented")
}
func (*UnimplementedContactCenterInsightsServer) DeleteIssue(context.Context, *DeleteIssueRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteIssue not implemented")
}
func (*UnimplementedContactCenterInsightsServer) CalculateIssueModelStats(context.Context, *CalculateIssueModelStatsRequest) (*CalculateIssueModelStatsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CalculateIssueModelStats not implemented")
}
func (*UnimplementedContactCenterInsightsServer) CreatePhraseMatcher(context.Context, *CreatePhraseMatcherRequest) (*PhraseMatcher, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreatePhraseMatcher not implemented")
}
func (*UnimplementedContactCenterInsightsServer) GetPhraseMatcher(context.Context, *GetPhraseMatcherRequest) (*PhraseMatcher, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetPhraseMatcher not implemented")
}
func (*UnimplementedContactCenterInsightsServer) ListPhraseMatchers(context.Context, *ListPhraseMatchersRequest) (*ListPhraseMatchersResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListPhraseMatchers not implemented")
}
func (*UnimplementedContactCenterInsightsServer) DeletePhraseMatcher(context.Context, *DeletePhraseMatcherRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeletePhraseMatcher not implemented")
}
func (*UnimplementedContactCenterInsightsServer) UpdatePhraseMatcher(context.Context, *UpdatePhraseMatcherRequest) (*PhraseMatcher, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdatePhraseMatcher not implemented")
}
func (*UnimplementedContactCenterInsightsServer) CalculateStats(context.Context, *CalculateStatsRequest) (*CalculateStatsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CalculateStats not implemented")
}
func (*UnimplementedContactCenterInsightsServer) GetSettings(context.Context, *GetSettingsRequest) (*Settings, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetSettings not implemented")
}
func (*UnimplementedContactCenterInsightsServer) UpdateSettings(context.Context, *UpdateSettingsRequest) (*Settings, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateSettings not implemented")
}
func (*UnimplementedContactCenterInsightsServer) CreateView(context.Context, *CreateViewRequest) (*View, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateView not implemented")
}
func (*UnimplementedContactCenterInsightsServer) GetView(context.Context, *GetViewRequest) (*View, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetView not implemented")
}
func (*UnimplementedContactCenterInsightsServer) ListViews(context.Context, *ListViewsRequest) (*ListViewsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListViews not implemented")
}
func (*UnimplementedContactCenterInsightsServer) UpdateView(context.Context, *UpdateViewRequest) (*View, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateView not implemented")
}
func (*UnimplementedContactCenterInsightsServer) DeleteView(context.Context, *DeleteViewRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteView not implemented")
}

func RegisterContactCenterInsightsServer(s *grpc.Server, srv ContactCenterInsightsServer) {
	s.RegisterService(&_ContactCenterInsights_serviceDesc, srv)
}

func _ContactCenterInsights_CreateConversation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateConversationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).CreateConversation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/CreateConversation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).CreateConversation(ctx, req.(*CreateConversationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_UploadConversation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UploadConversationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).UploadConversation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/UploadConversation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).UploadConversation(ctx, req.(*UploadConversationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_UpdateConversation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateConversationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).UpdateConversation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/UpdateConversation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).UpdateConversation(ctx, req.(*UpdateConversationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_GetConversation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConversationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).GetConversation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/GetConversation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).GetConversation(ctx, req.(*GetConversationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_ListConversations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListConversationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).ListConversations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/ListConversations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).ListConversations(ctx, req.(*ListConversationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_DeleteConversation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteConversationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).DeleteConversation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/DeleteConversation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).DeleteConversation(ctx, req.(*DeleteConversationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_CreateAnalysis_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAnalysisRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).CreateAnalysis(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/CreateAnalysis",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).CreateAnalysis(ctx, req.(*CreateAnalysisRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_GetAnalysis_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAnalysisRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).GetAnalysis(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/GetAnalysis",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).GetAnalysis(ctx, req.(*GetAnalysisRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_ListAnalyses_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAnalysesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).ListAnalyses(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/ListAnalyses",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).ListAnalyses(ctx, req.(*ListAnalysesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_DeleteAnalysis_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAnalysisRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).DeleteAnalysis(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/DeleteAnalysis",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).DeleteAnalysis(ctx, req.(*DeleteAnalysisRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_BulkAnalyzeConversations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BulkAnalyzeConversationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).BulkAnalyzeConversations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/BulkAnalyzeConversations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).BulkAnalyzeConversations(ctx, req.(*BulkAnalyzeConversationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_BulkDeleteConversations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BulkDeleteConversationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).BulkDeleteConversations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/BulkDeleteConversations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).BulkDeleteConversations(ctx, req.(*BulkDeleteConversationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_IngestConversations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(IngestConversationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).IngestConversations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/IngestConversations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).IngestConversations(ctx, req.(*IngestConversationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_ExportInsightsData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportInsightsDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).ExportInsightsData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/ExportInsightsData",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).ExportInsightsData(ctx, req.(*ExportInsightsDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_CreateIssueModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateIssueModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).CreateIssueModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/CreateIssueModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).CreateIssueModel(ctx, req.(*CreateIssueModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_UpdateIssueModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateIssueModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).UpdateIssueModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/UpdateIssueModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).UpdateIssueModel(ctx, req.(*UpdateIssueModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_GetIssueModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIssueModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).GetIssueModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/GetIssueModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).GetIssueModel(ctx, req.(*GetIssueModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_ListIssueModels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListIssueModelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).ListIssueModels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/ListIssueModels",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).ListIssueModels(ctx, req.(*ListIssueModelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_DeleteIssueModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteIssueModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).DeleteIssueModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/DeleteIssueModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).DeleteIssueModel(ctx, req.(*DeleteIssueModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_DeployIssueModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeployIssueModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).DeployIssueModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/DeployIssueModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).DeployIssueModel(ctx, req.(*DeployIssueModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_UndeployIssueModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UndeployIssueModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).UndeployIssueModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/UndeployIssueModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).UndeployIssueModel(ctx, req.(*UndeployIssueModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_GetIssue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIssueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).GetIssue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/GetIssue",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).GetIssue(ctx, req.(*GetIssueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_ListIssues_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListIssuesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).ListIssues(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/ListIssues",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).ListIssues(ctx, req.(*ListIssuesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_UpdateIssue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateIssueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).UpdateIssue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/UpdateIssue",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).UpdateIssue(ctx, req.(*UpdateIssueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_DeleteIssue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteIssueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).DeleteIssue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/DeleteIssue",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).DeleteIssue(ctx, req.(*DeleteIssueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_CalculateIssueModelStats_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CalculateIssueModelStatsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).CalculateIssueModelStats(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/CalculateIssueModelStats",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).CalculateIssueModelStats(ctx, req.(*CalculateIssueModelStatsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_CreatePhraseMatcher_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePhraseMatcherRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).CreatePhraseMatcher(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/CreatePhraseMatcher",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).CreatePhraseMatcher(ctx, req.(*CreatePhraseMatcherRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_GetPhraseMatcher_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPhraseMatcherRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).GetPhraseMatcher(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/GetPhraseMatcher",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).GetPhraseMatcher(ctx, req.(*GetPhraseMatcherRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_ListPhraseMatchers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPhraseMatchersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).ListPhraseMatchers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/ListPhraseMatchers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).ListPhraseMatchers(ctx, req.(*ListPhraseMatchersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_DeletePhraseMatcher_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePhraseMatcherRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).DeletePhraseMatcher(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/DeletePhraseMatcher",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).DeletePhraseMatcher(ctx, req.(*DeletePhraseMatcherRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_UpdatePhraseMatcher_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdatePhraseMatcherRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).UpdatePhraseMatcher(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/UpdatePhraseMatcher",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).UpdatePhraseMatcher(ctx, req.(*UpdatePhraseMatcherRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_CalculateStats_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CalculateStatsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).CalculateStats(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/CalculateStats",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).CalculateStats(ctx, req.(*CalculateStatsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_GetSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).GetSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/GetSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).GetSettings(ctx, req.(*GetSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_UpdateSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).UpdateSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/UpdateSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).UpdateSettings(ctx, req.(*UpdateSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_CreateView_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateViewRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).CreateView(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/CreateView",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).CreateView(ctx, req.(*CreateViewRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_GetView_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetViewRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).GetView(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/GetView",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).GetView(ctx, req.(*GetViewRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_ListViews_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListViewsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).ListViews(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/ListViews",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).ListViews(ctx, req.(*ListViewsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_UpdateView_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateViewRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).UpdateView(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/UpdateView",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).UpdateView(ctx, req.(*UpdateViewRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactCenterInsights_DeleteView_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteViewRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactCenterInsightsServer).DeleteView(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contactcenterinsights.v1.ContactCenterInsights/DeleteView",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactCenterInsightsServer).DeleteView(ctx, req.(*DeleteViewRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ContactCenterInsights_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
	HandlerType: (*ContactCenterInsightsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateConversation",
			Handler:    _ContactCenterInsights_CreateConversation_Handler,
		},
		{
			MethodName: "UploadConversation",
			Handler:    _ContactCenterInsights_UploadConversation_Handler,
		},
		{
			MethodName: "UpdateConversation",
			Handler:    _ContactCenterInsights_UpdateConversation_Handler,
		},
		{
			MethodName: "GetConversation",
			Handler:    _ContactCenterInsights_GetConversation_Handler,
		},
		{
			MethodName: "ListConversations",
			Handler:    _ContactCenterInsights_ListConversations_Handler,
		},
		{
			MethodName: "DeleteConversation",
			Handler:    _ContactCenterInsights_DeleteConversation_Handler,
		},
		{
			MethodName: "CreateAnalysis",
			Handler:    _ContactCenterInsights_CreateAnalysis_Handler,
		},
		{
			MethodName: "GetAnalysis",
			Handler:    _ContactCenterInsights_GetAnalysis_Handler,
		},
		{
			MethodName: "ListAnalyses",
			Handler:    _ContactCenterInsights_ListAnalyses_Handler,
		},
		{
			MethodName: "DeleteAnalysis",
			Handler:    _ContactCenterInsights_DeleteAnalysis_Handler,
		},
		{
			MethodName: "BulkAnalyzeConversations",
			Handler:    _ContactCenterInsights_BulkAnalyzeConversations_Handler,
		},
		{
			MethodName: "BulkDeleteConversations",
			Handler:    _ContactCenterInsights_BulkDeleteConversations_Handler,
		},
		{
			MethodName: "IngestConversations",
			Handler:    _ContactCenterInsights_IngestConversations_Handler,
		},
		{
			MethodName: "ExportInsightsData",
			Handler:    _ContactCenterInsights_ExportInsightsData_Handler,
		},
		{
			MethodName: "CreateIssueModel",
			Handler:    _ContactCenterInsights_CreateIssueModel_Handler,
		},
		{
			MethodName: "UpdateIssueModel",
			Handler:    _ContactCenterInsights_UpdateIssueModel_Handler,
		},
		{
			MethodName: "GetIssueModel",
			Handler:    _ContactCenterInsights_GetIssueModel_Handler,
		},
		{
			MethodName: "ListIssueModels",
			Handler:    _ContactCenterInsights_ListIssueModels_Handler,
		},
		{
			MethodName: "DeleteIssueModel",
			Handler:    _ContactCenterInsights_DeleteIssueModel_Handler,
		},
		{
			MethodName: "DeployIssueModel",
			Handler:    _ContactCenterInsights_DeployIssueModel_Handler,
		},
		{
			MethodName: "UndeployIssueModel",
			Handler:    _ContactCenterInsights_UndeployIssueModel_Handler,
		},
		{
			MethodName: "GetIssue",
			Handler:    _ContactCenterInsights_GetIssue_Handler,
		},
		{
			MethodName: "ListIssues",
			Handler:    _ContactCenterInsights_ListIssues_Handler,
		},
		{
			MethodName: "UpdateIssue",
			Handler:    _ContactCenterInsights_UpdateIssue_Handler,
		},
		{
			MethodName: "DeleteIssue",
			Handler:    _ContactCenterInsights_DeleteIssue_Handler,
		},
		{
			MethodName: "CalculateIssueModelStats",
			Handler:    _ContactCenterInsights_CalculateIssueModelStats_Handler,
		},
		{
			MethodName: "CreatePhraseMatcher",
			Handler:    _ContactCenterInsights_CreatePhraseMatcher_Handler,
		},
		{
			MethodName: "GetPhraseMatcher",
			Handler:    _ContactCenterInsights_GetPhraseMatcher_Handler,
		},
		{
			MethodName: "ListPhraseMatchers",
			Handler:    _ContactCenterInsights_ListPhraseMatchers_Handler,
		},
		{
			MethodName: "DeletePhraseMatcher",
			Handler:    _ContactCenterInsights_DeletePhraseMatcher_Handler,
		},
		{
			MethodName: "UpdatePhraseMatcher",
			Handler:    _ContactCenterInsights_UpdatePhraseMatcher_Handler,
		},
		{
			MethodName: "CalculateStats",
			Handler:    _ContactCenterInsights_CalculateStats_Handler,
		},
		{
			MethodName: "GetSettings",
			Handler:    _ContactCenterInsights_GetSettings_Handler,
		},
		{
			MethodName: "UpdateSettings",
			Handler:    _ContactCenterInsights_UpdateSettings_Handler,
		},
		{
			MethodName: "CreateView",
			Handler:    _ContactCenterInsights_CreateView_Handler,
		},
		{
			MethodName: "GetView",
			Handler:    _ContactCenterInsights_GetView_Handler,
		},
		{
			MethodName: "ListViews",
			Handler:    _ContactCenterInsights_ListViews_Handler,
		},
		{
			MethodName: "UpdateView",
			Handler:    _ContactCenterInsights_UpdateView_Handler,
		},
		{
			MethodName: "DeleteView",
			Handler:    _ContactCenterInsights_DeleteView_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/contactcenterinsights/v1/contact_center_insights.proto",
}
