// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.31.0
// 	protoc        v4.23.2
// source: google/cloud/dialogflow/cx/v3beta1/security_settings.proto

package cxpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Defines how we redact data.
type SecuritySettings_RedactionStrategy int32

const (
	// Do not redact.
	SecuritySettings_REDACTION_STRATEGY_UNSPECIFIED SecuritySettings_RedactionStrategy = 0
	// Call redaction service to clean up the data to be persisted.
	SecuritySettings_REDACT_WITH_SERVICE SecuritySettings_RedactionStrategy = 1
)

// Enum value maps for SecuritySettings_RedactionStrategy.
var (
	SecuritySettings_RedactionStrategy_name = map[int32]string{
		0: "REDACTION_STRATEGY_UNSPECIFIED",
		1: "REDACT_WITH_SERVICE",
	}
	SecuritySettings_RedactionStrategy_value = map[string]int32{
		"REDACTION_STRATEGY_UNSPECIFIED": 0,
		"REDACT_WITH_SERVICE":            1,
	}
)

func (x SecuritySettings_RedactionStrategy) Enum() *SecuritySettings_RedactionStrategy {
	p := new(SecuritySettings_RedactionStrategy)
	*p = x
	return p
}

func (x SecuritySettings_RedactionStrategy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SecuritySettings_RedactionStrategy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_enumTypes[0].Descriptor()
}

func (SecuritySettings_RedactionStrategy) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_enumTypes[0]
}

func (x SecuritySettings_RedactionStrategy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SecuritySettings_RedactionStrategy.Descriptor instead.
func (SecuritySettings_RedactionStrategy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_rawDescGZIP(), []int{6, 0}
}

// Defines what types of data to redact.
type SecuritySettings_RedactionScope int32

const (
	// Don't redact any kind of data.
	SecuritySettings_REDACTION_SCOPE_UNSPECIFIED SecuritySettings_RedactionScope = 0
	// On data to be written to disk or similar devices that are capable of
	// holding data even if power is disconnected. This includes data that are
	// temporarily saved on disk.
	SecuritySettings_REDACT_DISK_STORAGE SecuritySettings_RedactionScope = 2
)

// Enum value maps for SecuritySettings_RedactionScope.
var (
	SecuritySettings_RedactionScope_name = map[int32]string{
		0: "REDACTION_SCOPE_UNSPECIFIED",
		2: "REDACT_DISK_STORAGE",
	}
	SecuritySettings_RedactionScope_value = map[string]int32{
		"REDACTION_SCOPE_UNSPECIFIED": 0,
		"REDACT_DISK_STORAGE":         2,
	}
)

func (x SecuritySettings_RedactionScope) Enum() *SecuritySettings_RedactionScope {
	p := new(SecuritySettings_RedactionScope)
	*p = x
	return p
}

func (x SecuritySettings_RedactionScope) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SecuritySettings_RedactionScope) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_enumTypes[1].Descriptor()
}

func (SecuritySettings_RedactionScope) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_enumTypes[1]
}

func (x SecuritySettings_RedactionScope) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SecuritySettings_RedactionScope.Descriptor instead.
func (SecuritySettings_RedactionScope) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_rawDescGZIP(), []int{6, 1}
}

// Defines how long we retain persisted data that contains sensitive info.
type SecuritySettings_RetentionStrategy int32

const (
	// Retains the persisted data with Dialogflow's internal default 365d TTLs.
	SecuritySettings_RETENTION_STRATEGY_UNSPECIFIED SecuritySettings_RetentionStrategy = 0
	// Removes data when the conversation ends. If there is no [Conversation][]
	// explicitly established, a default conversation ends when the
	// corresponding Dialogflow session ends.
	SecuritySettings_REMOVE_AFTER_CONVERSATION SecuritySettings_RetentionStrategy = 1
)

// Enum value maps for SecuritySettings_RetentionStrategy.
var (
	SecuritySettings_RetentionStrategy_name = map[int32]string{
		0: "RETENTION_STRATEGY_UNSPECIFIED",
		1: "REMOVE_AFTER_CONVERSATION",
	}
	SecuritySettings_RetentionStrategy_value = map[string]int32{
		"RETENTION_STRATEGY_UNSPECIFIED": 0,
		"REMOVE_AFTER_CONVERSATION":      1,
	}
)

func (x SecuritySettings_RetentionStrategy) Enum() *SecuritySettings_RetentionStrategy {
	p := new(SecuritySettings_RetentionStrategy)
	*p = x
	return p
}

func (x SecuritySettings_RetentionStrategy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SecuritySettings_RetentionStrategy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_enumTypes[2].Descriptor()
}

func (SecuritySettings_RetentionStrategy) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_enumTypes[2]
}

func (x SecuritySettings_RetentionStrategy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SecuritySettings_RetentionStrategy.Descriptor instead.
func (SecuritySettings_RetentionStrategy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_rawDescGZIP(), []int{6, 2}
}

// Type of data we purge after retention settings triggers purge.
type SecuritySettings_PurgeDataType int32

const (
	// Unspecified. Do not use.
	SecuritySettings_PURGE_DATA_TYPE_UNSPECIFIED SecuritySettings_PurgeDataType = 0
	// Dialogflow history. This does not include Cloud logging, which is
	// owned by the user - not Dialogflow.
	SecuritySettings_DIALOGFLOW_HISTORY SecuritySettings_PurgeDataType = 1
)

// Enum value maps for SecuritySettings_PurgeDataType.
var (
	SecuritySettings_PurgeDataType_name = map[int32]string{
		0: "PURGE_DATA_TYPE_UNSPECIFIED",
		1: "DIALOGFLOW_HISTORY",
	}
	SecuritySettings_PurgeDataType_value = map[string]int32{
		"PURGE_DATA_TYPE_UNSPECIFIED": 0,
		"DIALOGFLOW_HISTORY":          1,
	}
)

func (x SecuritySettings_PurgeDataType) Enum() *SecuritySettings_PurgeDataType {
	p := new(SecuritySettings_PurgeDataType)
	*p = x
	return p
}

func (x SecuritySettings_PurgeDataType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SecuritySettings_PurgeDataType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_enumTypes[3].Descriptor()
}

func (SecuritySettings_PurgeDataType) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_enumTypes[3]
}

func (x SecuritySettings_PurgeDataType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SecuritySettings_PurgeDataType.Descriptor instead.
func (SecuritySettings_PurgeDataType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_rawDescGZIP(), []int{6, 3}
}

// File format for exported audio file. Currently only in telephony
// recordings.
type SecuritySettings_AudioExportSettings_AudioFormat int32

const (
	// Unspecified. Do not use.
	SecuritySettings_AudioExportSettings_AUDIO_FORMAT_UNSPECIFIED SecuritySettings_AudioExportSettings_AudioFormat = 0
	// G.711 mu-law PCM with 8kHz sample rate.
	SecuritySettings_AudioExportSettings_MULAW SecuritySettings_AudioExportSettings_AudioFormat = 1
	// MP3 file format.
	SecuritySettings_AudioExportSettings_MP3 SecuritySettings_AudioExportSettings_AudioFormat = 2
	// OGG Vorbis.
	SecuritySettings_AudioExportSettings_OGG SecuritySettings_AudioExportSettings_AudioFormat = 3
)

// Enum value maps for SecuritySettings_AudioExportSettings_AudioFormat.
var (
	SecuritySettings_AudioExportSettings_AudioFormat_name = map[int32]string{
		0: "AUDIO_FORMAT_UNSPECIFIED",
		1: "MULAW",
		2: "MP3",
		3: "OGG",
	}
	SecuritySettings_AudioExportSettings_AudioFormat_value = map[string]int32{
		"AUDIO_FORMAT_UNSPECIFIED": 0,
		"MULAW":                    1,
		"MP3":                      2,
		"OGG":                      3,
	}
)

func (x SecuritySettings_AudioExportSettings_AudioFormat) Enum() *SecuritySettings_AudioExportSettings_AudioFormat {
	p := new(SecuritySettings_AudioExportSettings_AudioFormat)
	*p = x
	return p
}

func (x SecuritySettings_AudioExportSettings_AudioFormat) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SecuritySettings_AudioExportSettings_AudioFormat) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_enumTypes[4].Descriptor()
}

func (SecuritySettings_AudioExportSettings_AudioFormat) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_enumTypes[4]
}

func (x SecuritySettings_AudioExportSettings_AudioFormat) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SecuritySettings_AudioExportSettings_AudioFormat.Descriptor instead.
func (SecuritySettings_AudioExportSettings_AudioFormat) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_rawDescGZIP(), []int{6, 0, 0}
}

// The request message for
// [SecuritySettingsService.GetSecuritySettings][google.cloud.dialogflow.cx.v3beta1.SecuritySettingsService.GetSecuritySettings].
type GetSecuritySettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the settings.
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/securitySettings/<security settings ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSecuritySettingsRequest) Reset() {
	*x = GetSecuritySettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSecuritySettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSecuritySettingsRequest) ProtoMessage() {}

func (x *GetSecuritySettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSecuritySettingsRequest.ProtoReflect.Descriptor instead.
func (*GetSecuritySettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_rawDescGZIP(), []int{0}
}

func (x *GetSecuritySettingsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for
// [SecuritySettingsService.UpdateSecuritySettings][google.cloud.dialogflow.cx.v3beta1.SecuritySettingsService.UpdateSecuritySettings].
type UpdateSecuritySettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. [SecuritySettings] object that contains values for each of the
	// fields to update.
	SecuritySettings *SecuritySettings `protobuf:"bytes,1,opt,name=security_settings,json=securitySettings,proto3" json:"security_settings,omitempty"`
	// Required. The mask to control which fields get updated. If the mask is not
	// present, all fields will be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateSecuritySettingsRequest) Reset() {
	*x = UpdateSecuritySettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateSecuritySettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSecuritySettingsRequest) ProtoMessage() {}

func (x *UpdateSecuritySettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSecuritySettingsRequest.ProtoReflect.Descriptor instead.
func (*UpdateSecuritySettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_rawDescGZIP(), []int{1}
}

func (x *UpdateSecuritySettingsRequest) GetSecuritySettings() *SecuritySettings {
	if x != nil {
		return x.SecuritySettings
	}
	return nil
}

func (x *UpdateSecuritySettingsRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The request message for [SecuritySettings.ListSecuritySettings][].
type ListSecuritySettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The location to list all security settings for.
	// Format: `projects/<Project ID>/locations/<Location ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return in a single page. By default 20 and
	// at most 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListSecuritySettingsRequest) Reset() {
	*x = ListSecuritySettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSecuritySettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSecuritySettingsRequest) ProtoMessage() {}

func (x *ListSecuritySettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSecuritySettingsRequest.ProtoReflect.Descriptor instead.
func (*ListSecuritySettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_rawDescGZIP(), []int{2}
}

func (x *ListSecuritySettingsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListSecuritySettingsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSecuritySettingsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response message for [SecuritySettings.ListSecuritySettings][].
type ListSecuritySettingsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of security settings.
	SecuritySettings []*SecuritySettings `protobuf:"bytes,1,rep,name=security_settings,json=securitySettings,proto3" json:"security_settings,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListSecuritySettingsResponse) Reset() {
	*x = ListSecuritySettingsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSecuritySettingsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSecuritySettingsResponse) ProtoMessage() {}

func (x *ListSecuritySettingsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSecuritySettingsResponse.ProtoReflect.Descriptor instead.
func (*ListSecuritySettingsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_rawDescGZIP(), []int{3}
}

func (x *ListSecuritySettingsResponse) GetSecuritySettings() []*SecuritySettings {
	if x != nil {
		return x.SecuritySettings
	}
	return nil
}

func (x *ListSecuritySettingsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request message for [SecuritySettings.CreateSecuritySettings][].
type CreateSecuritySettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The location to create an
	// [SecuritySettings][google.cloud.dialogflow.cx.v3beta1.SecuritySettings]
	// for. Format: `projects/<Project ID>/locations/<Location ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The security settings to create.
	SecuritySettings *SecuritySettings `protobuf:"bytes,2,opt,name=security_settings,json=securitySettings,proto3" json:"security_settings,omitempty"`
}

func (x *CreateSecuritySettingsRequest) Reset() {
	*x = CreateSecuritySettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateSecuritySettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSecuritySettingsRequest) ProtoMessage() {}

func (x *CreateSecuritySettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSecuritySettingsRequest.ProtoReflect.Descriptor instead.
func (*CreateSecuritySettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_rawDescGZIP(), []int{4}
}

func (x *CreateSecuritySettingsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateSecuritySettingsRequest) GetSecuritySettings() *SecuritySettings {
	if x != nil {
		return x.SecuritySettings
	}
	return nil
}

// The request message for [SecuritySettings.DeleteSecuritySettings][].
type DeleteSecuritySettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the
	// [SecuritySettings][google.cloud.dialogflow.cx.v3beta1.SecuritySettings] to
	// delete. Format: `projects/<Project ID>/locations/<Location
	// ID>/securitySettings/<Security Settings ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteSecuritySettingsRequest) Reset() {
	*x = DeleteSecuritySettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteSecuritySettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSecuritySettingsRequest) ProtoMessage() {}

func (x *DeleteSecuritySettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSecuritySettingsRequest.ProtoReflect.Descriptor instead.
func (*DeleteSecuritySettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_rawDescGZIP(), []int{5}
}

func (x *DeleteSecuritySettingsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Represents the settings related to security issues, such as data redaction
// and data retention. It may take hours for updates on the settings to
// propagate to all the related components and take effect.
type SecuritySettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name of the settings.
	// Required for the
	// [SecuritySettingsService.UpdateSecuritySettings][google.cloud.dialogflow.cx.v3beta1.SecuritySettingsService.UpdateSecuritySettings]
	// method.
	// [SecuritySettingsService.CreateSecuritySettings][google.cloud.dialogflow.cx.v3beta1.SecuritySettingsService.CreateSecuritySettings]
	// populates the name automatically. Format: `projects/<Project
	// ID>/locations/<Location ID>/securitySettings/<Security Settings ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The human-readable name of the security settings, unique within
	// the location.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Strategy that defines how we do redaction.
	RedactionStrategy SecuritySettings_RedactionStrategy `protobuf:"varint,3,opt,name=redaction_strategy,json=redactionStrategy,proto3,enum=google.cloud.dialogflow.cx.v3beta1.SecuritySettings_RedactionStrategy" json:"redaction_strategy,omitempty"`
	// Defines the data for which Dialogflow applies redaction. Dialogflow does
	// not redact data that it does not have access to – for example, Cloud
	// logging.
	RedactionScope SecuritySettings_RedactionScope `protobuf:"varint,4,opt,name=redaction_scope,json=redactionScope,proto3,enum=google.cloud.dialogflow.cx.v3beta1.SecuritySettings_RedactionScope" json:"redaction_scope,omitempty"`
	// [DLP](https://cloud.google.com/dlp/docs) inspect template name. Use this
	// template to define inspect base settings.
	//
	// The `DLP Inspect Templates Reader` role is needed on the Dialogflow
	// service identity service account (has the form
	// `service-PROJECT_NUMBER@gcp-sa-dialogflow.iam.gserviceaccount.com`)
	// for your agent's project.
	//
	// If empty, we use the default DLP inspect config.
	//
	// The template name will have one of the following formats:
	// `projects/<Project ID>/locations/<Location ID>/inspectTemplates/<Template
	// ID>` OR `organizations/<Organization ID>/locations/<Location
	// ID>/inspectTemplates/<Template ID>`
	//
	// Note: `inspect_template` must be located in the same region as the
	// `SecuritySettings`.
	InspectTemplate string `protobuf:"bytes,9,opt,name=inspect_template,json=inspectTemplate,proto3" json:"inspect_template,omitempty"`
	// [DLP](https://cloud.google.com/dlp/docs) deidentify template name. Use this
	// template to define de-identification configuration for the content.
	//
	// The `DLP De-identify Templates Reader` role is needed on the Dialogflow
	// service identity service account (has the form
	// `service-PROJECT_NUMBER@gcp-sa-dialogflow.iam.gserviceaccount.com`)
	// for your agent's project.
	//
	// If empty, Dialogflow replaces sensitive info with `[redacted]` text.
	//
	// The template name will have one of the following formats:
	// `projects/<Project ID>/locations/<Location
	// ID>/deidentifyTemplates/<Template ID>` OR `organizations/<Organization
	// ID>/locations/<Location ID>/deidentifyTemplates/<Template ID>`
	//
	// Note: `deidentify_template` must be located in the same region as the
	// `SecuritySettings`.
	DeidentifyTemplate string `protobuf:"bytes,17,opt,name=deidentify_template,json=deidentifyTemplate,proto3" json:"deidentify_template,omitempty"`
	// Specifies how data is retained. Note that even if the data is
	// purged due to retention policy, we may still hold it in backup storage for
	// a few days without allowing direct readings.
	//
	// Types that are assignable to DataRetention:
	//	*SecuritySettings_RetentionWindowDays
	//	*SecuritySettings_RetentionStrategy_
	DataRetention isSecuritySettings_DataRetention `protobuf_oneof:"data_retention"`
	// List of types of data to remove when retention settings triggers purge.
	PurgeDataTypes []SecuritySettings_PurgeDataType `protobuf:"varint,8,rep,packed,name=purge_data_types,json=purgeDataTypes,proto3,enum=google.cloud.dialogflow.cx.v3beta1.SecuritySettings_PurgeDataType" json:"purge_data_types,omitempty"`
	// Controls audio export settings for post-conversation analytics when
	// ingesting audio to conversations via [Participants.AnalyzeContent][] or
	// [Participants.StreamingAnalyzeContent][].
	//
	// If
	// [retention_strategy][google.cloud.dialogflow.cx.v3beta1.SecuritySettings.retention_strategy]
	// is set to REMOVE_AFTER_CONVERSATION or [audio_export_settings.gcs_bucket][]
	// is empty, audio export is disabled.
	//
	// If audio export is enabled, audio is recorded and saved to
	// [audio_export_settings.gcs_bucket][], subject to retention policy of
	// [audio_export_settings.gcs_bucket][].
	//
	// This setting won't effect audio input for implicit sessions via
	// [Sessions.DetectIntent][google.cloud.dialogflow.cx.v3beta1.Sessions.DetectIntent]
	// or
	// [Sessions.StreamingDetectIntent][google.cloud.dialogflow.cx.v3beta1.Sessions.StreamingDetectIntent].
	AudioExportSettings *SecuritySettings_AudioExportSettings `protobuf:"bytes,12,opt,name=audio_export_settings,json=audioExportSettings,proto3" json:"audio_export_settings,omitempty"`
	// Controls conversation exporting settings to Insights after conversation is
	// completed.
	//
	// If
	// [retention_strategy][google.cloud.dialogflow.cx.v3beta1.SecuritySettings.retention_strategy]
	// is set to REMOVE_AFTER_CONVERSATION, Insights export is disabled no matter
	// what you configure here.
	InsightsExportSettings *SecuritySettings_InsightsExportSettings `protobuf:"bytes,13,opt,name=insights_export_settings,json=insightsExportSettings,proto3" json:"insights_export_settings,omitempty"`
}

func (x *SecuritySettings) Reset() {
	*x = SecuritySettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SecuritySettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecuritySettings) ProtoMessage() {}

func (x *SecuritySettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecuritySettings.ProtoReflect.Descriptor instead.
func (*SecuritySettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_rawDescGZIP(), []int{6}
}

func (x *SecuritySettings) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SecuritySettings) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *SecuritySettings) GetRedactionStrategy() SecuritySettings_RedactionStrategy {
	if x != nil {
		return x.RedactionStrategy
	}
	return SecuritySettings_REDACTION_STRATEGY_UNSPECIFIED
}

func (x *SecuritySettings) GetRedactionScope() SecuritySettings_RedactionScope {
	if x != nil {
		return x.RedactionScope
	}
	return SecuritySettings_REDACTION_SCOPE_UNSPECIFIED
}

func (x *SecuritySettings) GetInspectTemplate() string {
	if x != nil {
		return x.InspectTemplate
	}
	return ""
}

func (x *SecuritySettings) GetDeidentifyTemplate() string {
	if x != nil {
		return x.DeidentifyTemplate
	}
	return ""
}

func (m *SecuritySettings) GetDataRetention() isSecuritySettings_DataRetention {
	if m != nil {
		return m.DataRetention
	}
	return nil
}

func (x *SecuritySettings) GetRetentionWindowDays() int32 {
	if x, ok := x.GetDataRetention().(*SecuritySettings_RetentionWindowDays); ok {
		return x.RetentionWindowDays
	}
	return 0
}

func (x *SecuritySettings) GetRetentionStrategy() SecuritySettings_RetentionStrategy {
	if x, ok := x.GetDataRetention().(*SecuritySettings_RetentionStrategy_); ok {
		return x.RetentionStrategy
	}
	return SecuritySettings_RETENTION_STRATEGY_UNSPECIFIED
}

func (x *SecuritySettings) GetPurgeDataTypes() []SecuritySettings_PurgeDataType {
	if x != nil {
		return x.PurgeDataTypes
	}
	return nil
}

func (x *SecuritySettings) GetAudioExportSettings() *SecuritySettings_AudioExportSettings {
	if x != nil {
		return x.AudioExportSettings
	}
	return nil
}

func (x *SecuritySettings) GetInsightsExportSettings() *SecuritySettings_InsightsExportSettings {
	if x != nil {
		return x.InsightsExportSettings
	}
	return nil
}

type isSecuritySettings_DataRetention interface {
	isSecuritySettings_DataRetention()
}

type SecuritySettings_RetentionWindowDays struct {
	// Retains data in interaction logging for the specified number of days.
	// This does not apply to Cloud logging, which is owned by the user - not
	// Dialogflow.
	// User must set a value lower than Dialogflow's default 365d TTL (30 days
	// for Agent Assist traffic), higher value will be ignored and use default.
	// Setting a value higher than that has no effect. A missing value or
	// setting to 0 also means we use default TTL.
	RetentionWindowDays int32 `protobuf:"varint,6,opt,name=retention_window_days,json=retentionWindowDays,proto3,oneof"`
}

type SecuritySettings_RetentionStrategy_ struct {
	// Specifies the retention behavior defined by
	// [SecuritySettings.RetentionStrategy][google.cloud.dialogflow.cx.v3beta1.SecuritySettings.RetentionStrategy].
	RetentionStrategy SecuritySettings_RetentionStrategy `protobuf:"varint,7,opt,name=retention_strategy,json=retentionStrategy,proto3,enum=google.cloud.dialogflow.cx.v3beta1.SecuritySettings_RetentionStrategy,oneof"`
}

func (*SecuritySettings_RetentionWindowDays) isSecuritySettings_DataRetention() {}

func (*SecuritySettings_RetentionStrategy_) isSecuritySettings_DataRetention() {}

// Settings for exporting audio.
type SecuritySettings_AudioExportSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud Storage bucket to export audio record to.
	// Setting this field would grant the Storage Object Creator role to
	// the Dialogflow Service Agent.
	// API caller that tries to modify this field should have the permission of
	// storage.buckets.setIamPolicy.
	GcsBucket string `protobuf:"bytes,1,opt,name=gcs_bucket,json=gcsBucket,proto3" json:"gcs_bucket,omitempty"`
	// Filename pattern for exported audio.
	AudioExportPattern string `protobuf:"bytes,2,opt,name=audio_export_pattern,json=audioExportPattern,proto3" json:"audio_export_pattern,omitempty"`
	// Enable audio redaction if it is true.
	EnableAudioRedaction bool `protobuf:"varint,3,opt,name=enable_audio_redaction,json=enableAudioRedaction,proto3" json:"enable_audio_redaction,omitempty"`
	// File format for exported audio file. Currently only in telephony
	// recordings.
	AudioFormat SecuritySettings_AudioExportSettings_AudioFormat `protobuf:"varint,4,opt,name=audio_format,json=audioFormat,proto3,enum=google.cloud.dialogflow.cx.v3beta1.SecuritySettings_AudioExportSettings_AudioFormat" json:"audio_format,omitempty"`
}

func (x *SecuritySettings_AudioExportSettings) Reset() {
	*x = SecuritySettings_AudioExportSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SecuritySettings_AudioExportSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecuritySettings_AudioExportSettings) ProtoMessage() {}

func (x *SecuritySettings_AudioExportSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecuritySettings_AudioExportSettings.ProtoReflect.Descriptor instead.
func (*SecuritySettings_AudioExportSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_rawDescGZIP(), []int{6, 0}
}

func (x *SecuritySettings_AudioExportSettings) GetGcsBucket() string {
	if x != nil {
		return x.GcsBucket
	}
	return ""
}

func (x *SecuritySettings_AudioExportSettings) GetAudioExportPattern() string {
	if x != nil {
		return x.AudioExportPattern
	}
	return ""
}

func (x *SecuritySettings_AudioExportSettings) GetEnableAudioRedaction() bool {
	if x != nil {
		return x.EnableAudioRedaction
	}
	return false
}

func (x *SecuritySettings_AudioExportSettings) GetAudioFormat() SecuritySettings_AudioExportSettings_AudioFormat {
	if x != nil {
		return x.AudioFormat
	}
	return SecuritySettings_AudioExportSettings_AUDIO_FORMAT_UNSPECIFIED
}

// Settings for exporting conversations to
// [Insights](https://cloud.google.com/contact-center/insights/docs).
type SecuritySettings_InsightsExportSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If enabled, we will automatically exports
	// conversations to Insights and Insights runs its analyzers.
	EnableInsightsExport bool `protobuf:"varint,1,opt,name=enable_insights_export,json=enableInsightsExport,proto3" json:"enable_insights_export,omitempty"`
}

func (x *SecuritySettings_InsightsExportSettings) Reset() {
	*x = SecuritySettings_InsightsExportSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SecuritySettings_InsightsExportSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecuritySettings_InsightsExportSettings) ProtoMessage() {}

func (x *SecuritySettings_InsightsExportSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecuritySettings_InsightsExportSettings.ProtoReflect.Descriptor instead.
func (*SecuritySettings_InsightsExportSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_rawDescGZIP(), []int{6, 1}
}

func (x *SecuritySettings_InsightsExportSettings) GetEnableInsightsExport() bool {
	if x != nil {
		return x.EnableInsightsExport
	}
	return false
}

var File_google_cloud_dialogflow_cx_v3beta1_security_settings_proto protoreflect.FileDescriptor

var file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_rawDesc = []byte{
	0x0a, 0x3a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x73, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x22, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69,
	0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0x64, 0x0a, 0x1a, 0x47, 0x65, 0x74, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xc9, 0x01, 0x0a, 0x1d, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x66, 0x0a, 0x11, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x10, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d,
	0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x4d, 0x61, 0x73, 0x6b, 0x22, 0xa5, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x12, 0x2a, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a,
	0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa9, 0x01, 0x0a,
	0x1c, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x61, 0x0a,
	0x11, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x10,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xd3, 0x01, 0x0a, 0x1d, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2c, 0x12, 0x2a, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x66, 0x0a, 0x11, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76,
	0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x67,
	0x0a, 0x1d, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x8a, 0x0f, 0x0a, 0x10, 0x53, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x75, 0x0a, 0x12, 0x72, 0x65, 0x64, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x52, 0x65, 0x64, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x52, 0x11, 0x72, 0x65,
	0x64, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x12,
	0x6c, 0x0a, 0x0f, 0x72, 0x65, 0x64, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x63, 0x6f,
	0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x52,
	0x65, 0x64, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x52, 0x0e, 0x72,
	0x65, 0x64, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x12, 0x52, 0x0a,
	0x10, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x64, 0x6c,
	0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0x52, 0x0f, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x12, 0x5b, 0x0a, 0x13, 0x64, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x5f,
	0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x18, 0x11, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a,
	0xfa, 0x41, 0x27, 0x0a, 0x25, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x66, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x12, 0x64, 0x65, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x34,
	0x0a, 0x15, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x77, 0x69, 0x6e, 0x64,
	0x6f, 0x77, 0x5f, 0x64, 0x61, 0x79, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52,
	0x13, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77,
	0x44, 0x61, 0x79, 0x73, 0x12, 0x77, 0x0a, 0x12, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x48, 0x00, 0x52, 0x11, 0x72, 0x65, 0x74, 0x65,
	0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x12, 0x6c, 0x0a,
	0x10, 0x70, 0x75, 0x72, 0x67, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x50, 0x75,
	0x72, 0x67, 0x65, 0x44, 0x61, 0x74, 0x61, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0e, 0x70, 0x75, 0x72,
	0x67, 0x65, 0x44, 0x61, 0x74, 0x61, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x7c, 0x0a, 0x15, 0x61,
	0x75, 0x64, 0x69, 0x6f, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x73, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x2e, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x52, 0x13, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x45, 0x78, 0x70, 0x6f, 0x72,
	0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x85, 0x01, 0x0a, 0x18, 0x69, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x73, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x2e, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x45, 0x78, 0x70, 0x6f, 0x72,
	0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x16, 0x69, 0x6e, 0x73, 0x69, 0x67,
	0x68, 0x74, 0x73, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x1a, 0xdf, 0x02, 0x0a, 0x13, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x45, 0x78, 0x70, 0x6f, 0x72,
	0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x67, 0x63, 0x73,
	0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x67,
	0x63, 0x73, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x30, 0x0a, 0x14, 0x61, 0x75, 0x64, 0x69,
	0x6f, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x70, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x45, 0x78, 0x70,
	0x6f, 0x72, 0x74, 0x50, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x12, 0x34, 0x0a, 0x16, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x72, 0x65, 0x64, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x52, 0x65, 0x64, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x77, 0x0a, 0x0c, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x54, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x41, 0x75, 0x64,
	0x69, 0x6f, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x2e, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x52, 0x0b, 0x61, 0x75,
	0x64, 0x69, 0x6f, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x22, 0x48, 0x0a, 0x0b, 0x41, 0x75, 0x64,
	0x69, 0x6f, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x1c, 0x0a, 0x18, 0x41, 0x55, 0x44, 0x49,
	0x4f, 0x5f, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x4d, 0x55, 0x4c, 0x41, 0x57, 0x10,
	0x01, 0x12, 0x07, 0x0a, 0x03, 0x4d, 0x50, 0x33, 0x10, 0x02, 0x12, 0x07, 0x0a, 0x03, 0x4f, 0x47,
	0x47, 0x10, 0x03, 0x1a, 0x4e, 0x0a, 0x16, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x45,
	0x78, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x34, 0x0a,
	0x16, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x45, 0x78, 0x70,
	0x6f, 0x72, 0x74, 0x22, 0x50, 0x0a, 0x11, 0x52, 0x65, 0x64, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x12, 0x22, 0x0a, 0x1e, 0x52, 0x45, 0x44, 0x41,
	0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x54, 0x52, 0x41, 0x54, 0x45, 0x47, 0x59, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x17, 0x0a, 0x13,
	0x52, 0x45, 0x44, 0x41, 0x43, 0x54, 0x5f, 0x57, 0x49, 0x54, 0x48, 0x5f, 0x53, 0x45, 0x52, 0x56,
	0x49, 0x43, 0x45, 0x10, 0x01, 0x22, 0x4a, 0x0a, 0x0e, 0x52, 0x65, 0x64, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x12, 0x1f, 0x0a, 0x1b, 0x52, 0x45, 0x44, 0x41, 0x43,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x43, 0x4f, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x17, 0x0a, 0x13, 0x52, 0x45, 0x44, 0x41,
	0x43, 0x54, 0x5f, 0x44, 0x49, 0x53, 0x4b, 0x5f, 0x53, 0x54, 0x4f, 0x52, 0x41, 0x47, 0x45, 0x10,
	0x02, 0x22, 0x56, 0x0a, 0x11, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74,
	0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x12, 0x22, 0x0a, 0x1e, 0x52, 0x45, 0x54, 0x45, 0x4e, 0x54,
	0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x54, 0x52, 0x41, 0x54, 0x45, 0x47, 0x59, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1d, 0x0a, 0x19, 0x52, 0x45,
	0x4d, 0x4f, 0x56, 0x45, 0x5f, 0x41, 0x46, 0x54, 0x45, 0x52, 0x5f, 0x43, 0x4f, 0x4e, 0x56, 0x45,
	0x52, 0x53, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x22, 0x48, 0x0a, 0x0d, 0x50, 0x75, 0x72,
	0x67, 0x65, 0x44, 0x61, 0x74, 0x61, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1f, 0x0a, 0x1b, 0x50, 0x55,
	0x52, 0x47, 0x45, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x16, 0x0a, 0x12, 0x44,
	0x49, 0x41, 0x4c, 0x4f, 0x47, 0x46, 0x4c, 0x4f, 0x57, 0x5f, 0x48, 0x49, 0x53, 0x54, 0x4f, 0x52,
	0x59, 0x10, 0x01, 0x3a, 0x7d, 0xea, 0x41, 0x7a, 0x0a, 0x2a, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x12, 0x4c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x7b,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x7d, 0x42, 0x10, 0x0a, 0x0e, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x65, 0x74, 0x65, 0x6e,
	0x74, 0x69, 0x6f, 0x6e, 0x32, 0xb5, 0x0a, 0x0a, 0x17, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x12, 0x82, 0x02, 0x0a, 0x16, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x41, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x22, 0x6f, 0xda, 0x41, 0x18, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4e, 0x3a, 0x11, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x39, 0x2f, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0xd5, 0x01, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x53, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x3e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x22, 0x48, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x3b, 0x12, 0x39, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x9a, 0x02,
	0x0a, 0x16, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x22, 0x86, 0x01, 0xda, 0x41, 0x1d, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f,
	0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x60, 0x3a, 0x11, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x32, 0x4b, 0x2f,
	0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe5, 0x01, 0x0a, 0x14, 0x4c,
	0x69, 0x73, 0x74, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78,
	0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4a, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x12, 0x39, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x12, 0xbd, 0x01, 0x0a, 0x16, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x41, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x48, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x2a, 0x39, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f,
	0x2a, 0x7d, 0x1a, 0x78, 0xca, 0x41, 0x19, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0xd2, 0x41, 0x59, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75,
	0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74,
	0x68, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x42, 0xf6, 0x04, 0xea,
	0x41, 0xc8, 0x01, 0x0a, 0x22, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x55, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x70, 0x65,
	0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73,
	0x70, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x7d, 0x12, 0x4b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63,
	0x74, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x7d, 0xea, 0x41, 0xd7, 0x01, 0x0a,
	0x25, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x54, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x5b, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64, 0x65, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x66, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f, 0x7b, 0x64,
	0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x7d, 0x12, 0x51, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64, 0x65, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73,
	0x2f, 0x7b, 0x64, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x5f, 0x74, 0x65, 0x6d,
	0x70, 0x6c, 0x61, 0x74, 0x65, 0x7d, 0x0a, 0x26, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x15,
	0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x36, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x33,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x63, 0x78, 0x70, 0x62, 0x3b, 0x63, 0x78, 0x70, 0x62, 0xf8,
	0x01, 0x01, 0xa2, 0x02, 0x02, 0x44, 0x46, 0xaa, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x43, 0x78, 0x2e, 0x56, 0x33, 0x42, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x26, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x3a, 0x3a, 0x43, 0x58, 0x3a, 0x3a, 0x56, 0x33,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_rawDescOnce sync.Once
	file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_rawDescData = file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_rawDesc
)

func file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_rawDescGZIP() []byte {
	file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_rawDescOnce.Do(func() {
		file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_rawDescData)
	})
	return file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_rawDescData
}

var file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_msgTypes = make([]protoimpl.MessageInfo, 9)
var file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_goTypes = []interface{}{
	(SecuritySettings_RedactionStrategy)(0),               // 0: google.cloud.dialogflow.cx.v3beta1.SecuritySettings.RedactionStrategy
	(SecuritySettings_RedactionScope)(0),                  // 1: google.cloud.dialogflow.cx.v3beta1.SecuritySettings.RedactionScope
	(SecuritySettings_RetentionStrategy)(0),               // 2: google.cloud.dialogflow.cx.v3beta1.SecuritySettings.RetentionStrategy
	(SecuritySettings_PurgeDataType)(0),                   // 3: google.cloud.dialogflow.cx.v3beta1.SecuritySettings.PurgeDataType
	(SecuritySettings_AudioExportSettings_AudioFormat)(0), // 4: google.cloud.dialogflow.cx.v3beta1.SecuritySettings.AudioExportSettings.AudioFormat
	(*GetSecuritySettingsRequest)(nil),                    // 5: google.cloud.dialogflow.cx.v3beta1.GetSecuritySettingsRequest
	(*UpdateSecuritySettingsRequest)(nil),                 // 6: google.cloud.dialogflow.cx.v3beta1.UpdateSecuritySettingsRequest
	(*ListSecuritySettingsRequest)(nil),                   // 7: google.cloud.dialogflow.cx.v3beta1.ListSecuritySettingsRequest
	(*ListSecuritySettingsResponse)(nil),                  // 8: google.cloud.dialogflow.cx.v3beta1.ListSecuritySettingsResponse
	(*CreateSecuritySettingsRequest)(nil),                 // 9: google.cloud.dialogflow.cx.v3beta1.CreateSecuritySettingsRequest
	(*DeleteSecuritySettingsRequest)(nil),                 // 10: google.cloud.dialogflow.cx.v3beta1.DeleteSecuritySettingsRequest
	(*SecuritySettings)(nil),                              // 11: google.cloud.dialogflow.cx.v3beta1.SecuritySettings
	(*SecuritySettings_AudioExportSettings)(nil),          // 12: google.cloud.dialogflow.cx.v3beta1.SecuritySettings.AudioExportSettings
	(*SecuritySettings_InsightsExportSettings)(nil),       // 13: google.cloud.dialogflow.cx.v3beta1.SecuritySettings.InsightsExportSettings
	(*fieldmaskpb.FieldMask)(nil),                         // 14: google.protobuf.FieldMask
	(*emptypb.Empty)(nil),                                 // 15: google.protobuf.Empty
}
var file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_depIdxs = []int32{
	11, // 0: google.cloud.dialogflow.cx.v3beta1.UpdateSecuritySettingsRequest.security_settings:type_name -> google.cloud.dialogflow.cx.v3beta1.SecuritySettings
	14, // 1: google.cloud.dialogflow.cx.v3beta1.UpdateSecuritySettingsRequest.update_mask:type_name -> google.protobuf.FieldMask
	11, // 2: google.cloud.dialogflow.cx.v3beta1.ListSecuritySettingsResponse.security_settings:type_name -> google.cloud.dialogflow.cx.v3beta1.SecuritySettings
	11, // 3: google.cloud.dialogflow.cx.v3beta1.CreateSecuritySettingsRequest.security_settings:type_name -> google.cloud.dialogflow.cx.v3beta1.SecuritySettings
	0,  // 4: google.cloud.dialogflow.cx.v3beta1.SecuritySettings.redaction_strategy:type_name -> google.cloud.dialogflow.cx.v3beta1.SecuritySettings.RedactionStrategy
	1,  // 5: google.cloud.dialogflow.cx.v3beta1.SecuritySettings.redaction_scope:type_name -> google.cloud.dialogflow.cx.v3beta1.SecuritySettings.RedactionScope
	2,  // 6: google.cloud.dialogflow.cx.v3beta1.SecuritySettings.retention_strategy:type_name -> google.cloud.dialogflow.cx.v3beta1.SecuritySettings.RetentionStrategy
	3,  // 7: google.cloud.dialogflow.cx.v3beta1.SecuritySettings.purge_data_types:type_name -> google.cloud.dialogflow.cx.v3beta1.SecuritySettings.PurgeDataType
	12, // 8: google.cloud.dialogflow.cx.v3beta1.SecuritySettings.audio_export_settings:type_name -> google.cloud.dialogflow.cx.v3beta1.SecuritySettings.AudioExportSettings
	13, // 9: google.cloud.dialogflow.cx.v3beta1.SecuritySettings.insights_export_settings:type_name -> google.cloud.dialogflow.cx.v3beta1.SecuritySettings.InsightsExportSettings
	4,  // 10: google.cloud.dialogflow.cx.v3beta1.SecuritySettings.AudioExportSettings.audio_format:type_name -> google.cloud.dialogflow.cx.v3beta1.SecuritySettings.AudioExportSettings.AudioFormat
	9,  // 11: google.cloud.dialogflow.cx.v3beta1.SecuritySettingsService.CreateSecuritySettings:input_type -> google.cloud.dialogflow.cx.v3beta1.CreateSecuritySettingsRequest
	5,  // 12: google.cloud.dialogflow.cx.v3beta1.SecuritySettingsService.GetSecuritySettings:input_type -> google.cloud.dialogflow.cx.v3beta1.GetSecuritySettingsRequest
	6,  // 13: google.cloud.dialogflow.cx.v3beta1.SecuritySettingsService.UpdateSecuritySettings:input_type -> google.cloud.dialogflow.cx.v3beta1.UpdateSecuritySettingsRequest
	7,  // 14: google.cloud.dialogflow.cx.v3beta1.SecuritySettingsService.ListSecuritySettings:input_type -> google.cloud.dialogflow.cx.v3beta1.ListSecuritySettingsRequest
	10, // 15: google.cloud.dialogflow.cx.v3beta1.SecuritySettingsService.DeleteSecuritySettings:input_type -> google.cloud.dialogflow.cx.v3beta1.DeleteSecuritySettingsRequest
	11, // 16: google.cloud.dialogflow.cx.v3beta1.SecuritySettingsService.CreateSecuritySettings:output_type -> google.cloud.dialogflow.cx.v3beta1.SecuritySettings
	11, // 17: google.cloud.dialogflow.cx.v3beta1.SecuritySettingsService.GetSecuritySettings:output_type -> google.cloud.dialogflow.cx.v3beta1.SecuritySettings
	11, // 18: google.cloud.dialogflow.cx.v3beta1.SecuritySettingsService.UpdateSecuritySettings:output_type -> google.cloud.dialogflow.cx.v3beta1.SecuritySettings
	8,  // 19: google.cloud.dialogflow.cx.v3beta1.SecuritySettingsService.ListSecuritySettings:output_type -> google.cloud.dialogflow.cx.v3beta1.ListSecuritySettingsResponse
	15, // 20: google.cloud.dialogflow.cx.v3beta1.SecuritySettingsService.DeleteSecuritySettings:output_type -> google.protobuf.Empty
	16, // [16:21] is the sub-list for method output_type
	11, // [11:16] is the sub-list for method input_type
	11, // [11:11] is the sub-list for extension type_name
	11, // [11:11] is the sub-list for extension extendee
	0,  // [0:11] is the sub-list for field type_name
}

func init() { file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_init() }
func file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_init() {
	if File_google_cloud_dialogflow_cx_v3beta1_security_settings_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSecuritySettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateSecuritySettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSecuritySettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSecuritySettingsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateSecuritySettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteSecuritySettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SecuritySettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SecuritySettings_AudioExportSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SecuritySettings_InsightsExportSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_msgTypes[6].OneofWrappers = []interface{}{
		(*SecuritySettings_RetentionWindowDays)(nil),
		(*SecuritySettings_RetentionStrategy_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_rawDesc,
			NumEnums:      5,
			NumMessages:   9,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_goTypes,
		DependencyIndexes: file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_depIdxs,
		EnumInfos:         file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_enumTypes,
		MessageInfos:      file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_msgTypes,
	}.Build()
	File_google_cloud_dialogflow_cx_v3beta1_security_settings_proto = out.File
	file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_rawDesc = nil
	file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_goTypes = nil
	file_google_cloud_dialogflow_cx_v3beta1_security_settings_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// SecuritySettingsServiceClient is the client API for SecuritySettingsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SecuritySettingsServiceClient interface {
	// Create security settings in the specified location.
	CreateSecuritySettings(ctx context.Context, in *CreateSecuritySettingsRequest, opts ...grpc.CallOption) (*SecuritySettings, error)
	// Retrieves the specified
	// [SecuritySettings][google.cloud.dialogflow.cx.v3beta1.SecuritySettings].
	// The returned settings may be stale by up to 1 minute.
	GetSecuritySettings(ctx context.Context, in *GetSecuritySettingsRequest, opts ...grpc.CallOption) (*SecuritySettings, error)
	// Updates the specified
	// [SecuritySettings][google.cloud.dialogflow.cx.v3beta1.SecuritySettings].
	UpdateSecuritySettings(ctx context.Context, in *UpdateSecuritySettingsRequest, opts ...grpc.CallOption) (*SecuritySettings, error)
	// Returns the list of all security settings in the specified location.
	ListSecuritySettings(ctx context.Context, in *ListSecuritySettingsRequest, opts ...grpc.CallOption) (*ListSecuritySettingsResponse, error)
	// Deletes the specified
	// [SecuritySettings][google.cloud.dialogflow.cx.v3beta1.SecuritySettings].
	DeleteSecuritySettings(ctx context.Context, in *DeleteSecuritySettingsRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type securitySettingsServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewSecuritySettingsServiceClient(cc grpc.ClientConnInterface) SecuritySettingsServiceClient {
	return &securitySettingsServiceClient{cc}
}

func (c *securitySettingsServiceClient) CreateSecuritySettings(ctx context.Context, in *CreateSecuritySettingsRequest, opts ...grpc.CallOption) (*SecuritySettings, error) {
	out := new(SecuritySettings)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.SecuritySettingsService/CreateSecuritySettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securitySettingsServiceClient) GetSecuritySettings(ctx context.Context, in *GetSecuritySettingsRequest, opts ...grpc.CallOption) (*SecuritySettings, error) {
	out := new(SecuritySettings)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.SecuritySettingsService/GetSecuritySettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securitySettingsServiceClient) UpdateSecuritySettings(ctx context.Context, in *UpdateSecuritySettingsRequest, opts ...grpc.CallOption) (*SecuritySettings, error) {
	out := new(SecuritySettings)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.SecuritySettingsService/UpdateSecuritySettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securitySettingsServiceClient) ListSecuritySettings(ctx context.Context, in *ListSecuritySettingsRequest, opts ...grpc.CallOption) (*ListSecuritySettingsResponse, error) {
	out := new(ListSecuritySettingsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.SecuritySettingsService/ListSecuritySettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securitySettingsServiceClient) DeleteSecuritySettings(ctx context.Context, in *DeleteSecuritySettingsRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.SecuritySettingsService/DeleteSecuritySettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SecuritySettingsServiceServer is the server API for SecuritySettingsService service.
type SecuritySettingsServiceServer interface {
	// Create security settings in the specified location.
	CreateSecuritySettings(context.Context, *CreateSecuritySettingsRequest) (*SecuritySettings, error)
	// Retrieves the specified
	// [SecuritySettings][google.cloud.dialogflow.cx.v3beta1.SecuritySettings].
	// The returned settings may be stale by up to 1 minute.
	GetSecuritySettings(context.Context, *GetSecuritySettingsRequest) (*SecuritySettings, error)
	// Updates the specified
	// [SecuritySettings][google.cloud.dialogflow.cx.v3beta1.SecuritySettings].
	UpdateSecuritySettings(context.Context, *UpdateSecuritySettingsRequest) (*SecuritySettings, error)
	// Returns the list of all security settings in the specified location.
	ListSecuritySettings(context.Context, *ListSecuritySettingsRequest) (*ListSecuritySettingsResponse, error)
	// Deletes the specified
	// [SecuritySettings][google.cloud.dialogflow.cx.v3beta1.SecuritySettings].
	DeleteSecuritySettings(context.Context, *DeleteSecuritySettingsRequest) (*emptypb.Empty, error)
}

// UnimplementedSecuritySettingsServiceServer can be embedded to have forward compatible implementations.
type UnimplementedSecuritySettingsServiceServer struct {
}

func (*UnimplementedSecuritySettingsServiceServer) CreateSecuritySettings(context.Context, *CreateSecuritySettingsRequest) (*SecuritySettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSecuritySettings not implemented")
}
func (*UnimplementedSecuritySettingsServiceServer) GetSecuritySettings(context.Context, *GetSecuritySettingsRequest) (*SecuritySettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSecuritySettings not implemented")
}
func (*UnimplementedSecuritySettingsServiceServer) UpdateSecuritySettings(context.Context, *UpdateSecuritySettingsRequest) (*SecuritySettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSecuritySettings not implemented")
}
func (*UnimplementedSecuritySettingsServiceServer) ListSecuritySettings(context.Context, *ListSecuritySettingsRequest) (*ListSecuritySettingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSecuritySettings not implemented")
}
func (*UnimplementedSecuritySettingsServiceServer) DeleteSecuritySettings(context.Context, *DeleteSecuritySettingsRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSecuritySettings not implemented")
}

func RegisterSecuritySettingsServiceServer(s *grpc.Server, srv SecuritySettingsServiceServer) {
	s.RegisterService(&_SecuritySettingsService_serviceDesc, srv)
}

func _SecuritySettingsService_CreateSecuritySettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSecuritySettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecuritySettingsServiceServer).CreateSecuritySettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.SecuritySettingsService/CreateSecuritySettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecuritySettingsServiceServer).CreateSecuritySettings(ctx, req.(*CreateSecuritySettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecuritySettingsService_GetSecuritySettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSecuritySettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecuritySettingsServiceServer).GetSecuritySettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.SecuritySettingsService/GetSecuritySettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecuritySettingsServiceServer).GetSecuritySettings(ctx, req.(*GetSecuritySettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecuritySettingsService_UpdateSecuritySettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSecuritySettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecuritySettingsServiceServer).UpdateSecuritySettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.SecuritySettingsService/UpdateSecuritySettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecuritySettingsServiceServer).UpdateSecuritySettings(ctx, req.(*UpdateSecuritySettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecuritySettingsService_ListSecuritySettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSecuritySettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecuritySettingsServiceServer).ListSecuritySettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.SecuritySettingsService/ListSecuritySettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecuritySettingsServiceServer).ListSecuritySettings(ctx, req.(*ListSecuritySettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecuritySettingsService_DeleteSecuritySettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSecuritySettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecuritySettingsServiceServer).DeleteSecuritySettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.SecuritySettingsService/DeleteSecuritySettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecuritySettingsServiceServer).DeleteSecuritySettings(ctx, req.(*DeleteSecuritySettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _SecuritySettingsService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.cx.v3beta1.SecuritySettingsService",
	HandlerType: (*SecuritySettingsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateSecuritySettings",
			Handler:    _SecuritySettingsService_CreateSecuritySettings_Handler,
		},
		{
			MethodName: "GetSecuritySettings",
			Handler:    _SecuritySettingsService_GetSecuritySettings_Handler,
		},
		{
			MethodName: "UpdateSecuritySettings",
			Handler:    _SecuritySettingsService_UpdateSecuritySettings_Handler,
		},
		{
			MethodName: "ListSecuritySettings",
			Handler:    _SecuritySettingsService_ListSecuritySettings_Handler,
		},
		{
			MethodName: "DeleteSecuritySettings",
			Handler:    _SecuritySettingsService_DeleteSecuritySettings_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/cx/v3beta1/security_settings.proto",
}
