// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        v4.25.3
// source: google/cloud/dialogflow/cx/v3beta1/tool.proto

package cxpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	structpb "google.golang.org/protobuf/types/known/structpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Data format of the exported tools.
type ExportToolsRequest_DataFormat int32

const (
	// Unspecified format. Treated as `BLOB`.
	ExportToolsRequest_DATA_FORMAT_UNSPECIFIED ExportToolsRequest_DataFormat = 0
	// Tools will be exported as raw bytes.
	ExportToolsRequest_BLOB ExportToolsRequest_DataFormat = 1
	// Tools will be exported in JSON format.
	ExportToolsRequest_JSON ExportToolsRequest_DataFormat = 2
)

// Enum value maps for ExportToolsRequest_DataFormat.
var (
	ExportToolsRequest_DataFormat_name = map[int32]string{
		0: "DATA_FORMAT_UNSPECIFIED",
		1: "BLOB",
		2: "JSON",
	}
	ExportToolsRequest_DataFormat_value = map[string]int32{
		"DATA_FORMAT_UNSPECIFIED": 0,
		"BLOB":                    1,
		"JSON":                    2,
	}
)

func (x ExportToolsRequest_DataFormat) Enum() *ExportToolsRequest_DataFormat {
	p := new(ExportToolsRequest_DataFormat)
	*p = x
	return p
}

func (x ExportToolsRequest_DataFormat) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExportToolsRequest_DataFormat) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3beta1_tool_proto_enumTypes[0].Descriptor()
}

func (ExportToolsRequest_DataFormat) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3beta1_tool_proto_enumTypes[0]
}

func (x ExportToolsRequest_DataFormat) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExportToolsRequest_DataFormat.Descriptor instead.
func (ExportToolsRequest_DataFormat) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_tool_proto_rawDescGZIP(), []int{4, 0}
}

// Represents the type of the tool.
type Tool_ToolType int32

const (
	// Default value. This value is unused.
	Tool_TOOL_TYPE_UNSPECIFIED Tool_ToolType = 0
	// Customer provided tool.
	Tool_CUSTOMIZED_TOOL Tool_ToolType = 1
	// First party built-in tool created by Dialogflow which cannot be modified.
	Tool_BUILTIN_TOOL Tool_ToolType = 2
)

// Enum value maps for Tool_ToolType.
var (
	Tool_ToolType_name = map[int32]string{
		0: "TOOL_TYPE_UNSPECIFIED",
		1: "CUSTOMIZED_TOOL",
		2: "BUILTIN_TOOL",
	}
	Tool_ToolType_value = map[string]int32{
		"TOOL_TYPE_UNSPECIFIED": 0,
		"CUSTOMIZED_TOOL":       1,
		"BUILTIN_TOOL":          2,
	}
)

func (x Tool_ToolType) Enum() *Tool_ToolType {
	p := new(Tool_ToolType)
	*p = x
	return p
}

func (x Tool_ToolType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Tool_ToolType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3beta1_tool_proto_enumTypes[1].Descriptor()
}

func (Tool_ToolType) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3beta1_tool_proto_enumTypes[1]
}

func (x Tool_ToolType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Tool_ToolType.Descriptor instead.
func (Tool_ToolType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_tool_proto_rawDescGZIP(), []int{8, 0}
}

// The location of the API key in the request.
type Tool_Authentication_RequestLocation int32

const (
	// Default value. This value is unused.
	Tool_Authentication_REQUEST_LOCATION_UNSPECIFIED Tool_Authentication_RequestLocation = 0
	// Represents the key in http header.
	Tool_Authentication_HEADER Tool_Authentication_RequestLocation = 1
	// Represents the key in query string.
	Tool_Authentication_QUERY_STRING Tool_Authentication_RequestLocation = 2
)

// Enum value maps for Tool_Authentication_RequestLocation.
var (
	Tool_Authentication_RequestLocation_name = map[int32]string{
		0: "REQUEST_LOCATION_UNSPECIFIED",
		1: "HEADER",
		2: "QUERY_STRING",
	}
	Tool_Authentication_RequestLocation_value = map[string]int32{
		"REQUEST_LOCATION_UNSPECIFIED": 0,
		"HEADER":                       1,
		"QUERY_STRING":                 2,
	}
)

func (x Tool_Authentication_RequestLocation) Enum() *Tool_Authentication_RequestLocation {
	p := new(Tool_Authentication_RequestLocation)
	*p = x
	return p
}

func (x Tool_Authentication_RequestLocation) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Tool_Authentication_RequestLocation) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3beta1_tool_proto_enumTypes[2].Descriptor()
}

func (Tool_Authentication_RequestLocation) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3beta1_tool_proto_enumTypes[2]
}

func (x Tool_Authentication_RequestLocation) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Tool_Authentication_RequestLocation.Descriptor instead.
func (Tool_Authentication_RequestLocation) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_tool_proto_rawDescGZIP(), []int{8, 4, 0}
}

// OAuth grant types. Only [client credential
// grant](https://oauth.net/2/grant-types/client-credentials) is
// supported.
type Tool_Authentication_OAuthConfig_OauthGrantType int32

const (
	// Default value. This value is unused.
	Tool_Authentication_OAuthConfig_OAUTH_GRANT_TYPE_UNSPECIFIED Tool_Authentication_OAuthConfig_OauthGrantType = 0
	// Represents the [client credential
	// flow](https://oauth.net/2/grant-types/client-credentials).
	Tool_Authentication_OAuthConfig_CLIENT_CREDENTIAL Tool_Authentication_OAuthConfig_OauthGrantType = 1
)

// Enum value maps for Tool_Authentication_OAuthConfig_OauthGrantType.
var (
	Tool_Authentication_OAuthConfig_OauthGrantType_name = map[int32]string{
		0: "OAUTH_GRANT_TYPE_UNSPECIFIED",
		1: "CLIENT_CREDENTIAL",
	}
	Tool_Authentication_OAuthConfig_OauthGrantType_value = map[string]int32{
		"OAUTH_GRANT_TYPE_UNSPECIFIED": 0,
		"CLIENT_CREDENTIAL":            1,
	}
)

func (x Tool_Authentication_OAuthConfig_OauthGrantType) Enum() *Tool_Authentication_OAuthConfig_OauthGrantType {
	p := new(Tool_Authentication_OAuthConfig_OauthGrantType)
	*p = x
	return p
}

func (x Tool_Authentication_OAuthConfig_OauthGrantType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Tool_Authentication_OAuthConfig_OauthGrantType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3beta1_tool_proto_enumTypes[3].Descriptor()
}

func (Tool_Authentication_OAuthConfig_OauthGrantType) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3beta1_tool_proto_enumTypes[3]
}

func (x Tool_Authentication_OAuthConfig_OauthGrantType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Tool_Authentication_OAuthConfig_OauthGrantType.Descriptor instead.
func (Tool_Authentication_OAuthConfig_OauthGrantType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_tool_proto_rawDescGZIP(), []int{8, 4, 1, 0}
}

// The request message for
// [Tools.CreateTool][google.cloud.dialogflow.cx.v3beta1.Tools.CreateTool].
type CreateToolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The agent to create a Tool for.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The Tool to be created.
	Tool *Tool `protobuf:"bytes,2,opt,name=tool,proto3" json:"tool,omitempty"`
}

func (x *CreateToolRequest) Reset() {
	*x = CreateToolRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateToolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateToolRequest) ProtoMessage() {}

func (x *CreateToolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateToolRequest.ProtoReflect.Descriptor instead.
func (*CreateToolRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_tool_proto_rawDescGZIP(), []int{0}
}

func (x *CreateToolRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateToolRequest) GetTool() *Tool {
	if x != nil {
		return x.Tool
	}
	return nil
}

// The request message for
// [Tools.ListTools][google.cloud.dialogflow.cx.v3beta1.Tools.ListTools].
type ListToolsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The agent to list the Tools from.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return in a single page. By default 100 and
	// at most 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListToolsRequest) Reset() {
	*x = ListToolsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListToolsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListToolsRequest) ProtoMessage() {}

func (x *ListToolsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListToolsRequest.ProtoReflect.Descriptor instead.
func (*ListToolsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_tool_proto_rawDescGZIP(), []int{1}
}

func (x *ListToolsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListToolsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListToolsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response message for
// [Tools.ListTools][google.cloud.dialogflow.cx.v3beta1.Tools.ListTools].
type ListToolsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of Tools. There will be a maximum number of items returned
	// based on the page_size field in the request.
	Tools []*Tool `protobuf:"bytes,1,rep,name=tools,proto3" json:"tools,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListToolsResponse) Reset() {
	*x = ListToolsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListToolsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListToolsResponse) ProtoMessage() {}

func (x *ListToolsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListToolsResponse.ProtoReflect.Descriptor instead.
func (*ListToolsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_tool_proto_rawDescGZIP(), []int{2}
}

func (x *ListToolsResponse) GetTools() []*Tool {
	if x != nil {
		return x.Tools
	}
	return nil
}

func (x *ListToolsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request message for
// [Tools.GetTool][google.cloud.dialogflow.cx.v3beta1.Tools.GetTool].
type GetToolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Tool.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/tools/<Tool ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetToolRequest) Reset() {
	*x = GetToolRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetToolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetToolRequest) ProtoMessage() {}

func (x *GetToolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetToolRequest.ProtoReflect.Descriptor instead.
func (*GetToolRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_tool_proto_rawDescGZIP(), []int{3}
}

func (x *GetToolRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for
// [Tools.ExportTools][google.cloud.dialogflow.cx.v3beta1.Tools.ExportTools].
type ExportToolsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The agent to export tools from.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The name of the tools to export.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/tools/<Tool ID>`.
	Tools []string `protobuf:"bytes,2,rep,name=tools,proto3" json:"tools,omitempty"`
	// The destination to export.
	//
	// Types that are assignable to Destination:
	//
	//	*ExportToolsRequest_ToolsUri
	//	*ExportToolsRequest_ToolsContentInline
	Destination isExportToolsRequest_Destination `protobuf_oneof:"destination"`
	// Optional. The data format of the exported tools. If not specified, `BLOB`
	// is assumed.
	DataFormat ExportToolsRequest_DataFormat `protobuf:"varint,5,opt,name=data_format,json=dataFormat,proto3,enum=google.cloud.dialogflow.cx.v3beta1.ExportToolsRequest_DataFormat" json:"data_format,omitempty"`
}

func (x *ExportToolsRequest) Reset() {
	*x = ExportToolsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportToolsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportToolsRequest) ProtoMessage() {}

func (x *ExportToolsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportToolsRequest.ProtoReflect.Descriptor instead.
func (*ExportToolsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_tool_proto_rawDescGZIP(), []int{4}
}

func (x *ExportToolsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ExportToolsRequest) GetTools() []string {
	if x != nil {
		return x.Tools
	}
	return nil
}

func (m *ExportToolsRequest) GetDestination() isExportToolsRequest_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *ExportToolsRequest) GetToolsUri() string {
	if x, ok := x.GetDestination().(*ExportToolsRequest_ToolsUri); ok {
		return x.ToolsUri
	}
	return ""
}

func (x *ExportToolsRequest) GetToolsContentInline() bool {
	if x, ok := x.GetDestination().(*ExportToolsRequest_ToolsContentInline); ok {
		return x.ToolsContentInline
	}
	return false
}

func (x *ExportToolsRequest) GetDataFormat() ExportToolsRequest_DataFormat {
	if x != nil {
		return x.DataFormat
	}
	return ExportToolsRequest_DATA_FORMAT_UNSPECIFIED
}

type isExportToolsRequest_Destination interface {
	isExportToolsRequest_Destination()
}

type ExportToolsRequest_ToolsUri struct {
	// Optional. The [Google Cloud
	// Storage](https://cloud.google.com/storage/docs/) URI to export the tools
	// to. The format of this URI must be `gs://<bucket-name>/<object-name>`.
	//
	// Dialogflow performs a write operation for the Cloud Storage object
	// on the caller's behalf, so your request authentication must
	// have write permissions for the object. For more information, see
	// [Dialogflow access
	// control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
	ToolsUri string `protobuf:"bytes,3,opt,name=tools_uri,json=toolsUri,proto3,oneof"`
}

type ExportToolsRequest_ToolsContentInline struct {
	// Optional. The option to return the serialized tools inline.
	ToolsContentInline bool `protobuf:"varint,4,opt,name=tools_content_inline,json=toolsContentInline,proto3,oneof"`
}

func (*ExportToolsRequest_ToolsUri) isExportToolsRequest_Destination() {}

func (*ExportToolsRequest_ToolsContentInline) isExportToolsRequest_Destination() {}

// The response message for
// [Tools.ExportTools][google.cloud.dialogflow.cx.v3beta1.Tools.ExportTools].
type ExportToolsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The exported tools.
	//
	// Types that are assignable to Tools:
	//
	//	*ExportToolsResponse_ToolsUri
	//	*ExportToolsResponse_ToolsContent
	Tools isExportToolsResponse_Tools `protobuf_oneof:"tools"`
}

func (x *ExportToolsResponse) Reset() {
	*x = ExportToolsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportToolsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportToolsResponse) ProtoMessage() {}

func (x *ExportToolsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportToolsResponse.ProtoReflect.Descriptor instead.
func (*ExportToolsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_tool_proto_rawDescGZIP(), []int{5}
}

func (m *ExportToolsResponse) GetTools() isExportToolsResponse_Tools {
	if m != nil {
		return m.Tools
	}
	return nil
}

func (x *ExportToolsResponse) GetToolsUri() string {
	if x, ok := x.GetTools().(*ExportToolsResponse_ToolsUri); ok {
		return x.ToolsUri
	}
	return ""
}

func (x *ExportToolsResponse) GetToolsContent() *InlineDestination {
	if x, ok := x.GetTools().(*ExportToolsResponse_ToolsContent); ok {
		return x.ToolsContent
	}
	return nil
}

type isExportToolsResponse_Tools interface {
	isExportToolsResponse_Tools()
}

type ExportToolsResponse_ToolsUri struct {
	// The URI to a file containing the exported tools. This field is
	// populated only if `tools_uri` is specified in
	// [ExportToolsRequest][google.cloud.dialogflow.cx.v3beta1.ExportToolsRequest].
	ToolsUri string `protobuf:"bytes,1,opt,name=tools_uri,json=toolsUri,proto3,oneof"`
}

type ExportToolsResponse_ToolsContent struct {
	// Uncompressed byte content for tools. This field is populated only if
	// `tools_content_inline` is set to true in
	// [ExportToolsRequest][google.cloud.dialogflow.cx.v3beta1.ExportToolsRequest].
	ToolsContent *InlineDestination `protobuf:"bytes,2,opt,name=tools_content,json=toolsContent,proto3,oneof"`
}

func (*ExportToolsResponse_ToolsUri) isExportToolsResponse_Tools() {}

func (*ExportToolsResponse_ToolsContent) isExportToolsResponse_Tools() {}

// The request message for
// [Tools.UpdateTool][google.cloud.dialogflow.cx.v3beta1.Tools.UpdateTool].
type UpdateToolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Tool to be updated.
	Tool *Tool `protobuf:"bytes,1,opt,name=tool,proto3" json:"tool,omitempty"`
	// The mask to control which fields get updated. If the mask is not present,
	// all fields will be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateToolRequest) Reset() {
	*x = UpdateToolRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateToolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateToolRequest) ProtoMessage() {}

func (x *UpdateToolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateToolRequest.ProtoReflect.Descriptor instead.
func (*UpdateToolRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_tool_proto_rawDescGZIP(), []int{6}
}

func (x *UpdateToolRequest) GetTool() *Tool {
	if x != nil {
		return x.Tool
	}
	return nil
}

func (x *UpdateToolRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The request message for
// [Tools.DeleteTool][google.cloud.dialogflow.cx.v3beta1.Tools.DeleteTool].
type DeleteToolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Tool to be deleted.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/tools/<Tool ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// This field has no effect for Tools not being used.
	// For Tools that are used:
	//
	//   - If `force` is set to false, an error will be returned with message
	//     indicating the referenced resources.
	//   - If `force` is set to true, Dialogflow will remove the tool, as well
	//     as any references to the tool.
	Force bool `protobuf:"varint,2,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteToolRequest) Reset() {
	*x = DeleteToolRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteToolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteToolRequest) ProtoMessage() {}

func (x *DeleteToolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteToolRequest.ProtoReflect.Descriptor instead.
func (*DeleteToolRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_tool_proto_rawDescGZIP(), []int{7}
}

func (x *DeleteToolRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteToolRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// A tool provides a list of actions which are available to the
// [Playbook][google.cloud.dialogflow.cx.v3beta1.Playbook] to attain its goal. A
// Tool consists of a description of the tool's usage and a specification of the
// tool which contains the schema and authentication information.
type Tool struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique identifier of the Tool.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/tools/<Tool ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The human-readable name of the Tool, unique within an agent.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. High level description of the Tool and its usage.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Specification of the Tool.
	//
	// Types that are assignable to Specification:
	//
	//	*Tool_OpenApiSpec
	//	*Tool_DataStoreSpec
	//	*Tool_ExtensionSpec
	//	*Tool_FunctionSpec
	Specification isTool_Specification `protobuf_oneof:"specification"`
	// Output only. The tool type.
	ToolType Tool_ToolType `protobuf:"varint,12,opt,name=tool_type,json=toolType,proto3,enum=google.cloud.dialogflow.cx.v3beta1.Tool_ToolType" json:"tool_type,omitempty"`
}

func (x *Tool) Reset() {
	*x = Tool{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Tool) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tool) ProtoMessage() {}

func (x *Tool) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tool.ProtoReflect.Descriptor instead.
func (*Tool) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_tool_proto_rawDescGZIP(), []int{8}
}

func (x *Tool) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Tool) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Tool) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (m *Tool) GetSpecification() isTool_Specification {
	if m != nil {
		return m.Specification
	}
	return nil
}

func (x *Tool) GetOpenApiSpec() *Tool_OpenApiTool {
	if x, ok := x.GetSpecification().(*Tool_OpenApiSpec); ok {
		return x.OpenApiSpec
	}
	return nil
}

func (x *Tool) GetDataStoreSpec() *Tool_DataStoreTool {
	if x, ok := x.GetSpecification().(*Tool_DataStoreSpec); ok {
		return x.DataStoreSpec
	}
	return nil
}

func (x *Tool) GetExtensionSpec() *Tool_ExtensionTool {
	if x, ok := x.GetSpecification().(*Tool_ExtensionSpec); ok {
		return x.ExtensionSpec
	}
	return nil
}

func (x *Tool) GetFunctionSpec() *Tool_FunctionTool {
	if x, ok := x.GetSpecification().(*Tool_FunctionSpec); ok {
		return x.FunctionSpec
	}
	return nil
}

func (x *Tool) GetToolType() Tool_ToolType {
	if x != nil {
		return x.ToolType
	}
	return Tool_TOOL_TYPE_UNSPECIFIED
}

type isTool_Specification interface {
	isTool_Specification()
}

type Tool_OpenApiSpec struct {
	// OpenAPI specification of the Tool.
	OpenApiSpec *Tool_OpenApiTool `protobuf:"bytes,4,opt,name=open_api_spec,json=openApiSpec,proto3,oneof"`
}

type Tool_DataStoreSpec struct {
	// Data store search tool specification.
	DataStoreSpec *Tool_DataStoreTool `protobuf:"bytes,8,opt,name=data_store_spec,json=dataStoreSpec,proto3,oneof"`
}

type Tool_ExtensionSpec struct {
	// Vertex extension tool specification.
	ExtensionSpec *Tool_ExtensionTool `protobuf:"bytes,11,opt,name=extension_spec,json=extensionSpec,proto3,oneof"`
}

type Tool_FunctionSpec struct {
	// Client side executed function specification.
	FunctionSpec *Tool_FunctionTool `protobuf:"bytes,13,opt,name=function_spec,json=functionSpec,proto3,oneof"`
}

func (*Tool_OpenApiSpec) isTool_Specification() {}

func (*Tool_DataStoreSpec) isTool_Specification() {}

func (*Tool_ExtensionSpec) isTool_Specification() {}

func (*Tool_FunctionSpec) isTool_Specification() {}

// Metadata returned for the
// [Tools.ExportTools][google.cloud.dialogflow.cx.v3beta1.Tools.ExportTools]
// long running operation.
type ExportToolsMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ExportToolsMetadata) Reset() {
	*x = ExportToolsMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportToolsMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportToolsMetadata) ProtoMessage() {}

func (x *ExportToolsMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportToolsMetadata.ProtoReflect.Descriptor instead.
func (*ExportToolsMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_tool_proto_rawDescGZIP(), []int{9}
}

// An OpenAPI tool is a way to provide the Tool specifications in the Open API
// schema format.
type Tool_OpenApiTool struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Schema representation.
	//
	// Types that are assignable to Schema:
	//
	//	*Tool_OpenApiTool_TextSchema
	Schema isTool_OpenApiTool_Schema `protobuf_oneof:"schema"`
	// Optional. Authentication information required by the API.
	Authentication *Tool_Authentication `protobuf:"bytes,2,opt,name=authentication,proto3" json:"authentication,omitempty"`
	// Optional. TLS configuration for the HTTPS verification.
	TlsConfig *Tool_TLSConfig `protobuf:"bytes,3,opt,name=tls_config,json=tlsConfig,proto3" json:"tls_config,omitempty"`
	// Optional. Service Directory configuration.
	ServiceDirectoryConfig *Tool_ServiceDirectoryConfig `protobuf:"bytes,4,opt,name=service_directory_config,json=serviceDirectoryConfig,proto3" json:"service_directory_config,omitempty"`
}

func (x *Tool_OpenApiTool) Reset() {
	*x = Tool_OpenApiTool{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Tool_OpenApiTool) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tool_OpenApiTool) ProtoMessage() {}

func (x *Tool_OpenApiTool) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tool_OpenApiTool.ProtoReflect.Descriptor instead.
func (*Tool_OpenApiTool) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_tool_proto_rawDescGZIP(), []int{8, 0}
}

func (m *Tool_OpenApiTool) GetSchema() isTool_OpenApiTool_Schema {
	if m != nil {
		return m.Schema
	}
	return nil
}

func (x *Tool_OpenApiTool) GetTextSchema() string {
	if x, ok := x.GetSchema().(*Tool_OpenApiTool_TextSchema); ok {
		return x.TextSchema
	}
	return ""
}

func (x *Tool_OpenApiTool) GetAuthentication() *Tool_Authentication {
	if x != nil {
		return x.Authentication
	}
	return nil
}

func (x *Tool_OpenApiTool) GetTlsConfig() *Tool_TLSConfig {
	if x != nil {
		return x.TlsConfig
	}
	return nil
}

func (x *Tool_OpenApiTool) GetServiceDirectoryConfig() *Tool_ServiceDirectoryConfig {
	if x != nil {
		return x.ServiceDirectoryConfig
	}
	return nil
}

type isTool_OpenApiTool_Schema interface {
	isTool_OpenApiTool_Schema()
}

type Tool_OpenApiTool_TextSchema struct {
	// Required. The OpenAPI schema specified as a text.
	TextSchema string `protobuf:"bytes,1,opt,name=text_schema,json=textSchema,proto3,oneof"`
}

func (*Tool_OpenApiTool_TextSchema) isTool_OpenApiTool_Schema() {}

// A DataStoreTool is a way to provide specifications needed to search a
// list of data stores.
type Tool_DataStoreTool struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. List of data stores to search.
	DataStoreConnections []*DataStoreConnection `protobuf:"bytes,1,rep,name=data_store_connections,json=dataStoreConnections,proto3" json:"data_store_connections,omitempty"`
	// Required. Fallback prompt configurations to use.
	FallbackPrompt *Tool_DataStoreTool_FallbackPrompt `protobuf:"bytes,3,opt,name=fallback_prompt,json=fallbackPrompt,proto3" json:"fallback_prompt,omitempty"`
}

func (x *Tool_DataStoreTool) Reset() {
	*x = Tool_DataStoreTool{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Tool_DataStoreTool) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tool_DataStoreTool) ProtoMessage() {}

func (x *Tool_DataStoreTool) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tool_DataStoreTool.ProtoReflect.Descriptor instead.
func (*Tool_DataStoreTool) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_tool_proto_rawDescGZIP(), []int{8, 1}
}

func (x *Tool_DataStoreTool) GetDataStoreConnections() []*DataStoreConnection {
	if x != nil {
		return x.DataStoreConnections
	}
	return nil
}

func (x *Tool_DataStoreTool) GetFallbackPrompt() *Tool_DataStoreTool_FallbackPrompt {
	if x != nil {
		return x.FallbackPrompt
	}
	return nil
}

// An ExtensionTool is a way to use Vertex Extensions as a tool.
type Tool_ExtensionTool struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The full name of the referenced vertex extension.
	// Formats:
	// `projects/{project}/locations/{location}/extensions/{extension}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *Tool_ExtensionTool) Reset() {
	*x = Tool_ExtensionTool{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Tool_ExtensionTool) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tool_ExtensionTool) ProtoMessage() {}

func (x *Tool_ExtensionTool) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tool_ExtensionTool.ProtoReflect.Descriptor instead.
func (*Tool_ExtensionTool) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_tool_proto_rawDescGZIP(), []int{8, 2}
}

func (x *Tool_ExtensionTool) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A Function tool describes the functions to be invoked on the client side.
type Tool_FunctionTool struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The JSON schema is encapsulated in a
	// [google.protobuf.Struct][google.protobuf.Struct] to describe the input of
	// the function. This input is a JSON object that contains the function's
	// parameters as properties of the object.
	InputSchema *structpb.Struct `protobuf:"bytes,1,opt,name=input_schema,json=inputSchema,proto3" json:"input_schema,omitempty"`
	// Optional. The JSON schema is encapsulated in a
	// [google.protobuf.Struct][google.protobuf.Struct] to describe the output
	// of the function. This output is a JSON object that contains the
	// function's parameters as properties of the object.
	OutputSchema *structpb.Struct `protobuf:"bytes,2,opt,name=output_schema,json=outputSchema,proto3" json:"output_schema,omitempty"`
}

func (x *Tool_FunctionTool) Reset() {
	*x = Tool_FunctionTool{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Tool_FunctionTool) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tool_FunctionTool) ProtoMessage() {}

func (x *Tool_FunctionTool) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tool_FunctionTool.ProtoReflect.Descriptor instead.
func (*Tool_FunctionTool) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_tool_proto_rawDescGZIP(), []int{8, 3}
}

func (x *Tool_FunctionTool) GetInputSchema() *structpb.Struct {
	if x != nil {
		return x.InputSchema
	}
	return nil
}

func (x *Tool_FunctionTool) GetOutputSchema() *structpb.Struct {
	if x != nil {
		return x.OutputSchema
	}
	return nil
}

// Authentication information required for API calls
type Tool_Authentication struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The auth configuration.
	//
	// Types that are assignable to AuthConfig:
	//
	//	*Tool_Authentication_ApiKeyConfig_
	//	*Tool_Authentication_OauthConfig
	//	*Tool_Authentication_ServiceAgentAuthConfig_
	AuthConfig isTool_Authentication_AuthConfig `protobuf_oneof:"auth_config"`
}

func (x *Tool_Authentication) Reset() {
	*x = Tool_Authentication{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Tool_Authentication) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tool_Authentication) ProtoMessage() {}

func (x *Tool_Authentication) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tool_Authentication.ProtoReflect.Descriptor instead.
func (*Tool_Authentication) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_tool_proto_rawDescGZIP(), []int{8, 4}
}

func (m *Tool_Authentication) GetAuthConfig() isTool_Authentication_AuthConfig {
	if m != nil {
		return m.AuthConfig
	}
	return nil
}

func (x *Tool_Authentication) GetApiKeyConfig() *Tool_Authentication_ApiKeyConfig {
	if x, ok := x.GetAuthConfig().(*Tool_Authentication_ApiKeyConfig_); ok {
		return x.ApiKeyConfig
	}
	return nil
}

func (x *Tool_Authentication) GetOauthConfig() *Tool_Authentication_OAuthConfig {
	if x, ok := x.GetAuthConfig().(*Tool_Authentication_OauthConfig); ok {
		return x.OauthConfig
	}
	return nil
}

func (x *Tool_Authentication) GetServiceAgentAuthConfig() *Tool_Authentication_ServiceAgentAuthConfig {
	if x, ok := x.GetAuthConfig().(*Tool_Authentication_ServiceAgentAuthConfig_); ok {
		return x.ServiceAgentAuthConfig
	}
	return nil
}

type isTool_Authentication_AuthConfig interface {
	isTool_Authentication_AuthConfig()
}

type Tool_Authentication_ApiKeyConfig_ struct {
	// Config for API key auth.
	ApiKeyConfig *Tool_Authentication_ApiKeyConfig `protobuf:"bytes,1,opt,name=api_key_config,json=apiKeyConfig,proto3,oneof"`
}

type Tool_Authentication_OauthConfig struct {
	// Config for OAuth.
	OauthConfig *Tool_Authentication_OAuthConfig `protobuf:"bytes,2,opt,name=oauth_config,json=oauthConfig,proto3,oneof"`
}

type Tool_Authentication_ServiceAgentAuthConfig_ struct {
	// Config for [Diglogflow service
	// agent](https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent)
	// auth.
	ServiceAgentAuthConfig *Tool_Authentication_ServiceAgentAuthConfig `protobuf:"bytes,3,opt,name=service_agent_auth_config,json=serviceAgentAuthConfig,proto3,oneof"`
}

func (*Tool_Authentication_ApiKeyConfig_) isTool_Authentication_AuthConfig() {}

func (*Tool_Authentication_OauthConfig) isTool_Authentication_AuthConfig() {}

func (*Tool_Authentication_ServiceAgentAuthConfig_) isTool_Authentication_AuthConfig() {}

// The TLS configuration.
type Tool_TLSConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Specifies a list of allowed custom CA certificates for HTTPS
	// verification.
	CaCerts []*Tool_TLSConfig_CACert `protobuf:"bytes,1,rep,name=ca_certs,json=caCerts,proto3" json:"ca_certs,omitempty"`
}

func (x *Tool_TLSConfig) Reset() {
	*x = Tool_TLSConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Tool_TLSConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tool_TLSConfig) ProtoMessage() {}

func (x *Tool_TLSConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tool_TLSConfig.ProtoReflect.Descriptor instead.
func (*Tool_TLSConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_tool_proto_rawDescGZIP(), []int{8, 5}
}

func (x *Tool_TLSConfig) GetCaCerts() []*Tool_TLSConfig_CACert {
	if x != nil {
		return x.CaCerts
	}
	return nil
}

// Configuration for tools using Service Directory.
type Tool_ServiceDirectoryConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of [Service
	// Directory](https://cloud.google.com/service-directory) service.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/namespaces/<NamespaceID>/services/<ServiceID>`.
	// `LocationID` of the service directory must be the same as the location
	// of the agent.
	Service string `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
}

func (x *Tool_ServiceDirectoryConfig) Reset() {
	*x = Tool_ServiceDirectoryConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Tool_ServiceDirectoryConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tool_ServiceDirectoryConfig) ProtoMessage() {}

func (x *Tool_ServiceDirectoryConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tool_ServiceDirectoryConfig.ProtoReflect.Descriptor instead.
func (*Tool_ServiceDirectoryConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_tool_proto_rawDescGZIP(), []int{8, 6}
}

func (x *Tool_ServiceDirectoryConfig) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

// A FallbackPrompt is a way to provide specifications for the Data Store
// fallback prompt when generating responses.
type Tool_DataStoreTool_FallbackPrompt struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Tool_DataStoreTool_FallbackPrompt) Reset() {
	*x = Tool_DataStoreTool_FallbackPrompt{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Tool_DataStoreTool_FallbackPrompt) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tool_DataStoreTool_FallbackPrompt) ProtoMessage() {}

func (x *Tool_DataStoreTool_FallbackPrompt) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tool_DataStoreTool_FallbackPrompt.ProtoReflect.Descriptor instead.
func (*Tool_DataStoreTool_FallbackPrompt) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_tool_proto_rawDescGZIP(), []int{8, 1, 0}
}

// Config for authentication with API key.
type Tool_Authentication_ApiKeyConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parameter name or the header name of the API key.
	// E.g., If the API request is "https://example.com/act?X-Api-Key=<API
	// KEY>", "X-Api-Key" would be the parameter name.
	KeyName string `protobuf:"bytes,1,opt,name=key_name,json=keyName,proto3" json:"key_name,omitempty"`
	// Required. The API key.
	ApiKey string `protobuf:"bytes,2,opt,name=api_key,json=apiKey,proto3" json:"api_key,omitempty"`
	// Required. Key location in the request.
	RequestLocation Tool_Authentication_RequestLocation `protobuf:"varint,3,opt,name=request_location,json=requestLocation,proto3,enum=google.cloud.dialogflow.cx.v3beta1.Tool_Authentication_RequestLocation" json:"request_location,omitempty"`
}

func (x *Tool_Authentication_ApiKeyConfig) Reset() {
	*x = Tool_Authentication_ApiKeyConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Tool_Authentication_ApiKeyConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tool_Authentication_ApiKeyConfig) ProtoMessage() {}

func (x *Tool_Authentication_ApiKeyConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tool_Authentication_ApiKeyConfig.ProtoReflect.Descriptor instead.
func (*Tool_Authentication_ApiKeyConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_tool_proto_rawDescGZIP(), []int{8, 4, 0}
}

func (x *Tool_Authentication_ApiKeyConfig) GetKeyName() string {
	if x != nil {
		return x.KeyName
	}
	return ""
}

func (x *Tool_Authentication_ApiKeyConfig) GetApiKey() string {
	if x != nil {
		return x.ApiKey
	}
	return ""
}

func (x *Tool_Authentication_ApiKeyConfig) GetRequestLocation() Tool_Authentication_RequestLocation {
	if x != nil {
		return x.RequestLocation
	}
	return Tool_Authentication_REQUEST_LOCATION_UNSPECIFIED
}

// Config for authentication with OAuth.
type Tool_Authentication_OAuthConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. OAuth grant types.
	OauthGrantType Tool_Authentication_OAuthConfig_OauthGrantType `protobuf:"varint,1,opt,name=oauth_grant_type,json=oauthGrantType,proto3,enum=google.cloud.dialogflow.cx.v3beta1.Tool_Authentication_OAuthConfig_OauthGrantType" json:"oauth_grant_type,omitempty"`
	// Required. The client ID from the OAuth provider.
	ClientId string `protobuf:"bytes,2,opt,name=client_id,json=clientId,proto3" json:"client_id,omitempty"`
	// Required. The client secret from the OAuth provider.
	ClientSecret string `protobuf:"bytes,3,opt,name=client_secret,json=clientSecret,proto3" json:"client_secret,omitempty"`
	// Required. The token endpoint in the OAuth provider to exchange for an
	// access token.
	TokenEndpoint string `protobuf:"bytes,4,opt,name=token_endpoint,json=tokenEndpoint,proto3" json:"token_endpoint,omitempty"`
}

func (x *Tool_Authentication_OAuthConfig) Reset() {
	*x = Tool_Authentication_OAuthConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Tool_Authentication_OAuthConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tool_Authentication_OAuthConfig) ProtoMessage() {}

func (x *Tool_Authentication_OAuthConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tool_Authentication_OAuthConfig.ProtoReflect.Descriptor instead.
func (*Tool_Authentication_OAuthConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_tool_proto_rawDescGZIP(), []int{8, 4, 1}
}

func (x *Tool_Authentication_OAuthConfig) GetOauthGrantType() Tool_Authentication_OAuthConfig_OauthGrantType {
	if x != nil {
		return x.OauthGrantType
	}
	return Tool_Authentication_OAuthConfig_OAUTH_GRANT_TYPE_UNSPECIFIED
}

func (x *Tool_Authentication_OAuthConfig) GetClientId() string {
	if x != nil {
		return x.ClientId
	}
	return ""
}

func (x *Tool_Authentication_OAuthConfig) GetClientSecret() string {
	if x != nil {
		return x.ClientSecret
	}
	return ""
}

func (x *Tool_Authentication_OAuthConfig) GetTokenEndpoint() string {
	if x != nil {
		return x.TokenEndpoint
	}
	return ""
}

// Config for auth using [Diglogflow service
// agent](https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent).
type Tool_Authentication_ServiceAgentAuthConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Tool_Authentication_ServiceAgentAuthConfig) Reset() {
	*x = Tool_Authentication_ServiceAgentAuthConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Tool_Authentication_ServiceAgentAuthConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tool_Authentication_ServiceAgentAuthConfig) ProtoMessage() {}

func (x *Tool_Authentication_ServiceAgentAuthConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tool_Authentication_ServiceAgentAuthConfig.ProtoReflect.Descriptor instead.
func (*Tool_Authentication_ServiceAgentAuthConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_tool_proto_rawDescGZIP(), []int{8, 4, 2}
}

// The CA certificate.
type Tool_TLSConfig_CACert struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the allowed custom CA certificates. This
	// can be used to disambiguate the custom CA certificates.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. The allowed custom CA certificates (in DER format) for
	// HTTPS verification. This overrides the default SSL trust store. If this
	// is empty or unspecified, Dialogflow will use Google's default trust
	// store to verify certificates. N.B. Make sure the HTTPS server
	// certificates are signed with "subject alt name". For instance a
	// certificate can be self-signed using the following command,
	//
	//	openssl x509 -req -days 200 -in example.com.csr \
	//	  -signkey example.com.key \
	//	  -out example.com.crt \
	//	  -extfile <(printf "\nsubjectAltName='DNS:www.example.com'")
	Cert []byte `protobuf:"bytes,2,opt,name=cert,proto3" json:"cert,omitempty"`
}

func (x *Tool_TLSConfig_CACert) Reset() {
	*x = Tool_TLSConfig_CACert{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Tool_TLSConfig_CACert) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tool_TLSConfig_CACert) ProtoMessage() {}

func (x *Tool_TLSConfig_CACert) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tool_TLSConfig_CACert.ProtoReflect.Descriptor instead.
func (*Tool_TLSConfig_CACert) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_tool_proto_rawDescGZIP(), []int{8, 5, 0}
}

func (x *Tool_TLSConfig_CACert) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Tool_TLSConfig_CACert) GetCert() []byte {
	if x != nil {
		return x.Cert
	}
	return nil
}

var File_google_cloud_dialogflow_cx_v3beta1_tool_proto protoreflect.FileDescriptor

var file_google_cloud_dialogflow_cx_v3beta1_tool_proto_rawDesc = []byte{
	0x0a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x74, 0x6f, 0x6f, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x22, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f,
	0x63, 0x78, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f,
	0x63, 0x78, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x69, 0x6e, 0x6c, 0x69, 0x6e,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d,
	0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x96, 0x01, 0x0a, 0x11, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x12, 0x1e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x54, 0x6f, 0x6f, 0x6c, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x41, 0x0a, 0x04, 0x74, 0x6f, 0x6f, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x74, 0x6f,
	0x6f, 0x6c, 0x22, 0x8e, 0x01, 0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x6f, 0x6f, 0x6c, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x12,
	0x1e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x6f, 0x6f, 0x6c, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0x7b, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x6f, 0x6f, 0x6c, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3e, 0x0a, 0x05, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x6f, 0x6f,
	0x6c, 0x52, 0x05, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0x4c, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x54, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x3a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x6f, 0x6f, 0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa6,
	0x03, 0x0a, 0x12, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x6f, 0x6f, 0x6c, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x12, 0x1e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x6f, 0x6f, 0x6c, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x3c, 0x0a, 0x05, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x6f, 0x6f, 0x6c, 0x52, 0x05, 0x74, 0x6f,
	0x6f, 0x6c, 0x73, 0x12, 0x22, 0x0a, 0x09, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x5f, 0x75, 0x72, 0x69,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x08, 0x74,
	0x6f, 0x6f, 0x6c, 0x73, 0x55, 0x72, 0x69, 0x12, 0x37, 0x0a, 0x14, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x12, 0x74, 0x6f,
	0x6f, 0x6c, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x6c, 0x69, 0x6e, 0x65,
	0x12, 0x67, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72,
	0x74, 0x54, 0x6f, 0x6f, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x64,
	0x61, 0x74, 0x61, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x22, 0x3d, 0x0a, 0x0a, 0x44, 0x61, 0x74,
	0x61, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x1b, 0x0a, 0x17, 0x44, 0x41, 0x54, 0x41, 0x5f,
	0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x42, 0x4c, 0x4f, 0x42, 0x10, 0x01, 0x12, 0x08,
	0x0a, 0x04, 0x4a, 0x53, 0x4f, 0x4e, 0x10, 0x02, 0x42, 0x0d, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x9b, 0x01, 0x0a, 0x13, 0x45, 0x78, 0x70, 0x6f,
	0x72, 0x74, 0x54, 0x6f, 0x6f, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x1d, 0x0a, 0x09, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x00, 0x52, 0x08, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x55, 0x72, 0x69, 0x12, 0x5c,
	0x0a, 0x0d, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x6c, 0x69, 0x6e,
	0x65, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0c,
	0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0x07, 0x0a, 0x05,
	0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x22, 0x93, 0x01, 0x0a, 0x11, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x54, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x04, 0x74,
	0x6f, 0x6f, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54,
	0x6f, 0x6f, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x74, 0x6f, 0x6f, 0x6c, 0x12, 0x3b,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52,
	0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x65, 0x0a, 0x11, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x3a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x54, 0x6f, 0x6f, 0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05,
	0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x66, 0x6f, 0x72,
	0x63, 0x65, 0x22, 0xfd, 0x16, 0x0a, 0x04, 0x54, 0x6f, 0x6f, 0x6c, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5a,
	0x0a, 0x0d, 0x6f, 0x70, 0x65, 0x6e, 0x5f, 0x61, 0x70, 0x69, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x2e,
	0x4f, 0x70, 0x65, 0x6e, 0x41, 0x70, 0x69, 0x54, 0x6f, 0x6f, 0x6c, 0x48, 0x00, 0x52, 0x0b, 0x6f,
	0x70, 0x65, 0x6e, 0x41, 0x70, 0x69, 0x53, 0x70, 0x65, 0x63, 0x12, 0x60, 0x0a, 0x0f, 0x64, 0x61,
	0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78,
	0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x54, 0x6f, 0x6f, 0x6c, 0x48, 0x00, 0x52, 0x0d, 0x64,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x5f, 0x0a, 0x0e,
	0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x2e, 0x45,
	0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6f, 0x6c, 0x48, 0x00, 0x52, 0x0d,
	0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x5c, 0x0a,
	0x0d, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x0d,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x2e, 0x46,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6f, 0x6c, 0x48, 0x00, 0x52, 0x0c, 0x66,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x53, 0x0a, 0x09, 0x74,
	0x6f, 0x6f, 0x6c, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x54, 0x79, 0x70,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x74, 0x6f, 0x6f, 0x6c, 0x54, 0x79, 0x70, 0x65,
	0x1a, 0xfd, 0x02, 0x0a, 0x0b, 0x4f, 0x70, 0x65, 0x6e, 0x41, 0x70, 0x69, 0x54, 0x6f, 0x6f, 0x6c,
	0x12, 0x26, 0x0a, 0x0b, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x00, 0x52, 0x0a, 0x74, 0x65,
	0x78, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x64, 0x0a, 0x0e, 0x61, 0x75, 0x74, 0x68,
	0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x65,
	0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e,
	0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x56,
	0x0a, 0x0a, 0x74, 0x6c, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e,
	0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x2e, 0x54, 0x4c, 0x53,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x74, 0x6c, 0x73,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x7e, 0x0a, 0x18, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x5f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x6f,
	0x6f, 0x6c, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x16,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x1a, 0x8a, 0x02, 0x0a, 0x0d, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x54, 0x6f,
	0x6f, 0x6c, 0x12, 0x72, 0x0a, 0x16, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e,
	0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72,
	0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x14, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x73, 0x0a, 0x0f, 0x66, 0x61, 0x6c, 0x6c, 0x62, 0x61,
	0x63, 0x6b, 0x5f, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74,
	0x6f, 0x72, 0x65, 0x54, 0x6f, 0x6f, 0x6c, 0x2e, 0x46, 0x61, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b,
	0x50, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x66, 0x61, 0x6c,
	0x6c, 0x62, 0x61, 0x63, 0x6b, 0x50, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x1a, 0x10, 0x0a, 0x0e, 0x46,
	0x61, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x50, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x1a, 0x28, 0x0a,
	0x0d, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6f, 0x6c, 0x12, 0x17,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x1a, 0x92, 0x01, 0x0a, 0x0c, 0x46, 0x75, 0x6e, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6f, 0x6c, 0x12, 0x3f, 0x0a, 0x0c, 0x69, 0x6e, 0x70, 0x75,
	0x74, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x69, 0x6e,
	0x70, 0x75, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x41, 0x0a, 0x0d, 0x6f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c,
	0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x1a, 0x91, 0x08, 0x0a,
	0x0e, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x6c, 0x0a, 0x0e, 0x61, 0x70, 0x69, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x6f, 0x6f,
	0x6c, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x41, 0x70, 0x69, 0x4b, 0x65, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52,
	0x0c, 0x61, 0x70, 0x69, 0x4b, 0x65, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x68, 0x0a,
	0x0c, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78,
	0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x2e, 0x41, 0x75,
	0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4f, 0x41, 0x75,
	0x74, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x0b, 0x6f, 0x61, 0x75, 0x74,
	0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x8b, 0x01, 0x0a, 0x19, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x67, 0x65, 0x6e,
	0x74, 0x41, 0x75, 0x74, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x16, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x41, 0x75, 0x74, 0x68, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0xc5, 0x01, 0x0a, 0x0c, 0x41, 0x70, 0x69, 0x4b, 0x65, 0x79,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1e, 0x0a, 0x08, 0x6b, 0x65, 0x79, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x6b,
	0x65, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x07, 0x61, 0x70, 0x69, 0x5f, 0x6b, 0x65,
	0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x61, 0x70,
	0x69, 0x4b, 0x65, 0x79, 0x12, 0x77, 0x0a, 0x10, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x47,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0xd4, 0x02,
	0x0a, 0x0b, 0x4f, 0x41, 0x75, 0x74, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x81, 0x01,
	0x0a, 0x10, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x52, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x6f,
	0x6f, 0x6c, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x4f, 0x41, 0x75, 0x74, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4f, 0x61,
	0x75, 0x74, 0x68, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0e, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x20, 0x0a, 0x09, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x0d, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65,
	0x63, 0x72, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0c, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x12, 0x2a, 0x0a,
	0x0e, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x22, 0x49, 0x0a, 0x0e, 0x4f, 0x61, 0x75,
	0x74, 0x68, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x20, 0x0a, 0x1c, 0x4f,
	0x41, 0x55, 0x54, 0x48, 0x5f, 0x47, 0x52, 0x41, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x15, 0x0a,
	0x11, 0x43, 0x4c, 0x49, 0x45, 0x4e, 0x54, 0x5f, 0x43, 0x52, 0x45, 0x44, 0x45, 0x4e, 0x54, 0x49,
	0x41, 0x4c, 0x10, 0x01, 0x1a, 0x18, 0x0a, 0x16, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41,
	0x67, 0x65, 0x6e, 0x74, 0x41, 0x75, 0x74, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x51,
	0x0a, 0x0f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x20, 0x0a, 0x1c, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x5f, 0x4c, 0x4f, 0x43,
	0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x48, 0x45, 0x41, 0x44, 0x45, 0x52, 0x10, 0x01, 0x12,
	0x10, 0x0a, 0x0c, 0x51, 0x55, 0x45, 0x52, 0x59, 0x5f, 0x53, 0x54, 0x52, 0x49, 0x4e, 0x47, 0x10,
	0x02, 0x42, 0x0d, 0x0a, 0x0b, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x1a, 0xb1, 0x01, 0x0a, 0x09, 0x54, 0x4c, 0x53, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x59,
	0x0a, 0x08, 0x63, 0x61, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x2e, 0x54, 0x4c, 0x53, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x43, 0x41, 0x43, 0x65, 0x72, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x07, 0x63, 0x61, 0x43, 0x65, 0x72, 0x74, 0x73, 0x1a, 0x49, 0x0a, 0x06, 0x43, 0x41, 0x43,
	0x65, 0x72, 0x74, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x63,
	0x65, 0x72, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04,
	0x63, 0x65, 0x72, 0x74, 0x1a, 0x63, 0x0a, 0x16, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x44,
	0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x49,
	0x0a, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x52, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x22, 0x4c, 0x0a, 0x08, 0x54, 0x6f, 0x6f,
	0x6c, 0x54, 0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x15, 0x54, 0x4f, 0x4f, 0x4c, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x13, 0x0a, 0x0f, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x49, 0x5a, 0x45, 0x44, 0x5f, 0x54,
	0x4f, 0x4f, 0x4c, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x42, 0x55, 0x49, 0x4c, 0x54, 0x49, 0x4e,
	0x5f, 0x54, 0x4f, 0x4f, 0x4c, 0x10, 0x02, 0x3a, 0x68, 0xea, 0x41, 0x65, 0x0a, 0x1e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x6f, 0x6f, 0x6c, 0x12, 0x43, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x67,
	0x65, 0x6e, 0x74, 0x7d, 0x2f, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x7b, 0x74, 0x6f, 0x6f, 0x6c,
	0x7d, 0x42, 0x0f, 0x0a, 0x0d, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x15, 0x0a, 0x13, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x6f, 0x6f, 0x6c,
	0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x32, 0x91, 0x0a, 0x0a, 0x05, 0x54, 0x6f,
	0x6f, 0x6c, 0x73, 0x12, 0xc2, 0x01, 0x0a, 0x0a, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x6f,
	0x6f, 0x6c, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e,
	0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x6f,
	0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54,
	0x6f, 0x6f, 0x6c, 0x22, 0x53, 0xda, 0x41, 0x0b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x74,
	0x6f, 0x6f, 0x6c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x3a, 0x04, 0x74, 0x6f, 0x6f, 0x6c, 0x22,
	0x37, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x12, 0xc2, 0x01, 0x0a, 0x09, 0x4c, 0x69, 0x73,
	0x74, 0x54, 0x6f, 0x6f, 0x6c, 0x73, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x54, 0x6f, 0x6f, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x6f, 0x6f, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x48, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x39, 0x12, 0x37, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67,
	0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x12, 0xdc, 0x01,
	0x0a, 0x0b, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x6f, 0x6f, 0x6c, 0x73, 0x12, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x6f, 0x6f, 0x6c, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x76, 0xca, 0x41, 0x2a, 0x0a, 0x13, 0x45, 0x78, 0x70, 0x6f, 0x72,
	0x74, 0x54, 0x6f, 0x6f, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x13,
	0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x6f, 0x6f, 0x6c, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x43, 0x3a, 0x01, 0x2a, 0x22, 0x3e, 0x2f, 0x76,
	0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x3a, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x12, 0xaf, 0x01, 0x0a,
	0x07, 0x47, 0x65, 0x74, 0x54, 0x6f, 0x6f, 0x6c, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x54, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x22, 0x46, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x39, 0x12, 0x37, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65,
	0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xcc,
	0x01, 0x0a, 0x0a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x6f, 0x6f, 0x6c, 0x12, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x22, 0x5d,
	0xda, 0x41, 0x10, 0x74, 0x6f, 0x6f, 0x6c, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x3a, 0x04, 0x74, 0x6f, 0x6f, 0x6c, 0x32,
	0x3c, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x74, 0x6f, 0x6f, 0x6c, 0x2e,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xa3, 0x01,
	0x0a, 0x0a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x6f, 0x6f, 0x6c, 0x12, 0x35, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x46, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x2a, 0x37, 0x2f, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x2f, 0x2a, 0x7d, 0x1a, 0x78, 0xca, 0x41, 0x19, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0xd2, 0x41, 0x59, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61,
	0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75,
	0x74, 0x68, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x42, 0x9a, 0x01,
	0x0a, 0x26, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78,
	0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x09, 0x54, 0x6f, 0x6f, 0x6c, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x36, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x33, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x63, 0x78, 0x70, 0x62, 0x3b, 0x63, 0x78, 0x70, 0x62, 0xf8, 0x01, 0x01,
	0xa2, 0x02, 0x02, 0x44, 0x46, 0xaa, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x43, 0x78, 0x2e, 0x56, 0x33, 0x42, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_cloud_dialogflow_cx_v3beta1_tool_proto_rawDescOnce sync.Once
	file_google_cloud_dialogflow_cx_v3beta1_tool_proto_rawDescData = file_google_cloud_dialogflow_cx_v3beta1_tool_proto_rawDesc
)

func file_google_cloud_dialogflow_cx_v3beta1_tool_proto_rawDescGZIP() []byte {
	file_google_cloud_dialogflow_cx_v3beta1_tool_proto_rawDescOnce.Do(func() {
		file_google_cloud_dialogflow_cx_v3beta1_tool_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dialogflow_cx_v3beta1_tool_proto_rawDescData)
	})
	return file_google_cloud_dialogflow_cx_v3beta1_tool_proto_rawDescData
}

var file_google_cloud_dialogflow_cx_v3beta1_tool_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes = make([]protoimpl.MessageInfo, 22)
var file_google_cloud_dialogflow_cx_v3beta1_tool_proto_goTypes = []any{
	(ExportToolsRequest_DataFormat)(0),                  // 0: google.cloud.dialogflow.cx.v3beta1.ExportToolsRequest.DataFormat
	(Tool_ToolType)(0),                                  // 1: google.cloud.dialogflow.cx.v3beta1.Tool.ToolType
	(Tool_Authentication_RequestLocation)(0),            // 2: google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.RequestLocation
	(Tool_Authentication_OAuthConfig_OauthGrantType)(0), // 3: google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig.OauthGrantType
	(*CreateToolRequest)(nil),                           // 4: google.cloud.dialogflow.cx.v3beta1.CreateToolRequest
	(*ListToolsRequest)(nil),                            // 5: google.cloud.dialogflow.cx.v3beta1.ListToolsRequest
	(*ListToolsResponse)(nil),                           // 6: google.cloud.dialogflow.cx.v3beta1.ListToolsResponse
	(*GetToolRequest)(nil),                              // 7: google.cloud.dialogflow.cx.v3beta1.GetToolRequest
	(*ExportToolsRequest)(nil),                          // 8: google.cloud.dialogflow.cx.v3beta1.ExportToolsRequest
	(*ExportToolsResponse)(nil),                         // 9: google.cloud.dialogflow.cx.v3beta1.ExportToolsResponse
	(*UpdateToolRequest)(nil),                           // 10: google.cloud.dialogflow.cx.v3beta1.UpdateToolRequest
	(*DeleteToolRequest)(nil),                           // 11: google.cloud.dialogflow.cx.v3beta1.DeleteToolRequest
	(*Tool)(nil),                                        // 12: google.cloud.dialogflow.cx.v3beta1.Tool
	(*ExportToolsMetadata)(nil),                         // 13: google.cloud.dialogflow.cx.v3beta1.ExportToolsMetadata
	(*Tool_OpenApiTool)(nil),                            // 14: google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool
	(*Tool_DataStoreTool)(nil),                          // 15: google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool
	(*Tool_ExtensionTool)(nil),                          // 16: google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool
	(*Tool_FunctionTool)(nil),                           // 17: google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool
	(*Tool_Authentication)(nil),                         // 18: google.cloud.dialogflow.cx.v3beta1.Tool.Authentication
	(*Tool_TLSConfig)(nil),                              // 19: google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig
	(*Tool_ServiceDirectoryConfig)(nil),                 // 20: google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig
	(*Tool_DataStoreTool_FallbackPrompt)(nil),           // 21: google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt
	(*Tool_Authentication_ApiKeyConfig)(nil),            // 22: google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig
	(*Tool_Authentication_OAuthConfig)(nil),             // 23: google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig
	(*Tool_Authentication_ServiceAgentAuthConfig)(nil),  // 24: google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig
	(*Tool_TLSConfig_CACert)(nil),                       // 25: google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert
	(*InlineDestination)(nil),                           // 26: google.cloud.dialogflow.cx.v3beta1.InlineDestination
	(*fieldmaskpb.FieldMask)(nil),                       // 27: google.protobuf.FieldMask
	(*DataStoreConnection)(nil),                         // 28: google.cloud.dialogflow.cx.v3beta1.DataStoreConnection
	(*structpb.Struct)(nil),                             // 29: google.protobuf.Struct
	(*longrunningpb.Operation)(nil),                     // 30: google.longrunning.Operation
	(*emptypb.Empty)(nil),                               // 31: google.protobuf.Empty
}
var file_google_cloud_dialogflow_cx_v3beta1_tool_proto_depIdxs = []int32{
	12, // 0: google.cloud.dialogflow.cx.v3beta1.CreateToolRequest.tool:type_name -> google.cloud.dialogflow.cx.v3beta1.Tool
	12, // 1: google.cloud.dialogflow.cx.v3beta1.ListToolsResponse.tools:type_name -> google.cloud.dialogflow.cx.v3beta1.Tool
	0,  // 2: google.cloud.dialogflow.cx.v3beta1.ExportToolsRequest.data_format:type_name -> google.cloud.dialogflow.cx.v3beta1.ExportToolsRequest.DataFormat
	26, // 3: google.cloud.dialogflow.cx.v3beta1.ExportToolsResponse.tools_content:type_name -> google.cloud.dialogflow.cx.v3beta1.InlineDestination
	12, // 4: google.cloud.dialogflow.cx.v3beta1.UpdateToolRequest.tool:type_name -> google.cloud.dialogflow.cx.v3beta1.Tool
	27, // 5: google.cloud.dialogflow.cx.v3beta1.UpdateToolRequest.update_mask:type_name -> google.protobuf.FieldMask
	14, // 6: google.cloud.dialogflow.cx.v3beta1.Tool.open_api_spec:type_name -> google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool
	15, // 7: google.cloud.dialogflow.cx.v3beta1.Tool.data_store_spec:type_name -> google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool
	16, // 8: google.cloud.dialogflow.cx.v3beta1.Tool.extension_spec:type_name -> google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool
	17, // 9: google.cloud.dialogflow.cx.v3beta1.Tool.function_spec:type_name -> google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool
	1,  // 10: google.cloud.dialogflow.cx.v3beta1.Tool.tool_type:type_name -> google.cloud.dialogflow.cx.v3beta1.Tool.ToolType
	18, // 11: google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool.authentication:type_name -> google.cloud.dialogflow.cx.v3beta1.Tool.Authentication
	19, // 12: google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool.tls_config:type_name -> google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig
	20, // 13: google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool.service_directory_config:type_name -> google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig
	28, // 14: google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.data_store_connections:type_name -> google.cloud.dialogflow.cx.v3beta1.DataStoreConnection
	21, // 15: google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.fallback_prompt:type_name -> google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt
	29, // 16: google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool.input_schema:type_name -> google.protobuf.Struct
	29, // 17: google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool.output_schema:type_name -> google.protobuf.Struct
	22, // 18: google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.api_key_config:type_name -> google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig
	23, // 19: google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.oauth_config:type_name -> google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig
	24, // 20: google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.service_agent_auth_config:type_name -> google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig
	25, // 21: google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.ca_certs:type_name -> google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert
	2,  // 22: google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig.request_location:type_name -> google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.RequestLocation
	3,  // 23: google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig.oauth_grant_type:type_name -> google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig.OauthGrantType
	4,  // 24: google.cloud.dialogflow.cx.v3beta1.Tools.CreateTool:input_type -> google.cloud.dialogflow.cx.v3beta1.CreateToolRequest
	5,  // 25: google.cloud.dialogflow.cx.v3beta1.Tools.ListTools:input_type -> google.cloud.dialogflow.cx.v3beta1.ListToolsRequest
	8,  // 26: google.cloud.dialogflow.cx.v3beta1.Tools.ExportTools:input_type -> google.cloud.dialogflow.cx.v3beta1.ExportToolsRequest
	7,  // 27: google.cloud.dialogflow.cx.v3beta1.Tools.GetTool:input_type -> google.cloud.dialogflow.cx.v3beta1.GetToolRequest
	10, // 28: google.cloud.dialogflow.cx.v3beta1.Tools.UpdateTool:input_type -> google.cloud.dialogflow.cx.v3beta1.UpdateToolRequest
	11, // 29: google.cloud.dialogflow.cx.v3beta1.Tools.DeleteTool:input_type -> google.cloud.dialogflow.cx.v3beta1.DeleteToolRequest
	12, // 30: google.cloud.dialogflow.cx.v3beta1.Tools.CreateTool:output_type -> google.cloud.dialogflow.cx.v3beta1.Tool
	6,  // 31: google.cloud.dialogflow.cx.v3beta1.Tools.ListTools:output_type -> google.cloud.dialogflow.cx.v3beta1.ListToolsResponse
	30, // 32: google.cloud.dialogflow.cx.v3beta1.Tools.ExportTools:output_type -> google.longrunning.Operation
	12, // 33: google.cloud.dialogflow.cx.v3beta1.Tools.GetTool:output_type -> google.cloud.dialogflow.cx.v3beta1.Tool
	12, // 34: google.cloud.dialogflow.cx.v3beta1.Tools.UpdateTool:output_type -> google.cloud.dialogflow.cx.v3beta1.Tool
	31, // 35: google.cloud.dialogflow.cx.v3beta1.Tools.DeleteTool:output_type -> google.protobuf.Empty
	30, // [30:36] is the sub-list for method output_type
	24, // [24:30] is the sub-list for method input_type
	24, // [24:24] is the sub-list for extension type_name
	24, // [24:24] is the sub-list for extension extendee
	0,  // [0:24] is the sub-list for field type_name
}

func init() { file_google_cloud_dialogflow_cx_v3beta1_tool_proto_init() }
func file_google_cloud_dialogflow_cx_v3beta1_tool_proto_init() {
	if File_google_cloud_dialogflow_cx_v3beta1_tool_proto != nil {
		return
	}
	file_google_cloud_dialogflow_cx_v3beta1_data_store_connection_proto_init()
	file_google_cloud_dialogflow_cx_v3beta1_inline_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*CreateToolRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*ListToolsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*ListToolsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*GetToolRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*ExportToolsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*ExportToolsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*UpdateToolRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*DeleteToolRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*Tool); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[9].Exporter = func(v any, i int) any {
			switch v := v.(*ExportToolsMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[10].Exporter = func(v any, i int) any {
			switch v := v.(*Tool_OpenApiTool); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[11].Exporter = func(v any, i int) any {
			switch v := v.(*Tool_DataStoreTool); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[12].Exporter = func(v any, i int) any {
			switch v := v.(*Tool_ExtensionTool); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[13].Exporter = func(v any, i int) any {
			switch v := v.(*Tool_FunctionTool); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[14].Exporter = func(v any, i int) any {
			switch v := v.(*Tool_Authentication); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[15].Exporter = func(v any, i int) any {
			switch v := v.(*Tool_TLSConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[16].Exporter = func(v any, i int) any {
			switch v := v.(*Tool_ServiceDirectoryConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[17].Exporter = func(v any, i int) any {
			switch v := v.(*Tool_DataStoreTool_FallbackPrompt); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[18].Exporter = func(v any, i int) any {
			switch v := v.(*Tool_Authentication_ApiKeyConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[19].Exporter = func(v any, i int) any {
			switch v := v.(*Tool_Authentication_OAuthConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[20].Exporter = func(v any, i int) any {
			switch v := v.(*Tool_Authentication_ServiceAgentAuthConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[21].Exporter = func(v any, i int) any {
			switch v := v.(*Tool_TLSConfig_CACert); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[4].OneofWrappers = []any{
		(*ExportToolsRequest_ToolsUri)(nil),
		(*ExportToolsRequest_ToolsContentInline)(nil),
	}
	file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[5].OneofWrappers = []any{
		(*ExportToolsResponse_ToolsUri)(nil),
		(*ExportToolsResponse_ToolsContent)(nil),
	}
	file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[8].OneofWrappers = []any{
		(*Tool_OpenApiSpec)(nil),
		(*Tool_DataStoreSpec)(nil),
		(*Tool_ExtensionSpec)(nil),
		(*Tool_FunctionSpec)(nil),
	}
	file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[10].OneofWrappers = []any{
		(*Tool_OpenApiTool_TextSchema)(nil),
	}
	file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes[14].OneofWrappers = []any{
		(*Tool_Authentication_ApiKeyConfig_)(nil),
		(*Tool_Authentication_OauthConfig)(nil),
		(*Tool_Authentication_ServiceAgentAuthConfig_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dialogflow_cx_v3beta1_tool_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   22,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_dialogflow_cx_v3beta1_tool_proto_goTypes,
		DependencyIndexes: file_google_cloud_dialogflow_cx_v3beta1_tool_proto_depIdxs,
		EnumInfos:         file_google_cloud_dialogflow_cx_v3beta1_tool_proto_enumTypes,
		MessageInfos:      file_google_cloud_dialogflow_cx_v3beta1_tool_proto_msgTypes,
	}.Build()
	File_google_cloud_dialogflow_cx_v3beta1_tool_proto = out.File
	file_google_cloud_dialogflow_cx_v3beta1_tool_proto_rawDesc = nil
	file_google_cloud_dialogflow_cx_v3beta1_tool_proto_goTypes = nil
	file_google_cloud_dialogflow_cx_v3beta1_tool_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ToolsClient is the client API for Tools service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ToolsClient interface {
	// Creates a [Tool][google.cloud.dialogflow.cx.v3beta1.Tool] in the specified
	// agent.
	CreateTool(ctx context.Context, in *CreateToolRequest, opts ...grpc.CallOption) (*Tool, error)
	// Returns a list of [Tools][google.cloud.dialogflow.cx.v3beta1.Tool] in the
	// specified agent.
	ListTools(ctx context.Context, in *ListToolsRequest, opts ...grpc.CallOption) (*ListToolsResponse, error)
	// Exports the selected tools.
	ExportTools(ctx context.Context, in *ExportToolsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Retrieves the specified [Tool][google.cloud.dialogflow.cx.v3beta1.Tool].
	GetTool(ctx context.Context, in *GetToolRequest, opts ...grpc.CallOption) (*Tool, error)
	// Update the specified [Tool][google.cloud.dialogflow.cx.v3beta1.Tool].
	UpdateTool(ctx context.Context, in *UpdateToolRequest, opts ...grpc.CallOption) (*Tool, error)
	// Deletes a specified [Tool][google.cloud.dialogflow.cx.v3beta1.Tool].
	DeleteTool(ctx context.Context, in *DeleteToolRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type toolsClient struct {
	cc grpc.ClientConnInterface
}

func NewToolsClient(cc grpc.ClientConnInterface) ToolsClient {
	return &toolsClient{cc}
}

func (c *toolsClient) CreateTool(ctx context.Context, in *CreateToolRequest, opts ...grpc.CallOption) (*Tool, error) {
	out := new(Tool)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.Tools/CreateTool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *toolsClient) ListTools(ctx context.Context, in *ListToolsRequest, opts ...grpc.CallOption) (*ListToolsResponse, error) {
	out := new(ListToolsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.Tools/ListTools", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *toolsClient) ExportTools(ctx context.Context, in *ExportToolsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.Tools/ExportTools", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *toolsClient) GetTool(ctx context.Context, in *GetToolRequest, opts ...grpc.CallOption) (*Tool, error) {
	out := new(Tool)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.Tools/GetTool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *toolsClient) UpdateTool(ctx context.Context, in *UpdateToolRequest, opts ...grpc.CallOption) (*Tool, error) {
	out := new(Tool)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.Tools/UpdateTool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *toolsClient) DeleteTool(ctx context.Context, in *DeleteToolRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.Tools/DeleteTool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ToolsServer is the server API for Tools service.
type ToolsServer interface {
	// Creates a [Tool][google.cloud.dialogflow.cx.v3beta1.Tool] in the specified
	// agent.
	CreateTool(context.Context, *CreateToolRequest) (*Tool, error)
	// Returns a list of [Tools][google.cloud.dialogflow.cx.v3beta1.Tool] in the
	// specified agent.
	ListTools(context.Context, *ListToolsRequest) (*ListToolsResponse, error)
	// Exports the selected tools.
	ExportTools(context.Context, *ExportToolsRequest) (*longrunningpb.Operation, error)
	// Retrieves the specified [Tool][google.cloud.dialogflow.cx.v3beta1.Tool].
	GetTool(context.Context, *GetToolRequest) (*Tool, error)
	// Update the specified [Tool][google.cloud.dialogflow.cx.v3beta1.Tool].
	UpdateTool(context.Context, *UpdateToolRequest) (*Tool, error)
	// Deletes a specified [Tool][google.cloud.dialogflow.cx.v3beta1.Tool].
	DeleteTool(context.Context, *DeleteToolRequest) (*emptypb.Empty, error)
}

// UnimplementedToolsServer can be embedded to have forward compatible implementations.
type UnimplementedToolsServer struct {
}

func (*UnimplementedToolsServer) CreateTool(context.Context, *CreateToolRequest) (*Tool, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTool not implemented")
}
func (*UnimplementedToolsServer) ListTools(context.Context, *ListToolsRequest) (*ListToolsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTools not implemented")
}
func (*UnimplementedToolsServer) ExportTools(context.Context, *ExportToolsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportTools not implemented")
}
func (*UnimplementedToolsServer) GetTool(context.Context, *GetToolRequest) (*Tool, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTool not implemented")
}
func (*UnimplementedToolsServer) UpdateTool(context.Context, *UpdateToolRequest) (*Tool, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTool not implemented")
}
func (*UnimplementedToolsServer) DeleteTool(context.Context, *DeleteToolRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTool not implemented")
}

func RegisterToolsServer(s *grpc.Server, srv ToolsServer) {
	s.RegisterService(&_Tools_serviceDesc, srv)
}

func _Tools_CreateTool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateToolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ToolsServer).CreateTool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.Tools/CreateTool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ToolsServer).CreateTool(ctx, req.(*CreateToolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Tools_ListTools_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListToolsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ToolsServer).ListTools(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.Tools/ListTools",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ToolsServer).ListTools(ctx, req.(*ListToolsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Tools_ExportTools_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportToolsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ToolsServer).ExportTools(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.Tools/ExportTools",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ToolsServer).ExportTools(ctx, req.(*ExportToolsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Tools_GetTool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetToolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ToolsServer).GetTool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.Tools/GetTool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ToolsServer).GetTool(ctx, req.(*GetToolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Tools_UpdateTool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateToolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ToolsServer).UpdateTool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.Tools/UpdateTool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ToolsServer).UpdateTool(ctx, req.(*UpdateToolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Tools_DeleteTool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteToolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ToolsServer).DeleteTool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.Tools/DeleteTool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ToolsServer).DeleteTool(ctx, req.(*DeleteToolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Tools_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.cx.v3beta1.Tools",
	HandlerType: (*ToolsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateTool",
			Handler:    _Tools_CreateTool_Handler,
		},
		{
			MethodName: "ListTools",
			Handler:    _Tools_ListTools_Handler,
		},
		{
			MethodName: "ExportTools",
			Handler:    _Tools_ExportTools_Handler,
		},
		{
			MethodName: "GetTool",
			Handler:    _Tools_GetTool_Handler,
		},
		{
			MethodName: "UpdateTool",
			Handler:    _Tools_UpdateTool_Handler,
		},
		{
			MethodName: "DeleteTool",
			Handler:    _Tools_DeleteTool_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/cx/v3beta1/tool.proto",
}
