// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.31.0
// 	protoc        v4.23.2
// source: google/cloud/functions/v2/functions.proto

package functionspb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	anypb "google.golang.org/protobuf/types/known/anypb"
	_ "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The environment the function is hosted on.
type Environment int32

const (
	// Unspecified
	Environment_ENVIRONMENT_UNSPECIFIED Environment = 0
	// Gen 1
	Environment_GEN_1 Environment = 1
	// Gen 2
	Environment_GEN_2 Environment = 2
)

// Enum value maps for Environment.
var (
	Environment_name = map[int32]string{
		0: "ENVIRONMENT_UNSPECIFIED",
		1: "GEN_1",
		2: "GEN_2",
	}
	Environment_value = map[string]int32{
		"ENVIRONMENT_UNSPECIFIED": 0,
		"GEN_1":                   1,
		"GEN_2":                   2,
	}
)

func (x Environment) Enum() *Environment {
	p := new(Environment)
	*p = x
	return p
}

func (x Environment) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Environment) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_functions_v2_functions_proto_enumTypes[0].Descriptor()
}

func (Environment) Type() protoreflect.EnumType {
	return &file_google_cloud_functions_v2_functions_proto_enumTypes[0]
}

func (x Environment) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Environment.Descriptor instead.
func (Environment) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_functions_v2_functions_proto_rawDescGZIP(), []int{0}
}

// Describes the current state of the function.
type Function_State int32

const (
	// Not specified. Invalid state.
	Function_STATE_UNSPECIFIED Function_State = 0
	// Function has been successfully deployed and is serving.
	Function_ACTIVE Function_State = 1
	// Function deployment failed and the function is not serving.
	Function_FAILED Function_State = 2
	// Function is being created or updated.
	Function_DEPLOYING Function_State = 3
	// Function is being deleted.
	Function_DELETING Function_State = 4
	// Function deployment failed and the function serving state is undefined.
	// The function should be updated or deleted to move it out of this state.
	Function_UNKNOWN Function_State = 5
)

// Enum value maps for Function_State.
var (
	Function_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "FAILED",
		3: "DEPLOYING",
		4: "DELETING",
		5: "UNKNOWN",
	}
	Function_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
		"FAILED":            2,
		"DEPLOYING":         3,
		"DELETING":          4,
		"UNKNOWN":           5,
	}
)

func (x Function_State) Enum() *Function_State {
	p := new(Function_State)
	*p = x
	return p
}

func (x Function_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Function_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_functions_v2_functions_proto_enumTypes[1].Descriptor()
}

func (Function_State) Type() protoreflect.EnumType {
	return &file_google_cloud_functions_v2_functions_proto_enumTypes[1]
}

func (x Function_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Function_State.Descriptor instead.
func (Function_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_functions_v2_functions_proto_rawDescGZIP(), []int{0, 0}
}

// Severity of the state message.
type StateMessage_Severity int32

const (
	// Not specified. Invalid severity.
	StateMessage_SEVERITY_UNSPECIFIED StateMessage_Severity = 0
	// ERROR-level severity.
	StateMessage_ERROR StateMessage_Severity = 1
	// WARNING-level severity.
	StateMessage_WARNING StateMessage_Severity = 2
	// INFO-level severity.
	StateMessage_INFO StateMessage_Severity = 3
)

// Enum value maps for StateMessage_Severity.
var (
	StateMessage_Severity_name = map[int32]string{
		0: "SEVERITY_UNSPECIFIED",
		1: "ERROR",
		2: "WARNING",
		3: "INFO",
	}
	StateMessage_Severity_value = map[string]int32{
		"SEVERITY_UNSPECIFIED": 0,
		"ERROR":                1,
		"WARNING":              2,
		"INFO":                 3,
	}
)

func (x StateMessage_Severity) Enum() *StateMessage_Severity {
	p := new(StateMessage_Severity)
	*p = x
	return p
}

func (x StateMessage_Severity) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StateMessage_Severity) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_functions_v2_functions_proto_enumTypes[2].Descriptor()
}

func (StateMessage_Severity) Type() protoreflect.EnumType {
	return &file_google_cloud_functions_v2_functions_proto_enumTypes[2]
}

func (x StateMessage_Severity) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StateMessage_Severity.Descriptor instead.
func (StateMessage_Severity) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_functions_v2_functions_proto_rawDescGZIP(), []int{1, 0}
}

// Docker Registry to use for storing function Docker images.
type BuildConfig_DockerRegistry int32

const (
	// Unspecified.
	BuildConfig_DOCKER_REGISTRY_UNSPECIFIED BuildConfig_DockerRegistry = 0
	// Docker images will be stored in multi-regional Container Registry
	// repositories named `gcf`.
	BuildConfig_CONTAINER_REGISTRY BuildConfig_DockerRegistry = 1
	// Docker images will be stored in regional Artifact Registry repositories.
	// By default, GCF will create and use repositories named `gcf-artifacts`
	// in every region in which a function is deployed. But the repository to
	// use can also be specified by the user using the `docker_repository`
	// field.
	BuildConfig_ARTIFACT_REGISTRY BuildConfig_DockerRegistry = 2
)

// Enum value maps for BuildConfig_DockerRegistry.
var (
	BuildConfig_DockerRegistry_name = map[int32]string{
		0: "DOCKER_REGISTRY_UNSPECIFIED",
		1: "CONTAINER_REGISTRY",
		2: "ARTIFACT_REGISTRY",
	}
	BuildConfig_DockerRegistry_value = map[string]int32{
		"DOCKER_REGISTRY_UNSPECIFIED": 0,
		"CONTAINER_REGISTRY":          1,
		"ARTIFACT_REGISTRY":           2,
	}
)

func (x BuildConfig_DockerRegistry) Enum() *BuildConfig_DockerRegistry {
	p := new(BuildConfig_DockerRegistry)
	*p = x
	return p
}

func (x BuildConfig_DockerRegistry) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BuildConfig_DockerRegistry) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_functions_v2_functions_proto_enumTypes[3].Descriptor()
}

func (BuildConfig_DockerRegistry) Type() protoreflect.EnumType {
	return &file_google_cloud_functions_v2_functions_proto_enumTypes[3]
}

func (x BuildConfig_DockerRegistry) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BuildConfig_DockerRegistry.Descriptor instead.
func (BuildConfig_DockerRegistry) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_functions_v2_functions_proto_rawDescGZIP(), []int{6, 0}
}

// Available egress settings.
//
// This controls what traffic is diverted through the VPC Access Connector
// resource. By default PRIVATE_RANGES_ONLY will be used.
type ServiceConfig_VpcConnectorEgressSettings int32

const (
	// Unspecified.
	ServiceConfig_VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED ServiceConfig_VpcConnectorEgressSettings = 0
	// Use the VPC Access Connector only for private IP space from RFC1918.
	ServiceConfig_PRIVATE_RANGES_ONLY ServiceConfig_VpcConnectorEgressSettings = 1
	// Force the use of VPC Access Connector for all egress traffic from the
	// function.
	ServiceConfig_ALL_TRAFFIC ServiceConfig_VpcConnectorEgressSettings = 2
)

// Enum value maps for ServiceConfig_VpcConnectorEgressSettings.
var (
	ServiceConfig_VpcConnectorEgressSettings_name = map[int32]string{
		0: "VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED",
		1: "PRIVATE_RANGES_ONLY",
		2: "ALL_TRAFFIC",
	}
	ServiceConfig_VpcConnectorEgressSettings_value = map[string]int32{
		"VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED": 0,
		"PRIVATE_RANGES_ONLY":                       1,
		"ALL_TRAFFIC":                               2,
	}
)

func (x ServiceConfig_VpcConnectorEgressSettings) Enum() *ServiceConfig_VpcConnectorEgressSettings {
	p := new(ServiceConfig_VpcConnectorEgressSettings)
	*p = x
	return p
}

func (x ServiceConfig_VpcConnectorEgressSettings) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ServiceConfig_VpcConnectorEgressSettings) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_functions_v2_functions_proto_enumTypes[4].Descriptor()
}

func (ServiceConfig_VpcConnectorEgressSettings) Type() protoreflect.EnumType {
	return &file_google_cloud_functions_v2_functions_proto_enumTypes[4]
}

func (x ServiceConfig_VpcConnectorEgressSettings) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ServiceConfig_VpcConnectorEgressSettings.Descriptor instead.
func (ServiceConfig_VpcConnectorEgressSettings) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_functions_v2_functions_proto_rawDescGZIP(), []int{7, 0}
}

// Available ingress settings.
//
// This controls what traffic can reach the function.
//
// If unspecified, ALLOW_ALL will be used.
type ServiceConfig_IngressSettings int32

const (
	// Unspecified.
	ServiceConfig_INGRESS_SETTINGS_UNSPECIFIED ServiceConfig_IngressSettings = 0
	// Allow HTTP traffic from public and private sources.
	ServiceConfig_ALLOW_ALL ServiceConfig_IngressSettings = 1
	// Allow HTTP traffic from only private VPC sources.
	ServiceConfig_ALLOW_INTERNAL_ONLY ServiceConfig_IngressSettings = 2
	// Allow HTTP traffic from private VPC sources and through GCLB.
	ServiceConfig_ALLOW_INTERNAL_AND_GCLB ServiceConfig_IngressSettings = 3
)

// Enum value maps for ServiceConfig_IngressSettings.
var (
	ServiceConfig_IngressSettings_name = map[int32]string{
		0: "INGRESS_SETTINGS_UNSPECIFIED",
		1: "ALLOW_ALL",
		2: "ALLOW_INTERNAL_ONLY",
		3: "ALLOW_INTERNAL_AND_GCLB",
	}
	ServiceConfig_IngressSettings_value = map[string]int32{
		"INGRESS_SETTINGS_UNSPECIFIED": 0,
		"ALLOW_ALL":                    1,
		"ALLOW_INTERNAL_ONLY":          2,
		"ALLOW_INTERNAL_AND_GCLB":      3,
	}
)

func (x ServiceConfig_IngressSettings) Enum() *ServiceConfig_IngressSettings {
	p := new(ServiceConfig_IngressSettings)
	*p = x
	return p
}

func (x ServiceConfig_IngressSettings) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ServiceConfig_IngressSettings) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_functions_v2_functions_proto_enumTypes[5].Descriptor()
}

func (ServiceConfig_IngressSettings) Type() protoreflect.EnumType {
	return &file_google_cloud_functions_v2_functions_proto_enumTypes[5]
}

func (x ServiceConfig_IngressSettings) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ServiceConfig_IngressSettings.Descriptor instead.
func (ServiceConfig_IngressSettings) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_functions_v2_functions_proto_rawDescGZIP(), []int{7, 1}
}

// Available security level settings.
//
// This enforces security protocol on function URL.
//
// Security level is only configurable for 1st Gen functions, If unspecified,
// SECURE_OPTIONAL will be used. 2nd Gen functions are SECURE_ALWAYS ONLY.
type ServiceConfig_SecurityLevel int32

const (
	// Unspecified.
	ServiceConfig_SECURITY_LEVEL_UNSPECIFIED ServiceConfig_SecurityLevel = 0
	// Requests for a URL that match this handler that do not use HTTPS are
	// automatically redirected to the HTTPS URL with the same path. Query
	// parameters are reserved for the redirect.
	ServiceConfig_SECURE_ALWAYS ServiceConfig_SecurityLevel = 1
	// Both HTTP and HTTPS requests with URLs that match the handler succeed
	// without redirects. The application can examine the request to determine
	// which protocol was used and respond accordingly.
	ServiceConfig_SECURE_OPTIONAL ServiceConfig_SecurityLevel = 2
)

// Enum value maps for ServiceConfig_SecurityLevel.
var (
	ServiceConfig_SecurityLevel_name = map[int32]string{
		0: "SECURITY_LEVEL_UNSPECIFIED",
		1: "SECURE_ALWAYS",
		2: "SECURE_OPTIONAL",
	}
	ServiceConfig_SecurityLevel_value = map[string]int32{
		"SECURITY_LEVEL_UNSPECIFIED": 0,
		"SECURE_ALWAYS":              1,
		"SECURE_OPTIONAL":            2,
	}
)

func (x ServiceConfig_SecurityLevel) Enum() *ServiceConfig_SecurityLevel {
	p := new(ServiceConfig_SecurityLevel)
	*p = x
	return p
}

func (x ServiceConfig_SecurityLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ServiceConfig_SecurityLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_functions_v2_functions_proto_enumTypes[6].Descriptor()
}

func (ServiceConfig_SecurityLevel) Type() protoreflect.EnumType {
	return &file_google_cloud_functions_v2_functions_proto_enumTypes[6]
}

func (x ServiceConfig_SecurityLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ServiceConfig_SecurityLevel.Descriptor instead.
func (ServiceConfig_SecurityLevel) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_functions_v2_functions_proto_rawDescGZIP(), []int{7, 2}
}

// Describes the retry policy in case of function's execution failure.
// Retried execution is charged as any other execution.
type EventTrigger_RetryPolicy int32

const (
	// Not specified.
	EventTrigger_RETRY_POLICY_UNSPECIFIED EventTrigger_RetryPolicy = 0
	// Do not retry.
	EventTrigger_RETRY_POLICY_DO_NOT_RETRY EventTrigger_RetryPolicy = 1
	// Retry on any failure, retry up to 7 days with an exponential backoff
	// (capped at 10 seconds).
	EventTrigger_RETRY_POLICY_RETRY EventTrigger_RetryPolicy = 2
)

// Enum value maps for EventTrigger_RetryPolicy.
var (
	EventTrigger_RetryPolicy_name = map[int32]string{
		0: "RETRY_POLICY_UNSPECIFIED",
		1: "RETRY_POLICY_DO_NOT_RETRY",
		2: "RETRY_POLICY_RETRY",
	}
	EventTrigger_RetryPolicy_value = map[string]int32{
		"RETRY_POLICY_UNSPECIFIED":  0,
		"RETRY_POLICY_DO_NOT_RETRY": 1,
		"RETRY_POLICY_RETRY":        2,
	}
)

func (x EventTrigger_RetryPolicy) Enum() *EventTrigger_RetryPolicy {
	p := new(EventTrigger_RetryPolicy)
	*p = x
	return p
}

func (x EventTrigger_RetryPolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EventTrigger_RetryPolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_functions_v2_functions_proto_enumTypes[7].Descriptor()
}

func (EventTrigger_RetryPolicy) Type() protoreflect.EnumType {
	return &file_google_cloud_functions_v2_functions_proto_enumTypes[7]
}

func (x EventTrigger_RetryPolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EventTrigger_RetryPolicy.Descriptor instead.
func (EventTrigger_RetryPolicy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_functions_v2_functions_proto_rawDescGZIP(), []int{10, 0}
}

// The various stages that a runtime can be in.
type ListRuntimesResponse_RuntimeStage int32

const (
	// Not specified.
	ListRuntimesResponse_RUNTIME_STAGE_UNSPECIFIED ListRuntimesResponse_RuntimeStage = 0
	// The runtime is in development.
	ListRuntimesResponse_DEVELOPMENT ListRuntimesResponse_RuntimeStage = 1
	// The runtime is in the Alpha stage.
	ListRuntimesResponse_ALPHA ListRuntimesResponse_RuntimeStage = 2
	// The runtime is in the Beta stage.
	ListRuntimesResponse_BETA ListRuntimesResponse_RuntimeStage = 3
	// The runtime is generally available.
	ListRuntimesResponse_GA ListRuntimesResponse_RuntimeStage = 4
	// The runtime is deprecated.
	ListRuntimesResponse_DEPRECATED ListRuntimesResponse_RuntimeStage = 5
	// The runtime is no longer supported.
	ListRuntimesResponse_DECOMMISSIONED ListRuntimesResponse_RuntimeStage = 6
)

// Enum value maps for ListRuntimesResponse_RuntimeStage.
var (
	ListRuntimesResponse_RuntimeStage_name = map[int32]string{
		0: "RUNTIME_STAGE_UNSPECIFIED",
		1: "DEVELOPMENT",
		2: "ALPHA",
		3: "BETA",
		4: "GA",
		5: "DEPRECATED",
		6: "DECOMMISSIONED",
	}
	ListRuntimesResponse_RuntimeStage_value = map[string]int32{
		"RUNTIME_STAGE_UNSPECIFIED": 0,
		"DEVELOPMENT":               1,
		"ALPHA":                     2,
		"BETA":                      3,
		"GA":                        4,
		"DEPRECATED":                5,
		"DECOMMISSIONED":            6,
	}
)

func (x ListRuntimesResponse_RuntimeStage) Enum() *ListRuntimesResponse_RuntimeStage {
	p := new(ListRuntimesResponse_RuntimeStage)
	*p = x
	return p
}

func (x ListRuntimesResponse_RuntimeStage) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ListRuntimesResponse_RuntimeStage) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_functions_v2_functions_proto_enumTypes[8].Descriptor()
}

func (ListRuntimesResponse_RuntimeStage) Type() protoreflect.EnumType {
	return &file_google_cloud_functions_v2_functions_proto_enumTypes[8]
}

func (x ListRuntimesResponse_RuntimeStage) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ListRuntimesResponse_RuntimeStage.Descriptor instead.
func (ListRuntimesResponse_RuntimeStage) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_functions_v2_functions_proto_rawDescGZIP(), []int{23, 0}
}

// Possible names for a Stage
type Stage_Name int32

const (
	// Not specified. Invalid name.
	Stage_NAME_UNSPECIFIED Stage_Name = 0
	// Artifact Regsitry Stage
	Stage_ARTIFACT_REGISTRY Stage_Name = 1
	// Build Stage
	Stage_BUILD Stage_Name = 2
	// Service Stage
	Stage_SERVICE Stage_Name = 3
	// Trigger Stage
	Stage_TRIGGER Stage_Name = 4
	// Service Rollback Stage
	Stage_SERVICE_ROLLBACK Stage_Name = 5
	// Trigger Rollback Stage
	Stage_TRIGGER_ROLLBACK Stage_Name = 6
)

// Enum value maps for Stage_Name.
var (
	Stage_Name_name = map[int32]string{
		0: "NAME_UNSPECIFIED",
		1: "ARTIFACT_REGISTRY",
		2: "BUILD",
		3: "SERVICE",
		4: "TRIGGER",
		5: "SERVICE_ROLLBACK",
		6: "TRIGGER_ROLLBACK",
	}
	Stage_Name_value = map[string]int32{
		"NAME_UNSPECIFIED":  0,
		"ARTIFACT_REGISTRY": 1,
		"BUILD":             2,
		"SERVICE":           3,
		"TRIGGER":           4,
		"SERVICE_ROLLBACK":  5,
		"TRIGGER_ROLLBACK":  6,
	}
)

func (x Stage_Name) Enum() *Stage_Name {
	p := new(Stage_Name)
	*p = x
	return p
}

func (x Stage_Name) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Stage_Name) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_functions_v2_functions_proto_enumTypes[9].Descriptor()
}

func (Stage_Name) Type() protoreflect.EnumType {
	return &file_google_cloud_functions_v2_functions_proto_enumTypes[9]
}

func (x Stage_Name) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Stage_Name.Descriptor instead.
func (Stage_Name) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_functions_v2_functions_proto_rawDescGZIP(), []int{26, 0}
}

// Possible states for a Stage
type Stage_State int32

const (
	// Not specified. Invalid state.
	Stage_STATE_UNSPECIFIED Stage_State = 0
	// Stage has not started.
	Stage_NOT_STARTED Stage_State = 1
	// Stage is in progress.
	Stage_IN_PROGRESS Stage_State = 2
	// Stage has completed.
	Stage_COMPLETE Stage_State = 3
)

// Enum value maps for Stage_State.
var (
	Stage_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "NOT_STARTED",
		2: "IN_PROGRESS",
		3: "COMPLETE",
	}
	Stage_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"NOT_STARTED":       1,
		"IN_PROGRESS":       2,
		"COMPLETE":          3,
	}
)

func (x Stage_State) Enum() *Stage_State {
	p := new(Stage_State)
	*p = x
	return p
}

func (x Stage_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Stage_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_functions_v2_functions_proto_enumTypes[10].Descriptor()
}

func (Stage_State) Type() protoreflect.EnumType {
	return &file_google_cloud_functions_v2_functions_proto_enumTypes[10]
}

func (x Stage_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Stage_State.Descriptor instead.
func (Stage_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_functions_v2_functions_proto_rawDescGZIP(), []int{26, 1}
}

// Describes a Cloud Function that contains user computation executed in
// response to an event. It encapsulates function and trigger configurations.
type Function struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A user-defined name of the function. Function names must be unique
	// globally and match pattern `projects/*/locations/*/functions/*`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// User-provided description of a function.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Describes the Build step of the function that builds a container from the
	// given source.
	BuildConfig *BuildConfig `protobuf:"bytes,3,opt,name=build_config,json=buildConfig,proto3" json:"build_config,omitempty"`
	// Describes the Service being deployed. Currently deploys services to Cloud
	// Run (fully managed).
	ServiceConfig *ServiceConfig `protobuf:"bytes,4,opt,name=service_config,json=serviceConfig,proto3" json:"service_config,omitempty"`
	// An Eventarc trigger managed by Google Cloud Functions that fires events in
	// response to a condition in another service.
	EventTrigger *EventTrigger `protobuf:"bytes,5,opt,name=event_trigger,json=eventTrigger,proto3" json:"event_trigger,omitempty"`
	// Output only. State of the function.
	State Function_State `protobuf:"varint,6,opt,name=state,proto3,enum=google.cloud.functions.v2.Function_State" json:"state,omitempty"`
	// Output only. The last update timestamp of a Cloud Function.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Labels associated with this Cloud Function.
	Labels map[string]string `protobuf:"bytes,8,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. State Messages for this Cloud Function.
	StateMessages []*StateMessage `protobuf:"bytes,9,rep,name=state_messages,json=stateMessages,proto3" json:"state_messages,omitempty"`
	// Describe whether the function is 1st Gen or 2nd Gen.
	Environment Environment `protobuf:"varint,10,opt,name=environment,proto3,enum=google.cloud.functions.v2.Environment" json:"environment,omitempty"`
	// Output only. The deployed url for the function.
	Url string `protobuf:"bytes,14,opt,name=url,proto3" json:"url,omitempty"`
	// [Preview] Resource name of a KMS crypto key (managed by the user) used to
	// encrypt/decrypt function resources.
	//
	// It must match the pattern
	// `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
	KmsKeyName string `protobuf:"bytes,25,opt,name=kms_key_name,json=kmsKeyName,proto3" json:"kms_key_name,omitempty"`
}

func (x *Function) Reset() {
	*x = Function{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Function) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Function) ProtoMessage() {}

func (x *Function) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Function.ProtoReflect.Descriptor instead.
func (*Function) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v2_functions_proto_rawDescGZIP(), []int{0}
}

func (x *Function) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Function) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Function) GetBuildConfig() *BuildConfig {
	if x != nil {
		return x.BuildConfig
	}
	return nil
}

func (x *Function) GetServiceConfig() *ServiceConfig {
	if x != nil {
		return x.ServiceConfig
	}
	return nil
}

func (x *Function) GetEventTrigger() *EventTrigger {
	if x != nil {
		return x.EventTrigger
	}
	return nil
}

func (x *Function) GetState() Function_State {
	if x != nil {
		return x.State
	}
	return Function_STATE_UNSPECIFIED
}

func (x *Function) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Function) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Function) GetStateMessages() []*StateMessage {
	if x != nil {
		return x.StateMessages
	}
	return nil
}

func (x *Function) GetEnvironment() Environment {
	if x != nil {
		return x.Environment
	}
	return Environment_ENVIRONMENT_UNSPECIFIED
}

func (x *Function) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *Function) GetKmsKeyName() string {
	if x != nil {
		return x.KmsKeyName
	}
	return ""
}

// Informational messages about the state of the Cloud Function or Operation.
type StateMessage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Severity of the state message.
	Severity StateMessage_Severity `protobuf:"varint,1,opt,name=severity,proto3,enum=google.cloud.functions.v2.StateMessage_Severity" json:"severity,omitempty"`
	// One-word CamelCase type of the state message.
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// The message.
	Message string `protobuf:"bytes,3,opt,name=message,proto3" json:"message,omitempty"`
}

func (x *StateMessage) Reset() {
	*x = StateMessage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StateMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StateMessage) ProtoMessage() {}

func (x *StateMessage) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StateMessage.ProtoReflect.Descriptor instead.
func (*StateMessage) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v2_functions_proto_rawDescGZIP(), []int{1}
}

func (x *StateMessage) GetSeverity() StateMessage_Severity {
	if x != nil {
		return x.Severity
	}
	return StateMessage_SEVERITY_UNSPECIFIED
}

func (x *StateMessage) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *StateMessage) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

// Location of the source in an archive file in Google Cloud Storage.
type StorageSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Google Cloud Storage bucket containing the source (see
	// [Bucket Name
	// Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Google Cloud Storage object containing the source.
	//
	// This object must be a gzipped archive file (`.tar.gz`) containing source to
	// build.
	Object string `protobuf:"bytes,2,opt,name=object,proto3" json:"object,omitempty"`
	// Google Cloud Storage generation for the object. If the generation is
	// omitted, the latest generation will be used.
	Generation int64 `protobuf:"varint,3,opt,name=generation,proto3" json:"generation,omitempty"`
}

func (x *StorageSource) Reset() {
	*x = StorageSource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StorageSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StorageSource) ProtoMessage() {}

func (x *StorageSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StorageSource.ProtoReflect.Descriptor instead.
func (*StorageSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v2_functions_proto_rawDescGZIP(), []int{2}
}

func (x *StorageSource) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *StorageSource) GetObject() string {
	if x != nil {
		return x.Object
	}
	return ""
}

func (x *StorageSource) GetGeneration() int64 {
	if x != nil {
		return x.Generation
	}
	return 0
}

// Location of the source in a Google Cloud Source Repository.
type RepoSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A revision within the Cloud Source Repository must be specified in
	// one of these ways.
	//
	// Types that are assignable to Revision:
	//	*RepoSource_BranchName
	//	*RepoSource_TagName
	//	*RepoSource_CommitSha
	Revision isRepoSource_Revision `protobuf_oneof:"revision"`
	// ID of the project that owns the Cloud Source Repository. If omitted, the
	// project ID requesting the build is assumed.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Name of the Cloud Source Repository.
	RepoName string `protobuf:"bytes,2,opt,name=repo_name,json=repoName,proto3" json:"repo_name,omitempty"`
	// Directory, relative to the source root, in which to run the build.
	//
	// This must be a relative path. If a step's `dir` is specified and is an
	// absolute path, this value is ignored for that step's execution.
	// eg. helloworld (no leading slash allowed)
	Dir string `protobuf:"bytes,6,opt,name=dir,proto3" json:"dir,omitempty"`
	// Only trigger a build if the revision regex does NOT match the revision
	// regex.
	InvertRegex bool `protobuf:"varint,7,opt,name=invert_regex,json=invertRegex,proto3" json:"invert_regex,omitempty"`
}

func (x *RepoSource) Reset() {
	*x = RepoSource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RepoSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RepoSource) ProtoMessage() {}

func (x *RepoSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RepoSource.ProtoReflect.Descriptor instead.
func (*RepoSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v2_functions_proto_rawDescGZIP(), []int{3}
}

func (m *RepoSource) GetRevision() isRepoSource_Revision {
	if m != nil {
		return m.Revision
	}
	return nil
}

func (x *RepoSource) GetBranchName() string {
	if x, ok := x.GetRevision().(*RepoSource_BranchName); ok {
		return x.BranchName
	}
	return ""
}

func (x *RepoSource) GetTagName() string {
	if x, ok := x.GetRevision().(*RepoSource_TagName); ok {
		return x.TagName
	}
	return ""
}

func (x *RepoSource) GetCommitSha() string {
	if x, ok := x.GetRevision().(*RepoSource_CommitSha); ok {
		return x.CommitSha
	}
	return ""
}

func (x *RepoSource) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *RepoSource) GetRepoName() string {
	if x != nil {
		return x.RepoName
	}
	return ""
}

func (x *RepoSource) GetDir() string {
	if x != nil {
		return x.Dir
	}
	return ""
}

func (x *RepoSource) GetInvertRegex() bool {
	if x != nil {
		return x.InvertRegex
	}
	return false
}

type isRepoSource_Revision interface {
	isRepoSource_Revision()
}

type RepoSource_BranchName struct {
	// Regex matching branches to build.
	//
	// The syntax of the regular expressions accepted is the syntax accepted by
	// RE2 and described at https://github.com/google/re2/wiki/Syntax
	BranchName string `protobuf:"bytes,3,opt,name=branch_name,json=branchName,proto3,oneof"`
}

type RepoSource_TagName struct {
	// Regex matching tags to build.
	//
	// The syntax of the regular expressions accepted is the syntax accepted by
	// RE2 and described at https://github.com/google/re2/wiki/Syntax
	TagName string `protobuf:"bytes,4,opt,name=tag_name,json=tagName,proto3,oneof"`
}

type RepoSource_CommitSha struct {
	// Explicit commit SHA to build.
	CommitSha string `protobuf:"bytes,5,opt,name=commit_sha,json=commitSha,proto3,oneof"`
}

func (*RepoSource_BranchName) isRepoSource_Revision() {}

func (*RepoSource_TagName) isRepoSource_Revision() {}

func (*RepoSource_CommitSha) isRepoSource_Revision() {}

// The location of the function source code.
type Source struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Location of the source.
	// At least one source needs to be provided for the deployment to succeed.
	//
	// Types that are assignable to Source:
	//	*Source_StorageSource
	//	*Source_RepoSource
	Source isSource_Source `protobuf_oneof:"source"`
}

func (x *Source) Reset() {
	*x = Source{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Source) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Source) ProtoMessage() {}

func (x *Source) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Source.ProtoReflect.Descriptor instead.
func (*Source) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v2_functions_proto_rawDescGZIP(), []int{4}
}

func (m *Source) GetSource() isSource_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *Source) GetStorageSource() *StorageSource {
	if x, ok := x.GetSource().(*Source_StorageSource); ok {
		return x.StorageSource
	}
	return nil
}

func (x *Source) GetRepoSource() *RepoSource {
	if x, ok := x.GetSource().(*Source_RepoSource); ok {
		return x.RepoSource
	}
	return nil
}

type isSource_Source interface {
	isSource_Source()
}

type Source_StorageSource struct {
	// If provided, get the source from this location in Google Cloud Storage.
	StorageSource *StorageSource `protobuf:"bytes,1,opt,name=storage_source,json=storageSource,proto3,oneof"`
}

type Source_RepoSource struct {
	// If provided, get the source from this location in a Cloud Source
	// Repository.
	RepoSource *RepoSource `protobuf:"bytes,2,opt,name=repo_source,json=repoSource,proto3,oneof"`
}

func (*Source_StorageSource) isSource_Source() {}

func (*Source_RepoSource) isSource_Source() {}

// Provenance of the source. Ways to find the original source, or verify that
// some source was used for this build.
type SourceProvenance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A copy of the build's `source.storage_source`, if exists, with any
	// generations resolved.
	ResolvedStorageSource *StorageSource `protobuf:"bytes,1,opt,name=resolved_storage_source,json=resolvedStorageSource,proto3" json:"resolved_storage_source,omitempty"`
	// A copy of the build's `source.repo_source`, if exists, with any
	// revisions resolved.
	ResolvedRepoSource *RepoSource `protobuf:"bytes,2,opt,name=resolved_repo_source,json=resolvedRepoSource,proto3" json:"resolved_repo_source,omitempty"`
}

func (x *SourceProvenance) Reset() {
	*x = SourceProvenance{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SourceProvenance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SourceProvenance) ProtoMessage() {}

func (x *SourceProvenance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SourceProvenance.ProtoReflect.Descriptor instead.
func (*SourceProvenance) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v2_functions_proto_rawDescGZIP(), []int{5}
}

func (x *SourceProvenance) GetResolvedStorageSource() *StorageSource {
	if x != nil {
		return x.ResolvedStorageSource
	}
	return nil
}

func (x *SourceProvenance) GetResolvedRepoSource() *RepoSource {
	if x != nil {
		return x.ResolvedRepoSource
	}
	return nil
}

// Describes the Build step of the function that builds a container from the
// given source.
type BuildConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The Cloud Build name of the latest successful deployment of
	// the function.
	Build string `protobuf:"bytes,1,opt,name=build,proto3" json:"build,omitempty"`
	// The runtime in which to run the function. Required when deploying a new
	// function, optional when updating an existing function. For a complete
	// list of possible choices, see the
	// [`gcloud` command
	// reference](https://cloud.google.com/sdk/gcloud/reference/functions/deploy#--runtime).
	Runtime string `protobuf:"bytes,2,opt,name=runtime,proto3" json:"runtime,omitempty"`
	// The name of the function (as defined in source code) that will be
	// executed. Defaults to the resource name suffix, if not specified. For
	// backward compatibility, if function with given name is not found, then the
	// system will try to use function named "function".
	// For Node.js this is name of a function exported by the module specified
	// in `source_location`.
	EntryPoint string `protobuf:"bytes,3,opt,name=entry_point,json=entryPoint,proto3" json:"entry_point,omitempty"`
	// The location of the function source code.
	Source *Source `protobuf:"bytes,4,opt,name=source,proto3" json:"source,omitempty"`
	// Output only. A permanent fixed identifier for source.
	SourceProvenance *SourceProvenance `protobuf:"bytes,8,opt,name=source_provenance,json=sourceProvenance,proto3" json:"source_provenance,omitempty"`
	// Name of the Cloud Build Custom Worker Pool that should be used to build the
	// function. The format of this field is
	// `projects/{project}/locations/{region}/workerPools/{workerPool}` where
	// {project} and {region} are the project id and region respectively where the
	// worker pool is defined and {workerPool} is the short name of the worker
	// pool.
	//
	// If the project id is not the same as the function, then the Cloud
	// Functions Service Agent
	// (service-<project_number>@gcf-admin-robot.iam.gserviceaccount.com) must be
	// granted the role Cloud Build Custom Workers Builder
	// (roles/cloudbuild.customworkers.builder) in the project.
	WorkerPool string `protobuf:"bytes,5,opt,name=worker_pool,json=workerPool,proto3" json:"worker_pool,omitempty"`
	// User-provided build-time environment variables for the function
	EnvironmentVariables map[string]string `protobuf:"bytes,6,rep,name=environment_variables,json=environmentVariables,proto3" json:"environment_variables,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Docker Registry to use for this deployment. This configuration is only
	// applicable to 1st Gen functions, 2nd Gen functions can only use Artifact
	// Registry.
	//
	// If `docker_repository` field is specified, this field will be automatically
	// set as `ARTIFACT_REGISTRY`.
	// If unspecified, it currently defaults to `CONTAINER_REGISTRY`.
	// This field may be overridden by the backend for eligible deployments.
	DockerRegistry BuildConfig_DockerRegistry `protobuf:"varint,10,opt,name=docker_registry,json=dockerRegistry,proto3,enum=google.cloud.functions.v2.BuildConfig_DockerRegistry" json:"docker_registry,omitempty"`
	// User managed repository created in Artifact Registry optionally
	// with a customer managed encryption key. This is the repository to which the
	// function docker image will be pushed after it is built by Cloud Build.
	// If unspecified, GCF will create and use a repository named 'gcf-artifacts'
	// for every deployed region.
	//
	// It must match the pattern
	// `projects/{project}/locations/{location}/repositories/{repository}`.
	//
	// Cross-project repositories are not supported.
	// Cross-location repositories are not supported.
	// Repository format must be 'DOCKER'.
	DockerRepository string `protobuf:"bytes,7,opt,name=docker_repository,json=dockerRepository,proto3" json:"docker_repository,omitempty"`
}

func (x *BuildConfig) Reset() {
	*x = BuildConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BuildConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BuildConfig) ProtoMessage() {}

func (x *BuildConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BuildConfig.ProtoReflect.Descriptor instead.
func (*BuildConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v2_functions_proto_rawDescGZIP(), []int{6}
}

func (x *BuildConfig) GetBuild() string {
	if x != nil {
		return x.Build
	}
	return ""
}

func (x *BuildConfig) GetRuntime() string {
	if x != nil {
		return x.Runtime
	}
	return ""
}

func (x *BuildConfig) GetEntryPoint() string {
	if x != nil {
		return x.EntryPoint
	}
	return ""
}

func (x *BuildConfig) GetSource() *Source {
	if x != nil {
		return x.Source
	}
	return nil
}

func (x *BuildConfig) GetSourceProvenance() *SourceProvenance {
	if x != nil {
		return x.SourceProvenance
	}
	return nil
}

func (x *BuildConfig) GetWorkerPool() string {
	if x != nil {
		return x.WorkerPool
	}
	return ""
}

func (x *BuildConfig) GetEnvironmentVariables() map[string]string {
	if x != nil {
		return x.EnvironmentVariables
	}
	return nil
}

func (x *BuildConfig) GetDockerRegistry() BuildConfig_DockerRegistry {
	if x != nil {
		return x.DockerRegistry
	}
	return BuildConfig_DOCKER_REGISTRY_UNSPECIFIED
}

func (x *BuildConfig) GetDockerRepository() string {
	if x != nil {
		return x.DockerRepository
	}
	return ""
}

// Describes the Service being deployed.
// Currently Supported : Cloud Run (fully managed).
type ServiceConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Name of the service associated with a Function.
	// The format of this field is
	// `projects/{project}/locations/{region}/services/{service}`
	Service string `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
	// The function execution timeout. Execution is considered failed and
	// can be terminated if the function is not completed at the end of the
	// timeout period. Defaults to 60 seconds.
	TimeoutSeconds int32 `protobuf:"varint,2,opt,name=timeout_seconds,json=timeoutSeconds,proto3" json:"timeout_seconds,omitempty"`
	// The amount of memory available for a function.
	// Defaults to 256M. Supported units are k, M, G, Mi, Gi. If no unit is
	// supplied the value is interpreted as bytes.
	// See
	// https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
	// a full description.
	AvailableMemory string `protobuf:"bytes,13,opt,name=available_memory,json=availableMemory,proto3" json:"available_memory,omitempty"`
	// [Preview] The number of CPUs used in a single container instance.
	// Default value is calculated from available memory.
	// Supports the same values as Cloud Run, see
	// https://cloud.google.com/run/docs/reference/rest/v1/Container#resourcerequirements
	// Example: "1" indicates 1 vCPU
	AvailableCpu string `protobuf:"bytes,22,opt,name=available_cpu,json=availableCpu,proto3" json:"available_cpu,omitempty"`
	// Environment variables that shall be available during function execution.
	EnvironmentVariables map[string]string `protobuf:"bytes,4,rep,name=environment_variables,json=environmentVariables,proto3" json:"environment_variables,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The limit on the maximum number of function instances that may coexist at a
	// given time.
	//
	// In some cases, such as rapid traffic surges, Cloud Functions may, for a
	// short period of time, create more instances than the specified max
	// instances limit. If your function cannot tolerate this temporary behavior,
	// you may want to factor in a safety margin and set a lower max instances
	// value than your function can tolerate.
	//
	// See the [Max
	// Instances](https://cloud.google.com/functions/docs/max-instances) Guide for
	// more details.
	MaxInstanceCount int32 `protobuf:"varint,5,opt,name=max_instance_count,json=maxInstanceCount,proto3" json:"max_instance_count,omitempty"`
	// The limit on the minimum number of function instances that may coexist at a
	// given time.
	//
	// Function instances are kept in idle state for a short period after they
	// finished executing the request to reduce cold start time for subsequent
	// requests. Setting a minimum instance count will ensure that the given
	// number of instances are kept running in idle state always. This can help
	// with cold start times when jump in incoming request count occurs after the
	// idle instance would have been stopped in the default case.
	MinInstanceCount int32 `protobuf:"varint,12,opt,name=min_instance_count,json=minInstanceCount,proto3" json:"min_instance_count,omitempty"`
	// The Serverless VPC Access connector that this cloud function can connect
	// to. The format of this field is `projects/*/locations/*/connectors/*`.
	VpcConnector string `protobuf:"bytes,6,opt,name=vpc_connector,json=vpcConnector,proto3" json:"vpc_connector,omitempty"`
	// The egress settings for the connector, controlling what traffic is diverted
	// through it.
	VpcConnectorEgressSettings ServiceConfig_VpcConnectorEgressSettings `protobuf:"varint,7,opt,name=vpc_connector_egress_settings,json=vpcConnectorEgressSettings,proto3,enum=google.cloud.functions.v2.ServiceConfig_VpcConnectorEgressSettings" json:"vpc_connector_egress_settings,omitempty"`
	// The ingress settings for the function, controlling what traffic can reach
	// it.
	IngressSettings ServiceConfig_IngressSettings `protobuf:"varint,8,opt,name=ingress_settings,json=ingressSettings,proto3,enum=google.cloud.functions.v2.ServiceConfig_IngressSettings" json:"ingress_settings,omitempty"`
	// Output only. URI of the Service deployed.
	Uri string `protobuf:"bytes,9,opt,name=uri,proto3" json:"uri,omitempty"`
	// The email of the service's service account. If empty, defaults to
	// `{project_number}-compute@developer.gserviceaccount.com`.
	ServiceAccountEmail string `protobuf:"bytes,10,opt,name=service_account_email,json=serviceAccountEmail,proto3" json:"service_account_email,omitempty"`
	// Whether 100% of traffic is routed to the latest revision.
	// On CreateFunction and UpdateFunction, when set to true, the revision being
	// deployed will serve 100% of traffic, ignoring any traffic split settings,
	// if any. On GetFunction, true will be returned if the latest revision is
	// serving 100% of traffic.
	AllTrafficOnLatestRevision bool `protobuf:"varint,16,opt,name=all_traffic_on_latest_revision,json=allTrafficOnLatestRevision,proto3" json:"all_traffic_on_latest_revision,omitempty"`
	// Secret environment variables configuration.
	SecretEnvironmentVariables []*SecretEnvVar `protobuf:"bytes,17,rep,name=secret_environment_variables,json=secretEnvironmentVariables,proto3" json:"secret_environment_variables,omitempty"`
	// Secret volumes configuration.
	SecretVolumes []*SecretVolume `protobuf:"bytes,19,rep,name=secret_volumes,json=secretVolumes,proto3" json:"secret_volumes,omitempty"`
	// Output only. The name of service revision.
	Revision string `protobuf:"bytes,18,opt,name=revision,proto3" json:"revision,omitempty"`
	// [Preview] Sets the maximum number of concurrent requests that each instance
	// can receive. Defaults to 1.
	MaxInstanceRequestConcurrency int32 `protobuf:"varint,20,opt,name=max_instance_request_concurrency,json=maxInstanceRequestConcurrency,proto3" json:"max_instance_request_concurrency,omitempty"`
	// Security level configure whether the function only accepts https.
	// This configuration is only applicable to 1st Gen functions with Http
	// trigger. By default https is optional for 1st Gen functions; 2nd Gen
	// functions are https ONLY.
	SecurityLevel ServiceConfig_SecurityLevel `protobuf:"varint,21,opt,name=security_level,json=securityLevel,proto3,enum=google.cloud.functions.v2.ServiceConfig_SecurityLevel" json:"security_level,omitempty"`
}

func (x *ServiceConfig) Reset() {
	*x = ServiceConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServiceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceConfig) ProtoMessage() {}

func (x *ServiceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceConfig.ProtoReflect.Descriptor instead.
func (*ServiceConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v2_functions_proto_rawDescGZIP(), []int{7}
}

func (x *ServiceConfig) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

func (x *ServiceConfig) GetTimeoutSeconds() int32 {
	if x != nil {
		return x.TimeoutSeconds
	}
	return 0
}

func (x *ServiceConfig) GetAvailableMemory() string {
	if x != nil {
		return x.AvailableMemory
	}
	return ""
}

func (x *ServiceConfig) GetAvailableCpu() string {
	if x != nil {
		return x.AvailableCpu
	}
	return ""
}

func (x *ServiceConfig) GetEnvironmentVariables() map[string]string {
	if x != nil {
		return x.EnvironmentVariables
	}
	return nil
}

func (x *ServiceConfig) GetMaxInstanceCount() int32 {
	if x != nil {
		return x.MaxInstanceCount
	}
	return 0
}

func (x *ServiceConfig) GetMinInstanceCount() int32 {
	if x != nil {
		return x.MinInstanceCount
	}
	return 0
}

func (x *ServiceConfig) GetVpcConnector() string {
	if x != nil {
		return x.VpcConnector
	}
	return ""
}

func (x *ServiceConfig) GetVpcConnectorEgressSettings() ServiceConfig_VpcConnectorEgressSettings {
	if x != nil {
		return x.VpcConnectorEgressSettings
	}
	return ServiceConfig_VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED
}

func (x *ServiceConfig) GetIngressSettings() ServiceConfig_IngressSettings {
	if x != nil {
		return x.IngressSettings
	}
	return ServiceConfig_INGRESS_SETTINGS_UNSPECIFIED
}

func (x *ServiceConfig) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *ServiceConfig) GetServiceAccountEmail() string {
	if x != nil {
		return x.ServiceAccountEmail
	}
	return ""
}

func (x *ServiceConfig) GetAllTrafficOnLatestRevision() bool {
	if x != nil {
		return x.AllTrafficOnLatestRevision
	}
	return false
}

func (x *ServiceConfig) GetSecretEnvironmentVariables() []*SecretEnvVar {
	if x != nil {
		return x.SecretEnvironmentVariables
	}
	return nil
}

func (x *ServiceConfig) GetSecretVolumes() []*SecretVolume {
	if x != nil {
		return x.SecretVolumes
	}
	return nil
}

func (x *ServiceConfig) GetRevision() string {
	if x != nil {
		return x.Revision
	}
	return ""
}

func (x *ServiceConfig) GetMaxInstanceRequestConcurrency() int32 {
	if x != nil {
		return x.MaxInstanceRequestConcurrency
	}
	return 0
}

func (x *ServiceConfig) GetSecurityLevel() ServiceConfig_SecurityLevel {
	if x != nil {
		return x.SecurityLevel
	}
	return ServiceConfig_SECURITY_LEVEL_UNSPECIFIED
}

// Configuration for a secret environment variable. It has the information
// necessary to fetch the secret value from secret manager and expose it as an
// environment variable.
type SecretEnvVar struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the environment variable.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Project identifier (preferably project number but can also be the
	// project ID) of the project that contains the secret. If not set, it is
	// assumed that the secret is in the same project as the function.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Name of the secret in secret manager (not the full resource name).
	Secret string `protobuf:"bytes,3,opt,name=secret,proto3" json:"secret,omitempty"`
	// Version of the secret (version number or the string 'latest'). It is
	// recommended to use a numeric version for secret environment variables as
	// any updates to the secret value is not reflected until new instances
	// start.
	Version string `protobuf:"bytes,4,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *SecretEnvVar) Reset() {
	*x = SecretEnvVar{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SecretEnvVar) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecretEnvVar) ProtoMessage() {}

func (x *SecretEnvVar) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecretEnvVar.ProtoReflect.Descriptor instead.
func (*SecretEnvVar) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v2_functions_proto_rawDescGZIP(), []int{8}
}

func (x *SecretEnvVar) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *SecretEnvVar) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *SecretEnvVar) GetSecret() string {
	if x != nil {
		return x.Secret
	}
	return ""
}

func (x *SecretEnvVar) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

// Configuration for a secret volume. It has the information necessary to fetch
// the secret value from secret manager and make it available as files mounted
// at the requested paths within the application container.
type SecretVolume struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The path within the container to mount the secret volume. For example,
	// setting the mount_path as `/etc/secrets` would mount the secret value files
	// under the `/etc/secrets` directory. This directory will also be completely
	// shadowed and unavailable to mount any other secrets.
	// Recommended mount path: /etc/secrets
	MountPath string `protobuf:"bytes,1,opt,name=mount_path,json=mountPath,proto3" json:"mount_path,omitempty"`
	// Project identifier (preferably project number but can also be the project
	// ID) of the project that contains the secret. If not set, it is
	// assumed that the secret is in the same project as the function.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Name of the secret in secret manager (not the full resource name).
	Secret string `protobuf:"bytes,3,opt,name=secret,proto3" json:"secret,omitempty"`
	// List of secret versions to mount for this secret. If empty, the `latest`
	// version of the secret will be made available in a file named after the
	// secret under the mount point.
	Versions []*SecretVolume_SecretVersion `protobuf:"bytes,4,rep,name=versions,proto3" json:"versions,omitempty"`
}

func (x *SecretVolume) Reset() {
	*x = SecretVolume{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SecretVolume) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecretVolume) ProtoMessage() {}

func (x *SecretVolume) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecretVolume.ProtoReflect.Descriptor instead.
func (*SecretVolume) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v2_functions_proto_rawDescGZIP(), []int{9}
}

func (x *SecretVolume) GetMountPath() string {
	if x != nil {
		return x.MountPath
	}
	return ""
}

func (x *SecretVolume) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *SecretVolume) GetSecret() string {
	if x != nil {
		return x.Secret
	}
	return ""
}

func (x *SecretVolume) GetVersions() []*SecretVolume_SecretVersion {
	if x != nil {
		return x.Versions
	}
	return nil
}

// Describes EventTrigger, used to request events to be sent from another
// service.
type EventTrigger struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the Eventarc trigger. The format of this
	// field is `projects/{project}/locations/{region}/triggers/{trigger}`.
	Trigger string `protobuf:"bytes,1,opt,name=trigger,proto3" json:"trigger,omitempty"`
	// The region that the trigger will be in. The trigger will only receive
	// events originating in this region. It can be the same
	// region as the function, a different region or multi-region, or the global
	// region. If not provided, defaults to the same region as the function.
	TriggerRegion string `protobuf:"bytes,2,opt,name=trigger_region,json=triggerRegion,proto3" json:"trigger_region,omitempty"`
	// Required. The type of event to observe. For example:
	// `google.cloud.audit.log.v1.written` or
	// `google.cloud.pubsub.topic.v1.messagePublished`.
	EventType string `protobuf:"bytes,3,opt,name=event_type,json=eventType,proto3" json:"event_type,omitempty"`
	// Criteria used to filter events.
	EventFilters []*EventFilter `protobuf:"bytes,4,rep,name=event_filters,json=eventFilters,proto3" json:"event_filters,omitempty"`
	// Optional. The name of a Pub/Sub topic in the same project that will be used
	// as the transport topic for the event delivery. Format:
	// `projects/{project}/topics/{topic}`.
	//
	// This is only valid for events of type
	// `google.cloud.pubsub.topic.v1.messagePublished`. The topic provided here
	// will not be deleted at function deletion.
	PubsubTopic string `protobuf:"bytes,5,opt,name=pubsub_topic,json=pubsubTopic,proto3" json:"pubsub_topic,omitempty"`
	// Optional. The email of the trigger's service account. The service account
	// must have permission to invoke Cloud Run services, the permission is
	// `run.routes.invoke`.
	// If empty, defaults to the Compute Engine default service account:
	// `{project_number}-compute@developer.gserviceaccount.com`.
	ServiceAccountEmail string `protobuf:"bytes,6,opt,name=service_account_email,json=serviceAccountEmail,proto3" json:"service_account_email,omitempty"`
	// Optional. If unset, then defaults to ignoring failures (i.e. not retrying
	// them).
	RetryPolicy EventTrigger_RetryPolicy `protobuf:"varint,7,opt,name=retry_policy,json=retryPolicy,proto3,enum=google.cloud.functions.v2.EventTrigger_RetryPolicy" json:"retry_policy,omitempty"`
	// Optional. The name of the channel associated with the trigger in
	// `projects/{project}/locations/{location}/channels/{channel}` format.
	// You must provide a channel to receive events from Eventarc SaaS partners.
	Channel string `protobuf:"bytes,8,opt,name=channel,proto3" json:"channel,omitempty"`
}

func (x *EventTrigger) Reset() {
	*x = EventTrigger{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EventTrigger) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EventTrigger) ProtoMessage() {}

func (x *EventTrigger) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EventTrigger.ProtoReflect.Descriptor instead.
func (*EventTrigger) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v2_functions_proto_rawDescGZIP(), []int{10}
}

func (x *EventTrigger) GetTrigger() string {
	if x != nil {
		return x.Trigger
	}
	return ""
}

func (x *EventTrigger) GetTriggerRegion() string {
	if x != nil {
		return x.TriggerRegion
	}
	return ""
}

func (x *EventTrigger) GetEventType() string {
	if x != nil {
		return x.EventType
	}
	return ""
}

func (x *EventTrigger) GetEventFilters() []*EventFilter {
	if x != nil {
		return x.EventFilters
	}
	return nil
}

func (x *EventTrigger) GetPubsubTopic() string {
	if x != nil {
		return x.PubsubTopic
	}
	return ""
}

func (x *EventTrigger) GetServiceAccountEmail() string {
	if x != nil {
		return x.ServiceAccountEmail
	}
	return ""
}

func (x *EventTrigger) GetRetryPolicy() EventTrigger_RetryPolicy {
	if x != nil {
		return x.RetryPolicy
	}
	return EventTrigger_RETRY_POLICY_UNSPECIFIED
}

func (x *EventTrigger) GetChannel() string {
	if x != nil {
		return x.Channel
	}
	return ""
}

// Filters events based on exact matches on the CloudEvents attributes.
type EventFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of a CloudEvents attribute.
	Attribute string `protobuf:"bytes,1,opt,name=attribute,proto3" json:"attribute,omitempty"`
	// Required. The value for the attribute.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	// Optional. The operator used for matching the events with the value of the
	// filter. If not specified, only events that have an exact key-value pair
	// specified in the filter are matched. The only allowed value is
	// `match-path-pattern`.
	Operator string `protobuf:"bytes,3,opt,name=operator,proto3" json:"operator,omitempty"`
}

func (x *EventFilter) Reset() {
	*x = EventFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EventFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EventFilter) ProtoMessage() {}

func (x *EventFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EventFilter.ProtoReflect.Descriptor instead.
func (*EventFilter) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v2_functions_proto_rawDescGZIP(), []int{11}
}

func (x *EventFilter) GetAttribute() string {
	if x != nil {
		return x.Attribute
	}
	return ""
}

func (x *EventFilter) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

func (x *EventFilter) GetOperator() string {
	if x != nil {
		return x.Operator
	}
	return ""
}

// Request for the `GetFunction` method.
type GetFunctionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the function which details should be obtained.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetFunctionRequest) Reset() {
	*x = GetFunctionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetFunctionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFunctionRequest) ProtoMessage() {}

func (x *GetFunctionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFunctionRequest.ProtoReflect.Descriptor instead.
func (*GetFunctionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v2_functions_proto_rawDescGZIP(), []int{12}
}

func (x *GetFunctionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for the `ListFunctions` method.
type ListFunctionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project and location from which the function should be
	// listed, specified in the format `projects/*/locations/*` If you want to
	// list functions in all locations, use "-" in place of a location. When
	// listing functions in all locations, if one or more location(s) are
	// unreachable, the response will contain functions from all reachable
	// locations along with the names of any unreachable locations.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Maximum number of functions to return per call. The largest allowed
	// page_size is 1,000, if the page_size is omitted or specified as greater
	// than 1,000 then it will be replaced as 1,000. The size of the list
	// response can be less than specified when used with filters.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value returned by the last
	// `ListFunctionsResponse`; indicates that
	// this is a continuation of a prior `ListFunctions` call, and that the
	// system should return the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The filter for Functions that match the filter expression,
	// following the syntax outlined in https://google.aip.dev/160.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// The sorting order of the resources returned. Value should be a comma
	// separated list of fields. The default sorting oder is ascending.
	// See https://google.aip.dev/132#ordering.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListFunctionsRequest) Reset() {
	*x = ListFunctionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListFunctionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFunctionsRequest) ProtoMessage() {}

func (x *ListFunctionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFunctionsRequest.ProtoReflect.Descriptor instead.
func (*ListFunctionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v2_functions_proto_rawDescGZIP(), []int{13}
}

func (x *ListFunctionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListFunctionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListFunctionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListFunctionsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListFunctionsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response for the `ListFunctions` method.
type ListFunctionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The functions that match the request.
	Functions []*Function `protobuf:"bytes,1,rep,name=functions,proto3" json:"functions,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached. The response does not include any
	// functions from these locations.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListFunctionsResponse) Reset() {
	*x = ListFunctionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListFunctionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFunctionsResponse) ProtoMessage() {}

func (x *ListFunctionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFunctionsResponse.ProtoReflect.Descriptor instead.
func (*ListFunctionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v2_functions_proto_rawDescGZIP(), []int{14}
}

func (x *ListFunctionsResponse) GetFunctions() []*Function {
	if x != nil {
		return x.Functions
	}
	return nil
}

func (x *ListFunctionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListFunctionsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request for the `CreateFunction` method.
type CreateFunctionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project and location in which the function should be created,
	// specified in the format `projects/*/locations/*`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Function to be created.
	Function *Function `protobuf:"bytes,2,opt,name=function,proto3" json:"function,omitempty"`
	// The ID to use for the function, which will become the final component of
	// the function's resource name.
	//
	// This value should be 4-63 characters, and valid characters
	// are /[a-z][0-9]-/.
	FunctionId string `protobuf:"bytes,3,opt,name=function_id,json=functionId,proto3" json:"function_id,omitempty"`
}

func (x *CreateFunctionRequest) Reset() {
	*x = CreateFunctionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateFunctionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateFunctionRequest) ProtoMessage() {}

func (x *CreateFunctionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateFunctionRequest.ProtoReflect.Descriptor instead.
func (*CreateFunctionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v2_functions_proto_rawDescGZIP(), []int{15}
}

func (x *CreateFunctionRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateFunctionRequest) GetFunction() *Function {
	if x != nil {
		return x.Function
	}
	return nil
}

func (x *CreateFunctionRequest) GetFunctionId() string {
	if x != nil {
		return x.FunctionId
	}
	return ""
}

// Request for the `UpdateFunction` method.
type UpdateFunctionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. New version of the function.
	Function *Function `protobuf:"bytes,1,opt,name=function,proto3" json:"function,omitempty"`
	// The list of fields to be updated.
	// If no field mask is provided, all provided fields in the request will be
	// updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateFunctionRequest) Reset() {
	*x = UpdateFunctionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateFunctionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateFunctionRequest) ProtoMessage() {}

func (x *UpdateFunctionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateFunctionRequest.ProtoReflect.Descriptor instead.
func (*UpdateFunctionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v2_functions_proto_rawDescGZIP(), []int{16}
}

func (x *UpdateFunctionRequest) GetFunction() *Function {
	if x != nil {
		return x.Function
	}
	return nil
}

func (x *UpdateFunctionRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request for the `DeleteFunction` method.
type DeleteFunctionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the function which should be deleted.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteFunctionRequest) Reset() {
	*x = DeleteFunctionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteFunctionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteFunctionRequest) ProtoMessage() {}

func (x *DeleteFunctionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteFunctionRequest.ProtoReflect.Descriptor instead.
func (*DeleteFunctionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v2_functions_proto_rawDescGZIP(), []int{17}
}

func (x *DeleteFunctionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request of `GenerateSourceUploadUrl` method.
type GenerateUploadUrlRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project and location in which the Google Cloud Storage signed
	// URL should be generated, specified in the format `projects/*/locations/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// [Preview] Resource name of a KMS crypto key (managed by the user) used to
	// encrypt/decrypt function source code objects in intermediate Cloud Storage
	// buckets. When you generate an upload url and upload your source code, it
	// gets copied to an intermediate Cloud Storage bucket. The source code is
	// then copied to a versioned directory in the sources bucket in the consumer
	// project during the function deployment.
	//
	// It must match the pattern
	// `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
	//
	// The Google Cloud Functions service account
	// (service-{project_number}@gcf-admin-robot.iam.gserviceaccount.com) must be
	// granted the role 'Cloud KMS CryptoKey Encrypter/Decrypter
	// (roles/cloudkms.cryptoKeyEncrypterDecrypter)' on the
	// Key/KeyRing/Project/Organization (least access preferred).
	KmsKeyName string `protobuf:"bytes,2,opt,name=kms_key_name,json=kmsKeyName,proto3" json:"kms_key_name,omitempty"`
}

func (x *GenerateUploadUrlRequest) Reset() {
	*x = GenerateUploadUrlRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateUploadUrlRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateUploadUrlRequest) ProtoMessage() {}

func (x *GenerateUploadUrlRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateUploadUrlRequest.ProtoReflect.Descriptor instead.
func (*GenerateUploadUrlRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v2_functions_proto_rawDescGZIP(), []int{18}
}

func (x *GenerateUploadUrlRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *GenerateUploadUrlRequest) GetKmsKeyName() string {
	if x != nil {
		return x.KmsKeyName
	}
	return ""
}

// Response of `GenerateSourceUploadUrl` method.
type GenerateUploadUrlResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The generated Google Cloud Storage signed URL that should be used for a
	// function source code upload. The uploaded file should be a zip archive
	// which contains a function.
	UploadUrl string `protobuf:"bytes,1,opt,name=upload_url,json=uploadUrl,proto3" json:"upload_url,omitempty"`
	// The location of the source code in the upload bucket.
	//
	// Once the archive is uploaded using the `upload_url` use this field to
	// set the `function.build_config.source.storage_source`
	// during CreateFunction and UpdateFunction.
	//
	// Generation defaults to 0, as Cloud Storage provides a new generation only
	// upon uploading a new object or version of an object.
	StorageSource *StorageSource `protobuf:"bytes,2,opt,name=storage_source,json=storageSource,proto3" json:"storage_source,omitempty"`
}

func (x *GenerateUploadUrlResponse) Reset() {
	*x = GenerateUploadUrlResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateUploadUrlResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateUploadUrlResponse) ProtoMessage() {}

func (x *GenerateUploadUrlResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateUploadUrlResponse.ProtoReflect.Descriptor instead.
func (*GenerateUploadUrlResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v2_functions_proto_rawDescGZIP(), []int{19}
}

func (x *GenerateUploadUrlResponse) GetUploadUrl() string {
	if x != nil {
		return x.UploadUrl
	}
	return ""
}

func (x *GenerateUploadUrlResponse) GetStorageSource() *StorageSource {
	if x != nil {
		return x.StorageSource
	}
	return nil
}

// Request of `GenerateDownloadUrl` method.
type GenerateDownloadUrlRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of function for which source code Google Cloud Storage
	// signed URL should be generated.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GenerateDownloadUrlRequest) Reset() {
	*x = GenerateDownloadUrlRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateDownloadUrlRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateDownloadUrlRequest) ProtoMessage() {}

func (x *GenerateDownloadUrlRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateDownloadUrlRequest.ProtoReflect.Descriptor instead.
func (*GenerateDownloadUrlRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v2_functions_proto_rawDescGZIP(), []int{20}
}

func (x *GenerateDownloadUrlRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Response of `GenerateDownloadUrl` method.
type GenerateDownloadUrlResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The generated Google Cloud Storage signed URL that should be used for
	// function source code download.
	DownloadUrl string `protobuf:"bytes,1,opt,name=download_url,json=downloadUrl,proto3" json:"download_url,omitempty"`
}

func (x *GenerateDownloadUrlResponse) Reset() {
	*x = GenerateDownloadUrlResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateDownloadUrlResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateDownloadUrlResponse) ProtoMessage() {}

func (x *GenerateDownloadUrlResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateDownloadUrlResponse.ProtoReflect.Descriptor instead.
func (*GenerateDownloadUrlResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v2_functions_proto_rawDescGZIP(), []int{21}
}

func (x *GenerateDownloadUrlResponse) GetDownloadUrl() string {
	if x != nil {
		return x.DownloadUrl
	}
	return ""
}

// Request for the `ListRuntimes` method.
type ListRuntimesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project and location from which the runtimes should be
	// listed, specified in the format `projects/*/locations/*`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The filter for Runtimes that match the filter expression,
	// following the syntax outlined in https://google.aip.dev/160.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListRuntimesRequest) Reset() {
	*x = ListRuntimesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRuntimesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRuntimesRequest) ProtoMessage() {}

func (x *ListRuntimesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRuntimesRequest.ProtoReflect.Descriptor instead.
func (*ListRuntimesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v2_functions_proto_rawDescGZIP(), []int{22}
}

func (x *ListRuntimesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListRuntimesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Response for the `ListRuntimes` method.
type ListRuntimesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The runtimes that match the request.
	Runtimes []*ListRuntimesResponse_Runtime `protobuf:"bytes,1,rep,name=runtimes,proto3" json:"runtimes,omitempty"`
}

func (x *ListRuntimesResponse) Reset() {
	*x = ListRuntimesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRuntimesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRuntimesResponse) ProtoMessage() {}

func (x *ListRuntimesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRuntimesResponse.ProtoReflect.Descriptor instead.
func (*ListRuntimesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v2_functions_proto_rawDescGZIP(), []int{23}
}

func (x *ListRuntimesResponse) GetRuntimes() []*ListRuntimesResponse_Runtime {
	if x != nil {
		return x.Runtimes
	}
	return nil
}

// Represents the metadata of the long-running operation.
type OperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Server-defined resource path for the target of the operation.
	Target string `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Name of the verb executed by the operation.
	Verb string `protobuf:"bytes,4,opt,name=verb,proto3" json:"verb,omitempty"`
	// Human-readable status of the operation, if any.
	StatusDetail string `protobuf:"bytes,5,opt,name=status_detail,json=statusDetail,proto3" json:"status_detail,omitempty"`
	// Identifies whether the user has requested cancellation
	// of the operation. Operations that have successfully been cancelled
	// have [Operation.error][] value with a
	// [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to
	// `Code.CANCELLED`.
	CancelRequested bool `protobuf:"varint,6,opt,name=cancel_requested,json=cancelRequested,proto3" json:"cancel_requested,omitempty"`
	// API version used to start the operation.
	ApiVersion string `protobuf:"bytes,7,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
	// The original request that started the operation.
	RequestResource *anypb.Any `protobuf:"bytes,8,opt,name=request_resource,json=requestResource,proto3" json:"request_resource,omitempty"`
	// Mechanism for reporting in-progress stages
	Stages []*Stage `protobuf:"bytes,9,rep,name=stages,proto3" json:"stages,omitempty"`
}

func (x *OperationMetadata) Reset() {
	*x = OperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationMetadata) ProtoMessage() {}

func (x *OperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationMetadata.ProtoReflect.Descriptor instead.
func (*OperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v2_functions_proto_rawDescGZIP(), []int{24}
}

func (x *OperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *OperationMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *OperationMetadata) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

func (x *OperationMetadata) GetVerb() string {
	if x != nil {
		return x.Verb
	}
	return ""
}

func (x *OperationMetadata) GetStatusDetail() string {
	if x != nil {
		return x.StatusDetail
	}
	return ""
}

func (x *OperationMetadata) GetCancelRequested() bool {
	if x != nil {
		return x.CancelRequested
	}
	return false
}

func (x *OperationMetadata) GetApiVersion() string {
	if x != nil {
		return x.ApiVersion
	}
	return ""
}

func (x *OperationMetadata) GetRequestResource() *anypb.Any {
	if x != nil {
		return x.RequestResource
	}
	return nil
}

func (x *OperationMetadata) GetStages() []*Stage {
	if x != nil {
		return x.Stages
	}
	return nil
}

// Extra GCF specific location information.
type LocationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Cloud Function environments this location supports.
	Environments []Environment `protobuf:"varint,1,rep,packed,name=environments,proto3,enum=google.cloud.functions.v2.Environment" json:"environments,omitempty"`
}

func (x *LocationMetadata) Reset() {
	*x = LocationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LocationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LocationMetadata) ProtoMessage() {}

func (x *LocationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LocationMetadata.ProtoReflect.Descriptor instead.
func (*LocationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v2_functions_proto_rawDescGZIP(), []int{25}
}

func (x *LocationMetadata) GetEnvironments() []Environment {
	if x != nil {
		return x.Environments
	}
	return nil
}

// Each Stage of the deployment process
type Stage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the Stage. This will be unique for each Stage.
	Name Stage_Name `protobuf:"varint,1,opt,name=name,proto3,enum=google.cloud.functions.v2.Stage_Name" json:"name,omitempty"`
	// Message describing the Stage
	Message string `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	// Current state of the Stage
	State Stage_State `protobuf:"varint,3,opt,name=state,proto3,enum=google.cloud.functions.v2.Stage_State" json:"state,omitempty"`
	// Resource of the Stage
	Resource string `protobuf:"bytes,4,opt,name=resource,proto3" json:"resource,omitempty"`
	// Link to the current Stage resource
	ResourceUri string `protobuf:"bytes,5,opt,name=resource_uri,json=resourceUri,proto3" json:"resource_uri,omitempty"`
	// State messages from the current Stage.
	StateMessages []*StateMessage `protobuf:"bytes,6,rep,name=state_messages,json=stateMessages,proto3" json:"state_messages,omitempty"`
}

func (x *Stage) Reset() {
	*x = Stage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Stage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Stage) ProtoMessage() {}

func (x *Stage) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Stage.ProtoReflect.Descriptor instead.
func (*Stage) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v2_functions_proto_rawDescGZIP(), []int{26}
}

func (x *Stage) GetName() Stage_Name {
	if x != nil {
		return x.Name
	}
	return Stage_NAME_UNSPECIFIED
}

func (x *Stage) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *Stage) GetState() Stage_State {
	if x != nil {
		return x.State
	}
	return Stage_STATE_UNSPECIFIED
}

func (x *Stage) GetResource() string {
	if x != nil {
		return x.Resource
	}
	return ""
}

func (x *Stage) GetResourceUri() string {
	if x != nil {
		return x.ResourceUri
	}
	return ""
}

func (x *Stage) GetStateMessages() []*StateMessage {
	if x != nil {
		return x.StateMessages
	}
	return nil
}

// Configuration for a single version.
type SecretVolume_SecretVersion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Version of the secret (version number or the string 'latest'). It is
	// preferable to use `latest` version with secret volumes as secret value
	// changes are reflected immediately.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// Relative path of the file under the mount path where the secret value for
	// this version will be fetched and made available. For example, setting the
	// mount_path as '/etc/secrets' and path as `secret_foo` would mount the
	// secret value file at `/etc/secrets/secret_foo`.
	Path string `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
}

func (x *SecretVolume_SecretVersion) Reset() {
	*x = SecretVolume_SecretVersion{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SecretVolume_SecretVersion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecretVolume_SecretVersion) ProtoMessage() {}

func (x *SecretVolume_SecretVersion) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecretVolume_SecretVersion.ProtoReflect.Descriptor instead.
func (*SecretVolume_SecretVersion) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v2_functions_proto_rawDescGZIP(), []int{9, 0}
}

func (x *SecretVolume_SecretVersion) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *SecretVolume_SecretVersion) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

// Describes a runtime and any special information (e.g., deprecation status)
// related to it.
type ListRuntimesResponse_Runtime struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the runtime, e.g., 'go113', 'nodejs12', etc.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The user facing name, eg 'Go 1.13', 'Node.js 12', etc.
	DisplayName string `protobuf:"bytes,5,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The stage of life this runtime is in, e.g., BETA, GA, etc.
	Stage ListRuntimesResponse_RuntimeStage `protobuf:"varint,2,opt,name=stage,proto3,enum=google.cloud.functions.v2.ListRuntimesResponse_RuntimeStage" json:"stage,omitempty"`
	// Warning messages, e.g., a deprecation warning.
	Warnings []string `protobuf:"bytes,3,rep,name=warnings,proto3" json:"warnings,omitempty"`
	// The environment for the runtime.
	Environment Environment `protobuf:"varint,4,opt,name=environment,proto3,enum=google.cloud.functions.v2.Environment" json:"environment,omitempty"`
}

func (x *ListRuntimesResponse_Runtime) Reset() {
	*x = ListRuntimesResponse_Runtime{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRuntimesResponse_Runtime) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRuntimesResponse_Runtime) ProtoMessage() {}

func (x *ListRuntimesResponse_Runtime) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v2_functions_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRuntimesResponse_Runtime.ProtoReflect.Descriptor instead.
func (*ListRuntimesResponse_Runtime) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v2_functions_proto_rawDescGZIP(), []int{23, 0}
}

func (x *ListRuntimesResponse_Runtime) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ListRuntimesResponse_Runtime) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *ListRuntimesResponse_Runtime) GetStage() ListRuntimesResponse_RuntimeStage {
	if x != nil {
		return x.Stage
	}
	return ListRuntimesResponse_RUNTIME_STAGE_UNSPECIFIED
}

func (x *ListRuntimesResponse_Runtime) GetWarnings() []string {
	if x != nil {
		return x.Warnings
	}
	return nil
}

func (x *ListRuntimesResponse_Runtime) GetEnvironment() Environment {
	if x != nil {
		return x.Environment
	}
	return Environment_ENVIRONMENT_UNSPECIFIED
}

var File_google_cloud_functions_v2_functions_proto protoreflect.FileDescriptor

var file_google_cloud_functions_v2_functions_proto_rawDesc = []byte{
	0x0a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x66,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x66, 0x75, 0x6e, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x32, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x61, 0x6e, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x98, 0x08, 0x0a, 0x08, 0x46, 0x75,
	0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x49, 0x0a, 0x0c,
	0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x42,
	0x75, 0x69, 0x6c, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0b, 0x62, 0x75, 0x69, 0x6c,
	0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4f, 0x0a, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0d, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4c, 0x0a, 0x0d, 0x65, 0x76, 0x65, 0x6e,
	0x74, 0x5f, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x52, 0x0c, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54,
	0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x12, 0x44, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76,
	0x32, 0x2e, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x40, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x47,
	0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75,
	0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x75, 0x6e, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x53, 0x0a, 0x0e, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x12, 0x48, 0x0a, 0x0b,
	0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x45, 0x6e,
	0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72,
	0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x0e, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x12, 0x48, 0x0a,
	0x0c, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x19, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x26, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b,
	0x6d, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x52, 0x0a, 0x6b, 0x6d, 0x73,
	0x4b, 0x65, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x22, 0x60, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53,
	0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x0a,
	0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x44, 0x45,
	0x50, 0x4c, 0x4f, 0x59, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c,
	0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f,
	0x57, 0x4e, 0x10, 0x05, 0x3a, 0x7e, 0xea, 0x41, 0x7b, 0x0a, 0x26, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x3c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x66, 0x75, 0x6e, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2a,
	0x09, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x32, 0x08, 0x66, 0x75, 0x6e, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0xd2, 0x01, 0x0a, 0x0c, 0x53, 0x74, 0x61, 0x74, 0x65, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x4c, 0x0a, 0x08, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x2e, 0x53, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x52, 0x08, 0x73, 0x65, 0x76, 0x65, 0x72,
	0x69, 0x74, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x22, 0x46, 0x0a, 0x08, 0x53, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x12, 0x18, 0x0a,
	0x14, 0x53, 0x45, 0x56, 0x45, 0x52, 0x49, 0x54, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f, 0x52,
	0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x57, 0x41, 0x52, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12,
	0x08, 0x0a, 0x04, 0x49, 0x4e, 0x46, 0x4f, 0x10, 0x03, 0x22, 0x5f, 0x0a, 0x0d, 0x53, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x62, 0x75,
	0x63, 0x6b, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x62, 0x75, 0x63, 0x6b,
	0x65, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x1e, 0x0a, 0x0a, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a,
	0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xea, 0x01, 0x0a, 0x0a, 0x52,
	0x65, 0x70, 0x6f, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x21, 0x0a, 0x0b, 0x62, 0x72, 0x61,
	0x6e, 0x63, 0x68, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00,
	0x52, 0x0a, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x08,
	0x74, 0x61, 0x67, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00,
	0x52, 0x07, 0x74, 0x61, 0x67, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0a, 0x63, 0x6f, 0x6d,
	0x6d, 0x69, 0x74, 0x5f, 0x73, 0x68, 0x61, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52,
	0x09, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x53, 0x68, 0x61, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x72, 0x65, 0x70,
	0x6f, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x72, 0x65,
	0x70, 0x6f, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x64, 0x69, 0x72, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x64, 0x69, 0x72, 0x12, 0x21, 0x0a, 0x0c, 0x69, 0x6e, 0x76, 0x65,
	0x72, 0x74, 0x5f, 0x72, 0x65, 0x67, 0x65, 0x78, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b,
	0x69, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x52, 0x65, 0x67, 0x65, 0x78, 0x42, 0x0a, 0x0a, 0x08, 0x72,
	0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xaf, 0x01, 0x0a, 0x06, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x12, 0x51, 0x0a, 0x0e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x0d, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x48, 0x0a, 0x0b, 0x72, 0x65, 0x70, 0x6f, 0x5f, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x48, 0x00, 0x52, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42,
	0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0xcd, 0x01, 0x0a, 0x10, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x60,
	0x0a, 0x17, 0x72, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x64, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x15, 0x72, 0x65, 0x73, 0x6f, 0x6c,
	0x76, 0x65, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x12, 0x57, 0x0a, 0x14, 0x72, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x70,
	0x6f, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75,
	0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x12, 0x72, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x64, 0x52,
	0x65, 0x70, 0x6f, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0xcd, 0x06, 0x0a, 0x0b, 0x42, 0x75,
	0x69, 0x6c, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3d, 0x0a, 0x05, 0x62, 0x75, 0x69,
	0x6c, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x21,
	0x0a, 0x1f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x75, 0x69, 0x6c,
	0x64, 0x52, 0x05, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x12, 0x18, 0x0a, 0x07, 0x72, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x50, 0x6f,
	0x69, 0x6e, 0x74, 0x12, 0x39, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x32, 0x2e,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x5d,
	0x0a, 0x11, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61,
	0x6e, 0x63, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x76,
	0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x4a, 0x0a,
	0x0b, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x29, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75,
	0x69, 0x6c, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x0a, 0x77,
	0x6f, 0x72, 0x6b, 0x65, 0x72, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x75, 0x0a, 0x15, 0x65, 0x6e, 0x76,
	0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x76, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c,
	0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x56, 0x61, 0x72, 0x69,
	0x61, 0x62, 0x6c, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x14, 0x65, 0x6e, 0x76, 0x69,
	0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73,
	0x12, 0x5e, 0x0a, 0x0f, 0x64, 0x6f, 0x63, 0x6b, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x44, 0x6f, 0x63, 0x6b, 0x65, 0x72, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x52, 0x0e, 0x64, 0x6f, 0x63, 0x6b, 0x65, 0x72, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x12, 0x5c, 0x0a, 0x11, 0x64, 0x6f, 0x63, 0x6b, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xfa, 0x41, 0x2c,
	0x0a, 0x2a, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x10, 0x64, 0x6f,
	0x63, 0x6b, 0x65, 0x72, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x1a, 0x47,
	0x0a, 0x19, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x56, 0x61, 0x72,
	0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x60, 0x0a, 0x0e, 0x44, 0x6f, 0x63, 0x6b, 0x65,
	0x72, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x12, 0x1f, 0x0a, 0x1b, 0x44, 0x4f, 0x43,
	0x4b, 0x45, 0x52, 0x5f, 0x52, 0x45, 0x47, 0x49, 0x53, 0x54, 0x52, 0x59, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x16, 0x0a, 0x12, 0x43, 0x4f,
	0x4e, 0x54, 0x41, 0x49, 0x4e, 0x45, 0x52, 0x5f, 0x52, 0x45, 0x47, 0x49, 0x53, 0x54, 0x52, 0x59,
	0x10, 0x01, 0x12, 0x15, 0x0a, 0x11, 0x41, 0x52, 0x54, 0x49, 0x46, 0x41, 0x43, 0x54, 0x5f, 0x52,
	0x45, 0x47, 0x49, 0x53, 0x54, 0x52, 0x59, 0x10, 0x02, 0x22, 0xfd, 0x0c, 0x0a, 0x0d, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3c, 0x0a, 0x07, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x22, 0xe0, 0x41,
	0x03, 0xfa, 0x41, 0x1c, 0x0a, 0x1a, 0x72, 0x75, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x52, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x74, 0x69, 0x6d,
	0x65, 0x6f, 0x75, 0x74, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x0e, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x53, 0x65, 0x63, 0x6f, 0x6e,
	0x64, 0x73, 0x12, 0x29, 0x0a, 0x10, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x5f,
	0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x61, 0x76,
	0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x12, 0x23, 0x0a,
	0x0d, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x70, 0x75, 0x18, 0x16,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x43,
	0x70, 0x75, 0x12, 0x77, 0x0a, 0x15, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e,
	0x74, 0x5f, 0x76, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x45, 0x6e, 0x76, 0x69,
	0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x14, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x12, 0x2c, 0x0a, 0x12, 0x6d,
	0x61, 0x78, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x10, 0x6d, 0x61, 0x78, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2c, 0x0a, 0x12, 0x6d, 0x69, 0x6e,
	0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x0c, 0x20, 0x01, 0x28, 0x05, 0x52, 0x10, 0x6d, 0x69, 0x6e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x4c, 0x0a, 0x0d, 0x76, 0x70, 0x63, 0x5f, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27,
	0xfa, 0x41, 0x24, 0x0a, 0x22, 0x76, 0x70, 0x63, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x0c, 0x76, 0x70, 0x63, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x86, 0x01, 0x0a, 0x1d, 0x76, 0x70, 0x63, 0x5f, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x5f, 0x65, 0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x73,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x43, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x56, 0x70, 0x63, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x52, 0x1a, 0x76, 0x70, 0x63, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x63,
	0x0a, 0x10, 0x69, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x49, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x52, 0x0f, 0x69, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x32, 0x0a, 0x15, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x65, 0x6d,
	0x61, 0x69, 0x6c, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x12, 0x42,
	0x0a, 0x1e, 0x61, 0x6c, 0x6c, 0x5f, 0x74, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x5f, 0x6f, 0x6e,
	0x5f, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x10, 0x20, 0x01, 0x28, 0x08, 0x52, 0x1a, 0x61, 0x6c, 0x6c, 0x54, 0x72, 0x61, 0x66, 0x66,
	0x69, 0x63, 0x4f, 0x6e, 0x4c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x69, 0x0a, 0x1c, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x5f, 0x65, 0x6e, 0x76,
	0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x76, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c,
	0x65, 0x73, 0x18, 0x11, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x45, 0x6e, 0x76, 0x56, 0x61,
	0x72, 0x52, 0x1a, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e,
	0x6d, 0x65, 0x6e, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x12, 0x4e, 0x0a,
	0x0e, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x5f, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73, 0x18,
	0x13, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76,
	0x32, 0x2e, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52, 0x0d,
	0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73, 0x12, 0x1f, 0x0a,
	0x08, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x12, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x47,
	0x0a, 0x20, 0x6d, 0x61, 0x78, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x63, 0x79, 0x18, 0x14, 0x20, 0x01, 0x28, 0x05, 0x52, 0x1d, 0x6d, 0x61, 0x78, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x63,
	0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x5d, 0x0a, 0x0e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x0d, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x1a, 0x47, 0x0a, 0x19, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f,
	0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22,
	0x75, 0x0a, 0x1a, 0x56, 0x70, 0x63, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x45,
	0x67, 0x72, 0x65, 0x73, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x2d, 0x0a,
	0x29, 0x56, 0x50, 0x43, 0x5f, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x4f, 0x52, 0x5f, 0x45,
	0x47, 0x52, 0x45, 0x53, 0x53, 0x5f, 0x53, 0x45, 0x54, 0x54, 0x49, 0x4e, 0x47, 0x53, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x17, 0x0a, 0x13,
	0x50, 0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x5f, 0x52, 0x41, 0x4e, 0x47, 0x45, 0x53, 0x5f, 0x4f,
	0x4e, 0x4c, 0x59, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x41, 0x4c, 0x4c, 0x5f, 0x54, 0x52, 0x41,
	0x46, 0x46, 0x49, 0x43, 0x10, 0x02, 0x22, 0x78, 0x0a, 0x0f, 0x49, 0x6e, 0x67, 0x72, 0x65, 0x73,
	0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x20, 0x0a, 0x1c, 0x49, 0x4e, 0x47,
	0x52, 0x45, 0x53, 0x53, 0x5f, 0x53, 0x45, 0x54, 0x54, 0x49, 0x4e, 0x47, 0x53, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x41,
	0x4c, 0x4c, 0x4f, 0x57, 0x5f, 0x41, 0x4c, 0x4c, 0x10, 0x01, 0x12, 0x17, 0x0a, 0x13, 0x41, 0x4c,
	0x4c, 0x4f, 0x57, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x5f, 0x4f, 0x4e, 0x4c,
	0x59, 0x10, 0x02, 0x12, 0x1b, 0x0a, 0x17, 0x41, 0x4c, 0x4c, 0x4f, 0x57, 0x5f, 0x49, 0x4e, 0x54,
	0x45, 0x52, 0x4e, 0x41, 0x4c, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x47, 0x43, 0x4c, 0x42, 0x10, 0x03,
	0x22, 0x57, 0x0a, 0x0d, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x4c, 0x65, 0x76, 0x65,
	0x6c, 0x12, 0x1e, 0x0a, 0x1a, 0x53, 0x45, 0x43, 0x55, 0x52, 0x49, 0x54, 0x59, 0x5f, 0x4c, 0x45,
	0x56, 0x45, 0x4c, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x11, 0x0a, 0x0d, 0x53, 0x45, 0x43, 0x55, 0x52, 0x45, 0x5f, 0x41, 0x4c, 0x57, 0x41,
	0x59, 0x53, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x53, 0x45, 0x43, 0x55, 0x52, 0x45, 0x5f, 0x4f,
	0x50, 0x54, 0x49, 0x4f, 0x4e, 0x41, 0x4c, 0x10, 0x02, 0x22, 0x71, 0x0a, 0x0c, 0x53, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x45, 0x6e, 0x76, 0x56, 0x61, 0x72, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x1d, 0x0a, 0x0a, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x65,
	0x63, 0x72, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xf6, 0x01, 0x0a,
	0x0c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x12, 0x1d, 0x0a,
	0x0a, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x50, 0x61, 0x74, 0x68, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x73,
	0x65, 0x63, 0x72, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x12, 0x51, 0x0a, 0x08, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76,
	0x32, 0x2e, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x2e, 0x53,
	0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x3d, 0x0a, 0x0d, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x70, 0x61, 0x74, 0x68, 0x22, 0xee, 0x04, 0x0a, 0x0c, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54,
	0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x12, 0x41, 0x0a, 0x07, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65,
	0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x21, 0x0a,
	0x1f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x63, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72,
	0x52, 0x07, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x12, 0x25, 0x0a, 0x0e, 0x74, 0x72, 0x69,
	0x67, 0x67, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e,
	0x12, 0x22, 0x0a, 0x0a, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x4b, 0x0a, 0x0d, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x52, 0x0c, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x73, 0x12, 0x46, 0x0a, 0x0c, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x5f, 0x74, 0x6f, 0x70, 0x69,
	0x63, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x23, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x1d, 0x0a,
	0x1b, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x52, 0x0b, 0x70, 0x75,
	0x62, 0x73, 0x75, 0x62, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x37, 0x0a, 0x15, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x65, 0x6d, 0x61,
	0x69, 0x6c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x45, 0x6d, 0x61,
	0x69, 0x6c, 0x12, 0x5b, 0x0a, 0x0c, 0x72, 0x65, 0x74, 0x72, 0x79, 0x5f, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x76, 0x32, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65,
	0x72, 0x2e, 0x52, 0x65, 0x74, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0b, 0x72, 0x65, 0x74, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12,
	0x41, 0x0a, 0x07, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x27, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x61,
	0x72, 0x63, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x07, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x22, 0x62, 0x0a, 0x0b, 0x52, 0x65, 0x74, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x12, 0x1c, 0x0a, 0x18, 0x52, 0x45, 0x54, 0x52, 0x59, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43,
	0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x1d, 0x0a, 0x19, 0x52, 0x45, 0x54, 0x52, 0x59, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f,
	0x44, 0x4f, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x52, 0x45, 0x54, 0x52, 0x59, 0x10, 0x01, 0x12, 0x16,
	0x0a, 0x12, 0x52, 0x45, 0x54, 0x52, 0x59, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x52,
	0x45, 0x54, 0x52, 0x59, 0x10, 0x02, 0x22, 0x6c, 0x0a, 0x0b, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x21, 0x0a, 0x09, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x61,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x12, 0x1f, 0x0a, 0x08, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x6f, 0x72, 0x22, 0x58, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x46, 0x75, 0x6e, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28,
	0x0a, 0x26, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xcd,
	0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x12,
	0x26, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xa4,
	0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x41, 0x0a, 0x09, 0x66, 0x75, 0x6e, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x09, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62,
	0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63,
	0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0xc1, 0x01, 0x0a, 0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x44, 0x0a, 0x08, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x32,
	0x2e, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08,
	0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x66, 0x75, 0x6e, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x66,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22, 0x9a, 0x01, 0x0a, 0x15, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x08, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76,
	0x32, 0x2e, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x08, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x5b, 0x0a, 0x15, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x66, 0x75, 0x6e, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0xa7, 0x01, 0x0a, 0x18, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65,
	0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x72, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x48, 0x0a, 0x0c, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xfa, 0x41, 0x23, 0x0a, 0x21,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65,
	0x79, 0x52, 0x0a, 0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x8b, 0x01,
	0x0a, 0x19, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64,
	0x55, 0x72, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x75,
	0x70, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x72, 0x6c, 0x12, 0x4f, 0x0a, 0x0e, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x53,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x0d, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x60, 0x0a, 0x1a, 0x47,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x55,
	0x72, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a,
	0x26, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x40, 0x0a,
	0x1b, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61,
	0x64, 0x55, 0x72, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x21, 0x0a, 0x0c,
	0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x72, 0x6c, 0x22,
	0x70, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x22, 0xe9, 0x03, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x53, 0x0a, 0x08, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x52, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x52, 0x08, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x1a,
	0xfa, 0x01, 0x0a, 0x07, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x52, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x53, 0x74, 0x61, 0x67, 0x65, 0x52,
	0x05, 0x73, 0x74, 0x61, 0x67, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x77, 0x61, 0x72, 0x6e, 0x69, 0x6e,
	0x67, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x77, 0x61, 0x72, 0x6e, 0x69, 0x6e,
	0x67, 0x73, 0x12, 0x48, 0x0a, 0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e,
	0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x76, 0x32, 0x2e, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x7f, 0x0a, 0x0c,
	0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x53, 0x74, 0x61, 0x67, 0x65, 0x12, 0x1d, 0x0a, 0x19,
	0x52, 0x55, 0x4e, 0x54, 0x49, 0x4d, 0x45, 0x5f, 0x53, 0x54, 0x41, 0x47, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x44,
	0x45, 0x56, 0x45, 0x4c, 0x4f, 0x50, 0x4d, 0x45, 0x4e, 0x54, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05,
	0x41, 0x4c, 0x50, 0x48, 0x41, 0x10, 0x02, 0x12, 0x08, 0x0a, 0x04, 0x42, 0x45, 0x54, 0x41, 0x10,
	0x03, 0x12, 0x06, 0x0a, 0x02, 0x47, 0x41, 0x10, 0x04, 0x12, 0x0e, 0x0a, 0x0a, 0x44, 0x45, 0x50,
	0x52, 0x45, 0x43, 0x41, 0x54, 0x45, 0x44, 0x10, 0x05, 0x12, 0x12, 0x0a, 0x0e, 0x44, 0x45, 0x43,
	0x4f, 0x4d, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x45, 0x44, 0x10, 0x06, 0x22, 0x9f, 0x03,
	0x0a, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07,
	0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12,
	0x12, 0x0a, 0x04, 0x76, 0x65, 0x72, 0x62, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x76,
	0x65, 0x72, 0x62, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x64, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x12, 0x29, 0x0a, 0x10, 0x63, 0x61, 0x6e, 0x63,
	0x65, 0x6c, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0f, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x65, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x61, 0x70, 0x69, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3f, 0x0a, 0x10, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x41, 0x6e, 0x79, 0x52, 0x0f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x38, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x67, 0x65, 0x73, 0x18,
	0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76,
	0x32, 0x2e, 0x53, 0x74, 0x61, 0x67, 0x65, 0x52, 0x06, 0x73, 0x74, 0x61, 0x67, 0x65, 0x73, 0x22,
	0x5e, 0x0a, 0x10, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x4a, 0x0a, 0x0c, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e,
	0x74, 0x52, 0x0c, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x22,
	0x80, 0x04, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x67, 0x65, 0x12, 0x39, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x61, 0x67, 0x65, 0x2e, 0x4e, 0x61, 0x6d, 0x65, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x3c,
	0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x26, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x61, 0x67, 0x65, 0x2e,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1a, 0x0a, 0x08,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55, 0x72, 0x69, 0x12, 0x4e, 0x0a, 0x0e, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x18, 0x06, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x32, 0x2e,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x0d, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x22, 0x84, 0x01, 0x0a, 0x04,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x4e, 0x41, 0x4d, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x41, 0x52,
	0x54, 0x49, 0x46, 0x41, 0x43, 0x54, 0x5f, 0x52, 0x45, 0x47, 0x49, 0x53, 0x54, 0x52, 0x59, 0x10,
	0x01, 0x12, 0x09, 0x0a, 0x05, 0x42, 0x55, 0x49, 0x4c, 0x44, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07,
	0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x10, 0x03, 0x12, 0x0b, 0x0a, 0x07, 0x54, 0x52, 0x49,
	0x47, 0x47, 0x45, 0x52, 0x10, 0x04, 0x12, 0x14, 0x0a, 0x10, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43,
	0x45, 0x5f, 0x52, 0x4f, 0x4c, 0x4c, 0x42, 0x41, 0x43, 0x4b, 0x10, 0x05, 0x12, 0x14, 0x0a, 0x10,
	0x54, 0x52, 0x49, 0x47, 0x47, 0x45, 0x52, 0x5f, 0x52, 0x4f, 0x4c, 0x4c, 0x42, 0x41, 0x43, 0x4b,
	0x10, 0x06, 0x22, 0x4e, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53,
	0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x4e, 0x4f, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x52, 0x54, 0x45,
	0x44, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x49, 0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x47, 0x52, 0x45,
	0x53, 0x53, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x4f, 0x4d, 0x50, 0x4c, 0x45, 0x54, 0x45,
	0x10, 0x03, 0x2a, 0x40, 0x0a, 0x0b, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e,
	0x74, 0x12, 0x1b, 0x0a, 0x17, 0x45, 0x4e, 0x56, 0x49, 0x52, 0x4f, 0x4e, 0x4d, 0x45, 0x4e, 0x54,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09,
	0x0a, 0x05, 0x47, 0x45, 0x4e, 0x5f, 0x31, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x47, 0x45, 0x4e,
	0x5f, 0x32, 0x10, 0x02, 0x32, 0xaa, 0x0e, 0x0a, 0x0f, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x9f, 0x01, 0x0a, 0x0b, 0x47, 0x65, 0x74,
	0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x74, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x76, 0x32, 0x2e, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x3c, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x12, 0x2d, 0x2f, 0x76, 0x32,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x75,
	0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xb2, 0x01, 0x0a, 0x0d, 0x4c,
	0x69, 0x73, 0x74, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x75, 0x6e,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x75,
	0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x3e, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f,
	0x12, 0x2d, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x95, 0x02, 0x0a, 0x0e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0xb1, 0x01, 0xca, 0x41, 0x51, 0x0a, 0x22, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2b, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x1b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x2c, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x66, 0x75, 0x6e,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x3a, 0x08,
	0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x2d, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x75,
	0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x97, 0x02, 0x0a, 0x0e, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x75, 0x6e,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb3, 0x01, 0xca, 0x41,
	0x51, 0x0a, 0x22, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x75, 0x6e,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x32,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xda, 0x41, 0x14, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x3a,
	0x08, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x32, 0x36, 0x2f, 0x76, 0x32, 0x2f, 0x7b,
	0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xe7, 0x01, 0x0a, 0x0e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x75, 0x6e, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x32,
	0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x83, 0x01, 0xca, 0x41, 0x44, 0x0a, 0x15, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70,
	0x74, 0x79, 0x12, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x2a, 0x2d, 0x2f, 0x76,
	0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xca, 0x01, 0x0a, 0x11,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x72,
	0x6c, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x72, 0x6c, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x76, 0x32, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x55, 0x70, 0x6c, 0x6f, 0x61,
	0x64, 0x55, 0x72, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4a, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x44, 0x3a, 0x01, 0x2a, 0x22, 0x3f, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x75, 0x6e,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x55,
	0x70, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x72, 0x6c, 0x12, 0xd2, 0x01, 0x0a, 0x13, 0x47, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x65, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x72, 0x6c,
	0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x65, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x72, 0x6c,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x44, 0x6f, 0x77, 0x6e,
	0x6c, 0x6f, 0x61, 0x64, 0x55, 0x72, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x4c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x46, 0x3a, 0x01, 0x2a, 0x22, 0x41, 0x2f, 0x76, 0x32, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x75, 0x6e,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x65, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x72, 0x6c, 0x12, 0xae, 0x01,
	0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x12, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75,
	0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75,
	0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x3d, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2e,
	0x12, 0x2c, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x1a, 0x51,
	0xca, 0x41, 0x1d, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75,
	0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x42, 0xee, 0x07, 0xea, 0x41, 0x6f, 0x0a, 0x2a, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63,
	0x74, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x12, 0x41, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x72, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x7d, 0xea, 0x41, 0x59, 0x0a, 0x1f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x12, 0x36, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x73, 0x2f, 0x7b, 0x62, 0x75, 0x69, 0x6c,
	0x64, 0x7d, 0xea, 0x41, 0x69, 0x0a, 0x24, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c,
	0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x41, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x50, 0x6f, 0x6f, 0x6c, 0x73,
	0x2f, 0x7b, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x7d, 0xea, 0x41,
	0x58, 0x0a, 0x1a, 0x72, 0x75, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x3a, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f,
	0x7b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x7d, 0xea, 0x41, 0x64, 0x0a, 0x22, 0x76, 0x70,
	0x63, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x12, 0x3e, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x7d,
	0xea, 0x41, 0x5d, 0x0a, 0x1f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x63, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x72, 0x69,
	0x67, 0x67, 0x65, 0x72, 0x12, 0x3a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x74, 0x72,
	0x69, 0x67, 0x67, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x7d,
	0xea, 0x41, 0x5d, 0x0a, 0x1f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x63, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x3a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x2f, 0x7b, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x7d,
	0xea, 0x41, 0x40, 0x0a, 0x1b, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x6f, 0x70, 0x69, 0x63,
	0x12, 0x21, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x73, 0x2f, 0x7b, 0x74, 0x6f, 0x70,
	0x69, 0x63, 0x7d, 0xea, 0x41, 0x78, 0x0a, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x12, 0x53, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x6b, 0x65, 0x79, 0x52, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x7b, 0x6b, 0x65, 0x79,
	0x5f, 0x72, 0x69, 0x6e, 0x67, 0x7d, 0x2f, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79,
	0x73, 0x2f, 0x7b, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x5f, 0x6b, 0x65, 0x79, 0x7d, 0x0a, 0x1d,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x32, 0x42, 0x0e, 0x46,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a,
	0x3b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x61,
	0x70, 0x69, 0x76, 0x32, 0x2f, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x70, 0x62,
	0x3b, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x70, 0x62, 0xa2, 0x02, 0x03, 0x47,
	0x43, 0x46, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_functions_v2_functions_proto_rawDescOnce sync.Once
	file_google_cloud_functions_v2_functions_proto_rawDescData = file_google_cloud_functions_v2_functions_proto_rawDesc
)

func file_google_cloud_functions_v2_functions_proto_rawDescGZIP() []byte {
	file_google_cloud_functions_v2_functions_proto_rawDescOnce.Do(func() {
		file_google_cloud_functions_v2_functions_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_functions_v2_functions_proto_rawDescData)
	})
	return file_google_cloud_functions_v2_functions_proto_rawDescData
}

var file_google_cloud_functions_v2_functions_proto_enumTypes = make([]protoimpl.EnumInfo, 11)
var file_google_cloud_functions_v2_functions_proto_msgTypes = make([]protoimpl.MessageInfo, 32)
var file_google_cloud_functions_v2_functions_proto_goTypes = []interface{}{
	(Environment)(0),                              // 0: google.cloud.functions.v2.Environment
	(Function_State)(0),                           // 1: google.cloud.functions.v2.Function.State
	(StateMessage_Severity)(0),                    // 2: google.cloud.functions.v2.StateMessage.Severity
	(BuildConfig_DockerRegistry)(0),               // 3: google.cloud.functions.v2.BuildConfig.DockerRegistry
	(ServiceConfig_VpcConnectorEgressSettings)(0), // 4: google.cloud.functions.v2.ServiceConfig.VpcConnectorEgressSettings
	(ServiceConfig_IngressSettings)(0),            // 5: google.cloud.functions.v2.ServiceConfig.IngressSettings
	(ServiceConfig_SecurityLevel)(0),              // 6: google.cloud.functions.v2.ServiceConfig.SecurityLevel
	(EventTrigger_RetryPolicy)(0),                 // 7: google.cloud.functions.v2.EventTrigger.RetryPolicy
	(ListRuntimesResponse_RuntimeStage)(0),        // 8: google.cloud.functions.v2.ListRuntimesResponse.RuntimeStage
	(Stage_Name)(0),                               // 9: google.cloud.functions.v2.Stage.Name
	(Stage_State)(0),                              // 10: google.cloud.functions.v2.Stage.State
	(*Function)(nil),                              // 11: google.cloud.functions.v2.Function
	(*StateMessage)(nil),                          // 12: google.cloud.functions.v2.StateMessage
	(*StorageSource)(nil),                         // 13: google.cloud.functions.v2.StorageSource
	(*RepoSource)(nil),                            // 14: google.cloud.functions.v2.RepoSource
	(*Source)(nil),                                // 15: google.cloud.functions.v2.Source
	(*SourceProvenance)(nil),                      // 16: google.cloud.functions.v2.SourceProvenance
	(*BuildConfig)(nil),                           // 17: google.cloud.functions.v2.BuildConfig
	(*ServiceConfig)(nil),                         // 18: google.cloud.functions.v2.ServiceConfig
	(*SecretEnvVar)(nil),                          // 19: google.cloud.functions.v2.SecretEnvVar
	(*SecretVolume)(nil),                          // 20: google.cloud.functions.v2.SecretVolume
	(*EventTrigger)(nil),                          // 21: google.cloud.functions.v2.EventTrigger
	(*EventFilter)(nil),                           // 22: google.cloud.functions.v2.EventFilter
	(*GetFunctionRequest)(nil),                    // 23: google.cloud.functions.v2.GetFunctionRequest
	(*ListFunctionsRequest)(nil),                  // 24: google.cloud.functions.v2.ListFunctionsRequest
	(*ListFunctionsResponse)(nil),                 // 25: google.cloud.functions.v2.ListFunctionsResponse
	(*CreateFunctionRequest)(nil),                 // 26: google.cloud.functions.v2.CreateFunctionRequest
	(*UpdateFunctionRequest)(nil),                 // 27: google.cloud.functions.v2.UpdateFunctionRequest
	(*DeleteFunctionRequest)(nil),                 // 28: google.cloud.functions.v2.DeleteFunctionRequest
	(*GenerateUploadUrlRequest)(nil),              // 29: google.cloud.functions.v2.GenerateUploadUrlRequest
	(*GenerateUploadUrlResponse)(nil),             // 30: google.cloud.functions.v2.GenerateUploadUrlResponse
	(*GenerateDownloadUrlRequest)(nil),            // 31: google.cloud.functions.v2.GenerateDownloadUrlRequest
	(*GenerateDownloadUrlResponse)(nil),           // 32: google.cloud.functions.v2.GenerateDownloadUrlResponse
	(*ListRuntimesRequest)(nil),                   // 33: google.cloud.functions.v2.ListRuntimesRequest
	(*ListRuntimesResponse)(nil),                  // 34: google.cloud.functions.v2.ListRuntimesResponse
	(*OperationMetadata)(nil),                     // 35: google.cloud.functions.v2.OperationMetadata
	(*LocationMetadata)(nil),                      // 36: google.cloud.functions.v2.LocationMetadata
	(*Stage)(nil),                                 // 37: google.cloud.functions.v2.Stage
	nil,                                           // 38: google.cloud.functions.v2.Function.LabelsEntry
	nil,                                           // 39: google.cloud.functions.v2.BuildConfig.EnvironmentVariablesEntry
	nil,                                           // 40: google.cloud.functions.v2.ServiceConfig.EnvironmentVariablesEntry
	(*SecretVolume_SecretVersion)(nil),            // 41: google.cloud.functions.v2.SecretVolume.SecretVersion
	(*ListRuntimesResponse_Runtime)(nil),          // 42: google.cloud.functions.v2.ListRuntimesResponse.Runtime
	(*timestamppb.Timestamp)(nil),                 // 43: google.protobuf.Timestamp
	(*fieldmaskpb.FieldMask)(nil),                 // 44: google.protobuf.FieldMask
	(*anypb.Any)(nil),                             // 45: google.protobuf.Any
	(*longrunningpb.Operation)(nil),               // 46: google.longrunning.Operation
}
var file_google_cloud_functions_v2_functions_proto_depIdxs = []int32{
	17, // 0: google.cloud.functions.v2.Function.build_config:type_name -> google.cloud.functions.v2.BuildConfig
	18, // 1: google.cloud.functions.v2.Function.service_config:type_name -> google.cloud.functions.v2.ServiceConfig
	21, // 2: google.cloud.functions.v2.Function.event_trigger:type_name -> google.cloud.functions.v2.EventTrigger
	1,  // 3: google.cloud.functions.v2.Function.state:type_name -> google.cloud.functions.v2.Function.State
	43, // 4: google.cloud.functions.v2.Function.update_time:type_name -> google.protobuf.Timestamp
	38, // 5: google.cloud.functions.v2.Function.labels:type_name -> google.cloud.functions.v2.Function.LabelsEntry
	12, // 6: google.cloud.functions.v2.Function.state_messages:type_name -> google.cloud.functions.v2.StateMessage
	0,  // 7: google.cloud.functions.v2.Function.environment:type_name -> google.cloud.functions.v2.Environment
	2,  // 8: google.cloud.functions.v2.StateMessage.severity:type_name -> google.cloud.functions.v2.StateMessage.Severity
	13, // 9: google.cloud.functions.v2.Source.storage_source:type_name -> google.cloud.functions.v2.StorageSource
	14, // 10: google.cloud.functions.v2.Source.repo_source:type_name -> google.cloud.functions.v2.RepoSource
	13, // 11: google.cloud.functions.v2.SourceProvenance.resolved_storage_source:type_name -> google.cloud.functions.v2.StorageSource
	14, // 12: google.cloud.functions.v2.SourceProvenance.resolved_repo_source:type_name -> google.cloud.functions.v2.RepoSource
	15, // 13: google.cloud.functions.v2.BuildConfig.source:type_name -> google.cloud.functions.v2.Source
	16, // 14: google.cloud.functions.v2.BuildConfig.source_provenance:type_name -> google.cloud.functions.v2.SourceProvenance
	39, // 15: google.cloud.functions.v2.BuildConfig.environment_variables:type_name -> google.cloud.functions.v2.BuildConfig.EnvironmentVariablesEntry
	3,  // 16: google.cloud.functions.v2.BuildConfig.docker_registry:type_name -> google.cloud.functions.v2.BuildConfig.DockerRegistry
	40, // 17: google.cloud.functions.v2.ServiceConfig.environment_variables:type_name -> google.cloud.functions.v2.ServiceConfig.EnvironmentVariablesEntry
	4,  // 18: google.cloud.functions.v2.ServiceConfig.vpc_connector_egress_settings:type_name -> google.cloud.functions.v2.ServiceConfig.VpcConnectorEgressSettings
	5,  // 19: google.cloud.functions.v2.ServiceConfig.ingress_settings:type_name -> google.cloud.functions.v2.ServiceConfig.IngressSettings
	19, // 20: google.cloud.functions.v2.ServiceConfig.secret_environment_variables:type_name -> google.cloud.functions.v2.SecretEnvVar
	20, // 21: google.cloud.functions.v2.ServiceConfig.secret_volumes:type_name -> google.cloud.functions.v2.SecretVolume
	6,  // 22: google.cloud.functions.v2.ServiceConfig.security_level:type_name -> google.cloud.functions.v2.ServiceConfig.SecurityLevel
	41, // 23: google.cloud.functions.v2.SecretVolume.versions:type_name -> google.cloud.functions.v2.SecretVolume.SecretVersion
	22, // 24: google.cloud.functions.v2.EventTrigger.event_filters:type_name -> google.cloud.functions.v2.EventFilter
	7,  // 25: google.cloud.functions.v2.EventTrigger.retry_policy:type_name -> google.cloud.functions.v2.EventTrigger.RetryPolicy
	11, // 26: google.cloud.functions.v2.ListFunctionsResponse.functions:type_name -> google.cloud.functions.v2.Function
	11, // 27: google.cloud.functions.v2.CreateFunctionRequest.function:type_name -> google.cloud.functions.v2.Function
	11, // 28: google.cloud.functions.v2.UpdateFunctionRequest.function:type_name -> google.cloud.functions.v2.Function
	44, // 29: google.cloud.functions.v2.UpdateFunctionRequest.update_mask:type_name -> google.protobuf.FieldMask
	13, // 30: google.cloud.functions.v2.GenerateUploadUrlResponse.storage_source:type_name -> google.cloud.functions.v2.StorageSource
	42, // 31: google.cloud.functions.v2.ListRuntimesResponse.runtimes:type_name -> google.cloud.functions.v2.ListRuntimesResponse.Runtime
	43, // 32: google.cloud.functions.v2.OperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	43, // 33: google.cloud.functions.v2.OperationMetadata.end_time:type_name -> google.protobuf.Timestamp
	45, // 34: google.cloud.functions.v2.OperationMetadata.request_resource:type_name -> google.protobuf.Any
	37, // 35: google.cloud.functions.v2.OperationMetadata.stages:type_name -> google.cloud.functions.v2.Stage
	0,  // 36: google.cloud.functions.v2.LocationMetadata.environments:type_name -> google.cloud.functions.v2.Environment
	9,  // 37: google.cloud.functions.v2.Stage.name:type_name -> google.cloud.functions.v2.Stage.Name
	10, // 38: google.cloud.functions.v2.Stage.state:type_name -> google.cloud.functions.v2.Stage.State
	12, // 39: google.cloud.functions.v2.Stage.state_messages:type_name -> google.cloud.functions.v2.StateMessage
	8,  // 40: google.cloud.functions.v2.ListRuntimesResponse.Runtime.stage:type_name -> google.cloud.functions.v2.ListRuntimesResponse.RuntimeStage
	0,  // 41: google.cloud.functions.v2.ListRuntimesResponse.Runtime.environment:type_name -> google.cloud.functions.v2.Environment
	23, // 42: google.cloud.functions.v2.FunctionService.GetFunction:input_type -> google.cloud.functions.v2.GetFunctionRequest
	24, // 43: google.cloud.functions.v2.FunctionService.ListFunctions:input_type -> google.cloud.functions.v2.ListFunctionsRequest
	26, // 44: google.cloud.functions.v2.FunctionService.CreateFunction:input_type -> google.cloud.functions.v2.CreateFunctionRequest
	27, // 45: google.cloud.functions.v2.FunctionService.UpdateFunction:input_type -> google.cloud.functions.v2.UpdateFunctionRequest
	28, // 46: google.cloud.functions.v2.FunctionService.DeleteFunction:input_type -> google.cloud.functions.v2.DeleteFunctionRequest
	29, // 47: google.cloud.functions.v2.FunctionService.GenerateUploadUrl:input_type -> google.cloud.functions.v2.GenerateUploadUrlRequest
	31, // 48: google.cloud.functions.v2.FunctionService.GenerateDownloadUrl:input_type -> google.cloud.functions.v2.GenerateDownloadUrlRequest
	33, // 49: google.cloud.functions.v2.FunctionService.ListRuntimes:input_type -> google.cloud.functions.v2.ListRuntimesRequest
	11, // 50: google.cloud.functions.v2.FunctionService.GetFunction:output_type -> google.cloud.functions.v2.Function
	25, // 51: google.cloud.functions.v2.FunctionService.ListFunctions:output_type -> google.cloud.functions.v2.ListFunctionsResponse
	46, // 52: google.cloud.functions.v2.FunctionService.CreateFunction:output_type -> google.longrunning.Operation
	46, // 53: google.cloud.functions.v2.FunctionService.UpdateFunction:output_type -> google.longrunning.Operation
	46, // 54: google.cloud.functions.v2.FunctionService.DeleteFunction:output_type -> google.longrunning.Operation
	30, // 55: google.cloud.functions.v2.FunctionService.GenerateUploadUrl:output_type -> google.cloud.functions.v2.GenerateUploadUrlResponse
	32, // 56: google.cloud.functions.v2.FunctionService.GenerateDownloadUrl:output_type -> google.cloud.functions.v2.GenerateDownloadUrlResponse
	34, // 57: google.cloud.functions.v2.FunctionService.ListRuntimes:output_type -> google.cloud.functions.v2.ListRuntimesResponse
	50, // [50:58] is the sub-list for method output_type
	42, // [42:50] is the sub-list for method input_type
	42, // [42:42] is the sub-list for extension type_name
	42, // [42:42] is the sub-list for extension extendee
	0,  // [0:42] is the sub-list for field type_name
}

func init() { file_google_cloud_functions_v2_functions_proto_init() }
func file_google_cloud_functions_v2_functions_proto_init() {
	if File_google_cloud_functions_v2_functions_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_functions_v2_functions_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Function); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v2_functions_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StateMessage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v2_functions_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StorageSource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v2_functions_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RepoSource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v2_functions_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Source); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v2_functions_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SourceProvenance); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v2_functions_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BuildConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v2_functions_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServiceConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v2_functions_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SecretEnvVar); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v2_functions_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SecretVolume); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v2_functions_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EventTrigger); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v2_functions_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EventFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v2_functions_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetFunctionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v2_functions_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListFunctionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v2_functions_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListFunctionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v2_functions_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateFunctionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v2_functions_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateFunctionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v2_functions_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteFunctionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v2_functions_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateUploadUrlRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v2_functions_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateUploadUrlResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v2_functions_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateDownloadUrlRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v2_functions_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateDownloadUrlResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v2_functions_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRuntimesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v2_functions_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRuntimesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v2_functions_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v2_functions_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LocationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v2_functions_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Stage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v2_functions_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SecretVolume_SecretVersion); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v2_functions_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRuntimesResponse_Runtime); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_functions_v2_functions_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*RepoSource_BranchName)(nil),
		(*RepoSource_TagName)(nil),
		(*RepoSource_CommitSha)(nil),
	}
	file_google_cloud_functions_v2_functions_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*Source_StorageSource)(nil),
		(*Source_RepoSource)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_functions_v2_functions_proto_rawDesc,
			NumEnums:      11,
			NumMessages:   32,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_functions_v2_functions_proto_goTypes,
		DependencyIndexes: file_google_cloud_functions_v2_functions_proto_depIdxs,
		EnumInfos:         file_google_cloud_functions_v2_functions_proto_enumTypes,
		MessageInfos:      file_google_cloud_functions_v2_functions_proto_msgTypes,
	}.Build()
	File_google_cloud_functions_v2_functions_proto = out.File
	file_google_cloud_functions_v2_functions_proto_rawDesc = nil
	file_google_cloud_functions_v2_functions_proto_goTypes = nil
	file_google_cloud_functions_v2_functions_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// FunctionServiceClient is the client API for FunctionService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type FunctionServiceClient interface {
	// Returns a function with the given name from the requested project.
	GetFunction(ctx context.Context, in *GetFunctionRequest, opts ...grpc.CallOption) (*Function, error)
	// Returns a list of functions that belong to the requested project.
	ListFunctions(ctx context.Context, in *ListFunctionsRequest, opts ...grpc.CallOption) (*ListFunctionsResponse, error)
	// Creates a new function. If a function with the given name already exists in
	// the specified project, the long running operation will return
	// `ALREADY_EXISTS` error.
	CreateFunction(ctx context.Context, in *CreateFunctionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates existing function.
	UpdateFunction(ctx context.Context, in *UpdateFunctionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a function with the given name from the specified project. If the
	// given function is used by some trigger, the trigger will be updated to
	// remove this function.
	DeleteFunction(ctx context.Context, in *DeleteFunctionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Returns a signed URL for uploading a function source code.
	// For more information about the signed URL usage see:
	// https://cloud.google.com/storage/docs/access-control/signed-urls.
	// Once the function source code upload is complete, the used signed
	// URL should be provided in CreateFunction or UpdateFunction request
	// as a reference to the function source code.
	//
	// When uploading source code to the generated signed URL, please follow
	// these restrictions:
	//
	// * Source file type should be a zip file.
	// * No credentials should be attached - the signed URLs provide access to the
	//   target bucket using internal service identity; if credentials were
	//   attached, the identity from the credentials would be used, but that
	//   identity does not have permissions to upload files to the URL.
	//
	// When making a HTTP PUT request, these two headers need to be specified:
	//
	// * `content-type: application/zip`
	//
	// And this header SHOULD NOT be specified:
	//
	// * `Authorization: Bearer YOUR_TOKEN`
	GenerateUploadUrl(ctx context.Context, in *GenerateUploadUrlRequest, opts ...grpc.CallOption) (*GenerateUploadUrlResponse, error)
	// Returns a signed URL for downloading deployed function source code.
	// The URL is only valid for a limited period and should be used within
	// 30 minutes of generation.
	// For more information about the signed URL usage see:
	// https://cloud.google.com/storage/docs/access-control/signed-urls
	GenerateDownloadUrl(ctx context.Context, in *GenerateDownloadUrlRequest, opts ...grpc.CallOption) (*GenerateDownloadUrlResponse, error)
	// Returns a list of runtimes that are supported for the requested project.
	ListRuntimes(ctx context.Context, in *ListRuntimesRequest, opts ...grpc.CallOption) (*ListRuntimesResponse, error)
}

type functionServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewFunctionServiceClient(cc grpc.ClientConnInterface) FunctionServiceClient {
	return &functionServiceClient{cc}
}

func (c *functionServiceClient) GetFunction(ctx context.Context, in *GetFunctionRequest, opts ...grpc.CallOption) (*Function, error) {
	out := new(Function)
	err := c.cc.Invoke(ctx, "/google.cloud.functions.v2.FunctionService/GetFunction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *functionServiceClient) ListFunctions(ctx context.Context, in *ListFunctionsRequest, opts ...grpc.CallOption) (*ListFunctionsResponse, error) {
	out := new(ListFunctionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.functions.v2.FunctionService/ListFunctions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *functionServiceClient) CreateFunction(ctx context.Context, in *CreateFunctionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.functions.v2.FunctionService/CreateFunction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *functionServiceClient) UpdateFunction(ctx context.Context, in *UpdateFunctionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.functions.v2.FunctionService/UpdateFunction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *functionServiceClient) DeleteFunction(ctx context.Context, in *DeleteFunctionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.functions.v2.FunctionService/DeleteFunction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *functionServiceClient) GenerateUploadUrl(ctx context.Context, in *GenerateUploadUrlRequest, opts ...grpc.CallOption) (*GenerateUploadUrlResponse, error) {
	out := new(GenerateUploadUrlResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.functions.v2.FunctionService/GenerateUploadUrl", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *functionServiceClient) GenerateDownloadUrl(ctx context.Context, in *GenerateDownloadUrlRequest, opts ...grpc.CallOption) (*GenerateDownloadUrlResponse, error) {
	out := new(GenerateDownloadUrlResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.functions.v2.FunctionService/GenerateDownloadUrl", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *functionServiceClient) ListRuntimes(ctx context.Context, in *ListRuntimesRequest, opts ...grpc.CallOption) (*ListRuntimesResponse, error) {
	out := new(ListRuntimesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.functions.v2.FunctionService/ListRuntimes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// FunctionServiceServer is the server API for FunctionService service.
type FunctionServiceServer interface {
	// Returns a function with the given name from the requested project.
	GetFunction(context.Context, *GetFunctionRequest) (*Function, error)
	// Returns a list of functions that belong to the requested project.
	ListFunctions(context.Context, *ListFunctionsRequest) (*ListFunctionsResponse, error)
	// Creates a new function. If a function with the given name already exists in
	// the specified project, the long running operation will return
	// `ALREADY_EXISTS` error.
	CreateFunction(context.Context, *CreateFunctionRequest) (*longrunningpb.Operation, error)
	// Updates existing function.
	UpdateFunction(context.Context, *UpdateFunctionRequest) (*longrunningpb.Operation, error)
	// Deletes a function with the given name from the specified project. If the
	// given function is used by some trigger, the trigger will be updated to
	// remove this function.
	DeleteFunction(context.Context, *DeleteFunctionRequest) (*longrunningpb.Operation, error)
	// Returns a signed URL for uploading a function source code.
	// For more information about the signed URL usage see:
	// https://cloud.google.com/storage/docs/access-control/signed-urls.
	// Once the function source code upload is complete, the used signed
	// URL should be provided in CreateFunction or UpdateFunction request
	// as a reference to the function source code.
	//
	// When uploading source code to the generated signed URL, please follow
	// these restrictions:
	//
	// * Source file type should be a zip file.
	// * No credentials should be attached - the signed URLs provide access to the
	//   target bucket using internal service identity; if credentials were
	//   attached, the identity from the credentials would be used, but that
	//   identity does not have permissions to upload files to the URL.
	//
	// When making a HTTP PUT request, these two headers need to be specified:
	//
	// * `content-type: application/zip`
	//
	// And this header SHOULD NOT be specified:
	//
	// * `Authorization: Bearer YOUR_TOKEN`
	GenerateUploadUrl(context.Context, *GenerateUploadUrlRequest) (*GenerateUploadUrlResponse, error)
	// Returns a signed URL for downloading deployed function source code.
	// The URL is only valid for a limited period and should be used within
	// 30 minutes of generation.
	// For more information about the signed URL usage see:
	// https://cloud.google.com/storage/docs/access-control/signed-urls
	GenerateDownloadUrl(context.Context, *GenerateDownloadUrlRequest) (*GenerateDownloadUrlResponse, error)
	// Returns a list of runtimes that are supported for the requested project.
	ListRuntimes(context.Context, *ListRuntimesRequest) (*ListRuntimesResponse, error)
}

// UnimplementedFunctionServiceServer can be embedded to have forward compatible implementations.
type UnimplementedFunctionServiceServer struct {
}

func (*UnimplementedFunctionServiceServer) GetFunction(context.Context, *GetFunctionRequest) (*Function, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFunction not implemented")
}
func (*UnimplementedFunctionServiceServer) ListFunctions(context.Context, *ListFunctionsRequest) (*ListFunctionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListFunctions not implemented")
}
func (*UnimplementedFunctionServiceServer) CreateFunction(context.Context, *CreateFunctionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateFunction not implemented")
}
func (*UnimplementedFunctionServiceServer) UpdateFunction(context.Context, *UpdateFunctionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateFunction not implemented")
}
func (*UnimplementedFunctionServiceServer) DeleteFunction(context.Context, *DeleteFunctionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteFunction not implemented")
}
func (*UnimplementedFunctionServiceServer) GenerateUploadUrl(context.Context, *GenerateUploadUrlRequest) (*GenerateUploadUrlResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateUploadUrl not implemented")
}
func (*UnimplementedFunctionServiceServer) GenerateDownloadUrl(context.Context, *GenerateDownloadUrlRequest) (*GenerateDownloadUrlResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateDownloadUrl not implemented")
}
func (*UnimplementedFunctionServiceServer) ListRuntimes(context.Context, *ListRuntimesRequest) (*ListRuntimesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRuntimes not implemented")
}

func RegisterFunctionServiceServer(s *grpc.Server, srv FunctionServiceServer) {
	s.RegisterService(&_FunctionService_serviceDesc, srv)
}

func _FunctionService_GetFunction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFunctionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FunctionServiceServer).GetFunction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.functions.v2.FunctionService/GetFunction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FunctionServiceServer).GetFunction(ctx, req.(*GetFunctionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FunctionService_ListFunctions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFunctionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FunctionServiceServer).ListFunctions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.functions.v2.FunctionService/ListFunctions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FunctionServiceServer).ListFunctions(ctx, req.(*ListFunctionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FunctionService_CreateFunction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFunctionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FunctionServiceServer).CreateFunction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.functions.v2.FunctionService/CreateFunction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FunctionServiceServer).CreateFunction(ctx, req.(*CreateFunctionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FunctionService_UpdateFunction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFunctionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FunctionServiceServer).UpdateFunction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.functions.v2.FunctionService/UpdateFunction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FunctionServiceServer).UpdateFunction(ctx, req.(*UpdateFunctionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FunctionService_DeleteFunction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFunctionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FunctionServiceServer).DeleteFunction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.functions.v2.FunctionService/DeleteFunction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FunctionServiceServer).DeleteFunction(ctx, req.(*DeleteFunctionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FunctionService_GenerateUploadUrl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateUploadUrlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FunctionServiceServer).GenerateUploadUrl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.functions.v2.FunctionService/GenerateUploadUrl",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FunctionServiceServer).GenerateUploadUrl(ctx, req.(*GenerateUploadUrlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FunctionService_GenerateDownloadUrl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateDownloadUrlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FunctionServiceServer).GenerateDownloadUrl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.functions.v2.FunctionService/GenerateDownloadUrl",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FunctionServiceServer).GenerateDownloadUrl(ctx, req.(*GenerateDownloadUrlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FunctionService_ListRuntimes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRuntimesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FunctionServiceServer).ListRuntimes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.functions.v2.FunctionService/ListRuntimes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FunctionServiceServer).ListRuntimes(ctx, req.(*ListRuntimesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _FunctionService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.functions.v2.FunctionService",
	HandlerType: (*FunctionServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetFunction",
			Handler:    _FunctionService_GetFunction_Handler,
		},
		{
			MethodName: "ListFunctions",
			Handler:    _FunctionService_ListFunctions_Handler,
		},
		{
			MethodName: "CreateFunction",
			Handler:    _FunctionService_CreateFunction_Handler,
		},
		{
			MethodName: "UpdateFunction",
			Handler:    _FunctionService_UpdateFunction_Handler,
		},
		{
			MethodName: "DeleteFunction",
			Handler:    _FunctionService_DeleteFunction_Handler,
		},
		{
			MethodName: "GenerateUploadUrl",
			Handler:    _FunctionService_GenerateUploadUrl_Handler,
		},
		{
			MethodName: "GenerateDownloadUrl",
			Handler:    _FunctionService_GenerateDownloadUrl_Handler,
		},
		{
			MethodName: "ListRuntimes",
			Handler:    _FunctionService_ListRuntimes_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/functions/v2/functions.proto",
}
