// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package iam

import (
	"bytes"
	"context"
	"fmt"
	"log/slog"
	"math"
	"net/http"
	"net/url"
	"time"

	iampb "cloud.google.com/go/iam/apiv3/iampb"
	"cloud.google.com/go/longrunning"
	lroauto "cloud.google.com/go/longrunning/autogen"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	httptransport "google.golang.org/api/transport/http"
	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
	"google.golang.org/protobuf/encoding/protojson"
	"google.golang.org/protobuf/proto"
)

var newPolicyBindingsClientHook clientHook

// PolicyBindingsCallOptions contains the retry settings for each method of PolicyBindingsClient.
type PolicyBindingsCallOptions struct {
	CreatePolicyBinding        []gax.CallOption
	GetPolicyBinding           []gax.CallOption
	UpdatePolicyBinding        []gax.CallOption
	DeletePolicyBinding        []gax.CallOption
	ListPolicyBindings         []gax.CallOption
	SearchTargetPolicyBindings []gax.CallOption
	GetOperation               []gax.CallOption
}

func defaultPolicyBindingsGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("iam.googleapis.com:443"),
		internaloption.WithDefaultEndpointTemplate("iam.UNIVERSE_DOMAIN:443"),
		internaloption.WithDefaultMTLSEndpoint("iam.mtls.googleapis.com:443"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://iam.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		internaloption.EnableNewAuthLibrary(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultPolicyBindingsCallOptions() *PolicyBindingsCallOptions {
	return &PolicyBindingsCallOptions{
		CreatePolicyBinding: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
		},
		GetPolicyBinding: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		UpdatePolicyBinding: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
		},
		DeletePolicyBinding: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
		},
		ListPolicyBindings: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		SearchTargetPolicyBindings: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetOperation: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
	}
}

func defaultPolicyBindingsRESTCallOptions() *PolicyBindingsCallOptions {
	return &PolicyBindingsCallOptions{
		CreatePolicyBinding: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
		},
		GetPolicyBinding: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		UpdatePolicyBinding: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
		},
		DeletePolicyBinding: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
		},
		ListPolicyBindings: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		SearchTargetPolicyBindings: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		GetOperation: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
	}
}

// internalPolicyBindingsClient is an interface that defines the methods available from Identity and Access Management (IAM) API.
type internalPolicyBindingsClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	CreatePolicyBinding(context.Context, *iampb.CreatePolicyBindingRequest, ...gax.CallOption) (*CreatePolicyBindingOperation, error)
	CreatePolicyBindingOperation(name string) *CreatePolicyBindingOperation
	GetPolicyBinding(context.Context, *iampb.GetPolicyBindingRequest, ...gax.CallOption) (*iampb.PolicyBinding, error)
	UpdatePolicyBinding(context.Context, *iampb.UpdatePolicyBindingRequest, ...gax.CallOption) (*UpdatePolicyBindingOperation, error)
	UpdatePolicyBindingOperation(name string) *UpdatePolicyBindingOperation
	DeletePolicyBinding(context.Context, *iampb.DeletePolicyBindingRequest, ...gax.CallOption) (*DeletePolicyBindingOperation, error)
	DeletePolicyBindingOperation(name string) *DeletePolicyBindingOperation
	ListPolicyBindings(context.Context, *iampb.ListPolicyBindingsRequest, ...gax.CallOption) *PolicyBindingIterator
	SearchTargetPolicyBindings(context.Context, *iampb.SearchTargetPolicyBindingsRequest, ...gax.CallOption) *PolicyBindingIterator
	GetOperation(context.Context, *longrunningpb.GetOperationRequest, ...gax.CallOption) (*longrunningpb.Operation, error)
}

// PolicyBindingsClient is a client for interacting with Identity and Access Management (IAM) API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// An interface for managing Identity and Access Management (IAM) policy
// bindings.
type PolicyBindingsClient struct {
	// The internal transport-dependent client.
	internalClient internalPolicyBindingsClient

	// The call options for this service.
	CallOptions *PolicyBindingsCallOptions

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient *lroauto.OperationsClient
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *PolicyBindingsClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *PolicyBindingsClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *PolicyBindingsClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// CreatePolicyBinding creates a policy binding and returns a long-running operation.
// Callers will need the IAM permissions on both the policy and target.
// Once the binding is created, the policy is applied to the target.
func (c *PolicyBindingsClient) CreatePolicyBinding(ctx context.Context, req *iampb.CreatePolicyBindingRequest, opts ...gax.CallOption) (*CreatePolicyBindingOperation, error) {
	return c.internalClient.CreatePolicyBinding(ctx, req, opts...)
}

// CreatePolicyBindingOperation returns a new CreatePolicyBindingOperation from a given name.
// The name must be that of a previously created CreatePolicyBindingOperation, possibly from a different process.
func (c *PolicyBindingsClient) CreatePolicyBindingOperation(name string) *CreatePolicyBindingOperation {
	return c.internalClient.CreatePolicyBindingOperation(name)
}

// GetPolicyBinding gets a policy binding.
func (c *PolicyBindingsClient) GetPolicyBinding(ctx context.Context, req *iampb.GetPolicyBindingRequest, opts ...gax.CallOption) (*iampb.PolicyBinding, error) {
	return c.internalClient.GetPolicyBinding(ctx, req, opts...)
}

// UpdatePolicyBinding updates a policy binding and returns a long-running operation.
// Callers will need the IAM permissions on the policy and target in the
// binding to update, and the IAM permission to remove the existing policy
// from the binding. Target is immutable and cannot be updated. Once the
// binding is updated, the new policy is applied to the target.
func (c *PolicyBindingsClient) UpdatePolicyBinding(ctx context.Context, req *iampb.UpdatePolicyBindingRequest, opts ...gax.CallOption) (*UpdatePolicyBindingOperation, error) {
	return c.internalClient.UpdatePolicyBinding(ctx, req, opts...)
}

// UpdatePolicyBindingOperation returns a new UpdatePolicyBindingOperation from a given name.
// The name must be that of a previously created UpdatePolicyBindingOperation, possibly from a different process.
func (c *PolicyBindingsClient) UpdatePolicyBindingOperation(name string) *UpdatePolicyBindingOperation {
	return c.internalClient.UpdatePolicyBindingOperation(name)
}

// DeletePolicyBinding deletes a policy binding and returns a long-running operation.
// Callers will need the IAM permissions on both the policy and target.
// Once the binding is deleted, the policy no longer applies to the target.
func (c *PolicyBindingsClient) DeletePolicyBinding(ctx context.Context, req *iampb.DeletePolicyBindingRequest, opts ...gax.CallOption) (*DeletePolicyBindingOperation, error) {
	return c.internalClient.DeletePolicyBinding(ctx, req, opts...)
}

// DeletePolicyBindingOperation returns a new DeletePolicyBindingOperation from a given name.
// The name must be that of a previously created DeletePolicyBindingOperation, possibly from a different process.
func (c *PolicyBindingsClient) DeletePolicyBindingOperation(name string) *DeletePolicyBindingOperation {
	return c.internalClient.DeletePolicyBindingOperation(name)
}

// ListPolicyBindings lists policy bindings.
func (c *PolicyBindingsClient) ListPolicyBindings(ctx context.Context, req *iampb.ListPolicyBindingsRequest, opts ...gax.CallOption) *PolicyBindingIterator {
	return c.internalClient.ListPolicyBindings(ctx, req, opts...)
}

// SearchTargetPolicyBindings search policy bindings by target. Returns all policy binding objects bound
// directly to target.
func (c *PolicyBindingsClient) SearchTargetPolicyBindings(ctx context.Context, req *iampb.SearchTargetPolicyBindingsRequest, opts ...gax.CallOption) *PolicyBindingIterator {
	return c.internalClient.SearchTargetPolicyBindings(ctx, req, opts...)
}

// GetOperation is a utility method from google.longrunning.Operations.
func (c *PolicyBindingsClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	return c.internalClient.GetOperation(ctx, req, opts...)
}

// policyBindingsGRPCClient is a client for interacting with Identity and Access Management (IAM) API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type policyBindingsGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing PolicyBindingsClient
	CallOptions **PolicyBindingsCallOptions

	// The gRPC API client.
	policyBindingsClient iampb.PolicyBindingsClient

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	operationsClient longrunningpb.OperationsClient

	// The x-goog-* metadata to be sent with each request.
	xGoogHeaders []string

	logger *slog.Logger
}

// NewPolicyBindingsClient creates a new policy bindings client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// An interface for managing Identity and Access Management (IAM) policy
// bindings.
func NewPolicyBindingsClient(ctx context.Context, opts ...option.ClientOption) (*PolicyBindingsClient, error) {
	clientOpts := defaultPolicyBindingsGRPCClientOptions()
	if newPolicyBindingsClientHook != nil {
		hookOpts, err := newPolicyBindingsClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := PolicyBindingsClient{CallOptions: defaultPolicyBindingsCallOptions()}

	c := &policyBindingsGRPCClient{
		connPool:             connPool,
		policyBindingsClient: iampb.NewPolicyBindingsClient(connPool),
		CallOptions:          &client.CallOptions,
		logger:               internaloption.GetLogger(opts),
		operationsClient:     longrunningpb.NewOperationsClient(connPool),
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	client.LROClient, err = lroauto.NewOperationsClient(ctx, gtransport.WithConnPool(connPool))
	if err != nil {
		// This error "should not happen", since we are just reusing old connection pool
		// and never actually need to dial.
		// If this does happen, we could leak connp. However, we cannot close conn:
		// If the user invoked the constructor with option.WithGRPCConn,
		// we would close a connection that's still in use.
		// TODO: investigate error conditions.
		return nil, err
	}
	c.LROClient = &client.LROClient
	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *policyBindingsGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *policyBindingsGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *policyBindingsGRPCClient) Close() error {
	return c.connPool.Close()
}

// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type policyBindingsRESTClient struct {
	// The http endpoint to connect to.
	endpoint string

	// The http client.
	httpClient *http.Client

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	// The x-goog-* headers to be sent with each request.
	xGoogHeaders []string

	// Points back to the CallOptions field of the containing PolicyBindingsClient
	CallOptions **PolicyBindingsCallOptions

	logger *slog.Logger
}

// NewPolicyBindingsRESTClient creates a new policy bindings rest client.
//
// An interface for managing Identity and Access Management (IAM) policy
// bindings.
func NewPolicyBindingsRESTClient(ctx context.Context, opts ...option.ClientOption) (*PolicyBindingsClient, error) {
	clientOpts := append(defaultPolicyBindingsRESTClientOptions(), opts...)
	httpClient, endpoint, err := httptransport.NewClient(ctx, clientOpts...)
	if err != nil {
		return nil, err
	}

	callOpts := defaultPolicyBindingsRESTCallOptions()
	c := &policyBindingsRESTClient{
		endpoint:    endpoint,
		httpClient:  httpClient,
		CallOptions: &callOpts,
		logger:      internaloption.GetLogger(opts),
	}
	c.setGoogleClientInfo()

	lroOpts := []option.ClientOption{
		option.WithHTTPClient(httpClient),
		option.WithEndpoint(endpoint),
	}
	opClient, err := lroauto.NewOperationsRESTClient(ctx, lroOpts...)
	if err != nil {
		return nil, err
	}
	c.LROClient = &opClient

	return &PolicyBindingsClient{internalClient: c, CallOptions: callOpts}, nil
}

func defaultPolicyBindingsRESTClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("https://iam.googleapis.com"),
		internaloption.WithDefaultEndpointTemplate("https://iam.UNIVERSE_DOMAIN"),
		internaloption.WithDefaultMTLSEndpoint("https://iam.mtls.googleapis.com"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://iam.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableNewAuthLibrary(),
	}
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *policyBindingsRESTClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "rest", "UNKNOWN")
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *policyBindingsRESTClient) Close() error {
	// Replace httpClient with nil to force cleanup.
	c.httpClient = nil
	return nil
}

// Connection returns a connection to the API service.
//
// Deprecated: This method always returns nil.
func (c *policyBindingsRESTClient) Connection() *grpc.ClientConn {
	return nil
}
func (c *policyBindingsGRPCClient) CreatePolicyBinding(ctx context.Context, req *iampb.CreatePolicyBindingRequest, opts ...gax.CallOption) (*CreatePolicyBindingOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreatePolicyBinding[0:len((*c.CallOptions).CreatePolicyBinding):len((*c.CallOptions).CreatePolicyBinding)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.policyBindingsClient.CreatePolicyBinding, req, settings.GRPC, c.logger, "CreatePolicyBinding")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreatePolicyBindingOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *policyBindingsGRPCClient) GetPolicyBinding(ctx context.Context, req *iampb.GetPolicyBindingRequest, opts ...gax.CallOption) (*iampb.PolicyBinding, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetPolicyBinding[0:len((*c.CallOptions).GetPolicyBinding):len((*c.CallOptions).GetPolicyBinding)], opts...)
	var resp *iampb.PolicyBinding
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.policyBindingsClient.GetPolicyBinding, req, settings.GRPC, c.logger, "GetPolicyBinding")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *policyBindingsGRPCClient) UpdatePolicyBinding(ctx context.Context, req *iampb.UpdatePolicyBindingRequest, opts ...gax.CallOption) (*UpdatePolicyBindingOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "policy_binding.name", url.QueryEscape(req.GetPolicyBinding().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdatePolicyBinding[0:len((*c.CallOptions).UpdatePolicyBinding):len((*c.CallOptions).UpdatePolicyBinding)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.policyBindingsClient.UpdatePolicyBinding, req, settings.GRPC, c.logger, "UpdatePolicyBinding")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdatePolicyBindingOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *policyBindingsGRPCClient) DeletePolicyBinding(ctx context.Context, req *iampb.DeletePolicyBindingRequest, opts ...gax.CallOption) (*DeletePolicyBindingOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeletePolicyBinding[0:len((*c.CallOptions).DeletePolicyBinding):len((*c.CallOptions).DeletePolicyBinding)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.policyBindingsClient.DeletePolicyBinding, req, settings.GRPC, c.logger, "DeletePolicyBinding")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeletePolicyBindingOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *policyBindingsGRPCClient) ListPolicyBindings(ctx context.Context, req *iampb.ListPolicyBindingsRequest, opts ...gax.CallOption) *PolicyBindingIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListPolicyBindings[0:len((*c.CallOptions).ListPolicyBindings):len((*c.CallOptions).ListPolicyBindings)], opts...)
	it := &PolicyBindingIterator{}
	req = proto.Clone(req).(*iampb.ListPolicyBindingsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*iampb.PolicyBinding, string, error) {
		resp := &iampb.ListPolicyBindingsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.policyBindingsClient.ListPolicyBindings, req, settings.GRPC, c.logger, "ListPolicyBindings")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetPolicyBindings(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *policyBindingsGRPCClient) SearchTargetPolicyBindings(ctx context.Context, req *iampb.SearchTargetPolicyBindingsRequest, opts ...gax.CallOption) *PolicyBindingIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).SearchTargetPolicyBindings[0:len((*c.CallOptions).SearchTargetPolicyBindings):len((*c.CallOptions).SearchTargetPolicyBindings)], opts...)
	it := &PolicyBindingIterator{}
	req = proto.Clone(req).(*iampb.SearchTargetPolicyBindingsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*iampb.PolicyBinding, string, error) {
		resp := &iampb.SearchTargetPolicyBindingsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.policyBindingsClient.SearchTargetPolicyBindings, req, settings.GRPC, c.logger, "SearchTargetPolicyBindings")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetPolicyBindings(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *policyBindingsGRPCClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetOperation[0:len((*c.CallOptions).GetOperation):len((*c.CallOptions).GetOperation)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.operationsClient.GetOperation, req, settings.GRPC, c.logger, "GetOperation")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// CreatePolicyBinding creates a policy binding and returns a long-running operation.
// Callers will need the IAM permissions on both the policy and target.
// Once the binding is created, the policy is applied to the target.
func (c *policyBindingsRESTClient) CreatePolicyBinding(ctx context.Context, req *iampb.CreatePolicyBindingRequest, opts ...gax.CallOption) (*CreatePolicyBindingOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetPolicyBinding()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v3/%v/policyBindings", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("policyBindingId", fmt.Sprintf("%v", req.GetPolicyBindingId()))
	if req.GetValidateOnly() {
		params.Add("validateOnly", fmt.Sprintf("%v", req.GetValidateOnly()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreatePolicyBinding")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v3/%s", resp.GetName())
	return &CreatePolicyBindingOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// GetPolicyBinding gets a policy binding.
func (c *policyBindingsRESTClient) GetPolicyBinding(ctx context.Context, req *iampb.GetPolicyBindingRequest, opts ...gax.CallOption) (*iampb.PolicyBinding, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v3/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetPolicyBinding[0:len((*c.CallOptions).GetPolicyBinding):len((*c.CallOptions).GetPolicyBinding)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &iampb.PolicyBinding{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetPolicyBinding")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// UpdatePolicyBinding updates a policy binding and returns a long-running operation.
// Callers will need the IAM permissions on the policy and target in the
// binding to update, and the IAM permission to remove the existing policy
// from the binding. Target is immutable and cannot be updated. Once the
// binding is updated, the new policy is applied to the target.
func (c *policyBindingsRESTClient) UpdatePolicyBinding(ctx context.Context, req *iampb.UpdatePolicyBindingRequest, opts ...gax.CallOption) (*UpdatePolicyBindingOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetPolicyBinding()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v3/%v", req.GetPolicyBinding().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}
	if req.GetValidateOnly() {
		params.Add("validateOnly", fmt.Sprintf("%v", req.GetValidateOnly()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "policy_binding.name", url.QueryEscape(req.GetPolicyBinding().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdatePolicyBinding")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v3/%s", resp.GetName())
	return &UpdatePolicyBindingOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeletePolicyBinding deletes a policy binding and returns a long-running operation.
// Callers will need the IAM permissions on both the policy and target.
// Once the binding is deleted, the policy no longer applies to the target.
func (c *policyBindingsRESTClient) DeletePolicyBinding(ctx context.Context, req *iampb.DeletePolicyBindingRequest, opts ...gax.CallOption) (*DeletePolicyBindingOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v3/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetEtag() != "" {
		params.Add("etag", fmt.Sprintf("%v", req.GetEtag()))
	}
	if req.GetValidateOnly() {
		params.Add("validateOnly", fmt.Sprintf("%v", req.GetValidateOnly()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeletePolicyBinding")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v3/%s", resp.GetName())
	return &DeletePolicyBindingOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ListPolicyBindings lists policy bindings.
func (c *policyBindingsRESTClient) ListPolicyBindings(ctx context.Context, req *iampb.ListPolicyBindingsRequest, opts ...gax.CallOption) *PolicyBindingIterator {
	it := &PolicyBindingIterator{}
	req = proto.Clone(req).(*iampb.ListPolicyBindingsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*iampb.PolicyBinding, string, error) {
		resp := &iampb.ListPolicyBindingsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v3/%v/policyBindings", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListPolicyBindings")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetPolicyBindings(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// SearchTargetPolicyBindings search policy bindings by target. Returns all policy binding objects bound
// directly to target.
func (c *policyBindingsRESTClient) SearchTargetPolicyBindings(ctx context.Context, req *iampb.SearchTargetPolicyBindingsRequest, opts ...gax.CallOption) *PolicyBindingIterator {
	it := &PolicyBindingIterator{}
	req = proto.Clone(req).(*iampb.SearchTargetPolicyBindingsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*iampb.PolicyBinding, string, error) {
		resp := &iampb.SearchTargetPolicyBindingsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v3/%v/policyBindings:searchTargetPolicyBindings", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}
		params.Add("target", fmt.Sprintf("%v", req.GetTarget()))

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "SearchTargetPolicyBindings")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetPolicyBindings(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetOperation is a utility method from google.longrunning.Operations.
func (c *policyBindingsRESTClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v3/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetOperation[0:len((*c.CallOptions).GetOperation):len((*c.CallOptions).GetOperation)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetOperation")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreatePolicyBindingOperation returns a new CreatePolicyBindingOperation from a given name.
// The name must be that of a previously created CreatePolicyBindingOperation, possibly from a different process.
func (c *policyBindingsGRPCClient) CreatePolicyBindingOperation(name string) *CreatePolicyBindingOperation {
	return &CreatePolicyBindingOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreatePolicyBindingOperation returns a new CreatePolicyBindingOperation from a given name.
// The name must be that of a previously created CreatePolicyBindingOperation, possibly from a different process.
func (c *policyBindingsRESTClient) CreatePolicyBindingOperation(name string) *CreatePolicyBindingOperation {
	override := fmt.Sprintf("/v3/%s", name)
	return &CreatePolicyBindingOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeletePolicyBindingOperation returns a new DeletePolicyBindingOperation from a given name.
// The name must be that of a previously created DeletePolicyBindingOperation, possibly from a different process.
func (c *policyBindingsGRPCClient) DeletePolicyBindingOperation(name string) *DeletePolicyBindingOperation {
	return &DeletePolicyBindingOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeletePolicyBindingOperation returns a new DeletePolicyBindingOperation from a given name.
// The name must be that of a previously created DeletePolicyBindingOperation, possibly from a different process.
func (c *policyBindingsRESTClient) DeletePolicyBindingOperation(name string) *DeletePolicyBindingOperation {
	override := fmt.Sprintf("/v3/%s", name)
	return &DeletePolicyBindingOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdatePolicyBindingOperation returns a new UpdatePolicyBindingOperation from a given name.
// The name must be that of a previously created UpdatePolicyBindingOperation, possibly from a different process.
func (c *policyBindingsGRPCClient) UpdatePolicyBindingOperation(name string) *UpdatePolicyBindingOperation {
	return &UpdatePolicyBindingOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdatePolicyBindingOperation returns a new UpdatePolicyBindingOperation from a given name.
// The name must be that of a previously created UpdatePolicyBindingOperation, possibly from a different process.
func (c *policyBindingsRESTClient) UpdatePolicyBindingOperation(name string) *UpdatePolicyBindingOperation {
	override := fmt.Sprintf("/v3/%s", name)
	return &UpdatePolicyBindingOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}
