// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        v4.25.3
// source: google/cloud/metastore/v1alpha/metastore_federation.proto

package metastorepb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The current state of the federation.
type Federation_State int32

const (
	// The state of the metastore federation is unknown.
	Federation_STATE_UNSPECIFIED Federation_State = 0
	// The metastore federation is in the process of being created.
	Federation_CREATING Federation_State = 1
	// The metastore federation is running and ready to serve queries.
	Federation_ACTIVE Federation_State = 2
	// The metastore federation is being updated. It remains usable but cannot
	// accept additional update requests or be deleted at this time.
	Federation_UPDATING Federation_State = 3
	// The metastore federation is undergoing deletion. It cannot be used.
	Federation_DELETING Federation_State = 4
	// The metastore federation has encountered an error and cannot be used. The
	// metastore federation should be deleted.
	Federation_ERROR Federation_State = 5
)

// Enum value maps for Federation_State.
var (
	Federation_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "ACTIVE",
		3: "UPDATING",
		4: "DELETING",
		5: "ERROR",
	}
	Federation_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"ACTIVE":            2,
		"UPDATING":          3,
		"DELETING":          4,
		"ERROR":             5,
	}
)

func (x Federation_State) Enum() *Federation_State {
	p := new(Federation_State)
	*p = x
	return p
}

func (x Federation_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Federation_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_metastore_v1alpha_metastore_federation_proto_enumTypes[0].Descriptor()
}

func (Federation_State) Type() protoreflect.EnumType {
	return &file_google_cloud_metastore_v1alpha_metastore_federation_proto_enumTypes[0]
}

func (x Federation_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Federation_State.Descriptor instead.
func (Federation_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_federation_proto_rawDescGZIP(), []int{0, 0}
}

// The type of the backend metastore.
type BackendMetastore_MetastoreType int32

const (
	// The metastore type is not set.
	BackendMetastore_METASTORE_TYPE_UNSPECIFIED BackendMetastore_MetastoreType = 0
	// The backend metastore is Dataplex.
	BackendMetastore_DATAPLEX BackendMetastore_MetastoreType = 1
	// The backend metastore is BigQuery.
	BackendMetastore_BIGQUERY BackendMetastore_MetastoreType = 2
	// The backend metastore is Dataproc Metastore.
	BackendMetastore_DATAPROC_METASTORE BackendMetastore_MetastoreType = 3
)

// Enum value maps for BackendMetastore_MetastoreType.
var (
	BackendMetastore_MetastoreType_name = map[int32]string{
		0: "METASTORE_TYPE_UNSPECIFIED",
		1: "DATAPLEX",
		2: "BIGQUERY",
		3: "DATAPROC_METASTORE",
	}
	BackendMetastore_MetastoreType_value = map[string]int32{
		"METASTORE_TYPE_UNSPECIFIED": 0,
		"DATAPLEX":                   1,
		"BIGQUERY":                   2,
		"DATAPROC_METASTORE":         3,
	}
)

func (x BackendMetastore_MetastoreType) Enum() *BackendMetastore_MetastoreType {
	p := new(BackendMetastore_MetastoreType)
	*p = x
	return p
}

func (x BackendMetastore_MetastoreType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackendMetastore_MetastoreType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_metastore_v1alpha_metastore_federation_proto_enumTypes[1].Descriptor()
}

func (BackendMetastore_MetastoreType) Type() protoreflect.EnumType {
	return &file_google_cloud_metastore_v1alpha_metastore_federation_proto_enumTypes[1]
}

func (x BackendMetastore_MetastoreType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackendMetastore_MetastoreType.Descriptor instead.
func (BackendMetastore_MetastoreType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_federation_proto_rawDescGZIP(), []int{1, 0}
}

// Represents a federation of multiple backend metastores.
type Federation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. The relative resource name of the federation, of the
	// form:
	// projects/{project_number}/locations/{location_id}/federations/{federation_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The time when the metastore federation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time when the metastore federation was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// User-defined labels for the metastore federation.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Immutable. The Apache Hive metastore version of the federation. All backend
	// metastore versions must be compatible with the federation version.
	Version string `protobuf:"bytes,5,opt,name=version,proto3" json:"version,omitempty"`
	// A map from `BackendMetastore` rank to `BackendMetastore`s from which the
	// federation service serves metadata at query time. The map key represents
	// the order in which `BackendMetastore`s should be evaluated to resolve
	// database names at query time and should be greater than or equal to zero. A
	// `BackendMetastore` with a lower number will be evaluated before a
	// `BackendMetastore` with a higher number.
	BackendMetastores map[int32]*BackendMetastore `protobuf:"bytes,6,rep,name=backend_metastores,json=backendMetastores,proto3" json:"backend_metastores,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. The federation endpoint.
	EndpointUri string `protobuf:"bytes,7,opt,name=endpoint_uri,json=endpointUri,proto3" json:"endpoint_uri,omitempty"`
	// Output only. The current state of the federation.
	State Federation_State `protobuf:"varint,8,opt,name=state,proto3,enum=google.cloud.metastore.v1alpha.Federation_State" json:"state,omitempty"`
	// Output only. Additional information about the current state of the
	// metastore federation, if available.
	StateMessage string `protobuf:"bytes,9,opt,name=state_message,json=stateMessage,proto3" json:"state_message,omitempty"`
	// Output only. The globally unique resource identifier of the metastore
	// federation.
	Uid string `protobuf:"bytes,10,opt,name=uid,proto3" json:"uid,omitempty"`
}

func (x *Federation) Reset() {
	*x = Federation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_metastore_v1alpha_metastore_federation_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Federation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Federation) ProtoMessage() {}

func (x *Federation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_metastore_v1alpha_metastore_federation_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Federation.ProtoReflect.Descriptor instead.
func (*Federation) Descriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_federation_proto_rawDescGZIP(), []int{0}
}

func (x *Federation) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Federation) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Federation) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Federation) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Federation) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *Federation) GetBackendMetastores() map[int32]*BackendMetastore {
	if x != nil {
		return x.BackendMetastores
	}
	return nil
}

func (x *Federation) GetEndpointUri() string {
	if x != nil {
		return x.EndpointUri
	}
	return ""
}

func (x *Federation) GetState() Federation_State {
	if x != nil {
		return x.State
	}
	return Federation_STATE_UNSPECIFIED
}

func (x *Federation) GetStateMessage() string {
	if x != nil {
		return x.StateMessage
	}
	return ""
}

func (x *Federation) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

// Represents a backend metastore for the federation.
type BackendMetastore struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The relative resource name of the metastore that is being federated.
	// The formats of the relative resource names for the currently supported
	// metastores are listed below:
	//
	// * BigQuery
	//   - `projects/{project_id}`
	//
	// * Dataproc Metastore
	//   - `projects/{project_id}/locations/{location}/services/{service_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The type of the backend metastore.
	MetastoreType BackendMetastore_MetastoreType `protobuf:"varint,2,opt,name=metastore_type,json=metastoreType,proto3,enum=google.cloud.metastore.v1alpha.BackendMetastore_MetastoreType" json:"metastore_type,omitempty"`
}

func (x *BackendMetastore) Reset() {
	*x = BackendMetastore{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_metastore_v1alpha_metastore_federation_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BackendMetastore) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackendMetastore) ProtoMessage() {}

func (x *BackendMetastore) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_metastore_v1alpha_metastore_federation_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackendMetastore.ProtoReflect.Descriptor instead.
func (*BackendMetastore) Descriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_federation_proto_rawDescGZIP(), []int{1}
}

func (x *BackendMetastore) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *BackendMetastore) GetMetastoreType() BackendMetastore_MetastoreType {
	if x != nil {
		return x.MetastoreType
	}
	return BackendMetastore_METASTORE_TYPE_UNSPECIFIED
}

// Request message for ListFederations.
type ListFederationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The relative resource name of the location of metastore
	// federations to list, in the following form:
	// `projects/{project_number}/locations/{location_id}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of federations to return. The response may
	// contain less than the maximum number. If unspecified, no more than 500
	// services are returned. The maximum value is 1000; values above 1000 are
	// changed to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous ListFederationServices
	// call. Provide this token to retrieve the subsequent page.
	//
	// To retrieve the first page, supply an empty page token.
	//
	// When paginating, other parameters provided to
	// ListFederationServices must match the call that provided the
	// page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The filter to apply to list results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Specify the ordering of results as described in [Sorting
	// Order](https://cloud.google.com/apis/design/design_patterns#sorting_order).
	// If not specified, the results will be sorted in the default order.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListFederationsRequest) Reset() {
	*x = ListFederationsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_metastore_v1alpha_metastore_federation_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListFederationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFederationsRequest) ProtoMessage() {}

func (x *ListFederationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_metastore_v1alpha_metastore_federation_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFederationsRequest.ProtoReflect.Descriptor instead.
func (*ListFederationsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_federation_proto_rawDescGZIP(), []int{2}
}

func (x *ListFederationsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListFederationsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListFederationsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListFederationsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListFederationsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for ListFederations
type ListFederationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The services in the specified location.
	Federations []*Federation `protobuf:"bytes,1,rep,name=federations,proto3" json:"federations,omitempty"`
	// A token that can be sent as `page_token` to retrieve the next page. If this
	// field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListFederationsResponse) Reset() {
	*x = ListFederationsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_metastore_v1alpha_metastore_federation_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListFederationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFederationsResponse) ProtoMessage() {}

func (x *ListFederationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_metastore_v1alpha_metastore_federation_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFederationsResponse.ProtoReflect.Descriptor instead.
func (*ListFederationsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_federation_proto_rawDescGZIP(), []int{3}
}

func (x *ListFederationsResponse) GetFederations() []*Federation {
	if x != nil {
		return x.Federations
	}
	return nil
}

func (x *ListFederationsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListFederationsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for GetFederation.
type GetFederationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The relative resource name of the metastore federation to
	// retrieve, in the following form:
	//
	// `projects/{project_number}/locations/{location_id}/federations/{federation_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetFederationRequest) Reset() {
	*x = GetFederationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_metastore_v1alpha_metastore_federation_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetFederationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFederationRequest) ProtoMessage() {}

func (x *GetFederationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_metastore_v1alpha_metastore_federation_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFederationRequest.ProtoReflect.Descriptor instead.
func (*GetFederationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_federation_proto_rawDescGZIP(), []int{4}
}

func (x *GetFederationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for CreateFederation.
type CreateFederationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The relative resource name of the location in which to create a
	// federation service, in the following form:
	//
	// `projects/{project_number}/locations/{location_id}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ID of the metastore federation, which is used as the final
	// component of the metastore federation's name.
	//
	// This value must be between 2 and 63 characters long inclusive, begin with a
	// letter, end with a letter or number, and consist of alpha-numeric
	// ASCII characters or hyphens.
	FederationId string `protobuf:"bytes,2,opt,name=federation_id,json=federationId,proto3" json:"federation_id,omitempty"`
	// Required. The Metastore Federation to create. The `name` field is
	// ignored. The ID of the created metastore federation must be
	// provided in the request's `federation_id` field.
	Federation *Federation `protobuf:"bytes,3,opt,name=federation,proto3" json:"federation,omitempty"`
	// Optional. A request ID. Specify a unique request ID to allow the server to
	// ignore the request if it has completed. The server will ignore subsequent
	// requests that provide a duplicate request ID for at least 60 minutes after
	// the first request.
	//
	// For example, if an initial request times out, followed by another request
	// with the same request ID, the server ignores the second request to prevent
	// the creation of duplicate commitments.
	//
	// The request ID must be a valid
	// [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format)
	// A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateFederationRequest) Reset() {
	*x = CreateFederationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_metastore_v1alpha_metastore_federation_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateFederationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateFederationRequest) ProtoMessage() {}

func (x *CreateFederationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_metastore_v1alpha_metastore_federation_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateFederationRequest.ProtoReflect.Descriptor instead.
func (*CreateFederationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_federation_proto_rawDescGZIP(), []int{5}
}

func (x *CreateFederationRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateFederationRequest) GetFederationId() string {
	if x != nil {
		return x.FederationId
	}
	return ""
}

func (x *CreateFederationRequest) GetFederation() *Federation {
	if x != nil {
		return x.Federation
	}
	return nil
}

func (x *CreateFederationRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for UpdateFederation.
type UpdateFederationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A field mask used to specify the fields to be overwritten in the
	// metastore federation resource by the update.
	// Fields specified in the `update_mask` are relative to the resource (not
	// to the full request). A field is overwritten if it is in the mask.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The metastore federation to update. The server only merges fields
	// in the service if they are specified in `update_mask`.
	//
	// The metastore federation's `name` field is used to identify the
	// metastore service to be updated.
	Federation *Federation `protobuf:"bytes,2,opt,name=federation,proto3" json:"federation,omitempty"`
	// Optional. A request ID. Specify a unique request ID to allow the server to
	// ignore the request if it has completed. The server will ignore subsequent
	// requests that provide a duplicate request ID for at least 60 minutes after
	// the first request.
	//
	// For example, if an initial request times out, followed by another request
	// with the same request ID, the server ignores the second request to prevent
	// the creation of duplicate commitments.
	//
	// The request ID must be a valid
	// [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format)
	// A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdateFederationRequest) Reset() {
	*x = UpdateFederationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_metastore_v1alpha_metastore_federation_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateFederationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateFederationRequest) ProtoMessage() {}

func (x *UpdateFederationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_metastore_v1alpha_metastore_federation_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateFederationRequest.ProtoReflect.Descriptor instead.
func (*UpdateFederationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_federation_proto_rawDescGZIP(), []int{6}
}

func (x *UpdateFederationRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateFederationRequest) GetFederation() *Federation {
	if x != nil {
		return x.Federation
	}
	return nil
}

func (x *UpdateFederationRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for DeleteFederation.
type DeleteFederationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The relative resource name of the metastore federation to delete,
	// in the following form:
	//
	// `projects/{project_number}/locations/{location_id}/federations/{federation_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. A request ID. Specify a unique request ID to allow the server to
	// ignore the request if it has completed. The server will ignore subsequent
	// requests that provide a duplicate request ID for at least 60 minutes after
	// the first request.
	//
	// For example, if an initial request times out, followed by another request
	// with the same request ID, the server ignores the second request to prevent
	// the creation of duplicate commitments.
	//
	// The request ID must be a valid
	// [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format)
	// A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteFederationRequest) Reset() {
	*x = DeleteFederationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_metastore_v1alpha_metastore_federation_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteFederationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteFederationRequest) ProtoMessage() {}

func (x *DeleteFederationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_metastore_v1alpha_metastore_federation_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteFederationRequest.ProtoReflect.Descriptor instead.
func (*DeleteFederationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_federation_proto_rawDescGZIP(), []int{7}
}

func (x *DeleteFederationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteFederationRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

var File_google_cloud_metastore_v1alpha_metastore_federation_proto protoreflect.FileDescriptor

var file_google_cloud_metastore_v1alpha_metastore_federation_proto_rawDesc = []byte{
	0x0a, 0x39, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d,
	0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2f, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x66, 0x65, 0x64, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x1a, 0x1c, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d, 0x65, 0x74,
	0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x6d,
	0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0xc0, 0x07, 0x0a, 0x0a, 0x46, 0x65, 0x64, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x4e, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x46, 0x65, 0x64, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12,
	0x1d, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x70,
	0x0a, 0x12, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46, 0x65, 0x64, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x4d, 0x65,
	0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x11, 0x62,
	0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x4d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73,
	0x12, 0x26, 0x0a, 0x0c, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x75, 0x72, 0x69,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x65, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x55, 0x72, 0x69, 0x12, 0x4b, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46, 0x65, 0x64, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0c, 0x73, 0x74, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12,
	0x15, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x03, 0x75, 0x69, 0x64, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x1a, 0x76, 0x0a, 0x16, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x4d, 0x65, 0x74, 0x61,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x46, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x61,
	0x63, 0x6b, 0x65, 0x6e, 0x64, 0x4d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x5f, 0x0a, 0x05, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45,
	0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56,
	0x45, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x50, 0x44, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10,
	0x03, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12,
	0x09, 0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x05, 0x3a, 0x6a, 0xea, 0x41, 0x67, 0x0a,
	0x23, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x65, 0x64, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x66, 0x65,
	0x64, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x66, 0x65, 0x64, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x22, 0xf2, 0x01, 0x0a, 0x10, 0x42, 0x61, 0x63, 0x6b, 0x65,
	0x6e, 0x64, 0x4d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x65, 0x0a, 0x0e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64,
	0x4d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0d, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x54, 0x79, 0x70, 0x65, 0x22, 0x63, 0x0a, 0x0d, 0x4d, 0x65, 0x74, 0x61, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1e, 0x0a, 0x1a, 0x4d, 0x45, 0x54, 0x41, 0x53,
	0x54, 0x4f, 0x52, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x41, 0x54, 0x41, 0x50,
	0x4c, 0x45, 0x58, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x42, 0x49, 0x47, 0x51, 0x55, 0x45, 0x52,
	0x59, 0x10, 0x02, 0x12, 0x16, 0x0a, 0x12, 0x44, 0x41, 0x54, 0x41, 0x50, 0x52, 0x4f, 0x43, 0x5f,
	0x4d, 0x45, 0x54, 0x41, 0x53, 0x54, 0x4f, 0x52, 0x45, 0x10, 0x03, 0x22, 0xe0, 0x01, 0x0a, 0x16,
	0x4c, 0x69, 0x73, 0x74, 0x46, 0x65, 0x64, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x12, 0x23,
	0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x65, 0x64, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a,
	0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e,
	0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xb1,
	0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x65, 0x64, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4c, 0x0a, 0x0b, 0x66, 0x65,
	0x64, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x46, 0x65, 0x64, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x66, 0x65, 0x64,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62,
	0x6c, 0x65, 0x22, 0x57, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x46, 0x65, 0x64, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25,
	0x0a, 0x23, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x65, 0x64, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xfd, 0x01, 0x0a, 0x17,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x65, 0x64, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x12,
	0x23, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x65, 0x64, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x28, 0x0a, 0x0d,
	0x66, 0x65, 0x64, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x66, 0x65, 0x64, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x4f, 0x0a, 0x0a, 0x66, 0x65, 0x64, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46, 0x65, 0x64, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x66, 0x65, 0x64,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xd0, 0x01, 0x0a, 0x17,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x65, 0x64, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x4f, 0x0a, 0x0a, 0x66, 0x65, 0x64,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74,
	0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46,
	0x65, 0x64, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a,
	0x66, 0x65, 0x64, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x7e,
	0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x65, 0x64, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a,
	0x23, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x65, 0x64, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x32, 0xa7,
	0x0a, 0x0a, 0x1b, 0x44, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x46, 0x65, 0x64, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0xc9,
	0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x65, 0x64, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x65, 0x64, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x46, 0x65, 0x64, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x45, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x36, 0x12, 0x34, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66,
	0x65, 0x64, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xb6, 0x01, 0x0a, 0x0d, 0x47,
	0x65, 0x74, 0x46, 0x65, 0x64, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x65,
	0x74, 0x46, 0x65, 0x64, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x46, 0x65, 0x64, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x43,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36, 0x12, 0x34, 0x2f,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x65, 0x64, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0x98, 0x02, 0x0a, 0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x65,
	0x64, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x46, 0x65, 0x64, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0xab, 0x01, 0xca, 0x41, 0x3e, 0x0a, 0x0a, 0x46, 0x65, 0x64, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x1f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x66, 0x65,
	0x64, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x66, 0x65, 0x64, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x3a, 0x0a, 0x66, 0x65,
	0x64, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x34, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x66, 0x65, 0x64, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x9a,
	0x02, 0x0a, 0x10, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x65, 0x64, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x65, 0x64, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xad, 0x01, 0xca, 0x41,
	0x3e, 0x0a, 0x0a, 0x46, 0x65, 0x64, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x30, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda,
	0x41, 0x16, 0x66, 0x65, 0x64, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4d, 0x3a, 0x0a,
	0x66, 0x65, 0x64, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x32, 0x3f, 0x2f, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x66, 0x65, 0x64, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x65, 0x64,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xfc, 0x01, 0x0a, 0x10,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x65, 0x64, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x65, 0x64, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8f, 0x01, 0xca, 0x41, 0x49, 0x0a, 0x15,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x36, 0x2a, 0x34, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x65, 0x64, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x1a, 0x4c, 0xca, 0x41, 0x18, 0x6d,
	0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a,
	0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x82, 0x01, 0x0a, 0x22, 0x63, 0x6f, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65,
	0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x42,
	0x18, 0x4d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x46, 0x65, 0x64, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x40, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f,
	0x2f, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x70,
	0x62, 0x3b, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x70, 0x62, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_metastore_v1alpha_metastore_federation_proto_rawDescOnce sync.Once
	file_google_cloud_metastore_v1alpha_metastore_federation_proto_rawDescData = file_google_cloud_metastore_v1alpha_metastore_federation_proto_rawDesc
)

func file_google_cloud_metastore_v1alpha_metastore_federation_proto_rawDescGZIP() []byte {
	file_google_cloud_metastore_v1alpha_metastore_federation_proto_rawDescOnce.Do(func() {
		file_google_cloud_metastore_v1alpha_metastore_federation_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_metastore_v1alpha_metastore_federation_proto_rawDescData)
	})
	return file_google_cloud_metastore_v1alpha_metastore_federation_proto_rawDescData
}

var file_google_cloud_metastore_v1alpha_metastore_federation_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_metastore_v1alpha_metastore_federation_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_google_cloud_metastore_v1alpha_metastore_federation_proto_goTypes = []any{
	(Federation_State)(0),               // 0: google.cloud.metastore.v1alpha.Federation.State
	(BackendMetastore_MetastoreType)(0), // 1: google.cloud.metastore.v1alpha.BackendMetastore.MetastoreType
	(*Federation)(nil),                  // 2: google.cloud.metastore.v1alpha.Federation
	(*BackendMetastore)(nil),            // 3: google.cloud.metastore.v1alpha.BackendMetastore
	(*ListFederationsRequest)(nil),      // 4: google.cloud.metastore.v1alpha.ListFederationsRequest
	(*ListFederationsResponse)(nil),     // 5: google.cloud.metastore.v1alpha.ListFederationsResponse
	(*GetFederationRequest)(nil),        // 6: google.cloud.metastore.v1alpha.GetFederationRequest
	(*CreateFederationRequest)(nil),     // 7: google.cloud.metastore.v1alpha.CreateFederationRequest
	(*UpdateFederationRequest)(nil),     // 8: google.cloud.metastore.v1alpha.UpdateFederationRequest
	(*DeleteFederationRequest)(nil),     // 9: google.cloud.metastore.v1alpha.DeleteFederationRequest
	nil,                                 // 10: google.cloud.metastore.v1alpha.Federation.LabelsEntry
	nil,                                 // 11: google.cloud.metastore.v1alpha.Federation.BackendMetastoresEntry
	(*timestamppb.Timestamp)(nil),       // 12: google.protobuf.Timestamp
	(*fieldmaskpb.FieldMask)(nil),       // 13: google.protobuf.FieldMask
	(*longrunningpb.Operation)(nil),     // 14: google.longrunning.Operation
}
var file_google_cloud_metastore_v1alpha_metastore_federation_proto_depIdxs = []int32{
	12, // 0: google.cloud.metastore.v1alpha.Federation.create_time:type_name -> google.protobuf.Timestamp
	12, // 1: google.cloud.metastore.v1alpha.Federation.update_time:type_name -> google.protobuf.Timestamp
	10, // 2: google.cloud.metastore.v1alpha.Federation.labels:type_name -> google.cloud.metastore.v1alpha.Federation.LabelsEntry
	11, // 3: google.cloud.metastore.v1alpha.Federation.backend_metastores:type_name -> google.cloud.metastore.v1alpha.Federation.BackendMetastoresEntry
	0,  // 4: google.cloud.metastore.v1alpha.Federation.state:type_name -> google.cloud.metastore.v1alpha.Federation.State
	1,  // 5: google.cloud.metastore.v1alpha.BackendMetastore.metastore_type:type_name -> google.cloud.metastore.v1alpha.BackendMetastore.MetastoreType
	2,  // 6: google.cloud.metastore.v1alpha.ListFederationsResponse.federations:type_name -> google.cloud.metastore.v1alpha.Federation
	2,  // 7: google.cloud.metastore.v1alpha.CreateFederationRequest.federation:type_name -> google.cloud.metastore.v1alpha.Federation
	13, // 8: google.cloud.metastore.v1alpha.UpdateFederationRequest.update_mask:type_name -> google.protobuf.FieldMask
	2,  // 9: google.cloud.metastore.v1alpha.UpdateFederationRequest.federation:type_name -> google.cloud.metastore.v1alpha.Federation
	3,  // 10: google.cloud.metastore.v1alpha.Federation.BackendMetastoresEntry.value:type_name -> google.cloud.metastore.v1alpha.BackendMetastore
	4,  // 11: google.cloud.metastore.v1alpha.DataprocMetastoreFederation.ListFederations:input_type -> google.cloud.metastore.v1alpha.ListFederationsRequest
	6,  // 12: google.cloud.metastore.v1alpha.DataprocMetastoreFederation.GetFederation:input_type -> google.cloud.metastore.v1alpha.GetFederationRequest
	7,  // 13: google.cloud.metastore.v1alpha.DataprocMetastoreFederation.CreateFederation:input_type -> google.cloud.metastore.v1alpha.CreateFederationRequest
	8,  // 14: google.cloud.metastore.v1alpha.DataprocMetastoreFederation.UpdateFederation:input_type -> google.cloud.metastore.v1alpha.UpdateFederationRequest
	9,  // 15: google.cloud.metastore.v1alpha.DataprocMetastoreFederation.DeleteFederation:input_type -> google.cloud.metastore.v1alpha.DeleteFederationRequest
	5,  // 16: google.cloud.metastore.v1alpha.DataprocMetastoreFederation.ListFederations:output_type -> google.cloud.metastore.v1alpha.ListFederationsResponse
	2,  // 17: google.cloud.metastore.v1alpha.DataprocMetastoreFederation.GetFederation:output_type -> google.cloud.metastore.v1alpha.Federation
	14, // 18: google.cloud.metastore.v1alpha.DataprocMetastoreFederation.CreateFederation:output_type -> google.longrunning.Operation
	14, // 19: google.cloud.metastore.v1alpha.DataprocMetastoreFederation.UpdateFederation:output_type -> google.longrunning.Operation
	14, // 20: google.cloud.metastore.v1alpha.DataprocMetastoreFederation.DeleteFederation:output_type -> google.longrunning.Operation
	16, // [16:21] is the sub-list for method output_type
	11, // [11:16] is the sub-list for method input_type
	11, // [11:11] is the sub-list for extension type_name
	11, // [11:11] is the sub-list for extension extendee
	0,  // [0:11] is the sub-list for field type_name
}

func init() { file_google_cloud_metastore_v1alpha_metastore_federation_proto_init() }
func file_google_cloud_metastore_v1alpha_metastore_federation_proto_init() {
	if File_google_cloud_metastore_v1alpha_metastore_federation_proto != nil {
		return
	}
	file_google_cloud_metastore_v1alpha_metastore_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_metastore_v1alpha_metastore_federation_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*Federation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_metastore_v1alpha_metastore_federation_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*BackendMetastore); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_metastore_v1alpha_metastore_federation_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*ListFederationsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_metastore_v1alpha_metastore_federation_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*ListFederationsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_metastore_v1alpha_metastore_federation_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*GetFederationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_metastore_v1alpha_metastore_federation_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*CreateFederationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_metastore_v1alpha_metastore_federation_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*UpdateFederationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_metastore_v1alpha_metastore_federation_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*DeleteFederationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_metastore_v1alpha_metastore_federation_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_metastore_v1alpha_metastore_federation_proto_goTypes,
		DependencyIndexes: file_google_cloud_metastore_v1alpha_metastore_federation_proto_depIdxs,
		EnumInfos:         file_google_cloud_metastore_v1alpha_metastore_federation_proto_enumTypes,
		MessageInfos:      file_google_cloud_metastore_v1alpha_metastore_federation_proto_msgTypes,
	}.Build()
	File_google_cloud_metastore_v1alpha_metastore_federation_proto = out.File
	file_google_cloud_metastore_v1alpha_metastore_federation_proto_rawDesc = nil
	file_google_cloud_metastore_v1alpha_metastore_federation_proto_goTypes = nil
	file_google_cloud_metastore_v1alpha_metastore_federation_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// DataprocMetastoreFederationClient is the client API for DataprocMetastoreFederation service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DataprocMetastoreFederationClient interface {
	// Lists federations in a project and location.
	ListFederations(ctx context.Context, in *ListFederationsRequest, opts ...grpc.CallOption) (*ListFederationsResponse, error)
	// Gets the details of a single federation.
	GetFederation(ctx context.Context, in *GetFederationRequest, opts ...grpc.CallOption) (*Federation, error)
	// Creates a metastore federation in a project and location.
	CreateFederation(ctx context.Context, in *CreateFederationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the fields of a federation.
	UpdateFederation(ctx context.Context, in *UpdateFederationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single federation.
	DeleteFederation(ctx context.Context, in *DeleteFederationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type dataprocMetastoreFederationClient struct {
	cc grpc.ClientConnInterface
}

func NewDataprocMetastoreFederationClient(cc grpc.ClientConnInterface) DataprocMetastoreFederationClient {
	return &dataprocMetastoreFederationClient{cc}
}

func (c *dataprocMetastoreFederationClient) ListFederations(ctx context.Context, in *ListFederationsRequest, opts ...grpc.CallOption) (*ListFederationsResponse, error) {
	out := new(ListFederationsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.metastore.v1alpha.DataprocMetastoreFederation/ListFederations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataprocMetastoreFederationClient) GetFederation(ctx context.Context, in *GetFederationRequest, opts ...grpc.CallOption) (*Federation, error) {
	out := new(Federation)
	err := c.cc.Invoke(ctx, "/google.cloud.metastore.v1alpha.DataprocMetastoreFederation/GetFederation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataprocMetastoreFederationClient) CreateFederation(ctx context.Context, in *CreateFederationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.metastore.v1alpha.DataprocMetastoreFederation/CreateFederation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataprocMetastoreFederationClient) UpdateFederation(ctx context.Context, in *UpdateFederationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.metastore.v1alpha.DataprocMetastoreFederation/UpdateFederation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataprocMetastoreFederationClient) DeleteFederation(ctx context.Context, in *DeleteFederationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.metastore.v1alpha.DataprocMetastoreFederation/DeleteFederation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DataprocMetastoreFederationServer is the server API for DataprocMetastoreFederation service.
type DataprocMetastoreFederationServer interface {
	// Lists federations in a project and location.
	ListFederations(context.Context, *ListFederationsRequest) (*ListFederationsResponse, error)
	// Gets the details of a single federation.
	GetFederation(context.Context, *GetFederationRequest) (*Federation, error)
	// Creates a metastore federation in a project and location.
	CreateFederation(context.Context, *CreateFederationRequest) (*longrunningpb.Operation, error)
	// Updates the fields of a federation.
	UpdateFederation(context.Context, *UpdateFederationRequest) (*longrunningpb.Operation, error)
	// Deletes a single federation.
	DeleteFederation(context.Context, *DeleteFederationRequest) (*longrunningpb.Operation, error)
}

// UnimplementedDataprocMetastoreFederationServer can be embedded to have forward compatible implementations.
type UnimplementedDataprocMetastoreFederationServer struct {
}

func (*UnimplementedDataprocMetastoreFederationServer) ListFederations(context.Context, *ListFederationsRequest) (*ListFederationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListFederations not implemented")
}
func (*UnimplementedDataprocMetastoreFederationServer) GetFederation(context.Context, *GetFederationRequest) (*Federation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFederation not implemented")
}
func (*UnimplementedDataprocMetastoreFederationServer) CreateFederation(context.Context, *CreateFederationRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateFederation not implemented")
}
func (*UnimplementedDataprocMetastoreFederationServer) UpdateFederation(context.Context, *UpdateFederationRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateFederation not implemented")
}
func (*UnimplementedDataprocMetastoreFederationServer) DeleteFederation(context.Context, *DeleteFederationRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteFederation not implemented")
}

func RegisterDataprocMetastoreFederationServer(s *grpc.Server, srv DataprocMetastoreFederationServer) {
	s.RegisterService(&_DataprocMetastoreFederation_serviceDesc, srv)
}

func _DataprocMetastoreFederation_ListFederations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFederationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataprocMetastoreFederationServer).ListFederations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.metastore.v1alpha.DataprocMetastoreFederation/ListFederations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataprocMetastoreFederationServer).ListFederations(ctx, req.(*ListFederationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataprocMetastoreFederation_GetFederation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFederationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataprocMetastoreFederationServer).GetFederation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.metastore.v1alpha.DataprocMetastoreFederation/GetFederation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataprocMetastoreFederationServer).GetFederation(ctx, req.(*GetFederationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataprocMetastoreFederation_CreateFederation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFederationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataprocMetastoreFederationServer).CreateFederation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.metastore.v1alpha.DataprocMetastoreFederation/CreateFederation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataprocMetastoreFederationServer).CreateFederation(ctx, req.(*CreateFederationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataprocMetastoreFederation_UpdateFederation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFederationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataprocMetastoreFederationServer).UpdateFederation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.metastore.v1alpha.DataprocMetastoreFederation/UpdateFederation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataprocMetastoreFederationServer).UpdateFederation(ctx, req.(*UpdateFederationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataprocMetastoreFederation_DeleteFederation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFederationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataprocMetastoreFederationServer).DeleteFederation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.metastore.v1alpha.DataprocMetastoreFederation/DeleteFederation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataprocMetastoreFederationServer).DeleteFederation(ctx, req.(*DeleteFederationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _DataprocMetastoreFederation_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.metastore.v1alpha.DataprocMetastoreFederation",
	HandlerType: (*DataprocMetastoreFederationServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListFederations",
			Handler:    _DataprocMetastoreFederation_ListFederations_Handler,
		},
		{
			MethodName: "GetFederation",
			Handler:    _DataprocMetastoreFederation_GetFederation_Handler,
		},
		{
			MethodName: "CreateFederation",
			Handler:    _DataprocMetastoreFederation_CreateFederation_Handler,
		},
		{
			MethodName: "UpdateFederation",
			Handler:    _DataprocMetastoreFederation_UpdateFederation_Handler,
		},
		{
			MethodName: "DeleteFederation",
			Handler:    _DataprocMetastoreFederation_DeleteFederation_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/metastore/v1alpha/metastore_federation.proto",
}
