// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.31.0
// 	protoc        v4.23.2
// source: google/storagetransfer/v1/transfer_types.proto

package storagetransferpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	code "google.golang.org/genproto/googleapis/rpc/code"
	date "google.golang.org/genproto/googleapis/type/date"
	timeofday "google.golang.org/genproto/googleapis/type/timeofday"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The authentication and authorization method used by the storage service.
type S3CompatibleMetadata_AuthMethod int32

const (
	// AuthMethod is not specified.
	S3CompatibleMetadata_AUTH_METHOD_UNSPECIFIED S3CompatibleMetadata_AuthMethod = 0
	// Auth requests with AWS SigV4.
	S3CompatibleMetadata_AUTH_METHOD_AWS_SIGNATURE_V4 S3CompatibleMetadata_AuthMethod = 1
	// Auth requests with AWS SigV2.
	S3CompatibleMetadata_AUTH_METHOD_AWS_SIGNATURE_V2 S3CompatibleMetadata_AuthMethod = 2
)

// Enum value maps for S3CompatibleMetadata_AuthMethod.
var (
	S3CompatibleMetadata_AuthMethod_name = map[int32]string{
		0: "AUTH_METHOD_UNSPECIFIED",
		1: "AUTH_METHOD_AWS_SIGNATURE_V4",
		2: "AUTH_METHOD_AWS_SIGNATURE_V2",
	}
	S3CompatibleMetadata_AuthMethod_value = map[string]int32{
		"AUTH_METHOD_UNSPECIFIED":      0,
		"AUTH_METHOD_AWS_SIGNATURE_V4": 1,
		"AUTH_METHOD_AWS_SIGNATURE_V2": 2,
	}
)

func (x S3CompatibleMetadata_AuthMethod) Enum() *S3CompatibleMetadata_AuthMethod {
	p := new(S3CompatibleMetadata_AuthMethod)
	*p = x
	return p
}

func (x S3CompatibleMetadata_AuthMethod) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (S3CompatibleMetadata_AuthMethod) Descriptor() protoreflect.EnumDescriptor {
	return file_google_storagetransfer_v1_transfer_types_proto_enumTypes[0].Descriptor()
}

func (S3CompatibleMetadata_AuthMethod) Type() protoreflect.EnumType {
	return &file_google_storagetransfer_v1_transfer_types_proto_enumTypes[0]
}

func (x S3CompatibleMetadata_AuthMethod) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use S3CompatibleMetadata_AuthMethod.Descriptor instead.
func (S3CompatibleMetadata_AuthMethod) EnumDescriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{10, 0}
}

// The request model of the API.
type S3CompatibleMetadata_RequestModel int32

const (
	// RequestModel is not specified.
	S3CompatibleMetadata_REQUEST_MODEL_UNSPECIFIED S3CompatibleMetadata_RequestModel = 0
	// Perform requests using Virtual Hosted Style.
	// Example: https://bucket-name.s3.region.amazonaws.com/key-name
	S3CompatibleMetadata_REQUEST_MODEL_VIRTUAL_HOSTED_STYLE S3CompatibleMetadata_RequestModel = 1
	// Perform requests using Path Style.
	// Example: https://s3.region.amazonaws.com/bucket-name/key-name
	S3CompatibleMetadata_REQUEST_MODEL_PATH_STYLE S3CompatibleMetadata_RequestModel = 2
)

// Enum value maps for S3CompatibleMetadata_RequestModel.
var (
	S3CompatibleMetadata_RequestModel_name = map[int32]string{
		0: "REQUEST_MODEL_UNSPECIFIED",
		1: "REQUEST_MODEL_VIRTUAL_HOSTED_STYLE",
		2: "REQUEST_MODEL_PATH_STYLE",
	}
	S3CompatibleMetadata_RequestModel_value = map[string]int32{
		"REQUEST_MODEL_UNSPECIFIED":          0,
		"REQUEST_MODEL_VIRTUAL_HOSTED_STYLE": 1,
		"REQUEST_MODEL_PATH_STYLE":           2,
	}
)

func (x S3CompatibleMetadata_RequestModel) Enum() *S3CompatibleMetadata_RequestModel {
	p := new(S3CompatibleMetadata_RequestModel)
	*p = x
	return p
}

func (x S3CompatibleMetadata_RequestModel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (S3CompatibleMetadata_RequestModel) Descriptor() protoreflect.EnumDescriptor {
	return file_google_storagetransfer_v1_transfer_types_proto_enumTypes[1].Descriptor()
}

func (S3CompatibleMetadata_RequestModel) Type() protoreflect.EnumType {
	return &file_google_storagetransfer_v1_transfer_types_proto_enumTypes[1]
}

func (x S3CompatibleMetadata_RequestModel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use S3CompatibleMetadata_RequestModel.Descriptor instead.
func (S3CompatibleMetadata_RequestModel) EnumDescriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{10, 1}
}

// The agent network protocol to access the storage service.
type S3CompatibleMetadata_NetworkProtocol int32

const (
	// NetworkProtocol is not specified.
	S3CompatibleMetadata_NETWORK_PROTOCOL_UNSPECIFIED S3CompatibleMetadata_NetworkProtocol = 0
	// Perform requests using HTTPS.
	S3CompatibleMetadata_NETWORK_PROTOCOL_HTTPS S3CompatibleMetadata_NetworkProtocol = 1
	// Not recommended: This sends data in clear-text. This is only
	// appropriate within a closed network or for publicly available data.
	// Perform requests using HTTP.
	S3CompatibleMetadata_NETWORK_PROTOCOL_HTTP S3CompatibleMetadata_NetworkProtocol = 2
)

// Enum value maps for S3CompatibleMetadata_NetworkProtocol.
var (
	S3CompatibleMetadata_NetworkProtocol_name = map[int32]string{
		0: "NETWORK_PROTOCOL_UNSPECIFIED",
		1: "NETWORK_PROTOCOL_HTTPS",
		2: "NETWORK_PROTOCOL_HTTP",
	}
	S3CompatibleMetadata_NetworkProtocol_value = map[string]int32{
		"NETWORK_PROTOCOL_UNSPECIFIED": 0,
		"NETWORK_PROTOCOL_HTTPS":       1,
		"NETWORK_PROTOCOL_HTTP":        2,
	}
)

func (x S3CompatibleMetadata_NetworkProtocol) Enum() *S3CompatibleMetadata_NetworkProtocol {
	p := new(S3CompatibleMetadata_NetworkProtocol)
	*p = x
	return p
}

func (x S3CompatibleMetadata_NetworkProtocol) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (S3CompatibleMetadata_NetworkProtocol) Descriptor() protoreflect.EnumDescriptor {
	return file_google_storagetransfer_v1_transfer_types_proto_enumTypes[2].Descriptor()
}

func (S3CompatibleMetadata_NetworkProtocol) Type() protoreflect.EnumType {
	return &file_google_storagetransfer_v1_transfer_types_proto_enumTypes[2]
}

func (x S3CompatibleMetadata_NetworkProtocol) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use S3CompatibleMetadata_NetworkProtocol.Descriptor instead.
func (S3CompatibleMetadata_NetworkProtocol) EnumDescriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{10, 2}
}

// The Listing API to use for discovering objects.
type S3CompatibleMetadata_ListApi int32

const (
	// ListApi is not specified.
	S3CompatibleMetadata_LIST_API_UNSPECIFIED S3CompatibleMetadata_ListApi = 0
	// Perform listing using ListObjectsV2 API.
	S3CompatibleMetadata_LIST_OBJECTS_V2 S3CompatibleMetadata_ListApi = 1
	// Legacy ListObjects API.
	S3CompatibleMetadata_LIST_OBJECTS S3CompatibleMetadata_ListApi = 2
)

// Enum value maps for S3CompatibleMetadata_ListApi.
var (
	S3CompatibleMetadata_ListApi_name = map[int32]string{
		0: "LIST_API_UNSPECIFIED",
		1: "LIST_OBJECTS_V2",
		2: "LIST_OBJECTS",
	}
	S3CompatibleMetadata_ListApi_value = map[string]int32{
		"LIST_API_UNSPECIFIED": 0,
		"LIST_OBJECTS_V2":      1,
		"LIST_OBJECTS":         2,
	}
)

func (x S3CompatibleMetadata_ListApi) Enum() *S3CompatibleMetadata_ListApi {
	p := new(S3CompatibleMetadata_ListApi)
	*p = x
	return p
}

func (x S3CompatibleMetadata_ListApi) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (S3CompatibleMetadata_ListApi) Descriptor() protoreflect.EnumDescriptor {
	return file_google_storagetransfer_v1_transfer_types_proto_enumTypes[3].Descriptor()
}

func (S3CompatibleMetadata_ListApi) Type() protoreflect.EnumType {
	return &file_google_storagetransfer_v1_transfer_types_proto_enumTypes[3]
}

func (x S3CompatibleMetadata_ListApi) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use S3CompatibleMetadata_ListApi.Descriptor instead.
func (S3CompatibleMetadata_ListApi) EnumDescriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{10, 3}
}

// The state of an AgentPool.
type AgentPool_State int32

const (
	// Default value. This value is unused.
	AgentPool_STATE_UNSPECIFIED AgentPool_State = 0
	// This is an initialization state. During this stage, the resources such as
	// Pub/Sub topics are allocated for the AgentPool.
	AgentPool_CREATING AgentPool_State = 1
	// Determines that the AgentPool is created for use. At this state, Agents
	// can join the AgentPool and participate in the transfer jobs in that pool.
	AgentPool_CREATED AgentPool_State = 2
	// Determines that the AgentPool deletion has been initiated, and all the
	// resources are scheduled to be cleaned up and freed.
	AgentPool_DELETING AgentPool_State = 3
)

// Enum value maps for AgentPool_State.
var (
	AgentPool_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "CREATED",
		3: "DELETING",
	}
	AgentPool_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"CREATED":           2,
		"DELETING":          3,
	}
)

func (x AgentPool_State) Enum() *AgentPool_State {
	p := new(AgentPool_State)
	*p = x
	return p
}

func (x AgentPool_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AgentPool_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_storagetransfer_v1_transfer_types_proto_enumTypes[4].Descriptor()
}

func (AgentPool_State) Type() protoreflect.EnumType {
	return &file_google_storagetransfer_v1_transfer_types_proto_enumTypes[4]
}

func (x AgentPool_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AgentPool_State.Descriptor instead.
func (AgentPool_State) EnumDescriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{11, 0}
}

// Specifies when to overwrite an object in the sink when an object with
// matching name is found in the source.
type TransferOptions_OverwriteWhen int32

const (
	// Overwrite behavior is unspecified.
	TransferOptions_OVERWRITE_WHEN_UNSPECIFIED TransferOptions_OverwriteWhen = 0
	// Overwrites destination objects with the source objects, only if the
	// objects have the same name but different HTTP ETags or checksum values.
	TransferOptions_DIFFERENT TransferOptions_OverwriteWhen = 1
	// Never overwrites a destination object if a source object has the
	// same name. In this case, the source object is not transferred.
	TransferOptions_NEVER TransferOptions_OverwriteWhen = 2
	// Always overwrite the destination object with the source object, even if
	// the HTTP Etags or checksum values are the same.
	TransferOptions_ALWAYS TransferOptions_OverwriteWhen = 3
)

// Enum value maps for TransferOptions_OverwriteWhen.
var (
	TransferOptions_OverwriteWhen_name = map[int32]string{
		0: "OVERWRITE_WHEN_UNSPECIFIED",
		1: "DIFFERENT",
		2: "NEVER",
		3: "ALWAYS",
	}
	TransferOptions_OverwriteWhen_value = map[string]int32{
		"OVERWRITE_WHEN_UNSPECIFIED": 0,
		"DIFFERENT":                  1,
		"NEVER":                      2,
		"ALWAYS":                     3,
	}
)

func (x TransferOptions_OverwriteWhen) Enum() *TransferOptions_OverwriteWhen {
	p := new(TransferOptions_OverwriteWhen)
	*p = x
	return p
}

func (x TransferOptions_OverwriteWhen) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TransferOptions_OverwriteWhen) Descriptor() protoreflect.EnumDescriptor {
	return file_google_storagetransfer_v1_transfer_types_proto_enumTypes[5].Descriptor()
}

func (TransferOptions_OverwriteWhen) Type() protoreflect.EnumType {
	return &file_google_storagetransfer_v1_transfer_types_proto_enumTypes[5]
}

func (x TransferOptions_OverwriteWhen) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TransferOptions_OverwriteWhen.Descriptor instead.
func (TransferOptions_OverwriteWhen) EnumDescriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{12, 0}
}

// Whether symlinks should be skipped or preserved during a transfer job.
type MetadataOptions_Symlink int32

const (
	// Symlink behavior is unspecified.
	MetadataOptions_SYMLINK_UNSPECIFIED MetadataOptions_Symlink = 0
	// Do not preserve symlinks during a transfer job.
	MetadataOptions_SYMLINK_SKIP MetadataOptions_Symlink = 1
	// Preserve symlinks during a transfer job.
	MetadataOptions_SYMLINK_PRESERVE MetadataOptions_Symlink = 2
)

// Enum value maps for MetadataOptions_Symlink.
var (
	MetadataOptions_Symlink_name = map[int32]string{
		0: "SYMLINK_UNSPECIFIED",
		1: "SYMLINK_SKIP",
		2: "SYMLINK_PRESERVE",
	}
	MetadataOptions_Symlink_value = map[string]int32{
		"SYMLINK_UNSPECIFIED": 0,
		"SYMLINK_SKIP":        1,
		"SYMLINK_PRESERVE":    2,
	}
)

func (x MetadataOptions_Symlink) Enum() *MetadataOptions_Symlink {
	p := new(MetadataOptions_Symlink)
	*p = x
	return p
}

func (x MetadataOptions_Symlink) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MetadataOptions_Symlink) Descriptor() protoreflect.EnumDescriptor {
	return file_google_storagetransfer_v1_transfer_types_proto_enumTypes[6].Descriptor()
}

func (MetadataOptions_Symlink) Type() protoreflect.EnumType {
	return &file_google_storagetransfer_v1_transfer_types_proto_enumTypes[6]
}

func (x MetadataOptions_Symlink) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MetadataOptions_Symlink.Descriptor instead.
func (MetadataOptions_Symlink) EnumDescriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{14, 0}
}

// Options for handling file mode attribute.
type MetadataOptions_Mode int32

const (
	// Mode behavior is unspecified.
	MetadataOptions_MODE_UNSPECIFIED MetadataOptions_Mode = 0
	// Do not preserve mode during a transfer job.
	MetadataOptions_MODE_SKIP MetadataOptions_Mode = 1
	// Preserve mode during a transfer job.
	MetadataOptions_MODE_PRESERVE MetadataOptions_Mode = 2
)

// Enum value maps for MetadataOptions_Mode.
var (
	MetadataOptions_Mode_name = map[int32]string{
		0: "MODE_UNSPECIFIED",
		1: "MODE_SKIP",
		2: "MODE_PRESERVE",
	}
	MetadataOptions_Mode_value = map[string]int32{
		"MODE_UNSPECIFIED": 0,
		"MODE_SKIP":        1,
		"MODE_PRESERVE":    2,
	}
)

func (x MetadataOptions_Mode) Enum() *MetadataOptions_Mode {
	p := new(MetadataOptions_Mode)
	*p = x
	return p
}

func (x MetadataOptions_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MetadataOptions_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_storagetransfer_v1_transfer_types_proto_enumTypes[7].Descriptor()
}

func (MetadataOptions_Mode) Type() protoreflect.EnumType {
	return &file_google_storagetransfer_v1_transfer_types_proto_enumTypes[7]
}

func (x MetadataOptions_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MetadataOptions_Mode.Descriptor instead.
func (MetadataOptions_Mode) EnumDescriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{14, 1}
}

// Options for handling file GID attribute.
type MetadataOptions_GID int32

const (
	// GID behavior is unspecified.
	MetadataOptions_GID_UNSPECIFIED MetadataOptions_GID = 0
	// Do not preserve GID during a transfer job.
	MetadataOptions_GID_SKIP MetadataOptions_GID = 1
	// Preserve GID during a transfer job.
	MetadataOptions_GID_NUMBER MetadataOptions_GID = 2
)

// Enum value maps for MetadataOptions_GID.
var (
	MetadataOptions_GID_name = map[int32]string{
		0: "GID_UNSPECIFIED",
		1: "GID_SKIP",
		2: "GID_NUMBER",
	}
	MetadataOptions_GID_value = map[string]int32{
		"GID_UNSPECIFIED": 0,
		"GID_SKIP":        1,
		"GID_NUMBER":      2,
	}
)

func (x MetadataOptions_GID) Enum() *MetadataOptions_GID {
	p := new(MetadataOptions_GID)
	*p = x
	return p
}

func (x MetadataOptions_GID) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MetadataOptions_GID) Descriptor() protoreflect.EnumDescriptor {
	return file_google_storagetransfer_v1_transfer_types_proto_enumTypes[8].Descriptor()
}

func (MetadataOptions_GID) Type() protoreflect.EnumType {
	return &file_google_storagetransfer_v1_transfer_types_proto_enumTypes[8]
}

func (x MetadataOptions_GID) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MetadataOptions_GID.Descriptor instead.
func (MetadataOptions_GID) EnumDescriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{14, 2}
}

// Options for handling file UID attribute.
type MetadataOptions_UID int32

const (
	// UID behavior is unspecified.
	MetadataOptions_UID_UNSPECIFIED MetadataOptions_UID = 0
	// Do not preserve UID during a transfer job.
	MetadataOptions_UID_SKIP MetadataOptions_UID = 1
	// Preserve UID during a transfer job.
	MetadataOptions_UID_NUMBER MetadataOptions_UID = 2
)

// Enum value maps for MetadataOptions_UID.
var (
	MetadataOptions_UID_name = map[int32]string{
		0: "UID_UNSPECIFIED",
		1: "UID_SKIP",
		2: "UID_NUMBER",
	}
	MetadataOptions_UID_value = map[string]int32{
		"UID_UNSPECIFIED": 0,
		"UID_SKIP":        1,
		"UID_NUMBER":      2,
	}
)

func (x MetadataOptions_UID) Enum() *MetadataOptions_UID {
	p := new(MetadataOptions_UID)
	*p = x
	return p
}

func (x MetadataOptions_UID) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MetadataOptions_UID) Descriptor() protoreflect.EnumDescriptor {
	return file_google_storagetransfer_v1_transfer_types_proto_enumTypes[9].Descriptor()
}

func (MetadataOptions_UID) Type() protoreflect.EnumType {
	return &file_google_storagetransfer_v1_transfer_types_proto_enumTypes[9]
}

func (x MetadataOptions_UID) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MetadataOptions_UID.Descriptor instead.
func (MetadataOptions_UID) EnumDescriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{14, 3}
}

// Options for handling Cloud Storage object ACLs.
type MetadataOptions_Acl int32

const (
	// ACL behavior is unspecified.
	MetadataOptions_ACL_UNSPECIFIED MetadataOptions_Acl = 0
	// Use the destination bucket's default object ACLS, if applicable.
	MetadataOptions_ACL_DESTINATION_BUCKET_DEFAULT MetadataOptions_Acl = 1
	// Preserve the object's original ACLs. This requires the service account
	// to have `storage.objects.getIamPolicy` permission for the source object.
	// [Uniform bucket-level
	// access](https://cloud.google.com/storage/docs/uniform-bucket-level-access)
	// must not be enabled on either the source or destination buckets.
	MetadataOptions_ACL_PRESERVE MetadataOptions_Acl = 2
)

// Enum value maps for MetadataOptions_Acl.
var (
	MetadataOptions_Acl_name = map[int32]string{
		0: "ACL_UNSPECIFIED",
		1: "ACL_DESTINATION_BUCKET_DEFAULT",
		2: "ACL_PRESERVE",
	}
	MetadataOptions_Acl_value = map[string]int32{
		"ACL_UNSPECIFIED":                0,
		"ACL_DESTINATION_BUCKET_DEFAULT": 1,
		"ACL_PRESERVE":                   2,
	}
)

func (x MetadataOptions_Acl) Enum() *MetadataOptions_Acl {
	p := new(MetadataOptions_Acl)
	*p = x
	return p
}

func (x MetadataOptions_Acl) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MetadataOptions_Acl) Descriptor() protoreflect.EnumDescriptor {
	return file_google_storagetransfer_v1_transfer_types_proto_enumTypes[10].Descriptor()
}

func (MetadataOptions_Acl) Type() protoreflect.EnumType {
	return &file_google_storagetransfer_v1_transfer_types_proto_enumTypes[10]
}

func (x MetadataOptions_Acl) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MetadataOptions_Acl.Descriptor instead.
func (MetadataOptions_Acl) EnumDescriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{14, 4}
}

// Options for handling Google Cloud Storage object storage class.
type MetadataOptions_StorageClass int32

const (
	// Storage class behavior is unspecified.
	MetadataOptions_STORAGE_CLASS_UNSPECIFIED MetadataOptions_StorageClass = 0
	// Use the destination bucket's default storage class.
	MetadataOptions_STORAGE_CLASS_DESTINATION_BUCKET_DEFAULT MetadataOptions_StorageClass = 1
	// Preserve the object's original storage class. This is only supported for
	// transfers from Google Cloud Storage buckets. REGIONAL and MULTI_REGIONAL
	// storage classes will be mapped to STANDARD to ensure they can be written
	// to the destination bucket.
	MetadataOptions_STORAGE_CLASS_PRESERVE MetadataOptions_StorageClass = 2
	// Set the storage class to STANDARD.
	MetadataOptions_STORAGE_CLASS_STANDARD MetadataOptions_StorageClass = 3
	// Set the storage class to NEARLINE.
	MetadataOptions_STORAGE_CLASS_NEARLINE MetadataOptions_StorageClass = 4
	// Set the storage class to COLDLINE.
	MetadataOptions_STORAGE_CLASS_COLDLINE MetadataOptions_StorageClass = 5
	// Set the storage class to ARCHIVE.
	MetadataOptions_STORAGE_CLASS_ARCHIVE MetadataOptions_StorageClass = 6
)

// Enum value maps for MetadataOptions_StorageClass.
var (
	MetadataOptions_StorageClass_name = map[int32]string{
		0: "STORAGE_CLASS_UNSPECIFIED",
		1: "STORAGE_CLASS_DESTINATION_BUCKET_DEFAULT",
		2: "STORAGE_CLASS_PRESERVE",
		3: "STORAGE_CLASS_STANDARD",
		4: "STORAGE_CLASS_NEARLINE",
		5: "STORAGE_CLASS_COLDLINE",
		6: "STORAGE_CLASS_ARCHIVE",
	}
	MetadataOptions_StorageClass_value = map[string]int32{
		"STORAGE_CLASS_UNSPECIFIED":                0,
		"STORAGE_CLASS_DESTINATION_BUCKET_DEFAULT": 1,
		"STORAGE_CLASS_PRESERVE":                   2,
		"STORAGE_CLASS_STANDARD":                   3,
		"STORAGE_CLASS_NEARLINE":                   4,
		"STORAGE_CLASS_COLDLINE":                   5,
		"STORAGE_CLASS_ARCHIVE":                    6,
	}
)

func (x MetadataOptions_StorageClass) Enum() *MetadataOptions_StorageClass {
	p := new(MetadataOptions_StorageClass)
	*p = x
	return p
}

func (x MetadataOptions_StorageClass) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MetadataOptions_StorageClass) Descriptor() protoreflect.EnumDescriptor {
	return file_google_storagetransfer_v1_transfer_types_proto_enumTypes[11].Descriptor()
}

func (MetadataOptions_StorageClass) Type() protoreflect.EnumType {
	return &file_google_storagetransfer_v1_transfer_types_proto_enumTypes[11]
}

func (x MetadataOptions_StorageClass) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MetadataOptions_StorageClass.Descriptor instead.
func (MetadataOptions_StorageClass) EnumDescriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{14, 5}
}

// Options for handling temporary holds for Google Cloud Storage objects.
type MetadataOptions_TemporaryHold int32

const (
	// Temporary hold behavior is unspecified.
	MetadataOptions_TEMPORARY_HOLD_UNSPECIFIED MetadataOptions_TemporaryHold = 0
	// Do not set a temporary hold on the destination object.
	MetadataOptions_TEMPORARY_HOLD_SKIP MetadataOptions_TemporaryHold = 1
	// Preserve the object's original temporary hold status.
	MetadataOptions_TEMPORARY_HOLD_PRESERVE MetadataOptions_TemporaryHold = 2
)

// Enum value maps for MetadataOptions_TemporaryHold.
var (
	MetadataOptions_TemporaryHold_name = map[int32]string{
		0: "TEMPORARY_HOLD_UNSPECIFIED",
		1: "TEMPORARY_HOLD_SKIP",
		2: "TEMPORARY_HOLD_PRESERVE",
	}
	MetadataOptions_TemporaryHold_value = map[string]int32{
		"TEMPORARY_HOLD_UNSPECIFIED": 0,
		"TEMPORARY_HOLD_SKIP":        1,
		"TEMPORARY_HOLD_PRESERVE":    2,
	}
)

func (x MetadataOptions_TemporaryHold) Enum() *MetadataOptions_TemporaryHold {
	p := new(MetadataOptions_TemporaryHold)
	*p = x
	return p
}

func (x MetadataOptions_TemporaryHold) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MetadataOptions_TemporaryHold) Descriptor() protoreflect.EnumDescriptor {
	return file_google_storagetransfer_v1_transfer_types_proto_enumTypes[12].Descriptor()
}

func (MetadataOptions_TemporaryHold) Type() protoreflect.EnumType {
	return &file_google_storagetransfer_v1_transfer_types_proto_enumTypes[12]
}

func (x MetadataOptions_TemporaryHold) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MetadataOptions_TemporaryHold.Descriptor instead.
func (MetadataOptions_TemporaryHold) EnumDescriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{14, 6}
}

// Options for handling the KmsKey setting for Google Cloud Storage objects.
type MetadataOptions_KmsKey int32

const (
	// KmsKey behavior is unspecified.
	MetadataOptions_KMS_KEY_UNSPECIFIED MetadataOptions_KmsKey = 0
	// Use the destination bucket's default encryption settings.
	MetadataOptions_KMS_KEY_DESTINATION_BUCKET_DEFAULT MetadataOptions_KmsKey = 1
	// Preserve the object's original Cloud KMS customer-managed encryption key
	// (CMEK) if present. Objects that do not use a Cloud KMS encryption key
	// will be encrypted using the destination bucket's encryption settings.
	MetadataOptions_KMS_KEY_PRESERVE MetadataOptions_KmsKey = 2
)

// Enum value maps for MetadataOptions_KmsKey.
var (
	MetadataOptions_KmsKey_name = map[int32]string{
		0: "KMS_KEY_UNSPECIFIED",
		1: "KMS_KEY_DESTINATION_BUCKET_DEFAULT",
		2: "KMS_KEY_PRESERVE",
	}
	MetadataOptions_KmsKey_value = map[string]int32{
		"KMS_KEY_UNSPECIFIED":                0,
		"KMS_KEY_DESTINATION_BUCKET_DEFAULT": 1,
		"KMS_KEY_PRESERVE":                   2,
	}
)

func (x MetadataOptions_KmsKey) Enum() *MetadataOptions_KmsKey {
	p := new(MetadataOptions_KmsKey)
	*p = x
	return p
}

func (x MetadataOptions_KmsKey) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MetadataOptions_KmsKey) Descriptor() protoreflect.EnumDescriptor {
	return file_google_storagetransfer_v1_transfer_types_proto_enumTypes[13].Descriptor()
}

func (MetadataOptions_KmsKey) Type() protoreflect.EnumType {
	return &file_google_storagetransfer_v1_transfer_types_proto_enumTypes[13]
}

func (x MetadataOptions_KmsKey) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MetadataOptions_KmsKey.Descriptor instead.
func (MetadataOptions_KmsKey) EnumDescriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{14, 7}
}

// Options for handling `timeCreated` metadata for Google Cloud Storage
// objects.
type MetadataOptions_TimeCreated int32

const (
	// TimeCreated behavior is unspecified.
	MetadataOptions_TIME_CREATED_UNSPECIFIED MetadataOptions_TimeCreated = 0
	// Do not preserve the `timeCreated` metadata from the source object.
	MetadataOptions_TIME_CREATED_SKIP MetadataOptions_TimeCreated = 1
	// Preserves the source object's `timeCreated` metadata in the `customTime`
	// field in the destination object.  Note that any value stored in the
	// source object's `customTime` field will not be propagated to the
	// destination object.
	MetadataOptions_TIME_CREATED_PRESERVE_AS_CUSTOM_TIME MetadataOptions_TimeCreated = 2
)

// Enum value maps for MetadataOptions_TimeCreated.
var (
	MetadataOptions_TimeCreated_name = map[int32]string{
		0: "TIME_CREATED_UNSPECIFIED",
		1: "TIME_CREATED_SKIP",
		2: "TIME_CREATED_PRESERVE_AS_CUSTOM_TIME",
	}
	MetadataOptions_TimeCreated_value = map[string]int32{
		"TIME_CREATED_UNSPECIFIED":             0,
		"TIME_CREATED_SKIP":                    1,
		"TIME_CREATED_PRESERVE_AS_CUSTOM_TIME": 2,
	}
)

func (x MetadataOptions_TimeCreated) Enum() *MetadataOptions_TimeCreated {
	p := new(MetadataOptions_TimeCreated)
	*p = x
	return p
}

func (x MetadataOptions_TimeCreated) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MetadataOptions_TimeCreated) Descriptor() protoreflect.EnumDescriptor {
	return file_google_storagetransfer_v1_transfer_types_proto_enumTypes[14].Descriptor()
}

func (MetadataOptions_TimeCreated) Type() protoreflect.EnumType {
	return &file_google_storagetransfer_v1_transfer_types_proto_enumTypes[14]
}

func (x MetadataOptions_TimeCreated) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MetadataOptions_TimeCreated.Descriptor instead.
func (MetadataOptions_TimeCreated) EnumDescriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{14, 8}
}

// The status of the transfer job.
type TransferJob_Status int32

const (
	// Zero is an illegal value.
	TransferJob_STATUS_UNSPECIFIED TransferJob_Status = 0
	// New transfers are performed based on the schedule.
	TransferJob_ENABLED TransferJob_Status = 1
	// New transfers are not scheduled.
	TransferJob_DISABLED TransferJob_Status = 2
	// This is a soft delete state. After a transfer job is set to this
	// state, the job and all the transfer executions are subject to
	// garbage collection. Transfer jobs become eligible for garbage collection
	// 30 days after their status is set to `DELETED`.
	TransferJob_DELETED TransferJob_Status = 3
)

// Enum value maps for TransferJob_Status.
var (
	TransferJob_Status_name = map[int32]string{
		0: "STATUS_UNSPECIFIED",
		1: "ENABLED",
		2: "DISABLED",
		3: "DELETED",
	}
	TransferJob_Status_value = map[string]int32{
		"STATUS_UNSPECIFIED": 0,
		"ENABLED":            1,
		"DISABLED":           2,
		"DELETED":            3,
	}
)

func (x TransferJob_Status) Enum() *TransferJob_Status {
	p := new(TransferJob_Status)
	*p = x
	return p
}

func (x TransferJob_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TransferJob_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_storagetransfer_v1_transfer_types_proto_enumTypes[15].Descriptor()
}

func (TransferJob_Status) Type() protoreflect.EnumType {
	return &file_google_storagetransfer_v1_transfer_types_proto_enumTypes[15]
}

func (x TransferJob_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TransferJob_Status.Descriptor instead.
func (TransferJob_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{18, 0}
}

// Enum for specifying event types for which notifications are to be
// published.
//
// Additional event types may be added in the future. Clients should either
// safely ignore unrecognized event types or explicitly specify which event
// types they are prepared to accept.
type NotificationConfig_EventType int32

const (
	// Illegal value, to avoid allowing a default.
	NotificationConfig_EVENT_TYPE_UNSPECIFIED NotificationConfig_EventType = 0
	// `TransferOperation` completed with status
	// [SUCCESS][google.storagetransfer.v1.TransferOperation.Status.SUCCESS].
	NotificationConfig_TRANSFER_OPERATION_SUCCESS NotificationConfig_EventType = 1
	// `TransferOperation` completed with status
	// [FAILED][google.storagetransfer.v1.TransferOperation.Status.FAILED].
	NotificationConfig_TRANSFER_OPERATION_FAILED NotificationConfig_EventType = 2
	// `TransferOperation` completed with status
	// [ABORTED][google.storagetransfer.v1.TransferOperation.Status.ABORTED].
	NotificationConfig_TRANSFER_OPERATION_ABORTED NotificationConfig_EventType = 3
)

// Enum value maps for NotificationConfig_EventType.
var (
	NotificationConfig_EventType_name = map[int32]string{
		0: "EVENT_TYPE_UNSPECIFIED",
		1: "TRANSFER_OPERATION_SUCCESS",
		2: "TRANSFER_OPERATION_FAILED",
		3: "TRANSFER_OPERATION_ABORTED",
	}
	NotificationConfig_EventType_value = map[string]int32{
		"EVENT_TYPE_UNSPECIFIED":     0,
		"TRANSFER_OPERATION_SUCCESS": 1,
		"TRANSFER_OPERATION_FAILED":  2,
		"TRANSFER_OPERATION_ABORTED": 3,
	}
)

func (x NotificationConfig_EventType) Enum() *NotificationConfig_EventType {
	p := new(NotificationConfig_EventType)
	*p = x
	return p
}

func (x NotificationConfig_EventType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NotificationConfig_EventType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_storagetransfer_v1_transfer_types_proto_enumTypes[16].Descriptor()
}

func (NotificationConfig_EventType) Type() protoreflect.EnumType {
	return &file_google_storagetransfer_v1_transfer_types_proto_enumTypes[16]
}

func (x NotificationConfig_EventType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NotificationConfig_EventType.Descriptor instead.
func (NotificationConfig_EventType) EnumDescriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{22, 0}
}

// Enum for specifying the format of a notification message's payload.
type NotificationConfig_PayloadFormat int32

const (
	// Illegal value, to avoid allowing a default.
	NotificationConfig_PAYLOAD_FORMAT_UNSPECIFIED NotificationConfig_PayloadFormat = 0
	// No payload is included with the notification.
	NotificationConfig_NONE NotificationConfig_PayloadFormat = 1
	// `TransferOperation` is [formatted as a JSON
	// response](https://developers.google.com/protocol-buffers/docs/proto3#json),
	// in application/json.
	NotificationConfig_JSON NotificationConfig_PayloadFormat = 2
)

// Enum value maps for NotificationConfig_PayloadFormat.
var (
	NotificationConfig_PayloadFormat_name = map[int32]string{
		0: "PAYLOAD_FORMAT_UNSPECIFIED",
		1: "NONE",
		2: "JSON",
	}
	NotificationConfig_PayloadFormat_value = map[string]int32{
		"PAYLOAD_FORMAT_UNSPECIFIED": 0,
		"NONE":                       1,
		"JSON":                       2,
	}
)

func (x NotificationConfig_PayloadFormat) Enum() *NotificationConfig_PayloadFormat {
	p := new(NotificationConfig_PayloadFormat)
	*p = x
	return p
}

func (x NotificationConfig_PayloadFormat) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NotificationConfig_PayloadFormat) Descriptor() protoreflect.EnumDescriptor {
	return file_google_storagetransfer_v1_transfer_types_proto_enumTypes[17].Descriptor()
}

func (NotificationConfig_PayloadFormat) Type() protoreflect.EnumType {
	return &file_google_storagetransfer_v1_transfer_types_proto_enumTypes[17]
}

func (x NotificationConfig_PayloadFormat) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NotificationConfig_PayloadFormat.Descriptor instead.
func (NotificationConfig_PayloadFormat) EnumDescriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{22, 1}
}

// Loggable actions.
type LoggingConfig_LoggableAction int32

const (
	// Default value. This value is unused.
	LoggingConfig_LOGGABLE_ACTION_UNSPECIFIED LoggingConfig_LoggableAction = 0
	// Listing objects in a bucket.
	LoggingConfig_FIND LoggingConfig_LoggableAction = 1
	// Deleting objects at the source or the destination.
	LoggingConfig_DELETE LoggingConfig_LoggableAction = 2
	// Copying objects to Google Cloud Storage.
	LoggingConfig_COPY LoggingConfig_LoggableAction = 3
)

// Enum value maps for LoggingConfig_LoggableAction.
var (
	LoggingConfig_LoggableAction_name = map[int32]string{
		0: "LOGGABLE_ACTION_UNSPECIFIED",
		1: "FIND",
		2: "DELETE",
		3: "COPY",
	}
	LoggingConfig_LoggableAction_value = map[string]int32{
		"LOGGABLE_ACTION_UNSPECIFIED": 0,
		"FIND":                        1,
		"DELETE":                      2,
		"COPY":                        3,
	}
)

func (x LoggingConfig_LoggableAction) Enum() *LoggingConfig_LoggableAction {
	p := new(LoggingConfig_LoggableAction)
	*p = x
	return p
}

func (x LoggingConfig_LoggableAction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LoggingConfig_LoggableAction) Descriptor() protoreflect.EnumDescriptor {
	return file_google_storagetransfer_v1_transfer_types_proto_enumTypes[18].Descriptor()
}

func (LoggingConfig_LoggableAction) Type() protoreflect.EnumType {
	return &file_google_storagetransfer_v1_transfer_types_proto_enumTypes[18]
}

func (x LoggingConfig_LoggableAction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LoggingConfig_LoggableAction.Descriptor instead.
func (LoggingConfig_LoggableAction) EnumDescriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{23, 0}
}

// Loggable action states.
type LoggingConfig_LoggableActionState int32

const (
	// Default value. This value is unused.
	LoggingConfig_LOGGABLE_ACTION_STATE_UNSPECIFIED LoggingConfig_LoggableActionState = 0
	// `LoggableAction` completed successfully. `SUCCEEDED` actions are
	// logged as [INFO][google.logging.type.LogSeverity.INFO].
	LoggingConfig_SUCCEEDED LoggingConfig_LoggableActionState = 1
	// `LoggableAction` terminated in an error state. `FAILED` actions are
	// logged as [ERROR][google.logging.type.LogSeverity.ERROR].
	LoggingConfig_FAILED LoggingConfig_LoggableActionState = 2
)

// Enum value maps for LoggingConfig_LoggableActionState.
var (
	LoggingConfig_LoggableActionState_name = map[int32]string{
		0: "LOGGABLE_ACTION_STATE_UNSPECIFIED",
		1: "SUCCEEDED",
		2: "FAILED",
	}
	LoggingConfig_LoggableActionState_value = map[string]int32{
		"LOGGABLE_ACTION_STATE_UNSPECIFIED": 0,
		"SUCCEEDED":                         1,
		"FAILED":                            2,
	}
)

func (x LoggingConfig_LoggableActionState) Enum() *LoggingConfig_LoggableActionState {
	p := new(LoggingConfig_LoggableActionState)
	*p = x
	return p
}

func (x LoggingConfig_LoggableActionState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LoggingConfig_LoggableActionState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_storagetransfer_v1_transfer_types_proto_enumTypes[19].Descriptor()
}

func (LoggingConfig_LoggableActionState) Type() protoreflect.EnumType {
	return &file_google_storagetransfer_v1_transfer_types_proto_enumTypes[19]
}

func (x LoggingConfig_LoggableActionState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LoggingConfig_LoggableActionState.Descriptor instead.
func (LoggingConfig_LoggableActionState) EnumDescriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{23, 1}
}

// The status of a TransferOperation.
type TransferOperation_Status int32

const (
	// Zero is an illegal value.
	TransferOperation_STATUS_UNSPECIFIED TransferOperation_Status = 0
	// In progress.
	TransferOperation_IN_PROGRESS TransferOperation_Status = 1
	// Paused.
	TransferOperation_PAUSED TransferOperation_Status = 2
	// Completed successfully.
	TransferOperation_SUCCESS TransferOperation_Status = 3
	// Terminated due to an unrecoverable failure.
	TransferOperation_FAILED TransferOperation_Status = 4
	// Aborted by the user.
	TransferOperation_ABORTED TransferOperation_Status = 5
	// Temporarily delayed by the system. No user action is required.
	TransferOperation_QUEUED TransferOperation_Status = 6
	// The operation is suspending and draining the ongoing work to completion.
	TransferOperation_SUSPENDING TransferOperation_Status = 7
)

// Enum value maps for TransferOperation_Status.
var (
	TransferOperation_Status_name = map[int32]string{
		0: "STATUS_UNSPECIFIED",
		1: "IN_PROGRESS",
		2: "PAUSED",
		3: "SUCCESS",
		4: "FAILED",
		5: "ABORTED",
		6: "QUEUED",
		7: "SUSPENDING",
	}
	TransferOperation_Status_value = map[string]int32{
		"STATUS_UNSPECIFIED": 0,
		"IN_PROGRESS":        1,
		"PAUSED":             2,
		"SUCCESS":            3,
		"FAILED":             4,
		"ABORTED":            5,
		"QUEUED":             6,
		"SUSPENDING":         7,
	}
)

func (x TransferOperation_Status) Enum() *TransferOperation_Status {
	p := new(TransferOperation_Status)
	*p = x
	return p
}

func (x TransferOperation_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TransferOperation_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_storagetransfer_v1_transfer_types_proto_enumTypes[20].Descriptor()
}

func (TransferOperation_Status) Type() protoreflect.EnumType {
	return &file_google_storagetransfer_v1_transfer_types_proto_enumTypes[20]
}

func (x TransferOperation_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TransferOperation_Status.Descriptor instead.
func (TransferOperation_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{24, 0}
}

// Google service account
type GoogleServiceAccount struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Email address of the service account.
	AccountEmail string `protobuf:"bytes,1,opt,name=account_email,json=accountEmail,proto3" json:"account_email,omitempty"`
	// Unique identifier for the service account.
	SubjectId string `protobuf:"bytes,2,opt,name=subject_id,json=subjectId,proto3" json:"subject_id,omitempty"`
}

func (x *GoogleServiceAccount) Reset() {
	*x = GoogleServiceAccount{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GoogleServiceAccount) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GoogleServiceAccount) ProtoMessage() {}

func (x *GoogleServiceAccount) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GoogleServiceAccount.ProtoReflect.Descriptor instead.
func (*GoogleServiceAccount) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{0}
}

func (x *GoogleServiceAccount) GetAccountEmail() string {
	if x != nil {
		return x.AccountEmail
	}
	return ""
}

func (x *GoogleServiceAccount) GetSubjectId() string {
	if x != nil {
		return x.SubjectId
	}
	return ""
}

// AWS access key (see
// [AWS Security
// Credentials](https://docs.aws.amazon.com/general/latest/gr/aws-security-credentials.html)).
//
// For information on our data retention policy for user credentials, see
// [User credentials](/storage-transfer/docs/data-retention#user-credentials).
type AwsAccessKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. AWS access key ID.
	AccessKeyId string `protobuf:"bytes,1,opt,name=access_key_id,json=accessKeyId,proto3" json:"access_key_id,omitempty"`
	// Required. AWS secret access key. This field is not returned in RPC
	// responses.
	SecretAccessKey string `protobuf:"bytes,2,opt,name=secret_access_key,json=secretAccessKey,proto3" json:"secret_access_key,omitempty"`
}

func (x *AwsAccessKey) Reset() {
	*x = AwsAccessKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AwsAccessKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsAccessKey) ProtoMessage() {}

func (x *AwsAccessKey) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsAccessKey.ProtoReflect.Descriptor instead.
func (*AwsAccessKey) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{1}
}

func (x *AwsAccessKey) GetAccessKeyId() string {
	if x != nil {
		return x.AccessKeyId
	}
	return ""
}

func (x *AwsAccessKey) GetSecretAccessKey() string {
	if x != nil {
		return x.SecretAccessKey
	}
	return ""
}

// Azure credentials
//
// For information on our data retention policy for user credentials, see
// [User credentials](/storage-transfer/docs/data-retention#user-credentials).
type AzureCredentials struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Azure shared access signature (SAS).
	//
	// For more information about SAS, see
	// [Grant limited access to Azure Storage resources using shared access
	// signatures
	// (SAS)](https://docs.microsoft.com/en-us/azure/storage/common/storage-sas-overview).
	SasToken string `protobuf:"bytes,2,opt,name=sas_token,json=sasToken,proto3" json:"sas_token,omitempty"`
}

func (x *AzureCredentials) Reset() {
	*x = AzureCredentials{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AzureCredentials) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AzureCredentials) ProtoMessage() {}

func (x *AzureCredentials) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AzureCredentials.ProtoReflect.Descriptor instead.
func (*AzureCredentials) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{2}
}

func (x *AzureCredentials) GetSasToken() string {
	if x != nil {
		return x.SasToken
	}
	return ""
}

// Conditions that determine which objects are transferred. Applies only
// to Cloud Data Sources such as S3, Azure, and Cloud Storage.
//
// The "last modification time" refers to the time of the
// last change to the object's content or metadata — specifically, this is
// the `updated` property of Cloud Storage objects, the `LastModified` field
// of S3 objects, and the `Last-Modified` header of Azure blobs.
//
// Transfers with a [PosixFilesystem][google.storagetransfer.v1.PosixFilesystem]
// source or destination don't support `ObjectConditions`.
type ObjectConditions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Ensures that objects are not transferred until a specific minimum time
	// has elapsed after the "last modification time". When a
	// [TransferOperation][google.storagetransfer.v1.TransferOperation] begins,
	// objects with a "last modification time" are transferred only if the elapsed
	// time between the
	// [start_time][google.storagetransfer.v1.TransferOperation.start_time] of the
	// `TransferOperation` and the "last modification time" of the object is equal
	// to or greater than the value of min_time_elapsed_since_last_modification`.
	// Objects that do not have a "last modification time" are also transferred.
	MinTimeElapsedSinceLastModification *durationpb.Duration `protobuf:"bytes,1,opt,name=min_time_elapsed_since_last_modification,json=minTimeElapsedSinceLastModification,proto3" json:"min_time_elapsed_since_last_modification,omitempty"`
	// Ensures that objects are not transferred if a specific maximum time
	// has elapsed since the "last modification time".
	// When a [TransferOperation][google.storagetransfer.v1.TransferOperation]
	// begins, objects with a "last modification time" are transferred only if the
	// elapsed time between the
	// [start_time][google.storagetransfer.v1.TransferOperation.start_time] of the
	// `TransferOperation`and the "last modification time" of the object
	//  is less than the value of max_time_elapsed_since_last_modification`.
	// Objects that do not have a "last modification time" are also transferred.
	MaxTimeElapsedSinceLastModification *durationpb.Duration `protobuf:"bytes,2,opt,name=max_time_elapsed_since_last_modification,json=maxTimeElapsedSinceLastModification,proto3" json:"max_time_elapsed_since_last_modification,omitempty"`
	// If you specify `include_prefixes`, Storage Transfer Service uses the items
	// in the `include_prefixes` array to determine which objects to include in a
	// transfer. Objects must start with one of the matching `include_prefixes`
	// for inclusion in the transfer. If
	// [exclude_prefixes][google.storagetransfer.v1.ObjectConditions.exclude_prefixes]
	// is specified, objects must not start with any of the `exclude_prefixes`
	// specified for inclusion in the transfer.
	//
	// The following are requirements of `include_prefixes`:
	//
	//   * Each include-prefix can contain any sequence of Unicode characters, to
	//     a max length of 1024 bytes when UTF8-encoded, and must not contain
	//     Carriage Return or Line Feed characters.  Wildcard matching and regular
	//     expression matching are not supported.
	//
	//   * Each include-prefix must omit the leading slash. For example, to
	//     include the object `s3://my-aws-bucket/logs/y=2015/requests.gz`,
	//     specify the include-prefix as `logs/y=2015/requests.gz`.
	//
	//   * None of the include-prefix values can be empty, if specified.
	//
	//   * Each include-prefix must include a distinct portion of the object
	//     namespace. No include-prefix may be a prefix of another
	//     include-prefix.
	//
	// The max size of `include_prefixes` is 1000.
	//
	// For more information, see [Filtering objects from
	// transfers](/storage-transfer/docs/filtering-objects-from-transfers).
	IncludePrefixes []string `protobuf:"bytes,3,rep,name=include_prefixes,json=includePrefixes,proto3" json:"include_prefixes,omitempty"`
	// If you specify `exclude_prefixes`, Storage Transfer Service uses the items
	// in the `exclude_prefixes` array to determine which objects to exclude from
	// a transfer. Objects must not start with one of the matching
	// `exclude_prefixes` for inclusion in a transfer.
	//
	// The following are requirements of `exclude_prefixes`:
	//
	//   * Each exclude-prefix can contain any sequence of Unicode characters, to
	//     a max length of 1024 bytes when UTF8-encoded, and must not contain
	//     Carriage Return or Line Feed characters.  Wildcard matching and regular
	//     expression matching are not supported.
	//
	//   * Each exclude-prefix must omit the leading slash. For example, to
	//     exclude the object `s3://my-aws-bucket/logs/y=2015/requests.gz`,
	//     specify the exclude-prefix as `logs/y=2015/requests.gz`.
	//
	//   * None of the exclude-prefix values can be empty, if specified.
	//
	//   * Each exclude-prefix must exclude a distinct portion of the object
	//     namespace. No exclude-prefix may be a prefix of another
	//     exclude-prefix.
	//
	//   * If
	//   [include_prefixes][google.storagetransfer.v1.ObjectConditions.include_prefixes]
	//   is specified, then each exclude-prefix must start with the value of a
	//   path explicitly included by `include_prefixes`.
	//
	// The max size of `exclude_prefixes` is 1000.
	//
	// For more information, see [Filtering objects from
	// transfers](/storage-transfer/docs/filtering-objects-from-transfers).
	ExcludePrefixes []string `protobuf:"bytes,4,rep,name=exclude_prefixes,json=excludePrefixes,proto3" json:"exclude_prefixes,omitempty"`
	// If specified, only objects with a "last modification time" on or after
	// this timestamp and objects that don't have a "last modification time" are
	// transferred.
	//
	// The `last_modified_since` and `last_modified_before` fields can be used
	// together for chunked data processing. For example, consider a script that
	// processes each day's worth of data at a time. For that you'd set each
	// of the fields as follows:
	//
	// *  `last_modified_since` to the start of the day
	//
	// *  `last_modified_before` to the end of the day
	LastModifiedSince *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=last_modified_since,json=lastModifiedSince,proto3" json:"last_modified_since,omitempty"`
	// If specified, only objects with a "last modification time" before this
	// timestamp and objects that don't have a "last modification time" are
	// transferred.
	LastModifiedBefore *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=last_modified_before,json=lastModifiedBefore,proto3" json:"last_modified_before,omitempty"`
}

func (x *ObjectConditions) Reset() {
	*x = ObjectConditions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ObjectConditions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ObjectConditions) ProtoMessage() {}

func (x *ObjectConditions) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ObjectConditions.ProtoReflect.Descriptor instead.
func (*ObjectConditions) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{3}
}

func (x *ObjectConditions) GetMinTimeElapsedSinceLastModification() *durationpb.Duration {
	if x != nil {
		return x.MinTimeElapsedSinceLastModification
	}
	return nil
}

func (x *ObjectConditions) GetMaxTimeElapsedSinceLastModification() *durationpb.Duration {
	if x != nil {
		return x.MaxTimeElapsedSinceLastModification
	}
	return nil
}

func (x *ObjectConditions) GetIncludePrefixes() []string {
	if x != nil {
		return x.IncludePrefixes
	}
	return nil
}

func (x *ObjectConditions) GetExcludePrefixes() []string {
	if x != nil {
		return x.ExcludePrefixes
	}
	return nil
}

func (x *ObjectConditions) GetLastModifiedSince() *timestamppb.Timestamp {
	if x != nil {
		return x.LastModifiedSince
	}
	return nil
}

func (x *ObjectConditions) GetLastModifiedBefore() *timestamppb.Timestamp {
	if x != nil {
		return x.LastModifiedBefore
	}
	return nil
}

// In a GcsData resource, an object's name is the Cloud Storage object's
// name and its "last modification time" refers to the object's `updated`
// property of Cloud Storage objects, which changes when the content or the
// metadata of the object is updated.
type GcsData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Cloud Storage bucket name. Must meet
	// [Bucket Name Requirements](/storage/docs/naming#requirements).
	BucketName string `protobuf:"bytes,1,opt,name=bucket_name,json=bucketName,proto3" json:"bucket_name,omitempty"`
	// Root path to transfer objects.
	//
	// Must be an empty string or full path name that ends with a '/'. This field
	// is treated as an object prefix. As such, it should generally not begin with
	// a '/'.
	//
	// The root path value must meet
	// [Object Name Requirements](/storage/docs/naming#objectnames).
	Path string `protobuf:"bytes,3,opt,name=path,proto3" json:"path,omitempty"`
}

func (x *GcsData) Reset() {
	*x = GcsData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GcsData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcsData) ProtoMessage() {}

func (x *GcsData) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcsData.ProtoReflect.Descriptor instead.
func (*GcsData) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{4}
}

func (x *GcsData) GetBucketName() string {
	if x != nil {
		return x.BucketName
	}
	return ""
}

func (x *GcsData) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

// An AwsS3Data resource can be a data source, but not a data sink.
// In an AwsS3Data resource, an object's name is the S3 object's key name.
type AwsS3Data struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. S3 Bucket name (see
	// [Creating a
	// bucket](https://docs.aws.amazon.com/AmazonS3/latest/dev/create-bucket-get-location-example.html)).
	BucketName string `protobuf:"bytes,1,opt,name=bucket_name,json=bucketName,proto3" json:"bucket_name,omitempty"`
	// Input only. AWS access key used to sign the API requests to the AWS S3
	// bucket. Permissions on the bucket must be granted to the access ID of the
	// AWS access key.
	//
	// For information on our data retention policy for user credentials, see
	// [User credentials](/storage-transfer/docs/data-retention#user-credentials).
	AwsAccessKey *AwsAccessKey `protobuf:"bytes,2,opt,name=aws_access_key,json=awsAccessKey,proto3" json:"aws_access_key,omitempty"`
	// Root path to transfer objects.
	//
	// Must be an empty string or full path name that ends with a '/'. This field
	// is treated as an object prefix. As such, it should generally not begin with
	// a '/'.
	Path string `protobuf:"bytes,3,opt,name=path,proto3" json:"path,omitempty"`
	// The Amazon Resource Name (ARN) of the role to support temporary
	// credentials via `AssumeRoleWithWebIdentity`. For more information about
	// ARNs, see [IAM
	// ARNs](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns).
	//
	// When a role ARN is provided, Transfer Service fetches temporary
	// credentials for the session using a `AssumeRoleWithWebIdentity` call for
	// the provided role using the
	// [GoogleServiceAccount][google.storagetransfer.v1.GoogleServiceAccount] for
	// this project.
	RoleArn string `protobuf:"bytes,4,opt,name=role_arn,json=roleArn,proto3" json:"role_arn,omitempty"`
	// Optional. The Resource name of a secret in Secret Manager.
	//
	// The Azure SAS token must be stored in Secret Manager in JSON format:
	// <pre>{
	//  "sas_token" : "<var>SAS_TOKEN</var>"
	// }</pre>
	// [GoogleServiceAccount][google.storagetransfer.v1.GoogleServiceAccount] must
	// be granted `roles/secretmanager.secretAccessor` for the resource.
	//
	// See [Configure access to a source: Microsoft Azure Blob Storage]
	// (https://cloud.google.com/storage-transfer/docs/source-microsoft-azure#secret_manager)
	// for more information.
	//
	// If `credentials_secret` is specified, do not specify [azure_credentials][].
	//
	// This feature is in
	// [preview](https://cloud.google.com/terms/service-terms#1).
	//
	// Format: `projects/{project_number}/secrets/{secret_name}`
	CredentialsSecret string `protobuf:"bytes,7,opt,name=credentials_secret,json=credentialsSecret,proto3" json:"credentials_secret,omitempty"`
}

func (x *AwsS3Data) Reset() {
	*x = AwsS3Data{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AwsS3Data) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsS3Data) ProtoMessage() {}

func (x *AwsS3Data) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsS3Data.ProtoReflect.Descriptor instead.
func (*AwsS3Data) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{5}
}

func (x *AwsS3Data) GetBucketName() string {
	if x != nil {
		return x.BucketName
	}
	return ""
}

func (x *AwsS3Data) GetAwsAccessKey() *AwsAccessKey {
	if x != nil {
		return x.AwsAccessKey
	}
	return nil
}

func (x *AwsS3Data) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *AwsS3Data) GetRoleArn() string {
	if x != nil {
		return x.RoleArn
	}
	return ""
}

func (x *AwsS3Data) GetCredentialsSecret() string {
	if x != nil {
		return x.CredentialsSecret
	}
	return ""
}

// An AzureBlobStorageData resource can be a data source, but not a data sink.
// An AzureBlobStorageData resource represents one Azure container. The storage
// account determines the [Azure
// endpoint](https://docs.microsoft.com/en-us/azure/storage/common/storage-create-storage-account#storage-account-endpoints).
// In an AzureBlobStorageData resource, a blobs's name is the [Azure Blob
// Storage blob's key
// name](https://docs.microsoft.com/en-us/rest/api/storageservices/naming-and-referencing-containers--blobs--and-metadata#blob-names).
type AzureBlobStorageData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Azure Storage account.
	StorageAccount string `protobuf:"bytes,1,opt,name=storage_account,json=storageAccount,proto3" json:"storage_account,omitempty"`
	// Required. Input only. Credentials used to authenticate API requests to
	// Azure.
	//
	// For information on our data retention policy for user credentials, see
	// [User credentials](/storage-transfer/docs/data-retention#user-credentials).
	AzureCredentials *AzureCredentials `protobuf:"bytes,2,opt,name=azure_credentials,json=azureCredentials,proto3" json:"azure_credentials,omitempty"`
	// Required. The container to transfer from the Azure Storage account.
	Container string `protobuf:"bytes,4,opt,name=container,proto3" json:"container,omitempty"`
	// Root path to transfer objects.
	//
	// Must be an empty string or full path name that ends with a '/'. This field
	// is treated as an object prefix. As such, it should generally not begin with
	// a '/'.
	Path string `protobuf:"bytes,5,opt,name=path,proto3" json:"path,omitempty"`
	// Optional. The Resource name of a secret in Secret Manager.
	//
	// The Azure SAS token must be stored in Secret Manager in JSON format:
	// <pre>{
	//  "sas_token" : "<var>SAS_TOKEN</var>"
	// }</pre>
	// [GoogleServiceAccount][google.storagetransfer.v1.GoogleServiceAccount] must
	// be granted `roles/secretmanager.secretAccessor` for the resource.
	//
	// See [Configure access to a source: Microsoft Azure Blob Storage]
	// (https://cloud.google.com/storage-transfer/docs/source-microsoft-azure#secret_manager)
	// for more information.
	//
	// If `credentials_secret` is specified, do not specify
	// [azure_credentials][google.storagetransfer.v1.AzureBlobStorageData.azure_credentials].
	//
	// This feature is in
	// [preview](https://cloud.google.com/terms/service-terms#1).
	//
	// Format: `projects/{project_number}/secrets/{secret_name}`
	CredentialsSecret string `protobuf:"bytes,7,opt,name=credentials_secret,json=credentialsSecret,proto3" json:"credentials_secret,omitempty"`
}

func (x *AzureBlobStorageData) Reset() {
	*x = AzureBlobStorageData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AzureBlobStorageData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AzureBlobStorageData) ProtoMessage() {}

func (x *AzureBlobStorageData) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AzureBlobStorageData.ProtoReflect.Descriptor instead.
func (*AzureBlobStorageData) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{6}
}

func (x *AzureBlobStorageData) GetStorageAccount() string {
	if x != nil {
		return x.StorageAccount
	}
	return ""
}

func (x *AzureBlobStorageData) GetAzureCredentials() *AzureCredentials {
	if x != nil {
		return x.AzureCredentials
	}
	return nil
}

func (x *AzureBlobStorageData) GetContainer() string {
	if x != nil {
		return x.Container
	}
	return ""
}

func (x *AzureBlobStorageData) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *AzureBlobStorageData) GetCredentialsSecret() string {
	if x != nil {
		return x.CredentialsSecret
	}
	return ""
}

// An HttpData resource specifies a list of objects on the web to be transferred
// over HTTP.  The information of the objects to be transferred is contained in
// a file referenced by a URL. The first line in the file must be
// `"TsvHttpData-1.0"`, which specifies the format of the file.  Subsequent
// lines specify the information of the list of objects, one object per list
// entry. Each entry has the following tab-delimited fields:
//
// * **HTTP URL** — The location of the object.
//
// * **Length** — The size of the object in bytes.
//
// * **MD5** — The base64-encoded MD5 hash of the object.
//
// For an example of a valid TSV file, see
// [Transferring data from
// URLs](https://cloud.google.com/storage-transfer/docs/create-url-list).
//
// When transferring data based on a URL list, keep the following in mind:
//
// * When an object located at `http(s)://hostname:port/<URL-path>` is
// transferred to a data sink, the name of the object at the data sink is
// `<hostname>/<URL-path>`.
//
// * If the specified size of an object does not match the actual size of the
// object fetched, the object is not transferred.
//
// * If the specified MD5 does not match the MD5 computed from the transferred
// bytes, the object transfer fails.
//
// * Ensure that each URL you specify is publicly accessible. For
// example, in Cloud Storage you can
// [share an object publicly]
// (/storage/docs/cloud-console#_sharingdata) and get a link to it.
//
// * Storage Transfer Service obeys `robots.txt` rules and requires the source
// HTTP server to support `Range` requests and to return a `Content-Length`
// header in each response.
//
// * [ObjectConditions][google.storagetransfer.v1.ObjectConditions] have no
// effect when filtering objects to transfer.
type HttpData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The URL that points to the file that stores the object list
	// entries. This file must allow public access.  Currently, only URLs with
	// HTTP and HTTPS schemes are supported.
	ListUrl string `protobuf:"bytes,1,opt,name=list_url,json=listUrl,proto3" json:"list_url,omitempty"`
}

func (x *HttpData) Reset() {
	*x = HttpData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HttpData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpData) ProtoMessage() {}

func (x *HttpData) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpData.ProtoReflect.Descriptor instead.
func (*HttpData) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{7}
}

func (x *HttpData) GetListUrl() string {
	if x != nil {
		return x.ListUrl
	}
	return ""
}

// A POSIX filesystem resource.
type PosixFilesystem struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Root directory path to the filesystem.
	RootDirectory string `protobuf:"bytes,1,opt,name=root_directory,json=rootDirectory,proto3" json:"root_directory,omitempty"`
}

func (x *PosixFilesystem) Reset() {
	*x = PosixFilesystem{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PosixFilesystem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PosixFilesystem) ProtoMessage() {}

func (x *PosixFilesystem) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PosixFilesystem.ProtoReflect.Descriptor instead.
func (*PosixFilesystem) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{8}
}

func (x *PosixFilesystem) GetRootDirectory() string {
	if x != nil {
		return x.RootDirectory
	}
	return ""
}

// An AwsS3CompatibleData resource.
type AwsS3CompatibleData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Specifies the name of the bucket.
	BucketName string `protobuf:"bytes,1,opt,name=bucket_name,json=bucketName,proto3" json:"bucket_name,omitempty"`
	// Specifies the root path to transfer objects.
	//
	// Must be an empty string or full path name that ends with a '/'. This
	// field is treated as an object prefix. As such, it should generally not
	// begin with a '/'.
	Path string `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
	// Required. Specifies the endpoint of the storage service.
	Endpoint string `protobuf:"bytes,3,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	// Specifies the region to sign requests with. This can be left blank if
	// requests should be signed with an empty region.
	Region string `protobuf:"bytes,5,opt,name=region,proto3" json:"region,omitempty"`
	// Specifies the metadata of the S3 compatible data provider. Each provider
	// may contain some attributes that do not apply to all S3-compatible data
	// providers. When not specified, S3CompatibleMetadata is used by default.
	//
	// Types that are assignable to DataProvider:
	//	*AwsS3CompatibleData_S3Metadata
	DataProvider isAwsS3CompatibleData_DataProvider `protobuf_oneof:"data_provider"`
}

func (x *AwsS3CompatibleData) Reset() {
	*x = AwsS3CompatibleData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AwsS3CompatibleData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsS3CompatibleData) ProtoMessage() {}

func (x *AwsS3CompatibleData) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsS3CompatibleData.ProtoReflect.Descriptor instead.
func (*AwsS3CompatibleData) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{9}
}

func (x *AwsS3CompatibleData) GetBucketName() string {
	if x != nil {
		return x.BucketName
	}
	return ""
}

func (x *AwsS3CompatibleData) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *AwsS3CompatibleData) GetEndpoint() string {
	if x != nil {
		return x.Endpoint
	}
	return ""
}

func (x *AwsS3CompatibleData) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

func (m *AwsS3CompatibleData) GetDataProvider() isAwsS3CompatibleData_DataProvider {
	if m != nil {
		return m.DataProvider
	}
	return nil
}

func (x *AwsS3CompatibleData) GetS3Metadata() *S3CompatibleMetadata {
	if x, ok := x.GetDataProvider().(*AwsS3CompatibleData_S3Metadata); ok {
		return x.S3Metadata
	}
	return nil
}

type isAwsS3CompatibleData_DataProvider interface {
	isAwsS3CompatibleData_DataProvider()
}

type AwsS3CompatibleData_S3Metadata struct {
	// A S3 compatible metadata.
	S3Metadata *S3CompatibleMetadata `protobuf:"bytes,4,opt,name=s3_metadata,json=s3Metadata,proto3,oneof"`
}

func (*AwsS3CompatibleData_S3Metadata) isAwsS3CompatibleData_DataProvider() {}

// S3CompatibleMetadata contains the metadata fields that apply to the basic
// types of S3-compatible data providers.
type S3CompatibleMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies the authentication and authorization method used by the storage
	// service. When not specified, Transfer Service will attempt to determine
	// right auth method to use.
	AuthMethod S3CompatibleMetadata_AuthMethod `protobuf:"varint,1,opt,name=auth_method,json=authMethod,proto3,enum=google.storagetransfer.v1.S3CompatibleMetadata_AuthMethod" json:"auth_method,omitempty"`
	// Specifies the API request model used to call the storage service. When not
	// specified, the default value of RequestModel
	// REQUEST_MODEL_VIRTUAL_HOSTED_STYLE is used.
	RequestModel S3CompatibleMetadata_RequestModel `protobuf:"varint,2,opt,name=request_model,json=requestModel,proto3,enum=google.storagetransfer.v1.S3CompatibleMetadata_RequestModel" json:"request_model,omitempty"`
	// Specifies the network protocol of the agent. When not specified, the
	// default value of NetworkProtocol NETWORK_PROTOCOL_HTTPS is used.
	Protocol S3CompatibleMetadata_NetworkProtocol `protobuf:"varint,3,opt,name=protocol,proto3,enum=google.storagetransfer.v1.S3CompatibleMetadata_NetworkProtocol" json:"protocol,omitempty"`
	// The Listing API to use for discovering objects. When not specified,
	// Transfer Service will attempt to determine the right API to use.
	ListApi S3CompatibleMetadata_ListApi `protobuf:"varint,4,opt,name=list_api,json=listApi,proto3,enum=google.storagetransfer.v1.S3CompatibleMetadata_ListApi" json:"list_api,omitempty"`
}

func (x *S3CompatibleMetadata) Reset() {
	*x = S3CompatibleMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *S3CompatibleMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*S3CompatibleMetadata) ProtoMessage() {}

func (x *S3CompatibleMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use S3CompatibleMetadata.ProtoReflect.Descriptor instead.
func (*S3CompatibleMetadata) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{10}
}

func (x *S3CompatibleMetadata) GetAuthMethod() S3CompatibleMetadata_AuthMethod {
	if x != nil {
		return x.AuthMethod
	}
	return S3CompatibleMetadata_AUTH_METHOD_UNSPECIFIED
}

func (x *S3CompatibleMetadata) GetRequestModel() S3CompatibleMetadata_RequestModel {
	if x != nil {
		return x.RequestModel
	}
	return S3CompatibleMetadata_REQUEST_MODEL_UNSPECIFIED
}

func (x *S3CompatibleMetadata) GetProtocol() S3CompatibleMetadata_NetworkProtocol {
	if x != nil {
		return x.Protocol
	}
	return S3CompatibleMetadata_NETWORK_PROTOCOL_UNSPECIFIED
}

func (x *S3CompatibleMetadata) GetListApi() S3CompatibleMetadata_ListApi {
	if x != nil {
		return x.ListApi
	}
	return S3CompatibleMetadata_LIST_API_UNSPECIFIED
}

// Represents an On-Premises Agent pool.
type AgentPool struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Specifies a unique string that identifies the agent pool.
	//
	// Format: `projects/{project_id}/agentPools/{agent_pool_id}`
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Specifies the client-specified AgentPool description.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. Specifies the state of the AgentPool.
	State AgentPool_State `protobuf:"varint,4,opt,name=state,proto3,enum=google.storagetransfer.v1.AgentPool_State" json:"state,omitempty"`
	// Specifies the bandwidth limit details. If this field is unspecified, the
	// default value is set as 'No Limit'.
	BandwidthLimit *AgentPool_BandwidthLimit `protobuf:"bytes,5,opt,name=bandwidth_limit,json=bandwidthLimit,proto3" json:"bandwidth_limit,omitempty"`
}

func (x *AgentPool) Reset() {
	*x = AgentPool{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AgentPool) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AgentPool) ProtoMessage() {}

func (x *AgentPool) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AgentPool.ProtoReflect.Descriptor instead.
func (*AgentPool) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{11}
}

func (x *AgentPool) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AgentPool) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *AgentPool) GetState() AgentPool_State {
	if x != nil {
		return x.State
	}
	return AgentPool_STATE_UNSPECIFIED
}

func (x *AgentPool) GetBandwidthLimit() *AgentPool_BandwidthLimit {
	if x != nil {
		return x.BandwidthLimit
	}
	return nil
}

// TransferOptions define the actions to be performed on objects in a transfer.
type TransferOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// When to overwrite objects that already exist in the sink. The default is
	// that only objects that are different from the source are ovewritten. If
	// true, all objects in the sink whose name matches an object in the source
	// are overwritten with the source object.
	OverwriteObjectsAlreadyExistingInSink bool `protobuf:"varint,1,opt,name=overwrite_objects_already_existing_in_sink,json=overwriteObjectsAlreadyExistingInSink,proto3" json:"overwrite_objects_already_existing_in_sink,omitempty"`
	// Whether objects that exist only in the sink should be deleted.
	//
	// **Note:** This option and
	// [delete_objects_from_source_after_transfer][google.storagetransfer.v1.TransferOptions.delete_objects_from_source_after_transfer]
	// are mutually exclusive.
	DeleteObjectsUniqueInSink bool `protobuf:"varint,2,opt,name=delete_objects_unique_in_sink,json=deleteObjectsUniqueInSink,proto3" json:"delete_objects_unique_in_sink,omitempty"`
	// Whether objects should be deleted from the source after they are
	// transferred to the sink.
	//
	// **Note:** This option and
	// [delete_objects_unique_in_sink][google.storagetransfer.v1.TransferOptions.delete_objects_unique_in_sink]
	// are mutually exclusive.
	DeleteObjectsFromSourceAfterTransfer bool `protobuf:"varint,3,opt,name=delete_objects_from_source_after_transfer,json=deleteObjectsFromSourceAfterTransfer,proto3" json:"delete_objects_from_source_after_transfer,omitempty"`
	// When to overwrite objects that already exist in the sink. If not set,
	// overwrite behavior is determined by
	// [overwrite_objects_already_existing_in_sink][google.storagetransfer.v1.TransferOptions.overwrite_objects_already_existing_in_sink].
	OverwriteWhen TransferOptions_OverwriteWhen `protobuf:"varint,4,opt,name=overwrite_when,json=overwriteWhen,proto3,enum=google.storagetransfer.v1.TransferOptions_OverwriteWhen" json:"overwrite_when,omitempty"`
	// Represents the selected metadata options for a transfer job.
	MetadataOptions *MetadataOptions `protobuf:"bytes,5,opt,name=metadata_options,json=metadataOptions,proto3" json:"metadata_options,omitempty"`
}

func (x *TransferOptions) Reset() {
	*x = TransferOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransferOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransferOptions) ProtoMessage() {}

func (x *TransferOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransferOptions.ProtoReflect.Descriptor instead.
func (*TransferOptions) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{12}
}

func (x *TransferOptions) GetOverwriteObjectsAlreadyExistingInSink() bool {
	if x != nil {
		return x.OverwriteObjectsAlreadyExistingInSink
	}
	return false
}

func (x *TransferOptions) GetDeleteObjectsUniqueInSink() bool {
	if x != nil {
		return x.DeleteObjectsUniqueInSink
	}
	return false
}

func (x *TransferOptions) GetDeleteObjectsFromSourceAfterTransfer() bool {
	if x != nil {
		return x.DeleteObjectsFromSourceAfterTransfer
	}
	return false
}

func (x *TransferOptions) GetOverwriteWhen() TransferOptions_OverwriteWhen {
	if x != nil {
		return x.OverwriteWhen
	}
	return TransferOptions_OVERWRITE_WHEN_UNSPECIFIED
}

func (x *TransferOptions) GetMetadataOptions() *MetadataOptions {
	if x != nil {
		return x.MetadataOptions
	}
	return nil
}

// Configuration for running a transfer.
type TransferSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The write sink for the data.
	//
	// Types that are assignable to DataSink:
	//	*TransferSpec_GcsDataSink
	//	*TransferSpec_PosixDataSink
	DataSink isTransferSpec_DataSink `protobuf_oneof:"data_sink"`
	// The read source of the data.
	//
	// Types that are assignable to DataSource:
	//	*TransferSpec_GcsDataSource
	//	*TransferSpec_AwsS3DataSource
	//	*TransferSpec_HttpDataSource
	//	*TransferSpec_PosixDataSource
	//	*TransferSpec_AzureBlobStorageDataSource
	//	*TransferSpec_AwsS3CompatibleDataSource
	DataSource isTransferSpec_DataSource `protobuf_oneof:"data_source"`
	// Types that are assignable to IntermediateDataLocation:
	//	*TransferSpec_GcsIntermediateDataLocation
	IntermediateDataLocation isTransferSpec_IntermediateDataLocation `protobuf_oneof:"intermediate_data_location"`
	// Only objects that satisfy these object conditions are included in the set
	// of data source and data sink objects.  Object conditions based on
	// objects' "last modification time" do not exclude objects in a data sink.
	ObjectConditions *ObjectConditions `protobuf:"bytes,5,opt,name=object_conditions,json=objectConditions,proto3" json:"object_conditions,omitempty"`
	// If the option
	// [delete_objects_unique_in_sink][google.storagetransfer.v1.TransferOptions.delete_objects_unique_in_sink]
	// is `true` and time-based object conditions such as 'last modification time'
	// are specified, the request fails with an
	// [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT] error.
	TransferOptions *TransferOptions `protobuf:"bytes,6,opt,name=transfer_options,json=transferOptions,proto3" json:"transfer_options,omitempty"`
	// A manifest file provides a list of objects to be transferred from the data
	// source. This field points to the location of the manifest file.
	// Otherwise, the entire source bucket is used. ObjectConditions still apply.
	TransferManifest *TransferManifest `protobuf:"bytes,15,opt,name=transfer_manifest,json=transferManifest,proto3" json:"transfer_manifest,omitempty"`
	// Specifies the agent pool name associated with the posix data source. When
	// unspecified, the default name is used.
	SourceAgentPoolName string `protobuf:"bytes,17,opt,name=source_agent_pool_name,json=sourceAgentPoolName,proto3" json:"source_agent_pool_name,omitempty"`
	// Specifies the agent pool name associated with the posix data sink. When
	// unspecified, the default name is used.
	SinkAgentPoolName string `protobuf:"bytes,18,opt,name=sink_agent_pool_name,json=sinkAgentPoolName,proto3" json:"sink_agent_pool_name,omitempty"`
}

func (x *TransferSpec) Reset() {
	*x = TransferSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransferSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransferSpec) ProtoMessage() {}

func (x *TransferSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransferSpec.ProtoReflect.Descriptor instead.
func (*TransferSpec) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{13}
}

func (m *TransferSpec) GetDataSink() isTransferSpec_DataSink {
	if m != nil {
		return m.DataSink
	}
	return nil
}

func (x *TransferSpec) GetGcsDataSink() *GcsData {
	if x, ok := x.GetDataSink().(*TransferSpec_GcsDataSink); ok {
		return x.GcsDataSink
	}
	return nil
}

func (x *TransferSpec) GetPosixDataSink() *PosixFilesystem {
	if x, ok := x.GetDataSink().(*TransferSpec_PosixDataSink); ok {
		return x.PosixDataSink
	}
	return nil
}

func (m *TransferSpec) GetDataSource() isTransferSpec_DataSource {
	if m != nil {
		return m.DataSource
	}
	return nil
}

func (x *TransferSpec) GetGcsDataSource() *GcsData {
	if x, ok := x.GetDataSource().(*TransferSpec_GcsDataSource); ok {
		return x.GcsDataSource
	}
	return nil
}

func (x *TransferSpec) GetAwsS3DataSource() *AwsS3Data {
	if x, ok := x.GetDataSource().(*TransferSpec_AwsS3DataSource); ok {
		return x.AwsS3DataSource
	}
	return nil
}

func (x *TransferSpec) GetHttpDataSource() *HttpData {
	if x, ok := x.GetDataSource().(*TransferSpec_HttpDataSource); ok {
		return x.HttpDataSource
	}
	return nil
}

func (x *TransferSpec) GetPosixDataSource() *PosixFilesystem {
	if x, ok := x.GetDataSource().(*TransferSpec_PosixDataSource); ok {
		return x.PosixDataSource
	}
	return nil
}

func (x *TransferSpec) GetAzureBlobStorageDataSource() *AzureBlobStorageData {
	if x, ok := x.GetDataSource().(*TransferSpec_AzureBlobStorageDataSource); ok {
		return x.AzureBlobStorageDataSource
	}
	return nil
}

func (x *TransferSpec) GetAwsS3CompatibleDataSource() *AwsS3CompatibleData {
	if x, ok := x.GetDataSource().(*TransferSpec_AwsS3CompatibleDataSource); ok {
		return x.AwsS3CompatibleDataSource
	}
	return nil
}

func (m *TransferSpec) GetIntermediateDataLocation() isTransferSpec_IntermediateDataLocation {
	if m != nil {
		return m.IntermediateDataLocation
	}
	return nil
}

func (x *TransferSpec) GetGcsIntermediateDataLocation() *GcsData {
	if x, ok := x.GetIntermediateDataLocation().(*TransferSpec_GcsIntermediateDataLocation); ok {
		return x.GcsIntermediateDataLocation
	}
	return nil
}

func (x *TransferSpec) GetObjectConditions() *ObjectConditions {
	if x != nil {
		return x.ObjectConditions
	}
	return nil
}

func (x *TransferSpec) GetTransferOptions() *TransferOptions {
	if x != nil {
		return x.TransferOptions
	}
	return nil
}

func (x *TransferSpec) GetTransferManifest() *TransferManifest {
	if x != nil {
		return x.TransferManifest
	}
	return nil
}

func (x *TransferSpec) GetSourceAgentPoolName() string {
	if x != nil {
		return x.SourceAgentPoolName
	}
	return ""
}

func (x *TransferSpec) GetSinkAgentPoolName() string {
	if x != nil {
		return x.SinkAgentPoolName
	}
	return ""
}

type isTransferSpec_DataSink interface {
	isTransferSpec_DataSink()
}

type TransferSpec_GcsDataSink struct {
	// A Cloud Storage data sink.
	GcsDataSink *GcsData `protobuf:"bytes,4,opt,name=gcs_data_sink,json=gcsDataSink,proto3,oneof"`
}

type TransferSpec_PosixDataSink struct {
	// A POSIX Filesystem data sink.
	PosixDataSink *PosixFilesystem `protobuf:"bytes,13,opt,name=posix_data_sink,json=posixDataSink,proto3,oneof"`
}

func (*TransferSpec_GcsDataSink) isTransferSpec_DataSink() {}

func (*TransferSpec_PosixDataSink) isTransferSpec_DataSink() {}

type isTransferSpec_DataSource interface {
	isTransferSpec_DataSource()
}

type TransferSpec_GcsDataSource struct {
	// A Cloud Storage data source.
	GcsDataSource *GcsData `protobuf:"bytes,1,opt,name=gcs_data_source,json=gcsDataSource,proto3,oneof"`
}

type TransferSpec_AwsS3DataSource struct {
	// An AWS S3 data source.
	AwsS3DataSource *AwsS3Data `protobuf:"bytes,2,opt,name=aws_s3_data_source,json=awsS3DataSource,proto3,oneof"`
}

type TransferSpec_HttpDataSource struct {
	// An HTTP URL data source.
	HttpDataSource *HttpData `protobuf:"bytes,3,opt,name=http_data_source,json=httpDataSource,proto3,oneof"`
}

type TransferSpec_PosixDataSource struct {
	// A POSIX Filesystem data source.
	PosixDataSource *PosixFilesystem `protobuf:"bytes,14,opt,name=posix_data_source,json=posixDataSource,proto3,oneof"`
}

type TransferSpec_AzureBlobStorageDataSource struct {
	// An Azure Blob Storage data source.
	AzureBlobStorageDataSource *AzureBlobStorageData `protobuf:"bytes,8,opt,name=azure_blob_storage_data_source,json=azureBlobStorageDataSource,proto3,oneof"`
}

type TransferSpec_AwsS3CompatibleDataSource struct {
	// An AWS S3 compatible data source.
	AwsS3CompatibleDataSource *AwsS3CompatibleData `protobuf:"bytes,19,opt,name=aws_s3_compatible_data_source,json=awsS3CompatibleDataSource,proto3,oneof"`
}

func (*TransferSpec_GcsDataSource) isTransferSpec_DataSource() {}

func (*TransferSpec_AwsS3DataSource) isTransferSpec_DataSource() {}

func (*TransferSpec_HttpDataSource) isTransferSpec_DataSource() {}

func (*TransferSpec_PosixDataSource) isTransferSpec_DataSource() {}

func (*TransferSpec_AzureBlobStorageDataSource) isTransferSpec_DataSource() {}

func (*TransferSpec_AwsS3CompatibleDataSource) isTransferSpec_DataSource() {}

type isTransferSpec_IntermediateDataLocation interface {
	isTransferSpec_IntermediateDataLocation()
}

type TransferSpec_GcsIntermediateDataLocation struct {
	// For transfers between file systems, specifies a Cloud Storage bucket
	// to be used as an intermediate location through which to transfer data.
	//
	// See [Transfer data between file
	// systems](https://cloud.google.com/storage-transfer/docs/file-to-file) for
	// more information.
	GcsIntermediateDataLocation *GcsData `protobuf:"bytes,16,opt,name=gcs_intermediate_data_location,json=gcsIntermediateDataLocation,proto3,oneof"`
}

func (*TransferSpec_GcsIntermediateDataLocation) isTransferSpec_IntermediateDataLocation() {}

// Specifies the metadata options for running a transfer.
type MetadataOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies how symlinks should be handled by the transfer. By default,
	// symlinks are not preserved. Only applicable to transfers involving
	// POSIX file systems, and ignored for other transfers.
	Symlink MetadataOptions_Symlink `protobuf:"varint,1,opt,name=symlink,proto3,enum=google.storagetransfer.v1.MetadataOptions_Symlink" json:"symlink,omitempty"`
	// Specifies how each file's mode attribute should be handled by the transfer.
	// By default, mode is not preserved. Only applicable to transfers involving
	// POSIX file systems, and ignored for other transfers.
	Mode MetadataOptions_Mode `protobuf:"varint,2,opt,name=mode,proto3,enum=google.storagetransfer.v1.MetadataOptions_Mode" json:"mode,omitempty"`
	// Specifies how each file's POSIX group ID (GID) attribute should be handled
	// by the transfer. By default, GID is not preserved. Only applicable to
	// transfers involving POSIX file systems, and ignored for other transfers.
	Gid MetadataOptions_GID `protobuf:"varint,3,opt,name=gid,proto3,enum=google.storagetransfer.v1.MetadataOptions_GID" json:"gid,omitempty"`
	// Specifies how each file's POSIX user ID (UID) attribute should be handled
	// by the transfer. By default, UID is not preserved. Only applicable to
	// transfers involving POSIX file systems, and ignored for other transfers.
	Uid MetadataOptions_UID `protobuf:"varint,4,opt,name=uid,proto3,enum=google.storagetransfer.v1.MetadataOptions_UID" json:"uid,omitempty"`
	// Specifies how each object's ACLs should be preserved for transfers between
	// Google Cloud Storage buckets. If unspecified, the default behavior is the
	// same as ACL_DESTINATION_BUCKET_DEFAULT.
	Acl MetadataOptions_Acl `protobuf:"varint,5,opt,name=acl,proto3,enum=google.storagetransfer.v1.MetadataOptions_Acl" json:"acl,omitempty"`
	// Specifies the storage class to set on objects being transferred to Google
	// Cloud Storage buckets.  If unspecified, the default behavior is the same as
	// [STORAGE_CLASS_DESTINATION_BUCKET_DEFAULT][google.storagetransfer.v1.MetadataOptions.StorageClass.STORAGE_CLASS_DESTINATION_BUCKET_DEFAULT].
	StorageClass MetadataOptions_StorageClass `protobuf:"varint,6,opt,name=storage_class,json=storageClass,proto3,enum=google.storagetransfer.v1.MetadataOptions_StorageClass" json:"storage_class,omitempty"`
	// Specifies how each object's temporary hold status should be preserved for
	// transfers between Google Cloud Storage buckets.  If unspecified, the
	// default behavior is the same as
	// [TEMPORARY_HOLD_PRESERVE][google.storagetransfer.v1.MetadataOptions.TemporaryHold.TEMPORARY_HOLD_PRESERVE].
	TemporaryHold MetadataOptions_TemporaryHold `protobuf:"varint,7,opt,name=temporary_hold,json=temporaryHold,proto3,enum=google.storagetransfer.v1.MetadataOptions_TemporaryHold" json:"temporary_hold,omitempty"`
	// Specifies how each object's Cloud KMS customer-managed encryption key
	// (CMEK) is preserved for transfers between Google Cloud Storage buckets.  If
	// unspecified, the default behavior is the same as
	// [KMS_KEY_DESTINATION_BUCKET_DEFAULT][google.storagetransfer.v1.MetadataOptions.KmsKey.KMS_KEY_DESTINATION_BUCKET_DEFAULT].
	KmsKey MetadataOptions_KmsKey `protobuf:"varint,8,opt,name=kms_key,json=kmsKey,proto3,enum=google.storagetransfer.v1.MetadataOptions_KmsKey" json:"kms_key,omitempty"`
	// Specifies how each object's `timeCreated` metadata is preserved for
	// transfers between Google Cloud Storage buckets.  If unspecified, the
	// default behavior is the same as
	// [TIME_CREATED_SKIP][google.storagetransfer.v1.MetadataOptions.TimeCreated.TIME_CREATED_SKIP].
	TimeCreated MetadataOptions_TimeCreated `protobuf:"varint,9,opt,name=time_created,json=timeCreated,proto3,enum=google.storagetransfer.v1.MetadataOptions_TimeCreated" json:"time_created,omitempty"`
}

func (x *MetadataOptions) Reset() {
	*x = MetadataOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MetadataOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetadataOptions) ProtoMessage() {}

func (x *MetadataOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetadataOptions.ProtoReflect.Descriptor instead.
func (*MetadataOptions) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{14}
}

func (x *MetadataOptions) GetSymlink() MetadataOptions_Symlink {
	if x != nil {
		return x.Symlink
	}
	return MetadataOptions_SYMLINK_UNSPECIFIED
}

func (x *MetadataOptions) GetMode() MetadataOptions_Mode {
	if x != nil {
		return x.Mode
	}
	return MetadataOptions_MODE_UNSPECIFIED
}

func (x *MetadataOptions) GetGid() MetadataOptions_GID {
	if x != nil {
		return x.Gid
	}
	return MetadataOptions_GID_UNSPECIFIED
}

func (x *MetadataOptions) GetUid() MetadataOptions_UID {
	if x != nil {
		return x.Uid
	}
	return MetadataOptions_UID_UNSPECIFIED
}

func (x *MetadataOptions) GetAcl() MetadataOptions_Acl {
	if x != nil {
		return x.Acl
	}
	return MetadataOptions_ACL_UNSPECIFIED
}

func (x *MetadataOptions) GetStorageClass() MetadataOptions_StorageClass {
	if x != nil {
		return x.StorageClass
	}
	return MetadataOptions_STORAGE_CLASS_UNSPECIFIED
}

func (x *MetadataOptions) GetTemporaryHold() MetadataOptions_TemporaryHold {
	if x != nil {
		return x.TemporaryHold
	}
	return MetadataOptions_TEMPORARY_HOLD_UNSPECIFIED
}

func (x *MetadataOptions) GetKmsKey() MetadataOptions_KmsKey {
	if x != nil {
		return x.KmsKey
	}
	return MetadataOptions_KMS_KEY_UNSPECIFIED
}

func (x *MetadataOptions) GetTimeCreated() MetadataOptions_TimeCreated {
	if x != nil {
		return x.TimeCreated
	}
	return MetadataOptions_TIME_CREATED_UNSPECIFIED
}

// Specifies where the manifest is located.
type TransferManifest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies the path to the manifest in Cloud Storage. The Google-managed
	// service account for the transfer must have `storage.objects.get`
	// permission for this object. An example path is
	// `gs://bucket_name/path/manifest.csv`.
	Location string `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
}

func (x *TransferManifest) Reset() {
	*x = TransferManifest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransferManifest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransferManifest) ProtoMessage() {}

func (x *TransferManifest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransferManifest.ProtoReflect.Descriptor instead.
func (*TransferManifest) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{15}
}

func (x *TransferManifest) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

// Transfers can be scheduled to recur or to run just once.
type Schedule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The start date of a transfer. Date boundaries are determined
	// relative to UTC time. If `schedule_start_date` and
	// [start_time_of_day][google.storagetransfer.v1.Schedule.start_time_of_day]
	// are in the past relative to the job's creation time, the transfer starts
	// the day after you schedule the transfer request.
	//
	// **Note:** When starting jobs at or near midnight UTC it is possible that
	// a job starts later than expected. For example, if you send an outbound
	// request on June 1 one millisecond prior to midnight UTC and the Storage
	// Transfer Service server receives the request on June 2, then it creates
	// a TransferJob with `schedule_start_date` set to June 2 and a
	// `start_time_of_day` set to midnight UTC. The first scheduled
	// [TransferOperation][google.storagetransfer.v1.TransferOperation] takes
	// place on June 3 at midnight UTC.
	ScheduleStartDate *date.Date `protobuf:"bytes,1,opt,name=schedule_start_date,json=scheduleStartDate,proto3" json:"schedule_start_date,omitempty"`
	// The last day a transfer runs. Date boundaries are determined relative to
	// UTC time. A job runs once per 24 hours within the following guidelines:
	//
	// *   If `schedule_end_date` and
	// [schedule_start_date][google.storagetransfer.v1.Schedule.schedule_start_date]
	// are the same and in
	//     the future relative to UTC, the transfer is executed only one time.
	// *   If `schedule_end_date` is later than `schedule_start_date`  and
	//     `schedule_end_date` is in the future relative to UTC, the job runs each
	//     day at
	//     [start_time_of_day][google.storagetransfer.v1.Schedule.start_time_of_day]
	//     through `schedule_end_date`.
	ScheduleEndDate *date.Date `protobuf:"bytes,2,opt,name=schedule_end_date,json=scheduleEndDate,proto3" json:"schedule_end_date,omitempty"`
	// The time in UTC that a transfer job is scheduled to run. Transfers may
	// start later than this time.
	//
	// If `start_time_of_day` is not specified:
	//
	// *   One-time transfers run immediately.
	// *   Recurring transfers run immediately, and each day at midnight UTC,
	//     through
	//     [schedule_end_date][google.storagetransfer.v1.Schedule.schedule_end_date].
	//
	// If `start_time_of_day` is specified:
	//
	// *   One-time transfers run at the specified time.
	// *   Recurring transfers run at the specified time each day, through
	//     `schedule_end_date`.
	StartTimeOfDay *timeofday.TimeOfDay `protobuf:"bytes,3,opt,name=start_time_of_day,json=startTimeOfDay,proto3" json:"start_time_of_day,omitempty"`
	// The time in UTC that no further transfer operations are scheduled. Combined
	// with
	// [schedule_end_date][google.storagetransfer.v1.Schedule.schedule_end_date],
	// `end_time_of_day` specifies the end date and time for starting new transfer
	// operations. This field must be greater than or equal to the timestamp
	// corresponding to the combintation of
	// [schedule_start_date][google.storagetransfer.v1.Schedule.schedule_start_date]
	// and
	// [start_time_of_day][google.storagetransfer.v1.Schedule.start_time_of_day],
	// and is subject to the following:
	//
	// *   If `end_time_of_day` is not set and `schedule_end_date` is set, then
	//     a default value of `23:59:59` is used for `end_time_of_day`.
	//
	// *   If `end_time_of_day` is set and `schedule_end_date` is not set, then
	//     [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT] is returned.
	EndTimeOfDay *timeofday.TimeOfDay `protobuf:"bytes,4,opt,name=end_time_of_day,json=endTimeOfDay,proto3" json:"end_time_of_day,omitempty"`
	// Interval between the start of each scheduled TransferOperation. If
	// unspecified, the default value is 24 hours. This value may not be less than
	// 1 hour.
	RepeatInterval *durationpb.Duration `protobuf:"bytes,5,opt,name=repeat_interval,json=repeatInterval,proto3" json:"repeat_interval,omitempty"`
}

func (x *Schedule) Reset() {
	*x = Schedule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Schedule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Schedule) ProtoMessage() {}

func (x *Schedule) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Schedule.ProtoReflect.Descriptor instead.
func (*Schedule) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{16}
}

func (x *Schedule) GetScheduleStartDate() *date.Date {
	if x != nil {
		return x.ScheduleStartDate
	}
	return nil
}

func (x *Schedule) GetScheduleEndDate() *date.Date {
	if x != nil {
		return x.ScheduleEndDate
	}
	return nil
}

func (x *Schedule) GetStartTimeOfDay() *timeofday.TimeOfDay {
	if x != nil {
		return x.StartTimeOfDay
	}
	return nil
}

func (x *Schedule) GetEndTimeOfDay() *timeofday.TimeOfDay {
	if x != nil {
		return x.EndTimeOfDay
	}
	return nil
}

func (x *Schedule) GetRepeatInterval() *durationpb.Duration {
	if x != nil {
		return x.RepeatInterval
	}
	return nil
}

// Specifies the Event-driven transfer options. Event-driven transfers listen to
// an event stream to transfer updated files.
type EventStream struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Specifies a unique name of the resource such as AWS SQS
	// ARN in the form 'arn:aws:sqs:region:account_id:queue_name',
	// or Pub/Sub subscription resource name in the form
	// 'projects/{project}/subscriptions/{sub}'.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Specifies the date and time that Storage Transfer Service starts
	// listening for events from this stream. If no start time is specified or
	// start time is in the past, Storage Transfer Service starts listening
	// immediately.
	EventStreamStartTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=event_stream_start_time,json=eventStreamStartTime,proto3" json:"event_stream_start_time,omitempty"`
	// Specifies the data and time at which Storage Transfer Service stops
	// listening for events from this stream. After this time, any transfers in
	// progress will complete, but no new transfers are initiated.
	EventStreamExpirationTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=event_stream_expiration_time,json=eventStreamExpirationTime,proto3" json:"event_stream_expiration_time,omitempty"`
}

func (x *EventStream) Reset() {
	*x = EventStream{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EventStream) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EventStream) ProtoMessage() {}

func (x *EventStream) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EventStream.ProtoReflect.Descriptor instead.
func (*EventStream) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{17}
}

func (x *EventStream) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *EventStream) GetEventStreamStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EventStreamStartTime
	}
	return nil
}

func (x *EventStream) GetEventStreamExpirationTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EventStreamExpirationTime
	}
	return nil
}

// This resource represents the configuration of a transfer job that runs
// periodically.
type TransferJob struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A unique name (within the transfer project) assigned when the job is
	// created.  If this field is empty in a CreateTransferJobRequest, Storage
	// Transfer Service assigns a unique name. Otherwise, the specified name
	// is used as the unique name for this job.
	//
	// If the specified name is in use by a job, the creation request fails with
	// an [ALREADY_EXISTS][google.rpc.Code.ALREADY_EXISTS] error.
	//
	// This name must start with `"transferJobs/"` prefix and end with a letter or
	// a number, and should be no more than 128 characters. For transfers
	// involving PosixFilesystem, this name must start with `transferJobs/OPI`
	// specifically. For all other transfer types, this name must not start with
	// `transferJobs/OPI`.
	//
	// Non-PosixFilesystem example:
	// `"transferJobs/^(?!OPI)[A-Za-z0-9-._~]*[A-Za-z0-9]$"`
	//
	// PosixFilesystem example:
	// `"transferJobs/OPI^[A-Za-z0-9-._~]*[A-Za-z0-9]$"`
	//
	// Applications must not rely on the enforcement of naming requirements
	// involving OPI.
	//
	// Invalid job names fail with an
	// [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT] error.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A description provided by the user for the job. Its max length is 1024
	// bytes when Unicode-encoded.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// The ID of the Google Cloud project that owns the job.
	ProjectId string `protobuf:"bytes,3,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Transfer specification.
	TransferSpec *TransferSpec `protobuf:"bytes,4,opt,name=transfer_spec,json=transferSpec,proto3" json:"transfer_spec,omitempty"`
	// Notification configuration. This is not supported for transfers involving
	// PosixFilesystem.
	NotificationConfig *NotificationConfig `protobuf:"bytes,11,opt,name=notification_config,json=notificationConfig,proto3" json:"notification_config,omitempty"`
	// Logging configuration.
	LoggingConfig *LoggingConfig `protobuf:"bytes,14,opt,name=logging_config,json=loggingConfig,proto3" json:"logging_config,omitempty"`
	// Specifies schedule for the transfer job.
	// This is an optional field. When the field is not set, the job never
	// executes a transfer, unless you invoke RunTransferJob or update the job to
	// have a non-empty schedule.
	Schedule *Schedule `protobuf:"bytes,5,opt,name=schedule,proto3" json:"schedule,omitempty"`
	// Specifies the event stream for the transfer job for event-driven transfers.
	// When EventStream is specified, the Schedule fields are ignored.
	EventStream *EventStream `protobuf:"bytes,15,opt,name=event_stream,json=eventStream,proto3" json:"event_stream,omitempty"`
	// Status of the job. This value MUST be specified for
	// `CreateTransferJobRequests`.
	//
	// **Note:** The effect of the new job status takes place during a subsequent
	// job run. For example, if you change the job status from
	// [ENABLED][google.storagetransfer.v1.TransferJob.Status.ENABLED] to
	// [DISABLED][google.storagetransfer.v1.TransferJob.Status.DISABLED], and an
	// operation spawned by the transfer is running, the status change would not
	// affect the current operation.
	Status TransferJob_Status `protobuf:"varint,6,opt,name=status,proto3,enum=google.storagetransfer.v1.TransferJob_Status" json:"status,omitempty"`
	// Output only. The time that the transfer job was created.
	CreationTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=creation_time,json=creationTime,proto3" json:"creation_time,omitempty"`
	// Output only. The time that the transfer job was last modified.
	LastModificationTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=last_modification_time,json=lastModificationTime,proto3" json:"last_modification_time,omitempty"`
	// Output only. The time that the transfer job was deleted.
	DeletionTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=deletion_time,json=deletionTime,proto3" json:"deletion_time,omitempty"`
	// The name of the most recently started TransferOperation of this JobConfig.
	// Present if a TransferOperation has been created for this JobConfig.
	LatestOperationName string `protobuf:"bytes,12,opt,name=latest_operation_name,json=latestOperationName,proto3" json:"latest_operation_name,omitempty"`
}

func (x *TransferJob) Reset() {
	*x = TransferJob{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransferJob) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransferJob) ProtoMessage() {}

func (x *TransferJob) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransferJob.ProtoReflect.Descriptor instead.
func (*TransferJob) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{18}
}

func (x *TransferJob) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TransferJob) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *TransferJob) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *TransferJob) GetTransferSpec() *TransferSpec {
	if x != nil {
		return x.TransferSpec
	}
	return nil
}

func (x *TransferJob) GetNotificationConfig() *NotificationConfig {
	if x != nil {
		return x.NotificationConfig
	}
	return nil
}

func (x *TransferJob) GetLoggingConfig() *LoggingConfig {
	if x != nil {
		return x.LoggingConfig
	}
	return nil
}

func (x *TransferJob) GetSchedule() *Schedule {
	if x != nil {
		return x.Schedule
	}
	return nil
}

func (x *TransferJob) GetEventStream() *EventStream {
	if x != nil {
		return x.EventStream
	}
	return nil
}

func (x *TransferJob) GetStatus() TransferJob_Status {
	if x != nil {
		return x.Status
	}
	return TransferJob_STATUS_UNSPECIFIED
}

func (x *TransferJob) GetCreationTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreationTime
	}
	return nil
}

func (x *TransferJob) GetLastModificationTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastModificationTime
	}
	return nil
}

func (x *TransferJob) GetDeletionTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DeletionTime
	}
	return nil
}

func (x *TransferJob) GetLatestOperationName() string {
	if x != nil {
		return x.LatestOperationName
	}
	return ""
}

// An entry describing an error that has occurred.
type ErrorLogEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A URL that refers to the target (a data source, a data sink,
	// or an object) with which the error is associated.
	Url string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	// A list of messages that carry the error details.
	ErrorDetails []string `protobuf:"bytes,3,rep,name=error_details,json=errorDetails,proto3" json:"error_details,omitempty"`
}

func (x *ErrorLogEntry) Reset() {
	*x = ErrorLogEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ErrorLogEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ErrorLogEntry) ProtoMessage() {}

func (x *ErrorLogEntry) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ErrorLogEntry.ProtoReflect.Descriptor instead.
func (*ErrorLogEntry) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{19}
}

func (x *ErrorLogEntry) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *ErrorLogEntry) GetErrorDetails() []string {
	if x != nil {
		return x.ErrorDetails
	}
	return nil
}

// A summary of errors by error code, plus a count and sample error log
// entries.
type ErrorSummary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required.
	ErrorCode code.Code `protobuf:"varint,1,opt,name=error_code,json=errorCode,proto3,enum=google.rpc.Code" json:"error_code,omitempty"`
	// Required. Count of this type of error.
	ErrorCount int64 `protobuf:"varint,2,opt,name=error_count,json=errorCount,proto3" json:"error_count,omitempty"`
	// Error samples.
	//
	// At most 5 error log entries are recorded for a given
	// error code for a single transfer operation.
	ErrorLogEntries []*ErrorLogEntry `protobuf:"bytes,3,rep,name=error_log_entries,json=errorLogEntries,proto3" json:"error_log_entries,omitempty"`
}

func (x *ErrorSummary) Reset() {
	*x = ErrorSummary{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ErrorSummary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ErrorSummary) ProtoMessage() {}

func (x *ErrorSummary) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ErrorSummary.ProtoReflect.Descriptor instead.
func (*ErrorSummary) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{20}
}

func (x *ErrorSummary) GetErrorCode() code.Code {
	if x != nil {
		return x.ErrorCode
	}
	return code.Code(0)
}

func (x *ErrorSummary) GetErrorCount() int64 {
	if x != nil {
		return x.ErrorCount
	}
	return 0
}

func (x *ErrorSummary) GetErrorLogEntries() []*ErrorLogEntry {
	if x != nil {
		return x.ErrorLogEntries
	}
	return nil
}

// A collection of counters that report the progress of a transfer operation.
type TransferCounters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Objects found in the data source that are scheduled to be transferred,
	// excluding any that are filtered based on object conditions or skipped due
	// to sync.
	ObjectsFoundFromSource int64 `protobuf:"varint,1,opt,name=objects_found_from_source,json=objectsFoundFromSource,proto3" json:"objects_found_from_source,omitempty"`
	// Bytes found in the data source that are scheduled to be transferred,
	// excluding any that are filtered based on object conditions or skipped due
	// to sync.
	BytesFoundFromSource int64 `protobuf:"varint,2,opt,name=bytes_found_from_source,json=bytesFoundFromSource,proto3" json:"bytes_found_from_source,omitempty"`
	// Objects found only in the data sink that are scheduled to be deleted.
	ObjectsFoundOnlyFromSink int64 `protobuf:"varint,3,opt,name=objects_found_only_from_sink,json=objectsFoundOnlyFromSink,proto3" json:"objects_found_only_from_sink,omitempty"`
	// Bytes found only in the data sink that are scheduled to be deleted.
	BytesFoundOnlyFromSink int64 `protobuf:"varint,4,opt,name=bytes_found_only_from_sink,json=bytesFoundOnlyFromSink,proto3" json:"bytes_found_only_from_sink,omitempty"`
	// Objects in the data source that are not transferred because they already
	// exist in the data sink.
	ObjectsFromSourceSkippedBySync int64 `protobuf:"varint,5,opt,name=objects_from_source_skipped_by_sync,json=objectsFromSourceSkippedBySync,proto3" json:"objects_from_source_skipped_by_sync,omitempty"`
	// Bytes in the data source that are not transferred because they already
	// exist in the data sink.
	BytesFromSourceSkippedBySync int64 `protobuf:"varint,6,opt,name=bytes_from_source_skipped_by_sync,json=bytesFromSourceSkippedBySync,proto3" json:"bytes_from_source_skipped_by_sync,omitempty"`
	// Objects that are copied to the data sink.
	ObjectsCopiedToSink int64 `protobuf:"varint,7,opt,name=objects_copied_to_sink,json=objectsCopiedToSink,proto3" json:"objects_copied_to_sink,omitempty"`
	// Bytes that are copied to the data sink.
	BytesCopiedToSink int64 `protobuf:"varint,8,opt,name=bytes_copied_to_sink,json=bytesCopiedToSink,proto3" json:"bytes_copied_to_sink,omitempty"`
	// Objects that are deleted from the data source.
	ObjectsDeletedFromSource int64 `protobuf:"varint,9,opt,name=objects_deleted_from_source,json=objectsDeletedFromSource,proto3" json:"objects_deleted_from_source,omitempty"`
	// Bytes that are deleted from the data source.
	BytesDeletedFromSource int64 `protobuf:"varint,10,opt,name=bytes_deleted_from_source,json=bytesDeletedFromSource,proto3" json:"bytes_deleted_from_source,omitempty"`
	// Objects that are deleted from the data sink.
	ObjectsDeletedFromSink int64 `protobuf:"varint,11,opt,name=objects_deleted_from_sink,json=objectsDeletedFromSink,proto3" json:"objects_deleted_from_sink,omitempty"`
	// Bytes that are deleted from the data sink.
	BytesDeletedFromSink int64 `protobuf:"varint,12,opt,name=bytes_deleted_from_sink,json=bytesDeletedFromSink,proto3" json:"bytes_deleted_from_sink,omitempty"`
	// Objects in the data source that failed to be transferred or that failed
	// to be deleted after being transferred.
	ObjectsFromSourceFailed int64 `protobuf:"varint,13,opt,name=objects_from_source_failed,json=objectsFromSourceFailed,proto3" json:"objects_from_source_failed,omitempty"`
	// Bytes in the data source that failed to be transferred or that failed to
	// be deleted after being transferred.
	BytesFromSourceFailed int64 `protobuf:"varint,14,opt,name=bytes_from_source_failed,json=bytesFromSourceFailed,proto3" json:"bytes_from_source_failed,omitempty"`
	// Objects that failed to be deleted from the data sink.
	ObjectsFailedToDeleteFromSink int64 `protobuf:"varint,15,opt,name=objects_failed_to_delete_from_sink,json=objectsFailedToDeleteFromSink,proto3" json:"objects_failed_to_delete_from_sink,omitempty"`
	// Bytes that failed to be deleted from the data sink.
	BytesFailedToDeleteFromSink int64 `protobuf:"varint,16,opt,name=bytes_failed_to_delete_from_sink,json=bytesFailedToDeleteFromSink,proto3" json:"bytes_failed_to_delete_from_sink,omitempty"`
	// For transfers involving PosixFilesystem only.
	//
	// Number of directories found while listing. For example, if the root
	// directory of the transfer is `base/` and there are two other directories,
	// `a/` and `b/` under this directory, the count after listing `base/`,
	// `base/a/` and `base/b/` is 3.
	DirectoriesFoundFromSource int64 `protobuf:"varint,17,opt,name=directories_found_from_source,json=directoriesFoundFromSource,proto3" json:"directories_found_from_source,omitempty"`
	// For transfers involving PosixFilesystem only.
	//
	// Number of listing failures for each directory found at the source.
	// Potential failures when listing a directory include permission failure or
	// block failure. If listing a directory fails, no files in the directory are
	// transferred.
	DirectoriesFailedToListFromSource int64 `protobuf:"varint,18,opt,name=directories_failed_to_list_from_source,json=directoriesFailedToListFromSource,proto3" json:"directories_failed_to_list_from_source,omitempty"`
	// For transfers involving PosixFilesystem only.
	//
	// Number of successful listings for each directory found at the source.
	DirectoriesSuccessfullyListedFromSource int64 `protobuf:"varint,19,opt,name=directories_successfully_listed_from_source,json=directoriesSuccessfullyListedFromSource,proto3" json:"directories_successfully_listed_from_source,omitempty"`
	// Number of successfully cleaned up intermediate objects.
	IntermediateObjectsCleanedUp int64 `protobuf:"varint,22,opt,name=intermediate_objects_cleaned_up,json=intermediateObjectsCleanedUp,proto3" json:"intermediate_objects_cleaned_up,omitempty"`
	// Number of intermediate objects failed cleaned up.
	IntermediateObjectsFailedCleanedUp int64 `protobuf:"varint,23,opt,name=intermediate_objects_failed_cleaned_up,json=intermediateObjectsFailedCleanedUp,proto3" json:"intermediate_objects_failed_cleaned_up,omitempty"`
}

func (x *TransferCounters) Reset() {
	*x = TransferCounters{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransferCounters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransferCounters) ProtoMessage() {}

func (x *TransferCounters) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransferCounters.ProtoReflect.Descriptor instead.
func (*TransferCounters) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{21}
}

func (x *TransferCounters) GetObjectsFoundFromSource() int64 {
	if x != nil {
		return x.ObjectsFoundFromSource
	}
	return 0
}

func (x *TransferCounters) GetBytesFoundFromSource() int64 {
	if x != nil {
		return x.BytesFoundFromSource
	}
	return 0
}

func (x *TransferCounters) GetObjectsFoundOnlyFromSink() int64 {
	if x != nil {
		return x.ObjectsFoundOnlyFromSink
	}
	return 0
}

func (x *TransferCounters) GetBytesFoundOnlyFromSink() int64 {
	if x != nil {
		return x.BytesFoundOnlyFromSink
	}
	return 0
}

func (x *TransferCounters) GetObjectsFromSourceSkippedBySync() int64 {
	if x != nil {
		return x.ObjectsFromSourceSkippedBySync
	}
	return 0
}

func (x *TransferCounters) GetBytesFromSourceSkippedBySync() int64 {
	if x != nil {
		return x.BytesFromSourceSkippedBySync
	}
	return 0
}

func (x *TransferCounters) GetObjectsCopiedToSink() int64 {
	if x != nil {
		return x.ObjectsCopiedToSink
	}
	return 0
}

func (x *TransferCounters) GetBytesCopiedToSink() int64 {
	if x != nil {
		return x.BytesCopiedToSink
	}
	return 0
}

func (x *TransferCounters) GetObjectsDeletedFromSource() int64 {
	if x != nil {
		return x.ObjectsDeletedFromSource
	}
	return 0
}

func (x *TransferCounters) GetBytesDeletedFromSource() int64 {
	if x != nil {
		return x.BytesDeletedFromSource
	}
	return 0
}

func (x *TransferCounters) GetObjectsDeletedFromSink() int64 {
	if x != nil {
		return x.ObjectsDeletedFromSink
	}
	return 0
}

func (x *TransferCounters) GetBytesDeletedFromSink() int64 {
	if x != nil {
		return x.BytesDeletedFromSink
	}
	return 0
}

func (x *TransferCounters) GetObjectsFromSourceFailed() int64 {
	if x != nil {
		return x.ObjectsFromSourceFailed
	}
	return 0
}

func (x *TransferCounters) GetBytesFromSourceFailed() int64 {
	if x != nil {
		return x.BytesFromSourceFailed
	}
	return 0
}

func (x *TransferCounters) GetObjectsFailedToDeleteFromSink() int64 {
	if x != nil {
		return x.ObjectsFailedToDeleteFromSink
	}
	return 0
}

func (x *TransferCounters) GetBytesFailedToDeleteFromSink() int64 {
	if x != nil {
		return x.BytesFailedToDeleteFromSink
	}
	return 0
}

func (x *TransferCounters) GetDirectoriesFoundFromSource() int64 {
	if x != nil {
		return x.DirectoriesFoundFromSource
	}
	return 0
}

func (x *TransferCounters) GetDirectoriesFailedToListFromSource() int64 {
	if x != nil {
		return x.DirectoriesFailedToListFromSource
	}
	return 0
}

func (x *TransferCounters) GetDirectoriesSuccessfullyListedFromSource() int64 {
	if x != nil {
		return x.DirectoriesSuccessfullyListedFromSource
	}
	return 0
}

func (x *TransferCounters) GetIntermediateObjectsCleanedUp() int64 {
	if x != nil {
		return x.IntermediateObjectsCleanedUp
	}
	return 0
}

func (x *TransferCounters) GetIntermediateObjectsFailedCleanedUp() int64 {
	if x != nil {
		return x.IntermediateObjectsFailedCleanedUp
	}
	return 0
}

// Specification to configure notifications published to Pub/Sub.
// Notifications are published to the customer-provided topic using the
// following `PubsubMessage.attributes`:
//
// * `"eventType"`: one of the
// [EventType][google.storagetransfer.v1.NotificationConfig.EventType] values
// * `"payloadFormat"`: one of the
// [PayloadFormat][google.storagetransfer.v1.NotificationConfig.PayloadFormat]
// values
// * `"projectId"`: the
// [project_id][google.storagetransfer.v1.TransferOperation.project_id] of the
// `TransferOperation`
// * `"transferJobName"`: the
// [transfer_job_name][google.storagetransfer.v1.TransferOperation.transfer_job_name]
// of the `TransferOperation`
// * `"transferOperationName"`: the
// [name][google.storagetransfer.v1.TransferOperation.name] of the
// `TransferOperation`
//
// The `PubsubMessage.data` contains a
// [TransferOperation][google.storagetransfer.v1.TransferOperation] resource
// formatted according to the specified `PayloadFormat`.
type NotificationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The `Topic.name` of the Pub/Sub topic to which to publish
	// notifications. Must be of the format: `projects/{project}/topics/{topic}`.
	// Not matching this format results in an
	// [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT] error.
	PubsubTopic string `protobuf:"bytes,1,opt,name=pubsub_topic,json=pubsubTopic,proto3" json:"pubsub_topic,omitempty"`
	// Event types for which a notification is desired. If empty, send
	// notifications for all event types.
	EventTypes []NotificationConfig_EventType `protobuf:"varint,2,rep,packed,name=event_types,json=eventTypes,proto3,enum=google.storagetransfer.v1.NotificationConfig_EventType" json:"event_types,omitempty"`
	// Required. The desired format of the notification message payloads.
	PayloadFormat NotificationConfig_PayloadFormat `protobuf:"varint,3,opt,name=payload_format,json=payloadFormat,proto3,enum=google.storagetransfer.v1.NotificationConfig_PayloadFormat" json:"payload_format,omitempty"`
}

func (x *NotificationConfig) Reset() {
	*x = NotificationConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NotificationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NotificationConfig) ProtoMessage() {}

func (x *NotificationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NotificationConfig.ProtoReflect.Descriptor instead.
func (*NotificationConfig) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{22}
}

func (x *NotificationConfig) GetPubsubTopic() string {
	if x != nil {
		return x.PubsubTopic
	}
	return ""
}

func (x *NotificationConfig) GetEventTypes() []NotificationConfig_EventType {
	if x != nil {
		return x.EventTypes
	}
	return nil
}

func (x *NotificationConfig) GetPayloadFormat() NotificationConfig_PayloadFormat {
	if x != nil {
		return x.PayloadFormat
	}
	return NotificationConfig_PAYLOAD_FORMAT_UNSPECIFIED
}

// Specifies the logging behavior for transfer operations.
//
// For cloud-to-cloud transfers, logs are sent to Cloud Logging. See
// [Read transfer
// logs](https://cloud.google.com/storage-transfer/docs/read-transfer-logs) for
// details.
//
// For transfers to or from a POSIX file system, logs are stored in the
// Cloud Storage bucket that is the source or sink of the transfer.
// See [Managing Transfer for on-premises jobs]
// (https://cloud.google.com/storage-transfer/docs/managing-on-prem-jobs#viewing-logs)
// for details.
type LoggingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies the actions to be logged. If empty, no logs are generated.
	// Not supported for transfers with PosixFilesystem data sources; use
	// [enable_onprem_gcs_transfer_logs][google.storagetransfer.v1.LoggingConfig.enable_onprem_gcs_transfer_logs]
	// instead.
	LogActions []LoggingConfig_LoggableAction `protobuf:"varint,1,rep,packed,name=log_actions,json=logActions,proto3,enum=google.storagetransfer.v1.LoggingConfig_LoggableAction" json:"log_actions,omitempty"`
	// States in which `log_actions` are logged. If empty, no logs are generated.
	// Not supported for transfers with PosixFilesystem data sources; use
	// [enable_onprem_gcs_transfer_logs][google.storagetransfer.v1.LoggingConfig.enable_onprem_gcs_transfer_logs]
	// instead.
	LogActionStates []LoggingConfig_LoggableActionState `protobuf:"varint,2,rep,packed,name=log_action_states,json=logActionStates,proto3,enum=google.storagetransfer.v1.LoggingConfig_LoggableActionState" json:"log_action_states,omitempty"`
	// For transfers with a PosixFilesystem source, this option enables the Cloud
	// Storage transfer logs for this transfer.
	EnableOnpremGcsTransferLogs bool `protobuf:"varint,3,opt,name=enable_onprem_gcs_transfer_logs,json=enableOnpremGcsTransferLogs,proto3" json:"enable_onprem_gcs_transfer_logs,omitempty"`
}

func (x *LoggingConfig) Reset() {
	*x = LoggingConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LoggingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoggingConfig) ProtoMessage() {}

func (x *LoggingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoggingConfig.ProtoReflect.Descriptor instead.
func (*LoggingConfig) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{23}
}

func (x *LoggingConfig) GetLogActions() []LoggingConfig_LoggableAction {
	if x != nil {
		return x.LogActions
	}
	return nil
}

func (x *LoggingConfig) GetLogActionStates() []LoggingConfig_LoggableActionState {
	if x != nil {
		return x.LogActionStates
	}
	return nil
}

func (x *LoggingConfig) GetEnableOnpremGcsTransferLogs() bool {
	if x != nil {
		return x.EnableOnpremGcsTransferLogs
	}
	return false
}

// A description of the execution of a transfer.
type TransferOperation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A globally unique ID assigned by the system.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The ID of the Google Cloud project that owns the operation.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Transfer specification.
	TransferSpec *TransferSpec `protobuf:"bytes,3,opt,name=transfer_spec,json=transferSpec,proto3" json:"transfer_spec,omitempty"`
	// Notification configuration.
	NotificationConfig *NotificationConfig `protobuf:"bytes,10,opt,name=notification_config,json=notificationConfig,proto3" json:"notification_config,omitempty"`
	// Cloud Logging configuration.
	LoggingConfig *LoggingConfig `protobuf:"bytes,12,opt,name=logging_config,json=loggingConfig,proto3" json:"logging_config,omitempty"`
	// Start time of this transfer execution.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// End time of this transfer execution.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Status of the transfer operation.
	Status TransferOperation_Status `protobuf:"varint,6,opt,name=status,proto3,enum=google.storagetransfer.v1.TransferOperation_Status" json:"status,omitempty"`
	// Information about the progress of the transfer operation.
	Counters *TransferCounters `protobuf:"bytes,7,opt,name=counters,proto3" json:"counters,omitempty"`
	// Summarizes errors encountered with sample error log entries.
	ErrorBreakdowns []*ErrorSummary `protobuf:"bytes,8,rep,name=error_breakdowns,json=errorBreakdowns,proto3" json:"error_breakdowns,omitempty"`
	// The name of the transfer job that triggers this transfer operation.
	TransferJobName string `protobuf:"bytes,9,opt,name=transfer_job_name,json=transferJobName,proto3" json:"transfer_job_name,omitempty"`
}

func (x *TransferOperation) Reset() {
	*x = TransferOperation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransferOperation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransferOperation) ProtoMessage() {}

func (x *TransferOperation) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransferOperation.ProtoReflect.Descriptor instead.
func (*TransferOperation) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{24}
}

func (x *TransferOperation) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TransferOperation) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *TransferOperation) GetTransferSpec() *TransferSpec {
	if x != nil {
		return x.TransferSpec
	}
	return nil
}

func (x *TransferOperation) GetNotificationConfig() *NotificationConfig {
	if x != nil {
		return x.NotificationConfig
	}
	return nil
}

func (x *TransferOperation) GetLoggingConfig() *LoggingConfig {
	if x != nil {
		return x.LoggingConfig
	}
	return nil
}

func (x *TransferOperation) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *TransferOperation) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *TransferOperation) GetStatus() TransferOperation_Status {
	if x != nil {
		return x.Status
	}
	return TransferOperation_STATUS_UNSPECIFIED
}

func (x *TransferOperation) GetCounters() *TransferCounters {
	if x != nil {
		return x.Counters
	}
	return nil
}

func (x *TransferOperation) GetErrorBreakdowns() []*ErrorSummary {
	if x != nil {
		return x.ErrorBreakdowns
	}
	return nil
}

func (x *TransferOperation) GetTransferJobName() string {
	if x != nil {
		return x.TransferJobName
	}
	return ""
}

// Specifies a bandwidth limit for an agent pool.
type AgentPool_BandwidthLimit struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Bandwidth rate in megabytes per second, distributed across all the agents
	// in the pool.
	LimitMbps int64 `protobuf:"varint,1,opt,name=limit_mbps,json=limitMbps,proto3" json:"limit_mbps,omitempty"`
}

func (x *AgentPool_BandwidthLimit) Reset() {
	*x = AgentPool_BandwidthLimit{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AgentPool_BandwidthLimit) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AgentPool_BandwidthLimit) ProtoMessage() {}

func (x *AgentPool_BandwidthLimit) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AgentPool_BandwidthLimit.ProtoReflect.Descriptor instead.
func (*AgentPool_BandwidthLimit) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{11, 0}
}

func (x *AgentPool_BandwidthLimit) GetLimitMbps() int64 {
	if x != nil {
		return x.LimitMbps
	}
	return 0
}

var File_google_storagetransfer_v1_transfer_types_proto protoreflect.FileDescriptor

var file_google_storagetransfer_v1_transfer_types_proto_rawDesc = []byte{
	0x0a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x65, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65,
	0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x72, 0x70, 0x63, 0x2f, 0x63, 0x6f, 0x64, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x64, 0x61, 0x74,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x74, 0x79, 0x70, 0x65, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x66, 0x64, 0x61, 0x79, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0x5a, 0x0a, 0x14, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x23, 0x0a, 0x0d,
	0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x45, 0x6d, 0x61, 0x69,
	0x6c, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64,
	0x22, 0x68, 0x0a, 0x0c, 0x41, 0x77, 0x73, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4b, 0x65, 0x79,
	0x12, 0x27, 0x0a, 0x0d, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x61, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x4b, 0x65, 0x79, 0x49, 0x64, 0x12, 0x2f, 0x0a, 0x11, 0x73, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x73, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4b, 0x65, 0x79, 0x22, 0x34, 0x0a, 0x10, 0x41, 0x7a,
	0x75, 0x72, 0x65, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x12, 0x20,
	0x0a, 0x09, 0x73, 0x61, 0x73, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x73, 0x61, 0x73, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0xe6, 0x03, 0x0a, 0x10, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x64, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x70, 0x0a, 0x28, 0x6d, 0x69, 0x6e, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x5f, 0x65, 0x6c, 0x61, 0x70, 0x73, 0x65, 0x64, 0x5f, 0x73, 0x69, 0x6e, 0x63, 0x65, 0x5f,
	0x6c, 0x61, 0x73, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x23, 0x6d, 0x69, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x45, 0x6c, 0x61, 0x70, 0x73,
	0x65, 0x64, 0x53, 0x69, 0x6e, 0x63, 0x65, 0x4c, 0x61, 0x73, 0x74, 0x4d, 0x6f, 0x64, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x70, 0x0a, 0x28, 0x6d, 0x61, 0x78, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x5f, 0x65, 0x6c, 0x61, 0x70, 0x73, 0x65, 0x64, 0x5f, 0x73, 0x69, 0x6e, 0x63,
	0x65, 0x5f, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x23, 0x6d, 0x61, 0x78, 0x54, 0x69, 0x6d, 0x65, 0x45, 0x6c, 0x61,
	0x70, 0x73, 0x65, 0x64, 0x53, 0x69, 0x6e, 0x63, 0x65, 0x4c, 0x61, 0x73, 0x74, 0x4d, 0x6f, 0x64,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x29, 0x0a, 0x10, 0x69, 0x6e, 0x63,
	0x6c, 0x75, 0x64, 0x65, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x65, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x0f, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x50, 0x72, 0x65, 0x66,
	0x69, 0x78, 0x65, 0x73, 0x12, 0x29, 0x0a, 0x10, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f,
	0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f,
	0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x65, 0x73, 0x12,
	0x4a, 0x0a, 0x13, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x64,
	0x5f, 0x73, 0x69, 0x6e, 0x63, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x11, 0x6c, 0x61, 0x73, 0x74, 0x4d, 0x6f,
	0x64, 0x69, 0x66, 0x69, 0x65, 0x64, 0x53, 0x69, 0x6e, 0x63, 0x65, 0x12, 0x4c, 0x0a, 0x14, 0x6c,
	0x61, 0x73, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x64, 0x5f, 0x62, 0x65, 0x66,
	0x6f, 0x72, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x12, 0x6c, 0x61, 0x73, 0x74, 0x4d, 0x6f, 0x64, 0x69, 0x66,
	0x69, 0x65, 0x64, 0x42, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x22, 0x43, 0x0a, 0x07, 0x47, 0x63, 0x73,
	0x44, 0x61, 0x74, 0x61, 0x12, 0x24, 0x0a, 0x0b, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a,
	0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61,
	0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x22, 0xe8,
	0x01, 0x0a, 0x09, 0x41, 0x77, 0x73, 0x53, 0x33, 0x44, 0x61, 0x74, 0x61, 0x12, 0x24, 0x0a, 0x0b,
	0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x52, 0x0a, 0x0e, 0x61, 0x77, 0x73, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x4b, 0x65, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x52, 0x0c, 0x61, 0x77, 0x73, 0x41, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x4b, 0x65, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x19, 0x0a, 0x08, 0x72, 0x6f,
	0x6c, 0x65, 0x5f, 0x61, 0x72, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x72, 0x6f,
	0x6c, 0x65, 0x41, 0x72, 0x6e, 0x12, 0x32, 0x0a, 0x12, 0x63, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x61, 0x6c, 0x73, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x63, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x61, 0x6c, 0x73, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x22, 0x91, 0x02, 0x0a, 0x14, 0x41, 0x7a,
	0x75, 0x72, 0x65, 0x42, 0x6c, 0x6f, 0x62, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x44, 0x61,
	0x74, 0x61, 0x12, 0x2c, 0x0a, 0x0f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x12, 0x60, 0x0a, 0x11, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x72, 0x65, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x61, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x72, 0x65,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x04,
	0x52, 0x10, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61,
	0x6c, 0x73, 0x12, 0x21, 0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x32, 0x0a, 0x12, 0x63, 0x72, 0x65,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x63, 0x72, 0x65, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x22, 0x2a, 0x0a,
	0x08, 0x48, 0x74, 0x74, 0x70, 0x44, 0x61, 0x74, 0x61, 0x12, 0x1e, 0x0a, 0x08, 0x6c, 0x69, 0x73,
	0x74, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x07, 0x6c, 0x69, 0x73, 0x74, 0x55, 0x72, 0x6c, 0x22, 0x38, 0x0a, 0x0f, 0x50, 0x6f, 0x73,
	0x69, 0x78, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x12, 0x25, 0x0a, 0x0e,
	0x72, 0x6f, 0x6f, 0x74, 0x5f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x72, 0x6f, 0x6f, 0x74, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x79, 0x22, 0xed, 0x01, 0x0a, 0x13, 0x41, 0x77, 0x73, 0x53, 0x33, 0x43, 0x6f, 0x6d,
	0x70, 0x61, 0x74, 0x69, 0x62, 0x6c, 0x65, 0x44, 0x61, 0x74, 0x61, 0x12, 0x24, 0x0a, 0x0b, 0x62,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x1f, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x65, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x12, 0x52,
	0x0a, 0x0b, 0x73, 0x33, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x33, 0x43, 0x6f, 0x6d, 0x70, 0x61, 0x74, 0x69, 0x62, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x0a, 0x73, 0x33, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x42, 0x0f, 0x0a, 0x0d, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x70, 0x72, 0x6f, 0x76, 0x69,
	0x64, 0x65, 0x72, 0x22, 0xa3, 0x06, 0x0a, 0x14, 0x53, 0x33, 0x43, 0x6f, 0x6d, 0x70, 0x61, 0x74,
	0x69, 0x62, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x5b, 0x0a, 0x0b,
	0x61, 0x75, 0x74, 0x68, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x33,
	0x43, 0x6f, 0x6d, 0x70, 0x61, 0x74, 0x69, 0x62, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x52, 0x0a, 0x61,
	0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x61, 0x0a, 0x0d, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x33, 0x43,
	0x6f, 0x6d, 0x70, 0x61, 0x74, 0x69, 0x62, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x0c,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x5b, 0x0a, 0x08,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x33, 0x43, 0x6f, 0x6d,
	0x70, 0x61, 0x74, 0x69, 0x62, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e,
	0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x52,
	0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x52, 0x0a, 0x08, 0x6c, 0x69, 0x73,
	0x74, 0x5f, 0x61, 0x70, 0x69, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x33, 0x43, 0x6f, 0x6d, 0x70, 0x61, 0x74,
	0x69, 0x62, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x41, 0x70, 0x69, 0x52, 0x07, 0x6c, 0x69, 0x73, 0x74, 0x41, 0x70, 0x69, 0x22, 0x6d, 0x0a,
	0x0a, 0x41, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x1b, 0x0a, 0x17, 0x41,
	0x55, 0x54, 0x48, 0x5f, 0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x20, 0x0a, 0x1c, 0x41, 0x55, 0x54, 0x48,
	0x5f, 0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44, 0x5f, 0x41, 0x57, 0x53, 0x5f, 0x53, 0x49, 0x47, 0x4e,
	0x41, 0x54, 0x55, 0x52, 0x45, 0x5f, 0x56, 0x34, 0x10, 0x01, 0x12, 0x20, 0x0a, 0x1c, 0x41, 0x55,
	0x54, 0x48, 0x5f, 0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44, 0x5f, 0x41, 0x57, 0x53, 0x5f, 0x53, 0x49,
	0x47, 0x4e, 0x41, 0x54, 0x55, 0x52, 0x45, 0x5f, 0x56, 0x32, 0x10, 0x02, 0x22, 0x73, 0x0a, 0x0c,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x1d, 0x0a, 0x19,
	0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x4c, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x26, 0x0a, 0x22, 0x52,
	0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x4c, 0x5f, 0x56, 0x49, 0x52,
	0x54, 0x55, 0x41, 0x4c, 0x5f, 0x48, 0x4f, 0x53, 0x54, 0x45, 0x44, 0x5f, 0x53, 0x54, 0x59, 0x4c,
	0x45, 0x10, 0x01, 0x12, 0x1c, 0x0a, 0x18, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x5f, 0x4d,
	0x4f, 0x44, 0x45, 0x4c, 0x5f, 0x50, 0x41, 0x54, 0x48, 0x5f, 0x53, 0x54, 0x59, 0x4c, 0x45, 0x10,
	0x02, 0x22, 0x6a, 0x0a, 0x0f, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x20, 0x0a, 0x1c, 0x4e, 0x45, 0x54, 0x57, 0x4f, 0x52, 0x4b, 0x5f,
	0x50, 0x52, 0x4f, 0x54, 0x4f, 0x43, 0x4f, 0x4c, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1a, 0x0a, 0x16, 0x4e, 0x45, 0x54, 0x57, 0x4f, 0x52,
	0x4b, 0x5f, 0x50, 0x52, 0x4f, 0x54, 0x4f, 0x43, 0x4f, 0x4c, 0x5f, 0x48, 0x54, 0x54, 0x50, 0x53,
	0x10, 0x01, 0x12, 0x19, 0x0a, 0x15, 0x4e, 0x45, 0x54, 0x57, 0x4f, 0x52, 0x4b, 0x5f, 0x50, 0x52,
	0x4f, 0x54, 0x4f, 0x43, 0x4f, 0x4c, 0x5f, 0x48, 0x54, 0x54, 0x50, 0x10, 0x02, 0x22, 0x4a, 0x0a,
	0x07, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x70, 0x69, 0x12, 0x18, 0x0a, 0x14, 0x4c, 0x49, 0x53, 0x54,
	0x5f, 0x41, 0x50, 0x49, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x4c, 0x49, 0x53, 0x54, 0x5f, 0x4f, 0x42, 0x4a, 0x45, 0x43,
	0x54, 0x53, 0x5f, 0x56, 0x32, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x4c, 0x49, 0x53, 0x54, 0x5f,
	0x4f, 0x42, 0x4a, 0x45, 0x43, 0x54, 0x53, 0x10, 0x02, 0x22, 0xc8, 0x03, 0x0a, 0x09, 0x41, 0x67,
	0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x45, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x67, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x5c, 0x0a, 0x0f, 0x62, 0x61,
	0x6e, 0x64, 0x77, 0x69, 0x64, 0x74, 0x68, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x67, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x2e, 0x42, 0x61, 0x6e, 0x64, 0x77, 0x69,
	0x64, 0x74, 0x68, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x52, 0x0e, 0x62, 0x61, 0x6e, 0x64, 0x77, 0x69,
	0x64, 0x74, 0x68, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x1a, 0x2f, 0x0a, 0x0e, 0x42, 0x61, 0x6e, 0x64,
	0x77, 0x69, 0x64, 0x74, 0x68, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x6c, 0x69,
	0x6d, 0x69, 0x74, 0x5f, 0x6d, 0x62, 0x70, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09,
	0x6c, 0x69, 0x6d, 0x69, 0x74, 0x4d, 0x62, 0x70, 0x73, 0x22, 0x47, 0x0a, 0x05, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45,
	0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x43, 0x52, 0x45, 0x41, 0x54,
	0x45, 0x44, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47,
	0x10, 0x03, 0x3a, 0x60, 0xea, 0x41, 0x5d, 0x0a, 0x29, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6f,
	0x6c, 0x73, 0x12, 0x30, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x50,
	0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x7b, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x6f, 0x6f, 0x6c,
	0x5f, 0x69, 0x64, 0x7d, 0x22, 0x96, 0x04, 0x0a, 0x0f, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65,
	0x72, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x59, 0x0a, 0x2a, 0x6f, 0x76, 0x65, 0x72,
	0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x5f, 0x61, 0x6c,
	0x72, 0x65, 0x61, 0x64, 0x79, 0x5f, 0x65, 0x78, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x69,
	0x6e, 0x5f, 0x73, 0x69, 0x6e, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x25, 0x6f, 0x76,
	0x65, 0x72, 0x77, 0x72, 0x69, 0x74, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x41, 0x6c,
	0x72, 0x65, 0x61, 0x64, 0x79, 0x45, 0x78, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x53,
	0x69, 0x6e, 0x6b, 0x12, 0x40, 0x0a, 0x1d, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x6f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x5f, 0x75, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x5f, 0x69, 0x6e, 0x5f,
	0x73, 0x69, 0x6e, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x19, 0x64, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x55, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x49,
	0x6e, 0x53, 0x69, 0x6e, 0x6b, 0x12, 0x57, 0x0a, 0x29, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f,
	0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x5f, 0x61, 0x66, 0x74, 0x65, 0x72, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x24, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x46, 0x72, 0x6f, 0x6d, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x41, 0x66, 0x74, 0x65, 0x72, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x12, 0x5f,
	0x0a, 0x0e, 0x6f, 0x76, 0x65, 0x72, 0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x77, 0x68, 0x65, 0x6e,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x4f, 0x76, 0x65, 0x72, 0x77, 0x72, 0x69, 0x74, 0x65, 0x57, 0x68, 0x65, 0x6e,
	0x52, 0x0d, 0x6f, 0x76, 0x65, 0x72, 0x77, 0x72, 0x69, 0x74, 0x65, 0x57, 0x68, 0x65, 0x6e, 0x12,
	0x55, 0x0a, 0x10, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x6f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x0f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x55, 0x0a, 0x0d, 0x4f, 0x76, 0x65, 0x72, 0x77, 0x72,
	0x69, 0x74, 0x65, 0x57, 0x68, 0x65, 0x6e, 0x12, 0x1e, 0x0a, 0x1a, 0x4f, 0x56, 0x45, 0x52, 0x57,
	0x52, 0x49, 0x54, 0x45, 0x5f, 0x57, 0x48, 0x45, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x44, 0x49, 0x46, 0x46, 0x45,
	0x52, 0x45, 0x4e, 0x54, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x4e, 0x45, 0x56, 0x45, 0x52, 0x10,
	0x02, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x4c, 0x57, 0x41, 0x59, 0x53, 0x10, 0x03, 0x22, 0xfd, 0x09,
	0x0a, 0x0c, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x12, 0x48,
	0x0a, 0x0d, 0x67, 0x63, 0x73, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x69, 0x6e, 0x6b, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x47, 0x63, 0x73, 0x44, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x0b, 0x67, 0x63, 0x73,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x69, 0x6e, 0x6b, 0x12, 0x54, 0x0a, 0x0f, 0x70, 0x6f, 0x73, 0x69,
	0x78, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x69, 0x6e, 0x6b, 0x18, 0x0d, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f,
	0x73, 0x69, 0x78, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x48, 0x00, 0x52,
	0x0d, 0x70, 0x6f, 0x73, 0x69, 0x78, 0x44, 0x61, 0x74, 0x61, 0x53, 0x69, 0x6e, 0x6b, 0x12, 0x4c,
	0x0a, 0x0f, 0x67, 0x63, 0x73, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x63, 0x73, 0x44, 0x61, 0x74, 0x61, 0x48, 0x01, 0x52, 0x0d, 0x67,
	0x63, 0x73, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x53, 0x0a, 0x12,
	0x61, 0x77, 0x73, 0x5f, 0x73, 0x33, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x53, 0x33, 0x44, 0x61, 0x74, 0x61, 0x48, 0x01,
	0x52, 0x0f, 0x61, 0x77, 0x73, 0x53, 0x33, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x12, 0x4f, 0x0a, 0x10, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x44, 0x61, 0x74, 0x61,
	0x48, 0x01, 0x52, 0x0e, 0x68, 0x74, 0x74, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x12, 0x58, 0x0a, 0x11, 0x70, 0x6f, 0x73, 0x69, 0x78, 0x5f, 0x64, 0x61, 0x74, 0x61,
	0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x73, 0x69, 0x78, 0x46,
	0x69, 0x6c, 0x65, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x48, 0x01, 0x52, 0x0f, 0x70, 0x6f, 0x73,
	0x69, 0x78, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x75, 0x0a, 0x1e,
	0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x62, 0x6c, 0x6f, 0x62, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x42, 0x6c, 0x6f, 0x62, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x44, 0x61, 0x74, 0x61, 0x48, 0x01, 0x52, 0x1a, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x42, 0x6c,
	0x6f, 0x62, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x12, 0x72, 0x0a, 0x1d, 0x61, 0x77, 0x73, 0x5f, 0x73, 0x33, 0x5f, 0x63, 0x6f,
	0x6d, 0x70, 0x61, 0x74, 0x69, 0x62, 0x6c, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x53, 0x33, 0x43, 0x6f, 0x6d, 0x70,
	0x61, 0x74, 0x69, 0x62, 0x6c, 0x65, 0x44, 0x61, 0x74, 0x61, 0x48, 0x01, 0x52, 0x19, 0x61, 0x77,
	0x73, 0x53, 0x33, 0x43, 0x6f, 0x6d, 0x70, 0x61, 0x74, 0x69, 0x62, 0x6c, 0x65, 0x44, 0x61, 0x74,
	0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x69, 0x0a, 0x1e, 0x67, 0x63, 0x73, 0x5f, 0x69,
	0x6e, 0x74, 0x65, 0x72, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61,
	0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x63, 0x73, 0x44,
	0x61, 0x74, 0x61, 0x48, 0x02, 0x52, 0x1b, 0x67, 0x63, 0x73, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6d,
	0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x58, 0x0a, 0x11, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x63, 0x6f, 0x6e,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x10, 0x6f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x55, 0x0a, 0x10,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x0f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x58, 0x0a, 0x11, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x5f,
	0x6d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x52, 0x10, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x65, 0x72, 0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x12, 0x33, 0x0a,
	0x16, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x6f,
	0x6f, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x11, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x2f, 0x0a, 0x14, 0x73, 0x69, 0x6e, 0x6b, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x12, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x11, 0x73, 0x69, 0x6e, 0x6b, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x4e,
	0x61, 0x6d, 0x65, 0x42, 0x0b, 0x0a, 0x09, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x69, 0x6e, 0x6b,
	0x42, 0x0d, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42,
	0x1c, 0x0a, 0x1a, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x5f,
	0x64, 0x61, 0x74, 0x61, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xc1, 0x0c,
	0x0a, 0x0f, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x4c, 0x0a, 0x07, 0x73, 0x79, 0x6d, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x53,
	0x79, 0x6d, 0x6c, 0x69, 0x6e, 0x6b, 0x52, 0x07, 0x73, 0x79, 0x6d, 0x6c, 0x69, 0x6e, 0x6b, 0x12,
	0x43, 0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x04,
	0x6d, 0x6f, 0x64, 0x65, 0x12, 0x40, 0x0a, 0x03, 0x67, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x47, 0x49,
	0x44, 0x52, 0x03, 0x67, 0x69, 0x64, 0x12, 0x40, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x55, 0x49, 0x44, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x40, 0x0a, 0x03, 0x61, 0x63, 0x6c, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x41, 0x63, 0x6c, 0x52, 0x03, 0x61, 0x63, 0x6c, 0x12, 0x5c, 0x0a, 0x0d, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x53, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x52, 0x0c, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x12, 0x5f, 0x0a, 0x0e, 0x74, 0x65, 0x6d, 0x70,
	0x6f, 0x72, 0x61, 0x72, 0x79, 0x5f, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x54, 0x65, 0x6d,
	0x70, 0x6f, 0x72, 0x61, 0x72, 0x79, 0x48, 0x6f, 0x6c, 0x64, 0x52, 0x0d, 0x74, 0x65, 0x6d, 0x70,
	0x6f, 0x72, 0x61, 0x72, 0x79, 0x48, 0x6f, 0x6c, 0x64, 0x12, 0x4a, 0x0a, 0x07, 0x6b, 0x6d, 0x73,
	0x5f, 0x6b, 0x65, 0x79, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x4b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x52, 0x06, 0x6b,
	0x6d, 0x73, 0x4b, 0x65, 0x79, 0x12, 0x59, 0x0a, 0x0c, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x64, 0x52, 0x0b, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64,
	0x22, 0x4a, 0x0a, 0x07, 0x53, 0x79, 0x6d, 0x6c, 0x69, 0x6e, 0x6b, 0x12, 0x17, 0x0a, 0x13, 0x53,
	0x59, 0x4d, 0x4c, 0x49, 0x4e, 0x4b, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x53, 0x59, 0x4d, 0x4c, 0x49, 0x4e, 0x4b, 0x5f,
	0x53, 0x4b, 0x49, 0x50, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x53, 0x59, 0x4d, 0x4c, 0x49, 0x4e,
	0x4b, 0x5f, 0x50, 0x52, 0x45, 0x53, 0x45, 0x52, 0x56, 0x45, 0x10, 0x02, 0x22, 0x3e, 0x0a, 0x04,
	0x4d, 0x6f, 0x64, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x4d, 0x4f,
	0x44, 0x45, 0x5f, 0x53, 0x4b, 0x49, 0x50, 0x10, 0x01, 0x12, 0x11, 0x0a, 0x0d, 0x4d, 0x4f, 0x44,
	0x45, 0x5f, 0x50, 0x52, 0x45, 0x53, 0x45, 0x52, 0x56, 0x45, 0x10, 0x02, 0x22, 0x38, 0x0a, 0x03,
	0x47, 0x49, 0x44, 0x12, 0x13, 0x0a, 0x0f, 0x47, 0x49, 0x44, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x47, 0x49, 0x44, 0x5f,
	0x53, 0x4b, 0x49, 0x50, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x47, 0x49, 0x44, 0x5f, 0x4e, 0x55,
	0x4d, 0x42, 0x45, 0x52, 0x10, 0x02, 0x22, 0x38, 0x0a, 0x03, 0x55, 0x49, 0x44, 0x12, 0x13, 0x0a,
	0x0f, 0x55, 0x49, 0x44, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x49, 0x44, 0x5f, 0x53, 0x4b, 0x49, 0x50, 0x10, 0x01,
	0x12, 0x0e, 0x0a, 0x0a, 0x55, 0x49, 0x44, 0x5f, 0x4e, 0x55, 0x4d, 0x42, 0x45, 0x52, 0x10, 0x02,
	0x22, 0x50, 0x0a, 0x03, 0x41, 0x63, 0x6c, 0x12, 0x13, 0x0a, 0x0f, 0x41, 0x43, 0x4c, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x22, 0x0a, 0x1e,
	0x41, 0x43, 0x4c, 0x5f, 0x44, 0x45, 0x53, 0x54, 0x49, 0x4e, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x42, 0x55, 0x43, 0x4b, 0x45, 0x54, 0x5f, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x10, 0x01,
	0x12, 0x10, 0x0a, 0x0c, 0x41, 0x43, 0x4c, 0x5f, 0x50, 0x52, 0x45, 0x53, 0x45, 0x52, 0x56, 0x45,
	0x10, 0x02, 0x22, 0xe6, 0x01, 0x0a, 0x0c, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x43, 0x6c,
	0x61, 0x73, 0x73, 0x12, 0x1d, 0x0a, 0x19, 0x53, 0x54, 0x4f, 0x52, 0x41, 0x47, 0x45, 0x5f, 0x43,
	0x4c, 0x41, 0x53, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x2c, 0x0a, 0x28, 0x53, 0x54, 0x4f, 0x52, 0x41, 0x47, 0x45, 0x5f, 0x43, 0x4c,
	0x41, 0x53, 0x53, 0x5f, 0x44, 0x45, 0x53, 0x54, 0x49, 0x4e, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x42, 0x55, 0x43, 0x4b, 0x45, 0x54, 0x5f, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x10, 0x01,
	0x12, 0x1a, 0x0a, 0x16, 0x53, 0x54, 0x4f, 0x52, 0x41, 0x47, 0x45, 0x5f, 0x43, 0x4c, 0x41, 0x53,
	0x53, 0x5f, 0x50, 0x52, 0x45, 0x53, 0x45, 0x52, 0x56, 0x45, 0x10, 0x02, 0x12, 0x1a, 0x0a, 0x16,
	0x53, 0x54, 0x4f, 0x52, 0x41, 0x47, 0x45, 0x5f, 0x43, 0x4c, 0x41, 0x53, 0x53, 0x5f, 0x53, 0x54,
	0x41, 0x4e, 0x44, 0x41, 0x52, 0x44, 0x10, 0x03, 0x12, 0x1a, 0x0a, 0x16, 0x53, 0x54, 0x4f, 0x52,
	0x41, 0x47, 0x45, 0x5f, 0x43, 0x4c, 0x41, 0x53, 0x53, 0x5f, 0x4e, 0x45, 0x41, 0x52, 0x4c, 0x49,
	0x4e, 0x45, 0x10, 0x04, 0x12, 0x1a, 0x0a, 0x16, 0x53, 0x54, 0x4f, 0x52, 0x41, 0x47, 0x45, 0x5f,
	0x43, 0x4c, 0x41, 0x53, 0x53, 0x5f, 0x43, 0x4f, 0x4c, 0x44, 0x4c, 0x49, 0x4e, 0x45, 0x10, 0x05,
	0x12, 0x19, 0x0a, 0x15, 0x53, 0x54, 0x4f, 0x52, 0x41, 0x47, 0x45, 0x5f, 0x43, 0x4c, 0x41, 0x53,
	0x53, 0x5f, 0x41, 0x52, 0x43, 0x48, 0x49, 0x56, 0x45, 0x10, 0x06, 0x22, 0x65, 0x0a, 0x0d, 0x54,
	0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x72, 0x79, 0x48, 0x6f, 0x6c, 0x64, 0x12, 0x1e, 0x0a, 0x1a,
	0x54, 0x45, 0x4d, 0x50, 0x4f, 0x52, 0x41, 0x52, 0x59, 0x5f, 0x48, 0x4f, 0x4c, 0x44, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x17, 0x0a, 0x13,
	0x54, 0x45, 0x4d, 0x50, 0x4f, 0x52, 0x41, 0x52, 0x59, 0x5f, 0x48, 0x4f, 0x4c, 0x44, 0x5f, 0x53,
	0x4b, 0x49, 0x50, 0x10, 0x01, 0x12, 0x1b, 0x0a, 0x17, 0x54, 0x45, 0x4d, 0x50, 0x4f, 0x52, 0x41,
	0x52, 0x59, 0x5f, 0x48, 0x4f, 0x4c, 0x44, 0x5f, 0x50, 0x52, 0x45, 0x53, 0x45, 0x52, 0x56, 0x45,
	0x10, 0x02, 0x22, 0x5f, 0x0a, 0x06, 0x4b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x12, 0x17, 0x0a, 0x13,
	0x4b, 0x4d, 0x53, 0x5f, 0x4b, 0x45, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x26, 0x0a, 0x22, 0x4b, 0x4d, 0x53, 0x5f, 0x4b, 0x45, 0x59,
	0x5f, 0x44, 0x45, 0x53, 0x54, 0x49, 0x4e, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x42, 0x55, 0x43,
	0x4b, 0x45, 0x54, 0x5f, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x10, 0x01, 0x12, 0x14, 0x0a,
	0x10, 0x4b, 0x4d, 0x53, 0x5f, 0x4b, 0x45, 0x59, 0x5f, 0x50, 0x52, 0x45, 0x53, 0x45, 0x52, 0x56,
	0x45, 0x10, 0x02, 0x22, 0x6c, 0x0a, 0x0b, 0x54, 0x69, 0x6d, 0x65, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x64, 0x12, 0x1c, 0x0a, 0x18, 0x54, 0x49, 0x4d, 0x45, 0x5f, 0x43, 0x52, 0x45, 0x41, 0x54,
	0x45, 0x44, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x15, 0x0a, 0x11, 0x54, 0x49, 0x4d, 0x45, 0x5f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x44,
	0x5f, 0x53, 0x4b, 0x49, 0x50, 0x10, 0x01, 0x12, 0x28, 0x0a, 0x24, 0x54, 0x49, 0x4d, 0x45, 0x5f,
	0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x44, 0x5f, 0x50, 0x52, 0x45, 0x53, 0x45, 0x52, 0x56, 0x45,
	0x5f, 0x41, 0x53, 0x5f, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x10,
	0x02, 0x22, 0x2e, 0x0a, 0x10, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4d, 0x61, 0x6e,
	0x69, 0x66, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0xd7, 0x02, 0x0a, 0x08, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x46,
	0x0a, 0x13, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x11, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x53, 0x74, 0x61,
	0x72, 0x74, 0x44, 0x61, 0x74, 0x65, 0x12, 0x3d, 0x0a, 0x11, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75,
	0x6c, 0x65, 0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e,
	0x44, 0x61, 0x74, 0x65, 0x52, 0x0f, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x45, 0x6e,
	0x64, 0x44, 0x61, 0x74, 0x65, 0x12, 0x41, 0x0a, 0x11, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x5f, 0x6f, 0x66, 0x5f, 0x64, 0x61, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x4f, 0x66, 0x44, 0x61, 0x79, 0x52, 0x0e, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54,
	0x69, 0x6d, 0x65, 0x4f, 0x66, 0x44, 0x61, 0x79, 0x12, 0x3d, 0x0a, 0x0f, 0x65, 0x6e, 0x64, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6f, 0x66, 0x5f, 0x64, 0x61, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x4f, 0x66, 0x44, 0x61, 0x79, 0x52, 0x0c, 0x65, 0x6e, 0x64, 0x54, 0x69,
	0x6d, 0x65, 0x4f, 0x66, 0x44, 0x61, 0x79, 0x12, 0x42, 0x0a, 0x0f, 0x72, 0x65, 0x70, 0x65, 0x61,
	0x74, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x72, 0x65, 0x70,
	0x65, 0x61, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x22, 0xd6, 0x01, 0x0a, 0x0b,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x17, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x51, 0x0a, 0x17, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x14, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x53, 0x74,
	0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x5b, 0x0a, 0x1c, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x19, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x45, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x54, 0x69, 0x6d, 0x65, 0x22, 0x95, 0x07, 0x0a, 0x0b, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65,
	0x72, 0x4a, 0x6f, 0x62, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x4c, 0x0a, 0x0d, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x65, 0x72, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x52, 0x0c, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x12, 0x5e, 0x0a, 0x13, 0x6e, 0x6f, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x12, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4f, 0x0a, 0x0e, 0x6c, 0x6f, 0x67, 0x67, 0x69,
	0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x67, 0x67,
	0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0d, 0x6c, 0x6f, 0x67, 0x67, 0x69,
	0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3f, 0x0a, 0x08, 0x73, 0x63, 0x68, 0x65,
	0x64, 0x75, 0x6c, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x52,
	0x08, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x49, 0x0a, 0x0c, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x0b, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x12, 0x45, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x2e, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x44, 0x0a, 0x0d, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0c, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x55, 0x0a, 0x16, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x14, 0x6c, 0x61, 0x73, 0x74, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x44, 0x0a, 0x0d, 0x64, 0x65, 0x6c, 0x65,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0c, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x32,
	0x0a, 0x15, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x6c,
	0x61, 0x74, 0x65, 0x73, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61,
	0x6d, 0x65, 0x22, 0x48, 0x0a, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x16, 0x0a, 0x12,
	0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10,
	0x01, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12,
	0x0b, 0x0a, 0x07, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x03, 0x22, 0x4b, 0x0a, 0x0d,
	0x45, 0x72, 0x72, 0x6f, 0x72, 0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x15, 0x0a,
	0x03, 0x75, 0x72, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x03, 0x75, 0x72, 0x6c, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x64, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0xc0, 0x01, 0x0a, 0x0c, 0x45, 0x72,
	0x72, 0x6f, 0x72, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x12, 0x34, 0x0a, 0x0a, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x10,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x43, 0x6f, 0x64, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x64, 0x65,
	0x12, 0x24, 0x0a, 0x0b, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x54, 0x0a, 0x11, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f,
	0x6c, 0x6f, 0x67, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x72,
	0x72, 0x6f, 0x72, 0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0f, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x22, 0xff, 0x0a, 0x0a,
	0x10, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72,
	0x73, 0x12, 0x39, 0x0a, 0x19, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x5f, 0x66, 0x6f, 0x75,
	0x6e, 0x64, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x16, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x46, 0x6f, 0x75,
	0x6e, 0x64, 0x46, 0x72, 0x6f, 0x6d, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x35, 0x0a, 0x17,
	0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x66, 0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x66, 0x72, 0x6f, 0x6d,
	0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x14, 0x62,
	0x79, 0x74, 0x65, 0x73, 0x46, 0x6f, 0x75, 0x6e, 0x64, 0x46, 0x72, 0x6f, 0x6d, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x12, 0x3e, 0x0a, 0x1c, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x5f, 0x66,
	0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x73,
	0x69, 0x6e, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x18, 0x6f, 0x62, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x46, 0x6f, 0x75, 0x6e, 0x64, 0x4f, 0x6e, 0x6c, 0x79, 0x46, 0x72, 0x6f, 0x6d, 0x53,
	0x69, 0x6e, 0x6b, 0x12, 0x3a, 0x0a, 0x1a, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x66, 0x6f, 0x75,
	0x6e, 0x64, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x73, 0x69, 0x6e,
	0x6b, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x16, 0x62, 0x79, 0x74, 0x65, 0x73, 0x46, 0x6f,
	0x75, 0x6e, 0x64, 0x4f, 0x6e, 0x6c, 0x79, 0x46, 0x72, 0x6f, 0x6d, 0x53, 0x69, 0x6e, 0x6b, 0x12,
	0x4b, 0x0a, 0x23, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x73, 0x6b, 0x69, 0x70, 0x70, 0x65, 0x64, 0x5f, 0x62,
	0x79, 0x5f, 0x73, 0x79, 0x6e, 0x63, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x1e, 0x6f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x46, 0x72, 0x6f, 0x6d, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53,
	0x6b, 0x69, 0x70, 0x70, 0x65, 0x64, 0x42, 0x79, 0x53, 0x79, 0x6e, 0x63, 0x12, 0x47, 0x0a, 0x21,
	0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x73, 0x6b, 0x69, 0x70, 0x70, 0x65, 0x64, 0x5f, 0x62, 0x79, 0x5f, 0x73, 0x79, 0x6e,
	0x63, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x52, 0x1c, 0x62, 0x79, 0x74, 0x65, 0x73, 0x46, 0x72,
	0x6f, 0x6d, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x6b, 0x69, 0x70, 0x70, 0x65, 0x64, 0x42,
	0x79, 0x53, 0x79, 0x6e, 0x63, 0x12, 0x33, 0x0a, 0x16, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x5f, 0x63, 0x6f, 0x70, 0x69, 0x65, 0x64, 0x5f, 0x74, 0x6f, 0x5f, 0x73, 0x69, 0x6e, 0x6b, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x03, 0x52, 0x13, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x43, 0x6f,
	0x70, 0x69, 0x65, 0x64, 0x54, 0x6f, 0x53, 0x69, 0x6e, 0x6b, 0x12, 0x2f, 0x0a, 0x14, 0x62, 0x79,
	0x74, 0x65, 0x73, 0x5f, 0x63, 0x6f, 0x70, 0x69, 0x65, 0x64, 0x5f, 0x74, 0x6f, 0x5f, 0x73, 0x69,
	0x6e, 0x6b, 0x18, 0x08, 0x20, 0x01, 0x28, 0x03, 0x52, 0x11, 0x62, 0x79, 0x74, 0x65, 0x73, 0x43,
	0x6f, 0x70, 0x69, 0x65, 0x64, 0x54, 0x6f, 0x53, 0x69, 0x6e, 0x6b, 0x12, 0x3d, 0x0a, 0x1b, 0x6f,
	0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x5f, 0x66,
	0x72, 0x6f, 0x6d, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x18, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64,
	0x46, 0x72, 0x6f, 0x6d, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x39, 0x0a, 0x19, 0x62, 0x79,
	0x74, 0x65, 0x73, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x5f, 0x66, 0x72, 0x6f, 0x6d,
	0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x03, 0x52, 0x16, 0x62,
	0x79, 0x74, 0x65, 0x73, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x46, 0x72, 0x6f, 0x6d, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x39, 0x0a, 0x19, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x73, 0x69,
	0x6e, 0x6b, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x03, 0x52, 0x16, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x46, 0x72, 0x6f, 0x6d, 0x53, 0x69, 0x6e, 0x6b,
	0x12, 0x35, 0x0a, 0x17, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x64, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x73, 0x69, 0x6e, 0x6b, 0x18, 0x0c, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x14, 0x62, 0x79, 0x74, 0x65, 0x73, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x46,
	0x72, 0x6f, 0x6d, 0x53, 0x69, 0x6e, 0x6b, 0x12, 0x3b, 0x0a, 0x1a, 0x6f, 0x62, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x66,
	0x61, 0x69, 0x6c, 0x65, 0x64, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x03, 0x52, 0x17, 0x6f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x46, 0x72, 0x6f, 0x6d, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x46, 0x61,
	0x69, 0x6c, 0x65, 0x64, 0x12, 0x37, 0x0a, 0x18, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x66, 0x72,
	0x6f, 0x6d, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64,
	0x18, 0x0e, 0x20, 0x01, 0x28, 0x03, 0x52, 0x15, 0x62, 0x79, 0x74, 0x65, 0x73, 0x46, 0x72, 0x6f,
	0x6d, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x46, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x12, 0x49, 0x0a,
	0x22, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x5f,
	0x74, 0x6f, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x73,
	0x69, 0x6e, 0x6b, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x03, 0x52, 0x1d, 0x6f, 0x62, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x46, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x54, 0x6f, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x46, 0x72, 0x6f, 0x6d, 0x53, 0x69, 0x6e, 0x6b, 0x12, 0x45, 0x0a, 0x20, 0x62, 0x79, 0x74, 0x65,
	0x73, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x5f, 0x74, 0x6f, 0x5f, 0x64, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x73, 0x69, 0x6e, 0x6b, 0x18, 0x10, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x1b, 0x62, 0x79, 0x74, 0x65, 0x73, 0x46, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x54,
	0x6f, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x72, 0x6f, 0x6d, 0x53, 0x69, 0x6e, 0x6b, 0x12,
	0x41, 0x0a, 0x1d, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x5f, 0x66,
	0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x18, 0x11, 0x20, 0x01, 0x28, 0x03, 0x52, 0x1a, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x69, 0x65, 0x73, 0x46, 0x6f, 0x75, 0x6e, 0x64, 0x46, 0x72, 0x6f, 0x6d, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x12, 0x51, 0x0a, 0x26, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x69, 0x65,
	0x73, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x5f, 0x74, 0x6f, 0x5f, 0x6c, 0x69, 0x73, 0x74,
	0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x12, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x21, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x46,
	0x61, 0x69, 0x6c, 0x65, 0x64, 0x54, 0x6f, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x72, 0x6f, 0x6d, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x5c, 0x0a, 0x2b, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x69, 0x65, 0x73, 0x5f, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x66, 0x75, 0x6c, 0x6c,
	0x79, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x18, 0x13, 0x20, 0x01, 0x28, 0x03, 0x52, 0x27, 0x64, 0x69, 0x72, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x53, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x66, 0x75,
	0x6c, 0x6c, 0x79, 0x4c, 0x69, 0x73, 0x74, 0x65, 0x64, 0x46, 0x72, 0x6f, 0x6d, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x12, 0x45, 0x0a, 0x1f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x65, 0x64, 0x69,
	0x61, 0x74, 0x65, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x5f, 0x63, 0x6c, 0x65, 0x61,
	0x6e, 0x65, 0x64, 0x5f, 0x75, 0x70, 0x18, 0x16, 0x20, 0x01, 0x28, 0x03, 0x52, 0x1c, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x43, 0x6c, 0x65, 0x61, 0x6e, 0x65, 0x64, 0x55, 0x70, 0x12, 0x52, 0x0a, 0x26, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x5f, 0x63, 0x6c, 0x65, 0x61, 0x6e, 0x65,
	0x64, 0x5f, 0x75, 0x70, 0x18, 0x17, 0x20, 0x01, 0x28, 0x03, 0x52, 0x22, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x46,
	0x61, 0x69, 0x6c, 0x65, 0x64, 0x43, 0x6c, 0x65, 0x61, 0x6e, 0x65, 0x64, 0x55, 0x70, 0x22, 0xcd,
	0x03, 0x0a, 0x12, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x26, 0x0a, 0x0c, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x5f,
	0x74, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0b, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x58, 0x0a,
	0x0b, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e,
	0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x67, 0x0a, 0x0e, 0x70, 0x61, 0x79, 0x6c, 0x6f,
	0x61, 0x64, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50,
	0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0d, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x22, 0x86, 0x01, 0x0a, 0x09, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a,
	0x0a, 0x16, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1e, 0x0a, 0x1a, 0x54, 0x52,
	0x41, 0x4e, 0x53, 0x46, 0x45, 0x52, 0x5f, 0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x53, 0x55, 0x43, 0x43, 0x45, 0x53, 0x53, 0x10, 0x01, 0x12, 0x1d, 0x0a, 0x19, 0x54, 0x52,
	0x41, 0x4e, 0x53, 0x46, 0x45, 0x52, 0x5f, 0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x1e, 0x0a, 0x1a, 0x54, 0x52, 0x41,
	0x4e, 0x53, 0x46, 0x45, 0x52, 0x5f, 0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x41, 0x42, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x10, 0x03, 0x22, 0x43, 0x0a, 0x0d, 0x50, 0x61, 0x79,
	0x6c, 0x6f, 0x61, 0x64, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x1e, 0x0a, 0x1a, 0x50, 0x41,
	0x59, 0x4c, 0x4f, 0x41, 0x44, 0x5f, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x4e, 0x4f,
	0x4e, 0x45, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x4a, 0x53, 0x4f, 0x4e, 0x10, 0x02, 0x22, 0xc5,
	0x03, 0x0a, 0x0d, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x58, 0x0a, 0x0b, 0x6c, 0x6f, 0x67, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x4c, 0x6f, 0x67, 0x67, 0x61, 0x62, 0x6c, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a,
	0x6c, 0x6f, 0x67, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x68, 0x0a, 0x11, 0x6c, 0x6f,
	0x67, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x4c, 0x6f, 0x67, 0x67, 0x61, 0x62, 0x6c, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x52, 0x0f, 0x6c, 0x6f, 0x67, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x73, 0x12, 0x44, 0x0a, 0x1f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6f,
	0x6e, 0x70, 0x72, 0x65, 0x6d, 0x5f, 0x67, 0x63, 0x73, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x65, 0x72, 0x5f, 0x6c, 0x6f, 0x67, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x1b, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x6e, 0x70, 0x72, 0x65, 0x6d, 0x47, 0x63, 0x73, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4c, 0x6f, 0x67, 0x73, 0x22, 0x51, 0x0a, 0x0e, 0x4c, 0x6f,
	0x67, 0x67, 0x61, 0x62, 0x6c, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x1b,
	0x4c, 0x4f, 0x47, 0x47, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a,
	0x04, 0x46, 0x49, 0x4e, 0x44, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x44, 0x45, 0x4c, 0x45, 0x54,
	0x45, 0x10, 0x02, 0x12, 0x08, 0x0a, 0x04, 0x43, 0x4f, 0x50, 0x59, 0x10, 0x03, 0x22, 0x57, 0x0a,
	0x13, 0x4c, 0x6f, 0x67, 0x67, 0x61, 0x62, 0x6c, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x25, 0x0a, 0x21, 0x4c, 0x4f, 0x47, 0x47, 0x41, 0x42, 0x4c, 0x45,
	0x5f, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x53,
	0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41,
	0x49, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x22, 0xce, 0x06, 0x0a, 0x11, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12,
	0x4c, 0x0a, 0x0d, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x5f, 0x73, 0x70, 0x65, 0x63,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x52,
	0x0c, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x12, 0x5e, 0x0a,
	0x13, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x12, 0x6e, 0x6f, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4f, 0x0a,
	0x0e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x0d, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x39,
	0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x4b, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x65, 0x72, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x47, 0x0a,
	0x08, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x65, 0x72, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x73, 0x52, 0x08, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x65, 0x72, 0x73, 0x12, 0x52, 0x0a, 0x10, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f,
	0x62, 0x72, 0x65, 0x61, 0x6b, 0x64, 0x6f, 0x77, 0x6e, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x72, 0x72,
	0x6f, 0x72, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x52, 0x0f, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x42, 0x72, 0x65, 0x61, 0x6b, 0x64, 0x6f, 0x77, 0x6e, 0x73, 0x12, 0x2a, 0x0a, 0x11, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4a,
	0x6f, 0x62, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x7f, 0x0a, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x12, 0x16, 0x0a, 0x12, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x49, 0x4e, 0x5f, 0x50,
	0x52, 0x4f, 0x47, 0x52, 0x45, 0x53, 0x53, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x50, 0x41, 0x55,
	0x53, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x55, 0x43, 0x43, 0x45, 0x53, 0x53,
	0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0b,
	0x0a, 0x07, 0x41, 0x42, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x10, 0x05, 0x12, 0x0a, 0x0a, 0x06, 0x51,
	0x55, 0x45, 0x55, 0x45, 0x44, 0x10, 0x06, 0x12, 0x0e, 0x0a, 0x0a, 0x53, 0x55, 0x53, 0x50, 0x45,
	0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x07, 0x42, 0xef, 0x01, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x42,
	0x0d, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x73, 0x5a, 0x4d,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x70, 0x62, 0x3b, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x70, 0x62, 0xf8, 0x01, 0x01,
	0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e,
	0x56, 0x31, 0xca, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x5c, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65,
	0x72, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x65, 0x72, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_google_storagetransfer_v1_transfer_types_proto_rawDescOnce sync.Once
	file_google_storagetransfer_v1_transfer_types_proto_rawDescData = file_google_storagetransfer_v1_transfer_types_proto_rawDesc
)

func file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP() []byte {
	file_google_storagetransfer_v1_transfer_types_proto_rawDescOnce.Do(func() {
		file_google_storagetransfer_v1_transfer_types_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_storagetransfer_v1_transfer_types_proto_rawDescData)
	})
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescData
}

var file_google_storagetransfer_v1_transfer_types_proto_enumTypes = make([]protoimpl.EnumInfo, 21)
var file_google_storagetransfer_v1_transfer_types_proto_msgTypes = make([]protoimpl.MessageInfo, 26)
var file_google_storagetransfer_v1_transfer_types_proto_goTypes = []interface{}{
	(S3CompatibleMetadata_AuthMethod)(0),      // 0: google.storagetransfer.v1.S3CompatibleMetadata.AuthMethod
	(S3CompatibleMetadata_RequestModel)(0),    // 1: google.storagetransfer.v1.S3CompatibleMetadata.RequestModel
	(S3CompatibleMetadata_NetworkProtocol)(0), // 2: google.storagetransfer.v1.S3CompatibleMetadata.NetworkProtocol
	(S3CompatibleMetadata_ListApi)(0),         // 3: google.storagetransfer.v1.S3CompatibleMetadata.ListApi
	(AgentPool_State)(0),                      // 4: google.storagetransfer.v1.AgentPool.State
	(TransferOptions_OverwriteWhen)(0),        // 5: google.storagetransfer.v1.TransferOptions.OverwriteWhen
	(MetadataOptions_Symlink)(0),              // 6: google.storagetransfer.v1.MetadataOptions.Symlink
	(MetadataOptions_Mode)(0),                 // 7: google.storagetransfer.v1.MetadataOptions.Mode
	(MetadataOptions_GID)(0),                  // 8: google.storagetransfer.v1.MetadataOptions.GID
	(MetadataOptions_UID)(0),                  // 9: google.storagetransfer.v1.MetadataOptions.UID
	(MetadataOptions_Acl)(0),                  // 10: google.storagetransfer.v1.MetadataOptions.Acl
	(MetadataOptions_StorageClass)(0),         // 11: google.storagetransfer.v1.MetadataOptions.StorageClass
	(MetadataOptions_TemporaryHold)(0),        // 12: google.storagetransfer.v1.MetadataOptions.TemporaryHold
	(MetadataOptions_KmsKey)(0),               // 13: google.storagetransfer.v1.MetadataOptions.KmsKey
	(MetadataOptions_TimeCreated)(0),          // 14: google.storagetransfer.v1.MetadataOptions.TimeCreated
	(TransferJob_Status)(0),                   // 15: google.storagetransfer.v1.TransferJob.Status
	(NotificationConfig_EventType)(0),         // 16: google.storagetransfer.v1.NotificationConfig.EventType
	(NotificationConfig_PayloadFormat)(0),     // 17: google.storagetransfer.v1.NotificationConfig.PayloadFormat
	(LoggingConfig_LoggableAction)(0),         // 18: google.storagetransfer.v1.LoggingConfig.LoggableAction
	(LoggingConfig_LoggableActionState)(0),    // 19: google.storagetransfer.v1.LoggingConfig.LoggableActionState
	(TransferOperation_Status)(0),             // 20: google.storagetransfer.v1.TransferOperation.Status
	(*GoogleServiceAccount)(nil),              // 21: google.storagetransfer.v1.GoogleServiceAccount
	(*AwsAccessKey)(nil),                      // 22: google.storagetransfer.v1.AwsAccessKey
	(*AzureCredentials)(nil),                  // 23: google.storagetransfer.v1.AzureCredentials
	(*ObjectConditions)(nil),                  // 24: google.storagetransfer.v1.ObjectConditions
	(*GcsData)(nil),                           // 25: google.storagetransfer.v1.GcsData
	(*AwsS3Data)(nil),                         // 26: google.storagetransfer.v1.AwsS3Data
	(*AzureBlobStorageData)(nil),              // 27: google.storagetransfer.v1.AzureBlobStorageData
	(*HttpData)(nil),                          // 28: google.storagetransfer.v1.HttpData
	(*PosixFilesystem)(nil),                   // 29: google.storagetransfer.v1.PosixFilesystem
	(*AwsS3CompatibleData)(nil),               // 30: google.storagetransfer.v1.AwsS3CompatibleData
	(*S3CompatibleMetadata)(nil),              // 31: google.storagetransfer.v1.S3CompatibleMetadata
	(*AgentPool)(nil),                         // 32: google.storagetransfer.v1.AgentPool
	(*TransferOptions)(nil),                   // 33: google.storagetransfer.v1.TransferOptions
	(*TransferSpec)(nil),                      // 34: google.storagetransfer.v1.TransferSpec
	(*MetadataOptions)(nil),                   // 35: google.storagetransfer.v1.MetadataOptions
	(*TransferManifest)(nil),                  // 36: google.storagetransfer.v1.TransferManifest
	(*Schedule)(nil),                          // 37: google.storagetransfer.v1.Schedule
	(*EventStream)(nil),                       // 38: google.storagetransfer.v1.EventStream
	(*TransferJob)(nil),                       // 39: google.storagetransfer.v1.TransferJob
	(*ErrorLogEntry)(nil),                     // 40: google.storagetransfer.v1.ErrorLogEntry
	(*ErrorSummary)(nil),                      // 41: google.storagetransfer.v1.ErrorSummary
	(*TransferCounters)(nil),                  // 42: google.storagetransfer.v1.TransferCounters
	(*NotificationConfig)(nil),                // 43: google.storagetransfer.v1.NotificationConfig
	(*LoggingConfig)(nil),                     // 44: google.storagetransfer.v1.LoggingConfig
	(*TransferOperation)(nil),                 // 45: google.storagetransfer.v1.TransferOperation
	(*AgentPool_BandwidthLimit)(nil),          // 46: google.storagetransfer.v1.AgentPool.BandwidthLimit
	(*durationpb.Duration)(nil),               // 47: google.protobuf.Duration
	(*timestamppb.Timestamp)(nil),             // 48: google.protobuf.Timestamp
	(*date.Date)(nil),                         // 49: google.type.Date
	(*timeofday.TimeOfDay)(nil),               // 50: google.type.TimeOfDay
	(code.Code)(0),                            // 51: google.rpc.Code
}
var file_google_storagetransfer_v1_transfer_types_proto_depIdxs = []int32{
	47, // 0: google.storagetransfer.v1.ObjectConditions.min_time_elapsed_since_last_modification:type_name -> google.protobuf.Duration
	47, // 1: google.storagetransfer.v1.ObjectConditions.max_time_elapsed_since_last_modification:type_name -> google.protobuf.Duration
	48, // 2: google.storagetransfer.v1.ObjectConditions.last_modified_since:type_name -> google.protobuf.Timestamp
	48, // 3: google.storagetransfer.v1.ObjectConditions.last_modified_before:type_name -> google.protobuf.Timestamp
	22, // 4: google.storagetransfer.v1.AwsS3Data.aws_access_key:type_name -> google.storagetransfer.v1.AwsAccessKey
	23, // 5: google.storagetransfer.v1.AzureBlobStorageData.azure_credentials:type_name -> google.storagetransfer.v1.AzureCredentials
	31, // 6: google.storagetransfer.v1.AwsS3CompatibleData.s3_metadata:type_name -> google.storagetransfer.v1.S3CompatibleMetadata
	0,  // 7: google.storagetransfer.v1.S3CompatibleMetadata.auth_method:type_name -> google.storagetransfer.v1.S3CompatibleMetadata.AuthMethod
	1,  // 8: google.storagetransfer.v1.S3CompatibleMetadata.request_model:type_name -> google.storagetransfer.v1.S3CompatibleMetadata.RequestModel
	2,  // 9: google.storagetransfer.v1.S3CompatibleMetadata.protocol:type_name -> google.storagetransfer.v1.S3CompatibleMetadata.NetworkProtocol
	3,  // 10: google.storagetransfer.v1.S3CompatibleMetadata.list_api:type_name -> google.storagetransfer.v1.S3CompatibleMetadata.ListApi
	4,  // 11: google.storagetransfer.v1.AgentPool.state:type_name -> google.storagetransfer.v1.AgentPool.State
	46, // 12: google.storagetransfer.v1.AgentPool.bandwidth_limit:type_name -> google.storagetransfer.v1.AgentPool.BandwidthLimit
	5,  // 13: google.storagetransfer.v1.TransferOptions.overwrite_when:type_name -> google.storagetransfer.v1.TransferOptions.OverwriteWhen
	35, // 14: google.storagetransfer.v1.TransferOptions.metadata_options:type_name -> google.storagetransfer.v1.MetadataOptions
	25, // 15: google.storagetransfer.v1.TransferSpec.gcs_data_sink:type_name -> google.storagetransfer.v1.GcsData
	29, // 16: google.storagetransfer.v1.TransferSpec.posix_data_sink:type_name -> google.storagetransfer.v1.PosixFilesystem
	25, // 17: google.storagetransfer.v1.TransferSpec.gcs_data_source:type_name -> google.storagetransfer.v1.GcsData
	26, // 18: google.storagetransfer.v1.TransferSpec.aws_s3_data_source:type_name -> google.storagetransfer.v1.AwsS3Data
	28, // 19: google.storagetransfer.v1.TransferSpec.http_data_source:type_name -> google.storagetransfer.v1.HttpData
	29, // 20: google.storagetransfer.v1.TransferSpec.posix_data_source:type_name -> google.storagetransfer.v1.PosixFilesystem
	27, // 21: google.storagetransfer.v1.TransferSpec.azure_blob_storage_data_source:type_name -> google.storagetransfer.v1.AzureBlobStorageData
	30, // 22: google.storagetransfer.v1.TransferSpec.aws_s3_compatible_data_source:type_name -> google.storagetransfer.v1.AwsS3CompatibleData
	25, // 23: google.storagetransfer.v1.TransferSpec.gcs_intermediate_data_location:type_name -> google.storagetransfer.v1.GcsData
	24, // 24: google.storagetransfer.v1.TransferSpec.object_conditions:type_name -> google.storagetransfer.v1.ObjectConditions
	33, // 25: google.storagetransfer.v1.TransferSpec.transfer_options:type_name -> google.storagetransfer.v1.TransferOptions
	36, // 26: google.storagetransfer.v1.TransferSpec.transfer_manifest:type_name -> google.storagetransfer.v1.TransferManifest
	6,  // 27: google.storagetransfer.v1.MetadataOptions.symlink:type_name -> google.storagetransfer.v1.MetadataOptions.Symlink
	7,  // 28: google.storagetransfer.v1.MetadataOptions.mode:type_name -> google.storagetransfer.v1.MetadataOptions.Mode
	8,  // 29: google.storagetransfer.v1.MetadataOptions.gid:type_name -> google.storagetransfer.v1.MetadataOptions.GID
	9,  // 30: google.storagetransfer.v1.MetadataOptions.uid:type_name -> google.storagetransfer.v1.MetadataOptions.UID
	10, // 31: google.storagetransfer.v1.MetadataOptions.acl:type_name -> google.storagetransfer.v1.MetadataOptions.Acl
	11, // 32: google.storagetransfer.v1.MetadataOptions.storage_class:type_name -> google.storagetransfer.v1.MetadataOptions.StorageClass
	12, // 33: google.storagetransfer.v1.MetadataOptions.temporary_hold:type_name -> google.storagetransfer.v1.MetadataOptions.TemporaryHold
	13, // 34: google.storagetransfer.v1.MetadataOptions.kms_key:type_name -> google.storagetransfer.v1.MetadataOptions.KmsKey
	14, // 35: google.storagetransfer.v1.MetadataOptions.time_created:type_name -> google.storagetransfer.v1.MetadataOptions.TimeCreated
	49, // 36: google.storagetransfer.v1.Schedule.schedule_start_date:type_name -> google.type.Date
	49, // 37: google.storagetransfer.v1.Schedule.schedule_end_date:type_name -> google.type.Date
	50, // 38: google.storagetransfer.v1.Schedule.start_time_of_day:type_name -> google.type.TimeOfDay
	50, // 39: google.storagetransfer.v1.Schedule.end_time_of_day:type_name -> google.type.TimeOfDay
	47, // 40: google.storagetransfer.v1.Schedule.repeat_interval:type_name -> google.protobuf.Duration
	48, // 41: google.storagetransfer.v1.EventStream.event_stream_start_time:type_name -> google.protobuf.Timestamp
	48, // 42: google.storagetransfer.v1.EventStream.event_stream_expiration_time:type_name -> google.protobuf.Timestamp
	34, // 43: google.storagetransfer.v1.TransferJob.transfer_spec:type_name -> google.storagetransfer.v1.TransferSpec
	43, // 44: google.storagetransfer.v1.TransferJob.notification_config:type_name -> google.storagetransfer.v1.NotificationConfig
	44, // 45: google.storagetransfer.v1.TransferJob.logging_config:type_name -> google.storagetransfer.v1.LoggingConfig
	37, // 46: google.storagetransfer.v1.TransferJob.schedule:type_name -> google.storagetransfer.v1.Schedule
	38, // 47: google.storagetransfer.v1.TransferJob.event_stream:type_name -> google.storagetransfer.v1.EventStream
	15, // 48: google.storagetransfer.v1.TransferJob.status:type_name -> google.storagetransfer.v1.TransferJob.Status
	48, // 49: google.storagetransfer.v1.TransferJob.creation_time:type_name -> google.protobuf.Timestamp
	48, // 50: google.storagetransfer.v1.TransferJob.last_modification_time:type_name -> google.protobuf.Timestamp
	48, // 51: google.storagetransfer.v1.TransferJob.deletion_time:type_name -> google.protobuf.Timestamp
	51, // 52: google.storagetransfer.v1.ErrorSummary.error_code:type_name -> google.rpc.Code
	40, // 53: google.storagetransfer.v1.ErrorSummary.error_log_entries:type_name -> google.storagetransfer.v1.ErrorLogEntry
	16, // 54: google.storagetransfer.v1.NotificationConfig.event_types:type_name -> google.storagetransfer.v1.NotificationConfig.EventType
	17, // 55: google.storagetransfer.v1.NotificationConfig.payload_format:type_name -> google.storagetransfer.v1.NotificationConfig.PayloadFormat
	18, // 56: google.storagetransfer.v1.LoggingConfig.log_actions:type_name -> google.storagetransfer.v1.LoggingConfig.LoggableAction
	19, // 57: google.storagetransfer.v1.LoggingConfig.log_action_states:type_name -> google.storagetransfer.v1.LoggingConfig.LoggableActionState
	34, // 58: google.storagetransfer.v1.TransferOperation.transfer_spec:type_name -> google.storagetransfer.v1.TransferSpec
	43, // 59: google.storagetransfer.v1.TransferOperation.notification_config:type_name -> google.storagetransfer.v1.NotificationConfig
	44, // 60: google.storagetransfer.v1.TransferOperation.logging_config:type_name -> google.storagetransfer.v1.LoggingConfig
	48, // 61: google.storagetransfer.v1.TransferOperation.start_time:type_name -> google.protobuf.Timestamp
	48, // 62: google.storagetransfer.v1.TransferOperation.end_time:type_name -> google.protobuf.Timestamp
	20, // 63: google.storagetransfer.v1.TransferOperation.status:type_name -> google.storagetransfer.v1.TransferOperation.Status
	42, // 64: google.storagetransfer.v1.TransferOperation.counters:type_name -> google.storagetransfer.v1.TransferCounters
	41, // 65: google.storagetransfer.v1.TransferOperation.error_breakdowns:type_name -> google.storagetransfer.v1.ErrorSummary
	66, // [66:66] is the sub-list for method output_type
	66, // [66:66] is the sub-list for method input_type
	66, // [66:66] is the sub-list for extension type_name
	66, // [66:66] is the sub-list for extension extendee
	0,  // [0:66] is the sub-list for field type_name
}

func init() { file_google_storagetransfer_v1_transfer_types_proto_init() }
func file_google_storagetransfer_v1_transfer_types_proto_init() {
	if File_google_storagetransfer_v1_transfer_types_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GoogleServiceAccount); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AwsAccessKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AzureCredentials); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ObjectConditions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GcsData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AwsS3Data); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AzureBlobStorageData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HttpData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PosixFilesystem); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AwsS3CompatibleData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*S3CompatibleMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AgentPool); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransferOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransferSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MetadataOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransferManifest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Schedule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EventStream); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransferJob); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ErrorLogEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ErrorSummary); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransferCounters); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NotificationConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LoggingConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransferOperation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AgentPool_BandwidthLimit); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_storagetransfer_v1_transfer_types_proto_msgTypes[9].OneofWrappers = []interface{}{
		(*AwsS3CompatibleData_S3Metadata)(nil),
	}
	file_google_storagetransfer_v1_transfer_types_proto_msgTypes[13].OneofWrappers = []interface{}{
		(*TransferSpec_GcsDataSink)(nil),
		(*TransferSpec_PosixDataSink)(nil),
		(*TransferSpec_GcsDataSource)(nil),
		(*TransferSpec_AwsS3DataSource)(nil),
		(*TransferSpec_HttpDataSource)(nil),
		(*TransferSpec_PosixDataSource)(nil),
		(*TransferSpec_AzureBlobStorageDataSource)(nil),
		(*TransferSpec_AwsS3CompatibleDataSource)(nil),
		(*TransferSpec_GcsIntermediateDataLocation)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_storagetransfer_v1_transfer_types_proto_rawDesc,
			NumEnums:      21,
			NumMessages:   26,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_storagetransfer_v1_transfer_types_proto_goTypes,
		DependencyIndexes: file_google_storagetransfer_v1_transfer_types_proto_depIdxs,
		EnumInfos:         file_google_storagetransfer_v1_transfer_types_proto_enumTypes,
		MessageInfos:      file_google_storagetransfer_v1_transfer_types_proto_msgTypes,
	}.Build()
	File_google_storagetransfer_v1_transfer_types_proto = out.File
	file_google_storagetransfer_v1_transfer_types_proto_rawDesc = nil
	file_google_storagetransfer_v1_transfer_types_proto_goTypes = nil
	file_google_storagetransfer_v1_transfer_types_proto_depIdxs = nil
}
