// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.31.0
// 	protoc        v4.23.2
// source: google/cloud/translate/v3/translation_service.proto

package translatepb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// State of the job.
type BatchTranslateMetadata_State int32

const (
	// Invalid.
	BatchTranslateMetadata_STATE_UNSPECIFIED BatchTranslateMetadata_State = 0
	// Request is being processed.
	BatchTranslateMetadata_RUNNING BatchTranslateMetadata_State = 1
	// The batch is processed, and at least one item was successfully
	// processed.
	BatchTranslateMetadata_SUCCEEDED BatchTranslateMetadata_State = 2
	// The batch is done and no item was successfully processed.
	BatchTranslateMetadata_FAILED BatchTranslateMetadata_State = 3
	// Request is in the process of being canceled after caller invoked
	// longrunning.Operations.CancelOperation on the request id.
	BatchTranslateMetadata_CANCELLING BatchTranslateMetadata_State = 4
	// The batch is done after the user has called the
	// longrunning.Operations.CancelOperation. Any records processed before the
	// cancel command are output as specified in the request.
	BatchTranslateMetadata_CANCELLED BatchTranslateMetadata_State = 5
)

// Enum value maps for BatchTranslateMetadata_State.
var (
	BatchTranslateMetadata_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "RUNNING",
		2: "SUCCEEDED",
		3: "FAILED",
		4: "CANCELLING",
		5: "CANCELLED",
	}
	BatchTranslateMetadata_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"RUNNING":           1,
		"SUCCEEDED":         2,
		"FAILED":            3,
		"CANCELLING":        4,
		"CANCELLED":         5,
	}
)

func (x BatchTranslateMetadata_State) Enum() *BatchTranslateMetadata_State {
	p := new(BatchTranslateMetadata_State)
	*p = x
	return p
}

func (x BatchTranslateMetadata_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BatchTranslateMetadata_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_translate_v3_translation_service_proto_enumTypes[0].Descriptor()
}

func (BatchTranslateMetadata_State) Type() protoreflect.EnumType {
	return &file_google_cloud_translate_v3_translation_service_proto_enumTypes[0]
}

func (x BatchTranslateMetadata_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BatchTranslateMetadata_State.Descriptor instead.
func (BatchTranslateMetadata_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_translation_service_proto_rawDescGZIP(), []int{20, 0}
}

// Enumerates the possible states that the creation request can be in.
type CreateGlossaryMetadata_State int32

const (
	// Invalid.
	CreateGlossaryMetadata_STATE_UNSPECIFIED CreateGlossaryMetadata_State = 0
	// Request is being processed.
	CreateGlossaryMetadata_RUNNING CreateGlossaryMetadata_State = 1
	// The glossary was successfully created.
	CreateGlossaryMetadata_SUCCEEDED CreateGlossaryMetadata_State = 2
	// Failed to create the glossary.
	CreateGlossaryMetadata_FAILED CreateGlossaryMetadata_State = 3
	// Request is in the process of being canceled after caller invoked
	// longrunning.Operations.CancelOperation on the request id.
	CreateGlossaryMetadata_CANCELLING CreateGlossaryMetadata_State = 4
	// The glossary creation request was successfully canceled.
	CreateGlossaryMetadata_CANCELLED CreateGlossaryMetadata_State = 5
)

// Enum value maps for CreateGlossaryMetadata_State.
var (
	CreateGlossaryMetadata_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "RUNNING",
		2: "SUCCEEDED",
		3: "FAILED",
		4: "CANCELLING",
		5: "CANCELLED",
	}
	CreateGlossaryMetadata_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"RUNNING":           1,
		"SUCCEEDED":         2,
		"FAILED":            3,
		"CANCELLING":        4,
		"CANCELLED":         5,
	}
)

func (x CreateGlossaryMetadata_State) Enum() *CreateGlossaryMetadata_State {
	p := new(CreateGlossaryMetadata_State)
	*p = x
	return p
}

func (x CreateGlossaryMetadata_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CreateGlossaryMetadata_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_translate_v3_translation_service_proto_enumTypes[1].Descriptor()
}

func (CreateGlossaryMetadata_State) Type() protoreflect.EnumType {
	return &file_google_cloud_translate_v3_translation_service_proto_enumTypes[1]
}

func (x CreateGlossaryMetadata_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CreateGlossaryMetadata_State.Descriptor instead.
func (CreateGlossaryMetadata_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_translation_service_proto_rawDescGZIP(), []int{29, 0}
}

// Enumerates the possible states that the creation request can be in.
type DeleteGlossaryMetadata_State int32

const (
	// Invalid.
	DeleteGlossaryMetadata_STATE_UNSPECIFIED DeleteGlossaryMetadata_State = 0
	// Request is being processed.
	DeleteGlossaryMetadata_RUNNING DeleteGlossaryMetadata_State = 1
	// The glossary was successfully deleted.
	DeleteGlossaryMetadata_SUCCEEDED DeleteGlossaryMetadata_State = 2
	// Failed to delete the glossary.
	DeleteGlossaryMetadata_FAILED DeleteGlossaryMetadata_State = 3
	// Request is in the process of being canceled after caller invoked
	// longrunning.Operations.CancelOperation on the request id.
	DeleteGlossaryMetadata_CANCELLING DeleteGlossaryMetadata_State = 4
	// The glossary deletion request was successfully canceled.
	DeleteGlossaryMetadata_CANCELLED DeleteGlossaryMetadata_State = 5
)

// Enum value maps for DeleteGlossaryMetadata_State.
var (
	DeleteGlossaryMetadata_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "RUNNING",
		2: "SUCCEEDED",
		3: "FAILED",
		4: "CANCELLING",
		5: "CANCELLED",
	}
	DeleteGlossaryMetadata_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"RUNNING":           1,
		"SUCCEEDED":         2,
		"FAILED":            3,
		"CANCELLING":        4,
		"CANCELLED":         5,
	}
)

func (x DeleteGlossaryMetadata_State) Enum() *DeleteGlossaryMetadata_State {
	p := new(DeleteGlossaryMetadata_State)
	*p = x
	return p
}

func (x DeleteGlossaryMetadata_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DeleteGlossaryMetadata_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_translate_v3_translation_service_proto_enumTypes[2].Descriptor()
}

func (DeleteGlossaryMetadata_State) Type() protoreflect.EnumType {
	return &file_google_cloud_translate_v3_translation_service_proto_enumTypes[2]
}

func (x DeleteGlossaryMetadata_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DeleteGlossaryMetadata_State.Descriptor instead.
func (DeleteGlossaryMetadata_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_translation_service_proto_rawDescGZIP(), []int{30, 0}
}

// State of the job.
type BatchTranslateDocumentMetadata_State int32

const (
	// Invalid.
	BatchTranslateDocumentMetadata_STATE_UNSPECIFIED BatchTranslateDocumentMetadata_State = 0
	// Request is being processed.
	BatchTranslateDocumentMetadata_RUNNING BatchTranslateDocumentMetadata_State = 1
	// The batch is processed, and at least one item was successfully processed.
	BatchTranslateDocumentMetadata_SUCCEEDED BatchTranslateDocumentMetadata_State = 2
	// The batch is done and no item was successfully processed.
	BatchTranslateDocumentMetadata_FAILED BatchTranslateDocumentMetadata_State = 3
	// Request is in the process of being canceled after caller invoked
	// longrunning.Operations.CancelOperation on the request id.
	BatchTranslateDocumentMetadata_CANCELLING BatchTranslateDocumentMetadata_State = 4
	// The batch is done after the user has called the
	// longrunning.Operations.CancelOperation. Any records processed before the
	// cancel command are output as specified in the request.
	BatchTranslateDocumentMetadata_CANCELLED BatchTranslateDocumentMetadata_State = 5
)

// Enum value maps for BatchTranslateDocumentMetadata_State.
var (
	BatchTranslateDocumentMetadata_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "RUNNING",
		2: "SUCCEEDED",
		3: "FAILED",
		4: "CANCELLING",
		5: "CANCELLED",
	}
	BatchTranslateDocumentMetadata_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"RUNNING":           1,
		"SUCCEEDED":         2,
		"FAILED":            3,
		"CANCELLING":        4,
		"CANCELLED":         5,
	}
)

func (x BatchTranslateDocumentMetadata_State) Enum() *BatchTranslateDocumentMetadata_State {
	p := new(BatchTranslateDocumentMetadata_State)
	*p = x
	return p
}

func (x BatchTranslateDocumentMetadata_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BatchTranslateDocumentMetadata_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_translate_v3_translation_service_proto_enumTypes[3].Descriptor()
}

func (BatchTranslateDocumentMetadata_State) Type() protoreflect.EnumType {
	return &file_google_cloud_translate_v3_translation_service_proto_enumTypes[3]
}

func (x BatchTranslateDocumentMetadata_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BatchTranslateDocumentMetadata_State.Descriptor instead.
func (BatchTranslateDocumentMetadata_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_translation_service_proto_rawDescGZIP(), []int{36, 0}
}

// Configures which glossary is used for a specific target language and defines
// options for applying that glossary.
type TranslateTextGlossaryConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The `glossary` to be applied for this translation.
	//
	// The format depends on the glossary:
	//
	// - User-provided custom glossary:
	//   `projects/{project-number-or-id}/locations/{location-id}/glossaries/{glossary-id}`
	Glossary string `protobuf:"bytes,1,opt,name=glossary,proto3" json:"glossary,omitempty"`
	// Optional. Indicates match is case insensitive. The default value is `false`
	// if missing.
	IgnoreCase bool `protobuf:"varint,2,opt,name=ignore_case,json=ignoreCase,proto3" json:"ignore_case,omitempty"`
}

func (x *TranslateTextGlossaryConfig) Reset() {
	*x = TranslateTextGlossaryConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TranslateTextGlossaryConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TranslateTextGlossaryConfig) ProtoMessage() {}

func (x *TranslateTextGlossaryConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TranslateTextGlossaryConfig.ProtoReflect.Descriptor instead.
func (*TranslateTextGlossaryConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_translation_service_proto_rawDescGZIP(), []int{0}
}

func (x *TranslateTextGlossaryConfig) GetGlossary() string {
	if x != nil {
		return x.Glossary
	}
	return ""
}

func (x *TranslateTextGlossaryConfig) GetIgnoreCase() bool {
	if x != nil {
		return x.IgnoreCase
	}
	return false
}

// The request message for synchronous translation.
type TranslateTextRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The content of the input in string format.
	// We recommend the total content be less than 30,000 codepoints. The max
	// length of this field is 1024. Use BatchTranslateText for larger text.
	Contents []string `protobuf:"bytes,1,rep,name=contents,proto3" json:"contents,omitempty"`
	// Optional. The format of the source text, for example, "text/html",
	//  "text/plain". If left blank, the MIME type defaults to "text/html".
	MimeType string `protobuf:"bytes,3,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
	// Optional. The ISO-639 language code of the input text if
	// known, for example, "en-US" or "sr-Latn". Supported language codes are
	// listed in Language Support. If the source language isn't specified, the API
	// attempts to identify the source language automatically and returns the
	// source language within the response.
	SourceLanguageCode string `protobuf:"bytes,4,opt,name=source_language_code,json=sourceLanguageCode,proto3" json:"source_language_code,omitempty"`
	// Required. The ISO-639 language code to use for translation of the input
	// text, set to one of the language codes listed in Language Support.
	TargetLanguageCode string `protobuf:"bytes,5,opt,name=target_language_code,json=targetLanguageCode,proto3" json:"target_language_code,omitempty"`
	// Required. Project or location to make a call. Must refer to a caller's
	// project.
	//
	// Format: `projects/{project-number-or-id}` or
	// `projects/{project-number-or-id}/locations/{location-id}`.
	//
	// For global calls, use `projects/{project-number-or-id}/locations/global` or
	// `projects/{project-number-or-id}`.
	//
	// Non-global location is required for requests using AutoML models or
	// custom glossaries.
	//
	// Models and glossaries must be within the same region (have same
	// location-id), otherwise an INVALID_ARGUMENT (400) error is returned.
	Parent string `protobuf:"bytes,8,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The `model` type requested for this translation.
	//
	// The format depends on model type:
	//
	// - AutoML Translation models:
	//   `projects/{project-number-or-id}/locations/{location-id}/models/{model-id}`
	//
	// - General (built-in) models:
	//   `projects/{project-number-or-id}/locations/{location-id}/models/general/nmt`,
	//
	//
	// For global (non-regionalized) requests, use `location-id` `global`.
	// For example,
	// `projects/{project-number-or-id}/locations/global/models/general/nmt`.
	//
	// If not provided, the default Google model (NMT) will be used
	Model string `protobuf:"bytes,6,opt,name=model,proto3" json:"model,omitempty"`
	// Optional. Glossary to be applied. The glossary must be
	// within the same region (have the same location-id) as the model, otherwise
	// an INVALID_ARGUMENT (400) error is returned.
	GlossaryConfig *TranslateTextGlossaryConfig `protobuf:"bytes,7,opt,name=glossary_config,json=glossaryConfig,proto3" json:"glossary_config,omitempty"`
	// Optional. The labels with user-defined metadata for the request.
	//
	// Label keys and values can be no longer than 63 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	// Label values are optional. Label keys must start with a letter.
	//
	// See https://cloud.google.com/translate/docs/advanced/labels for more
	// information.
	Labels map[string]string `protobuf:"bytes,10,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *TranslateTextRequest) Reset() {
	*x = TranslateTextRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TranslateTextRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TranslateTextRequest) ProtoMessage() {}

func (x *TranslateTextRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TranslateTextRequest.ProtoReflect.Descriptor instead.
func (*TranslateTextRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_translation_service_proto_rawDescGZIP(), []int{1}
}

func (x *TranslateTextRequest) GetContents() []string {
	if x != nil {
		return x.Contents
	}
	return nil
}

func (x *TranslateTextRequest) GetMimeType() string {
	if x != nil {
		return x.MimeType
	}
	return ""
}

func (x *TranslateTextRequest) GetSourceLanguageCode() string {
	if x != nil {
		return x.SourceLanguageCode
	}
	return ""
}

func (x *TranslateTextRequest) GetTargetLanguageCode() string {
	if x != nil {
		return x.TargetLanguageCode
	}
	return ""
}

func (x *TranslateTextRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *TranslateTextRequest) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

func (x *TranslateTextRequest) GetGlossaryConfig() *TranslateTextGlossaryConfig {
	if x != nil {
		return x.GlossaryConfig
	}
	return nil
}

func (x *TranslateTextRequest) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

type TranslateTextResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Text translation responses with no glossary applied.
	// This field has the same length as
	// [`contents`][google.cloud.translation.v3.TranslateTextRequest.contents].
	Translations []*Translation `protobuf:"bytes,1,rep,name=translations,proto3" json:"translations,omitempty"`
	// Text translation responses if a glossary is provided in the request.
	// This can be the same as
	// [`translations`][google.cloud.translation.v3.TranslateTextResponse.translations]
	// if no terms apply. This field has the same length as
	// [`contents`][google.cloud.translation.v3.TranslateTextRequest.contents].
	GlossaryTranslations []*Translation `protobuf:"bytes,3,rep,name=glossary_translations,json=glossaryTranslations,proto3" json:"glossary_translations,omitempty"`
}

func (x *TranslateTextResponse) Reset() {
	*x = TranslateTextResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TranslateTextResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TranslateTextResponse) ProtoMessage() {}

func (x *TranslateTextResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TranslateTextResponse.ProtoReflect.Descriptor instead.
func (*TranslateTextResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_translation_service_proto_rawDescGZIP(), []int{2}
}

func (x *TranslateTextResponse) GetTranslations() []*Translation {
	if x != nil {
		return x.Translations
	}
	return nil
}

func (x *TranslateTextResponse) GetGlossaryTranslations() []*Translation {
	if x != nil {
		return x.GlossaryTranslations
	}
	return nil
}

// A single translation response.
type Translation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Text translated into the target language.
	// If an error occurs during translation, this field might be excluded from
	// the response.
	TranslatedText string `protobuf:"bytes,1,opt,name=translated_text,json=translatedText,proto3" json:"translated_text,omitempty"`
	// Only present when `model` is present in the request.
	// `model` here is normalized to have project number.
	//
	// For example:
	// If the `model` requested in TranslationTextRequest is
	// `projects/{project-id}/locations/{location-id}/models/general/nmt` then
	// `model` here would be normalized to
	// `projects/{project-number}/locations/{location-id}/models/general/nmt`.
	Model string `protobuf:"bytes,2,opt,name=model,proto3" json:"model,omitempty"`
	// The ISO-639 language code of source text in the initial request, detected
	// automatically, if no source language was passed within the initial
	// request. If the source language was passed, auto-detection of the language
	// does not occur and this field is empty.
	DetectedLanguageCode string `protobuf:"bytes,4,opt,name=detected_language_code,json=detectedLanguageCode,proto3" json:"detected_language_code,omitempty"`
	// The `glossary_config` used for this translation.
	GlossaryConfig *TranslateTextGlossaryConfig `protobuf:"bytes,3,opt,name=glossary_config,json=glossaryConfig,proto3" json:"glossary_config,omitempty"`
}

func (x *Translation) Reset() {
	*x = Translation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Translation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Translation) ProtoMessage() {}

func (x *Translation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Translation.ProtoReflect.Descriptor instead.
func (*Translation) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_translation_service_proto_rawDescGZIP(), []int{3}
}

func (x *Translation) GetTranslatedText() string {
	if x != nil {
		return x.TranslatedText
	}
	return ""
}

func (x *Translation) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

func (x *Translation) GetDetectedLanguageCode() string {
	if x != nil {
		return x.DetectedLanguageCode
	}
	return ""
}

func (x *Translation) GetGlossaryConfig() *TranslateTextGlossaryConfig {
	if x != nil {
		return x.GlossaryConfig
	}
	return nil
}

// The request message for language detection.
type DetectLanguageRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Project or location to make a call. Must refer to a caller's
	// project.
	//
	// Format: `projects/{project-number-or-id}/locations/{location-id}` or
	// `projects/{project-number-or-id}`.
	//
	// For global calls, use `projects/{project-number-or-id}/locations/global` or
	// `projects/{project-number-or-id}`.
	//
	// Only models within the same region (has same location-id) can be used.
	// Otherwise an INVALID_ARGUMENT (400) error is returned.
	Parent string `protobuf:"bytes,5,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The language detection model to be used.
	//
	// Format:
	// `projects/{project-number-or-id}/locations/{location-id}/models/language-detection/{model-id}`
	//
	// Only one language detection model is currently supported:
	// `projects/{project-number-or-id}/locations/{location-id}/models/language-detection/default`.
	//
	// If not specified, the default model is used.
	Model string `protobuf:"bytes,4,opt,name=model,proto3" json:"model,omitempty"`
	// Required. The source of the document from which to detect the language.
	//
	// Types that are assignable to Source:
	//	*DetectLanguageRequest_Content
	Source isDetectLanguageRequest_Source `protobuf_oneof:"source"`
	// Optional. The format of the source text, for example, "text/html",
	// "text/plain". If left blank, the MIME type defaults to "text/html".
	MimeType string `protobuf:"bytes,3,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
	// Optional. The labels with user-defined metadata for the request.
	//
	// Label keys and values can be no longer than 63 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	// Label values are optional. Label keys must start with a letter.
	//
	// See https://cloud.google.com/translate/docs/advanced/labels for more
	// information.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *DetectLanguageRequest) Reset() {
	*x = DetectLanguageRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DetectLanguageRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DetectLanguageRequest) ProtoMessage() {}

func (x *DetectLanguageRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DetectLanguageRequest.ProtoReflect.Descriptor instead.
func (*DetectLanguageRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_translation_service_proto_rawDescGZIP(), []int{4}
}

func (x *DetectLanguageRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *DetectLanguageRequest) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

func (m *DetectLanguageRequest) GetSource() isDetectLanguageRequest_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *DetectLanguageRequest) GetContent() string {
	if x, ok := x.GetSource().(*DetectLanguageRequest_Content); ok {
		return x.Content
	}
	return ""
}

func (x *DetectLanguageRequest) GetMimeType() string {
	if x != nil {
		return x.MimeType
	}
	return ""
}

func (x *DetectLanguageRequest) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

type isDetectLanguageRequest_Source interface {
	isDetectLanguageRequest_Source()
}

type DetectLanguageRequest_Content struct {
	// The content of the input stored as a string.
	Content string `protobuf:"bytes,1,opt,name=content,proto3,oneof"`
}

func (*DetectLanguageRequest_Content) isDetectLanguageRequest_Source() {}

// The response message for language detection.
type DetectedLanguage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ISO-639 language code of the source content in the request, detected
	// automatically.
	LanguageCode string `protobuf:"bytes,1,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// The confidence of the detection result for this language.
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
}

func (x *DetectedLanguage) Reset() {
	*x = DetectedLanguage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DetectedLanguage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DetectedLanguage) ProtoMessage() {}

func (x *DetectedLanguage) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DetectedLanguage.ProtoReflect.Descriptor instead.
func (*DetectedLanguage) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_translation_service_proto_rawDescGZIP(), []int{5}
}

func (x *DetectedLanguage) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *DetectedLanguage) GetConfidence() float32 {
	if x != nil {
		return x.Confidence
	}
	return 0
}

// The response message for language detection.
type DetectLanguageResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The most probable language detected by the Translation API. For each
	// request, the Translation API will always return only one result.
	Languages []*DetectedLanguage `protobuf:"bytes,1,rep,name=languages,proto3" json:"languages,omitempty"`
}

func (x *DetectLanguageResponse) Reset() {
	*x = DetectLanguageResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DetectLanguageResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DetectLanguageResponse) ProtoMessage() {}

func (x *DetectLanguageResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DetectLanguageResponse.ProtoReflect.Descriptor instead.
func (*DetectLanguageResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_translation_service_proto_rawDescGZIP(), []int{6}
}

func (x *DetectLanguageResponse) GetLanguages() []*DetectedLanguage {
	if x != nil {
		return x.Languages
	}
	return nil
}

// The request message for discovering supported languages.
type GetSupportedLanguagesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Project or location to make a call. Must refer to a caller's
	// project.
	//
	// Format: `projects/{project-number-or-id}` or
	// `projects/{project-number-or-id}/locations/{location-id}`.
	//
	// For global calls, use `projects/{project-number-or-id}/locations/global` or
	// `projects/{project-number-or-id}`.
	//
	// Non-global location is required for AutoML models.
	//
	// Only models within the same region (have same location-id) can be used,
	// otherwise an INVALID_ARGUMENT (400) error is returned.
	Parent string `protobuf:"bytes,3,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The language to use to return localized, human readable names
	// of supported languages. If missing, then display names are not returned
	// in a response.
	DisplayLanguageCode string `protobuf:"bytes,1,opt,name=display_language_code,json=displayLanguageCode,proto3" json:"display_language_code,omitempty"`
	// Optional. Get supported languages of this model.
	//
	// The format depends on model type:
	//
	// - AutoML Translation models:
	//   `projects/{project-number-or-id}/locations/{location-id}/models/{model-id}`
	//
	// - General (built-in) models:
	//   `projects/{project-number-or-id}/locations/{location-id}/models/general/nmt`,
	//
	//
	// Returns languages supported by the specified model.
	// If missing, we get supported languages of Google general NMT model.
	Model string `protobuf:"bytes,2,opt,name=model,proto3" json:"model,omitempty"`
}

func (x *GetSupportedLanguagesRequest) Reset() {
	*x = GetSupportedLanguagesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSupportedLanguagesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSupportedLanguagesRequest) ProtoMessage() {}

func (x *GetSupportedLanguagesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSupportedLanguagesRequest.ProtoReflect.Descriptor instead.
func (*GetSupportedLanguagesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_translation_service_proto_rawDescGZIP(), []int{7}
}

func (x *GetSupportedLanguagesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *GetSupportedLanguagesRequest) GetDisplayLanguageCode() string {
	if x != nil {
		return x.DisplayLanguageCode
	}
	return ""
}

func (x *GetSupportedLanguagesRequest) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

// The response message for discovering supported languages.
type SupportedLanguages struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of supported language responses. This list contains an entry
	// for each language the Translation API supports.
	Languages []*SupportedLanguage `protobuf:"bytes,1,rep,name=languages,proto3" json:"languages,omitempty"`
}

func (x *SupportedLanguages) Reset() {
	*x = SupportedLanguages{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SupportedLanguages) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SupportedLanguages) ProtoMessage() {}

func (x *SupportedLanguages) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SupportedLanguages.ProtoReflect.Descriptor instead.
func (*SupportedLanguages) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_translation_service_proto_rawDescGZIP(), []int{8}
}

func (x *SupportedLanguages) GetLanguages() []*SupportedLanguage {
	if x != nil {
		return x.Languages
	}
	return nil
}

// A single supported language response corresponds to information related
// to one supported language.
type SupportedLanguage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Supported language code, generally consisting of its ISO 639-1
	// identifier, for example, 'en', 'ja'. In certain cases, ISO-639 codes
	// including language and region identifiers are returned (for example,
	// 'zh-TW' and 'zh-CN').
	LanguageCode string `protobuf:"bytes,1,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Human-readable name of the language localized in the display language
	// specified in the request.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Can be used as a source language.
	SupportSource bool `protobuf:"varint,3,opt,name=support_source,json=supportSource,proto3" json:"support_source,omitempty"`
	// Can be used as a target language.
	SupportTarget bool `protobuf:"varint,4,opt,name=support_target,json=supportTarget,proto3" json:"support_target,omitempty"`
}

func (x *SupportedLanguage) Reset() {
	*x = SupportedLanguage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SupportedLanguage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SupportedLanguage) ProtoMessage() {}

func (x *SupportedLanguage) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SupportedLanguage.ProtoReflect.Descriptor instead.
func (*SupportedLanguage) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_translation_service_proto_rawDescGZIP(), []int{9}
}

func (x *SupportedLanguage) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *SupportedLanguage) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *SupportedLanguage) GetSupportSource() bool {
	if x != nil {
		return x.SupportSource
	}
	return false
}

func (x *SupportedLanguage) GetSupportTarget() bool {
	if x != nil {
		return x.SupportTarget
	}
	return false
}

// The Google Cloud Storage location for the input content.
type GcsSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Source data URI. For example, `gs://my_bucket/my_object`.
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
}

func (x *GcsSource) Reset() {
	*x = GcsSource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GcsSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcsSource) ProtoMessage() {}

func (x *GcsSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcsSource.ProtoReflect.Descriptor instead.
func (*GcsSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_translation_service_proto_rawDescGZIP(), []int{10}
}

func (x *GcsSource) GetInputUri() string {
	if x != nil {
		return x.InputUri
	}
	return ""
}

// Input configuration for BatchTranslateText request.
type InputConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Can be "text/plain" or "text/html".
	// For `.tsv`, "text/html" is used if mime_type is missing.
	// For `.html`, this field must be "text/html" or empty.
	// For `.txt`, this field must be "text/plain" or empty.
	MimeType string `protobuf:"bytes,1,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
	// Required. Specify the input.
	//
	// Types that are assignable to Source:
	//	*InputConfig_GcsSource
	Source isInputConfig_Source `protobuf_oneof:"source"`
}

func (x *InputConfig) Reset() {
	*x = InputConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InputConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InputConfig) ProtoMessage() {}

func (x *InputConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InputConfig.ProtoReflect.Descriptor instead.
func (*InputConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_translation_service_proto_rawDescGZIP(), []int{11}
}

func (x *InputConfig) GetMimeType() string {
	if x != nil {
		return x.MimeType
	}
	return ""
}

func (m *InputConfig) GetSource() isInputConfig_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *InputConfig) GetGcsSource() *GcsSource {
	if x, ok := x.GetSource().(*InputConfig_GcsSource); ok {
		return x.GcsSource
	}
	return nil
}

type isInputConfig_Source interface {
	isInputConfig_Source()
}

type InputConfig_GcsSource struct {
	// Required. Google Cloud Storage location for the source input.
	// This can be a single file (for example,
	// `gs://translation-test/input.tsv`) or a wildcard (for example,
	// `gs://translation-test/*`). If a file extension is `.tsv`, it can
	// contain either one or two columns. The first column (optional) is the id
	// of the text request. If the first column is missing, we use the row
	// number (0-based) from the input file as the ID in the output file. The
	// second column is the actual text to be
	//  translated. We recommend each row be <= 10K Unicode codepoints,
	// otherwise an error might be returned.
	// Note that the input tsv must be RFC 4180 compliant.
	//
	// You could use https://github.com/Clever/csvlint to check potential
	// formatting errors in your tsv file.
	// csvlint --delimiter='\t' your_input_file.tsv
	//
	// The other supported file extensions are `.txt` or `.html`, which is
	// treated as a single large chunk of text.
	GcsSource *GcsSource `protobuf:"bytes,2,opt,name=gcs_source,json=gcsSource,proto3,oneof"`
}

func (*InputConfig_GcsSource) isInputConfig_Source() {}

// The Google Cloud Storage location for the output content.
type GcsDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The bucket used in 'output_uri_prefix' must exist and there must
	// be no files under 'output_uri_prefix'. 'output_uri_prefix' must end with
	// "/" and start with "gs://". One 'output_uri_prefix' can only be used by one
	// batch translation job at a time. Otherwise an INVALID_ARGUMENT (400) error
	// is returned.
	OutputUriPrefix string `protobuf:"bytes,1,opt,name=output_uri_prefix,json=outputUriPrefix,proto3" json:"output_uri_prefix,omitempty"`
}

func (x *GcsDestination) Reset() {
	*x = GcsDestination{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GcsDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcsDestination) ProtoMessage() {}

func (x *GcsDestination) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcsDestination.ProtoReflect.Descriptor instead.
func (*GcsDestination) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_translation_service_proto_rawDescGZIP(), []int{12}
}

func (x *GcsDestination) GetOutputUriPrefix() string {
	if x != nil {
		return x.OutputUriPrefix
	}
	return ""
}

// Output configuration for BatchTranslateText request.
type OutputConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The destination of output.
	//
	// Types that are assignable to Destination:
	//	*OutputConfig_GcsDestination
	Destination isOutputConfig_Destination `protobuf_oneof:"destination"`
}

func (x *OutputConfig) Reset() {
	*x = OutputConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OutputConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutputConfig) ProtoMessage() {}

func (x *OutputConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutputConfig.ProtoReflect.Descriptor instead.
func (*OutputConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_translation_service_proto_rawDescGZIP(), []int{13}
}

func (m *OutputConfig) GetDestination() isOutputConfig_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *OutputConfig) GetGcsDestination() *GcsDestination {
	if x, ok := x.GetDestination().(*OutputConfig_GcsDestination); ok {
		return x.GcsDestination
	}
	return nil
}

type isOutputConfig_Destination interface {
	isOutputConfig_Destination()
}

type OutputConfig_GcsDestination struct {
	// Google Cloud Storage destination for output content.
	// For every single input file (for example, gs://a/b/c.[extension]), we
	// generate at most 2 * n output files. (n is the # of target_language_codes
	// in the BatchTranslateTextRequest).
	//
	// Output files (tsv) generated are compliant with RFC 4180 except that
	// record delimiters are '\n' instead of '\r\n'. We don't provide any way to
	// change record delimiters.
	//
	// While the input files are being processed, we write/update an index file
	// 'index.csv'  under 'output_uri_prefix' (for example,
	// gs://translation-test/index.csv) The index file is generated/updated as
	// new files are being translated. The format is:
	//
	// input_file,target_language_code,translations_file,errors_file,
	// glossary_translations_file,glossary_errors_file
	//
	// input_file is one file we matched using gcs_source.input_uri.
	// target_language_code is provided in the request.
	// translations_file contains the translations. (details provided below)
	// errors_file contains the errors during processing of the file. (details
	// below). Both translations_file and errors_file could be empty
	// strings if we have no content to output.
	// glossary_translations_file and glossary_errors_file are always empty
	// strings if the input_file is tsv. They could also be empty if we have no
	// content to output.
	//
	// Once a row is present in index.csv, the input/output matching never
	// changes. Callers should also expect all the content in input_file are
	// processed and ready to be consumed (that is, no partial output file is
	// written).
	//
	// Since index.csv will be keeping updated during the process, please make
	// sure there is no custom retention policy applied on the output bucket
	// that may avoid file updating.
	// (https://cloud.google.com/storage/docs/bucket-lock#retention-policy)
	//
	// The format of translations_file (for target language code 'trg') is:
	// `gs://translation_test/a_b_c_'trg'_translations.[extension]`
	//
	// If the input file extension is tsv, the output has the following
	// columns:
	// Column 1: ID of the request provided in the input, if it's not
	// provided in the input, then the input row number is used (0-based).
	// Column 2: source sentence.
	// Column 3: translation without applying a glossary. Empty string if there
	// is an error.
	// Column 4 (only present if a glossary is provided in the request):
	// translation after applying the glossary. Empty string if there is an
	// error applying the glossary. Could be same string as column 3 if there is
	// no glossary applied.
	//
	// If input file extension is a txt or html, the translation is directly
	// written to the output file. If glossary is requested, a separate
	// glossary_translations_file has format of
	// `gs://translation_test/a_b_c_'trg'_glossary_translations.[extension]`
	//
	// The format of errors file (for target language code 'trg') is:
	// `gs://translation_test/a_b_c_'trg'_errors.[extension]`
	//
	// If the input file extension is tsv, errors_file contains the following:
	// Column 1: ID of the request provided in the input, if it's not
	// provided in the input, then the input row number is used (0-based).
	// Column 2: source sentence.
	// Column 3: Error detail for the translation. Could be empty.
	// Column 4 (only present if a glossary is provided in the request):
	// Error when applying the glossary.
	//
	// If the input file extension is txt or html, glossary_error_file will be
	// generated that contains error details. glossary_error_file has format of
	// `gs://translation_test/a_b_c_'trg'_glossary_errors.[extension]`
	GcsDestination *GcsDestination `protobuf:"bytes,1,opt,name=gcs_destination,json=gcsDestination,proto3,oneof"`
}

func (*OutputConfig_GcsDestination) isOutputConfig_Destination() {}

// A document translation request input config.
type DocumentInputConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies the source for the document's content.
	// The input file size should be <= 20MB for
	// - application/vnd.openxmlformats-officedocument.wordprocessingml.document
	// - application/vnd.openxmlformats-officedocument.presentationml.presentation
	// - application/vnd.openxmlformats-officedocument.spreadsheetml.sheet
	// The input file size should be <= 20MB and the maximum page limit is 20 for
	// - application/pdf
	//
	// Types that are assignable to Source:
	//	*DocumentInputConfig_Content
	//	*DocumentInputConfig_GcsSource
	Source isDocumentInputConfig_Source `protobuf_oneof:"source"`
	// Specifies the input document's mime_type.
	//
	// If not specified it will be determined using the file extension for
	// gcs_source provided files. For a file provided through bytes content the
	// mime_type must be provided.
	// Currently supported mime types are:
	// - application/pdf
	// - application/vnd.openxmlformats-officedocument.wordprocessingml.document
	// - application/vnd.openxmlformats-officedocument.presentationml.presentation
	// - application/vnd.openxmlformats-officedocument.spreadsheetml.sheet
	MimeType string `protobuf:"bytes,4,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
}

func (x *DocumentInputConfig) Reset() {
	*x = DocumentInputConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DocumentInputConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DocumentInputConfig) ProtoMessage() {}

func (x *DocumentInputConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DocumentInputConfig.ProtoReflect.Descriptor instead.
func (*DocumentInputConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_translation_service_proto_rawDescGZIP(), []int{14}
}

func (m *DocumentInputConfig) GetSource() isDocumentInputConfig_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *DocumentInputConfig) GetContent() []byte {
	if x, ok := x.GetSource().(*DocumentInputConfig_Content); ok {
		return x.Content
	}
	return nil
}

func (x *DocumentInputConfig) GetGcsSource() *GcsSource {
	if x, ok := x.GetSource().(*DocumentInputConfig_GcsSource); ok {
		return x.GcsSource
	}
	return nil
}

func (x *DocumentInputConfig) GetMimeType() string {
	if x != nil {
		return x.MimeType
	}
	return ""
}

type isDocumentInputConfig_Source interface {
	isDocumentInputConfig_Source()
}

type DocumentInputConfig_Content struct {
	// Document's content represented as a stream of bytes.
	Content []byte `protobuf:"bytes,1,opt,name=content,proto3,oneof"`
}

type DocumentInputConfig_GcsSource struct {
	// Google Cloud Storage location. This must be a single file.
	// For example: gs://example_bucket/example_file.pdf
	GcsSource *GcsSource `protobuf:"bytes,2,opt,name=gcs_source,json=gcsSource,proto3,oneof"`
}

func (*DocumentInputConfig_Content) isDocumentInputConfig_Source() {}

func (*DocumentInputConfig_GcsSource) isDocumentInputConfig_Source() {}

// A document translation request output config.
type DocumentOutputConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A URI destination for the translated document.
	// It is optional to provide a destination. If provided the results from
	// TranslateDocument will be stored in the destination.
	// Whether a destination is provided or not, the translated documents will be
	// returned within TranslateDocumentResponse.document_translation and
	// TranslateDocumentResponse.glossary_document_translation.
	//
	// Types that are assignable to Destination:
	//	*DocumentOutputConfig_GcsDestination
	Destination isDocumentOutputConfig_Destination `protobuf_oneof:"destination"`
	// Optional. Specifies the translated document's mime_type.
	// If not specified, the translated file's mime type will be the same as the
	// input file's mime type.
	// Currently only support the output mime type to be the same as input mime
	// type.
	// - application/pdf
	// - application/vnd.openxmlformats-officedocument.wordprocessingml.document
	// - application/vnd.openxmlformats-officedocument.presentationml.presentation
	// - application/vnd.openxmlformats-officedocument.spreadsheetml.sheet
	MimeType string `protobuf:"bytes,3,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
}

func (x *DocumentOutputConfig) Reset() {
	*x = DocumentOutputConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DocumentOutputConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DocumentOutputConfig) ProtoMessage() {}

func (x *DocumentOutputConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DocumentOutputConfig.ProtoReflect.Descriptor instead.
func (*DocumentOutputConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_translation_service_proto_rawDescGZIP(), []int{15}
}

func (m *DocumentOutputConfig) GetDestination() isDocumentOutputConfig_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *DocumentOutputConfig) GetGcsDestination() *GcsDestination {
	if x, ok := x.GetDestination().(*DocumentOutputConfig_GcsDestination); ok {
		return x.GcsDestination
	}
	return nil
}

func (x *DocumentOutputConfig) GetMimeType() string {
	if x != nil {
		return x.MimeType
	}
	return ""
}

type isDocumentOutputConfig_Destination interface {
	isDocumentOutputConfig_Destination()
}

type DocumentOutputConfig_GcsDestination struct {
	// Optional. Google Cloud Storage destination for the translation output,
	// e.g., `gs://my_bucket/my_directory/`.
	//
	// The destination directory provided does not have to be empty, but the
	// bucket must exist. If a file with the same name as the output file
	// already exists in the destination an error will be returned.
	//
	// For a DocumentInputConfig.contents provided document, the output file
	// will have the name "output_[trg]_translations.[ext]", where
	// - [trg] corresponds to the translated file's language code,
	// - [ext] corresponds to the translated file's extension according to its
	// mime type.
	//
	//
	// For a DocumentInputConfig.gcs_uri provided document, the output file will
	// have a name according to its URI. For example: an input file with URI:
	// `gs://a/b/c.[extension]` stored in a gcs_destination bucket with name
	// "my_bucket" will have an output URI:
	// `gs://my_bucket/a_b_c_[trg]_translations.[ext]`, where
	// - [trg] corresponds to the translated file's language code,
	// - [ext] corresponds to the translated file's extension according to its
	// mime type.
	//
	//
	// If the document was directly provided through the request, then the
	// output document will have the format:
	// `gs://my_bucket/translated_document_[trg]_translations.[ext]`, where
	// - [trg] corresponds to the translated file's language code,
	// - [ext] corresponds to the translated file's extension according to its
	// mime type.
	//
	// If a glossary was provided, then the output URI for the glossary
	// translation will be equal to the default output URI but have
	// `glossary_translations` instead of `translations`. For the previous
	// example, its glossary URI would be:
	// `gs://my_bucket/a_b_c_[trg]_glossary_translations.[ext]`.
	//
	// Thus the max number of output files will be 2 (Translated document,
	// Glossary translated document).
	//
	// Callers should expect no partial outputs. If there is any error during
	// document translation, no output will be stored in the Cloud Storage
	// bucket.
	GcsDestination *GcsDestination `protobuf:"bytes,1,opt,name=gcs_destination,json=gcsDestination,proto3,oneof"`
}

func (*DocumentOutputConfig_GcsDestination) isDocumentOutputConfig_Destination() {}

// A document translation request.
type TranslateDocumentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Location to make a regional call.
	//
	// Format: `projects/{project-number-or-id}/locations/{location-id}`.
	//
	// For global calls, use `projects/{project-number-or-id}/locations/global` or
	// `projects/{project-number-or-id}`.
	//
	// Non-global location is required for requests using AutoML models or custom
	// glossaries.
	//
	// Models and glossaries must be within the same region (have the same
	// location-id), otherwise an INVALID_ARGUMENT (400) error is returned.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The ISO-639 language code of the input document if known, for
	// example, "en-US" or "sr-Latn". Supported language codes are listed in
	// Language Support. If the source language isn't specified, the API attempts
	// to identify the source language automatically and returns the source
	// language within the response. Source language must be specified if the
	// request contains a glossary or a custom model.
	SourceLanguageCode string `protobuf:"bytes,2,opt,name=source_language_code,json=sourceLanguageCode,proto3" json:"source_language_code,omitempty"`
	// Required. The ISO-639 language code to use for translation of the input
	// document, set to one of the language codes listed in Language Support.
	TargetLanguageCode string `protobuf:"bytes,3,opt,name=target_language_code,json=targetLanguageCode,proto3" json:"target_language_code,omitempty"`
	// Required. Input configurations.
	DocumentInputConfig *DocumentInputConfig `protobuf:"bytes,4,opt,name=document_input_config,json=documentInputConfig,proto3" json:"document_input_config,omitempty"`
	// Optional. Output configurations.
	// Defines if the output file should be stored within Cloud Storage as well
	// as the desired output format. If not provided the translated file will
	// only be returned through a byte-stream and its output mime type will be
	// the same as the input file's mime type.
	DocumentOutputConfig *DocumentOutputConfig `protobuf:"bytes,5,opt,name=document_output_config,json=documentOutputConfig,proto3" json:"document_output_config,omitempty"`
	// Optional. The `model` type requested for this translation.
	//
	// The format depends on model type:
	//
	// - AutoML Translation models:
	//   `projects/{project-number-or-id}/locations/{location-id}/models/{model-id}`
	//
	// - General (built-in) models:
	//   `projects/{project-number-or-id}/locations/{location-id}/models/general/nmt`,
	//
	//
	// If not provided, the default Google model (NMT) will be used for
	// translation.
	Model string `protobuf:"bytes,6,opt,name=model,proto3" json:"model,omitempty"`
	// Optional. Glossary to be applied. The glossary must be within the same
	// region (have the same location-id) as the model, otherwise an
	// INVALID_ARGUMENT (400) error is returned.
	GlossaryConfig *TranslateTextGlossaryConfig `protobuf:"bytes,7,opt,name=glossary_config,json=glossaryConfig,proto3" json:"glossary_config,omitempty"`
	// Optional. The labels with user-defined metadata for the request.
	//
	// Label keys and values can be no longer than 63 characters (Unicode
	// codepoints), can only contain lowercase letters, numeric characters,
	// underscores and dashes. International characters are allowed. Label values
	// are optional. Label keys must start with a letter.
	//
	// See https://cloud.google.com/translate/docs/advanced/labels for more
	// information.
	Labels map[string]string `protobuf:"bytes,8,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. This flag is to support user customized attribution.
	// If not provided, the default is `Machine Translated by Google`.
	// Customized attribution should follow rules in
	// https://cloud.google.com/translate/attribution#attribution_and_logos
	CustomizedAttribution string `protobuf:"bytes,10,opt,name=customized_attribution,json=customizedAttribution,proto3" json:"customized_attribution,omitempty"`
	// Optional. is_translate_native_pdf_only field for external customers.
	// If true, the page limit of online native pdf translation is 300 and only
	// native pdf pages will be translated.
	IsTranslateNativePdfOnly bool `protobuf:"varint,11,opt,name=is_translate_native_pdf_only,json=isTranslateNativePdfOnly,proto3" json:"is_translate_native_pdf_only,omitempty"`
	// Optional. If true, use the text removal server to remove the shadow text on
	// background image for native pdf translation.
	// Shadow removal feature can only be enabled when
	// is_translate_native_pdf_only: false && pdf_native_only: false
	EnableShadowRemovalNativePdf bool `protobuf:"varint,12,opt,name=enable_shadow_removal_native_pdf,json=enableShadowRemovalNativePdf,proto3" json:"enable_shadow_removal_native_pdf,omitempty"`
	// Optional. If true, enable auto rotation correction in DVS.
	EnableRotationCorrection bool `protobuf:"varint,13,opt,name=enable_rotation_correction,json=enableRotationCorrection,proto3" json:"enable_rotation_correction,omitempty"`
}

func (x *TranslateDocumentRequest) Reset() {
	*x = TranslateDocumentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TranslateDocumentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TranslateDocumentRequest) ProtoMessage() {}

func (x *TranslateDocumentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TranslateDocumentRequest.ProtoReflect.Descriptor instead.
func (*TranslateDocumentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_translation_service_proto_rawDescGZIP(), []int{16}
}

func (x *TranslateDocumentRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *TranslateDocumentRequest) GetSourceLanguageCode() string {
	if x != nil {
		return x.SourceLanguageCode
	}
	return ""
}

func (x *TranslateDocumentRequest) GetTargetLanguageCode() string {
	if x != nil {
		return x.TargetLanguageCode
	}
	return ""
}

func (x *TranslateDocumentRequest) GetDocumentInputConfig() *DocumentInputConfig {
	if x != nil {
		return x.DocumentInputConfig
	}
	return nil
}

func (x *TranslateDocumentRequest) GetDocumentOutputConfig() *DocumentOutputConfig {
	if x != nil {
		return x.DocumentOutputConfig
	}
	return nil
}

func (x *TranslateDocumentRequest) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

func (x *TranslateDocumentRequest) GetGlossaryConfig() *TranslateTextGlossaryConfig {
	if x != nil {
		return x.GlossaryConfig
	}
	return nil
}

func (x *TranslateDocumentRequest) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *TranslateDocumentRequest) GetCustomizedAttribution() string {
	if x != nil {
		return x.CustomizedAttribution
	}
	return ""
}

func (x *TranslateDocumentRequest) GetIsTranslateNativePdfOnly() bool {
	if x != nil {
		return x.IsTranslateNativePdfOnly
	}
	return false
}

func (x *TranslateDocumentRequest) GetEnableShadowRemovalNativePdf() bool {
	if x != nil {
		return x.EnableShadowRemovalNativePdf
	}
	return false
}

func (x *TranslateDocumentRequest) GetEnableRotationCorrection() bool {
	if x != nil {
		return x.EnableRotationCorrection
	}
	return false
}

// A translated document message.
type DocumentTranslation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The array of translated documents. It is expected to be size 1 for now. We
	// may produce multiple translated documents in the future for other type of
	// file formats.
	ByteStreamOutputs [][]byte `protobuf:"bytes,1,rep,name=byte_stream_outputs,json=byteStreamOutputs,proto3" json:"byte_stream_outputs,omitempty"`
	// The translated document's mime type.
	MimeType string `protobuf:"bytes,2,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
	// The detected language for the input document.
	// If the user did not provide the source language for the input document,
	// this field will have the language code automatically detected. If the
	// source language was passed, auto-detection of the language does not occur
	// and this field is empty.
	DetectedLanguageCode string `protobuf:"bytes,3,opt,name=detected_language_code,json=detectedLanguageCode,proto3" json:"detected_language_code,omitempty"`
}

func (x *DocumentTranslation) Reset() {
	*x = DocumentTranslation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DocumentTranslation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DocumentTranslation) ProtoMessage() {}

func (x *DocumentTranslation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DocumentTranslation.ProtoReflect.Descriptor instead.
func (*DocumentTranslation) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_translation_service_proto_rawDescGZIP(), []int{17}
}

func (x *DocumentTranslation) GetByteStreamOutputs() [][]byte {
	if x != nil {
		return x.ByteStreamOutputs
	}
	return nil
}

func (x *DocumentTranslation) GetMimeType() string {
	if x != nil {
		return x.MimeType
	}
	return ""
}

func (x *DocumentTranslation) GetDetectedLanguageCode() string {
	if x != nil {
		return x.DetectedLanguageCode
	}
	return ""
}

// A translated document response message.
type TranslateDocumentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Translated document.
	DocumentTranslation *DocumentTranslation `protobuf:"bytes,1,opt,name=document_translation,json=documentTranslation,proto3" json:"document_translation,omitempty"`
	// The document's translation output if a glossary is provided in the request.
	// This can be the same as [TranslateDocumentResponse.document_translation]
	// if no glossary terms apply.
	GlossaryDocumentTranslation *DocumentTranslation `protobuf:"bytes,2,opt,name=glossary_document_translation,json=glossaryDocumentTranslation,proto3" json:"glossary_document_translation,omitempty"`
	// Only present when 'model' is present in the request.
	// 'model' is normalized to have a project number.
	//
	// For example:
	// If the 'model' field in TranslateDocumentRequest is:
	// `projects/{project-id}/locations/{location-id}/models/general/nmt` then
	// `model` here would be normalized to
	// `projects/{project-number}/locations/{location-id}/models/general/nmt`.
	Model string `protobuf:"bytes,3,opt,name=model,proto3" json:"model,omitempty"`
	// The `glossary_config` used for this translation.
	GlossaryConfig *TranslateTextGlossaryConfig `protobuf:"bytes,4,opt,name=glossary_config,json=glossaryConfig,proto3" json:"glossary_config,omitempty"`
}

func (x *TranslateDocumentResponse) Reset() {
	*x = TranslateDocumentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TranslateDocumentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TranslateDocumentResponse) ProtoMessage() {}

func (x *TranslateDocumentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TranslateDocumentResponse.ProtoReflect.Descriptor instead.
func (*TranslateDocumentResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_translation_service_proto_rawDescGZIP(), []int{18}
}

func (x *TranslateDocumentResponse) GetDocumentTranslation() *DocumentTranslation {
	if x != nil {
		return x.DocumentTranslation
	}
	return nil
}

func (x *TranslateDocumentResponse) GetGlossaryDocumentTranslation() *DocumentTranslation {
	if x != nil {
		return x.GlossaryDocumentTranslation
	}
	return nil
}

func (x *TranslateDocumentResponse) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

func (x *TranslateDocumentResponse) GetGlossaryConfig() *TranslateTextGlossaryConfig {
	if x != nil {
		return x.GlossaryConfig
	}
	return nil
}

// The batch translation request.
type BatchTranslateTextRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Location to make a call. Must refer to a caller's project.
	//
	// Format: `projects/{project-number-or-id}/locations/{location-id}`.
	//
	// The `global` location is not supported for batch translation.
	//
	// Only AutoML Translation models or glossaries within the same region (have
	// the same location-id) can be used, otherwise an INVALID_ARGUMENT (400)
	// error is returned.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Source language code.
	SourceLanguageCode string `protobuf:"bytes,2,opt,name=source_language_code,json=sourceLanguageCode,proto3" json:"source_language_code,omitempty"`
	// Required. Specify up to 10 language codes here.
	TargetLanguageCodes []string `protobuf:"bytes,3,rep,name=target_language_codes,json=targetLanguageCodes,proto3" json:"target_language_codes,omitempty"`
	// Optional. The models to use for translation. Map's key is target language
	// code. Map's value is model name. Value can be a built-in general model,
	// or an AutoML Translation model.
	//
	// The value format depends on model type:
	//
	// - AutoML Translation models:
	//   `projects/{project-number-or-id}/locations/{location-id}/models/{model-id}`
	//
	// - General (built-in) models:
	//   `projects/{project-number-or-id}/locations/{location-id}/models/general/nmt`,
	//
	//
	// If the map is empty or a specific model is
	// not requested for a language pair, then default google model (nmt) is used.
	Models map[string]string `protobuf:"bytes,4,rep,name=models,proto3" json:"models,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. Input configurations.
	// The total number of files matched should be <= 100.
	// The total content size should be <= 100M Unicode codepoints.
	// The files must use UTF-8 encoding.
	InputConfigs []*InputConfig `protobuf:"bytes,5,rep,name=input_configs,json=inputConfigs,proto3" json:"input_configs,omitempty"`
	// Required. Output configuration.
	// If 2 input configs match to the same file (that is, same input path),
	// we don't generate output for duplicate inputs.
	OutputConfig *OutputConfig `protobuf:"bytes,6,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
	// Optional. Glossaries to be applied for translation.
	// It's keyed by target language code.
	Glossaries map[string]*TranslateTextGlossaryConfig `protobuf:"bytes,7,rep,name=glossaries,proto3" json:"glossaries,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. The labels with user-defined metadata for the request.
	//
	// Label keys and values can be no longer than 63 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	// Label values are optional. Label keys must start with a letter.
	//
	// See https://cloud.google.com/translate/docs/advanced/labels for more
	// information.
	Labels map[string]string `protobuf:"bytes,9,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *BatchTranslateTextRequest) Reset() {
	*x = BatchTranslateTextRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchTranslateTextRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchTranslateTextRequest) ProtoMessage() {}

func (x *BatchTranslateTextRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchTranslateTextRequest.ProtoReflect.Descriptor instead.
func (*BatchTranslateTextRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_translation_service_proto_rawDescGZIP(), []int{19}
}

func (x *BatchTranslateTextRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchTranslateTextRequest) GetSourceLanguageCode() string {
	if x != nil {
		return x.SourceLanguageCode
	}
	return ""
}

func (x *BatchTranslateTextRequest) GetTargetLanguageCodes() []string {
	if x != nil {
		return x.TargetLanguageCodes
	}
	return nil
}

func (x *BatchTranslateTextRequest) GetModels() map[string]string {
	if x != nil {
		return x.Models
	}
	return nil
}

func (x *BatchTranslateTextRequest) GetInputConfigs() []*InputConfig {
	if x != nil {
		return x.InputConfigs
	}
	return nil
}

func (x *BatchTranslateTextRequest) GetOutputConfig() *OutputConfig {
	if x != nil {
		return x.OutputConfig
	}
	return nil
}

func (x *BatchTranslateTextRequest) GetGlossaries() map[string]*TranslateTextGlossaryConfig {
	if x != nil {
		return x.Glossaries
	}
	return nil
}

func (x *BatchTranslateTextRequest) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

// State metadata for the batch translation operation.
type BatchTranslateMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The state of the operation.
	State BatchTranslateMetadata_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.translation.v3.BatchTranslateMetadata_State" json:"state,omitempty"`
	// Number of successfully translated characters so far (Unicode codepoints).
	TranslatedCharacters int64 `protobuf:"varint,2,opt,name=translated_characters,json=translatedCharacters,proto3" json:"translated_characters,omitempty"`
	// Number of characters that have failed to process so far (Unicode
	// codepoints).
	FailedCharacters int64 `protobuf:"varint,3,opt,name=failed_characters,json=failedCharacters,proto3" json:"failed_characters,omitempty"`
	// Total number of characters (Unicode codepoints).
	// This is the total number of codepoints from input files times the number of
	// target languages and appears here shortly after the call is submitted.
	TotalCharacters int64 `protobuf:"varint,4,opt,name=total_characters,json=totalCharacters,proto3" json:"total_characters,omitempty"`
	// Time when the operation was submitted.
	SubmitTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=submit_time,json=submitTime,proto3" json:"submit_time,omitempty"`
}

func (x *BatchTranslateMetadata) Reset() {
	*x = BatchTranslateMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchTranslateMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchTranslateMetadata) ProtoMessage() {}

func (x *BatchTranslateMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchTranslateMetadata.ProtoReflect.Descriptor instead.
func (*BatchTranslateMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_translation_service_proto_rawDescGZIP(), []int{20}
}

func (x *BatchTranslateMetadata) GetState() BatchTranslateMetadata_State {
	if x != nil {
		return x.State
	}
	return BatchTranslateMetadata_STATE_UNSPECIFIED
}

func (x *BatchTranslateMetadata) GetTranslatedCharacters() int64 {
	if x != nil {
		return x.TranslatedCharacters
	}
	return 0
}

func (x *BatchTranslateMetadata) GetFailedCharacters() int64 {
	if x != nil {
		return x.FailedCharacters
	}
	return 0
}

func (x *BatchTranslateMetadata) GetTotalCharacters() int64 {
	if x != nil {
		return x.TotalCharacters
	}
	return 0
}

func (x *BatchTranslateMetadata) GetSubmitTime() *timestamppb.Timestamp {
	if x != nil {
		return x.SubmitTime
	}
	return nil
}

// Stored in the
// [google.longrunning.Operation.response][google.longrunning.Operation.response]
// field returned by BatchTranslateText if at least one sentence is translated
// successfully.
type BatchTranslateResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Total number of characters (Unicode codepoints).
	TotalCharacters int64 `protobuf:"varint,1,opt,name=total_characters,json=totalCharacters,proto3" json:"total_characters,omitempty"`
	// Number of successfully translated characters (Unicode codepoints).
	TranslatedCharacters int64 `protobuf:"varint,2,opt,name=translated_characters,json=translatedCharacters,proto3" json:"translated_characters,omitempty"`
	// Number of characters that have failed to process (Unicode codepoints).
	FailedCharacters int64 `protobuf:"varint,3,opt,name=failed_characters,json=failedCharacters,proto3" json:"failed_characters,omitempty"`
	// Time when the operation was submitted.
	SubmitTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=submit_time,json=submitTime,proto3" json:"submit_time,omitempty"`
	// The time when the operation is finished and
	// [google.longrunning.Operation.done][google.longrunning.Operation.done] is
	// set to true.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *BatchTranslateResponse) Reset() {
	*x = BatchTranslateResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchTranslateResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchTranslateResponse) ProtoMessage() {}

func (x *BatchTranslateResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchTranslateResponse.ProtoReflect.Descriptor instead.
func (*BatchTranslateResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_translation_service_proto_rawDescGZIP(), []int{21}
}

func (x *BatchTranslateResponse) GetTotalCharacters() int64 {
	if x != nil {
		return x.TotalCharacters
	}
	return 0
}

func (x *BatchTranslateResponse) GetTranslatedCharacters() int64 {
	if x != nil {
		return x.TranslatedCharacters
	}
	return 0
}

func (x *BatchTranslateResponse) GetFailedCharacters() int64 {
	if x != nil {
		return x.FailedCharacters
	}
	return 0
}

func (x *BatchTranslateResponse) GetSubmitTime() *timestamppb.Timestamp {
	if x != nil {
		return x.SubmitTime
	}
	return nil
}

func (x *BatchTranslateResponse) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

// Input configuration for glossaries.
type GlossaryInputConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Specify the input.
	//
	// Types that are assignable to Source:
	//	*GlossaryInputConfig_GcsSource
	Source isGlossaryInputConfig_Source `protobuf_oneof:"source"`
}

func (x *GlossaryInputConfig) Reset() {
	*x = GlossaryInputConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GlossaryInputConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GlossaryInputConfig) ProtoMessage() {}

func (x *GlossaryInputConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GlossaryInputConfig.ProtoReflect.Descriptor instead.
func (*GlossaryInputConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_translation_service_proto_rawDescGZIP(), []int{22}
}

func (m *GlossaryInputConfig) GetSource() isGlossaryInputConfig_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *GlossaryInputConfig) GetGcsSource() *GcsSource {
	if x, ok := x.GetSource().(*GlossaryInputConfig_GcsSource); ok {
		return x.GcsSource
	}
	return nil
}

type isGlossaryInputConfig_Source interface {
	isGlossaryInputConfig_Source()
}

type GlossaryInputConfig_GcsSource struct {
	// Required. Google Cloud Storage location of glossary data.
	// File format is determined based on the filename extension. API returns
	// [google.rpc.Code.INVALID_ARGUMENT] for unsupported URI-s and file
	// formats. Wildcards are not allowed. This must be a single file in one of
	// the following formats:
	//
	// For unidirectional glossaries:
	//
	// - TSV/CSV (`.tsv`/`.csv`): Two column file, tab- or comma-separated.
	//   The first column is source text. The second column is target text.
	//   No headers in this file. The first row contains data and not column
	//   names.
	//
	// - TMX (`.tmx`): TMX file with parallel data defining source/target term
	// pairs.
	//
	// For equivalent term sets glossaries:
	//
	// - CSV (`.csv`): Multi-column CSV file defining equivalent glossary terms
	//   in multiple languages. See documentation for more information -
	//   [glossaries](https://cloud.google.com/translate/docs/advanced/glossary).
	GcsSource *GcsSource `protobuf:"bytes,1,opt,name=gcs_source,json=gcsSource,proto3,oneof"`
}

func (*GlossaryInputConfig_GcsSource) isGlossaryInputConfig_Source() {}

// Represents a glossary built from user-provided data.
type Glossary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the glossary. Glossary names have the form
	// `projects/{project-number-or-id}/locations/{location-id}/glossaries/{glossary-id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Languages supported by the glossary.
	//
	// Types that are assignable to Languages:
	//	*Glossary_LanguagePair
	//	*Glossary_LanguageCodesSet_
	Languages isGlossary_Languages `protobuf_oneof:"languages"`
	// Required. Provides examples to build the glossary from.
	// Total glossary must not exceed 10M Unicode codepoints.
	InputConfig *GlossaryInputConfig `protobuf:"bytes,5,opt,name=input_config,json=inputConfig,proto3" json:"input_config,omitempty"`
	// Output only. The number of entries defined in the glossary.
	EntryCount int32 `protobuf:"varint,6,opt,name=entry_count,json=entryCount,proto3" json:"entry_count,omitempty"`
	// Output only. When CreateGlossary was called.
	SubmitTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=submit_time,json=submitTime,proto3" json:"submit_time,omitempty"`
	// Output only. When the glossary creation was finished.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Optional. The display name of the glossary.
	DisplayName string `protobuf:"bytes,9,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
}

func (x *Glossary) Reset() {
	*x = Glossary{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Glossary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Glossary) ProtoMessage() {}

func (x *Glossary) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Glossary.ProtoReflect.Descriptor instead.
func (*Glossary) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_translation_service_proto_rawDescGZIP(), []int{23}
}

func (x *Glossary) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (m *Glossary) GetLanguages() isGlossary_Languages {
	if m != nil {
		return m.Languages
	}
	return nil
}

func (x *Glossary) GetLanguagePair() *Glossary_LanguageCodePair {
	if x, ok := x.GetLanguages().(*Glossary_LanguagePair); ok {
		return x.LanguagePair
	}
	return nil
}

func (x *Glossary) GetLanguageCodesSet() *Glossary_LanguageCodesSet {
	if x, ok := x.GetLanguages().(*Glossary_LanguageCodesSet_); ok {
		return x.LanguageCodesSet
	}
	return nil
}

func (x *Glossary) GetInputConfig() *GlossaryInputConfig {
	if x != nil {
		return x.InputConfig
	}
	return nil
}

func (x *Glossary) GetEntryCount() int32 {
	if x != nil {
		return x.EntryCount
	}
	return 0
}

func (x *Glossary) GetSubmitTime() *timestamppb.Timestamp {
	if x != nil {
		return x.SubmitTime
	}
	return nil
}

func (x *Glossary) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *Glossary) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

type isGlossary_Languages interface {
	isGlossary_Languages()
}

type Glossary_LanguagePair struct {
	// Used with unidirectional glossaries.
	LanguagePair *Glossary_LanguageCodePair `protobuf:"bytes,3,opt,name=language_pair,json=languagePair,proto3,oneof"`
}

type Glossary_LanguageCodesSet_ struct {
	// Used with equivalent term set glossaries.
	LanguageCodesSet *Glossary_LanguageCodesSet `protobuf:"bytes,4,opt,name=language_codes_set,json=languageCodesSet,proto3,oneof"`
}

func (*Glossary_LanguagePair) isGlossary_Languages() {}

func (*Glossary_LanguageCodesSet_) isGlossary_Languages() {}

// Request message for CreateGlossary.
type CreateGlossaryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project name.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The glossary to create.
	Glossary *Glossary `protobuf:"bytes,2,opt,name=glossary,proto3" json:"glossary,omitempty"`
}

func (x *CreateGlossaryRequest) Reset() {
	*x = CreateGlossaryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateGlossaryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateGlossaryRequest) ProtoMessage() {}

func (x *CreateGlossaryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateGlossaryRequest.ProtoReflect.Descriptor instead.
func (*CreateGlossaryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_translation_service_proto_rawDescGZIP(), []int{24}
}

func (x *CreateGlossaryRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateGlossaryRequest) GetGlossary() *Glossary {
	if x != nil {
		return x.Glossary
	}
	return nil
}

// Request message for GetGlossary.
type GetGlossaryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the glossary to retrieve.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetGlossaryRequest) Reset() {
	*x = GetGlossaryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetGlossaryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGlossaryRequest) ProtoMessage() {}

func (x *GetGlossaryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGlossaryRequest.ProtoReflect.Descriptor instead.
func (*GetGlossaryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_translation_service_proto_rawDescGZIP(), []int{25}
}

func (x *GetGlossaryRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for DeleteGlossary.
type DeleteGlossaryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the glossary to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteGlossaryRequest) Reset() {
	*x = DeleteGlossaryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteGlossaryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteGlossaryRequest) ProtoMessage() {}

func (x *DeleteGlossaryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteGlossaryRequest.ProtoReflect.Descriptor instead.
func (*DeleteGlossaryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_translation_service_proto_rawDescGZIP(), []int{26}
}

func (x *DeleteGlossaryRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListGlossaries.
type ListGlossariesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the project from which to list all of the glossaries.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Requested page size. The server may return fewer glossaries than
	// requested. If unspecified, the server picks an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results the server should return.
	// Typically, this is the value of [ListGlossariesResponse.next_page_token]
	// returned from the previous call to `ListGlossaries` method.
	// The first page is returned if `page_token`is empty or missing.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filter specifying constraints of a list operation.
	// Specify the constraint by the format of "key=value", where key must be
	// "src" or "tgt", and the value must be a valid language code.
	// For multiple restrictions, concatenate them by "AND" (uppercase only),
	// such as: "src=en-US AND tgt=zh-CN". Notice that the exact match is used
	// here, which means using 'en-US' and 'en' can lead to different results,
	// which depends on the language code you used when you create the glossary.
	// For the unidirectional glossaries, the "src" and "tgt" add restrictions
	// on the source and target language code separately.
	// For the equivalent term set glossaries, the "src" and/or "tgt" add
	// restrictions on the term set.
	// For example: "src=en-US AND tgt=zh-CN" will only pick the unidirectional
	// glossaries which exactly match the source language code as "en-US" and the
	// target language code "zh-CN", but all equivalent term set glossaries which
	// contain "en-US" and "zh-CN" in their language set will be picked.
	// If missing, no filtering is performed.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListGlossariesRequest) Reset() {
	*x = ListGlossariesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListGlossariesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGlossariesRequest) ProtoMessage() {}

func (x *ListGlossariesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGlossariesRequest.ProtoReflect.Descriptor instead.
func (*ListGlossariesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_translation_service_proto_rawDescGZIP(), []int{27}
}

func (x *ListGlossariesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListGlossariesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListGlossariesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListGlossariesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Response message for ListGlossaries.
type ListGlossariesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of glossaries for a project.
	Glossaries []*Glossary `protobuf:"bytes,1,rep,name=glossaries,proto3" json:"glossaries,omitempty"`
	// A token to retrieve a page of results. Pass this value in the
	// [ListGlossariesRequest.page_token] field in the subsequent call to
	// `ListGlossaries` method to retrieve the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListGlossariesResponse) Reset() {
	*x = ListGlossariesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListGlossariesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGlossariesResponse) ProtoMessage() {}

func (x *ListGlossariesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGlossariesResponse.ProtoReflect.Descriptor instead.
func (*ListGlossariesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_translation_service_proto_rawDescGZIP(), []int{28}
}

func (x *ListGlossariesResponse) GetGlossaries() []*Glossary {
	if x != nil {
		return x.Glossaries
	}
	return nil
}

func (x *ListGlossariesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Stored in the
// [google.longrunning.Operation.metadata][google.longrunning.Operation.metadata]
// field returned by CreateGlossary.
type CreateGlossaryMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the glossary that is being created.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The current state of the glossary creation operation.
	State CreateGlossaryMetadata_State `protobuf:"varint,2,opt,name=state,proto3,enum=google.cloud.translation.v3.CreateGlossaryMetadata_State" json:"state,omitempty"`
	// The time when the operation was submitted to the server.
	SubmitTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=submit_time,json=submitTime,proto3" json:"submit_time,omitempty"`
}

func (x *CreateGlossaryMetadata) Reset() {
	*x = CreateGlossaryMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateGlossaryMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateGlossaryMetadata) ProtoMessage() {}

func (x *CreateGlossaryMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateGlossaryMetadata.ProtoReflect.Descriptor instead.
func (*CreateGlossaryMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_translation_service_proto_rawDescGZIP(), []int{29}
}

func (x *CreateGlossaryMetadata) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CreateGlossaryMetadata) GetState() CreateGlossaryMetadata_State {
	if x != nil {
		return x.State
	}
	return CreateGlossaryMetadata_STATE_UNSPECIFIED
}

func (x *CreateGlossaryMetadata) GetSubmitTime() *timestamppb.Timestamp {
	if x != nil {
		return x.SubmitTime
	}
	return nil
}

// Stored in the
// [google.longrunning.Operation.metadata][google.longrunning.Operation.metadata]
// field returned by DeleteGlossary.
type DeleteGlossaryMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the glossary that is being deleted.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The current state of the glossary deletion operation.
	State DeleteGlossaryMetadata_State `protobuf:"varint,2,opt,name=state,proto3,enum=google.cloud.translation.v3.DeleteGlossaryMetadata_State" json:"state,omitempty"`
	// The time when the operation was submitted to the server.
	SubmitTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=submit_time,json=submitTime,proto3" json:"submit_time,omitempty"`
}

func (x *DeleteGlossaryMetadata) Reset() {
	*x = DeleteGlossaryMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteGlossaryMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteGlossaryMetadata) ProtoMessage() {}

func (x *DeleteGlossaryMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteGlossaryMetadata.ProtoReflect.Descriptor instead.
func (*DeleteGlossaryMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_translation_service_proto_rawDescGZIP(), []int{30}
}

func (x *DeleteGlossaryMetadata) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteGlossaryMetadata) GetState() DeleteGlossaryMetadata_State {
	if x != nil {
		return x.State
	}
	return DeleteGlossaryMetadata_STATE_UNSPECIFIED
}

func (x *DeleteGlossaryMetadata) GetSubmitTime() *timestamppb.Timestamp {
	if x != nil {
		return x.SubmitTime
	}
	return nil
}

// Stored in the
// [google.longrunning.Operation.response][google.longrunning.Operation.response]
// field returned by DeleteGlossary.
type DeleteGlossaryResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the deleted glossary.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The time when the operation was submitted to the server.
	SubmitTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=submit_time,json=submitTime,proto3" json:"submit_time,omitempty"`
	// The time when the glossary deletion is finished and
	// [google.longrunning.Operation.done][google.longrunning.Operation.done] is
	// set to true.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *DeleteGlossaryResponse) Reset() {
	*x = DeleteGlossaryResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteGlossaryResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteGlossaryResponse) ProtoMessage() {}

func (x *DeleteGlossaryResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteGlossaryResponse.ProtoReflect.Descriptor instead.
func (*DeleteGlossaryResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_translation_service_proto_rawDescGZIP(), []int{31}
}

func (x *DeleteGlossaryResponse) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteGlossaryResponse) GetSubmitTime() *timestamppb.Timestamp {
	if x != nil {
		return x.SubmitTime
	}
	return nil
}

func (x *DeleteGlossaryResponse) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

// The BatchTranslateDocument request.
type BatchTranslateDocumentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Location to make a regional call.
	//
	// Format: `projects/{project-number-or-id}/locations/{location-id}`.
	//
	// The `global` location is not supported for batch translation.
	//
	// Only AutoML Translation models or glossaries within the same region (have
	// the same location-id) can be used, otherwise an INVALID_ARGUMENT (400)
	// error is returned.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ISO-639 language code of the input document if known, for
	// example, "en-US" or "sr-Latn". Supported language codes are listed in
	// [Language Support](https://cloud.google.com/translate/docs/languages).
	SourceLanguageCode string `protobuf:"bytes,2,opt,name=source_language_code,json=sourceLanguageCode,proto3" json:"source_language_code,omitempty"`
	// Required. The ISO-639 language code to use for translation of the input
	// document. Specify up to 10 language codes here.
	TargetLanguageCodes []string `protobuf:"bytes,3,rep,name=target_language_codes,json=targetLanguageCodes,proto3" json:"target_language_codes,omitempty"`
	// Required. Input configurations.
	// The total number of files matched should be <= 100.
	// The total content size to translate should be <= 100M Unicode codepoints.
	// The files must use UTF-8 encoding.
	InputConfigs []*BatchDocumentInputConfig `protobuf:"bytes,4,rep,name=input_configs,json=inputConfigs,proto3" json:"input_configs,omitempty"`
	// Required. Output configuration.
	// If 2 input configs match to the same file (that is, same input path),
	// we don't generate output for duplicate inputs.
	OutputConfig *BatchDocumentOutputConfig `protobuf:"bytes,5,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
	// Optional. The models to use for translation. Map's key is target language
	// code. Map's value is the model name. Value can be a built-in general model,
	// or an AutoML Translation model.
	//
	// The value format depends on model type:
	//
	// - AutoML Translation models:
	//   `projects/{project-number-or-id}/locations/{location-id}/models/{model-id}`
	//
	// - General (built-in) models:
	//   `projects/{project-number-or-id}/locations/{location-id}/models/general/nmt`,
	//
	//
	// If the map is empty or a specific model is
	// not requested for a language pair, then default google model (nmt) is used.
	Models map[string]string `protobuf:"bytes,6,rep,name=models,proto3" json:"models,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Glossaries to be applied. It's keyed by target language code.
	Glossaries map[string]*TranslateTextGlossaryConfig `protobuf:"bytes,7,rep,name=glossaries,proto3" json:"glossaries,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. The file format conversion map that is applied to all input
	// files. The map key is the original mime_type. The map value is the target
	// mime_type of translated documents.
	//
	// Supported file format conversion includes:
	// - `application/pdf` to
	//   `application/vnd.openxmlformats-officedocument.wordprocessingml.document`
	//
	// If nothing specified, output files will be in the same format as the
	// original file.
	FormatConversions map[string]string `protobuf:"bytes,8,rep,name=format_conversions,json=formatConversions,proto3" json:"format_conversions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. This flag is to support user customized attribution.
	// If not provided, the default is `Machine Translated by Google`.
	// Customized attribution should follow rules in
	// https://cloud.google.com/translate/attribution#attribution_and_logos
	CustomizedAttribution string `protobuf:"bytes,10,opt,name=customized_attribution,json=customizedAttribution,proto3" json:"customized_attribution,omitempty"`
	// Optional. If true, use the text removal server to remove the shadow text on
	// background image for native pdf translation.
	// Shadow removal feature can only be enabled when
	// is_translate_native_pdf_only: false && pdf_native_only: false
	EnableShadowRemovalNativePdf bool `protobuf:"varint,11,opt,name=enable_shadow_removal_native_pdf,json=enableShadowRemovalNativePdf,proto3" json:"enable_shadow_removal_native_pdf,omitempty"`
	// Optional. If true, enable auto rotation correction in DVS.
	EnableRotationCorrection bool `protobuf:"varint,12,opt,name=enable_rotation_correction,json=enableRotationCorrection,proto3" json:"enable_rotation_correction,omitempty"`
}

func (x *BatchTranslateDocumentRequest) Reset() {
	*x = BatchTranslateDocumentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchTranslateDocumentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchTranslateDocumentRequest) ProtoMessage() {}

func (x *BatchTranslateDocumentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchTranslateDocumentRequest.ProtoReflect.Descriptor instead.
func (*BatchTranslateDocumentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_translation_service_proto_rawDescGZIP(), []int{32}
}

func (x *BatchTranslateDocumentRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchTranslateDocumentRequest) GetSourceLanguageCode() string {
	if x != nil {
		return x.SourceLanguageCode
	}
	return ""
}

func (x *BatchTranslateDocumentRequest) GetTargetLanguageCodes() []string {
	if x != nil {
		return x.TargetLanguageCodes
	}
	return nil
}

func (x *BatchTranslateDocumentRequest) GetInputConfigs() []*BatchDocumentInputConfig {
	if x != nil {
		return x.InputConfigs
	}
	return nil
}

func (x *BatchTranslateDocumentRequest) GetOutputConfig() *BatchDocumentOutputConfig {
	if x != nil {
		return x.OutputConfig
	}
	return nil
}

func (x *BatchTranslateDocumentRequest) GetModels() map[string]string {
	if x != nil {
		return x.Models
	}
	return nil
}

func (x *BatchTranslateDocumentRequest) GetGlossaries() map[string]*TranslateTextGlossaryConfig {
	if x != nil {
		return x.Glossaries
	}
	return nil
}

func (x *BatchTranslateDocumentRequest) GetFormatConversions() map[string]string {
	if x != nil {
		return x.FormatConversions
	}
	return nil
}

func (x *BatchTranslateDocumentRequest) GetCustomizedAttribution() string {
	if x != nil {
		return x.CustomizedAttribution
	}
	return ""
}

func (x *BatchTranslateDocumentRequest) GetEnableShadowRemovalNativePdf() bool {
	if x != nil {
		return x.EnableShadowRemovalNativePdf
	}
	return false
}

func (x *BatchTranslateDocumentRequest) GetEnableRotationCorrection() bool {
	if x != nil {
		return x.EnableRotationCorrection
	}
	return false
}

// Input configuration for BatchTranslateDocument request.
type BatchDocumentInputConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specify the input.
	//
	// Types that are assignable to Source:
	//	*BatchDocumentInputConfig_GcsSource
	Source isBatchDocumentInputConfig_Source `protobuf_oneof:"source"`
}

func (x *BatchDocumentInputConfig) Reset() {
	*x = BatchDocumentInputConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchDocumentInputConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchDocumentInputConfig) ProtoMessage() {}

func (x *BatchDocumentInputConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchDocumentInputConfig.ProtoReflect.Descriptor instead.
func (*BatchDocumentInputConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_translation_service_proto_rawDescGZIP(), []int{33}
}

func (m *BatchDocumentInputConfig) GetSource() isBatchDocumentInputConfig_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *BatchDocumentInputConfig) GetGcsSource() *GcsSource {
	if x, ok := x.GetSource().(*BatchDocumentInputConfig_GcsSource); ok {
		return x.GcsSource
	}
	return nil
}

type isBatchDocumentInputConfig_Source interface {
	isBatchDocumentInputConfig_Source()
}

type BatchDocumentInputConfig_GcsSource struct {
	// Google Cloud Storage location for the source input.
	// This can be a single file (for example,
	// `gs://translation-test/input.docx`) or a wildcard (for example,
	// `gs://translation-test/*`).
	//
	// File mime type is determined based on extension. Supported mime type
	// includes:
	// - `pdf`, application/pdf
	// - `docx`,
	// application/vnd.openxmlformats-officedocument.wordprocessingml.document
	// - `pptx`,
	// application/vnd.openxmlformats-officedocument.presentationml.presentation
	// - `xlsx`,
	// application/vnd.openxmlformats-officedocument.spreadsheetml.sheet
	//
	// The max file size to support for `.docx`, `.pptx` and `.xlsx` is 100MB.
	// The max file size to support for `.pdf` is 1GB and the max page limit is
	// 1000 pages.
	// The max file size to support for all input documents is 1GB.
	GcsSource *GcsSource `protobuf:"bytes,1,opt,name=gcs_source,json=gcsSource,proto3,oneof"`
}

func (*BatchDocumentInputConfig_GcsSource) isBatchDocumentInputConfig_Source() {}

// Output configuration for BatchTranslateDocument request.
type BatchDocumentOutputConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The destination of output. The destination directory provided must exist
	// and be empty.
	//
	// Types that are assignable to Destination:
	//	*BatchDocumentOutputConfig_GcsDestination
	Destination isBatchDocumentOutputConfig_Destination `protobuf_oneof:"destination"`
}

func (x *BatchDocumentOutputConfig) Reset() {
	*x = BatchDocumentOutputConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchDocumentOutputConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchDocumentOutputConfig) ProtoMessage() {}

func (x *BatchDocumentOutputConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchDocumentOutputConfig.ProtoReflect.Descriptor instead.
func (*BatchDocumentOutputConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_translation_service_proto_rawDescGZIP(), []int{34}
}

func (m *BatchDocumentOutputConfig) GetDestination() isBatchDocumentOutputConfig_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *BatchDocumentOutputConfig) GetGcsDestination() *GcsDestination {
	if x, ok := x.GetDestination().(*BatchDocumentOutputConfig_GcsDestination); ok {
		return x.GcsDestination
	}
	return nil
}

type isBatchDocumentOutputConfig_Destination interface {
	isBatchDocumentOutputConfig_Destination()
}

type BatchDocumentOutputConfig_GcsDestination struct {
	// Google Cloud Storage destination for output content.
	// For every single input document (for example, gs://a/b/c.[extension]), we
	// generate at most 2 * n output files. (n is the # of target_language_codes
	// in the BatchTranslateDocumentRequest).
	//
	// While the input documents are being processed, we write/update an index
	// file `index.csv` under `gcs_destination.output_uri_prefix` (for example,
	// gs://translation_output/index.csv) The index file is generated/updated as
	// new files are being translated. The format is:
	//
	// input_document,target_language_code,translation_output,error_output,
	// glossary_translation_output,glossary_error_output
	//
	// `input_document` is one file we matched using gcs_source.input_uri.
	// `target_language_code` is provided in the request.
	// `translation_output` contains the translations. (details provided below)
	// `error_output` contains the error message during processing of the file.
	// Both translations_file and errors_file could be empty strings if we have
	// no content to output.
	// `glossary_translation_output` and `glossary_error_output` are the
	// translated output/error when we apply glossaries. They could also be
	// empty if we have no content to output.
	//
	// Once a row is present in index.csv, the input/output matching never
	// changes. Callers should also expect all the content in input_file are
	// processed and ready to be consumed (that is, no partial output file is
	// written).
	//
	// Since index.csv will be keeping updated during the process, please make
	// sure there is no custom retention policy applied on the output bucket
	// that may avoid file updating.
	// (https://cloud.google.com/storage/docs/bucket-lock#retention-policy)
	//
	// The naming format of translation output files follows (for target
	// language code [trg]): `translation_output`:
	// `gs://translation_output/a_b_c_[trg]_translation.[extension]`
	// `glossary_translation_output`:
	// `gs://translation_test/a_b_c_[trg]_glossary_translation.[extension]`. The
	// output document will maintain the same file format as the input document.
	//
	// The naming format of error output files follows (for target language code
	// [trg]): `error_output`: `gs://translation_test/a_b_c_[trg]_errors.txt`
	// `glossary_error_output`:
	// `gs://translation_test/a_b_c_[trg]_glossary_translation.txt`. The error
	// output is a txt file containing error details.
	GcsDestination *GcsDestination `protobuf:"bytes,1,opt,name=gcs_destination,json=gcsDestination,proto3,oneof"`
}

func (*BatchDocumentOutputConfig_GcsDestination) isBatchDocumentOutputConfig_Destination() {}

// Stored in the
// [google.longrunning.Operation.response][google.longrunning.Operation.response]
// field returned by BatchTranslateDocument if at least one document is
// translated successfully.
type BatchTranslateDocumentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Total number of pages to translate in all documents. Documents without
	// clear page definition (such as XLSX) are not counted.
	TotalPages int64 `protobuf:"varint,1,opt,name=total_pages,json=totalPages,proto3" json:"total_pages,omitempty"`
	// Number of successfully translated pages in all documents. Documents without
	// clear page definition (such as XLSX) are not counted.
	TranslatedPages int64 `protobuf:"varint,2,opt,name=translated_pages,json=translatedPages,proto3" json:"translated_pages,omitempty"`
	// Number of pages that failed to process in all documents. Documents without
	// clear page definition (such as XLSX) are not counted.
	FailedPages int64 `protobuf:"varint,3,opt,name=failed_pages,json=failedPages,proto3" json:"failed_pages,omitempty"`
	// Number of billable pages in documents with clear page definition (such as
	// PDF, DOCX, PPTX)
	TotalBillablePages int64 `protobuf:"varint,4,opt,name=total_billable_pages,json=totalBillablePages,proto3" json:"total_billable_pages,omitempty"`
	// Total number of characters (Unicode codepoints) in all documents.
	TotalCharacters int64 `protobuf:"varint,5,opt,name=total_characters,json=totalCharacters,proto3" json:"total_characters,omitempty"`
	// Number of successfully translated characters (Unicode codepoints) in all
	// documents.
	TranslatedCharacters int64 `protobuf:"varint,6,opt,name=translated_characters,json=translatedCharacters,proto3" json:"translated_characters,omitempty"`
	// Number of characters that have failed to process (Unicode codepoints) in
	// all documents.
	FailedCharacters int64 `protobuf:"varint,7,opt,name=failed_characters,json=failedCharacters,proto3" json:"failed_characters,omitempty"`
	// Number of billable characters (Unicode codepoints) in documents without
	// clear page definition, such as XLSX.
	TotalBillableCharacters int64 `protobuf:"varint,8,opt,name=total_billable_characters,json=totalBillableCharacters,proto3" json:"total_billable_characters,omitempty"`
	// Time when the operation was submitted.
	SubmitTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=submit_time,json=submitTime,proto3" json:"submit_time,omitempty"`
	// The time when the operation is finished and
	// [google.longrunning.Operation.done][google.longrunning.Operation.done] is
	// set to true.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *BatchTranslateDocumentResponse) Reset() {
	*x = BatchTranslateDocumentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchTranslateDocumentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchTranslateDocumentResponse) ProtoMessage() {}

func (x *BatchTranslateDocumentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchTranslateDocumentResponse.ProtoReflect.Descriptor instead.
func (*BatchTranslateDocumentResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_translation_service_proto_rawDescGZIP(), []int{35}
}

func (x *BatchTranslateDocumentResponse) GetTotalPages() int64 {
	if x != nil {
		return x.TotalPages
	}
	return 0
}

func (x *BatchTranslateDocumentResponse) GetTranslatedPages() int64 {
	if x != nil {
		return x.TranslatedPages
	}
	return 0
}

func (x *BatchTranslateDocumentResponse) GetFailedPages() int64 {
	if x != nil {
		return x.FailedPages
	}
	return 0
}

func (x *BatchTranslateDocumentResponse) GetTotalBillablePages() int64 {
	if x != nil {
		return x.TotalBillablePages
	}
	return 0
}

func (x *BatchTranslateDocumentResponse) GetTotalCharacters() int64 {
	if x != nil {
		return x.TotalCharacters
	}
	return 0
}

func (x *BatchTranslateDocumentResponse) GetTranslatedCharacters() int64 {
	if x != nil {
		return x.TranslatedCharacters
	}
	return 0
}

func (x *BatchTranslateDocumentResponse) GetFailedCharacters() int64 {
	if x != nil {
		return x.FailedCharacters
	}
	return 0
}

func (x *BatchTranslateDocumentResponse) GetTotalBillableCharacters() int64 {
	if x != nil {
		return x.TotalBillableCharacters
	}
	return 0
}

func (x *BatchTranslateDocumentResponse) GetSubmitTime() *timestamppb.Timestamp {
	if x != nil {
		return x.SubmitTime
	}
	return nil
}

func (x *BatchTranslateDocumentResponse) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

// State metadata for the batch translation operation.
type BatchTranslateDocumentMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The state of the operation.
	State BatchTranslateDocumentMetadata_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.translation.v3.BatchTranslateDocumentMetadata_State" json:"state,omitempty"`
	// Total number of pages to translate in all documents so far. Documents
	// without clear page definition (such as XLSX) are not counted.
	TotalPages int64 `protobuf:"varint,2,opt,name=total_pages,json=totalPages,proto3" json:"total_pages,omitempty"`
	// Number of successfully translated pages in all documents so far. Documents
	// without clear page definition (such as XLSX) are not counted.
	TranslatedPages int64 `protobuf:"varint,3,opt,name=translated_pages,json=translatedPages,proto3" json:"translated_pages,omitempty"`
	// Number of pages that failed to process in all documents so far. Documents
	// without clear page definition (such as XLSX) are not counted.
	FailedPages int64 `protobuf:"varint,4,opt,name=failed_pages,json=failedPages,proto3" json:"failed_pages,omitempty"`
	// Number of billable pages in documents with clear page definition (such as
	// PDF, DOCX, PPTX) so far.
	TotalBillablePages int64 `protobuf:"varint,5,opt,name=total_billable_pages,json=totalBillablePages,proto3" json:"total_billable_pages,omitempty"`
	// Total number of characters (Unicode codepoints) in all documents so far.
	TotalCharacters int64 `protobuf:"varint,6,opt,name=total_characters,json=totalCharacters,proto3" json:"total_characters,omitempty"`
	// Number of successfully translated characters (Unicode codepoints) in all
	// documents so far.
	TranslatedCharacters int64 `protobuf:"varint,7,opt,name=translated_characters,json=translatedCharacters,proto3" json:"translated_characters,omitempty"`
	// Number of characters that have failed to process (Unicode codepoints) in
	// all documents so far.
	FailedCharacters int64 `protobuf:"varint,8,opt,name=failed_characters,json=failedCharacters,proto3" json:"failed_characters,omitempty"`
	// Number of billable characters (Unicode codepoints) in documents without
	// clear page definition (such as XLSX) so far.
	TotalBillableCharacters int64 `protobuf:"varint,9,opt,name=total_billable_characters,json=totalBillableCharacters,proto3" json:"total_billable_characters,omitempty"`
	// Time when the operation was submitted.
	SubmitTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=submit_time,json=submitTime,proto3" json:"submit_time,omitempty"`
}

func (x *BatchTranslateDocumentMetadata) Reset() {
	*x = BatchTranslateDocumentMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchTranslateDocumentMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchTranslateDocumentMetadata) ProtoMessage() {}

func (x *BatchTranslateDocumentMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchTranslateDocumentMetadata.ProtoReflect.Descriptor instead.
func (*BatchTranslateDocumentMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_translation_service_proto_rawDescGZIP(), []int{36}
}

func (x *BatchTranslateDocumentMetadata) GetState() BatchTranslateDocumentMetadata_State {
	if x != nil {
		return x.State
	}
	return BatchTranslateDocumentMetadata_STATE_UNSPECIFIED
}

func (x *BatchTranslateDocumentMetadata) GetTotalPages() int64 {
	if x != nil {
		return x.TotalPages
	}
	return 0
}

func (x *BatchTranslateDocumentMetadata) GetTranslatedPages() int64 {
	if x != nil {
		return x.TranslatedPages
	}
	return 0
}

func (x *BatchTranslateDocumentMetadata) GetFailedPages() int64 {
	if x != nil {
		return x.FailedPages
	}
	return 0
}

func (x *BatchTranslateDocumentMetadata) GetTotalBillablePages() int64 {
	if x != nil {
		return x.TotalBillablePages
	}
	return 0
}

func (x *BatchTranslateDocumentMetadata) GetTotalCharacters() int64 {
	if x != nil {
		return x.TotalCharacters
	}
	return 0
}

func (x *BatchTranslateDocumentMetadata) GetTranslatedCharacters() int64 {
	if x != nil {
		return x.TranslatedCharacters
	}
	return 0
}

func (x *BatchTranslateDocumentMetadata) GetFailedCharacters() int64 {
	if x != nil {
		return x.FailedCharacters
	}
	return 0
}

func (x *BatchTranslateDocumentMetadata) GetTotalBillableCharacters() int64 {
	if x != nil {
		return x.TotalBillableCharacters
	}
	return 0
}

func (x *BatchTranslateDocumentMetadata) GetSubmitTime() *timestamppb.Timestamp {
	if x != nil {
		return x.SubmitTime
	}
	return nil
}

// Used with unidirectional glossaries.
type Glossary_LanguageCodePair struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ISO-639 language code of the input text, for example,
	// "en-US". Expected to be an exact match for GlossaryTerm.language_code.
	SourceLanguageCode string `protobuf:"bytes,1,opt,name=source_language_code,json=sourceLanguageCode,proto3" json:"source_language_code,omitempty"`
	// Required. The ISO-639 language code for translation output, for example,
	// "zh-CN". Expected to be an exact match for GlossaryTerm.language_code.
	TargetLanguageCode string `protobuf:"bytes,2,opt,name=target_language_code,json=targetLanguageCode,proto3" json:"target_language_code,omitempty"`
}

func (x *Glossary_LanguageCodePair) Reset() {
	*x = Glossary_LanguageCodePair{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Glossary_LanguageCodePair) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Glossary_LanguageCodePair) ProtoMessage() {}

func (x *Glossary_LanguageCodePair) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Glossary_LanguageCodePair.ProtoReflect.Descriptor instead.
func (*Glossary_LanguageCodePair) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_translation_service_proto_rawDescGZIP(), []int{23, 0}
}

func (x *Glossary_LanguageCodePair) GetSourceLanguageCode() string {
	if x != nil {
		return x.SourceLanguageCode
	}
	return ""
}

func (x *Glossary_LanguageCodePair) GetTargetLanguageCode() string {
	if x != nil {
		return x.TargetLanguageCode
	}
	return ""
}

// Used with equivalent term set glossaries.
type Glossary_LanguageCodesSet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ISO-639 language code(s) for terms defined in the glossary.
	// All entries are unique. The list contains at least two entries.
	// Expected to be an exact match for GlossaryTerm.language_code.
	LanguageCodes []string `protobuf:"bytes,1,rep,name=language_codes,json=languageCodes,proto3" json:"language_codes,omitempty"`
}

func (x *Glossary_LanguageCodesSet) Reset() {
	*x = Glossary_LanguageCodesSet{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Glossary_LanguageCodesSet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Glossary_LanguageCodesSet) ProtoMessage() {}

func (x *Glossary_LanguageCodesSet) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_translation_service_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Glossary_LanguageCodesSet.ProtoReflect.Descriptor instead.
func (*Glossary_LanguageCodesSet) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_translation_service_proto_rawDescGZIP(), []int{23, 1}
}

func (x *Glossary_LanguageCodesSet) GetLanguageCodes() []string {
	if x != nil {
		return x.LanguageCodes
	}
	return nil
}

var File_google_cloud_translate_v3_translation_service_proto protoreflect.FileDescriptor

var file_google_cloud_translate_v3_translation_service_proto_rawDesc = []byte{
	0x0a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x2f, 0x76, 0x33, 0x2f, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x33, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61,
	0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x2f, 0x76, 0x33,
	0x2f, 0x61, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x6d, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x64, 0x0a, 0x1b, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61,
	0x74, 0x65, 0x54, 0x65, 0x78, 0x74, 0x47, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x1f, 0x0a, 0x08, 0x67, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x67, 0x6c, 0x6f,
	0x73, 0x73, 0x61, 0x72, 0x79, 0x12, 0x24, 0x0a, 0x0b, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x5f,
	0x63, 0x61, 0x73, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0a, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x43, 0x61, 0x73, 0x65, 0x22, 0xa4, 0x04, 0x0a, 0x14,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x54, 0x65, 0x78, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x1f, 0x0a, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x20, 0x0a, 0x09, 0x6d, 0x69, 0x6d, 0x65, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x6d,
	0x69, 0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x35, 0x0a, 0x14, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x35,
	0x0a, 0x14, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x12, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x19, 0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x12, 0x66, 0x0a, 0x0f, 0x67, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x6c, 0x61, 0x74, 0x65, 0x54, 0x65, 0x78, 0x74, 0x47, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x67, 0x6c, 0x6f,
	0x73, 0x73, 0x61, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5a, 0x0a, 0x06, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c,
	0x61, 0x74, 0x65, 0x54, 0x65, 0x78, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x22, 0xc4, 0x01, 0x0a, 0x15, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65,
	0x54, 0x65, 0x78, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4c, 0x0a, 0x0c,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x5d, 0x0a, 0x15, 0x67, 0x6c,
	0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x14, 0x67, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xe5, 0x01, 0x0a, 0x0b, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x27, 0x0a, 0x0f, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x54, 0x65,
	0x78, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x34, 0x0a, 0x16, 0x64, 0x65, 0x74, 0x65,
	0x63, 0x74, 0x65, 0x64, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f,
	0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74,
	0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x61,
	0x0a, 0x0f, 0x67, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x54,
	0x65, 0x78, 0x74, 0x47, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x0e, 0x67, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x22, 0xd5, 0x02, 0x0a, 0x15, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x4c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x19,
	0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x1a, 0x0a, 0x07, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x07, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x6d, 0x69, 0x6d, 0x65, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x6d,
	0x69, 0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x5b, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x4c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x42,
	0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x57, 0x0a, 0x10, 0x44, 0x65, 0x74,
	0x65, 0x63, 0x74, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x12, 0x23, 0x0a,
	0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f,
	0x64, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e,
	0x63, 0x65, 0x22, 0x65, 0x0a, 0x16, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x4c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4b, 0x0a, 0x09,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x52, 0x09,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x22, 0xb5, 0x01, 0x0a, 0x1c, 0x47, 0x65,
	0x74, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x37, 0x0a,
	0x15, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x13, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x22, 0x62, 0x0a, 0x12, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x4c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x12, 0x4c, 0x0a, 0x09, 0x6c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74,
	0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x52, 0x09, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x73, 0x22, 0xa9, 0x01, 0x0a, 0x11, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72,
	0x74, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65,
	0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x73, 0x75, 0x70,
	0x70, 0x6f, 0x72, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x73, 0x75,
	0x70, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0d, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x22, 0x2d, 0x0a, 0x09, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x20,
	0x0a, 0x09, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x55, 0x72, 0x69,
	0x22, 0x82, 0x01, 0x0a, 0x0b, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x20, 0x0a, 0x09, 0x6d, 0x69, 0x6d, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x6d, 0x69, 0x6d, 0x65, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x47, 0x0a, 0x0a, 0x67, 0x63, 0x73, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00,
	0x52, 0x09, 0x67, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x08, 0x0a, 0x06, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x41, 0x0a, 0x0e, 0x47, 0x63, 0x73, 0x44, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2f, 0x0a, 0x11, 0x6f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x5f, 0x75, 0x72, 0x69, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x55,
	0x72, 0x69, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x22, 0x75, 0x0a, 0x0c, 0x4f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x56, 0x0a, 0x0f, 0x67, 0x63, 0x73, 0x5f,
	0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x47, 0x63, 0x73, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00,
	0x52, 0x0e, 0x67, 0x63, 0x73, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x42, 0x0d, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0xa1, 0x01, 0x0a, 0x13, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x70, 0x75,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1a, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x12, 0x47, 0x0a, 0x0a, 0x67, 0x63, 0x73, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48,
	0x00, 0x52, 0x09, 0x67, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x1b, 0x0a, 0x09,
	0x6d, 0x69, 0x6d, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x6d, 0x69, 0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x22, 0xa4, 0x01, 0x0a, 0x14, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5b, 0x0a, 0x0f,
	0x67, 0x63, 0x73, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x47, 0x63, 0x73, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0e, 0x67, 0x63, 0x73, 0x44, 0x65,
	0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x09, 0x6d, 0x69, 0x6d,
	0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x08, 0x6d, 0x69, 0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x42, 0x0d, 0x0a, 0x0b, 0x64,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xad, 0x07, 0x0a, 0x18, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x35, 0x0a, 0x14, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x35, 0x0a, 0x14, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63,
	0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f,
	0x64, 0x65, 0x12, 0x69, 0x0a, 0x15, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69,
	0x6e, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x13, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x6c, 0x0a,
	0x16, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x19, 0x0a, 0x05, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x66, 0x0a, 0x0f, 0x67, 0x6c, 0x6f, 0x73, 0x73, 0x61,
	0x72, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x54, 0x65, 0x78, 0x74, 0x47, 0x6c, 0x6f, 0x73, 0x73,
	0x61, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e,
	0x67, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5e,
	0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x41,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x3a,
	0x0a, 0x16, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x15, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x69, 0x7a, 0x65, 0x64, 0x41,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x43, 0x0a, 0x1c, 0x69, 0x73,
	0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x5f, 0x6e, 0x61, 0x74, 0x69, 0x76,
	0x65, 0x5f, 0x70, 0x64, 0x66, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x18, 0x69, 0x73, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61,
	0x74, 0x65, 0x4e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x50, 0x64, 0x66, 0x4f, 0x6e, 0x6c, 0x79, 0x12,
	0x4b, 0x0a, 0x20, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x68, 0x61, 0x64, 0x6f, 0x77,
	0x5f, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x61, 0x6c, 0x5f, 0x6e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f,
	0x70, 0x64, 0x66, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1c,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x68, 0x61, 0x64, 0x6f, 0x77, 0x52, 0x65, 0x6d, 0x6f,
	0x76, 0x61, 0x6c, 0x4e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x50, 0x64, 0x66, 0x12, 0x41, 0x0a, 0x1a,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x72, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x63, 0x6f, 0x72, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x18, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x72, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x1a,
	0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x98, 0x01, 0x0a, 0x13, 0x44,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x2e, 0x0a, 0x13, 0x62, 0x79, 0x74, 0x65, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0c, 0x52,
	0x11, 0x62, 0x79, 0x74, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x4f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x69, 0x6d, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6d, 0x69, 0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x34, 0x0a, 0x16, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x14, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x43, 0x6f, 0x64, 0x65, 0x22, 0xef, 0x02, 0x0a, 0x19, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c,
	0x61, 0x74, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x63, 0x0a, 0x14, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x13, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x74, 0x0a, 0x1d, 0x67, 0x6c, 0x6f, 0x73,
	0x73, 0x61, 0x72, 0x79, 0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x1b, 0x67, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x44, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x14,
	0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x12, 0x61, 0x0a, 0x0f, 0x67, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x6c, 0x61, 0x74, 0x65, 0x54, 0x65, 0x78, 0x74, 0x47, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72,
	0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0e, 0x67, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72,
	0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x95, 0x07, 0x0a, 0x19, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x54, 0x65, 0x78, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x35, 0x0a, 0x14, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12,
	0x37, 0x0a, 0x15, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x13, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x4c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x73, 0x12, 0x5f, 0x0a, 0x06, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x6c, 0x61, 0x74, 0x65, 0x54, 0x65, 0x78, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x06, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x12, 0x52, 0x0a, 0x0d, 0x69, 0x6e, 0x70,
	0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0c, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x53, 0x0a,
	0x0d, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x6b, 0x0a, 0x0a, 0x67, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x69, 0x65, 0x73,
	0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c,
	0x61, 0x74, 0x65, 0x54, 0x65, 0x78, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x47,
	0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0a, 0x67, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x69, 0x65, 0x73, 0x12,
	0x5f, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x54, 0x65, 0x78, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x1a, 0x39, 0x0a, 0x0b, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x77, 0x0a, 0x0f, 0x47,
	0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x4e, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x54, 0x65, 0x78, 0x74, 0x47, 0x6c, 0x6f, 0x73, 0x73,
	0x61, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22,
	0x9a, 0x03, 0x0a, 0x16, 0x42, 0x61, 0x74, 0x63, 0x68, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61,
	0x74, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x4f, 0x0a, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x33, 0x0a, 0x15, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63,
	0x74, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x14, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x43, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x73,
	0x12, 0x2b, 0x0a, 0x11, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x5f, 0x63, 0x68, 0x61, 0x72, 0x61,
	0x63, 0x74, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x10, 0x66, 0x61, 0x69,
	0x6c, 0x65, 0x64, 0x43, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x73, 0x12, 0x29, 0x0a,
	0x10, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72,
	0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0f, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x43, 0x68,
	0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x73, 0x75, 0x62, 0x6d,
	0x69, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x73, 0x75, 0x62, 0x6d, 0x69,
	0x74, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x65, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15,
	0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47,
	0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10,
	0x02, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0e, 0x0a,
	0x0a, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x0d, 0x0a,
	0x09, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x05, 0x22, 0x99, 0x02, 0x0a,
	0x16, 0x42, 0x61, 0x74, 0x63, 0x68, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x29, 0x0a, 0x10, 0x74, 0x6f, 0x74, 0x61, 0x6c,
	0x5f, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x0f, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x43, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65,
	0x72, 0x73, 0x12, 0x33, 0x0a, 0x15, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x64,
	0x5f, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x14, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x43, 0x68, 0x61,
	0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x66, 0x61, 0x69, 0x6c, 0x65,
	0x64, 0x5f, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x10, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x43, 0x68, 0x61, 0x72, 0x61, 0x63,
	0x74, 0x65, 0x72, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x73, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x73, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x68, 0x0a, 0x13, 0x47, 0x6c, 0x6f, 0x73,
	0x73, 0x61, 0x72, 0x79, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x47, 0x0a, 0x0a, 0x67, 0x63, 0x73, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x09, 0x67,
	0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x22, 0xb2, 0x06, 0x0a, 0x08, 0x47, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x12,
	0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x5d, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x5f, 0x70, 0x61, 0x69, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x6c,
	0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x2e, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43,
	0x6f, 0x64, 0x65, 0x50, 0x61, 0x69, 0x72, 0x48, 0x00, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x50, 0x61, 0x69, 0x72, 0x12, 0x66, 0x0a, 0x12, 0x6c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x73, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x47, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x2e, 0x4c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x73, 0x53, 0x65, 0x74, 0x48, 0x00, 0x52, 0x10, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x73, 0x53, 0x65, 0x74, 0x12,
	0x53, 0x0a, 0x0c, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x47, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x49, 0x6e, 0x70, 0x75,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0b, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x24, 0x0a, 0x0b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x65, 0x6e, 0x74, 0x72, 0x79, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x73, 0x75,
	0x62, 0x6d, 0x69, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x73, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08,
	0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65,
	0x1a, 0x76, 0x0a, 0x10, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65,
	0x50, 0x61, 0x69, 0x72, 0x12, 0x30, 0x0a, 0x14, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x12, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x30, 0x0a, 0x14, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x4c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x1a, 0x39, 0x0a, 0x10, 0x4c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x73, 0x53, 0x65, 0x74, 0x12, 0x25, 0x0a, 0x0e,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f,
	0x64, 0x65, 0x73, 0x3a, 0x65, 0xea, 0x41, 0x62, 0x0a, 0x21, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c,
	0x61, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x47, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x12, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x67, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x69, 0x65, 0x73, 0x2f,
	0x7b, 0x67, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x7d, 0x42, 0x0b, 0x0a, 0x09, 0x6c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x22, 0xa2, 0x01, 0x0a, 0x15, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x47, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x46, 0x0a, 0x08, 0x67, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x08, 0x67, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x22, 0x53, 0x0a, 0x12,
	0x47, 0x65, 0x74, 0x47, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c,
	0x61, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x47, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0x56, 0x0a, 0x15, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x47, 0x6c, 0x6f, 0x73, 0x73,
	0x61, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23,
	0x0a, 0x21, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x6c, 0x6f, 0x73, 0x73,
	0x61, 0x72, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xbd, 0x01, 0x0a, 0x15, 0x4c, 0x69,
	0x73, 0x74, 0x47, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x87, 0x01, 0x0a, 0x16, 0x4c, 0x69,
	0x73, 0x74, 0x47, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x45, 0x0a, 0x0a, 0x67, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x69,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x52,
	0x0a, 0x67, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x69, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0xa1, 0x02, 0x0a, 0x16, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x47, 0x6c,
	0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x4f, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x47, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x73, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x73, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x54, 0x69, 0x6d, 0x65,
	0x22, 0x65, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41,
	0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0d, 0x0a,
	0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06,
	0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0e, 0x0a, 0x0a, 0x43, 0x41, 0x4e, 0x43,
	0x45, 0x4c, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x41, 0x4e, 0x43,
	0x45, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x05, 0x22, 0xa1, 0x02, 0x0a, 0x16, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x47, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x4f, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x47, 0x6c, 0x6f, 0x73, 0x73, 0x61,
	0x72, 0x79, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x73, 0x75, 0x62, 0x6d, 0x69,
	0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x73, 0x75, 0x62, 0x6d, 0x69, 0x74,
	0x54, 0x69, 0x6d, 0x65, 0x22, 0x65, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a,
	0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10,
	0x01, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x02,
	0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0e, 0x0a, 0x0a,
	0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x0d, 0x0a, 0x09,
	0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x05, 0x22, 0xa0, 0x01, 0x0a, 0x16,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x47, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x73, 0x75,
	0x62, 0x6d, 0x69, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x73, 0x75, 0x62,
	0x6d, 0x69, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x22, 0xb9,
	0x09, 0x0a, 0x1d, 0x42, 0x61, 0x74, 0x63, 0x68, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74,
	0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x35, 0x0a, 0x14, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x37, 0x0a, 0x15, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f,
	0x64, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x13,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f,
	0x64, 0x65, 0x73, 0x12, 0x5f, 0x0a, 0x0d, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x73, 0x12, 0x60, 0x0a, 0x0d, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x63, 0x0a, 0x06, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73,
	0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c,
	0x61, 0x74, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x06, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x12, 0x6f, 0x0a, 0x0a, 0x67,
	0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x69, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x47, 0x6c, 0x6f, 0x73,
	0x73, 0x61, 0x72, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0a, 0x67, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x69, 0x65, 0x73, 0x12, 0x85, 0x01, 0x0a,
	0x12, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x51, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x11, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3a, 0x0a, 0x16, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x69, 0x7a,
	0x65, 0x64, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x15, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x69, 0x7a, 0x65, 0x64, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x4b, 0x0a, 0x20, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x68, 0x61, 0x64, 0x6f,
	0x77, 0x5f, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x61, 0x6c, 0x5f, 0x6e, 0x61, 0x74, 0x69, 0x76, 0x65,
	0x5f, 0x70, 0x64, 0x66, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x1c, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x68, 0x61, 0x64, 0x6f, 0x77, 0x52, 0x65, 0x6d,
	0x6f, 0x76, 0x61, 0x6c, 0x4e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x50, 0x64, 0x66, 0x12, 0x41, 0x0a,
	0x1a, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x72, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x63, 0x6f, 0x72, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0c, 0x20, 0x01, 0x28,
	0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x18, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x72, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x1a, 0x39, 0x0a, 0x0b, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x77, 0x0a, 0x0f, 0x47,
	0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x4e, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x54, 0x65, 0x78, 0x74, 0x47, 0x6c, 0x6f, 0x73, 0x73,
	0x61, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x1a, 0x44, 0x0a, 0x16, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x6d, 0x0a, 0x18, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x70, 0x75, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x47, 0x0a, 0x0a, 0x67, 0x63, 0x73, 0x5f, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x48, 0x00, 0x52, 0x09, 0x67, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42,
	0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x82, 0x01, 0x0a, 0x19, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x56, 0x0a, 0x0f, 0x67, 0x63, 0x73, 0x5f, 0x64,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47,
	0x63, 0x73, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52,
	0x0e, 0x67, 0x63, 0x73, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x0d, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xfe,
	0x03, 0x0a, 0x1e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74,
	0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x50, 0x61, 0x67,
	0x65, 0x73, 0x12, 0x29, 0x0a, 0x10, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x64,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0f, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x50, 0x61, 0x67, 0x65, 0x73, 0x12, 0x21, 0x0a,
	0x0c, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x73, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x0b, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x50, 0x61, 0x67, 0x65, 0x73,
	0x12, 0x30, 0x0a, 0x14, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x62, 0x69, 0x6c, 0x6c, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x12,
	0x74, 0x6f, 0x74, 0x61, 0x6c, 0x42, 0x69, 0x6c, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x61, 0x67,
	0x65, 0x73, 0x12, 0x29, 0x0a, 0x10, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x63, 0x68, 0x61, 0x72,
	0x61, 0x63, 0x74, 0x65, 0x72, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0f, 0x74, 0x6f,
	0x74, 0x61, 0x6c, 0x43, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x73, 0x12, 0x33, 0x0a,
	0x15, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x68, 0x61, 0x72,
	0x61, 0x63, 0x74, 0x65, 0x72, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x52, 0x14, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x43, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65,
	0x72, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x5f, 0x63, 0x68, 0x61,
	0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x52, 0x10, 0x66,
	0x61, 0x69, 0x6c, 0x65, 0x64, 0x43, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x73, 0x12,
	0x3a, 0x0a, 0x19, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x62, 0x69, 0x6c, 0x6c, 0x61, 0x62, 0x6c,
	0x65, 0x5f, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x73, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x17, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x42, 0x69, 0x6c, 0x6c, 0x61, 0x62, 0x6c,
	0x65, 0x43, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x73,
	0x75, 0x62, 0x6d, 0x69, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x73, 0x75,
	0x62, 0x6d, 0x69, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x22,
	0x87, 0x05, 0x0a, 0x1e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61,
	0x74, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x57, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x44, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x74,
	0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x50, 0x61, 0x67, 0x65, 0x73, 0x12, 0x29, 0x0a, 0x10,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x73,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74,
	0x65, 0x64, 0x50, 0x61, 0x67, 0x65, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x66, 0x61, 0x69, 0x6c, 0x65,
	0x64, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0b, 0x66,
	0x61, 0x69, 0x6c, 0x65, 0x64, 0x50, 0x61, 0x67, 0x65, 0x73, 0x12, 0x30, 0x0a, 0x14, 0x74, 0x6f,
	0x74, 0x61, 0x6c, 0x5f, 0x62, 0x69, 0x6c, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x12, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x42,
	0x69, 0x6c, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x61, 0x67, 0x65, 0x73, 0x12, 0x29, 0x0a, 0x10,
	0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x73,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0f, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x43, 0x68, 0x61,
	0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x73, 0x12, 0x33, 0x0a, 0x15, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x6c, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x73,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x52, 0x14, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74,
	0x65, 0x64, 0x43, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x73, 0x12, 0x2b, 0x0a, 0x11,
	0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x5f, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72,
	0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x03, 0x52, 0x10, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x43,
	0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x73, 0x12, 0x3a, 0x0a, 0x19, 0x74, 0x6f, 0x74,
	0x61, 0x6c, 0x5f, 0x62, 0x69, 0x6c, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x72,
	0x61, 0x63, 0x74, 0x65, 0x72, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x03, 0x52, 0x17, 0x74, 0x6f,
	0x74, 0x61, 0x6c, 0x42, 0x69, 0x6c, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x68, 0x61, 0x72, 0x61,
	0x63, 0x74, 0x65, 0x72, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x73, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x73, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x54, 0x69,
	0x6d, 0x65, 0x22, 0x65, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53,
	0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12,
	0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0a,
	0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0e, 0x0a, 0x0a, 0x43, 0x41,
	0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x41,
	0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x05, 0x32, 0xa8, 0x26, 0x0a, 0x12, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x12, 0xd4, 0x02, 0x0a, 0x0d, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x54, 0x65,
	0x78, 0x74, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x54, 0x65, 0x78, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x54, 0x65, 0x78,
	0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xdb, 0x01, 0xda, 0x41, 0x24, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x2c, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x73, 0xda, 0x41, 0x49, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x2c, 0x6d, 0x69, 0x6d, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2c, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64,
	0x65, 0x2c, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x2c, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x62, 0x3a, 0x01, 0x2a, 0x5a, 0x2a, 0x3a, 0x01, 0x2a, 0x22, 0x25, 0x2f,
	0x76, 0x33, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65,
	0x54, 0x65, 0x78, 0x74, 0x22, 0x31, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c,
	0x61, 0x74, 0x65, 0x54, 0x65, 0x78, 0x74, 0x12, 0x87, 0x02, 0x0a, 0x0e, 0x44, 0x65, 0x74, 0x65,
	0x63, 0x74, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x4c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x65, 0x74,
	0x65, 0x63, 0x74, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x8b, 0x01, 0xda, 0x41, 0x1e, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2c, 0x6d, 0x69, 0x6d, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2c,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x64, 0x3a, 0x01, 0x2a,
	0x5a, 0x2b, 0x3a, 0x01, 0x2a, 0x22, 0x26, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x64,
	0x65, 0x74, 0x65, 0x63, 0x74, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x22, 0x32, 0x2f,
	0x76, 0x33, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x12, 0x97, 0x02, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74,
	0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x12, 0x39, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x75, 0x70,
	0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x4c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x22, 0x91, 0x01, 0xda, 0x41, 0x22, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x2c, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x66, 0x5a, 0x2c, 0x12, 0x2a, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x73, 0x12, 0x36, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74,
	0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x12, 0xc4, 0x01, 0x0a, 0x11,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65,
	0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x40, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3a, 0x3a, 0x01, 0x2a, 0x22, 0x35, 0x2f, 0x76, 0x33,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x12, 0xe1, 0x01, 0x0a, 0x12, 0x42, 0x61, 0x74, 0x63, 0x68, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x6c, 0x61, 0x74, 0x65, 0x54, 0x65, 0x78, 0x74, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x54, 0x65, 0x78, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x74, 0xca, 0x41, 0x30, 0x0a, 0x16, 0x42, 0x61, 0x74, 0x63, 0x68, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x16, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x3a, 0x01, 0x2a, 0x22, 0x36,
	0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61,
	0x74, 0x65, 0x54, 0x65, 0x78, 0x74, 0x12, 0xce, 0x02, 0x0a, 0x16, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x44, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xd8, 0x01, 0xca,
	0x41, 0x40, 0x0a, 0x1e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61,
	0x74, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x1e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61,
	0x74, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xda, 0x41, 0x4d, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65,
	0x2c, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x5f, 0x63, 0x6f, 0x64, 0x65, 0x73, 0x2c, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x73, 0x2c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x3a, 0x01, 0x2a, 0x22, 0x3a, 0x2f, 0x76, 0x33,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x44,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0xdc, 0x01, 0x0a, 0x0e, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x47, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x47,
	0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x77, 0xca,
	0x41, 0x22, 0x0a, 0x08, 0x47, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x12, 0x16, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x47, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x0f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x67, 0x6c,
	0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3a, 0x3a, 0x08, 0x67, 0x6c,
	0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x22, 0x2e, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x67, 0x6c, 0x6f, 0x73,
	0x73, 0x61, 0x72, 0x69, 0x65, 0x73, 0x12, 0xba, 0x01, 0x0a, 0x0e, 0x4c, 0x69, 0x73, 0x74, 0x47,
	0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x69, 0x65, 0x73, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x6c, 0x6f, 0x73,
	0x73, 0x61, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x47, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x3f, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x30, 0x12, 0x2e, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x67, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72,
	0x69, 0x65, 0x73, 0x12, 0xa4, 0x01, 0x0a, 0x0b, 0x47, 0x65, 0x74, 0x47, 0x6c, 0x6f, 0x73, 0x73,
	0x61, 0x72, 0x79, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x47, 0x65, 0x74, 0x47, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x47, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x22, 0x3d, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30, 0x12, 0x2e, 0x2f, 0x76, 0x33, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x6c, 0x6f,
	0x73, 0x73, 0x61, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd5, 0x01, 0x0a, 0x0e, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x47, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x12, 0x32, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x47, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x70, 0xca, 0x41, 0x30, 0x0a, 0x16, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x47, 0x6c, 0x6f,
	0x73, 0x73, 0x61, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x16, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x47, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x30, 0x2a, 0x2e, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x69, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0xf8, 0x01, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x64, 0x61,
	0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x3b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x41, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x44, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x64, 0x61, 0x70, 0x74, 0x69,
	0x76, 0x65, 0x4d, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x22, 0x70, 0xda, 0x41, 0x1a,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x61, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x5f,
	0x6d, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4d,
	0x3a, 0x13, 0x61, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x6d, 0x74, 0x5f, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x22, 0x36, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x64, 0x61, 0x70, 0x74,
	0x69, 0x76, 0x65, 0x4d, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x12, 0xb5, 0x01,
	0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65,
	0x4d, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x64,
	0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x45,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x2a, 0x36, 0x2f,
	0x76, 0x33, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x61, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc7, 0x01, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x41, 0x64, 0x61,
	0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x38,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65, 0x74,
	0x41, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d,
	0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x22, 0x45, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x12, 0x36, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x64, 0x61, 0x70, 0x74, 0x69,
	0x76, 0x65, 0x4d, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xda, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65,
	0x4d, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x64, 0x61,
	0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76,
	0x65, 0x4d, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x47, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x38, 0x12, 0x36, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x64, 0x61, 0x70, 0x74, 0x69,
	0x76, 0x65, 0x4d, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x12, 0xdd, 0x01, 0x0a,
	0x13, 0x41, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x6c, 0x61, 0x74, 0x65, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x41, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x64, 0x61, 0x70,
	0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x53, 0xda, 0x41, 0x0e, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x2c, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c,
	0x3a, 0x01, 0x2a, 0x22, 0x37, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76,
	0x65, 0x4d, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x12, 0xd0, 0x01, 0x0a,
	0x11, 0x47, 0x65, 0x74, 0x41, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x46, 0x69,
	0x6c, 0x65, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x47, 0x65, 0x74, 0x41, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x46, 0x69,
	0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65,
	0x4d, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x22, 0x57, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x4a, 0x12, 0x48, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65,
	0x4d, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x64, 0x61,
	0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xc1, 0x01, 0x0a, 0x14, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x64, 0x61, 0x70, 0x74, 0x69,
	0x76, 0x65, 0x4d, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x64, 0x61,
	0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x57, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4a, 0x2a, 0x48, 0x2f, 0x76, 0x33, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x64, 0x61, 0x70,
	0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x61, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xee, 0x01, 0x0a, 0x14, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x64,
	0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x12, 0x38, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x41, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x64, 0x61, 0x70, 0x74,
	0x69, 0x76, 0x65, 0x4d, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x61, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x52, 0x3a, 0x01, 0x2a, 0x22, 0x4d, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x64, 0x61, 0x70, 0x74, 0x69,
	0x76, 0x65, 0x4d, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74,
	0x46, 0x69, 0x6c, 0x65, 0x12, 0xe3, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x64, 0x61,
	0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x37, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41,
	0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65,
	0x4d, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x59, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4a,
	0x12, 0x48, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x44,
	0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x64, 0x61, 0x70, 0x74,
	0x69, 0x76, 0x65, 0x4d, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x12, 0xd7, 0x02, 0x0a, 0x17, 0x4c,
	0x69, 0x73, 0x74, 0x41, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x53, 0x65, 0x6e,
	0x74, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76,
	0x65, 0x4d, 0x74, 0x53, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74,
	0x53, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0xc0, 0x01, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0xb0, 0x01, 0x5a, 0x4e, 0x12, 0x4c, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x64, 0x61, 0x70, 0x74,
	0x69, 0x76, 0x65, 0x4d, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x61, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x53, 0x65, 0x6e, 0x74, 0x65,
	0x6e, 0x63, 0x65, 0x73, 0x12, 0x5e, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76,
	0x65, 0x4d, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x64,
	0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x61, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x53, 0x65, 0x6e, 0x74, 0x65,
	0x6e, 0x63, 0x65, 0x73, 0x1a, 0x7e, 0xca, 0x41, 0x18, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61,
	0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0xd2, 0x41, 0x60, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61,
	0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75,
	0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x42, 0xd1, 0x01, 0x0a, 0x1d, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c,
	0x61, 0x74, 0x65, 0x2e, 0x76, 0x33, 0x42, 0x17, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x3b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x76, 0x33, 0x2f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65,
	0x70, 0x62, 0x3b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x70, 0x62, 0xf8, 0x01,
	0x01, 0xaa, 0x02, 0x19, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x2e, 0x56, 0x33, 0xca, 0x02, 0x19,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x5c, 0x56, 0x33, 0xea, 0x02, 0x1c, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x6c, 0x61, 0x74, 0x65, 0x3a, 0x3a, 0x56, 0x33, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_translate_v3_translation_service_proto_rawDescOnce sync.Once
	file_google_cloud_translate_v3_translation_service_proto_rawDescData = file_google_cloud_translate_v3_translation_service_proto_rawDesc
)

func file_google_cloud_translate_v3_translation_service_proto_rawDescGZIP() []byte {
	file_google_cloud_translate_v3_translation_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_translate_v3_translation_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_translate_v3_translation_service_proto_rawDescData)
	})
	return file_google_cloud_translate_v3_translation_service_proto_rawDescData
}

var file_google_cloud_translate_v3_translation_service_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_cloud_translate_v3_translation_service_proto_msgTypes = make([]protoimpl.MessageInfo, 48)
var file_google_cloud_translate_v3_translation_service_proto_goTypes = []interface{}{
	(BatchTranslateMetadata_State)(0),         // 0: google.cloud.translation.v3.BatchTranslateMetadata.State
	(CreateGlossaryMetadata_State)(0),         // 1: google.cloud.translation.v3.CreateGlossaryMetadata.State
	(DeleteGlossaryMetadata_State)(0),         // 2: google.cloud.translation.v3.DeleteGlossaryMetadata.State
	(BatchTranslateDocumentMetadata_State)(0), // 3: google.cloud.translation.v3.BatchTranslateDocumentMetadata.State
	(*TranslateTextGlossaryConfig)(nil),       // 4: google.cloud.translation.v3.TranslateTextGlossaryConfig
	(*TranslateTextRequest)(nil),              // 5: google.cloud.translation.v3.TranslateTextRequest
	(*TranslateTextResponse)(nil),             // 6: google.cloud.translation.v3.TranslateTextResponse
	(*Translation)(nil),                       // 7: google.cloud.translation.v3.Translation
	(*DetectLanguageRequest)(nil),             // 8: google.cloud.translation.v3.DetectLanguageRequest
	(*DetectedLanguage)(nil),                  // 9: google.cloud.translation.v3.DetectedLanguage
	(*DetectLanguageResponse)(nil),            // 10: google.cloud.translation.v3.DetectLanguageResponse
	(*GetSupportedLanguagesRequest)(nil),      // 11: google.cloud.translation.v3.GetSupportedLanguagesRequest
	(*SupportedLanguages)(nil),                // 12: google.cloud.translation.v3.SupportedLanguages
	(*SupportedLanguage)(nil),                 // 13: google.cloud.translation.v3.SupportedLanguage
	(*GcsSource)(nil),                         // 14: google.cloud.translation.v3.GcsSource
	(*InputConfig)(nil),                       // 15: google.cloud.translation.v3.InputConfig
	(*GcsDestination)(nil),                    // 16: google.cloud.translation.v3.GcsDestination
	(*OutputConfig)(nil),                      // 17: google.cloud.translation.v3.OutputConfig
	(*DocumentInputConfig)(nil),               // 18: google.cloud.translation.v3.DocumentInputConfig
	(*DocumentOutputConfig)(nil),              // 19: google.cloud.translation.v3.DocumentOutputConfig
	(*TranslateDocumentRequest)(nil),          // 20: google.cloud.translation.v3.TranslateDocumentRequest
	(*DocumentTranslation)(nil),               // 21: google.cloud.translation.v3.DocumentTranslation
	(*TranslateDocumentResponse)(nil),         // 22: google.cloud.translation.v3.TranslateDocumentResponse
	(*BatchTranslateTextRequest)(nil),         // 23: google.cloud.translation.v3.BatchTranslateTextRequest
	(*BatchTranslateMetadata)(nil),            // 24: google.cloud.translation.v3.BatchTranslateMetadata
	(*BatchTranslateResponse)(nil),            // 25: google.cloud.translation.v3.BatchTranslateResponse
	(*GlossaryInputConfig)(nil),               // 26: google.cloud.translation.v3.GlossaryInputConfig
	(*Glossary)(nil),                          // 27: google.cloud.translation.v3.Glossary
	(*CreateGlossaryRequest)(nil),             // 28: google.cloud.translation.v3.CreateGlossaryRequest
	(*GetGlossaryRequest)(nil),                // 29: google.cloud.translation.v3.GetGlossaryRequest
	(*DeleteGlossaryRequest)(nil),             // 30: google.cloud.translation.v3.DeleteGlossaryRequest
	(*ListGlossariesRequest)(nil),             // 31: google.cloud.translation.v3.ListGlossariesRequest
	(*ListGlossariesResponse)(nil),            // 32: google.cloud.translation.v3.ListGlossariesResponse
	(*CreateGlossaryMetadata)(nil),            // 33: google.cloud.translation.v3.CreateGlossaryMetadata
	(*DeleteGlossaryMetadata)(nil),            // 34: google.cloud.translation.v3.DeleteGlossaryMetadata
	(*DeleteGlossaryResponse)(nil),            // 35: google.cloud.translation.v3.DeleteGlossaryResponse
	(*BatchTranslateDocumentRequest)(nil),     // 36: google.cloud.translation.v3.BatchTranslateDocumentRequest
	(*BatchDocumentInputConfig)(nil),          // 37: google.cloud.translation.v3.BatchDocumentInputConfig
	(*BatchDocumentOutputConfig)(nil),         // 38: google.cloud.translation.v3.BatchDocumentOutputConfig
	(*BatchTranslateDocumentResponse)(nil),    // 39: google.cloud.translation.v3.BatchTranslateDocumentResponse
	(*BatchTranslateDocumentMetadata)(nil),    // 40: google.cloud.translation.v3.BatchTranslateDocumentMetadata
	nil,                                       // 41: google.cloud.translation.v3.TranslateTextRequest.LabelsEntry
	nil,                                       // 42: google.cloud.translation.v3.DetectLanguageRequest.LabelsEntry
	nil,                                       // 43: google.cloud.translation.v3.TranslateDocumentRequest.LabelsEntry
	nil,                                       // 44: google.cloud.translation.v3.BatchTranslateTextRequest.ModelsEntry
	nil,                                       // 45: google.cloud.translation.v3.BatchTranslateTextRequest.GlossariesEntry
	nil,                                       // 46: google.cloud.translation.v3.BatchTranslateTextRequest.LabelsEntry
	(*Glossary_LanguageCodePair)(nil),         // 47: google.cloud.translation.v3.Glossary.LanguageCodePair
	(*Glossary_LanguageCodesSet)(nil),         // 48: google.cloud.translation.v3.Glossary.LanguageCodesSet
	nil,                                       // 49: google.cloud.translation.v3.BatchTranslateDocumentRequest.ModelsEntry
	nil,                                       // 50: google.cloud.translation.v3.BatchTranslateDocumentRequest.GlossariesEntry
	nil,                                       // 51: google.cloud.translation.v3.BatchTranslateDocumentRequest.FormatConversionsEntry
	(*timestamppb.Timestamp)(nil),             // 52: google.protobuf.Timestamp
	(*CreateAdaptiveMtDatasetRequest)(nil),    // 53: google.cloud.translation.v3.CreateAdaptiveMtDatasetRequest
	(*DeleteAdaptiveMtDatasetRequest)(nil),    // 54: google.cloud.translation.v3.DeleteAdaptiveMtDatasetRequest
	(*GetAdaptiveMtDatasetRequest)(nil),       // 55: google.cloud.translation.v3.GetAdaptiveMtDatasetRequest
	(*ListAdaptiveMtDatasetsRequest)(nil),     // 56: google.cloud.translation.v3.ListAdaptiveMtDatasetsRequest
	(*AdaptiveMtTranslateRequest)(nil),        // 57: google.cloud.translation.v3.AdaptiveMtTranslateRequest
	(*GetAdaptiveMtFileRequest)(nil),          // 58: google.cloud.translation.v3.GetAdaptiveMtFileRequest
	(*DeleteAdaptiveMtFileRequest)(nil),       // 59: google.cloud.translation.v3.DeleteAdaptiveMtFileRequest
	(*ImportAdaptiveMtFileRequest)(nil),       // 60: google.cloud.translation.v3.ImportAdaptiveMtFileRequest
	(*ListAdaptiveMtFilesRequest)(nil),        // 61: google.cloud.translation.v3.ListAdaptiveMtFilesRequest
	(*ListAdaptiveMtSentencesRequest)(nil),    // 62: google.cloud.translation.v3.ListAdaptiveMtSentencesRequest
	(*longrunningpb.Operation)(nil),           // 63: google.longrunning.Operation
	(*AdaptiveMtDataset)(nil),                 // 64: google.cloud.translation.v3.AdaptiveMtDataset
	(*emptypb.Empty)(nil),                     // 65: google.protobuf.Empty
	(*ListAdaptiveMtDatasetsResponse)(nil),    // 66: google.cloud.translation.v3.ListAdaptiveMtDatasetsResponse
	(*AdaptiveMtTranslateResponse)(nil),       // 67: google.cloud.translation.v3.AdaptiveMtTranslateResponse
	(*AdaptiveMtFile)(nil),                    // 68: google.cloud.translation.v3.AdaptiveMtFile
	(*ImportAdaptiveMtFileResponse)(nil),      // 69: google.cloud.translation.v3.ImportAdaptiveMtFileResponse
	(*ListAdaptiveMtFilesResponse)(nil),       // 70: google.cloud.translation.v3.ListAdaptiveMtFilesResponse
	(*ListAdaptiveMtSentencesResponse)(nil),   // 71: google.cloud.translation.v3.ListAdaptiveMtSentencesResponse
}
var file_google_cloud_translate_v3_translation_service_proto_depIdxs = []int32{
	4,  // 0: google.cloud.translation.v3.TranslateTextRequest.glossary_config:type_name -> google.cloud.translation.v3.TranslateTextGlossaryConfig
	41, // 1: google.cloud.translation.v3.TranslateTextRequest.labels:type_name -> google.cloud.translation.v3.TranslateTextRequest.LabelsEntry
	7,  // 2: google.cloud.translation.v3.TranslateTextResponse.translations:type_name -> google.cloud.translation.v3.Translation
	7,  // 3: google.cloud.translation.v3.TranslateTextResponse.glossary_translations:type_name -> google.cloud.translation.v3.Translation
	4,  // 4: google.cloud.translation.v3.Translation.glossary_config:type_name -> google.cloud.translation.v3.TranslateTextGlossaryConfig
	42, // 5: google.cloud.translation.v3.DetectLanguageRequest.labels:type_name -> google.cloud.translation.v3.DetectLanguageRequest.LabelsEntry
	9,  // 6: google.cloud.translation.v3.DetectLanguageResponse.languages:type_name -> google.cloud.translation.v3.DetectedLanguage
	13, // 7: google.cloud.translation.v3.SupportedLanguages.languages:type_name -> google.cloud.translation.v3.SupportedLanguage
	14, // 8: google.cloud.translation.v3.InputConfig.gcs_source:type_name -> google.cloud.translation.v3.GcsSource
	16, // 9: google.cloud.translation.v3.OutputConfig.gcs_destination:type_name -> google.cloud.translation.v3.GcsDestination
	14, // 10: google.cloud.translation.v3.DocumentInputConfig.gcs_source:type_name -> google.cloud.translation.v3.GcsSource
	16, // 11: google.cloud.translation.v3.DocumentOutputConfig.gcs_destination:type_name -> google.cloud.translation.v3.GcsDestination
	18, // 12: google.cloud.translation.v3.TranslateDocumentRequest.document_input_config:type_name -> google.cloud.translation.v3.DocumentInputConfig
	19, // 13: google.cloud.translation.v3.TranslateDocumentRequest.document_output_config:type_name -> google.cloud.translation.v3.DocumentOutputConfig
	4,  // 14: google.cloud.translation.v3.TranslateDocumentRequest.glossary_config:type_name -> google.cloud.translation.v3.TranslateTextGlossaryConfig
	43, // 15: google.cloud.translation.v3.TranslateDocumentRequest.labels:type_name -> google.cloud.translation.v3.TranslateDocumentRequest.LabelsEntry
	21, // 16: google.cloud.translation.v3.TranslateDocumentResponse.document_translation:type_name -> google.cloud.translation.v3.DocumentTranslation
	21, // 17: google.cloud.translation.v3.TranslateDocumentResponse.glossary_document_translation:type_name -> google.cloud.translation.v3.DocumentTranslation
	4,  // 18: google.cloud.translation.v3.TranslateDocumentResponse.glossary_config:type_name -> google.cloud.translation.v3.TranslateTextGlossaryConfig
	44, // 19: google.cloud.translation.v3.BatchTranslateTextRequest.models:type_name -> google.cloud.translation.v3.BatchTranslateTextRequest.ModelsEntry
	15, // 20: google.cloud.translation.v3.BatchTranslateTextRequest.input_configs:type_name -> google.cloud.translation.v3.InputConfig
	17, // 21: google.cloud.translation.v3.BatchTranslateTextRequest.output_config:type_name -> google.cloud.translation.v3.OutputConfig
	45, // 22: google.cloud.translation.v3.BatchTranslateTextRequest.glossaries:type_name -> google.cloud.translation.v3.BatchTranslateTextRequest.GlossariesEntry
	46, // 23: google.cloud.translation.v3.BatchTranslateTextRequest.labels:type_name -> google.cloud.translation.v3.BatchTranslateTextRequest.LabelsEntry
	0,  // 24: google.cloud.translation.v3.BatchTranslateMetadata.state:type_name -> google.cloud.translation.v3.BatchTranslateMetadata.State
	52, // 25: google.cloud.translation.v3.BatchTranslateMetadata.submit_time:type_name -> google.protobuf.Timestamp
	52, // 26: google.cloud.translation.v3.BatchTranslateResponse.submit_time:type_name -> google.protobuf.Timestamp
	52, // 27: google.cloud.translation.v3.BatchTranslateResponse.end_time:type_name -> google.protobuf.Timestamp
	14, // 28: google.cloud.translation.v3.GlossaryInputConfig.gcs_source:type_name -> google.cloud.translation.v3.GcsSource
	47, // 29: google.cloud.translation.v3.Glossary.language_pair:type_name -> google.cloud.translation.v3.Glossary.LanguageCodePair
	48, // 30: google.cloud.translation.v3.Glossary.language_codes_set:type_name -> google.cloud.translation.v3.Glossary.LanguageCodesSet
	26, // 31: google.cloud.translation.v3.Glossary.input_config:type_name -> google.cloud.translation.v3.GlossaryInputConfig
	52, // 32: google.cloud.translation.v3.Glossary.submit_time:type_name -> google.protobuf.Timestamp
	52, // 33: google.cloud.translation.v3.Glossary.end_time:type_name -> google.protobuf.Timestamp
	27, // 34: google.cloud.translation.v3.CreateGlossaryRequest.glossary:type_name -> google.cloud.translation.v3.Glossary
	27, // 35: google.cloud.translation.v3.ListGlossariesResponse.glossaries:type_name -> google.cloud.translation.v3.Glossary
	1,  // 36: google.cloud.translation.v3.CreateGlossaryMetadata.state:type_name -> google.cloud.translation.v3.CreateGlossaryMetadata.State
	52, // 37: google.cloud.translation.v3.CreateGlossaryMetadata.submit_time:type_name -> google.protobuf.Timestamp
	2,  // 38: google.cloud.translation.v3.DeleteGlossaryMetadata.state:type_name -> google.cloud.translation.v3.DeleteGlossaryMetadata.State
	52, // 39: google.cloud.translation.v3.DeleteGlossaryMetadata.submit_time:type_name -> google.protobuf.Timestamp
	52, // 40: google.cloud.translation.v3.DeleteGlossaryResponse.submit_time:type_name -> google.protobuf.Timestamp
	52, // 41: google.cloud.translation.v3.DeleteGlossaryResponse.end_time:type_name -> google.protobuf.Timestamp
	37, // 42: google.cloud.translation.v3.BatchTranslateDocumentRequest.input_configs:type_name -> google.cloud.translation.v3.BatchDocumentInputConfig
	38, // 43: google.cloud.translation.v3.BatchTranslateDocumentRequest.output_config:type_name -> google.cloud.translation.v3.BatchDocumentOutputConfig
	49, // 44: google.cloud.translation.v3.BatchTranslateDocumentRequest.models:type_name -> google.cloud.translation.v3.BatchTranslateDocumentRequest.ModelsEntry
	50, // 45: google.cloud.translation.v3.BatchTranslateDocumentRequest.glossaries:type_name -> google.cloud.translation.v3.BatchTranslateDocumentRequest.GlossariesEntry
	51, // 46: google.cloud.translation.v3.BatchTranslateDocumentRequest.format_conversions:type_name -> google.cloud.translation.v3.BatchTranslateDocumentRequest.FormatConversionsEntry
	14, // 47: google.cloud.translation.v3.BatchDocumentInputConfig.gcs_source:type_name -> google.cloud.translation.v3.GcsSource
	16, // 48: google.cloud.translation.v3.BatchDocumentOutputConfig.gcs_destination:type_name -> google.cloud.translation.v3.GcsDestination
	52, // 49: google.cloud.translation.v3.BatchTranslateDocumentResponse.submit_time:type_name -> google.protobuf.Timestamp
	52, // 50: google.cloud.translation.v3.BatchTranslateDocumentResponse.end_time:type_name -> google.protobuf.Timestamp
	3,  // 51: google.cloud.translation.v3.BatchTranslateDocumentMetadata.state:type_name -> google.cloud.translation.v3.BatchTranslateDocumentMetadata.State
	52, // 52: google.cloud.translation.v3.BatchTranslateDocumentMetadata.submit_time:type_name -> google.protobuf.Timestamp
	4,  // 53: google.cloud.translation.v3.BatchTranslateTextRequest.GlossariesEntry.value:type_name -> google.cloud.translation.v3.TranslateTextGlossaryConfig
	4,  // 54: google.cloud.translation.v3.BatchTranslateDocumentRequest.GlossariesEntry.value:type_name -> google.cloud.translation.v3.TranslateTextGlossaryConfig
	5,  // 55: google.cloud.translation.v3.TranslationService.TranslateText:input_type -> google.cloud.translation.v3.TranslateTextRequest
	8,  // 56: google.cloud.translation.v3.TranslationService.DetectLanguage:input_type -> google.cloud.translation.v3.DetectLanguageRequest
	11, // 57: google.cloud.translation.v3.TranslationService.GetSupportedLanguages:input_type -> google.cloud.translation.v3.GetSupportedLanguagesRequest
	20, // 58: google.cloud.translation.v3.TranslationService.TranslateDocument:input_type -> google.cloud.translation.v3.TranslateDocumentRequest
	23, // 59: google.cloud.translation.v3.TranslationService.BatchTranslateText:input_type -> google.cloud.translation.v3.BatchTranslateTextRequest
	36, // 60: google.cloud.translation.v3.TranslationService.BatchTranslateDocument:input_type -> google.cloud.translation.v3.BatchTranslateDocumentRequest
	28, // 61: google.cloud.translation.v3.TranslationService.CreateGlossary:input_type -> google.cloud.translation.v3.CreateGlossaryRequest
	31, // 62: google.cloud.translation.v3.TranslationService.ListGlossaries:input_type -> google.cloud.translation.v3.ListGlossariesRequest
	29, // 63: google.cloud.translation.v3.TranslationService.GetGlossary:input_type -> google.cloud.translation.v3.GetGlossaryRequest
	30, // 64: google.cloud.translation.v3.TranslationService.DeleteGlossary:input_type -> google.cloud.translation.v3.DeleteGlossaryRequest
	53, // 65: google.cloud.translation.v3.TranslationService.CreateAdaptiveMtDataset:input_type -> google.cloud.translation.v3.CreateAdaptiveMtDatasetRequest
	54, // 66: google.cloud.translation.v3.TranslationService.DeleteAdaptiveMtDataset:input_type -> google.cloud.translation.v3.DeleteAdaptiveMtDatasetRequest
	55, // 67: google.cloud.translation.v3.TranslationService.GetAdaptiveMtDataset:input_type -> google.cloud.translation.v3.GetAdaptiveMtDatasetRequest
	56, // 68: google.cloud.translation.v3.TranslationService.ListAdaptiveMtDatasets:input_type -> google.cloud.translation.v3.ListAdaptiveMtDatasetsRequest
	57, // 69: google.cloud.translation.v3.TranslationService.AdaptiveMtTranslate:input_type -> google.cloud.translation.v3.AdaptiveMtTranslateRequest
	58, // 70: google.cloud.translation.v3.TranslationService.GetAdaptiveMtFile:input_type -> google.cloud.translation.v3.GetAdaptiveMtFileRequest
	59, // 71: google.cloud.translation.v3.TranslationService.DeleteAdaptiveMtFile:input_type -> google.cloud.translation.v3.DeleteAdaptiveMtFileRequest
	60, // 72: google.cloud.translation.v3.TranslationService.ImportAdaptiveMtFile:input_type -> google.cloud.translation.v3.ImportAdaptiveMtFileRequest
	61, // 73: google.cloud.translation.v3.TranslationService.ListAdaptiveMtFiles:input_type -> google.cloud.translation.v3.ListAdaptiveMtFilesRequest
	62, // 74: google.cloud.translation.v3.TranslationService.ListAdaptiveMtSentences:input_type -> google.cloud.translation.v3.ListAdaptiveMtSentencesRequest
	6,  // 75: google.cloud.translation.v3.TranslationService.TranslateText:output_type -> google.cloud.translation.v3.TranslateTextResponse
	10, // 76: google.cloud.translation.v3.TranslationService.DetectLanguage:output_type -> google.cloud.translation.v3.DetectLanguageResponse
	12, // 77: google.cloud.translation.v3.TranslationService.GetSupportedLanguages:output_type -> google.cloud.translation.v3.SupportedLanguages
	22, // 78: google.cloud.translation.v3.TranslationService.TranslateDocument:output_type -> google.cloud.translation.v3.TranslateDocumentResponse
	63, // 79: google.cloud.translation.v3.TranslationService.BatchTranslateText:output_type -> google.longrunning.Operation
	63, // 80: google.cloud.translation.v3.TranslationService.BatchTranslateDocument:output_type -> google.longrunning.Operation
	63, // 81: google.cloud.translation.v3.TranslationService.CreateGlossary:output_type -> google.longrunning.Operation
	32, // 82: google.cloud.translation.v3.TranslationService.ListGlossaries:output_type -> google.cloud.translation.v3.ListGlossariesResponse
	27, // 83: google.cloud.translation.v3.TranslationService.GetGlossary:output_type -> google.cloud.translation.v3.Glossary
	63, // 84: google.cloud.translation.v3.TranslationService.DeleteGlossary:output_type -> google.longrunning.Operation
	64, // 85: google.cloud.translation.v3.TranslationService.CreateAdaptiveMtDataset:output_type -> google.cloud.translation.v3.AdaptiveMtDataset
	65, // 86: google.cloud.translation.v3.TranslationService.DeleteAdaptiveMtDataset:output_type -> google.protobuf.Empty
	64, // 87: google.cloud.translation.v3.TranslationService.GetAdaptiveMtDataset:output_type -> google.cloud.translation.v3.AdaptiveMtDataset
	66, // 88: google.cloud.translation.v3.TranslationService.ListAdaptiveMtDatasets:output_type -> google.cloud.translation.v3.ListAdaptiveMtDatasetsResponse
	67, // 89: google.cloud.translation.v3.TranslationService.AdaptiveMtTranslate:output_type -> google.cloud.translation.v3.AdaptiveMtTranslateResponse
	68, // 90: google.cloud.translation.v3.TranslationService.GetAdaptiveMtFile:output_type -> google.cloud.translation.v3.AdaptiveMtFile
	65, // 91: google.cloud.translation.v3.TranslationService.DeleteAdaptiveMtFile:output_type -> google.protobuf.Empty
	69, // 92: google.cloud.translation.v3.TranslationService.ImportAdaptiveMtFile:output_type -> google.cloud.translation.v3.ImportAdaptiveMtFileResponse
	70, // 93: google.cloud.translation.v3.TranslationService.ListAdaptiveMtFiles:output_type -> google.cloud.translation.v3.ListAdaptiveMtFilesResponse
	71, // 94: google.cloud.translation.v3.TranslationService.ListAdaptiveMtSentences:output_type -> google.cloud.translation.v3.ListAdaptiveMtSentencesResponse
	75, // [75:95] is the sub-list for method output_type
	55, // [55:75] is the sub-list for method input_type
	55, // [55:55] is the sub-list for extension type_name
	55, // [55:55] is the sub-list for extension extendee
	0,  // [0:55] is the sub-list for field type_name
}

func init() { file_google_cloud_translate_v3_translation_service_proto_init() }
func file_google_cloud_translate_v3_translation_service_proto_init() {
	if File_google_cloud_translate_v3_translation_service_proto != nil {
		return
	}
	file_google_cloud_translate_v3_adaptive_mt_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_translate_v3_translation_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TranslateTextGlossaryConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_translation_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TranslateTextRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_translation_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TranslateTextResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_translation_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Translation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_translation_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DetectLanguageRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_translation_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DetectedLanguage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_translation_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DetectLanguageResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_translation_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSupportedLanguagesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_translation_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SupportedLanguages); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_translation_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SupportedLanguage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_translation_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GcsSource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_translation_service_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InputConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_translation_service_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GcsDestination); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_translation_service_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OutputConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_translation_service_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DocumentInputConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_translation_service_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DocumentOutputConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_translation_service_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TranslateDocumentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_translation_service_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DocumentTranslation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_translation_service_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TranslateDocumentResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_translation_service_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchTranslateTextRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_translation_service_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchTranslateMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_translation_service_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchTranslateResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_translation_service_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GlossaryInputConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_translation_service_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Glossary); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_translation_service_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateGlossaryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_translation_service_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetGlossaryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_translation_service_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteGlossaryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_translation_service_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListGlossariesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_translation_service_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListGlossariesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_translation_service_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateGlossaryMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_translation_service_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteGlossaryMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_translation_service_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteGlossaryResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_translation_service_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchTranslateDocumentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_translation_service_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchDocumentInputConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_translation_service_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchDocumentOutputConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_translation_service_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchTranslateDocumentResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_translation_service_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchTranslateDocumentMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_translation_service_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Glossary_LanguageCodePair); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_translation_service_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Glossary_LanguageCodesSet); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_translate_v3_translation_service_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*DetectLanguageRequest_Content)(nil),
	}
	file_google_cloud_translate_v3_translation_service_proto_msgTypes[11].OneofWrappers = []interface{}{
		(*InputConfig_GcsSource)(nil),
	}
	file_google_cloud_translate_v3_translation_service_proto_msgTypes[13].OneofWrappers = []interface{}{
		(*OutputConfig_GcsDestination)(nil),
	}
	file_google_cloud_translate_v3_translation_service_proto_msgTypes[14].OneofWrappers = []interface{}{
		(*DocumentInputConfig_Content)(nil),
		(*DocumentInputConfig_GcsSource)(nil),
	}
	file_google_cloud_translate_v3_translation_service_proto_msgTypes[15].OneofWrappers = []interface{}{
		(*DocumentOutputConfig_GcsDestination)(nil),
	}
	file_google_cloud_translate_v3_translation_service_proto_msgTypes[22].OneofWrappers = []interface{}{
		(*GlossaryInputConfig_GcsSource)(nil),
	}
	file_google_cloud_translate_v3_translation_service_proto_msgTypes[23].OneofWrappers = []interface{}{
		(*Glossary_LanguagePair)(nil),
		(*Glossary_LanguageCodesSet_)(nil),
	}
	file_google_cloud_translate_v3_translation_service_proto_msgTypes[33].OneofWrappers = []interface{}{
		(*BatchDocumentInputConfig_GcsSource)(nil),
	}
	file_google_cloud_translate_v3_translation_service_proto_msgTypes[34].OneofWrappers = []interface{}{
		(*BatchDocumentOutputConfig_GcsDestination)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_translate_v3_translation_service_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   48,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_translate_v3_translation_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_translate_v3_translation_service_proto_depIdxs,
		EnumInfos:         file_google_cloud_translate_v3_translation_service_proto_enumTypes,
		MessageInfos:      file_google_cloud_translate_v3_translation_service_proto_msgTypes,
	}.Build()
	File_google_cloud_translate_v3_translation_service_proto = out.File
	file_google_cloud_translate_v3_translation_service_proto_rawDesc = nil
	file_google_cloud_translate_v3_translation_service_proto_goTypes = nil
	file_google_cloud_translate_v3_translation_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// TranslationServiceClient is the client API for TranslationService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type TranslationServiceClient interface {
	// Translates input text and returns translated text.
	TranslateText(ctx context.Context, in *TranslateTextRequest, opts ...grpc.CallOption) (*TranslateTextResponse, error)
	// Detects the language of text within a request.
	DetectLanguage(ctx context.Context, in *DetectLanguageRequest, opts ...grpc.CallOption) (*DetectLanguageResponse, error)
	// Returns a list of supported languages for translation.
	GetSupportedLanguages(ctx context.Context, in *GetSupportedLanguagesRequest, opts ...grpc.CallOption) (*SupportedLanguages, error)
	// Translates documents in synchronous mode.
	TranslateDocument(ctx context.Context, in *TranslateDocumentRequest, opts ...grpc.CallOption) (*TranslateDocumentResponse, error)
	// Translates a large volume of text in asynchronous batch mode.
	// This function provides real-time output as the inputs are being processed.
	// If caller cancels a request, the partial results (for an input file, it's
	// all or nothing) may still be available on the specified output location.
	//
	// This call returns immediately and you can
	// use google.longrunning.Operation.name to poll the status of the call.
	BatchTranslateText(ctx context.Context, in *BatchTranslateTextRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Translates a large volume of document in asynchronous batch mode.
	// This function provides real-time output as the inputs are being processed.
	// If caller cancels a request, the partial results (for an input file, it's
	// all or nothing) may still be available on the specified output location.
	//
	// This call returns immediately and you can use
	// google.longrunning.Operation.name to poll the status of the call.
	BatchTranslateDocument(ctx context.Context, in *BatchTranslateDocumentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a glossary and returns the long-running operation. Returns
	// NOT_FOUND, if the project doesn't exist.
	CreateGlossary(ctx context.Context, in *CreateGlossaryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists glossaries in a project. Returns NOT_FOUND, if the project doesn't
	// exist.
	ListGlossaries(ctx context.Context, in *ListGlossariesRequest, opts ...grpc.CallOption) (*ListGlossariesResponse, error)
	// Gets a glossary. Returns NOT_FOUND, if the glossary doesn't
	// exist.
	GetGlossary(ctx context.Context, in *GetGlossaryRequest, opts ...grpc.CallOption) (*Glossary, error)
	// Deletes a glossary, or cancels glossary construction
	// if the glossary isn't created yet.
	// Returns NOT_FOUND, if the glossary doesn't exist.
	DeleteGlossary(ctx context.Context, in *DeleteGlossaryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates an Adaptive MT dataset.
	CreateAdaptiveMtDataset(ctx context.Context, in *CreateAdaptiveMtDatasetRequest, opts ...grpc.CallOption) (*AdaptiveMtDataset, error)
	// Deletes an Adaptive MT dataset, including all its entries and associated
	// metadata.
	DeleteAdaptiveMtDataset(ctx context.Context, in *DeleteAdaptiveMtDatasetRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Gets the Adaptive MT dataset.
	GetAdaptiveMtDataset(ctx context.Context, in *GetAdaptiveMtDatasetRequest, opts ...grpc.CallOption) (*AdaptiveMtDataset, error)
	// Lists all Adaptive MT datasets for which the caller has read permission.
	ListAdaptiveMtDatasets(ctx context.Context, in *ListAdaptiveMtDatasetsRequest, opts ...grpc.CallOption) (*ListAdaptiveMtDatasetsResponse, error)
	// Translate text using Adaptive MT.
	AdaptiveMtTranslate(ctx context.Context, in *AdaptiveMtTranslateRequest, opts ...grpc.CallOption) (*AdaptiveMtTranslateResponse, error)
	// Gets and AdaptiveMtFile
	GetAdaptiveMtFile(ctx context.Context, in *GetAdaptiveMtFileRequest, opts ...grpc.CallOption) (*AdaptiveMtFile, error)
	// Deletes an AdaptiveMtFile along with its sentences.
	DeleteAdaptiveMtFile(ctx context.Context, in *DeleteAdaptiveMtFileRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Imports an AdaptiveMtFile and adds all of its sentences into the
	// AdaptiveMtDataset.
	ImportAdaptiveMtFile(ctx context.Context, in *ImportAdaptiveMtFileRequest, opts ...grpc.CallOption) (*ImportAdaptiveMtFileResponse, error)
	// Lists all AdaptiveMtFiles associated to an AdaptiveMtDataset.
	ListAdaptiveMtFiles(ctx context.Context, in *ListAdaptiveMtFilesRequest, opts ...grpc.CallOption) (*ListAdaptiveMtFilesResponse, error)
	// Lists all AdaptiveMtSentences under a given file/dataset.
	ListAdaptiveMtSentences(ctx context.Context, in *ListAdaptiveMtSentencesRequest, opts ...grpc.CallOption) (*ListAdaptiveMtSentencesResponse, error)
}

type translationServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewTranslationServiceClient(cc grpc.ClientConnInterface) TranslationServiceClient {
	return &translationServiceClient{cc}
}

func (c *translationServiceClient) TranslateText(ctx context.Context, in *TranslateTextRequest, opts ...grpc.CallOption) (*TranslateTextResponse, error) {
	out := new(TranslateTextResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.translation.v3.TranslationService/TranslateText", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) DetectLanguage(ctx context.Context, in *DetectLanguageRequest, opts ...grpc.CallOption) (*DetectLanguageResponse, error) {
	out := new(DetectLanguageResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.translation.v3.TranslationService/DetectLanguage", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) GetSupportedLanguages(ctx context.Context, in *GetSupportedLanguagesRequest, opts ...grpc.CallOption) (*SupportedLanguages, error) {
	out := new(SupportedLanguages)
	err := c.cc.Invoke(ctx, "/google.cloud.translation.v3.TranslationService/GetSupportedLanguages", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) TranslateDocument(ctx context.Context, in *TranslateDocumentRequest, opts ...grpc.CallOption) (*TranslateDocumentResponse, error) {
	out := new(TranslateDocumentResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.translation.v3.TranslationService/TranslateDocument", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) BatchTranslateText(ctx context.Context, in *BatchTranslateTextRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.translation.v3.TranslationService/BatchTranslateText", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) BatchTranslateDocument(ctx context.Context, in *BatchTranslateDocumentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.translation.v3.TranslationService/BatchTranslateDocument", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) CreateGlossary(ctx context.Context, in *CreateGlossaryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.translation.v3.TranslationService/CreateGlossary", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) ListGlossaries(ctx context.Context, in *ListGlossariesRequest, opts ...grpc.CallOption) (*ListGlossariesResponse, error) {
	out := new(ListGlossariesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.translation.v3.TranslationService/ListGlossaries", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) GetGlossary(ctx context.Context, in *GetGlossaryRequest, opts ...grpc.CallOption) (*Glossary, error) {
	out := new(Glossary)
	err := c.cc.Invoke(ctx, "/google.cloud.translation.v3.TranslationService/GetGlossary", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) DeleteGlossary(ctx context.Context, in *DeleteGlossaryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.translation.v3.TranslationService/DeleteGlossary", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) CreateAdaptiveMtDataset(ctx context.Context, in *CreateAdaptiveMtDatasetRequest, opts ...grpc.CallOption) (*AdaptiveMtDataset, error) {
	out := new(AdaptiveMtDataset)
	err := c.cc.Invoke(ctx, "/google.cloud.translation.v3.TranslationService/CreateAdaptiveMtDataset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) DeleteAdaptiveMtDataset(ctx context.Context, in *DeleteAdaptiveMtDatasetRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.translation.v3.TranslationService/DeleteAdaptiveMtDataset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) GetAdaptiveMtDataset(ctx context.Context, in *GetAdaptiveMtDatasetRequest, opts ...grpc.CallOption) (*AdaptiveMtDataset, error) {
	out := new(AdaptiveMtDataset)
	err := c.cc.Invoke(ctx, "/google.cloud.translation.v3.TranslationService/GetAdaptiveMtDataset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) ListAdaptiveMtDatasets(ctx context.Context, in *ListAdaptiveMtDatasetsRequest, opts ...grpc.CallOption) (*ListAdaptiveMtDatasetsResponse, error) {
	out := new(ListAdaptiveMtDatasetsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.translation.v3.TranslationService/ListAdaptiveMtDatasets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) AdaptiveMtTranslate(ctx context.Context, in *AdaptiveMtTranslateRequest, opts ...grpc.CallOption) (*AdaptiveMtTranslateResponse, error) {
	out := new(AdaptiveMtTranslateResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.translation.v3.TranslationService/AdaptiveMtTranslate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) GetAdaptiveMtFile(ctx context.Context, in *GetAdaptiveMtFileRequest, opts ...grpc.CallOption) (*AdaptiveMtFile, error) {
	out := new(AdaptiveMtFile)
	err := c.cc.Invoke(ctx, "/google.cloud.translation.v3.TranslationService/GetAdaptiveMtFile", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) DeleteAdaptiveMtFile(ctx context.Context, in *DeleteAdaptiveMtFileRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.translation.v3.TranslationService/DeleteAdaptiveMtFile", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) ImportAdaptiveMtFile(ctx context.Context, in *ImportAdaptiveMtFileRequest, opts ...grpc.CallOption) (*ImportAdaptiveMtFileResponse, error) {
	out := new(ImportAdaptiveMtFileResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.translation.v3.TranslationService/ImportAdaptiveMtFile", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) ListAdaptiveMtFiles(ctx context.Context, in *ListAdaptiveMtFilesRequest, opts ...grpc.CallOption) (*ListAdaptiveMtFilesResponse, error) {
	out := new(ListAdaptiveMtFilesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.translation.v3.TranslationService/ListAdaptiveMtFiles", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) ListAdaptiveMtSentences(ctx context.Context, in *ListAdaptiveMtSentencesRequest, opts ...grpc.CallOption) (*ListAdaptiveMtSentencesResponse, error) {
	out := new(ListAdaptiveMtSentencesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.translation.v3.TranslationService/ListAdaptiveMtSentences", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// TranslationServiceServer is the server API for TranslationService service.
type TranslationServiceServer interface {
	// Translates input text and returns translated text.
	TranslateText(context.Context, *TranslateTextRequest) (*TranslateTextResponse, error)
	// Detects the language of text within a request.
	DetectLanguage(context.Context, *DetectLanguageRequest) (*DetectLanguageResponse, error)
	// Returns a list of supported languages for translation.
	GetSupportedLanguages(context.Context, *GetSupportedLanguagesRequest) (*SupportedLanguages, error)
	// Translates documents in synchronous mode.
	TranslateDocument(context.Context, *TranslateDocumentRequest) (*TranslateDocumentResponse, error)
	// Translates a large volume of text in asynchronous batch mode.
	// This function provides real-time output as the inputs are being processed.
	// If caller cancels a request, the partial results (for an input file, it's
	// all or nothing) may still be available on the specified output location.
	//
	// This call returns immediately and you can
	// use google.longrunning.Operation.name to poll the status of the call.
	BatchTranslateText(context.Context, *BatchTranslateTextRequest) (*longrunningpb.Operation, error)
	// Translates a large volume of document in asynchronous batch mode.
	// This function provides real-time output as the inputs are being processed.
	// If caller cancels a request, the partial results (for an input file, it's
	// all or nothing) may still be available on the specified output location.
	//
	// This call returns immediately and you can use
	// google.longrunning.Operation.name to poll the status of the call.
	BatchTranslateDocument(context.Context, *BatchTranslateDocumentRequest) (*longrunningpb.Operation, error)
	// Creates a glossary and returns the long-running operation. Returns
	// NOT_FOUND, if the project doesn't exist.
	CreateGlossary(context.Context, *CreateGlossaryRequest) (*longrunningpb.Operation, error)
	// Lists glossaries in a project. Returns NOT_FOUND, if the project doesn't
	// exist.
	ListGlossaries(context.Context, *ListGlossariesRequest) (*ListGlossariesResponse, error)
	// Gets a glossary. Returns NOT_FOUND, if the glossary doesn't
	// exist.
	GetGlossary(context.Context, *GetGlossaryRequest) (*Glossary, error)
	// Deletes a glossary, or cancels glossary construction
	// if the glossary isn't created yet.
	// Returns NOT_FOUND, if the glossary doesn't exist.
	DeleteGlossary(context.Context, *DeleteGlossaryRequest) (*longrunningpb.Operation, error)
	// Creates an Adaptive MT dataset.
	CreateAdaptiveMtDataset(context.Context, *CreateAdaptiveMtDatasetRequest) (*AdaptiveMtDataset, error)
	// Deletes an Adaptive MT dataset, including all its entries and associated
	// metadata.
	DeleteAdaptiveMtDataset(context.Context, *DeleteAdaptiveMtDatasetRequest) (*emptypb.Empty, error)
	// Gets the Adaptive MT dataset.
	GetAdaptiveMtDataset(context.Context, *GetAdaptiveMtDatasetRequest) (*AdaptiveMtDataset, error)
	// Lists all Adaptive MT datasets for which the caller has read permission.
	ListAdaptiveMtDatasets(context.Context, *ListAdaptiveMtDatasetsRequest) (*ListAdaptiveMtDatasetsResponse, error)
	// Translate text using Adaptive MT.
	AdaptiveMtTranslate(context.Context, *AdaptiveMtTranslateRequest) (*AdaptiveMtTranslateResponse, error)
	// Gets and AdaptiveMtFile
	GetAdaptiveMtFile(context.Context, *GetAdaptiveMtFileRequest) (*AdaptiveMtFile, error)
	// Deletes an AdaptiveMtFile along with its sentences.
	DeleteAdaptiveMtFile(context.Context, *DeleteAdaptiveMtFileRequest) (*emptypb.Empty, error)
	// Imports an AdaptiveMtFile and adds all of its sentences into the
	// AdaptiveMtDataset.
	ImportAdaptiveMtFile(context.Context, *ImportAdaptiveMtFileRequest) (*ImportAdaptiveMtFileResponse, error)
	// Lists all AdaptiveMtFiles associated to an AdaptiveMtDataset.
	ListAdaptiveMtFiles(context.Context, *ListAdaptiveMtFilesRequest) (*ListAdaptiveMtFilesResponse, error)
	// Lists all AdaptiveMtSentences under a given file/dataset.
	ListAdaptiveMtSentences(context.Context, *ListAdaptiveMtSentencesRequest) (*ListAdaptiveMtSentencesResponse, error)
}

// UnimplementedTranslationServiceServer can be embedded to have forward compatible implementations.
type UnimplementedTranslationServiceServer struct {
}

func (*UnimplementedTranslationServiceServer) TranslateText(context.Context, *TranslateTextRequest) (*TranslateTextResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TranslateText not implemented")
}
func (*UnimplementedTranslationServiceServer) DetectLanguage(context.Context, *DetectLanguageRequest) (*DetectLanguageResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DetectLanguage not implemented")
}
func (*UnimplementedTranslationServiceServer) GetSupportedLanguages(context.Context, *GetSupportedLanguagesRequest) (*SupportedLanguages, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSupportedLanguages not implemented")
}
func (*UnimplementedTranslationServiceServer) TranslateDocument(context.Context, *TranslateDocumentRequest) (*TranslateDocumentResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TranslateDocument not implemented")
}
func (*UnimplementedTranslationServiceServer) BatchTranslateText(context.Context, *BatchTranslateTextRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchTranslateText not implemented")
}
func (*UnimplementedTranslationServiceServer) BatchTranslateDocument(context.Context, *BatchTranslateDocumentRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchTranslateDocument not implemented")
}
func (*UnimplementedTranslationServiceServer) CreateGlossary(context.Context, *CreateGlossaryRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateGlossary not implemented")
}
func (*UnimplementedTranslationServiceServer) ListGlossaries(context.Context, *ListGlossariesRequest) (*ListGlossariesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListGlossaries not implemented")
}
func (*UnimplementedTranslationServiceServer) GetGlossary(context.Context, *GetGlossaryRequest) (*Glossary, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGlossary not implemented")
}
func (*UnimplementedTranslationServiceServer) DeleteGlossary(context.Context, *DeleteGlossaryRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteGlossary not implemented")
}
func (*UnimplementedTranslationServiceServer) CreateAdaptiveMtDataset(context.Context, *CreateAdaptiveMtDatasetRequest) (*AdaptiveMtDataset, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAdaptiveMtDataset not implemented")
}
func (*UnimplementedTranslationServiceServer) DeleteAdaptiveMtDataset(context.Context, *DeleteAdaptiveMtDatasetRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAdaptiveMtDataset not implemented")
}
func (*UnimplementedTranslationServiceServer) GetAdaptiveMtDataset(context.Context, *GetAdaptiveMtDatasetRequest) (*AdaptiveMtDataset, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAdaptiveMtDataset not implemented")
}
func (*UnimplementedTranslationServiceServer) ListAdaptiveMtDatasets(context.Context, *ListAdaptiveMtDatasetsRequest) (*ListAdaptiveMtDatasetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAdaptiveMtDatasets not implemented")
}
func (*UnimplementedTranslationServiceServer) AdaptiveMtTranslate(context.Context, *AdaptiveMtTranslateRequest) (*AdaptiveMtTranslateResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AdaptiveMtTranslate not implemented")
}
func (*UnimplementedTranslationServiceServer) GetAdaptiveMtFile(context.Context, *GetAdaptiveMtFileRequest) (*AdaptiveMtFile, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAdaptiveMtFile not implemented")
}
func (*UnimplementedTranslationServiceServer) DeleteAdaptiveMtFile(context.Context, *DeleteAdaptiveMtFileRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAdaptiveMtFile not implemented")
}
func (*UnimplementedTranslationServiceServer) ImportAdaptiveMtFile(context.Context, *ImportAdaptiveMtFileRequest) (*ImportAdaptiveMtFileResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportAdaptiveMtFile not implemented")
}
func (*UnimplementedTranslationServiceServer) ListAdaptiveMtFiles(context.Context, *ListAdaptiveMtFilesRequest) (*ListAdaptiveMtFilesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAdaptiveMtFiles not implemented")
}
func (*UnimplementedTranslationServiceServer) ListAdaptiveMtSentences(context.Context, *ListAdaptiveMtSentencesRequest) (*ListAdaptiveMtSentencesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAdaptiveMtSentences not implemented")
}

func RegisterTranslationServiceServer(s *grpc.Server, srv TranslationServiceServer) {
	s.RegisterService(&_TranslationService_serviceDesc, srv)
}

func _TranslationService_TranslateText_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TranslateTextRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).TranslateText(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.translation.v3.TranslationService/TranslateText",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).TranslateText(ctx, req.(*TranslateTextRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_DetectLanguage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DetectLanguageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).DetectLanguage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.translation.v3.TranslationService/DetectLanguage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).DetectLanguage(ctx, req.(*DetectLanguageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_GetSupportedLanguages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSupportedLanguagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).GetSupportedLanguages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.translation.v3.TranslationService/GetSupportedLanguages",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).GetSupportedLanguages(ctx, req.(*GetSupportedLanguagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_TranslateDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TranslateDocumentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).TranslateDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.translation.v3.TranslationService/TranslateDocument",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).TranslateDocument(ctx, req.(*TranslateDocumentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_BatchTranslateText_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchTranslateTextRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).BatchTranslateText(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.translation.v3.TranslationService/BatchTranslateText",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).BatchTranslateText(ctx, req.(*BatchTranslateTextRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_BatchTranslateDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchTranslateDocumentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).BatchTranslateDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.translation.v3.TranslationService/BatchTranslateDocument",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).BatchTranslateDocument(ctx, req.(*BatchTranslateDocumentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_CreateGlossary_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateGlossaryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).CreateGlossary(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.translation.v3.TranslationService/CreateGlossary",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).CreateGlossary(ctx, req.(*CreateGlossaryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_ListGlossaries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListGlossariesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).ListGlossaries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.translation.v3.TranslationService/ListGlossaries",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).ListGlossaries(ctx, req.(*ListGlossariesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_GetGlossary_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGlossaryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).GetGlossary(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.translation.v3.TranslationService/GetGlossary",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).GetGlossary(ctx, req.(*GetGlossaryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_DeleteGlossary_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteGlossaryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).DeleteGlossary(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.translation.v3.TranslationService/DeleteGlossary",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).DeleteGlossary(ctx, req.(*DeleteGlossaryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_CreateAdaptiveMtDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAdaptiveMtDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).CreateAdaptiveMtDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.translation.v3.TranslationService/CreateAdaptiveMtDataset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).CreateAdaptiveMtDataset(ctx, req.(*CreateAdaptiveMtDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_DeleteAdaptiveMtDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAdaptiveMtDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).DeleteAdaptiveMtDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.translation.v3.TranslationService/DeleteAdaptiveMtDataset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).DeleteAdaptiveMtDataset(ctx, req.(*DeleteAdaptiveMtDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_GetAdaptiveMtDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAdaptiveMtDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).GetAdaptiveMtDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.translation.v3.TranslationService/GetAdaptiveMtDataset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).GetAdaptiveMtDataset(ctx, req.(*GetAdaptiveMtDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_ListAdaptiveMtDatasets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAdaptiveMtDatasetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).ListAdaptiveMtDatasets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.translation.v3.TranslationService/ListAdaptiveMtDatasets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).ListAdaptiveMtDatasets(ctx, req.(*ListAdaptiveMtDatasetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_AdaptiveMtTranslate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AdaptiveMtTranslateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).AdaptiveMtTranslate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.translation.v3.TranslationService/AdaptiveMtTranslate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).AdaptiveMtTranslate(ctx, req.(*AdaptiveMtTranslateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_GetAdaptiveMtFile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAdaptiveMtFileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).GetAdaptiveMtFile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.translation.v3.TranslationService/GetAdaptiveMtFile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).GetAdaptiveMtFile(ctx, req.(*GetAdaptiveMtFileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_DeleteAdaptiveMtFile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAdaptiveMtFileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).DeleteAdaptiveMtFile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.translation.v3.TranslationService/DeleteAdaptiveMtFile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).DeleteAdaptiveMtFile(ctx, req.(*DeleteAdaptiveMtFileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_ImportAdaptiveMtFile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportAdaptiveMtFileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).ImportAdaptiveMtFile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.translation.v3.TranslationService/ImportAdaptiveMtFile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).ImportAdaptiveMtFile(ctx, req.(*ImportAdaptiveMtFileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_ListAdaptiveMtFiles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAdaptiveMtFilesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).ListAdaptiveMtFiles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.translation.v3.TranslationService/ListAdaptiveMtFiles",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).ListAdaptiveMtFiles(ctx, req.(*ListAdaptiveMtFilesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_ListAdaptiveMtSentences_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAdaptiveMtSentencesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).ListAdaptiveMtSentences(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.translation.v3.TranslationService/ListAdaptiveMtSentences",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).ListAdaptiveMtSentences(ctx, req.(*ListAdaptiveMtSentencesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _TranslationService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.translation.v3.TranslationService",
	HandlerType: (*TranslationServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "TranslateText",
			Handler:    _TranslationService_TranslateText_Handler,
		},
		{
			MethodName: "DetectLanguage",
			Handler:    _TranslationService_DetectLanguage_Handler,
		},
		{
			MethodName: "GetSupportedLanguages",
			Handler:    _TranslationService_GetSupportedLanguages_Handler,
		},
		{
			MethodName: "TranslateDocument",
			Handler:    _TranslationService_TranslateDocument_Handler,
		},
		{
			MethodName: "BatchTranslateText",
			Handler:    _TranslationService_BatchTranslateText_Handler,
		},
		{
			MethodName: "BatchTranslateDocument",
			Handler:    _TranslationService_BatchTranslateDocument_Handler,
		},
		{
			MethodName: "CreateGlossary",
			Handler:    _TranslationService_CreateGlossary_Handler,
		},
		{
			MethodName: "ListGlossaries",
			Handler:    _TranslationService_ListGlossaries_Handler,
		},
		{
			MethodName: "GetGlossary",
			Handler:    _TranslationService_GetGlossary_Handler,
		},
		{
			MethodName: "DeleteGlossary",
			Handler:    _TranslationService_DeleteGlossary_Handler,
		},
		{
			MethodName: "CreateAdaptiveMtDataset",
			Handler:    _TranslationService_CreateAdaptiveMtDataset_Handler,
		},
		{
			MethodName: "DeleteAdaptiveMtDataset",
			Handler:    _TranslationService_DeleteAdaptiveMtDataset_Handler,
		},
		{
			MethodName: "GetAdaptiveMtDataset",
			Handler:    _TranslationService_GetAdaptiveMtDataset_Handler,
		},
		{
			MethodName: "ListAdaptiveMtDatasets",
			Handler:    _TranslationService_ListAdaptiveMtDatasets_Handler,
		},
		{
			MethodName: "AdaptiveMtTranslate",
			Handler:    _TranslationService_AdaptiveMtTranslate_Handler,
		},
		{
			MethodName: "GetAdaptiveMtFile",
			Handler:    _TranslationService_GetAdaptiveMtFile_Handler,
		},
		{
			MethodName: "DeleteAdaptiveMtFile",
			Handler:    _TranslationService_DeleteAdaptiveMtFile_Handler,
		},
		{
			MethodName: "ImportAdaptiveMtFile",
			Handler:    _TranslationService_ImportAdaptiveMtFile_Handler,
		},
		{
			MethodName: "ListAdaptiveMtFiles",
			Handler:    _TranslationService_ListAdaptiveMtFiles_Handler,
		},
		{
			MethodName: "ListAdaptiveMtSentences",
			Handler:    _TranslationService_ListAdaptiveMtSentences_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/translate/v3/translation_service.proto",
}
