#!/bin/sh

# Setup env
set -xe
. /environ

# Clone git repository at branch / tag / commit.
REPO='https://github.com/madler/zlib'; TAG='v1.3.1'
git clone "$REPO" --depth=1 --branch="${TAG}" /zlib
cd /zlib

# Configure build parameters.
#
# NOTE: ffmpeg does not support
# 2 versions of the same library
# so only build with 8 bit-depth.
./configure --prefix=/vendor \
            --eprefix=/vendor \
            --static \
|| { cat config.log; exit 1; }

# Perform library install + build.
make -j $(nproc) install
