package main

import (
	"context"
	"os"
	"os/signal"
	"path"
	"strings"
	"syscall"

	"codeberg.org/gruf/go-ffmpreg/ffmpreg"
	"codeberg.org/gruf/go-ffmpreg/wasm"
	"github.com/tetratelabs/wazero"
)

func main() {
	ctx, cncl := signal.NotifyContext(
		context.Background(),
		syscall.SIGINT,
		syscall.SIGTERM,
	)
	defer cncl()

	rc, err := ffmpreg.Run(ctx, wasm.Args{
		Name:   path.Base(os.Args[0]),
		Stdin:  os.Stdin,
		Stdout: os.Stdout,
		Stderr: os.Stderr,
		Args:   os.Args[1:],
		Config: func(cfg wazero.ModuleConfig) wazero.ModuleConfig {
			for _, kv := range os.Environ() {
				i := strings.IndexByte(kv, '=')
				cfg = cfg.WithEnv(kv[:i], kv[i+1:])
			}
			fscfg := wazero.NewFSConfig()
			fscfg = fscfg.WithDirMount("/", "/")
			return cfg.WithFSConfig(fscfg)
		},
	})
	if err != nil {
		panic(err)
	}

	os.Exit(int(rc))
}
