/*
   exif-terminator
   Copyright (C) 2022 SuperSeriousBusiness admin@gotosocial.org

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU Affero General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Affero General Public License for more details.

   You should have received a copy of the GNU Affero General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

package main

import (
	"fmt"
	"io"
	"os"
	"path"
	"strings"

	terminator "codeberg.org/superseriousbusiness/exif-terminator"
)

var images = []string{
	"sloth.jpg",
	"comic.png",
	"exif-panorama.jpg",
	"fish.png",
	"giant-turnip-world-record.jpg",
	"kitten.jpg",
	"pjw.webp",
	"recipe.jpg",
}

func main() {
	for _, name := range images {
		filepath := path.Join("./images", name)
		ext := strings.TrimPrefix(path.Ext(name), ".")
		fmt.Println("opening:", filepath)

		// open a file
		file, err := os.Open(filepath)
		if err != nil {
			panic(err)
		}
		defer file.Close()

		// terminate!
		fmt.Println("terminating:", filepath)
		out, err := terminator.Terminate(file, ext)
		if err != nil {
			panic(err)
		}

		// read the bytes from the reader
		b, err := io.ReadAll(out)
		if err != nil {
			panic(err)
		}

		name = strings.Replace(name, ".", "-clean.", 1)
		filepath = path.Join("./images", name)
		fmt.Println("writing to:", filepath)

		// save the file somewhere
		if err := os.WriteFile(filepath, b, 0666); err != nil {
			panic(err)
		}

	}
}
