// Code generated by go-swagger; DO NOT EDIT.

// Package restapi Composing authorizations
//
//	This sample API demonstrates how to compose several authentication schemes
//	and configure complex security requirements for your operations.
//
//	This API simulates a very simple market place with customers and resellers
//	of items.
//
//	Personas:
//	  - as a first time user, I want to see all items on sales
//	  - as a registered customer, I want to post orders for items and
//	    consult my past orders
//	  - as a registered reseller, I want to see all pending orders on the items
//	    I am selling on the market place
//	  - as a reseller managing my own inventories, I want to post replenishment orders for the items I provide
//	  - as a register user, I want to consult my personal account infos
//
//	The situation we defined on the authentication side is as follows:
//	  - every known user is authenticated using a basic token
//	  - resellers are authenticated using API keys - we let the option to authenticate using a header or query param
//	  - any registered user (customer or reseller) will add a signed JWT to access more API endpoints
//
//	Obviously, there are several ways to achieve the same result. We just wanted to demonstrate here how
//	security requirements may compose several schemes.
//
//	Note that we used the "OAuth2" declaration here but don't implement a real
//	OAuth2 workflow: our intend here is just to be able to extract scopes from a passed JWT token (the
//	only way to manipulate scoped authorizers with Swagger 2.0 is to declare them with type "oauth2").
//
//	Schemes:
//	  http
//	Host: localhost
//	BasePath: /api
//	Version: 0.0.1
//
//	Consumes:
//	  - application/json
//
//	Produces:
//	  - application/json
//
// swagger:meta
package restapi
