[Full Changelog](https://github.com/go-swagger/go-swagger/compare/0.5.0...0.6.0)

**Implemented enhancements:**

- \[BREAKING\] Changes the decision for a pointer, required fields are now pointers, `x-nullable: false` restores the old behavior.
- CLI options to define HTTP/HTTPS protocol schema in generated server code. [\#587](https://github.com/go-swagger/go-swagger/issues/587)
- Generating spec for response without nested struct [\#446](https://github.com/go-swagger/go-swagger/issues/446)
- \[BREAKING\] Move most of it under the open apis org [\#188](https://github.com/go-swagger/go-swagger/issues/188)
- x-nullable: false doesn't affect required values [\#458](https://github.com/go-swagger/go-swagger/issues/458)
- Refactor package structures [\#420](https://github.com/go-swagger/go-swagger/issues/420)

**Fixed bugs:**

- Code gen: The go generate comment is missing required parameters [\#611](https://github.com/go-swagger/go-swagger/issues/611)
- Generated client panics trying to type-assert required string parameter [\#546](https://github.com/go-swagger/go-swagger/issues/546)
- Build failure when using principal flag. [\#544](https://github.com/go-swagger/go-swagger/issues/544)
- Code generated from spec file does not compile [\#540](https://github.com/go-swagger/go-swagger/issues/540)
- Add size variable init when slice size needs to be checked. [\#570](https://github.com/go-swagger/go-swagger/pull/570) ([vburenin](https://github.com/vburenin))
- No validator code call for array items if they are other models. [\#524](https://github.com/go-swagger/go-swagger/issues/524)
- escaped slashes in path ids are incorrectly decoded [\#522](https://github.com/go-swagger/go-swagger/issues/522)
- Multipart form generates unnecessary variable that lead to compile error [\#511](https://github.com/go-swagger/go-swagger/issues/511)
- Negotiated content type producer uses DefaultProduces even when matched route does not have a "produces" for that type. [\#499](https://github.com/go-swagger/go-swagger/issues/499)
- Recursive definition causes stack overflow [\#483](https://github.com/go-swagger/go-swagger/issues/483)
- Fail and log on errors adding user-defined CLI flags [\#470](https://github.com/go-swagger/go-swagger/issues/470)
- Specification basePath is not respected [\#465](https://github.com/go-swagger/go-swagger/issues/465)
- Incorrect case in generated model code referencing model name [\#460](https://github.com/go-swagger/go-swagger/issues/460)
- Presence of required nested object is not validated [\#455](https://github.com/go-swagger/go-swagger/issues/455)
- Incorrectly generated Marshaller causes unlimited recursive Marshal calls [\#454](https://github.com/go-swagger/go-swagger/issues/454)
- Optional nested objects are not validated [\#453](https://github.com/go-swagger/go-swagger/issues/453)
- Swagger generate oauth2 scope [\#449](https://github.com/go-swagger/go-swagger/issues/449)
- Panic on form validation for mutlipart upload [\#438](https://github.com/go-swagger/go-swagger/issues/438)
- x-www-form-urlencoded cannot be consumed in go-swagger 0.5.x [\#433](https://github.com/go-swagger/go-swagger/issues/433)
- Incorrect unmarshal code generated for polymorphic object parent [\#423](https://github.com/go-swagger/go-swagger/issues/423)

**Closed issues:**

- Rename Mutli-Status to Multi-Status [\#640](https://github.com/go-swagger/go-swagger/issues/640)
- Array property of payload not being included in response body [\#638](https://github.com/go-swagger/go-swagger/issues/638)
- godep not vendoring go-swagger package to API package [\#635](https://github.com/go-swagger/go-swagger/issues/635)
- Generated server returns error code when invoked with "-h" or "--help" [\#630](https://github.com/go-swagger/go-swagger/issues/630)
- Error while updating dependencies [\#627](https://github.com/go-swagger/go-swagger/issues/627)
- Generated code validation [\#625](https://github.com/go-swagger/go-swagger/issues/625)
- Generate spec looks up types in wrong package if there are several of the same name [\#608](https://github.com/go-swagger/go-swagger/issues/608)
- Add support for MapType in parseIdentProperty [\#601](https://github.com/go-swagger/go-swagger/issues/601)
- Code generator emits two variants of strfmt [\#598](https://github.com/go-swagger/go-swagger/issues/598)
- Add the ability to use a model as a response Body. [\#595](https://github.com/go-swagger/go-swagger/issues/595)
- accept header is invalid [\#586](https://github.com/go-swagger/go-swagger/issues/586)
- missing swag import [\#580](https://github.com/go-swagger/go-swagger/issues/580)
- --skip-struct outputs blank files [\#575](https://github.com/go-swagger/go-swagger/issues/575)
- Command Line Flags example [\#572](https://github.com/go-swagger/go-swagger/issues/572)
- swagger validate swgger.yml fail when I follow Todo-List tutorial [\#571](https://github.com/go-swagger/go-swagger/issues/571)
- No way of avoiding generating validations [\#568](https://github.com/go-swagger/go-swagger/issues/568)
- Embedding anonymous pointer causes error [\#563](https://github.com/go-swagger/go-swagger/issues/563)
- All Go builtin types should be supported [\#560](https://github.com/go-swagger/go-swagger/issues/560)
- swagger error, during import spc doc into swagger editor [\#555](https://github.com/go-swagger/go-swagger/issues/555)
- No access to original HTTP request in GET request [\#550](https://github.com/go-swagger/go-swagger/issues/550)
- DELETE operation with no body returns 415 unsupported media [\#548](https://github.com/go-swagger/go-swagger/issues/548)
- todolist example fails to compile. Also the generated and the example code has different imports, which is strange [\#538](https://github.com/go-swagger/go-swagger/issues/538)
- Question: usage with react using the fetch api is supported [\#531](https://github.com/go-swagger/go-swagger/issues/531)
- File downloads [\#515](https://github.com/go-swagger/go-swagger/issues/515)
- Swagger generate spec paths [\#510](https://github.com/go-swagger/go-swagger/issues/510)
- Add new param type: json [\#140](https://github.com/go-swagger/go-swagger/issues/140)
- Using user defined logger instead of fmt.Printf [\#528](https://github.com/go-swagger/go-swagger/issues/528)
- where is the spec validator tested [\#525](https://github.com/go-swagger/go-swagger/issues/525)
- Integer enum validation always fail [\#523](https://github.com/go-swagger/go-swagger/issues/523)
- Skip parameter fields with json tag `json:"-"` [\#520](https://github.com/go-swagger/go-swagger/issues/520)
- Typo multipart/form-data as "Mulitpart" [\#518](https://github.com/go-swagger/go-swagger/issues/518)
- Generate models for internal use only [\#516](https://github.com/go-swagger/go-swagger/issues/516)
- Parameters template bug leads to errors in header validation [\#494](https://github.com/go-swagger/go-swagger/issues/494)
- types don't match: expect map key string or int get: bool [\#490](https://github.com/go-swagger/go-swagger/issues/490)
- go swagger generated code is not fully golint-able [\#487](https://github.com/go-swagger/go-swagger/issues/487)
- Validator treats array in example as invalid data [\#478](https://github.com/go-swagger/go-swagger/issues/478)
- Unnecessary "required" validation for array items [\#472](https://github.com/go-swagger/go-swagger/issues/472)
- Add hints for the type names generated by swagger [\#471](https://github.com/go-swagger/go-swagger/issues/471)
- go-swagger v0.5.0 - cannot find package "golang.org/x/tools/go/buildutil" [\#434](https://github.com/go-swagger/go-swagger/issues/434)
- Add a configuration layer for TLS. [\#430](https://github.com/go-swagger/go-swagger/issues/430)

**Merged pull requests:**

- Issue with embedded custom type [\#646](https://github.com/go-swagger/go-swagger/pull/646) ([gaplyk](https://github.com/gaplyk))
- fix http status code mapping from internal [\#645](https://github.com/go-swagger/go-swagger/pull/645) ([casualjim](https://github.com/casualjim))
- update deps [\#644](https://github.com/go-swagger/go-swagger/pull/644) ([casualjim](https://github.com/casualjim))
- Tests for issue with maps [\#642](https://github.com/go-swagger/go-swagger/pull/642) ([gaplyk](https://github.com/gaplyk))
- fix issue with map type [\#641](https://github.com/go-swagger/go-swagger/pull/641) ([gaplyk](https://github.com/gaplyk))
- Fix scopes to be initialized to an empty array [\#637](https://github.com/go-swagger/go-swagger/pull/637) ([losinggeneration](https://github.com/losinggeneration))
- Scan package [\#633](https://github.com/go-swagger/go-swagger/pull/633) ([casualjim](https://github.com/casualjim))
- Runtime listeners [\#632](https://github.com/go-swagger/go-swagger/pull/632) ([casualjim](https://github.com/casualjim))
- Dont error w/1 just b/c user asked for help text [\#631](https://github.com/go-swagger/go-swagger/pull/631) ([nelz9999](https://github.com/nelz9999))
- revert changes to CLI params [\#629](https://github.com/go-swagger/go-swagger/pull/629) ([casualjim](https://github.com/casualjim))
- Refactor JSON tag parsing [\#621](https://github.com/go-swagger/go-swagger/pull/621) ([bfirsh](https://github.com/bfirsh))
- Fixed copy-pasted description. [\#620](https://github.com/go-swagger/go-swagger/pull/620) ([vburenin](https://github.com/vburenin))
- Support json tags which don't set name [\#617](https://github.com/go-swagger/go-swagger/pull/617) ([bfirsh](https://github.com/bfirsh))
- update readme \[ci skip\] [\#615](https://github.com/go-swagger/go-swagger/pull/615) ([casualjim](https://github.com/casualjim))
- Resolve vendor [\#614](https://github.com/go-swagger/go-swagger/pull/614) ([casualjim](https://github.com/casualjim))
- Unified CLI for go swagger.  [\#612](https://github.com/go-swagger/go-swagger/pull/612) ([vburenin](https://github.com/vburenin))
- Don't include indirection for interface types. [\#609](https://github.com/go-swagger/go-swagger/pull/609) ([Cl0udPhish](https://github.com/Cl0udPhish))
- Gitbook \[ci skip\] [\#603](https://github.com/go-swagger/go-swagger/pull/603) ([casualjim](https://github.com/casualjim))
- handle aliased types in scanner [\#602](https://github.com/go-swagger/go-swagger/pull/602) ([casualjim](https://github.com/casualjim))
- Add the ability to use a model as a response. [\#596](https://github.com/go-swagger/go-swagger/pull/596) ([jjeffrey-bolste](https://github.com/jjeffrey-bolste))
- Update spec repo [\#584](https://github.com/go-swagger/go-swagger/pull/584) ([casualjim](https://github.com/casualjim))
- suffix validator only model generation with \_validator [\#579](https://github.com/go-swagger/go-swagger/pull/579) ([casualjim](https://github.com/casualjim))
- Expose server handler which can be used for writing tests [\#577](https://github.com/go-swagger/go-swagger/pull/577) ([xiwenc](https://github.com/xiwenc))
- actually render something [\#576](https://github.com/go-swagger/go-swagger/pull/576) ([casualjim](https://github.com/casualjim))
- adds support for skip-struct on generate model [\#574](https://github.com/go-swagger/go-swagger/pull/574) ([casualjim](https://github.com/casualjim))
- Command Line Flags Example [\#573](https://github.com/go-swagger/go-swagger/pull/573) ([nelz9999](https://github.com/nelz9999))
- make validations optional for "generate model" command [\#569](https://github.com/go-swagger/go-swagger/pull/569) ([casualjim](https://github.com/casualjim))
- fixes \#546, text no panic in marshaller for string pointer [\#567](https://github.com/go-swagger/go-swagger/pull/567) ([casualjim](https://github.com/casualjim))
- wrap typed auth functions into function that returns an interface [\#566](https://github.com/go-swagger/go-swagger/pull/566) ([casualjim](https://github.com/casualjim))
- fixes \#515, support streaming responses in the client [\#565](https://github.com/go-swagger/go-swagger/pull/565) ([casualjim](https://github.com/casualjim))
- Fix issue \#563 Added StarExpr in parseEmbeddedType [\#564](https://github.com/go-swagger/go-swagger/pull/564) ([zasran](https://github.com/zasran))
- Fix issue \#560 Go builtin support [\#562](https://github.com/go-swagger/go-swagger/pull/562) ([zasran](https://github.com/zasran))
- fixes \#550 always render and use parameters [\#558](https://github.com/go-swagger/go-swagger/pull/558) ([casualjim](https://github.com/casualjim))
- fixes yml for todolist example [\#556](https://github.com/go-swagger/go-swagger/pull/556) ([casualjim](https://github.com/casualjim))
- adds jlexer and jwriter from easyjson [\#553](https://github.com/go-swagger/go-swagger/pull/553) ([casualjim](https://github.com/casualjim))
- adds bitset library [\#552](https://github.com/go-swagger/go-swagger/pull/552) ([casualjim](https://github.com/casualjim))
- update go-flags [\#551](https://github.com/go-swagger/go-swagger/pull/551) ([casualjim](https://github.com/casualjim))
- make request timeout configurable for client [\#534](https://github.com/go-swagger/go-swagger/pull/534) ([casualjim](https://github.com/casualjim))
- Release 0.5.9 [\#532](https://github.com/go-swagger/go-swagger/pull/532) ([casualjim](https://github.com/casualjim))
- Added possibility for users to defined their custom logger. [\#529](https://github.com/go-swagger/go-swagger/pull/529) ([vburenin](https://github.com/vburenin))
- update vendored packages [\#527](https://github.com/go-swagger/go-swagger/pull/527) ([casualjim](https://github.com/casualjim))
- Fixed bug for not generated validator call if there is an array of complex objects. [\#526](https://github.com/go-swagger/go-swagger/pull/526) ([vburenin](https://github.com/vburenin))
- skip fields in parameter structs with struct tag `json:"-"` [\#521](https://github.com/go-swagger/go-swagger/pull/521) ([jlburkhead](https://github.com/jlburkhead))
- Fix typo mulit vs multi [\#519](https://github.com/go-swagger/go-swagger/pull/519) ([fiorix](https://github.com/fiorix))
- add support for oauth2 to generator [\#517](https://github.com/go-swagger/go-swagger/pull/517) ([casualjim](https://github.com/casualjim))
- fail on invalid command line definition [\#514](https://github.com/go-swagger/go-swagger/pull/514) ([casualjim](https://github.com/casualjim))
- remove unused param var [\#513](https://github.com/go-swagger/go-swagger/pull/513) ([casualjim](https://github.com/casualjim))
- update context, imports, swag, runtime, loads and govalidator [\#512](https://github.com/go-swagger/go-swagger/pull/512) ([casualjim](https://github.com/casualjim))
- Add support for strfmt.MAC [\#509](https://github.com/go-swagger/go-swagger/pull/509) ([tzneal](https://github.com/tzneal))
- Put params fix [\#508](https://github.com/go-swagger/go-swagger/pull/508) ([ivan1993spb](https://github.com/ivan1993spb))
- Added missing wait for the client generator. [\#507](https://github.com/go-swagger/go-swagger/pull/507) ([casualjim](https://github.com/casualjim))
- Leveraging Go goroutings to speed up generation process in multicore environment. [\#504](https://github.com/go-swagger/go-swagger/pull/504) ([vburenin](https://github.com/vburenin))
- Removed redundant code. Less JSON parsing. Speedups on many things in… [\#503](https://github.com/go-swagger/go-swagger/pull/503) ([vburenin](https://github.com/vburenin))
- Combined fix of 453 and 455 bugs. [\#502](https://github.com/go-swagger/go-swagger/pull/502) ([vburenin](https://github.com/vburenin))
- Prevents parsing structs that are needed when parsing dicovered schemas [\#498](https://github.com/go-swagger/go-swagger/pull/498) ([seanbrant](https://github.com/seanbrant))
- Add missed go code generation for \#494 [\#497](https://github.com/go-swagger/go-swagger/pull/497) ([galaxie](https://github.com/galaxie))
- Use canonicalized keys to retrieve values from http.Request.Header [\#495](https://github.com/go-swagger/go-swagger/pull/495) ([galaxie](https://github.com/galaxie))
- Pascalize method arguments in client operations - fixes \#487 [\#488](https://github.com/go-swagger/go-swagger/pull/488) ([MStoykov](https://github.com/MStoykov))
- 420 package refactor [\#486](https://github.com/go-swagger/go-swagger/pull/486) ([casualjim](https://github.com/casualjim))
- move analysis out of spec package [\#485](https://github.com/go-swagger/go-swagger/pull/485) ([casualjim](https://github.com/casualjim))
- generator: Use a JSON decoder with UseNumber enabled for unmarshaling [\#482](https://github.com/go-swagger/go-swagger/pull/482) ([chancez](https://github.com/chancez))
- updates unmarshal for discriminated types as property [\#480](https://github.com/go-swagger/go-swagger/pull/480) ([casualjim](https://github.com/casualjim))
- second part of bugfix [\#479](https://github.com/go-swagger/go-swagger/pull/479) ([casualjim](https://github.com/casualjim))
- validate items more often [\#475](https://github.com/go-swagger/go-swagger/pull/475) ([casualjim](https://github.com/casualjim))
- Use cache as it is designed to be used, not as it is actually used. [\#474](https://github.com/go-swagger/go-swagger/pull/474) ([vburenin](https://github.com/vburenin))
- Required flag is reset for array items. [\#473](https://github.com/go-swagger/go-swagger/pull/473) ([vburenin](https://github.com/vburenin))
- fix appveyor builds [\#468](https://github.com/go-swagger/go-swagger/pull/468) ([casualjim](https://github.com/casualjim))
- generator: fix package assumption on server generation [\#467](https://github.com/go-swagger/go-swagger/pull/467) ([jwmaag](https://github.com/jwmaag))
- Use spec BasePath when it is non-empty. [\#466](https://github.com/go-swagger/go-swagger/pull/466) ([nikhilm](https://github.com/nikhilm))
- fix some issues with additional properties generation [\#461](https://github.com/go-swagger/go-swagger/pull/461) ([casualjim](https://github.com/casualjim))
- X nullable first [\#459](https://github.com/go-swagger/go-swagger/pull/459) ([vburenin](https://github.com/vburenin))
- Fix https://github.com/go-swagger/go-swagger/issues/449 [\#451](https://github.com/go-swagger/go-swagger/pull/451) ([galeone](https://github.com/galeone))
- Add validation required fix and corresponding package tests [\#450](https://github.com/go-swagger/go-swagger/pull/450) ([galaxie](https://github.com/galaxie))
- Fixed bug in httpkit/client/runtime.go Submit\(\) [\#448](https://github.com/go-swagger/go-swagger/pull/448) ([ritchida](https://github.com/ritchida))
- also exclude models/handlers in the client [\#447](https://github.com/go-swagger/go-swagger/pull/447) ([casualjim](https://github.com/casualjim))
- add discard consumer/producer for http mimes [\#443](https://github.com/go-swagger/go-swagger/pull/443) ([casualjim](https://github.com/casualjim))
- add note to readme about homebrew package [\#441](https://github.com/go-swagger/go-swagger/pull/441) ([casualjim](https://github.com/casualjim))
- Fix typo \(defintion -\> definition\) [\#440](https://github.com/go-swagger/go-swagger/pull/440) ([flavioribeiro](https://github.com/flavioribeiro))
- Improve error message [\#437](https://github.com/go-swagger/go-swagger/pull/437) ([abclogin](https://github.com/abclogin))
- Bring back build util [\#435](https://github.com/go-swagger/go-swagger/pull/435) ([casualjim](https://github.com/casualjim))
- Added user hook to config TLS layer. [\#432](https://github.com/go-swagger/go-swagger/pull/432) ([vburenin](https://github.com/vburenin))
- \[wip\] once and for all work out the rules for pointing to things [\#431](https://github.com/go-swagger/go-swagger/pull/431) ([casualjim](https://github.com/casualjim))
- disables code coverage for automated builds for a while [\#429](https://github.com/go-swagger/go-swagger/pull/429) ([casualjim](https://github.com/casualjim))
- Fixes some issues with empty bodies [\#428](https://github.com/go-swagger/go-swagger/pull/428) ([casualjim](https://github.com/casualjim))
- Improve error message [\#427](https://github.com/go-swagger/go-swagger/pull/427) ([abclogin](https://github.com/abclogin))
- fix default produces [\#424](https://github.com/go-swagger/go-swagger/pull/424) ([casualjim](https://github.com/casualjim))
- increase circle ci default timeout [\#419](https://github.com/go-swagger/go-swagger/pull/419) ([pytlesk4](https://github.com/pytlesk4))
