# `rq --help`

*[back to index](./README.md)*

```
Usage: rq <command>

A CLI tool for running Rego Queries

Flags:
  -h, --help    Show context-sensitive help.

Commands:
  query [<query>]
    Run a Rego Query

  list-formats
    List supported input/output formats and exit

  script [<file> [<args> ...]]
    Run a Rego file as a script

  version
    Print version information and exit

  capabilities
    Access OPA capabilities information.

Run "rq <command> --help" for more information on a command.
```

## `rq query --help`

```
Usage: rq query [<query>]

Run a Rego Query

Arguments:
  [<query>]    Rego Query

Flags:
  -h, --help                  Show context-sensitive help.

  -I, --input=STRING          Specify an input data source in the same format
                              as --data. If the path is empty, data is read from
                              standard in. The default is to read from standard
                              in. Options expressed this way take precedence
                              over options provided on the CLI.
  -p, --in-place=STRING       Similar to --input, but also sets --output to the
                              same file, to simplify modifying files in-place.
  -i, --input-format=""       Choose the format the input data should be parsed
                              as. The empty string is treated as 'json'.
  -O, --output=STRING         Specify an output datasources, as with --input.
  -o, --output-format=""      Choose the format the output data should be
                              emitted in. The empty string is treated as 'json'.
      --no-tty-check          Disable checking if the input or output is a TTY.
                              When this flag is asserted, rq will not bail out
                              early when standard in is a TTY, and also won't
                              disable colorization if standard out is not a TTY.
      --no-color              Disable colorizing output in any circumstance.
                              Takes precedence over --force-color.
      --force-color           Where possible, color output, even if the output
                              is not a TTY.
      --ugly                  Disable pretty-printing output.
      --indent="\t"           Override the character(s) used for indentation.
      --style="native"        The Chroma style to use for colorized output, see:
                              https://xyproto.github.io/splash/docs/
  -D, --csv-comma=""          Delimiter to use when parsing CSV input files.
      --csv-comment=""        Comment character to use when parsing CSV input
                              files.
      --csv-skip-lines=0      Number of leading lines to skip when parsing CSV
                              input files.
  -H, --csv-headers           Treat the first row of the CSV file as headers.
      --csv-no-infer          Disable automatic type inference for CSV fields.
      --profile               enable runtime CPU profiling
  -d, --data=DATA             List of files to load into the 'data' package.
                              You can prefix the path with '<format>:' where
                              <format> is one of the formats -i knows about.
                              The file data is loaded into data.<file
                              base name> unless you prefix the path with
                              'some.rego.path='. If you want to specify both,
                              the format goes first. Example: '--data
                              yaml:data.foo.bar=/some/path'.
  -b, --bundle=BUNDLE,...     Paths to bundle files or directories to load into
                              Rego directly. This is equivalent to 'opa eval
                              --bundle/-b'.
  -R, --raw                   Shorthand for -o raw. Takes precedence over -o.
  -s, --save-bundle=STRING    Rather than executing the query, save all data and
                              Rego modules to the specified path, overwriting
                              any file that's already there.
  -t, --template=STRING       Template string to use as output.template. Also
                              implies -o template. The same template functions
                              are available as with the rq.template() builtin.
```

## `rq script --help`

```
Usage: rq script [<file> [<args> ...]]

Run a Rego file as a script

Arguments:
  [<file>]        Rego Script
  [<args> ...]    Arguments to expose to the script via rq.args().

Flags:
  -h, --help                  Show context-sensitive help.

  -I, --input=STRING          Specify an input data source in the same format
                              as --data. If the path is empty, data is read from
                              standard in. The default is to read from standard
                              in. Options expressed this way take precedence
                              over options provided on the CLI.
  -p, --in-place=STRING       Similar to --input, but also sets --output to the
                              same file, to simplify modifying files in-place.
  -i, --input-format=""       Choose the format the input data should be parsed
                              as. The empty string is treated as 'json'.
  -O, --output=STRING         Specify an output datasources, as with --input.
  -o, --output-format=""      Choose the format the output data should be
                              emitted in. The empty string is treated as 'json'.
      --no-tty-check          Disable checking if the input or output is a TTY.
                              When this flag is asserted, rq will not bail out
                              early when standard in is a TTY, and also won't
                              disable colorization if standard out is not a TTY.
      --no-color              Disable colorizing output in any circumstance.
                              Takes precedence over --force-color.
      --force-color           Where possible, color output, even if the output
                              is not a TTY.
      --ugly                  Disable pretty-printing output.
      --indent="\t"           Override the character(s) used for indentation.
      --style="native"        The Chroma style to use for colorized output, see:
                              https://xyproto.github.io/splash/docs/
  -D, --csv-comma=""          Delimiter to use when parsing CSV input files.
      --csv-comment=""        Comment character to use when parsing CSV input
                              files.
      --csv-skip-lines=0      Number of leading lines to skip when parsing CSV
                              input files.
  -H, --csv-headers           Treat the first row of the CSV file as headers.
      --csv-no-infer          Disable automatic type inference for CSV fields.
      --profile               enable runtime CPU profiling
  -d, --data=DATA             List of files to load into the 'data' package.
                              You can prefix the path with '<format>:' where
                              <format> is one of the formats -i knows about.
                              The file data is loaded into data.<file
                              base name> unless you prefix the path with
                              'some.rego.path='. If you want to specify both,
                              the format goes first. Example: '--data
                              yaml:data.foo.bar=/some/path'.
  -b, --bundle=BUNDLE,...     Paths to bundle files or directories to load into
                              Rego directly. This is equivalent to 'opa eval
                              --bundle/-b'.
  -R, --raw                   Shorthand for -o raw. Takes precedence over -o.
  -s, --save-bundle=STRING    Rather than executing the query, save all data and
                              Rego modules to the specified path, overwriting
                              any file that's already there.
  -t, --template=STRING       Template string to use as output.template. Also
                              implies -o template. The same template functions
                              are available as with the rq.template() builtin.
```

## `rq version --help`

```
Usage: rq version

Print version information and exit

Flags:
  -h, --help    Show context-sensitive help.
```

## `rq list-formats --help`

```
Usage: rq list-formats

List supported input/output formats and exit

Flags:
  -h, --help    Show context-sensitive help.
```

## `rq list-formats`

```
Input Formats:
	awk
	base64
	csv
	dhall
	dotenv
	hcl
	hjson
	ini
	json
	lines
	ndjson
	raw
	tabular
	toml
	tsv
	xml
	yaml

Output Formats:
	csv
	dotenv
	json
	md-table
	ndjson
	null
	raw
	sh
	template
	toml
	tsv
	xml
	yaml

NOTE: the 'raw' output format is the same as 'json', except syntax highlighting
and pretty printing are disabled, and if the result is a string, it will be
printed without quotes. If the output is a list of primitive types, they will
be printed one per line without quotes. This can be useful when using rq as a
filter for other shell tools.
```

## `rq install-completions --help`

```
Usage: rq query [<query>]

Run a Rego Query

Arguments:
  [<query>]    Rego Query

Flags:
  -h, --help                  Show context-sensitive help.

  -I, --input=STRING          Specify an input data source in the same format
                              as --data. If the path is empty, data is read from
                              standard in. The default is to read from standard
                              in. Options expressed this way take precedence
                              over options provided on the CLI.
  -p, --in-place=STRING       Similar to --input, but also sets --output to the
                              same file, to simplify modifying files in-place.
  -i, --input-format=""       Choose the format the input data should be parsed
                              as. The empty string is treated as 'json'.
  -O, --output=STRING         Specify an output datasources, as with --input.
  -o, --output-format=""      Choose the format the output data should be
                              emitted in. The empty string is treated as 'json'.
      --no-tty-check          Disable checking if the input or output is a TTY.
                              When this flag is asserted, rq will not bail out
                              early when standard in is a TTY, and also won't
                              disable colorization if standard out is not a TTY.
      --no-color              Disable colorizing output in any circumstance.
                              Takes precedence over --force-color.
      --force-color           Where possible, color output, even if the output
                              is not a TTY.
      --ugly                  Disable pretty-printing output.
      --indent="\t"           Override the character(s) used for indentation.
      --style="native"        The Chroma style to use for colorized output, see:
                              https://xyproto.github.io/splash/docs/
  -D, --csv-comma=""          Delimiter to use when parsing CSV input files.
      --csv-comment=""        Comment character to use when parsing CSV input
                              files.
      --csv-skip-lines=0      Number of leading lines to skip when parsing CSV
                              input files.
  -H, --csv-headers           Treat the first row of the CSV file as headers.
      --csv-no-infer          Disable automatic type inference for CSV fields.
      --profile               enable runtime CPU profiling
  -d, --data=DATA             List of files to load into the 'data' package.
                              You can prefix the path with '<format>:' where
                              <format> is one of the formats -i knows about.
                              The file data is loaded into data.<file
                              base name> unless you prefix the path with
                              'some.rego.path='. If you want to specify both,
                              the format goes first. Example: '--data
                              yaml:data.foo.bar=/some/path'.
  -b, --bundle=BUNDLE,...     Paths to bundle files or directories to load into
                              Rego directly. This is equivalent to 'opa eval
                              --bundle/-b'.
  -R, --raw                   Shorthand for -o raw. Takes precedence over -o.
  -s, --save-bundle=STRING    Rather than executing the query, save all data and
                              Rego modules to the specified path, overwriting
                              any file that's already there.
  -t, --template=STRING       Template string to use as output.template. Also
                              implies -o template. The same template functions
                              are available as with the rq.template() builtin.
```
